/**
 * @version $Id: mediaplayergroup.js 29553 2013-09-23 14:09:51Z teetov $
 * ------------------------------------------------------------------------------
 * media player group
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */


(function(window){
	"use strict";

	window.MediaPlayerGroup = MediaPlayerGroup;

	/**
	 *
	 * @constructor
	 */
	function MediaPlayerGroup()
	{
		/**
		 * @type {Boolean}
		 * @private
		 */
		this._isDebug = false;

		/**
		 * @type {Array}
		 * @private
		 */
		this._players = {};

		/**
		 * @type {number}
		 * @private
		 */
		this._syncInterval = 333;

		/**
		 * @type {number}
		 * @private
		 */
		this._syncTimeDifference = 1000;

		this._sync();
	}

	/**
	 * add player to group
	 *
	 * @param {number} obj
	 * @param {MediaPlayer} player
	 */
	MediaPlayerGroup.prototype.add = function(obj, player)
	{
		if (obj && player && !this._players[obj])
		{
			this._players[obj] = {
				player: player,
				timestamp: null
			};

			var self = this;

			this._players[obj].player.subscribe("stop", function(){
				self._players[obj].timestamp = null;
			}, "player");

			this._players[obj].player.subscribe("frame", function(timestamp, width, height){
				self._players[obj].timestamp = timestamp;
			}, "player");
		}
	};

	MediaPlayerGroup.prototype._sync = function()
	{
		var objList = Object.keys(this._players);
		if (objList.length > 0)
		{
			var minObj = Object.keys(this._players)[0];
			var minTime = this._players[minObj].timestamp;

			for (var obj in this._players)
			{
				if (this._players[obj].player.isPlay()
					&& this._players[obj].timestamp
					&& (!minTime || this._players[obj].timestamp < minTime))
				{
					minTime = this._players[obj].timestamp;
					minObj = obj;
				}
			}

			for (var obj in this._players)
			{
				var player = this._players[obj].player;
				if (player.isPlay()
					&& this._players[obj].timestamp
					&& this._players[obj].timestamp - minTime > this._syncTimeDifference)
				{
					player.pause();
				} else
				if (!player.isPlay()
					&& this._players[obj].timestamp
					&& this._players[obj].timestamp - minTime <= this._syncTimeDifference)
				{
					player.play();
				}
			}
		}

		setTimeout(this._sync.bind(this), this._syncInterval);
	};

	/**
	 * add player to group
	 *
	 * @param {number} obj
	 */
	MediaPlayerGroup.prototype.remove = function(obj)
	{
		delete this._players[obj];
	};

	/**
	 * @param {number} time
	 */
	MediaPlayerGroup.prototype.play = function(time)
	{
		for (var obj in this._players)
		{
			this._players[obj].player.play(null, time);
		}
	};

	MediaPlayerGroup.prototype.pause = function()
	{
		for (var obj in this._players)
		{
			this._players[obj].player.pause();
		}
	};

	MediaPlayerGroup.prototype.stop = function()
	{
		for (var obj in this._players)
		{
			this._players[obj].player.stop();
		}
	};

	/**
	 *
	 * @param {number} time
	 */
	MediaPlayerGroup.prototype.moveAbsolute = function(time)
	{
		for (var obj in this._players)
		{
			this._players[obj].player.moveAbsolute(time);
		}
	};

	/**
	 *
	 * @param {String} message
	 */
	MediaPlayerGroup.prototype.printErrorMessage = function(message)
	{
		for (var obj in this._players)
		{
			this._players[obj].player.printErrorMessage(message);
		}
	};

})(window);
