/*!
 * jQuery Tools v1.2.6 - The missing UI library for the Web
 * overlay/overlay.js
 * tabs/tabs.js
 */
(function(a){a.tools=a.tools||{version:"v1.2.6"},a.tools.overlay={addEffect:function(a,b,d){c[a]=[b,d]},conf:{close:null,closeOnClick:!0,closeOnEsc:!0,closeSpeed:"fast",effect:"default",fixed:!a.browser.msie||a.browser.version>6,left:"center",load:!1,mask:null,oneInstance:!0,speed:"normal",target:null,top:"10%"}};var b=[],c={};a.tools.overlay.addEffect("default",function(b,c){var d=this.getConf(),e=a(window);d.fixed||(b.top+=e.scrollTop(),b.left+=e.scrollLeft()),b.position=d.fixed?"fixed":"absolute",this.getOverlay().css(b).fadeIn(d.speed,c)},function(a){this.getOverlay().fadeOut(this.getConf().closeSpeed,a)});function d(d,e){var f=this,g=d.add(f),h=a(window),i,j,k,l=a.tools.expose&&(e.mask||e.expose),m=Math.random().toString().slice(10);l&&(typeof l=="string"&&(l={color:l}),l.closeOnClick=l.closeOnEsc=!1);var n=e.target||d.attr("rel");j=n?a(n):null||d;if(!j.length)throw"Could not find Overlay: "+n;d&&d.index(j)==-1&&d.click(function(a){f.load(a);return a.preventDefault()}),a.extend(f,{load:function(d){if(f.isOpened())return f;var i=c[e.effect];if(!i)throw"Overlay: cannot find effect : \""+e.effect+"\"";e.oneInstance&&a.each(b,function(){this.close(d)}),d=d||a.Event(),d.type="onBeforeLoad",g.trigger(d);if(d.isDefaultPrevented())return f;k=!0,l&&a(j).expose(l);var n=e.top,o=e.left,p=j.outerWidth({margin:!0}),q=j.outerHeight({margin:!0});typeof n=="string"&&(n=n=="center"?Math.max((h.height()-q)/2,0):parseInt(n,10)/100*h.height()),o=="center"&&(o=Math.max((h.width()-p)/2,0)),i[0].call(f,{top:n,left:o},function(){k&&(d.type="onLoad",g.trigger(d))}),l&&e.closeOnClick&&a.mask.getMask().one("click",f.close),e.closeOnClick&&a(document).bind("click."+m,function(b){a(b.target).parents(j).length||f.close(b)}),e.closeOnEsc&&a(document).bind("keydown."+m,function(a){a.keyCode==27&&f.close(a)});return f},close:function(b){if(!f.isOpened())return f;b=b||a.Event(),b.type="onBeforeClose",g.trigger(b);if(!b.isDefaultPrevented()){k=!1,c[e.effect][1].call(f,function(){b.type="onClose",g.trigger(b)}),a(document).unbind("click."+m).unbind("keydown."+m),l&&a.mask.close();return f}},getOverlay:function(){return j},getTrigger:function(){return d},getClosers:function(){return i},isOpened:function(){return k},getConf:function(){return e}}),a.each("onBeforeLoad,onStart,onLoad,onBeforeClose,onClose".split(","),function(b,c){a.isFunction(e[c])&&a(f).bind(c,e[c]),f[c]=function(b){b&&a(f).bind(c,b);return f}}),i=j.find(e.close||".close"),!i.length&&!e.close&&(i=a("<a class=\"close\"></a>"),j.prepend(i)),i.click(function(a){f.close(a)}),e.load&&f.load()}a.fn.overlay=function(c){var e=this.data("overlay");if(e)return e;a.isFunction(c)&&(c={onBeforeLoad:c}),c=a.extend(!0,{},a.tools.overlay.conf,c),this.each(function(){e=new d(a(this),c),b.push(e),a(this).data("overlay",e)});return c.api?e:this}})(jQuery);
(function(a){a.tools=a.tools||{version:"v1.2.6"},a.tools.tabs={conf:{tabs:"a",current:"current",onBeforeClick:null,onClick:null,effect:"default",initialIndex:0,event:"click",rotate:!1,slideUpSpeed:400,slideDownSpeed:400,history:!1},addEffect:function(a,c){b[a]=c}};var b={"default":function(a,b){this.getPanes().hide().eq(a).show(),b.call()},fade:function(a,b){var c=this.getConf(),d=c.fadeOutSpeed,e=this.getPanes();d?e.fadeOut(d):e.hide(),e.eq(a).fadeIn(c.fadeInSpeed,b)},slide:function(a,b){var c=this.getConf();this.getPanes().slideUp(c.slideUpSpeed),this.getPanes().eq(a).slideDown(c.slideDownSpeed,b)},ajax:function(a,b){this.getPanes().eq(0).load(this.getTabs().eq(a).attr("href"),b)}},c,d;a.tools.tabs.addEffect("horizontal",function(b,e){if(!c){var f=this.getPanes().eq(b),g=this.getCurrentPane();d||(d=this.getPanes().eq(0).width()),c=!0,f.show(),g.animate({width:0},{step:function(a){f.css("width",d-a)},complete:function(){a(this).hide(),e.call(),c=!1}}),g.length||(e.call(),c=!1)}});function e(c,d,e){var f=this,g=c.add(this),h=c.find(e.tabs),i=d.jquery?d:c.children(d),j;h.length||(h=c.children()),i.length||(i=c.parent().find(d)),i.length||(i=a(d)),a.extend(this,{click:function(c,d){var i=h.eq(c);typeof c=="string"&&c.replace("#","")&&(i=h.filter("[href*="+c.replace("#","")+"]"),c=Math.max(h.index(i),0));if(e.rotate){var k=h.length-1;if(c<0)return f.click(k,d);if(c>k)return f.click(0,d)}if(!i.length){if(j>=0)return f;c=e.initialIndex,i=h.eq(c)}if(c===j)return f;d=d||a.Event(),d.type="onBeforeClick",g.trigger(d,[c]);if(!d.isDefaultPrevented()){b[e.effect].call(f,c,function(){j=c,d.type="onClick",g.trigger(d,[c])}),h.removeClass(e.current),i.addClass(e.current);return f}},getConf:function(){return e},getTabs:function(){return h},getPanes:function(){return i},getCurrentPane:function(){return i.eq(j)},getCurrentTab:function(){return h.eq(j)},getIndex:function(){return j},next:function(){return f.click(j+1)},prev:function(){return f.click(j-1)},destroy:function(){h.unbind(e.event).removeClass(e.current),i.find("a[href^=#]").unbind("click.T");return f}}),a.each("onBeforeClick,onClick".split(","),function(b,c){a.isFunction(e[c])&&a(f).bind(c,e[c]),f[c]=function(b){b&&a(f).bind(c,b);return f}}),e.history&&a.fn.history&&(a.tools.history.init(h),e.event="history"),h.each(function(b){a(this).bind(e.event,function(a){f.click(b,a);return a.preventDefault()})}),i.find("a[href^=#]").bind("click.T",function(b){f.click(a(this).attr("href"),b)}),location.hash&&e.tabs=="a"&&c.find("[href="+location.hash+"]").length?f.click(location.hash):(e.initialIndex===0||e.initialIndex>0)&&f.click(e.initialIndex)}a.fn.tabs=function(b,c){var d=this.data("tabs");d&&(d.destroy(),this.removeData("tabs")),a.isFunction(c)&&(c={onBeforeClick:c}),c=a.extend({},a.tools.tabs.conf,c),this.each(function(){d=new e(a(this),b,c),a(this).data("tabs",d)});return c.api?d:this}})(jQuery);

/* jQuery Tools 1.2.6 Rangeinput - HTML5 <input type="range" /> for humans */
(function($) {

	$.tools = $.tools || {version: '1.2.6'};

	var tool;

	tool = $.tools.rangeinput = {

		conf: {
			min: 0,
			max: 100,		// as defined in the standard
			step: 'any', 	// granularity of the value. a non-zero float or int (or "any")
			steps: 0,
			value: 0,
			precision: undefined,
			vertical: 0,
			keyboard: false,
			progress: false,
			speed: 100,
			floatrange: false,

			// set to null if not needed
			css: {
				input:		'range',
				slider: 		'slider',
				progress: 	'progress',
				handle: 		'handle'
			}

		}
	};

//{{{ fn.drag

	/*
	 FULL featured drag and drop. 0.7 kb minified, 0.3 gzipped. done.
	 Who told d'n'd is rocket science? Usage:

	 $(".myelement").drag({y: false}).bind("drag", function(event, x, y) {
	 // do your custom thing
	 });

	 Configuration:
	 x: true, 		// enable horizontal drag
	 y: true, 		// enable vertical drag
	 drag: true 		// true = perform drag, false = only fire events

	 Events: dragStart, drag, dragEnd.
	 */
	var doc, draggable;

	$.fn.xdrag = function(conf) {

		// disable IE specialities
		document.ondragstart = function () { return false; };

		conf = $.extend({x: true, y: true, drag: true}, conf);

		doc = doc || $(document).bind("mousedown mouseup", function(e) {

			var el = $(e.target);

			// start
			if (e.type == "mousedown" && el.data("xdrag")) {

				var offset = el.position(),
					x0 = e.pageX - offset.left,
					y0 = e.pageY - offset.top,
					start = true;

				doc.bind("mousemove.xdrag", function(e) {
					var x = e.pageX -x0,
						y = e.pageY -y0,
						props = {};

					if (conf.x) { props.left = x; }
					if (conf.y) { props.top = y; }

					if (start) {
						el.trigger("xdragStart");
						start = false;
					}
					if (conf.drag) { el.css(props); }
					el.trigger("xdrag", [y, x]);
					draggable = el;
				});

				e.preventDefault();

			} else {

				try {
					if (draggable) {
						draggable.trigger("xdragEnd");
					}
				} finally {
					doc.unbind("mousemove.xdrag");
					draggable = null;
				}
			}

		});

		return this.data("xdrag", true);
	};

//}}}



	function round(value, precision) {
		var n = Math.pow(10, precision);
		return Math.round(value * n) / n;
	}

	// get hidden element's width or height even though it's hidden
	function dim(el, key) {
		var v = parseInt(el.css(key), 10);
		if (v) { return v; }
		var s = el[0].currentStyle;
		return s && s.width && parseInt(s.width, 10);
	}

	function hasEvent(el) {
		var e = el.data("events");
		return e && e.onSlide;
	}

	function RangeInput(input, conf) {

		// private variables
		var self = this,
			css = conf.css,
			root = $("<div><div/><a href='#'/></div>").data("rangeinput", self),
			vertical,
			value,			// current value
			origo,			// handle's start point
			len,				// length of the range
			pos;				// current position of the handle

		// create range
		input.before(root);

		var handle = root.addClass(css.slider).find("a").addClass(css.handle),
			progress = root.find("div").addClass(css.progress);

		// get (HTML5) attributes into configuration
		$.each("min,max,step,value,floatrange".split(","), function(i, key) {
			var val = input.attr(key);
			if (parseFloat(val)) {
				conf[key] = parseFloat(val, 10);
			}
		});

		if(conf.floatrange){
			conf.max = Math.max(conf.max, conf.value);
			conf.min = Math.min(conf.min, conf.value);
		}

		var range = conf.max - conf.min,
			step = conf.step == 'any' ? 0 : conf.step,
			precision = conf.precision;

		if (precision === undefined) {
			try {
				precision = step.toString().split(".")[1].length;
			} catch (err) {
				precision = 0;
			}
		}

		// Replace built-in range input (type attribute cannot be changed)
		if (input.attr("type") == 'range') {
			var def = input.clone().wrap("<div/>").parent().html(),
				clone = $(def.replace(/type/i, "type=text data-orig-type"));

			clone.val(conf.value);
			input.replaceWith(clone);
			input = clone;
		}

		input.addClass(css.input);

		var fire = $(self).add(input), fireOnSlide = true;


		/**
		 The flesh and bone of this tool. All sliding is routed trough this.

		 @param evt types include: click, keydown, blur and api (setValue call)
		 @param isSetValue when called trough setValue() call (keydown, blur, api)

		 vertical configuration gives additional complexity.
		 */
		function slide(evt, x, val, isSetValue) {

			// calculate value based on slide position
			if (val === undefined) {
				val = x / len * range;

				// x is calculated based on val. we need to strip off min during calculation
			} else if (isSetValue) {
					if(conf.floatrange){
						conf.min = Math.min(val,conf.min);
						conf.max = Math.max(val,conf.max);
						range = conf.max - conf.min;
					}
					val -= conf.min;
			}

			// increment in steps
			if (step) {
				val = Math.round(val / step) * step;
			}

			// count x based on value or tweak x if stepping is done
			if (x === undefined || step) {
				x = val * len / range;
			}

			// crazy value?
			if (isNaN(val)) { return self; }

			// stay within range

			x = Math.max(0, Math.min(x, len));
			val = x / len * range;

			if (isSetValue || !vertical) {
				val += conf.min;
			}

			// in vertical ranges value rises upwards
			if (vertical) {
				if (isSetValue) {
					x = len -x;
				} else {
					val = conf.max - val;
				}
			}

			// precision
			val = round(val, precision);

			// onSlide
			var isClick = evt.type == "click";
			if (fireOnSlide && value !== undefined && !isClick) {
				evt.type = "onSlide";
				fire.trigger(evt, [val, x]);
				if (evt.isDefaultPrevented()) { return self; }
			}

			// speed & callback
			var speed = isClick ? conf.speed : 0,
				callback = isClick ? function()  {
					evt.type = "change";
					fire.trigger(evt, [val]);
				} : null;

			if (vertical) {
				handle.animate({top: x}, speed, callback);
				if (conf.progress) {
					progress.animate({height: len - x + handle.height() / 2}, speed);
				}

			} else {
				handle.animate({left: x}, speed, callback);
				if (conf.progress) {
					progress.animate({width: x + handle.width() / 2}, speed);
				}
			}

			// store current value
			value = val;
			pos = x;

			// se input field's value
			input.val(val);

			return self;
		}


		$.extend(self, {

			getValue: function() {
				return value;
			},

			setValue: function(val, e) {
				init();
				return slide(e || $.Event("api"), undefined, val, true);
			},

			getConf: function() {
				return conf;
			},

			getProgress: function() {
				return progress;
			},

			getHandle: function() {
				return handle;
			},

			getInput: function() {
				return input;
			},

			step: function(am, e) {
				e = e || $.Event();
				var step = conf.step == 'any' ? 1 : conf.step;
				self.setValue(value + step * (am || 1), e);
			},

			// HTML5 compatible name
			stepUp: function(am) {
				return self.step(am || 1);
			},

			// HTML5 compatible name
			stepDown: function(am) {
				return self.step(-am || -1);
			}

		});

		// callbacks
		$.each("onSlide,change".split(","), function(i, name) {

			// from configuration
			if ($.isFunction(conf[name]))  {
				$(self).bind(name, conf[name]);
			}

			// API methods
			self[name] = function(fn) {
				if (fn) { $(self).bind(name, fn); }
				return self;
			};
		});


		// dragging
		handle.xdrag({drag: false}).bind("xdragStart", function() {

			/* do some pre- calculations for seek() function. improves performance */
			init();

			input.data('isDragged', true);
			// avoid redundant event triggering (= heavy stuff)
			fireOnSlide = true; // hasEvent($(self)) || hasEvent(input);


		}).bind("xdrag", function(e, y, x) {

				if (input.is(":disabled")) { return false; }
				slide(e, vertical ? y : x);

			}).bind("xdragEnd", function(e) {
			input.data('isDragged', false);
				if (!e.isDefaultPrevented()) {
					e.type = "change";
					fire.trigger(e, [value]);
				}

			}).click(function(e) {
				return e.preventDefault();
			});

		// clicking
		root.click(function(e) {
			if (input.is(":disabled") || e.target == handle[0]) {
				return e.preventDefault();
			}
			init();
			var fix = vertical ? handle.height() / 2 : handle.width() / 2;
			slide(e, vertical ? len-origo-fix + e.pageY  : e.pageX -origo -fix);
		});

		if (conf.keyboard) {

			input.keydown(function(e) {

				if (input.attr("readonly")) { return; }

				var key = e.keyCode,
					up = $([75, 76, 38, 33, 39]).index(key) != -1,
					down = $([74, 72, 40, 34, 37]).index(key) != -1;

				if ((up || down) && !(e.shiftKey || e.altKey || e.ctrlKey)) {

					// UP: 	k=75, l=76, up=38, pageup=33, right=39
					if (up) {
						self.step(key == 33 ? 10 : 1, e);

						// DOWN:	j=74, h=72, down=40, pagedown=34, left=37
					} else if (down) {
						self.step(key == 34 ? -10 : -1, e);
					}
					return e.preventDefault();
				}
			});
		}


		input.blur(function(e) {
			/* Check incorrect values in input field */
			var val = $(this).val() * 1;
			if (!val)
				val = 0;
			var conf = self.getConf();
			if (val < conf.min)
				if(conf.floatrange)
					conf.min = val;
				else val = conf.min;
			if (val > conf.max)
				if(conf.floatrange)
					conf.max = val;
				else val = conf.max;
			range = conf.max - conf.min;
			self.setValue(val, e);

			$(this).change();
		});


		// HTML5 DOM methods
		$.extend(input[0], { stepUp: self.stepUp, stepDown: self.stepDown});


		// calculate all dimension related stuff
		function init() {
			vertical = conf.vertical || dim(root, "height") > dim(root, "width");

			if (vertical) {
				len = dim(root, "height") - dim(handle, "height");
				origo = root.offset().top + len;

			} else {
				len = dim(root, "width") - dim(handle, "width");
				origo = root.offset().left;
			}
		}

		function begin() {
			init();
			self.setValue(conf.value !== undefined ? conf.value : conf.min);
		}
		begin();

		// some browsers cannot get dimensions upon initialization
		if (!len) {
			$(window).load(begin);
		}
	}

	$.expr[':'].range = function(el) {
		var type = el.getAttribute("type");
		return type && type == 'range' || !!$(el).filter("input").data("rangeinput");
	};


	// jQuery plugin implementation
	$.fn.rangeinput = function(conf) {

		// already installed
		if (this.data("rangeinput")) { return this; }

		// extend configuration with globals
		conf = $.extend(true, {}, tool.conf, conf);

		var els;

		this.each(function() {
			var el = new RangeInput($(this), $.extend(true, {}, conf));
			var input = el.getInput().data("rangeinput", el);
			els = els ? els.add(input) : input;
		});

		return els ? els : this;
	};

}) (jQuery);

(function($) {
	$.convertFn.range = function(value, source, target) {
		if ($(target).data("rangeinput"))
			$(target).data("rangeinput").setValue(value);
	};
}) (jQuery);
