/**
 * @version $Id: jquery.mask.js 30481 2014-04-14 15:31:05Z astarostin $
 * ------------------------------------------------------------------------------
 * Jquery masking plugin
 * Present functions for mask, unmask blocks
 * ------------------------------------------------------------------------------
 * @author Sergey Tsybulsky
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 * Example:
 * Mask block
 * $("#block").mask();
 * Unmask block
 * $("#block").unmask();
 *
 */
(function (factory) {
if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module depending on jQuery.
    define(['jquery', 'i18n'], factory);
} else {
    // No AMD. Register plugin with global jQuery object.
    factory(jQuery);
}
}(function ($) {
	var __ = window.__ || function(msg){return msg;};

	var styles = {
		light: {
			wrapper: "loading_light_wrapper",
			indicator: "loading_light"
		},
		dark: {
			wrapper: "loading_dark_wrapper",
			indicator: "loading_dark"
		}
	};
	var defaultSettings = {
		style: 'light',
		text: __("Loading")
	};

	$.fn.mask = function(options)
	{
		var settings = $.extend(defaultSettings, options);

		return this.each(function(){
			if (styles[settings.style])
			{
				var element = $(this);
				element.before('<div class="' + styles[settings.style].wrapper + '" style="z-index: 1000; top: ' + element.offset().top + 'px; left: ' + element.offset().left + 'px; width: ' + element.outerWidth() + 'px; height: ' + element.outerHeight() + 'px;"><div class="' + styles[settings.style].indicator + '">' + settings.text + '</div></div>');
				element.data("style", settings.style);
			}
		});
	};

	$.fn.unmask = function()
	{
		return this.each(function(){
			var style = $(this).data("style");

			if (styles[style])
			{
				$(this).parent().find("." + styles[style].wrapper).remove();
			}
		});
	};
}));
