/**
 * @version $Id: editor.js 33426 2015-12-15 13:34:56Z sabaev $
 * ------------------------------------------------------------------------------
 * Class for create object editor
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 * Example:
 * Create editor for camera with obj 101 and append it to body
 * var editor = new Editor({
 *  obj: 101,
 *  id: "body",
 *  type: "camera"
 * });
 * editor.init();
 *
 */
define("editor", ["jquery", "log", "api", "hwj", "jquery.mask", "i18n", "audit_lib", "mediaplayer", "jquery-ui", "jquery.jaoselect"], function (){
	"use strict";

	function Editor(params)
	{
		var type = params.type || null;
		var model = params.model || "";
		var obj = params.obj || "";
		var objList = params.objList || null;
		var setid = params.setid || null;
		var nodeid = params.nodeid || null;
		var id = params.id || null;
		var aditionalAttributes = params.attributes || {};
		var isMassObjectEditor = params.isMassObjectEditor || false;
		var notReload = params.notReload || false;
		var formName = params.name || '';
		var backname = params.backname || '';
		var backhref = params.backhref || '';
		var backpath = params.backpath || null;

		var api = new API();

		// player size
		var livePlayerWidth = 273;
		var livePlayerHeight = 205;

		var self = this;

		var objectTemplate = {};
		var deletedObjects = {};
		var selectedObjects = {};

		var textfield_and_regexp_list_for_check = {};
		var textfield_for_camera_exists_check = {};
		var textfield_and_js_list_for_check = {};

		/**
		 * @type {{}|null}
		 */
		var objectTypes = null;

		// use only buttons object for accesing buttons selector
		this.buttons = {
			remove: {
				show: true,
				id: "#deleteObject",
				label: __("Delete"),
				event: function(){}
			},
			reload: {
				show: true,
				id: "#reloadObject",
				label: __("Reload"),
				event: function(){}
			},
			cancel: {
				show: true,
				id: "#cancelObject",
				label: __("Cancel"),
				event: function(){}
			},
			save: {
				show: true,
				id: "#saveObject",
				label: __("Apply"),
				event: function(){}
			},
			back: {
				show: true,
				id: "#backObject",
				label: __("Back"),
				event: function(){}
			}
		};

		this.setButtons = function(buttons)
		{
			if (buttons)
			{
				for (var button in buttons)
				{
					if (this.buttons[button] && buttons[button].show !== null)
					{
						this.buttons[button].show = buttons[button].show;
					}
				}
			}
		};

		this.init = function()
		{
			if (!id)
				return;

			if (!obj && !type && !setid)
				return;

			// can be only one editor on screen for now
			this.destroy();

			if (!isMassObjectEditor)
			{
				window.Validate = window.Validate || {};
				window.Validate.isMassObjectEditor = false;

				remove_css("/sdi/global/editor_spreadsheet.css");

				if (obj && type)
				{
					aditionalAttributes = {}; // not empty, if obj is not defined
				} else
				if (type && setid)
				{
					//
				}
			} else
			if (isMassObjectEditor)
			{
				window.Validate = window.Validate || {};
				window.Validate.isMassObjectEditor = true;

				require_css("/sdi/global/editor_spreadsheet.css");

				if (setid)
				{
				} else
				if (type && setid)
				{
					//
				}
			}

			createContainer()
				.done(function(){
					init();
					addEvents();
				});
		};

		this.destroy = function()
		{
			if (window.HWJoystick)
			{
				HWJoystick.setObj(null);
			}
			$(".editor_container").remove();
		};

		this.onSave = function(obj, success)
		{

		};

		this.onDelete = function(obj, success)
		{

		};

		this.onLoad = function(obj)
		{

		};

		this.onReload = function(obj)
		{

		};

		this.onCancel = function(obj)
		{

		};

		this.onBack = function(obj)
		{

		};

		this.getObjectTemplate = function()
		{
			return objectTemplate;
		};

		this.getType = function()
		{
			if (!isMassObjectEditor)
			{
				return type;
			}else{
				return false;
			}
		};

		/**
		 *
		 * @param {Object} params
		 * @returns {Deferred}
		 */
		function getObjectNameList(params)
		{
			var deferred = $.Deferred();

			var id = params.id || null;
			var objList = params.objList || null;
			var type = params.type || null;
			var parameters = {};
			if (type)
			{
				parameters.type = type;
				if (type == 'node') parameters.withAttributes = true;
			}
			if (objList)
			{
				parameters.objList = JSON.stringify(objList);
			}
			if (!id)
			{
				deferred.reject();
				return deferred.promise();
			}

			var api = new API();
			api.getObjectList(parameters)
				.fail(function(code, message){
					Log.error(message);
					deferred.reject(message);
				})
				.done(function(response){
					var objectList = response.list;
					var objParamList = {};
					// get children
					if (objectList.length > 0)
					{
						for (var num = 0; num < objectList.length; num++)
						{
							var obj = objectList[num]["obj"];
							objParamList[obj] = {};
							objParamList[obj]['name'] = objectList[num]["name"];
							if (objectList[num]["udid"])
								objParamList[obj]['udid'] = objectList[num]["udid"];
							else objParamList[obj]['udid'] = '';
							if (type) {
								objParamList[obj]['type'] = type;
								objParamList[obj]['template'] = type;
								objParamList[obj]['fullname'] = objParamList[obj]['type'] + " [" + objParamList[obj]["udid"] + "]: " + objParamList[obj]["name"];
								if (type == 'set'){
									if (obj < 99)
										objParamList[obj]['fullname'] = __("System Sets") + ": " + objParamList[obj]['name'];
									else
										objParamList[obj]['fullname'] = __("User Sets") + ": " + objParamList[obj]['name'];
								}
								if (type == 'node'){
									objParamList[obj]['fullname'] = __("Node") + ": " + objectList[num]['attributes']['HOST'];
								}
							} else {
								var otype = objectList[num]["otype"];
								var subtype = objectList[num]["subtype"];
								objParamList[obj]['type'] = objectTypes[otype][subtype]["name"];
								objParamList[obj]['template'] = objectTypes[otype][subtype]["template"];
								objParamList[obj]['location'] = objectList[num]["location"];
								objParamList[obj]['fullname'] = objParamList[obj]['type'] + " [" + objParamList[obj]["udid"] + "]: " + objParamList[obj]["name"];
							}
						}
					}

					if (type)
					{
						deferred.resolve(objParamList);
					} else {
						$.when(
							getObjectNameList({id: "#list .tabs_content", type: 'set'}),
							getObjectNameList({id: "#list .tabs_content", type: 'node'})
						)
							.done(function(objParamListSet, objParamListNode){
								var objid;
								for (objid in objParamListSet)
								{
									objParamList[objid] = objParamListSet[objid];
								}
								for (objid in objParamListNode)
								{
									objParamList[objid] = objParamListNode[objid];
								}

								deferred.resolve(objParamList);
							});
					}
				});

			return deferred.promise();
		}

		/**
		 *
		 * @returns {Deferred}
		 */
		function createContainer()
		{
			var deferred = $.Deferred();

			var backnameHtml = '';
			if (!backpath)
			{
				createContainerWithPath('');

				deferred.resolve();
			} else {
				var objList = [];
				for (var i = 0; i < backpath.length - 1; i++) {
					var objStruct = backpath[i].split('_');
					objList[i] = objStruct[1];
				}

				var call = function()
				{
					getObjectNameList({
						id: "#list .tabs_content",
						objList: objList
					})
						.done(function (objParamList)
						{
							var backpathdevice = '';
							for (var i = 0; i < backpath.length - 1; i ++)
							{
								if (backpathdevice == '')
								{
									backpathdevice += '#' + backpath[i];
								} else
								{
									backpathdevice += '/' + backpath[i];
								}
								var objStruct = backpath[i].split('_');
								var objID = objStruct[2];
								var fullname = backpath[i];
								if (objParamList[objID])
								{
									fullname = objParamList[objID]['fullname'];
								}
								// get obj info from obj= ID from backpath[i]
								backnameHtml += '<a href=' + backpathdevice + ' style="text-decoration:underline">' + fullname + '</a> > ';
							}

							createContainerWithPath(backnameHtml);

							deferred.resolve();
						});
				};

				if (objectTypes == null)
				{
					var api = new API();
					api.getTypes()
						.done(function(response){
							objectTypes = response["types"];
							call();
						});
				} else {
					call();
				}
			}

			return deferred.promise();
		}

		function createContainerWithPath(backnameHtml)
		{
			backnameHtml = backnameHtml || '';
			var formNameHtml = '';
			if (formName || backname) {
				formNameHtml = '<div class="tabs_menu_header">' + backnameHtml + formName + '</div>';
			}
			var container =
			'<div class="editor_container editor_container_' + readCookie("language") + '">'
				+ '<div id="tabs" class="tabs">' + formNameHtml
					+ '<div id="tabs_menu" class="tabs_menu">'
						+ '<div class="current_tab" id="current_tab">'
							+ '<div class="tab_text"><a href="#">' + __("General") + '</a></div>'
						+ '</div>'
						+ '<!--<div class="tab_inactive">'
							+ '<div class="tab_text"><a href="#">Image</a></div>'
						+ '</div>'
						+ '<div class="tab_inactive">'
							+ '<div class="tab_text"><a href="#">Image</a></div>'
						+ '</div>'
						+ '<div class="tab_inactive">'
							+ '<div class="tab_text"><a href="#">Source</a></div>'
						+ '</div>-->'
					+ '</div>'
					+ '<div class="tabs_content">'
						+ '<div id="tabs_content" class="tabs_form">'
						+ '</div>'
						+ '<div class="tabs_manage_buttons_wrapper">'
							+ '<div class="tabs_manage_buttons">'
								+ '<div style="width: 20%; float: left; text-align: right;"><input type="button" id="backObject" value="' + __('Back') + '"/></div>'
								+ '<div style="width: 20%; float: left; text-align: right;"><input type="button" id="deleteObject" value="' + __('Delete') + '"/></div>'
								+ '<div style="width: 20%; float: left; text-align: right;"><input type="button" id="reloadObject" value="' + __('Reload') + '"/></div>'
								+ '<div style="width: 20%; float: left; text-align: right;"><input type="button" id="cancelObject" value="' + __('Cancel') + '" disabled="true"/></div>'
								+ '<div style="width: 20%; float: left;"><input type="button" id="saveObject" value="' + __('Apply') + '" disabled="true"/></div>'
							+ '</div>'
						+ '</div>'
					+ '</div>'
					+ '<div class="tabs_footer"></div>'
				+ '</div>'
			+ '</div>';

			$(id + " .editor_container").remove();
			$(id).append(container);
		}

		function init(notReload)
		{
			notReload = notReload || false;

			objectTemplate = {};
			deletedObjects = {};
			selectedObjects = {};

			textfield_and_regexp_list_for_check = {};
			textfield_for_camera_exists_check = {};
			textfield_and_js_list_for_check = {};

			if (notReload)
				return;

			// hide/show buttons
			for (var button in self.buttons)
			{
				if (!self.buttons[button].show)
				{
					$(self.buttons[button].id).hide();
				}
				$(self.buttons[button].id).val(self.buttons[button].label);
			}

			if (type !== "camera")
			{
				$("#tabs_content").width("100%");
			}

			if (type == "camera")
			{
				if ($("#camera").length == 0)
				{
					$("#tabs .tabs_content").prepend(
						'<div id="camera">'
							+'<div class="camera_image">'
								+'<div class="status"><img src="img/camera_status_ok.png" width="10" height="10"/></div>'
								+'<div class="video" id="playerVideoImage">'
									+'<img id="videoPlay" src="img/camera_image_play.png" width="273" height="205"/>'
								+'</div>'
								+'<div class="videoControl">'
									+'<div class="play"><img src="img/camera_play.png" width="22" height="22"/></div>'
									+'<div class="pause"><img src="img/camera_pause.png" width="22" height="22"/></div>'
								+'</div>'
							+'</div>'
						+'</div>'
					);
				}
			}

			if (isMassObjectEditor)
			{
				fillAllCameraAttributes();
			} else {
				fillObjectAttributes(obj, function(){
					fillCameraPlayerAttributes();

					// check credentials for editor
					if(type !== "user" && type !== "role" && type !== "set"){
						checkCredentials(obj);
					}
				});
			}
		}

		function addEvents()
		{
			$(document).keydown(function(event){
				if (event.keyCode == 13
					&& $("#wizard:visible").length)
				{
					if ($(event.target).attr("id") !== "next")
						$("#next").trigger("click");
				}
			});

			$("#tabs_content").keydown(function(event){
				if (event.keyCode == 13)
				{
					if (!isMassObjectEditor &&
						!$(self.buttons.save.id).prop("disabled"))
					{
						$(self.buttons.save.id).trigger("click");
					}
				}
			});

			$(self.buttons.remove.id).click(function(){
				if (obj)
				{
					var name = type == 'node' ? $("#NODENAME_" + obj).val() : $("#NAME_" + obj).val();
					if(confirm(__("Are you sure you want to delete ") + type + " '" + name + "' ?"))
					{
						deleteObject(
							obj,
							function(obj, success)
							{
								if (success && $.isFunction(self.onDelete))
								{
									self.onDelete(obj, success);
								}
							}
						);
					}
				}
			});
		}

		function fillObjectAttributes(object_id, callback)
		{
			/*if (!object_id || object_id <= 0)
				return;*/

			self.deactivateTabsManageButtons();

			$("#tabs").mask();

			var params = {
				attributes: JSON.stringify(aditionalAttributes),
				type: type
			};
			if (object_id)
			{
				params.objList = JSON.stringify([object_id])
			}

			api.getTemplates(params)
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				if (response.template && response.template[object_id])
				{
					if (response.template[object_id].attributes.CAMERAMODEL)
					{
						model = response.template[object_id].attributes.CAMERAMODEL.VALUE;
					}

					// load validate functions
					require(
						["/sdi/admin/js/" + type + "/" + model + "/validate.js"],
						function ()
						{
							objectTemplate = response.template;
							createObjectAttributes(object_id, objectTemplate, "tabs_content", isMassObjectEditor);
							createObjectTabs(objectTemplate[object_id]);

							// atach event handlers for controls
							$(self.buttons.save.id).unbind("click").click(function(){
								onSaveObjectClick(function(object, success){
									if ($.isFunction(self.onSave))
									{
										self.onSave(object, success);
									}
								});
							});
							$(self.buttons.cancel.id).unbind("click").click(function(){
								onCancelObjectClick();
								if ($.isFunction(self.onCancel))
								{
									self.onCancel();
								}
							});
							$(self.buttons.reload.id).unbind("click").click(function(){
								onReloadObjectClick();
								if ($.isFunction(self.onReload))
								{
									self.onReload();
								}
							});
							$(self.buttons.back.id).unbind("click").click(function(){
								onBackObjectClick();
								if ($.isFunction(self.onBack))
								{
									self.onBack();
								}
							});

							if ($.isFunction(callback))
							{
								callback();
							}

							if ($.isFunction(self.onLoad))
							{
								self.onLoad();
							}

							$("#tabs").unmask();
						}
					);
				}
			});
		}

		/**
		 * activate editor buttons
		 */
		this.activateTabsManageButtons = function()
		{
			var activate = true;
			if (!isMassObjectEditor)
			{
				activate = false;
				var attributes = getAttributes(obj, true);
				if (!$.isEmptyObject(attributes))
				{
					activate = true;
				}
			}

			if (activate)
			{
				$(self.buttons.save.id).prop("disabled", false);
				$(self.buttons.cancel.id).prop("disabled", false);
				$(self.buttons.reload.id).prop("disabled", true);
			}

			// only in many camera editor
			$("#saveAllChanges").prop("disabled", false);
		};

		/**
		 * deactivate editor buttons
		 */
		this.deactivateTabsManageButtons = function()
		{
			var activate = true;
			if (!isMassObjectEditor)
			{
				activate = false;
				var attributes = getAttributes(obj, true);
				if (!$.isEmptyObject(attributes))
				{
					activate = true;
				}
			}

			if (!activate)
			{
				$(self.buttons.save.id).prop("disabled", true);
				$(self.buttons.cancel.id).prop("disabled", true);
				$(self.buttons.reload.id).prop("disabled", false);
			}

			// only in many camera editor
			$("#saveAllChanges").prop("disabled", true);
		};

		function onSaveObjectClick(callback)
		{
			$(self.buttons.save.id).prop("disabled", true);

			var validateResult = validateAttributes();
			if (validateResult.error)
			{
				alert(__("Next attributes are incorrect:") +'\n' + validateResult.error_attributes);
				$(self.buttons.save.id).prop("disabled", false);
				return false;
			}

			var cameraListForCheck = getCameraListForCheck();
			var cameraListWithAttributesForSaving = [];
			var obj;

			for (obj in objectTemplate)
			{
				// this camera was deleted or need check model
				if (deletedObjects[obj]
					|| cameraListForCheck[obj])
				{
					continue;
				}

				var attributes = getAttributes(obj, true);
				// we need to save only objects with changed values
				if ($.isEmptyObject(attributes))
				{
					continue;
				}

				cameraListWithAttributesForSaving.push({
					obj: obj,
					attributes: attributes
				});
			}

			// save list of objects
			var saveObjects = function(i, objList, callback)
			{
				if (i !== objList.length)
				{
					saveObjectAttributes(objList[i].obj, objList[i].attributes, false, function(obj, success){
						if ($.isFunction(callback))
							callback(obj, success);

						saveObjects(++i, objList, callback);
					});
				}
			};

			if (isMassObjectEditor && (cameraListWithAttributesForSaving.length > 0 || !$.isEmptyObject(cameraListForCheck)))
			{
				$(id).mask({text: __("Saving")});
			}

			// first, we save cameras which no needs checking model
			saveObjects(0, cameraListWithAttributesForSaving, function(obj, success){
				if ($.isFunction(callback))
					callback(obj, success);

				if (obj && !success)
				{
					$(self.buttons.save.id).prop("disabled", false);
				}

				if (
					isMassObjectEditor
					&&
					(cameraListWithAttributesForSaving.length > 0 || !$.isEmptyObject(cameraListForCheck))
					//!$.isEmptyObject(cameraListForCheck)
					&&
					cameraListWithAttributesForSaving[cameraListWithAttributesForSaving.length - 1].obj == obj
				)
				{
					Log.info(__("Save complete"));
					$(id).unmask();
					createContainer()
						.done(init);
				}
			});

			var cameraListForCheckProgress = {};
			// second, we save cameras which needs checking model
			for (obj in cameraListForCheck)
			{
				// this camera was deleted
				if (deletedObjects[obj])
					continue;

				var attributes = getAttributes(obj, false);
				// we need to save only objects with changed values
				if ($.isEmptyObject(attributes))
					continue;

				if (cameraListForCheck[obj])
				{
					var ip = $("#DEVIP_" + obj).val();
					var port = $("#HTTP_PORT_" + obj).val();
					var user = $("#USRNAME_" + obj).val();
					var pass = attributes["PASSWD"] ? $("#PASSWD_" + obj).val() : null;
					var fastProbeModel = $("#CAMERAMODEL_" + obj).val();

					cameraListForCheckProgress[obj] = true;

					var getCameraModel = function(obj, attributes)
					{
						var newAttributes = {
							DEVIP: ip,
							HTTP_PORT: port,
							USRNAME: user,
							CAMERAMODEL: fastProbeModel
						};
						if (pass != null)
						{
							newAttributes["PASSWD"] = pass;
						}
						Validate.getCameraModel({
							attributes: newAttributes,
							obj: obj,
							"callback": function(model)
							{
								var isChangeModel = false;
								var error_cameras = "";

								if (model["error"] !== "")
								{
									error_cameras += "[" + obj + "] " + attributes["NAME"] + ". Error: " + model["error"];
								} else {
									var exists_msg = model["exists"];
									var camexists = model["camexists"];
									var objInCamExists = false;

									for (var objexists in camexists)
									{
										if (camexists[objexists] == obj) objInCamExists = true;
									}

									if (exists_msg !== "" && !objInCamExists)
									{
										Log.warning(exists_msg);
									}

									if (
										model["attributes"]['MODELID'] !== $("#MODELID_" + obj).val()
										|| model["attributes"]['CAMERAMODEL'] !== $("#CAMERAMODEL_" + obj).val()
										)
									{
										if (!confirm(
												"[" + obj + "] " + $("#NAME_" + obj).val() + " (" + $("#CAMERAMODEL_" + obj).val() + " " + $("#MODELID_" + obj).val() + ")\n"
												+ Gettext.strargs(__("You enter attributes for camera with another model (%1), are you sure that you want to save this camera?"), [model["attributes"]['CAMERAMODEL'] + " " + model["attributes"]['MODELID']])
											)
										)
										{
											error_cameras += Gettext.strargs(__("[%1] user abort"), [obj]); // i18n: %1 - object objid
										} else {
											isChangeModel = true;
											var changeModelAttributes = model["attributes"];

											var attributeList = ["DEVIP", "HTTP_PORT", "USRNAME", "PASSWD", "NAME", "LOCATION", "ASSOCIATE"];
											for (var i = 0; i < attributeList.length; i++)
											{
												var attribute = attributeList[i];
												changeModelAttributes[attribute] = attributes[attribute];
											}

											// save all VAE attributes
											$("#tab_content_VAE").find("select[data-attr][data-obj=" + obj + "], input[data-attr][data-obj=" + obj + "]").each(function(){
												var attribute = $(this).data("attr");
												var value = $(this).val();

												changeModelAttributes[attribute] = value;
											});

											// system type attribute not in attributes array
											changeModelAttributes["AUDIO_DEVID"] = $("#AUDIO_DEVID_" + obj).val();

											attributes = changeModelAttributes;
										}
									}
								}

								if (error_cameras !== "")
								{
									Log.error(Gettext.strargs(__("Next cameras not saved:\n%1"), [error_cameras]));
									$(self.buttons.save.id).prop("disabled", false);
									$(id).unmask();

									return false;
								} else {
									saveObjectAttributes(obj, attributes, isChangeModel, function(obj/*, success*/){
										if (cameraListForCheckProgress[obj])
											delete cameraListForCheckProgress[obj];
										if ($.isEmptyObject(cameraListForCheckProgress))
										{
											Log.info(__("Save complete"));
											$(id).unmask();
											createContainer()
												.done(init);
										}
									});
								}

								return true;
							}
						});
					}(obj, attributes);
				}
			}

			//$(self.buttons.save.id).prop("disabled", false);
			return true;
		}

		/**
		 * @param {String} name
		 * @returns {Function|null}
		 */
		function getValidateFunction(name)
		{
			var methodList = name.split(/\./);
			if (methodList.length > 0 && methodList[0] != "Validate")
			{
				return null;
			}

			var check = window;
			for (var i = 0; i < methodList.length;i++)
			{
				if (typeof check[methodList[i]] == "function")
				{
					return check[methodList[i]];
				} else
				if (typeof check[methodList[i]] == "object")
				{
					check = check[methodList[i]];
				} else {
					return null;
				}
			}

			return null;
		}

		function fillAllCameraAttributes()
		{
			var time = (new Date).getTime();
			var timeStr = "";

			var warningMessage = __("Depending on the number of devices present, this view may take some time to load. Please be patient.");
			$(id).append('<div class="loading_dark">' + warningMessage + '</div>');

			var apiParam = {};
			if (setid !== null) apiParam.setid = setid;
			if (nodeid !== null) apiParam.nodeid = nodeid;
			if (type !== null) apiParam.type = type;

			api.getTemplates(apiParam)
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				// load list of validate functions
				var loadValidate = function(i, objList, callback)
				{
					if (i == objList.length)
					{
						callback();
					} else {
						var obj = objList[i];
						var model = "";
						var type = response.template[obj].type;

						if (response.template[obj].attributes.CAMERAMODEL)
							model = response.template[obj].attributes.CAMERAMODEL.VALUE;

						// load validate functions
						require(
							["/sdi/admin/js/" + type + "/" + model + "/validate.js"],
							function ()
							{
								loadValidate(++i, objList, callback);
							}
						);
					}
				};

				var objList = Object.keys(response.template);

				loadValidate(0, objList, function(){
					var new_time = (new Date).getTime();
					timeStr += " Load: " + (new_time - time);
					time = new_time;

					$(self.buttons.remove.id).hide();

					$("#tabs_menu .tab_inactive").remove();

					new_time = (new Date).getTime();
					timeStr += " CSS1: " + (new_time - time);
					time = new_time;

					if (response.template)
					{
						objectTemplate = response.template;

						// hide buttons at bottom
						$(self.buttons.cancel.id).hide();
						$(self.buttons.save.id).hide();
						$(self.buttons.reload.id).hide();

						createObjectAttributes(null, objectTemplate, "tabs_content", isMassObjectEditor);

						// check for CSS3 (:last-child) for old browsers
						if (!$.support.scriptEval)
						{
							$(".tabs_form table tr td:last-child")
								.css("width", "150px")
								.css("background-color", "#828282")
								.css("color", "#FFFFFF")
								.css("text-align", "left");

							$(".tabs_form .tab_caption div:last-child")
								.css("color", "#000000")
								.css("font-weight", "bold")
								.css("text-align", "left")
								.css("width", "150px");
						}

						self.deactivateTabsManageButtons();

						new_time = (new Date).getTime();
						timeStr += " Create: " + (new_time - time);
						time = new_time;

						$("#tabs_content .tab_content").show();

						new_time = (new Date).getTime();
						timeStr += " CSS2: " + (new_time - time);
						time = new_time;

						$("#tabs .tabs_content").show();
						$(id + " .loading_dark").remove();

						if (window.console) console.log(timeStr);
					} else {
						Log.error(__('You have no cameras on this set at this time. Press "+" button to add cameras.'));
					}
					if ($.isFunction(self.onLoad))
					{
						self.onLoad();
					}
				});
			});
		}

		function onCancelObjectClick()
		{
			fillObjectAttributes(obj, function(){
				// check credentials for editor
				if (type !== "user" && type !== "role" && type !== "set")
				{
					checkCredentials(obj);
				}
			});

			//$("#current_camera_item").trigger("click");
		}

		function onBackObjectClick()
		{
	//		fillObjectAttributes(obj);
			//$("#current_camera_item").trigger("click");
		}

		function onReloadObjectClick()
		{
			fillObjectAttributes(obj, function(){
				fillCameraPlayerAttributes();
				// check credentials for editor
				if (type !== "user" && type !== "role" && type !== "set")
				{
					checkCredentials(obj);
				}
			});
		}

		function convertObjectsFormat(objects)
		{
			var result = {
				category: {},
				object: {}
			};

			for (var object in objects)
			{
				/**
				 * @type {Array}
				 */
				var tabs = objects[object].categories;

				result.object[object] = {};

				for (var tab = 0; tab < tabs.length; tab++)
				{
					var tabName = tabs[tab].category;
					var tabAttributes = tabs[tab].attributes;

					if (!result.category[tabName]) result.category[tabName] = {};
					if (!result.object[object][tabName]) result.object[object][tabName] = {};

					for (var attr = 0; attr < tabAttributes.length; attr++)
					{
						var attrName = tabAttributes[attr];
						if (!result.category[tabName][attrName]) result.category[tabName][attrName] = {};
						result.category[tabName][attrName][object] = object;

						result.object[object][tabName][attrName] = true;
					}
				}
			}
			return result;
		}

		function createObjectAttributes(obj_id, objects, elementIdForAtach, isMassObjectEditor)
		{
			var tab_content = [];
			var objectNames = [];
			if (!($("#" + elementIdForAtach).length > 0))
				return;
			var object;

			if (isMassObjectEditor)
			{
				var headerForTable = [];
				headerForTable.push('<table id="selectButtons"><tr><td><input type="button" id="saveAllChanges" value="' + __("Save all changes") +'"/><input type="button" id="deleteCameras" value="' + __("Delete objects") +'"/></td><td>&nbsp;</td>');
				for (object in objects)
				{
					var name = objects[object].attributes["NAME"]["VALUE"];
					headerForTable.push('<td>&nbsp;</td>');
					objectNames.push('<div><label><input type="checkbox" data-obj="' + object + '" data-event="checkCamera" value="' + __("Check") +'"/>' + name + '</label></div>');
				}
				headerForTable.push('<td>&nbsp;</td></tr></table>');
				tab_content.push(headerForTable.join(''));
			}

			// clear check list if reload attributes
			textfield_and_regexp_list_for_check = {};
			textfield_and_js_list_for_check = {};

			// find last object, and nu,ber of objects in objects
			var firstObject = null;
			var lastObject = null;
			var numberOfObjects = 0;
			for (object in objects)
			{
				if (!firstObject) firstObject = object;
				lastObject = object;
				numberOfObjects++;
			}

			// create tabs
			var convertedObjects = convertObjectsFormat(objects);
			var tabs = convertedObjects.category;
			var tabsObjects = convertedObjects.object;
			var tab;

			for (tab in tabs)
			{
				var tab_content_visible_attributes = [];

				if (isMassObjectEditor)
				{
					tab_content_visible_attributes.push('<div class="tab_caption"><div>' + __(tab, 'template') + '</div><div><label>' + __("Populate") + '<input data-event="checkAllCameras" type="checkbox"/></label></div>' + objectNames.join('') + '<div class="lastchild">' + __(tab, 'template') + '</div></div>');
				}

				// create content for tab
				tab_content_visible_attributes.push('<table>');
				var tab_content_hidden_attributes = [];

				for (var attr in tabs[tab])
				{
					// find attr with label
					var first_label = "";
					var has_visible_attr = false;
					for (object in objects)
					{
						if (!tabsObjects[object][tab] || !tabsObjects[object][tab][attr])
							continue;

						var tab_objects_attr = objects[object].attributes[attr];
						if (!tab_objects_attr)
							continue;

						var type = tab_objects_attr["TYPE"];
						var label = tab_objects_attr["LABEL"];

						if ((obj_id == "" && type == "init" || type !== "init")
							&& type !== "hidden"
							&& type !== "system")
						{
							has_visible_attr = true;

							if (label !== "")
							{
								first_label = label;
								break;
							}
						}
					}

					for (object in objects)
					{
						var attr_id = attr + "_" + object;
						var tab_objects_attr = objects[object].attributes[attr];

						if (has_visible_attr && object == firstObject)
						{
							tab_content_visible_attributes.push('<tr id="' + attr + '_row"><td>' + __(first_label, 'template') + '</td>');
							if (isMassObjectEditor)
							{
								// add edit field for populating to other attributes
								tab_content_visible_attributes.push('<td><input id="' + attr + '_populate" style="width: 70px;" value="" data-attr="' + attr + '"/><input id="' + attr + '_populate_button" type="button" value=">" style="width: 20px;" data-type="populate" data-attr="' + attr + '"/></td>');
							}
						}

						if (tabsObjects[object][tab] && tabsObjects[object][tab][attr] && tab_objects_attr)
						{
							var type = tab_objects_attr["TYPE"];
							var value = tab_objects_attr["VALUE"];
							var label = tab_objects_attr["LABEL"];
							var list = tab_objects_attr["LIST"];
							var url = tab_objects_attr["URL"];
							var validate = tab_objects_attr["VALIDATE"];
							var error = tab_objects_attr["ERROR"];
							var js = tab_objects_attr["JS"];
							var isDisabled = tab_objects_attr["IS_DISABLED"] === "true";

							var bySchedule = tab_objects_attr["BY_SCHEDULE"] === "true";
							var schedule = '';
							if (bySchedule)
							{
								schedule = 'data-schedule="true"';
							}

							if (type === "")
								continue;

							if ((obj_id == "" && type == "init" || type !== "init")
								&& type !== "hidden"
								&& type !== "system"
								|| has_visible_attr)
							{
								tab_content_visible_attributes.push('<td align="left" id="' + attr_id + '_cell">');
							}

							var found = null;
							var maxlength = "";

							// create controls
							if (type === "hidden"
								|| type === "system" || isMassObjectEditor && attr == "PROBE")
							{
								tab_content_hidden_attributes.push('<input id="' + attr_id + '" value="' + value.replace(/"/g, '&quot;') + '" type="hidden" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"' + schedule + '/>');
							} else
							if (type === "dropmenu")
							{
								var disabled = '';
								if (isDisabled)
								{
									disabled = 'disabled="true"';
								}
								tab_content_visible_attributes.push('<select id="' + attr_id + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '" ' + disabled + schedule + '>');
								var options = list;
								var isSelected = false;
								for (var j = 0; j < options.length; j++)
								{
									var optionValue = options[j]['value'] || '';
									optionValue = optionValue + "";
									optionValue = optionValue.replace(/"/g, '&quot;');
									var selectedAttribute = "";
									if (options[j]['value'] == value)
									{
										isSelected = true;
										selectedAttribute = 'selected="true"';
									}

									tab_content_visible_attributes.push('<option value="' + optionValue + '" ' + selectedAttribute + '>' + __(options[j]['label'], 'template') + '</option>');
								}

								// if list not contain necessary value, then create empty option
								if (!isSelected)
								{
									tab_content_visible_attributes.push('<option value="' + value.replace(/"/g, '&quot;') + '" selected="true"></option>');
								}
								tab_content_visible_attributes.push('</select>');
							} else
							if (type === "checkboxlist")
							{
								tab_content_visible_attributes.push('<div id="' + attr_id + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '">');
								var options = list;
								for (var j = 0; j < options.length; j++)
								{
									var optionValue = (""+options[j]['value']).replace(/"/g, '&quot;');
									tab_content_visible_attributes.push('<div><label><input type="checkbox" value="' + optionValue +'"/>' + __(options[j]['label'], 'template') + '</label></div>');
								}
								tab_content_visible_attributes.push('</div>');
							} else
							if (type === "triggerbutton")
							{
								var options = list;
								for (var j = 0; j < options.length; j++)
								{
									if (options[j]['value'] == value)
									{
										var disabled = "";
										if (value == 1)
										{
											disabled = 'disabled = "true"';
										}
										tab_content_visible_attributes.push('<input id="' + attr_id + '" data-url="' + url + '" data-error="' + error + '" type="button" value="' + __(options[j]['label'], 'template').replace(/"/g, '&quot;') + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '" ' + disabled + '/>');
									}
								}
							} else
							if (type === "urllist")
							{
								tab_content_visible_attributes.push('<div id="' + attr_id + '" value="' + value.replace(/"/g, '&quot;') + '" type="text" readOnly="true" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"/>');
							} else
							if (type === "custom_html")
							{
								tab_content_visible_attributes.push('<div id="' + attr_id + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '">' + value.replace(/"/g, '&quot;') + '</div>');
							} else
							if (type === "urlbutton")
							{
								tab_content_visible_attributes.push('<input id="' + attr_id + '" data-url="' + url + '" data-error="' + error + '" type="button" value="' + __(value, 'template').replace(/"/g, '&quot;') + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"/>');
							} else
							if (type === "view" || type === "refview")
							{
								tab_content_visible_attributes.push('<input id="' + attr_id + '" value="' + value.replace(/"/g, '&quot;') + '" type="text" readOnly="true" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"' + schedule + '/>');
							} else
							if (type === "stat" || isMassObjectEditor && (attr == 'DEVIP' || attr == 'HTTP_PORT' || attr == 'USRNAME'))
							{
								tab_content_visible_attributes.push('<input id="' + attr_id + '" value="' + __(value).replace(/"/g, '&quot;') + '" type="text" readOnly="true" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"/>');
							} else
							if (isMassObjectEditor && (attr == 'PASSWD'))
							{
								tab_content_visible_attributes.push('<input id="' + attr_id + '" value="' + __(value).replace(/"/g, '&quot;') + '" type="password" readOnly="true" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"/>');
							} else
							if ((found = /^textfield(.*)$/i.exec(type)) != null)
							{
								// init this type only for insert to DB, not for update DB
								maxlength = "";
								if (type !== "init")
								{
									var textfield_width = found[1];
									if (String(textfield_width) != 'null' && String(textfield_width) != 'undefined')
										maxlength = 'maxlength="' + textfield_width + '"';
								}
								tab_content_visible_attributes.push('<input id="' + attr_id + '" data-error="' + error + '" value="' + value.replace(/"/g, '&quot;') + '" type="text" ' + maxlength + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"' + schedule + '/>');

								if (validate !== "")
								{
									if (validate)
									{
										textfield_and_regexp_list_for_check[attr_id] = {};
										textfield_and_regexp_list_for_check[attr_id]['regexp'] = validate;
										textfield_and_regexp_list_for_check[attr_id]['label'] = label;
									}
								}
								if (js !== "")
								{
									if (js)
									{
										textfield_and_js_list_for_check[attr_id] = {};
										textfield_and_js_list_for_check[attr_id]['js'] = js;
										textfield_and_js_list_for_check[attr_id]['label'] = label;
									}
								}
							} else
							if ((found = /^password(.*)$/i.exec(type)) != null)
							{
								maxlength = "";
								var textfield_width = found[1];
								if (String(textfield_width) != 'null' && String(textfield_width) != 'undefined')
									maxlength = 'maxlength="' + textfield_width + '"';
								tab_content_visible_attributes.push('<input id="' + attr_id + '" value="' + value.replace(/"/g, '&quot;') + '" type="password" ' + maxlength + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '"/>');
							}

							// for this attributes no need close tags
							if ((obj_id == "" && type == "init" || type !== "init")
								&& type !== "hidden"
								&& type !== "system"
								|| has_visible_attr)
							{
								tab_content_visible_attributes.push("</td>");
							}
						} else
						if (has_visible_attr)
						{
							tab_content_visible_attributes.push('<td>&nbsp;</td>');
						}

						if (has_visible_attr && object == lastObject)
						{
							if (isMassObjectEditor)
							{
								tab_content_visible_attributes.push('<td align="right" class="lastchild">' + __(first_label, 'template') + '</td>');
							}
							tab_content_visible_attributes.push("</tr>");
						}
					}
				}
				tab_content_visible_attributes.push("</table>");
				tab_content.push('<div class="tab_content" id="tab_content_' + tab + '" style="display:none;">' + tab_content_hidden_attributes.join('') + tab_content_visible_attributes.join('') + '</div>');
			}

			// append new tabs to DOM
			if (isMassObjectEditor)
			{
				var elementIdForAtach_width = numberOfObjects * (104 + 2) + 156 * 2 + 104 + 4;
				$(".editor_container").width(elementIdForAtach_width + "px");
			}
			//$("#" + elementIdForAtach)[0].innerHTML = tab_content.join('');
			$("#" + elementIdForAtach).html(tab_content.join(''));
			$("#" + elementIdForAtach).data("obj", obj_id);

			if (isMassObjectEditor)
			{
				textfield_for_camera_exists_check = {};
			}
			for (object in objects)
			{
				var devip = $("#DEVIP_" + object).val();
				if (devip)
				{
					textfield_for_camera_exists_check['DEVIP_' + object] = devip;
					textfield_for_camera_exists_check['HTTP_PORT_' + object] = $("#HTTP_PORT_" + object).val();
					textfield_for_camera_exists_check['USRNAME_' + object] = $("#USRNAME_" + object).val();
					textfield_for_camera_exists_check['PASSWD_' + object] = $("#PASSWD_" + object).val();
				}
			}

			// atach events for created controls
			if (isMassObjectEditor)
			{
				$("#deleteCameras").click(onDeleteObjectsClick);
				$("#saveAllChanges").click(onSaveAllChangesClick);
				$("#" + elementIdForAtach).click(function(event){
					var data_event = $(event.target).data("event");
					var obj = $(event.target).data("obj");

					if (data_event === "checkCamera")
					{
						if (event.target.checked)
						{
							$("#" + elementIdForAtach + " input[type='checkbox'][data-obj='" + obj + "'][data-event='checkCamera']").each(function(){
								$(this)
									.prop("checked", true);
							});
							selectedObjects[obj] = true;
						} else {
							$("#" + elementIdForAtach + " input[type='checkbox'][data-obj='" + obj + "'][data-event='checkCamera']").each(function(){
								$(this)
									.prop("checked", false);
							});
							delete selectedObjects[obj];
						}
					} else
					if (data_event === "checkAllCameras")
					{
						// if checkbox checked then check all checkboxes else uncheck
						if ($(event.target).prop("checked"))
						{
							$("#" + elementIdForAtach + " input[type='checkbox']").each(function(){
								var data_event = $(this).data("event");
								if (data_event === 'checkCamera' || data_event === 'checkAllCameras')
								{
									$(this)
										.prop("checked", true);
								}
								if (data_event === 'checkCamera')
								{
									var obj = $(this).data("obj");
									selectedObjects[obj] = true;
								}
							});
						} else {
							$("#" + elementIdForAtach + " input[type='checkbox']").each(function(){
								var data_event = $(this).data("event");
								if (data_event === 'checkCamera' || data_event === 'checkAllCameras')
								{
									$(this)
										.prop("checked", false);
								}
							});
							selectedObjects = {};
						}
					}
				});
			}

			for (tab in tabs)
			{
				for (var attr in tabs[tab])
				{
					// add events for populate to all buttons
					$("#" + attr + "_populate_button").click(function(){
						var attr = $(this).data("attr");
						var populate_value = $("#" + attr + "_populate").val();

						var found;
						for (var object in objects)
						{
							// populate only selected cameras
							if (!selectedObjects[object])
								continue;

							// object was deleted
							if (deletedObjects[object])
								continue;

							var attr_id = attr + "_" + object;
							var type = $("#" + attr_id).data("type");

							if (type === "dropmenu")
							{
								// change value in dropmenu only if its consist it
								$("#" + attr_id).children().each(function()
								{
									if ($(this).text() === populate_value)
									{
										$("#" + attr_id)
											.val($(this).val())
											.trigger("change");
										return false;
									}
									return true;
								});
							} else
							if ((found = /^textfield(.*)$/i.exec(type)) != null
									|| (found = /^password(.*)$/i.exec(type)) != null)
							{
								$("#" + attr_id).val(populate_value);
							}
						}

						self.activateTabsManageButtons();
					});

					var dataList = {};
					// add events for all controls
					for (object in objects)
					{
						if (!tabsObjects[object][tab] || !tabsObjects[object][tab][attr])
							continue;

						var tab_objects_attr = objects[object].attributes[attr];
						if (!tab_objects_attr)
							continue;

						for (var ind in tab_objects_attr["LIST"])
						{
							tab_objects_attr["LIST"][ind]["label"] = __(tab_objects_attr["LIST"][ind]["label"], 'template');
						}

						var attr_id = attr + "_" + object;
						var type = tab_objects_attr["TYPE"];
						var value = tab_objects_attr["VALUE"];
						var label = tab_objects_attr["LABEL"];
						var list = tab_objects_attr["LIST"];
						var url = tab_objects_attr["URL"];
						var JS = tab_objects_attr["JS"];

						if (type == "")
							continue;
						if (type === "dropmenu")
						{
							// add handler for check parameter
							if (JS)
							{
								$("#" + attr_id).change(getValidateFunction(JS));
								$("#" + attr_id).trigger("change", {firstRun: true});
							}

							// add handler for activate 'apply' and 'cancel' buttons
							$("#" + attr_id).change(self.activateTabsManageButtons);
							for (var i = 0; i < list.length; i++)
							{
								dataList[list[i]['label']] = 1;
							}

							// hack for dropdown select with big width in IE
							if (attr == "TIME_ZONE" && $.browser.msie)
							{
								$("#" + attr_id)
									.mousedown(function(){
										if ($(this).width()<200)
											$(this).css("width", "auto");
									})
									.focus(function(){
										if ($(this).width()<200)
											$(this).css("width", "auto");
									})
									.blur(function(){
										$(this).css("width", "");
									});
							}
						} else
						if (type === "checkboxlist")
						{
							// add handler for check parameter
							if (JS)
							{
								$("#" + attr_id).click(getValidateFunction(JS));
								$("#" + attr_id).trigger("click", {firstRun: true});
							}
						} else
						if (type === "triggerbutton")
						{
							// add handler for check parameter
							if (JS && $("#" + attr_id).data("type") == "triggerbutton")
							{
								$("#" + attr_id).click(getValidateFunction(JS));
							}
						} else
						if (type === "urlbutton")
						{
							if (!JS)
							{
								$("#" + attr_id).click(function(){
									window.open($(this).data("url"), "", "width=800,height=600,resizable=yes,scrollbars=yes");
								});
							} else {
								$("#" + attr_id).click(getValidateFunction(JS));
							}
						} else
						if (type === "hidden"
							|| type === "view"
							|| type === "urllist"
							|| type === "stat")
						{
							if (JS)
							{
								$("#" + attr_id).change(getValidateFunction(JS));
								$("#" + attr_id).trigger("change", {firstRun: true});
							}
						} else
						if ((found = /^textfield(.*)$/i.exec(type)) !== null)
						{
							$("#" + attr_id).keyup(self.activateTabsManageButtons);
							dataList[value] = 1;
						} else
						if (type === "custom_html")
						{
							if (JS)
							{
								$("#" + attr_id).change(getValidateFunction(JS));
								$("#" + attr_id).trigger("change");
							}
						} else
						if ((found = /^password(.*)$/i.exec(type)) !== null)
						{
							$("#" + attr_id).keyup(self.activateTabsManageButtons);
						}
					}

					if (isMassObjectEditor)
					{
						// create array for autocompleting
						var dataListForAutocomplete = [];
						for (var data in dataList)
						{
							dataListForAutocomplete.push(data);
						}
						$("#" + attr + "_populate").autocomplete({
							source: dataListForAutocomplete,
							autoFocus: true,
							messages: {
								noResults: null,
								results: function ()
								{
								}
							},
							delay: 100,
							minLength: 0
						});
						$("#" + attr + "_populate").focus(function()
						{
							if (this.value.length == 0)
								$(this).autocomplete("search", "");
						});
					}
				}
			}

			self.deactivateTabsManageButtons();
		}

		function disableCameraAttributes(obj)
		{
			// remove checkboxes for selecting camera in mass camera editor
			$("#tabs_content input[type='checkbox'][data-obj='" + obj + "'][data-event='checkCamera']").each(function(){
				$(this).remove();
				delete selectedObjects[obj];
			});

			var convertedObjects = convertObjectsFormat(objectTemplate);

			var tabs = convertedObjects.category;
			var tabsObjects = convertedObjects.object;

			for (var tab in tabs)
			{
				for (var attr in tabs[tab])
				{
					if (tabsObjects[obj][tab][attr])
					{
						var attr_id = attr + "_" + obj;

						// remove element from DOM
						$("#" + attr_id).remove();

						// remove from list for checking
						delete textfield_and_regexp_list_for_check[attr_id];
					}
				}
			}
		}

		function createObjectTabs(objects)
		{
			/**
			 * @type {Array}
			 */
			var tabs = objects.categories || [];
			var tab_num = 0;
			var tab_headers = "";

			// create tab headers
			for (var tab = 0; tab < tabs.length; tab++)
			{
				var tabName = tabs[tab].category || "";

				// disable tabs for "Identity" editor if needed
				if (type == "gui" && formName == "Identity") {
					if(tabName == "General" && typeof identityGeneral != 'undefined' && !identityGeneral){
						continue;
					}
					else if(tabName == "Events" && typeof identityEvents != 'undefined' && !identityEvents){
						continue;
					}
					else if(tabName == "Mapping" && typeof identityMapping != 'undefined' && !identityMapping){
						continue;
					}
					else if(tabName == "vMX" && typeof identityvMX != 'undefined' && !identityvMX){
						continue;
					}
					else if(tabName == "Miscellaneous" && typeof identityMiscellaneous != 'undefined' && !identityMiscellaneous){
						continue;
					}
					else if(tabName == "Session" && typeof identitySession != 'undefined' && !identitySession){
						continue;
					}
					else if(tabName == "Cloud" && typeof identityCloud != 'undefined' && !identityCloud){
						continue;
					}
					else if(tabName == "LDAP" && typeof identityLDAP != 'undefined' && !identityLDAP){
						continue;
					}
				}

				tab_num++;
				tab_headers += '<div class="tab_inactive" name="tab_content_' + tabName + '">';
				tab_headers += '<div class="tab_text">' + __(tabName, 'template') + '</div>';
				tab_headers += '</div>';
			}

			var old_current_tab_name = $("#current_tab").attr("name");
			$("#tabs_menu")
				.empty()
				.append(tab_headers);

			// set width of tabs
			if (!$("#tabs:visible").length)
				$("#tabs").show();
			var tabs_width = $("#tabs").width();
			var tab_width = Math.round(tabs_width / tab_num);
			var last_tab_width = tabs_width - tab_width * (tab_num - 1);
			$("#tabs_menu .tab_inactive").css("width", tab_width + "px");
			$("#tabs_menu .current_tab").css("width", tab_width + "px");
			$("#tabs_menu .tab_inactive:last").css("width", last_tab_width + "px");

			if (typeof old_current_tab_name != "undefined")
			{
				$("#tabs_menu .tab_inactive[name='" + old_current_tab_name + "']").attr("id", "current_tab")
					.removeClass("tab_inactive")
					.addClass("current_tab");
			} else {
				$("#tabs_menu .tab_inactive:first").attr("id", "current_tab")
					.removeClass("tab_inactive")
					.addClass("current_tab");
			}

			$("#tabs_menu .tab_inactive, #tabs_menu .current_tab").click(function(){
				// hide player on Audit page
				if (!isMassObjectEditor)
				{
					if ($(this).attr("name") === "tab_content_Audit")
					{
						hideVideoPanel();
						auditObj.pagenum = 0;
						auditObj.applyFilter();
					} else {
						if (type == "camera") showVideoPanel();
					}
				}

				$("#tabs_content .tab_content:not(#" + $(this).attr("name") + ")").hide();
				$("#" + $(this).attr("name")).show();

				$("#tabs_menu .current_tab").removeAttr("id")
					.removeClass("current_tab")
					.addClass("tab_inactive");

				$(this).attr("id", "current_tab")
					.removeClass("tab_inactive")
					.addClass("current_tab");
			});

			$("#" + $("#current_tab").attr("name")).show();
			$("#current_tab").trigger("click");
			$("#tabs").show();
		}

		function hideVideoPanel(){
			$("#tabs div.tabs_content").children(":first-child").css("width", "0%").css("display", "none");
			$("#tabs_content").css("width", "100%");
		}

		function showVideoPanel(){
			$("#tabs div.tabs_content").children(":first-child").css("width", "49%").css("display", "block");
			$("#tabs_content").css("width", "49%");
		}

		function deleteObject(obj, callback)
		{
			if (!obj)
				return;

			api.deleteObject({
				objList: JSON.stringify([obj])
			})
				.fail(function(code, message){
					Log.error(message);
					if ($.isFunction(callback))
						callback(obj, false);
				})
				.done(function(/*response*/){
					if ($.isFunction(callback))
						callback(obj, true);
				});
		}

		function fillCameraPlayerAttributes(name, location)
		{
			var image_path = '/storage/snapshot?objid=' + obj + '&downscale';

			$("#camera .videoControl .play").unbind("click");
			$("#camera .videoControl .pause").unbind("click");

			// fill attributes for camera player
			$("#playerVideoImage")
				.empty()
				.append('<img id="videoPlay" src="img/camera_image_play.png" width="273" height="205"/>')
				.css("background", "url(" + image_path + ") no-repeat 50% 50%");

			$("#camera .videoControl .play").hide();
			$("#camera .videoControl .pause").hide();

			$("#videoPlay").click(onVideoPlayClick);
		}

		function onVideoPlayClick()
		{
			if ($("#POSITIONCTL_" + obj).val() != "none"
				&& window.HWJoystick)
			{
				HWJoystick.setObj(obj);
				HWJoystick.onLoad = function(success)
				{
					if (success)
					{
						HWJoystick.startWaitEvents();
					}
				};
				HWJoystick.init();
			}

			$("#playerVideoImage")
				.empty()
				.css({
					background: "",
					width: livePlayerWidth,
					height: livePlayerHeight,
					"margin-left": "30px"
				});

			var player = new MediaPlayer();
			player
				.init("#playerVideoImage")
				.done(function(){
					this.play(obj);

					this.subscribe("imageclick", function(width, height, x, y){
						if($("#POSITIONCTL_" + obj).val() != "none")
						{
							clickOnScreenPTZ(obj, width, height, x|0, y|0);
						}
					}, "zoom");
				});

			$("#camera .videoControl .pause")
				.click(function(){
					player.pause();

					$(this).hide();

					$("#camera .videoControl .play").show();
				});
			$("#camera .videoControl .play")
				.click(function(){
					player.play();

					$(this).hide();

					$("#camera .videoControl .pause").show();
				});
			$("#camera .videoControl .pause").show();
		}

		function clickOnScreenPTZ(objId, playerW, playerH, x, y)
		{
			HWJoystick.gotoXY(x, y, playerW, playerH);
		}

		function validateAttributes()
		{
			var error = false;
			var error_attributes = "";
			var key;

			// to use JS code as validator for text field validate javascript must return res.data("error") on errors
			for (key in textfield_and_js_list_for_check)
			{
				var JS = textfield_and_js_list_for_check[key]['js'];
				if (JS)
				{
					$("#" + key).change(getValidateFunction(JS));
					var res = $("#" + key).trigger("change");
					if (res.data("error") && res.data("error") != ''){
						error = true;
						error_attributes += res.data("error") + "\n";
					}
				}
			}

			for (key in textfield_and_regexp_list_for_check)
			{
				var str = $("#" + key).val();
				var regexp = new RegExp(textfield_and_regexp_list_for_check[key]['regexp']);
				if (!regexp.test(str))
				{
					var error_msg = $("#" + key).data("error");
					if (error_msg && error_msg !== "") error_msg = "(" + error_msg + ")";
					var identificator = "";
					var obj = $("#" + key).data("obj");
					if (obj)
					{
						var name = $("#NAME_" + obj).val();
						identificator = "[" + obj + "] " + name + ": ";
					}
					error_attributes += identificator + textfield_and_regexp_list_for_check[key]['label'] + " " + error_msg + "\n";
					error = true;
				}
			}
			return {
				"error": error,
				"error_attributes": error_attributes
			}
		}

		function getCameraListForCheck()
		{
			var cameraListForCheck = {};
			for (var key in textfield_for_camera_exists_check)
			{
				var obj = $("#" + key).data("obj");
				if (isMassObjectEditor)
				{
					cameraListForCheck[obj] = false;
				} else
				if (!cameraListForCheck[obj] && $("#CAMERAMODEL_" + obj).val() !== 'URL')
				{
					cameraListForCheck[obj] = textfield_for_camera_exists_check[key] !== $("#" + key).val();
				}
			}
			return cameraListForCheck;
		}

		/**
		 * get attributes of the specified object
		 * @param {number} obj
		 * @param {boolean} isChanged true - return only changed attributes, false - return all attributes
		 * @returns {Object<string, string>}
		 */
		function getAttributes(obj, isChanged)
		{
			var attributes = {};

			if (typeof objectTemplate[obj] !== "undefined")
			for (var attr in objectTemplate[obj].attributes)
			{
				var attribute = objectTemplate[obj].attributes[attr];
				var type = attribute["TYPE"];
				if (type !== ""
					&& typeof type != 'undefined'
					&& type !== "triggerbutton"
					&& type !== "urlbutton"
					&& type !== "urllist"
					&& type !== "checkboxlist"
					&& type !== "stat"
					&& type !== "system"
					&& type !== "custom_html"
					&& (obj == "" && type == "init" || type !== "init"))
				{
					var currentItem = $("#" + attr + "_" + obj);
					var currentAttrValue = currentItem.val();
					if (!isChanged || isChanged && attribute["VALUE"] !== currentAttrValue)
					{
						if (type.indexOf("textfield") > -1) currentAttrValue = $.trim(currentAttrValue);
						// skip empty template lists
						if (type == "dropmenu" && attribute["LIST"].length == 0)
						{
							continue;
						}
						attributes[attr] = currentAttrValue;
					}
				}
			}

			return attributes;
		}

		function saveObjectAttributes(obj, attributes, isChangeModel, callback)
		{
			// only when creating object
			// TODO: fix bug of replacing attributes values here
			if (!obj)
				$.extend(attributes, aditionalAttributes);

			if (obj)
			{
				$("#tabs").mask();

				api.setAttributes({
					obj: obj,
					attributes: JSON.stringify(attributes)
				})
					.fail(function(code, message){
						Log.error(message);
						if ($.isFunction(callback))
						{
							callback(null, false);
						}
					})
					.done(function(/*response*/){
						if (!isMassObjectEditor)
							init(notReload);
						if ($.isFunction(callback))
						{
							callback(obj, true);
						}
					})
					.always(function(){
						$("#tabs").unmask();
					})
			} else {
				var params = {
					attributes: JSON.stringify(attributes),
					type: type
				};
				if (setid)
				{
					params.setid = setid;
				}
				api.addObject(params)
				.fail(function(code, message){
					Log.error(message);
					if ($.isFunction(callback))
					{
						callback(null, false);
					}
				})
				.done(function(response){
					if (!isMassObjectEditor)
						init(notReload);
					if ($.isFunction(callback))
					{
						callback(response.obj, true);
					}
				});
			}
		}

		function onDeleteObjectsClick()
		{
			// delete cameras
			var names = "";
			var count = 0;
			var obj;
			for (obj in selectedObjects)
			{
				if (selectedObjects[obj])
				{
					count++;
					names += "[" + obj + "] " + $("#NAME_" + obj).val() + ", ";
				}
			}
			if (count > 0 && confirm("Are you sure you want to delete " + count + " cameras (" + names + ") ?"))
			{
				for (obj in selectedObjects)
				{
					if (selectedObjects[obj])
					{
						deleteObject(obj, function(obj, success){
							deletedObjects[obj] = success;
							success && disableCameraAttributes(obj);
						});
					}
				}
			}
		}

		function onSaveAllChangesClick()
		{
			//save cameras
			if(confirm(__("Are you sure you want to save all changes?")))
			{
				onSaveObjectClick();
			}
		}

		// load css styles to head section
		function require_css(url)
		{
			if (!url)
				return;

			if ($("head link[href$='" + url + "']").length > 0)
				return;

			var link = document.createElement('link');
			link.setAttribute("rel", "stylesheet");
			link.setAttribute("type", "text/css");
			link.setAttribute("media", "all");
			link.setAttribute("href", url);
			document.getElementsByTagName('head')[0].appendChild(link);
		}

		function remove_css(url)
		{
			$("head link[href$='" + url + "']").remove();
		}

		/**
		 * check access to attributes due to credentials
		 * @param {number} obj
		 */
		function checkCredentials(obj)
		{
			// do not check if full access
			if (window.scFullDevice)
			{
				return;
			}

			// do not allow to delete
			$("#deleteObject").prop("disabled", true);

			// give access to device settings, except NAME and IP
			if (window.scDeviceSettings)
			{
				$("#NAME_" + obj).prop("disabled", true);
				$("#DEVIP_" + obj).prop("disabled", true);
				return;
			}

			// disable all editable attributes
			$(".editor_container")
				.find("input, button, textarea, select")
				.prop("disabled", true);

			// allow to edit policies
			if (window.scDevicePolicy)
			{
				var EVENT_POLICY = $("#EVENT_POLICY_" + obj);
				if (EVENT_POLICY.length != 0)
				{
					EVENT_POLICY.prop("disabled", false);
				}

				var STORAGE_POLICY = $("#STORAGE_POLICY_" + obj);
				if (STORAGE_POLICY.length != 0)
				{
					STORAGE_POLICY.prop("disabled", false);
				}
			}

			// allow to edit VAE
			if (window.scDeviceAnalytics)
			{
				var VAE_ACTIVE = $("#VAE_ACTIVE_" + obj);
				if (VAE_ACTIVE.length != 0)
				{
					VAE_ACTIVE
						.closest('table')
						.find("input, button, textarea, select")
						.prop("disabled", false);
				}
			}
		}
	}

	return Editor;
});
