/**
 * AUTO-GENERATED FILE - DO NOT EDIT!!
 */
(function(window){
	"use strict";

	window.API = API;

	/**
	 * @param {Boolean} [async] use only if you CANNOT use async
	 * @constructor
	 */
	function API(async)
	{
		this._async = typeof async != "undefined" ? !!async : true;
	}

	/**
	 * @param {String} funcName
	 * @param {String} funcMethod
	 * @param {Object} parameters
	 * @param {Array} requiredParameters
	 * @returns {Deferred}
	 */
	API.prototype._send = function(funcName, funcMethod, parameters, requiredParameters)
	{
		var deferred = $.Deferred();

		var parameter;
		for (var i = 0; i < requiredParameters.length; i++)
		{
			parameter = requiredParameters[i];
			if (typeof parameters[parameter] == "undefined")
			{
				deferred.reject(400, "parameter '" + parameter + "' of function '" + funcName + "' should be specified", parameters);
				return deferred.promise();
			}
		}

		for (parameter in parameters)
		{
			if (parameters[parameter] == null)
			{
				deferred.reject(400, "parameter '" + parameter + "' of function '" + funcName + "' could not be null", parameters);
				return deferred.promise();
			}
		}

		var url = "/api/call/" + funcName;

		if (!this._async)
		{
			var e = new Error();
			if (!e.stack)
			{
				try { throw e; }
				catch (e) {}
			}
			var where = e.stack ? e.stack.toString().split(/\r\n|\n/)[2] : "";
			window.console && console.warn("do not use sync http call: " + url + "\n" + where);
		}

		$.ajax({
			url: url,
			type: funcMethod,
			dataType: "json",
			cache: false,
			data: parameters,
			async: this._async,
			error: function(jqXHR){
				var code = jqXHR.status;
				// use jqXHR.responseJSON.error for Safari
				var message = (jqXHR.responseJSON && jqXHR.responseJSON.error) ? jqXHR.responseJSON.error : jqXHR.statusText;
				deferred.reject(code, message, parameters);
			},
			success: function(result){
				if (result.code == 200)
				{
					deferred.resolve(result, parameters);
				} else {
					deferred.reject(result.code, result.error, parameters);
				}
			}
		});

		return deferred.promise();
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getAttribute = function(parameters){
		var funcName = "getAttribute";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj",
			"attribute"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getAttributes = function(parameters){
		var funcName = "getAttributes";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getBlockURL = function(parameters){
		var funcName = "getBlockURL";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj",
			"blockId"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getBlocksInfo = function(parameters){
		var funcName = "getBlocksInfo";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getIdentityAttribute = function(parameters){
		var funcName = "getIdentityAttribute";
		var funcMethod = "GET";
		var requiredParameters = [
			"attribute"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getIdentityAttributes = function(){
		var parameters = {};
		var funcName = "getIdentityAttributes";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getObjectList = function(parameters){
		var funcName = "getObjectList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getDeletedObjectList = function(parameters){
		var funcName = "getDeletedObjectList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getTemplate = function(parameters){
		var funcName = "getTemplate";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getTemplates = function(parameters){
		var funcName = "getTemplates";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getTypes = function(parameters){
		var funcName = "getTypes";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getResourceTree = function(parameters){
		var funcName = "getResourceTree";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getTicketForCameraModel = function(parameters){
		var funcName = "getTicketForCameraModel";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getCameraModelByTicket = function(parameters){
		var funcName = "getCameraModelByTicket";
		var funcMethod = "GET";
		var requiredParameters = [
			"ticket"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getCameraModel = function(parameters){
		var funcName = "getCameraModel";
		var funcMethod = "GET";
		var requiredParameters = [
			"attributes"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getPermissionTypeList = function(){
		var parameters = {};
		var funcName = "getPermissionTypeList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventsInterval = function(parameters){
		var funcName = "getEventsInterval";
		var funcMethod = "GET";
		var requiredParameters = [
			"start",
			"interval"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getEvents = function(parameters){
		var funcName = "getEvents";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventsStatistics = function(parameters){
		var funcName = "getEventsStatistics";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList",
			"beginTime",
			"endTime",
			"granularity"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.isEventExists = function(parameters){
		var funcName = "isEventExists";
		var funcMethod = "GET";
		var requiredParameters = [
			"eventid"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getTimezoneOffsetList = function(parameters){
		var funcName = "getTimezoneOffsetList";
		var funcMethod = "GET";
		var requiredParameters = [
			"timezoneList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getTimezoneInformationList = function(parameters){
		var funcName = "getTimezoneInformationList";
		var funcMethod = "GET";
		var requiredParameters = [
			"timezoneList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getCertificateRequestInfo = function(){
		var parameters = {};
		var funcName = "getCertificateRequestInfo";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getCertificateInfo = function(){
		var parameters = {};
		var funcName = "getCertificateInfo";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getCertificateFullInfo = function(){
		var parameters = {};
		var funcName = "getCertificateFullInfo";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getStorageUsage = function(parameters){
		var funcName = "getStorageUsage";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList",
			"granularity"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getStorageUsageTotals = function(parameters){
		var funcName = "getStorageUsageTotals";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getStorageUsageSpread = function(parameters){
		var funcName = "getStorageUsageSpread";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getNodeStorageUsageTotal = function(parameters){
		var funcName = "getNodeStorageUsageTotal";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getObjStoragePolicyInfo = function(parameters){
		var funcName = "getObjStoragePolicyInfo";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getSystemStatus = function(){
		var parameters = {};
		var funcName = "getSystemStatus";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getAvatarStatus = function(parameters){
		var funcName = "getAvatarStatus";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getAuditRecords = function(parameters){
		var funcName = "getAuditRecords";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getAuditCategories = function(){
		var parameters = {};
		var funcName = "getAuditCategories";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getEventPriorities = function(){
		var parameters = {};
		var funcName = "getEventPriorities";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getqtCamParametersList = function(parameters){
		var funcName = "getqtCamParametersList";
		var funcMethod = "GET";
		var requiredParameters = [
			"type"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getqtCamCameraPicture = function(parameters){
		var funcName = "getqtCamCameraPicture";
		var funcMethod = "GET";
		var requiredParameters = [
			"id"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getServerTime = function(){
		var parameters = {};
		var funcName = "getServerTime";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getObjectOnScheduleList = function(parameters){
		var funcName = "getObjectOnScheduleList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getUnusedPosturesList = function(parameters){
		var funcName = "getUnusedPosturesList";
		var funcMethod = "GET";
		var requiredParameters = [
			"scheduleid"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getScheduleInfo = function(parameters){
		var funcName = "getScheduleInfo";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventSource = function(parameters){
		var funcName = "getEventSource";
		var funcMethod = "GET";
		var requiredParameters = [
			"scheduleid",
			"datefrom",
			"dateto"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getAnalyticsSchema = function(){
		var parameters = {};
		var funcName = "getAnalyticsSchema";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.getSessionList = function(parameters){
		var funcName = "getSessionList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.authorizationManager = function(parameters){
		var funcName = "authorizationManager";
		var funcMethod = "GET";
		var requiredParameters = [
			"objid",
			"streamtype"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getCameraLog = function(parameters){
		var funcName = "getCameraLog";
		var funcMethod = "GET";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getPosturesInfo = function(parameters){
		var funcName = "getPosturesInfo";
		var funcMethod = "GET";
		var requiredParameters = [
			"scheduleid"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getStorageCoverage = function(parameters){
		var funcName = "getStorageCoverage";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList",
			"startTime",
			"endTime",
			"granularity"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getVersionControlInformation = function(parameters){
		var funcName = "getVersionControlInformation";
		var funcMethod = "GET";
		var requiredParameters = [
			"section"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getAxisCameraList = function(){
		var parameters = {};
		var funcName = "getAxisCameraList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getCameraModelList = function(){
		var parameters = {};
		var funcName = "getCameraModelList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getVCADetails = function(){
		var parameters = {};
		var funcName = "getVCADetails";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getOV6Details = function(){
		var parameters = {};
		var funcName = "getOV6Details";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getLastTargets = function(){
		var parameters = {};
		var funcName = "getLastTargets";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getTargetRelatedZone = function(parameters){
		var funcName = "getTargetRelatedZone";
		var funcMethod = "GET";
		var requiredParameters = [
			"targetId"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.findHomography = function(parameters){
		var funcName = "findHomography";
		var funcMethod = "GET";
		var requiredParameters = [
			"source",
			"destination"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getCloudStorageStatus = function(parameters){
		var funcName = "getCloudStorageStatus";
		var funcMethod = "GET";
		var requiredParameters = [
			"provider"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getAnnounceEventList = function(){
		var parameters = {};
		var funcName = "getAnnounceEventList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.countAnnouncedEvents = function(){
		var parameters = {};
		var funcName = "countAnnouncedEvents";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventInfo = function(parameters){
		var funcName = "getEventInfo";
		var funcMethod = "GET";
		var requiredParameters = [
			"eventId"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getAnnounceRoleUserList = function(){
		var parameters = {};
		var funcName = "getAnnounceRoleUserList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getCameraDowntime = function(parameters){
		var funcName = "getCameraDowntime";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList",
			"startTime",
			"endTime"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getCameraDowntimeSummary = function(parameters){
		var funcName = "getCameraDowntimeSummary";
		var funcMethod = "GET";
		var requiredParameters = [
			"objList",
			"startTime",
			"endTime",
			"granularity"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.testLDAP = function(){
		var parameters = {};
		var funcName = "testLDAP";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventSourceParametersList = function(parameters){
		var funcName = "getEventSourceParametersList";
		var funcMethod = "GET";
		var requiredParameters = [
			"id"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getEventPolicyList = function(){
		var parameters = {};
		var funcName = "getEventPolicyList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventSourceWorkflowList = function(parameters){
		var funcName = "getEventSourceWorkflowList";
		var funcMethod = "GET";
		var requiredParameters = [
			"eventpolicy_id",
			"eventsource_id"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getEventPolicy = function(parameters){
		var funcName = "getEventPolicy";
		var funcMethod = "GET";
		var requiredParameters = [
			"id"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.hasConnectToLicenseServer = function(){
		var parameters = {};
		var funcName = "hasConnectToLicenseServer";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getLicenseAttributesList = function(){
		var parameters = {};
		var funcName = "getLicenseAttributesList";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.getContentDeliveryDetails = function(parameters){
		var funcName = "getContentDeliveryDetails";
		var funcMethod = "GET";
		var requiredParameters = [
			"objs"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getSMWriterConf = function(){
		var parameters = {};
		var funcName = "getSMWriterConf";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.getLoginInfo = function(){
		var parameters = {};
		var funcName = "getLoginInfo";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.logout = function(){
		var parameters = {};
		var funcName = "logout";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.version = function(){
		var parameters = {};
		var funcName = "version";
		var funcMethod = "GET";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.addObject = function(parameters){
		var funcName = "addObject";
		var funcMethod = "POST";
		var requiredParameters = [
			"type",
			"attributes"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.deleteCamera = function(parameters){
		var funcName = "deleteCamera";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.deleteObject = function(parameters){
		var funcName = "deleteObject";
		var funcMethod = "POST";
		var requiredParameters = [
			"objList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setAttributes = function(parameters){
		var funcName = "setAttributes";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj",
			"attributes"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setIdentityAttributes = function(parameters){
		var funcName = "setIdentityAttributes";
		var funcMethod = "POST";
		var requiredParameters = [
			"attributes"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.deleteBlocks = function(parameters){
		var funcName = "deleteBlocks";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj",
			"blockIdList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setBlock = function(parameters){
		var funcName = "setBlock";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.changeObjectList = function(parameters){
		var funcName = "changeObjectList";
		var funcMethod = "POST";
		var requiredParameters = [
			"parentobj"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setPermission = function(parameters){
		var funcName = "setPermission";
		var funcMethod = "POST";
		var requiredParameters = [
			"roleid",
			"setid",
			"permission"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setSpecialCredentials = function(parameters){
		var funcName = "setSpecialCredentials";
		var funcMethod = "POST";
		var requiredParameters = [
			"roleid",
			"setid",
			"credentials"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.createCameraAssociatedDevices = function(parameters){
		var funcName = "createCameraAssociatedDevices";
		var funcMethod = "POST";
		var requiredParameters = [
			"cameraid",
			"attributes"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.invokeMethod = function(parameters){
		var funcName = "invokeMethod";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj",
			"methodname"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.createCertificateRequest = function(parameters){
		var funcName = "createCertificateRequest";
		var funcMethod = "POST";
		var requiredParameters = [
			"requestParameters"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.installCertificate = function(parameters){
		var funcName = "installCertificate";
		var funcMethod = "POST";
		var requiredParameters = [
			"certificate"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.addAuditRecord = function(parameters){
		var funcName = "addAuditRecord";
		var funcMethod = "POST";
		var requiredParameters = [
			"category",
			"paramsJSON"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.saveObjectsOnSchedule = function(parameters){
		var funcName = "saveObjectsOnSchedule";
		var funcMethod = "POST";
		var requiredParameters = [
			"scheduleid",
			"oldobjlist",
			"objlist"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.releasePosture = function(parameters){
		var funcName = "releasePosture";
		var funcMethod = "POST";
		var requiredParameters = [
			"scheduleid",
			"postureid",
			"timecardid"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setScheduleInfo = function(parameters){
		var funcName = "setScheduleInfo";
		var funcMethod = "POST";
		var requiredParameters = [
			"scheduleInfo"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.convertScheduleInfoToEventSource = function(parameters){
		var funcName = "convertScheduleInfoToEventSource";
		var funcMethod = "POST";
		var requiredParameters = [
			"scheduleid",
			"scheduleInfo",
			"datefrom",
			"dateto"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.sendAttributesBySMS = function(parameters){
		var funcName = "sendAttributesBySMS";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj",
			"attributes"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} [parameters]
	 * @returns {Deferred}
	 */
	API.prototype.stopSession = function(parameters){
		var funcName = "stopSession";
		var funcMethod = "POST";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setPassword = function(parameters){
		var funcName = "setPassword";
		var funcMethod = "POST";
		var requiredParameters = [
			"userid",
			"password"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.changePassword = function(parameters){
		var funcName = "changePassword";
		var funcMethod = "POST";
		var requiredParameters = [
			"currentPassword",
			"newPassword"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.setMetadataInfo = function(parameters){
		var funcName = "setMetadataInfo";
		var funcMethod = "POST";
		var requiredParameters = [
			"metaname",
			"ttl",
			"color",
			"font",
			"style",
			"height",
			"align",
			"valign"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.submitAction = function(parameters){
		var funcName = "submitAction";
		var funcMethod = "POST";
		var requiredParameters = [
			"name",
			"parameters",
			"properties"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.announceEventToRole = function(parameters){
		var funcName = "announceEventToRole";
		var funcMethod = "POST";
		var requiredParameters = [
			"eventid",
			"roleid"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.announceEventToUser = function(parameters){
		var funcName = "announceEventToUser";
		var funcMethod = "POST";
		var requiredParameters = [
			"eventid",
			"useridList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.markAnnounceEventAsRead = function(parameters){
		var funcName = "markAnnounceEventAsRead";
		var funcMethod = "POST";
		var requiredParameters = [
			"eventList"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.registerOpenVPNClient = function(parameters){
		var funcName = "registerOpenVPNClient";
		var funcMethod = "POST";
		var requiredParameters = [
			"csr"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.addEventPolicy = function(parameters){
		var funcName = "addEventPolicy";
		var funcMethod = "POST";
		var requiredParameters = [
			"name",
			"description",
			"eventsource_workflow_parameters",
			"eventpolicystorage"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.editEventPolicy = function(parameters){
		var funcName = "editEventPolicy";
		var funcMethod = "POST";
		var requiredParameters = [
			"id",
			"name",
			"description",
			"eventsource_workflow_parameters",
			"eventpolicystorage"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.deleteEventPolicy = function(parameters){
		var funcName = "deleteEventPolicy";
		var funcMethod = "POST";
		var requiredParameters = [
			"id"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @returns {Deferred}
	 */
	API.prototype.acceptLicense = function(){
		var parameters = {};
		var funcName = "acceptLicense";
		var funcMethod = "POST";
		var requiredParameters = [
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.activateSerialNumber = function(parameters){
		var funcName = "activateSerialNumber";
		var funcMethod = "POST";
		var requiredParameters = [
			"serialNumber"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.createPCID = function(parameters){
		var funcName = "createPCID";
		var funcMethod = "POST";
		var requiredParameters = [
			"serialNumber"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.execAvatarExternalCommand = function(parameters){
		var funcName = "execAvatarExternalCommand";
		var funcMethod = "POST";
		var requiredParameters = [
			"obj",
			"commandName"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

	/**
	 * @param {Object} parameters
	 * @returns {Deferred}
	 */
	API.prototype.login = function(parameters){
		var funcName = "login";
		var funcMethod = "POST";
		var requiredParameters = [
			"name",
			"credentials"
		];
		return this._send(funcName, funcMethod, parameters, requiredParameters);
	};

})(window);
