/**
 * @version $Id: amq.api.js 30482 2014-04-14 15:31:51Z astarostin $
 * ------------------------------------------------------------------------------
 * create global window.AMQ object for manipulating with server AMQ services
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

/**
* AMQ with jQuery 1.7's $.Callbacks().
*/

(function (window){
	"use strict";

	// if not in frame
	if (window.self === window.top) {
		/**
		 * @type {AMQ_API}
		 */
		window.AMQ = window.AMQ || new AMQ_API();
	} else {
		window.AMQ = window.top.AMQ;
	}


	/**
	 * @constructor
	 */
	function AMQ_API()
	{
		this._topics = {};

		this._fail = $.Callbacks();

		this._amq = org.activemq.Amq;
		this._amq.init({
			uri: '/api/amq',
			logging: true,
			timeout: 30,
			pollDelay: 1500,
			clientId: Date.now().toString(),
			fail: this._fail.fire
		});

		/**
		 * subscribe for errors
		 *
		 * @param {function} callback
		 * @returns {AMQ_API}
		 */
		this.fail = function(callback)
		{
			this._fail.add(callback);

			return this;
		};

		/**
		 * subscribe for topic/queue
		 *
		 * @param {string} destination topic/queue name
		 * @param {function} callback function
		 * @returns {AMQ_API}
		 */
		this.subscribe = function(destination, callback)
		{
			if (!destination) return this;

			var topic = this._topics[destination];
			var id = Math.floor(Math.random() * 100000000);
			if (!topic)
			{
				topic = {
					id: id,
					callbacks: $.Callbacks()
				};
				this._topics[destination] = topic;
			}

			topic.callbacks.add(callback);
			this._amq.addListener(topic.id, destination, topic.callbacks.fire);

			return this;
		};

		/**
		 * subscribe from topic/queue
		 *
		 * @param {string} destination topic/queue name
		 * @returns {AMQ_API}
		 */
		this.unsubscribe = function(destination)
		{
			if (!destination) return this;
			var topic = this._topics[destination];

			if (topic)
			{
				this._amq.removeListener(topic.id, destination);

				topic.callbacks.empty();
				delete this._topics[destination];
			}

			return this;
		};

		/**
		 * publish message to topic/queue
		 *
		 * @param {string} destination topic/queue name
		 * @param {string} message
		 * @returns {AMQ_API}
		 */
		this.publish = function(destination, message)
		{
			if (!destination) return this;

			this._amq.sendMessage(destination, message);

			return this;
		};
	}

})(window);
