var gMap = null;

$(document).ready(function()
{
	gMap = new GMap();

	var parameters = {
		fovX: 19.52622383,
		fovY: 14.70678998,
		tiltAngel: -3.97,
		azimuthAngle: 270,
		latitude: 38.88972222,
		longitude: -77.01055556,
		height: 1.5, // height relative to ground
		resolution: {
			width: 640,
			height: 480
		}
	};
	gMap.setCameraParameters(parameters);

	gMap.setParameters({
		requestToGE: true
	});

	gMap.init("map");

	$("#markCorners").click(function(){
		gMap.getVisiblePlane()
			.done(function(target1, target2, target3, target4){
				Log.info(target1);
				gMap.addMarker(new google.maps.LatLng(target1[0], target1[1]), target1[2] + " " + target1[3]);

				Log.info(target2);
				gMap.addMarker(new google.maps.LatLng(target2[0], target2[1]), target2[2] + " " + target2[3]);

				Log.info(target3);
				gMap.addMarker(new google.maps.LatLng(target3[0], target3[1]), target3[2] + " " + target3[3]);

				Log.info(target4);
				gMap.addMarker(new google.maps.LatLng(target4[0], target4[1]), target4[2] + " " + target4[3]);
			});
	});
});
