var useMap = false;
if (!useMap) {
	google.load("earth", "1");
}

// All angle formal arguments are in degrees
function GeoT (camLat, camLong, camH, resX, resY) {
	this.origin = new google.maps.LatLng(camLat, camLong);

	this.camLat = camLat * Math.PI / 180;
	this.camLong = camLong * Math.PI / 180;
	this.camH = camH;
	this.resX = resX;
	this.resY = resY;

	this.horizon = 8000;

	this.cameraShown = false;

	if (useMap) {
		this.map = new google.maps.Map(
		document.getElementById("map3d"),
		{
zoom: 16,
center: this.origin,
mapTypeId: google.maps.MapTypeId.ROADMAP
		}
		);
	} else { // Using GE plugin
		myGeoT = this;
		
		google.earth.createInstance('map3d', initCB, failureCB);

		function initCB(instance) {
			myGeoT.ge = instance;
			myGeoT.ge.getWindow().setVisibility(true);
		}

		function failureCB(errorCode) {
			alert("failed earth instance! " + errorCode);
		}
	}

	this.iw = new google.maps.InfoWindow({'content': document.createElement('div')});    
}   

GeoT.prototype.setMarker = function (lat, lng, H0, target, distance) {	

	if (!this.cameraShown) {
		this.cameraShown = true;
		this.setMarker(this.origin.lat(), this.origin.lng(), 0, 0);
	}

	if (!useMap) {
		// Create the placemark.
		var placemark = this.ge.createPlacemark('');

		// Set the placemark's location.  
		var point = this.ge.createPoint('');
		point.setLatitude(lat);
		point.setLongitude(lng);
		placemark.setGeometry(point);
		
		// Define a custom icon.
		var icon = this.ge.createIcon('');
		icon.setHref('http://maps.google.com/mapfiles/kml/paddle/red-circle.png');
		var style = this.ge.createStyle(''); //create a new style
		style.getIconStyle().setIcon(icon); //apply the icon to the style
		placemark.setStyleSelector(style); //apply the style to the placemark
		
		// Add the placemark to Earth.
		this.ge.getFeatures().appendChild(placemark);
		
		myGeoT = this;
		
		google.earth.addEventListener(placemark, 'click', function(event) {
			// Prevent the default balloon from popping up.
			event.preventDefault();

			var balloon = myGeoT.ge.createHtmlStringBalloon('');
			balloon.setFeature(placemark); 
			if (target > 0) 
			balloon.setContentString("Target elevation is " + target.toFixed(2) + " meters.<br/>Camera height is " + H0.toFixed(2) + ".<br />Distance cca " + distance.toFixed(0));
			else
			baloon.setContentString("Camera");
			myGeoT.ge.setBalloon(balloon);
		});
		
		// Get the current view
		var lookAt = this.ge.getView().copyAsLookAt(this.ge.ALTITUDE_RELATIVE_TO_GROUND);

		// Set new latitude and longitude values
		lookAt.setLatitude(lat);
		lookAt.setLongitude(lng);

		lookAt.setRange(1200);

		// Update the view in Google Earth
		this.ge.getView().setAbstractView(lookAt);
		
		return;
	}

	var pos = new google.maps.LatLng(lat, lng);

	var marker = new google.maps.Marker({
position: pos, 
map: this.map
	});

	if (target > 0) {
		marker.setTitle("Target elevation is " + target.toFixed(2) + " meters.\nCamera height is " + H0.toFixed(2) + ".\nDistance cca " + distance.toFixed(0) + " meters.");
		this.iw.setContent("Target elevation is " + target.toFixed(2) + " meters.<br/>Camera height is " + H0.toFixed(2) + ".<br />Distance cca " + distance.toFixed(0));
		this.iw.setPosition(pos);
		this.iw.open(this.map);    
	} 
	else {
		marker.setTitle("Camera");
	}
}    

GeoT.prototype.setHorizon = function (hor) {
	this.horizon = hor;
}

GeoT.prototype.tagTarget = function (FOV_XDeg, FOV_YDeg, camTiltDeg, camAzDeg, pixX, pixY) {
	var FOV_X = FOV_XDeg * Math.PI / 180;
	var FOV_Y = FOV_YDeg * Math.PI / 180;

	var R = 6371000; // mean radius of Earth, in meters

	// Current version, based on FOV data, vertical and horizontal
	var pixTilt = camTiltDeg * Math.PI / 180 + Math.atan(Math.tan(FOV_Y/2)*(pixY+1 - this.resY/2 - 0.5)/(this.resY/2));	

	var pixAz = camAzDeg * Math.PI / 180 + Math.atan(Math.tan(FOV_X/2)*(pixX+1 - this.resX/2 - 0.5)/(this.resX/2));

	// Our "ray" is 8 kilometers, we have 16 meters "precision". Google Elevation API limitation - single query returns up to 512 points.
	// I can implement this with smaller step, but I don't think Google data is any better than this -- dd.
	// For other situations, vary horizon only.

	var samples = 500;

	var horizonLat = Math.asin(
	Math.sin(this.camLat) * Math.cos(this.horizon/R) + Math.cos(this.camLat) * Math.sin(this.horizon/R) * Math.cos(pixAz)
	);

	var horizonLong = this.camLong + Math.atan2(
		Math.sin(pixAz) * Math.sin(this.horizon/R) * Math.cos(this.camLat), 
		Math.cos(this.horizon/R) - Math.sin(this.camLat) * Math.sin(horizonLat)
	);

	var horizLoc = new google.maps.LatLng(horizonLat * 180 / Math.PI, horizonLong * 180 / Math.PI);

	// Solving "this" ambiguity in anonymous function beneath
	var camH = this.camH;
	var horizon = this.horizon;
	var myGeoT = this;

	var es = new google.maps.ElevationService();
	var pReq = { 
		'path': [ this.origin, horizLoc ], 
		'samples': samples
	};
	es.getElevationAlongPath(pReq, function(results, status) {
		if (status == google.maps.ElevationStatus.OK) {
			var H0 = results[0].elevation + camH; // camera height
			var Hn;
			var distance;

			for (i = 1; i < samples; i++) {
				distance = horizon/samples * i;
				Hn = - distance * Math.sin(pixTilt) + H0;
				if (Hn <= results[i].elevation) {
					if (myGeoT.markerCallback) { // send results to caller or other parties
						myGeoT.markerCallback (results[i].location.lat(), results[i].location.lng(), results[i].elevation, distance);
					}

					myGeoT.setMarker(results[i].location.lat(), results[i].location.lng(), H0, results[i].elevation, distance);
					break;
				}
			}
		} else {
			alert("Elevation service failed due to: " + status);
		}
	});

	window.focus(); // Push map/ge window on top. Must be outside of callback method.
}

