<html>
<head>
	<META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">

	<script src="http://maps.google.com/maps/api/js?sensor=false"></script>
	<script>

		var myGeoT;

		var ge;
		var userId = null;
		var cookiePhpSessId = null;

		function init()
		{
			var resX = 640;
			var resY = 480;
			var camLatDeg = 38.88972222;
			var camLongDeg = -77.01055556;
			var camH = 1.5;

			myGeoT = new GeoT(camLatDeg, camLongDeg, camH, resX, resY);
			myGeoT.setHorizon(8000);

			var FOV_X = 19.52622383;
			var FOV_Y = 14.70678998;
			var camTiltDeg = 3.97;
			var camAzDeg = 270;

			var pixX = 320;
			var pixY = 240;

			myGeoT.tagTarget(FOV_X, FOV_Y, camTiltDeg, camAzDeg, pixX, pixY);
		}

		var useMap = false;

		// All angle formal arguments are in degrees
		function GeoT(camLat, camLong, camH, resX, resY)
		{
			this.origin = new window.google.maps.LatLng(camLat, camLong);

			this.camLat = camLat * Math.PI / 180;
			this.camLong = camLong * Math.PI / 180;
			this.camH = camH;
			this.resX = resX;
			this.resY = resY;

			this.horizon = 8000;

			this.cameraShown = false;

			if (useMap)
			{
				this.map = new google.maps.Map(
					document.getElementById("map3d"),
					{
						zoom:16,
						center:this.origin,
						mapTypeId:google.maps.MapTypeId.ROADMAP
					}
				);
			} else
			{ // Using GE plugin
				myGeoT = this;
			}
			this.iw = new google.maps.InfoWindow({'content':document.createElement('div')});
		}

		GeoT.prototype.setHorizon = function(hor)
		{
			this.horizon = hor;
		};

		GeoT.prototype.tagTarget = function(FOV_XDeg, FOV_YDeg, camTiltDeg, camAzDeg, pixX, pixY)
		{
			var FOV_X = FOV_XDeg * Math.PI / 180;
			var FOV_Y = FOV_YDeg * Math.PI / 180;

			var R = 6371000; // mean radius of Earth, in meters

			// Current version, based on FOV data, vertical and horizontal
			var pixTilt = camTiltDeg * Math.PI / 180 + Math.atan(Math.tan(FOV_Y / 2) * (pixY + 1 - this.resY / 2 - 0.5) / (this.resY / 2));

			var pixAz = camAzDeg * Math.PI / 180 + Math.atan(Math.tan(FOV_X / 2) * (pixX + 1 - this.resX / 2 - 0.5) / (this.resX / 2));

			// Our "ray" is 8 kilometers, we have 16 meters "precision". Google Elevation API limitation - single query returns up to 512 points.
			// I can implement this with smaller step, but I don't think Google data is any better than this -- dd.
			// For other situations, vary horizon only.

			var samples = 500;

			var horizonLat = Math.asin(
				Math.sin(this.camLat) * Math.cos(this.horizon / R) + Math.cos(this.camLat) * Math.sin(this.horizon / R) * Math.cos(pixAz)
			);

			var horizonLong = this.camLong + Math.atan2(
				Math.sin(pixAz) * Math.sin(this.horizon / R) * Math.cos(this.camLat),
				Math.cos(this.horizon / R) - Math.sin(this.camLat) * Math.sin(horizonLat)
			);

			var horizLoc = new google.maps.LatLng(horizonLat * 180 / Math.PI, horizonLong * 180 / Math.PI);

			// Solving "this" ambiguity in anonymous function beneath
			var camH = this.camH;
			var horizon = this.horizon;
			var myGeoT = this;

			var es = new google.maps.ElevationService();
			var pReq = {
				'path':[ this.origin, horizLoc ],
				'samples':samples
			};

			es.getElevationAlongPath(pReq, function(results, status)
			{
				if (status == google.maps.ElevationStatus.OK)
				{
					var H0 = results[0].elevation + camH; // camera height
					var Hn;
					var distance;

					for (i = 1; i < samples; i++)
					{
						distance = horizon / samples * i;
						Hn = -distance * Math.sin(pixTilt) + H0;
						if (Hn <= results[i].elevation)
						{
							if (myGeoT.markerCallback)
							{ // send results to caller or other parties
								myGeoT.markerCallback(results[i].location.lat(), results[i].location.lng(), results[i].elevation, distance);
							}
							//myGeoT.setMarker(results[i].location.lat(), results[i].location.lng(), H0, results[i].elevation, distance);
							break;
						}
					}
				} else
				{
					alert("Elevation service failed due to: " + status);
				}
			});
		};

		GeoT.prototype.markerCallback = function(la, lo, al, dd)
		{
			alert("latitude: " + la + "\n longitude: " + lo + "\n elevation: " + al + "\n distance: " + dd);
		};
	</script>
</head>

<body onload="init();">
	<div id="map3d" style="width: 1000px; height: 570px;"></div>
</body>
</html>
