/**
 * User: abaev
 * Date: 15.10.2010
 * Time: 15:17:39
 */

/*
 get 3D models list
 */
function get_3d_models_data(arr_models, on_success) {
    $.ajax({
        url: "/api/call.php",
        async: true,
        dataType: 'json',
        data: {'function': 'getObjectList', 'type': 'model3d', 'withAttributes': true},
        success: function(json){
            if (json.error != '') {
                alert(__("Error on 3d models get: ") + json.error);
            }
            else {
                for (var i = 0; i < json.list.length; i++) {
                    set_model_data(arr_models, json.list[i]);
                    get_model_layers(json.list[i].obj, arr_models, null);
                }
            }
            if(on_success){
                on_success(json);
            }
        }
    });
}

/*
 add layers for object
 */
function get_model_layers(model_id, arr_models, on_success) {
    $.ajax({
        url: "/api/call.php",
        async: true,
        dataType: 'json',
        data: {
            'function': 'getObjectList',
            'type': 'modellayer',
            'parentObj': model_id,
            'withAttributes': true,
            'withBlocks': true
        },
        success: function(json){
            if (json.error != '') {
                alert(__("Error on 3d models layers get: ") + json.error);
            }
            else {
                set_model_layers(arr_models, model_id, json.list);
                if(on_success){
                    on_success(json);
                }
            }
        }
    });
}

/*
 set model data
 */
function set_model_data(arr_models_list, model) {
    arr_models_list.push(model);
}

/*
 set model data
 */
function set_model_layers(arr_models_list, model_id, layers) {
    for (var i = 0; i < arr_models_list.length; i++) {
        if(arr_models_list[i].obj == model_id){
            arr_models_list[i].layers = layers;
        }
    }
}

/*
 get model data by object id
 */
function get_model_data_by_id(arr_models_list, obj_id) {
    for (var i = 0; i < arr_models_list.length; i++) {
        if (arr_models_list[i].obj == obj_id) {
            return arr_models_list[i];
        }
    }
    return null;
}

/*
 get model placemarks by object id
 */
function get_model_placemarks_by_id(arr_models_list, obj_id) {
    var placemarks = [];
    for (var i = 0; i < arr_models_list.length; i++) {
        if (arr_models_list[i].obj == obj_id) {
            for (var j = 0; j < arr_models_list[i].layers.length; j++) {
                var placemark = get_layer_placemark(arr_models_list[i].layers[j].obj);
                if(placemark != null){
                    placemarks.push(placemark);
                }
            }
        }
    }
    return placemarks;
}

/*
 get model layer data by object id
 */
function get_model_layer_data_by_id(arr_models_list, model_obj_id, layer_obj_id) {
    for (var i = 0; i < arr_models_list.length; i++) {
        if (arr_models_list[i].obj == model_obj_id) {
            if(arr_models_list[i].layers == undefined){
                return null;
            }
            for (var j = 0; j < arr_models_list[i].layers.length; j++) {
                if (arr_models_list[i].layers[j].obj == layer_obj_id) {
                    return arr_models_list[i].layers[j];
                }
            }
        }
    }
    return null;
}

/*
 load all kml layers files
 */
function load_all_layers_files(obj_3d_models_list, obj_3d_models_placemarks) {
    for(var i = 0; i < obj_3d_models_list.length; i++){
        var model = obj_3d_models_list[i];
        if(model.layers){
            for(var j = 0; j < model.layers.length; j++){
                if(!$.isEmptyObject(model.layers[j].blocks)){
                    load_layer_file(model.layers[j], obj_3d_models_placemarks);
                }
            }
        }
    }
}

/*
 load layer file
 */
function load_layer_file(layer_data, arr_placemarks, hidden) {
    var block_url = '';
    var url_prefix = jsServerProto + "://" + jsServerName;
    if (jsServerPort != 80) {
        url_prefix += ":" + jsServerPort;
    }

    for (var block in layer_data.blocks) {
        block_url = layer_data.blocks[block];
    }

    if (block_url == '') {
        alert(__("Wrong layer file URL!"));
        return;
    }

    var link = url_prefix + block_url;

    google.earth.fetchKml(ge, link, function(kmlObj){
        //alert("link="+link+", kmlObj="+kmlObj);
        if(kmlObj){
            ge.getFeatures().appendChild(kmlObj);
            var placemark = kmlObj.getFeatures().getLastChild();
            set_layer_placemark(arr_placemarks, layer_data.obj.toString(), placemark);

            if(hidden){
                placemark.setVisibility(false);
            }
            //alert("kml added: "+kmlObj.getKML());
        } else {
            // wrap alerts in API callbacks and event handlers
            // in a setTimeout to prevent deadlock in some browsers
            setTimeout(function() {
                alert(__("Bad or null KML. url=")+link);
            }, 0);
        }
     });
}

/*
 set layer placemark by layer id
 */
function set_layer_placemark(arr_placemarks, obj_id, placemark){
    arr_placemarks[obj_id] = placemark;
    //if(parent.jsDebug){ parent.appLogger.info("set_layer_placemark: obj_id= " + obj_id + ", placemark="+placemark); }
}

/*
 get layer placemark by layer id
 */
function get_layer_placemark(obj_placemarks, obj_id){
    for(var id in obj_placemarks){
        //if(parent.jsDebug){ parent.appLogger.info("get_layer_placemark: obj_id= " + obj_id + ", id="+id); }
        if(obj_id == id){
            return obj_placemarks[id];
        }
    }
    return null;
}

/*
 remove layer placemark by layer id
 */
function remove_layer_placemark(arr_placemarks, obj_id){
    for(var id in arr_placemarks){
        if(obj_id == id){
            delete arr_placemarks[id];
            return true;
        }
    }
    return null;
}

/*
 hide all placemarks
 */
function hide_all_placemarks(){
    var all_placemarks = ge.getFeatures().getChildNodes();
    for (var i = 0; i < all_placemarks.getLength(); i++) {
        all_placemarks.item(i).setVisibility(false);
    }
}

/*
 hide all models placemarks
 */
function hide_all_models_placemarks(obj_placemarks){
    for(var id in obj_placemarks){
        obj_placemarks[id].setVisibility(false);
    }
}

/*
 calculate floor height
 */
function calculate_layer_height(model, cur_layer){
    var layer_height = 0;

    for(var i = 0; i < model.layers.length; i++){
        if(model.layers[i].attributes.NUMBER < cur_layer.attributes.NUMBER){
            var cur_layer_height = 0;
            if(model.layers[i].attributes.LAYER_HEIGHT != ""){
                cur_layer_height = model.layers[i].attributes.LAYER_HEIGHT;
            }
            else{
                cur_layer_height = model.attributes.DEFAULT_LAYER_HEIGHT;
            }
            layer_height+= parseFloat(cur_layer_height);
        }
    }
    return layer_height;
}