/**
 * GEO functions
 * User: abaev
 * Date: 14.10.2010
 * Time: 16:32:17
 */

/*
 calculate coordinates by distance and radial
 */
function latlonByDistanceRadial(lat_c, lon_c, distance, radial) {
    var lat1 = lat_c * Math.PI / 180;
    var lon1 = lon_c * Math.PI / 180;
    var d = distance * Math.PI / (180 * 60);
    var lat2 = Math.asin(Math.sin(lat1) * Math.cos(d) + Math.cos(lat1) * Math.sin(d) * Math.cos(radial));
    var lon2 = lon1 + Math.atan2(Math.sin(radial) * Math.sin(d) * Math.cos(lat1), Math.cos(d) - Math.sin(lat1) * Math.sin(lat2));
    var result = [];
    result[0] = lat2 * 180 / Math.PI;
    result[1] = lon2 * 180 / Math.PI;
    return result;
}

/**
 * calculate distance between two points
 *
 * @param {number} lat1 in radians
 * @param {number} lon1 in radians
 * @param {number} lat2 in radians
 * @param {number} lon2 in radians
 * @returns {number}
 */
function distanceBetween2Points(lat1, lon1, lat2, lon2) {
    return 2 * Math.asin(Math.sqrt(Math.sin((lat1 - lat2) / 2) * Math.sin((lat1 - lat2) / 2) +
            Math.cos(lat1) * Math.cos(lat2) * ( Math.sin((lon1 - lon2) / 2) * Math.sin((lon1 - lon2) / 2))));
}

/*
 Converts numeric degrees to radians
*/
function toRad(Value) {
    return Value * Math.PI / 180;
}

/*
 Converts numeric radians to degrees
*/
function toDeg(Value) {
    return Value * 180 / Math.PI;
}

/**
 * calculate azimuth
 *
 * @param {number} lat1 in radians
 * @param {number} lon1 in radians
 * @param {number} lat2 in radians
 * @param {number} lon2 in radians
 * @returns {number}
 */
function calcAzimuth(lat1, lon1, lat2, lon2){
	//var x0 = 0, y0 = 0;

	//var ab = distanceBetween2Points(x0, y0, x1, y1);
	//var bc = distanceBetween2Points(x1, y1, x2, y2);
	//var ac = distanceBetween2Points(x0, y0, x2, y2);
	//var angle = Math.acos((Math.pow(ab,2) + Math.pow(ac,2) - Math.pow(bc,2))/(2*ab*ac));

	//Grad := Rad * 180 / Pi;
	//angle = angle * 180 / Math.PI;

	//var R = 6371; // km
	//var dLat = (lat2-lat1).toRad();
	var dLon = toRad(lon2 - lon1);
	lat1 = toRad(lat1);
	lat2 = toRad(lat2);

	//var a = Math.sin(dLat/2) * Math.sin(dLat/2) + Math.sin(dLon/2) * Math.sin(dLon/2) * Math.cos(lat1) * Math.cos(lat2);
	//var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
	//var d = R * c;

	var y = Math.sin(dLon) * Math.cos(lat2);
	var x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
	var azimuth = toDeg(Math.atan2(y, x));

	return azimuth;
}

/**
 * calculate angle by two points
 *
 * @param {number} lat1 in radians
 * @param {number} lon1 in radians
 * @param {number} lat2 in radians
 * @param {number} lon2 in radians
 * @returns {number}
 */
function angleBy2Points(lat1, lon1, lat2, lon2) {
    var ang = 0.0;
    var eps = 0.00001;
    if (Math.cos(lat1) < eps) {
        if (lat1 > 0) {
            return Math.PI;
        }
        else {
            return 2 * Math.PI;
        }
    }
    var d = distanceBetween2Points(lat1, lon1, lat2, lon2);

    var der = Math.sin(d) * Math.cos(lat1);
    if (der != 0) {
        if (Math.sin(lon2 - lon1) < 0) {
            ang = Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(d)) / der);
        }
        else {
            ang = 2 * Math.PI - Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(d)) / der);
        }

        if (IsNumeric(ang)) {
            return ang;
        }
        else {
            return 0;
        }
    }
    else {
        return 0;
    }
}

/*
  calculate angle distance
  gaversinus
 */
function calcGEODistance(lat1, long1, lat2, long2) {
    //Earth radius
    var R = 6372795;

    //coords to radians
    lat1 *= Math.PI / 180;
    lat2 *= Math.PI / 180;
    long1 *= Math.PI / 180;
    long2 *= Math.PI / 180;

    //cos and sin
    var cl1 = Math.cos(lat1);
    var cl2 = Math.cos(lat2);
    var sl1 = Math.sin(lat1);
    var sl2 = Math.sin(lat2);
    var delta = long2 - long1;
    var cdelta = Math.cos(delta);
    var sdelta = Math.sin(delta);

    //length of circus
    var y = Math.sqrt(Math.pow(cl2 * sdelta, 2) + Math.pow(cl1 * sl2 - sl1 * cl2 * cdelta, 2));
    var x = sl1 * sl2 + cl1 * cl2 * cdelta;
    var ad = Math.atan2(y, x);
    var dist = ad * R; //distance in meters

    return dist
}

/*
 detect all cameras mass center
 */
function findRangeRadius(obj_ids){
		var x = 0;
		var y = 0;
		var geoDeviceCounter = 0;
		for(var i = 0; i < obj_ids.length; i++){
			if(window['device_' + obj_ids[i]] === undefined){
				continue;
			}
			var point = window['device_' + obj_ids[i]].point;
			x+=point.getLatitude();
			y+=point.getLongitude();
			geoDeviceCounter++;
		}
		x /= geoDeviceCounter;
		y /= geoDeviceCounter;

		//find radius
		var radius = 0;
		for(i = 0; i < obj_ids.length; i++){
			if(window['device_' + obj_ids[i]] === undefined){
				continue;
			}
			point = window['device_'+obj_ids[i]].point;
			if(radius < calcGEODistance(x,y,point.getLatitude(),point.getLongitude())){
				radius = calcGEODistance(x,y,point.getLatitude(),point.getLongitude());
			}
		}
		if(radius == 0){
			radius = 100;
		}

		var retObj = [];
		retObj['x'] = x;
		retObj['y'] = y;
		retObj['radius'] = radius;
		retObj['numOfDevices'] = geoDeviceCounter;
		return retObj;
}

/**
 * Check if input parameter is Numeric
 *
 * @param {*} n
 * @returns {boolean}
 */
function IsNumeric(n){
    return !isNaN(n);
}

/*
 get view data
 */
function get_view_data(){
	var ge_view = ge.getView().copyAsLookAt(ge.ALTITUDE_CLAMP_TO_GROUND);
	var data = {};
	data.lat = ge_view.getLatitude();
	data.lon = ge_view.getLongitude();
	data.alt = ge_view.getAltitude();
	data.range = ge_view.getRange();
	data.tilt = ge_view.getTilt();
	data.head = ge_view.getHeading();
	return data;
}

/*
 change earth view
 */
function change_view(lat, lon, alt, range, tilt, heading){
	if(!ge){
		return false;
	}

    var look = ge.getView().copyAsLookAt(ge.ALTITUDE_RELATIVE_TO_GROUND);

    if(lat){
        lat = parseFloat(lat);
        look.setLatitude(lat);
    }

    if(lon){
        lon = parseFloat(lon);
        look.setLongitude(lon);
    }

    if(alt){
        alt = parseFloat(alt);
        look.setAltitude(alt);
    }

    if(range){
        range = parseFloat(range);
        look.setRange(range);
    }

    if(tilt){
        tilt = parseFloat(tilt);
        look.setTilt(tilt);
    }

    if(heading){
        heading = parseFloat(heading);
        look.setHeading(heading);
    }

    ge.getView().setAbstractView(look);
}

/*
* check is maps loaded
* */
function is3DMapLoaded(){
    return !(ge === undefined || ge === null || !ge);
}
