	/**
	 * Handler of iframe JS errors; prevent IE error window popup,
	 * log errors into appLogger
	 * @param msg   error message
	 * @param url   url of script
	 * @param line  line of error
	 */
	window.onerror = function(msg, url, line)
	{
		window.console && window.console.error(url + ':' + line + ' - ' + msg);

		// finalize loading for IE (if connection error happened)
		return true;
	};

	if(ge_3d_mapping_mode == 'hosted')
	{
		if (!("google" in window)) { window.google = {}; }
		if (!("loader" in window.google)) { window.google.loader = {}; }
		if (!("earth" in window.google)) { window.google.earth = {}; }
		window.google.loader.ApiKey = ge_3d_mapping_hosted_key;
		window.google.loader.KeyVerified = true;
		window.google.earth.allowUsageLogging = false;
		window.google.earth.setErrorUrl("/sdi/ge/ge_error.php");
		//hide layers tweak for hosted version
		parent.mx.GE.hideEngineLayersTweak();
	} else {
		google.load("earth", "1");
	}

	$(document).ready(function(){
		if (google && google.loader.LoadFailure)
		{
			alert(__("Install Google Earth plugin first!"));
		}

		window.GEIFRAME = parent.mx.GE.designation.getGeIframe();
		parent.mx.GE.designation.targetCreateNew();

		if(ge_3d_mapping_mode == 'hosted')
		{
			init();
		} else {
			google.setOnLoadCallback(init);
		}
	});

	var isExist = true;

	var map;
	var gMap = null;
	var targetingIconsUrl = "/TibcoGI/JSXAPPS/mx/images/MIL-STD-2525C/";

	var ge = null;
	var gePlayerW = 400;
	var gePlayerH = 300;
	var camIDs = [];
	var ptzPresence = false;
	var alertObjects = [];
	var alertFlash = true;
	var iconStylePlain = null;
	var iconStyleRed = null;

	var cue_placemark_point = null;
	var cue_placemark_line = null;

    var jsServerProto = parent.jsServerProto;
    var jsServerName = parent.jsServerName;
    var jsServerPort = parent.jsServerPort;

    var kml_files_counter = 0;

	var ruler = false;
	var ruler_units = 'meters';
	var ruler_placemark_start = null;
	var ruler_placemark_end = null;
	var ruler_placemark_line = null;
	var ruler_placemark_arrow = null;
	var dragInfo = null;

	var zoom = false;
	var zoom_placemark_start = null;
	var	zoom_placemark_end = null;
	var	zoom_placemark_rectangle = null;

	var locations = {};
	var location_placemark = null;
	var location_need_callback = false;

    /*
    * set event to device
    * */
	function setNewEvent(obj_id, event_id){
        var objDev = window['device_'+obj_id];
		if( objDev && objDev != null && objDev.type == "camera"){
			objDev.event_id = event_id;

            var found = false;
			for(var i = 0; i < alertObjects.length; i++){
				if( alertObjects[i] == obj_id ){
                    found = true;
                }
            }

            if (!found) {
                alertObjects.push(obj_id);

                var icon = ge.createIcon('');
                icon.setHref(checkDeviceIconURL(objDev, true));
                var style = ge.createStyle('');
                style.getIconStyle().setIcon(icon);
                style.getIconStyle().setScale(0.75);
                objDev.placemark.setStyleSelector(style);

                geIconBlink();

                if ($("#id_a02").attr("name") == obj_id) {
                    var button = document.getElementById("id_a02");
                    button.onclick = balloonEventAknowledge;
                    button.disabled = false;
                    button.title = Gettext.strargs(__("Acknowledge Event id: %1"), [event_id]);
                }
            }
        }
	}

    /*
    * go to next alerted device
    * */
    function gotoNextAlert(){
        if(alertObjects.length > 0){
            var deviceData = window['device_'+alertObjects[0]];
			var lookAt = ge.createLookAt('');
			lookAt.setLatitude(deviceData.point.getLatitude());
			lookAt.setLongitude(deviceData.point.getLongitude());
			lookAt.setAltitude(deviceData.point.getAltitude());

			lookAt.setRange(deviceData.range);
			lookAt.setTilt(deviceData.tilt);
			lookAt.setHeading(deviceData.heading);
            ge.getView().setAbstractView(lookAt);

            removeAlertFromDevice(deviceData, 0)
        }
    }

    function removeAlertFromDevice(deviceData, alertId){
        var icon = ge.createIcon('');
        icon.setHref(checkDeviceIconURL(deviceData));
        var style = ge.createStyle('');
        style.getIconStyle().setIcon(icon);
        style.getIconStyle().setScale(0.75);
        deviceData.placemark.setStyleSelector(style);

        for(var i = 0; i < alertObjects.length; i++){
			if(alertId >= 0){
				if( alertObjects[i] == alertObjects[alertId] ) alertObjects.splice(i, 1);
			}
			else{
				if( alertObjects[i] == deviceData.obj_id ) alertObjects.splice(i, 1);
			}
        }

        //stop alert if no more alerts
        if(alertObjects.length == 0){
            parent.mx.GE.hideCellAlert();
        }
    }

	function acknowledgeEventSend(obj_id, event_id)
	{
		acknowledgeEventReceived(obj_id, event_id);
		parent.mx.ELog2.submitAction("Acknowledge", event_id, obj_id);
	}

	function acknowledgeEventReceived(obj_id)
	{
		if( window['device_'+obj_id] && (window['device_'+obj_id] != null) )
		{
			window['device_'+obj_id].event_id = null;

			if(document.getElementById("id_a02")){
				var button = document.getElementById("id_a02");
				button.onclick = null;
				button.disabled = true;
				button.title = __("No new events present");
			}

			removeAlertFromDevice(window['device_'+obj_id], -1)
		}
	}

	function gePopUpCamera(obj_id){
		parent.mx.ELog2.elM2DEventAckn(obj_id.toString());
	}

	function gePopUpCameraInNewTab(obj_id){
		var cameraName = window['device_'+obj_id].name.toString();
		var tab = parent.mx.CT.createNewTab();
		if(tab != null)
		{
			var objDest = tab.getFirstChild();
			tab.doShow();
			var newCell = null;
			newCell = parent.mx.MATRIX2.createCell(obj_id, cameraName, objDest, false);
			newCell.setAttribute("close_previous","false");
			newCell.setAttribute("dst_from", "0");
			newCell.setAttribute("dst_to", "0");
			window.setTimeout(function(){ parent.mx.MATRIX2.setSelectedGroup(newCell.getDescendantOfName("cell_select"),null,false); }, 10);
		}
	}

    /*
    * show 3D blinking on event
    * */
	function geIconBlink(){
        parent.mx.GE.showCellAlert();
	}

	function geTargetingSwitchLiveArchive(state) {
	/*
        if(state == "closed" || state == undefined){
            layout.setCols("*,0,200", true);
            button.setAttribute("state", "opened");
			button.setImage("jsxuser:///images/design1/m3d/m3d_interfaces_on.png");
			button.setTip(__("Close targets panel"));
        }
        else if(state == "opened"){
            layout.setCols("*,0,0", true);
            button.setAttribute("state", "closed");
			button.setImage("jsxuser:///images/design1/m3d/m3d_interfaces_off.png");
			button.setTip(__("Open targets panel"));
        }
	*/
	}

	/*
		enable/disable engine layers
	*/
	function toggleEngineLayers(layerType, layerState){
		switch(layerType){
			case "buildings":
				setEngineLayerVisibility(ge.LAYER_BUILDINGS, layerState);
				setEngineLayerVisibility(ge.LAYER_BUILDINGS_LOW_RESOLUTION, layerState);
				break;
			case "roads":
				setEngineLayerVisibility(ge.LAYER_ROADS, layerState);
				break;
			case "borders":
				setEngineLayerVisibility(ge.LAYER_BORDERS, layerState);
				break;
			case "trees":
				setEngineLayerVisibility(ge.LAYER_TREES, layerState);
				break;
			default:
				break;
		}
	}

	function setEngineLayerVisibility(layerId, layerState){
		if(ge_3d_mapping_mode != 'hosted'){
			ge.getLayerRoot().enableLayerById(layerId, layerState);
		}
	}

	function init()
	{
		var parameters = {};
		if (ge_3d_mapping_mode == 'hosted')
		{
			parameters = {database: ge_3d_mapping_hosted_datasource};
		}
		google.earth.createInstance('map3d', initCallback, failureCallback, parameters);
	}

	function ge_monitor(){
		if(google.loader.LoadFailure || !google.loader.KeyVerified || google.earth.e){
			parent.mx.MATRIX2.showMessage(__("3D maps"), __("Google Earth plugin crashed.<br />Component reloaded."));
			window.location.href = window.location.href;
		}
		else{
			window.setTimeout(function() { ge_monitor(); }, 20000);
		}
	}

	/**
	 *
	 * @param {GEPlugin} object
	 */
	function initCallback(object)
	{
		ge = object;

		ge.getOptions().setAtmosphereVisibility(true);
		ge.getOptions().setStatusBarVisibility(true);
		ge.getWindow().setVisibility(true);
		ge.getNavigationControl().setVisibility(ge.VISIBILITY_AUTO);

		// Display all features by default. Potentially - introduce feature switcher.
		var geFeatures = ge.getLayerRoot().getFeatures().getChildNodes();
		for(var i=0; i<geFeatures.getLength(); i++) {
			setEngineLayerVisibility(geFeatures.item(i).getId(), true);
		}

		// Hide Buildings
		setEngineLayerVisibility(ge.LAYER_BUILDINGS, false);
		setEngineLayerVisibility(ge.LAYER_BUILDINGS_LOW_RESOLUTION, false);

		// gMap init - using Google Maps Elevation Services to Geo-Reference video attributes (onClick pixels).
		gMap = new GMap();

		if(geNacoDemo)
		{
			geCreateGroundOverlayNacoDemo();
		}

        parent.mx.GE.setModelSelect(obj_3d_models_list);
        changeModelLayer(0, 0, false);

        displayDevConf();

		if(ge_default_view != ''){
			// set default view
			var view = ge_default_view.split(",");
			for(var i = 0; i < view.length; i++){
				view[i] = parseFloat(view[i]);
			}
			change_view(parseFloat(view[0]), parseFloat(view[1]), parseFloat(view[2]), parseFloat(view[3]), parseFloat(view[4]), parseFloat(view[5]));
		}

		// Listen for mousedown on the window (look specifically for point placemarks).
		google.earth.addEventListener(ge.getWindow(), 'mousedown', function(event) {
			if (event.getTarget().getType() == 'KmlPlacemark' && event.getTarget().getGeometry().getType() == 'KmlPoint' && (event.getTarget() == ruler_placemark_start || event.getTarget() == ruler_placemark_end)) {
				var placemark = event.getTarget();
				dragInfo = {
					placemark: event.getTarget(),
					dragged: false
				};
			}
		});

		// Listen for mousemove on the globe.
		google.earth.addEventListener(ge.getGlobe(), 'mousemove', function(event) {
			if (dragInfo != null) {
				event.preventDefault();
				var point = dragInfo.placemark.getGeometry();
				point.setLatitude(event.getLatitude());
				point.setLongitude(event.getLongitude());
				moveRulerLine();
				dragInfo.dragged = true;
			}
			else if(zoom && zoom_placemark_start != null && zoom_placemark_end != null){
				moveZoomEndpoint(event.getLatitude(), event.getLongitude());
				removeZoomRectangle();
				drawZoomRectangle();
			}
		});

        google.earth.addEventListener(ge.getWindow(), 'mouseup', function(event) {
			if (dragInfo) {
				if (dragInfo.dragged) {
					// If the placemark was dragged, prevent balloons from popping up.
					event.preventDefault();
				}

				moveRulerLine();
				calcRuler(dragInfo.placemark);
				dragInfo = null;
				return;
			}

			//move slue to cue by left mousebutton click
			if(cue_placemark_point != null && event.getButton() == 0){
				geSlew2CueChange(event.getLatitude(), event.getLongitude());
			}
			else if(ruler && ruler_placemark_start == null){
				drawRulerPoint(event.getLatitude(), event.getLongitude(), "start");
			}
			else if(ruler && ruler_placemark_end == null){
				drawRulerPoint(event.getLatitude(), event.getLongitude(), "end");
				drawRulerLine();
				calcRuler(ruler_placemark_end);
			}
			else if(zoom && zoom_placemark_start == null){
				drawZoomPoints(event.getLatitude(), event.getLongitude());
				drawZoomRectangle();
			}
			else if(zoom && zoom_placemark_start != null){
				zoomToRectangle();
				if(parent.mx){ parent.mx.GE.toggleZoom(); }
			}
			else if(location_need_callback){
				var geodata = {};
				geodata.lat = event.getLatitude();
				geodata.lon = event.getLongitude();
				geodata.alt = event.getAltitude();

				parent.mx.GE.onLocationCallback(geodata);
			}
		});
		ge_monitor();

		parent.Targeting.init(window.self);
		parent.Targeting.amqPing();

		targetingSceneRecycle();
	}

	function failureCallback(errorCode)
	{
		if (errorCode == "ERR_CREATE_PLUGIN") {
			console.error("Google Earth Plugin not installed");
    	} else {
			console.error("failure loading the Google Earth Plugin: " + errorCode);
    	}
	}

	// Input values in [Deg]
	var devGeo2Absolute = new function()
	{
		this.devLat =  0.0;
		this.devLon = 0.0;
		this.devAlt = 0.0;
		this.tarLat = 0.0;
		this.tarLon = 0.0;
		this.tarAlt = 0.0;
		this.offset = 0.0;

		this.dist = 0.0;
		this.an2p = 0.0;

		this.setParams = function (dLa, dLo, dAl, tLa, tLo, tAl, ofs)
		{
			this.devLat = this.degToRad(dLa);
			this.devLon = this.degToRad(dLo);
			this.devAlt = dAl;
			this.tarLat = this.degToRad(tLa);
			this.tarLon = this.degToRad(tLo);
			this.tarAlt = tAl;
			this.offset = ofs;

			this.dist = this.radToDeg(distanceBetween2Points(this.devLat, this.devLon, this.tarLat, this.tarLon)) * 60 * 1852.0; // [m]

            this.an2p = this.radToDeg(angleBy2Points(this.devLat, this.devLon, this.tarLat, this.tarLon)); // [deg]
		};

		// Calculate Pan angle - returns [deg]
		this.getPan = function ()
		{
            var tmpA = -1 * this.an2p;
            tmpA = Math.round( tmpA + this.offset);
            if(Math.abs(tmpA) > 180){
                if(tmpA > 0) { tmpA = -(360 - tmpA); } else { tmpA = 360 + tmpA; }
            }
			return tmpA;
		};

		// Calculate Tilt angle
		// Assunption: We don't use GE ElevationServices, which ommits target's elevation data.
		// 			   Calculations are in WGS84 model, which assumes target and camera locations are on sea level
		this.getTilt = function ()
		{
			if(this.devAlt <= 0) return 0.0;
			return -1 * this.radToDeg( Math.atan2(this.devAlt, this.dist) );
		};

		this.getDist = function ()
		{
			return this.dist;
		};

		this.getAn2p = function ()
		{
			return this.an2p;
		};

		this.degToRad = function(value)
		{
			return value * Math.PI / 180;
		};

		this.radToDeg = function(value)
		{
			return value * 180 / Math.PI;
		};
	};

	/*******************************
		Locations functionality
	********************************/
	function addLocationLinePoint(point){
		if(!location_placemark){
			var style = ge.createStyle('');
			style.getPolyStyle().getColor().set('7f00ff00');

			var lineStyle = style.getLineStyle();
			lineStyle.setWidth(3);
			lineStyle.getColor().set('f000ffff');

			var lineString = ge.createLineString('');
			lineString.setExtrude(true);
			//lineString.setTessellate(true);
			lineString.setAltitudeMode(ge.ALTITUDE_RELATIVE_TO_GROUND);

			lineString.getCoordinates().pushLatLngAlt(point.lat, point.lon, point.alt + 10);

			location_placemark = ge.createPlacemark('');
			location_placemark.setStyleSelector(style);
			location_placemark.setGeometry(lineString);

			ge.getFeatures().appendChild(location_placemark);
		}
		else{
			location_placemark.setName(name);
			location_placemark.getGeometry().getCoordinates().pushLatLngAlt(point.lat, point.lon, point.alt + 10);
		}
	}

	/*
		add location data in location list
	*/
	function addLocation(objLocation){
		locations[objLocation.obj] = objLocation;
	}

	/*
		show added locations
	*/
	function showLocations(){
		var view = null;
		var basePoint = null;
		var size = 0;
		for(var locId in locations){
			var location = locations[locId];
			if(location.type == 'point'){
				var icon = ge.createIcon('');
				var iconURL = parent.mx.MATRIX2.getServerURL() + "/TibcoGI/JSXAPPS/mx/images/design1/m3d/m3d_location_2525c.png";
				icon.setHref(iconURL);

				var style = ge.createStyle('');
				style.getIconStyle().setIcon(icon);
				style.getIconStyle().setScale(0.75);

				var point = ge.createPoint('');
				point.set(location.data[0].lat, location.data[0].lon, location.data[0].alt, ge.ALTITUDE_CLAMP_TO_GROUND, true, false);

				var newPlacemark = ge.createPlacemark('');
				newPlacemark.setName(location.name);
				newPlacemark.setStyleSelector(style);
				newPlacemark.setGeometry(point);

				ge.getFeatures().appendChild(newPlacemark);
				location.placemark = newPlacemark;

				view = location.view;
				basePoint = location.data[0];
			}
			else if(location.type == 'line'){
				var style = ge.createStyle('');
				style.getPolyStyle().getColor().set('7f00ff00');

				var lineStyle = style.getLineStyle();
				lineStyle.setWidth(3);
				lineStyle.getColor().set('f000ffff');

				var lineString = ge.createLineString('');
				lineString.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
				lineString.setExtrude(true);
				lineString.setTessellate(true);

				for(var point in location.data){
					if (!location.data.hasOwnProperty(point)) continue;
					lineString.getCoordinates().pushLatLngAlt(location.data[point].lat, location.data[point].lon, location.data[point].alt + 5);
				}

				var newPlacemark = ge.createPlacemark('');
				newPlacemark.setName(location.name);
				newPlacemark.setStyleSelector(style);
				newPlacemark.setGeometry(lineString);

				ge.getFeatures().appendChild(newPlacemark);
				location.placemark = newPlacemark;

				view = location.view;
				basePoint = location.data[0];
			}
			size++;
		}

		if(size == 1){
			change_view(view.lat, view.lon, view.alt, view.range, view.tilt, view.head);

			// if slew2cue is active, reposition it
			if(cue_placemark_point != null){
				geSlew2CueChange(basePoint.lat, basePoint.lon);
			}

			// Camera (selected from "Targeting panel", "Camera Id: <> to follow target") point at selected location
			if(parent.jsTargetingCameraToFollowTarget != "none")
			{
				var objDev = window['device_'+parent.jsTargetingCameraToFollowTarget];
				var dev_lat = objDev.point.getLatitude();
				var dev_lon = objDev.point.getLongitude();
				var dev_alt = objDev.point.getAltitude();
				var offset = objDev.offset_north;

				devGeo2Absolute.setParams(dev_lat, dev_lon, dev_alt, parseFloat(basePoint.lat), parseFloat(basePoint.lon), 0.0, offset);
				var anglePan = Math.round(devGeo2Absolute.getPan());
				var angleTilt = Math.round(devGeo2Absolute.getTilt());

				parent.mx.GE.callPTZmoveAbs(parent.jsTargetingCameraToFollowTarget, anglePan, angleTilt);

				objDev.azimuth = (-1) * devGeo2Absolute.getAn2p();
				cameraChangeFieldOfView(objDev);
			}
		}
	}

	function clearLocations(){
		for(var locId in locations){
			if (!locations.hasOwnProperty(locId)) continue;
			ge.getFeatures().removeChild(locations[locId].placemark);
		}
		locations = {};
	}

	/*
		Ruler functionality
	*/
	function drawRulerPoint(lat, lon, type){
		var icon = ge.createIcon('');
		var iconURL = parent.mx.MATRIX2.getServerURL() + "/sdi/ge/images/ruler_point.png";
		icon.setHref(iconURL);

		var style = ge.createStyle('');
		style.getIconStyle().setIcon(icon);
		style.getIconStyle().setScale(0.5);
		style.getPolyStyle().getColor().set('7f00ff00');

		var point = ge.createPoint('');
        var alt = 0;

		point.set(lat, lon, alt, ge.ALTITUDE_RELATIVE_TO_GROUND, true, false);

		if(type == "start"){
			ruler_placemark_start = ge.createPlacemark('');
			ruler_placemark_start.setStyleSelector(style);
			ruler_placemark_start.setGeometry(point);
			ge.getFeatures().appendChild(ruler_placemark_start);
		}
		else{
			ruler_placemark_end = ge.createPlacemark('');
			ruler_placemark_end.setStyleSelector(style);
			ruler_placemark_end.setGeometry(point);
			ge.getFeatures().appendChild(ruler_placemark_end);
		}
	}

	function drawRulerLine(){
		var style = ge.createStyle('');
		style.getPolyStyle().getColor().set('7f00ff00');

		var lineStyle = style.getLineStyle();
		lineStyle.setWidth(3);
		lineStyle.getColor().set('f000ffff');

		var lineString = ge.createLineString('');
		lineString.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
		lineString.setExtrude(true);
		lineString.setTessellate(true);

		var alt = 0;

		lineString.getCoordinates().pushLatLngAlt(ruler_placemark_start.getGeometry().getLatitude(), ruler_placemark_start.getGeometry().getLongitude(), alt);
		lineString.getCoordinates().pushLatLngAlt(ruler_placemark_end.getGeometry().getLatitude(), ruler_placemark_end.getGeometry().getLongitude(), alt);

		ruler_placemark_line = ge.createPlacemark('');
		ruler_placemark_line.setStyleSelector(style);
		ruler_placemark_line.setGeometry(lineString);

		ge.getFeatures().appendChild(ruler_placemark_line);

		drawRulerArrow(ruler_placemark_start.getGeometry().getLatitude(), ruler_placemark_start.getGeometry().getLongitude(),ruler_placemark_end.getGeometry().getLatitude(), ruler_placemark_end.getGeometry().getLongitude());
	}

	function drawRulerArrow(x1, y1, x2, y2){
		var headlen = distanceBetween2Points(x1, y1, x2, y2)/7;   // length of head
		var angle = Math.atan2(y2-y1,x2-x1);

		var style = ge.createStyle('');
		style.getPolyStyle().getColor().set('7f00ff00');

		var lineStyle = style.getLineStyle();
		lineStyle.setWidth(3);
		lineStyle.getColor().set('f000ffff');

		var lineString = ge.createLineString('');
		lineString.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
		lineString.setExtrude(true);
		lineString.setTessellate(true);

		var alt = 0;

		lineString.getCoordinates().pushLatLngAlt(x2-headlen*Math.cos(angle-Math.PI/6),y2-headlen*Math.sin(angle-Math.PI/6), alt);
		lineString.getCoordinates().pushLatLngAlt(x2, y2, alt);
		lineString.getCoordinates().pushLatLngAlt(x2-headlen*Math.cos(angle+Math.PI/6),y2-headlen*Math.sin(angle+Math.PI/6), alt);

		ruler_placemark_arrow = ge.createPlacemark('');
		ruler_placemark_arrow.setStyleSelector(style);
		ruler_placemark_arrow.setGeometry(lineString);

		ge.getFeatures().appendChild(ruler_placemark_arrow);
	}

	function moveRulerLine(){
		if(!ruler || ruler_placemark_end == null){
			return;
		}

		ruler_placemark_line.getGeometry().getCoordinates().clear();

		var lat1 = ruler_placemark_start.getGeometry().getLatitude();
		var lon1 = ruler_placemark_start.getGeometry().getLongitude();
		var lat2 = ruler_placemark_end.getGeometry().getLatitude();
		var lon2 = ruler_placemark_end.getGeometry().getLongitude();

		ruler_placemark_line.getGeometry().getCoordinates().pushLatLngAlt(lat1, lon1, 0);
		ruler_placemark_line.getGeometry().getCoordinates().pushLatLngAlt(lat2, lon2, 0);

		ge.getFeatures().removeChild(ruler_placemark_arrow);
		ruler_placemark_arrow = null;

		drawRulerArrow(lat1, lon1, lat2, lon2);
	}

	function calcRuler(placemark){
		if(placemark == undefined){
			if(ruler_placemark_end != null){
				placemark = ruler_placemark_end;
			}
			else{
				return;
			}
		}

		var lat1 = ruler_placemark_start.getGeometry().getLatitude();
		var lon1 = ruler_placemark_start.getGeometry().getLongitude();
		var lat2 = ruler_placemark_end.getGeometry().getLatitude();
		var lon2 = ruler_placemark_end.getGeometry().getLongitude();

		var distance = calcGEODistance(lat1, lon1, lat2, lon2).toFixed(2);

		if(ruler_units == 'meters'){
			distance+= ' ' + __("meters");
		}
		else if(ruler_units == 'miles'){
			distance = (distance/1609.344).toFixed(2) + ' ' + __("miles");
		}

		var distance = calcGEODistance(lat1, lon1, lat2, lon2).toFixed(2);
		var azimuth = calcAzimuth(lat1, lon1, lat2, lon2).toFixed(2);


		if(ruler_units == 'meters'){
			distance+= ' ' + __("meters");
		}
		else if(ruler_units == 'miles'){
			distance = (distance/1609.344).toFixed(2) + ' ' + __("miles");
		}

		azimuth+= ' ' + __("degrees");

		var div = document.createElement('DIV');
		var content = __("Distance: ") + distance + '<br />Bearing: ' + azimuth + ' <br /><input type="button" value="' + __("Remove ruler") + '" onclick="if(parent.mx){ parent.mx.GE.toggleRuler(); }" >';
		div.innerHTML = content;

		var balloon = ge.createHtmlDivBalloon('');
		balloon.setFeature(placemark);
		balloon.setContentDiv(div);
		ge.setBalloon(balloon);
	}

	function removeRuler(){
		ge.getFeatures().removeChild(ruler_placemark_start);
		ge.getFeatures().removeChild(ruler_placemark_end);
		ge.getFeatures().removeChild(ruler_placemark_line);
		ge.getFeatures().removeChild(ruler_placemark_arrow);

		ruler_placemark_start = null;
		ruler_placemark_end = null;
		ruler_placemark_line = null;
		ruler_placemark_arrow = null;

		ge.setBalloon(null);
	}

	/*
		Zoom functionality
	*/

	function drawZoomPoints(lat, lon){
		var icon = ge.createIcon('');
		var iconURL = parent.mx.MATRIX2.getServerURL() + "/sdi/ge/images/ruler_point.png";
		icon.setHref(iconURL);

		var style = ge.createStyle('');
		style.getIconStyle().setIcon(icon);
		style.getIconStyle().setScale(0.75);
		style.getPolyStyle().getColor().set('7f00ff00');

		var point_start = ge.createPoint('');
		var point_end = ge.createPoint('');
        var alt = 10;

		point_start.set(lat, lon, alt, ge.ALTITUDE_CLAMP_TO_GROUND, true, false);

		zoom_placemark_start = ge.createPlacemark('');
		zoom_placemark_start.setStyleSelector(style);
		zoom_placemark_start.setGeometry(point_start);
		ge.getFeatures().appendChild(zoom_placemark_start);

		point_end.set(lat, lon, alt, ge.ALTITUDE_CLAMP_TO_GROUND, true, false);

		zoom_placemark_end = ge.createPlacemark('');
		zoom_placemark_end.setStyleSelector(style);
		zoom_placemark_end.setGeometry(point_end);
		ge.getFeatures().appendChild(zoom_placemark_end);
	}

	function moveZoomEndpoint(lat, lon){
		var point = zoom_placemark_end.getGeometry();
		point.setLatitude(parseFloat(lat));
		point.setLongitude(parseFloat(lon));
	}

	function drawZoomRectangle(){
		var style = ge.createStyle('');
		style.getPolyStyle().getColor().set('7f00ff00');

		var lineStyle = style.getLineStyle();
		lineStyle.setWidth(3);
		lineStyle.getColor().set('f000ffff');

		var lineString = ge.createLineString('');
		lineString.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
		lineString.setExtrude(true);
		lineString.setTessellate(true);

		var alt = 10;

		var start_lat = zoom_placemark_start.getGeometry().getLatitude();
		var start_lon = zoom_placemark_start.getGeometry().getLongitude();
		var end_lat = zoom_placemark_end.getGeometry().getLatitude();
		var end_lon = zoom_placemark_end.getGeometry().getLongitude();
		lineString.getCoordinates().pushLatLngAlt(start_lat, start_lon, alt);
		lineString.getCoordinates().pushLatLngAlt(start_lat, end_lon, alt);
		lineString.getCoordinates().pushLatLngAlt(end_lat, end_lon, alt);
		lineString.getCoordinates().pushLatLngAlt(end_lat, start_lon, alt);

		zoom_placemark_rectangle = ge.createPlacemark('');
		zoom_placemark_rectangle.setStyleSelector(style);
		zoom_placemark_rectangle.setGeometry(lineString);

		ge.getFeatures().appendChild(zoom_placemark_rectangle);
	}

	function zoomToRectangle(){
		var lat1 = zoom_placemark_start.getGeometry().getLatitude();
		var lng1 = zoom_placemark_start.getGeometry().getLongitude();
		var lat2 = zoom_placemark_end.getGeometry().getLatitude();
		var lng2 = zoom_placemark_end.getGeometry().getLongitude();

		//Radius of the earh.
		var r = 6378700;

		// Field of view
		var fov = 32;

		var cameraView = ge.createCamera('');
		cameraView.setLatitude((lat1 + lat2) / 2.0);
		cameraView.setLongitude((lng1 + lng2) / 2.0);
		cameraView.setHeading(0.0);
		cameraView.setTilt(0.0);

		// determine if the rectangle is portrait or landscape
		var dy = Math.max(lat1, lat2) - Math.min(lat1, lat2);
		var dx = Math.max(lng1, lng2) - Math.min(lng1, lng2);

		// find the longest side
		var d = Math.max(dy, dx);

		// convert the longest side degrees to radians
		d = d * Math.PI/180.0;

		// find half the chord length
		var dist = r * Math.sin(d / 2);

		// get the altitude using the chord length
		var alt = dist/(Math.tan(fov * Math.PI / 180.0));

		cameraView.setAltitude(alt);

		ge.getView().setAbstractView(cameraView);
	}

	function removeZoomRectangle(){
		ge.getFeatures().removeChild(zoom_placemark_rectangle);

		zoom_placemark_rectangle = null;
	}

	function removeZoom(){
		ge.getFeatures().removeChild(zoom_placemark_start);
		ge.getFeatures().removeChild(zoom_placemark_end);

		zoom_placemark_start = null;
		zoom_placemark_end = null;

		removeZoomRectangle()
	}

    /*
     change view model
     */
    function changeModelLayer(model_id, layer_level, is_center_on_model){
        hide_all_models_placemarks(obj_3d_models_placemarks);

        //set model layers visibility
        for(var i = 0; i < obj_3d_models_list.length; i++){
            var model = obj_3d_models_list[i];
            if((model.obj == model_id || model_id == 0) && model.layers){
                for(var j = 0; j < model.layers.length; j++){
                    if(model.layers[j].attributes.NUMBER <= layer_level || layer_level == 0){
                        var placemark = get_layer_placemark(obj_3d_models_placemarks, model.layers[j].obj);

                        if (placemark == null) {
                            if(!$.isEmptyObject(model.layers[j].blocks)){
                                load_layer_file(model.layers[j], obj_3d_models_placemarks);
                            }
                        }
                        else{
                            placemark.setVisibility(true);
                        }
                    }
                }
            }
        }

        //set devices visibility
        for(var i = 0; i < camIDs.length;i++){
            var device = window['device_'+camIDs[i]];
            if(device.model_id && device.layer_id){
                var layer_data = get_model_layer_data_by_id(obj_3d_models_list, device.model_id, device.layer_id);
                if(device.placemark){
                    if(layer_data.attributes.NUMBER == layer_level && (device.model_id == model_id || model_id == 0)){
                        device.placemark.setVisibility(true);
                    }
                    else{
                        device.placemark.setVisibility(false);
                    }
                }
            }
        }

        //reposition view
        if(is_center_on_model){
            if(model_id != 0){
                var model_view = get_model_data_by_id(obj_3d_models_list, model_id);
                var file_exists = false;

                for(var j = 0; j < model_view.layers.length; j++){
                    var placemark = get_layer_placemark(obj_3d_models_placemarks, model_view.layers[j].obj);
                    if(placemark){
                        var lat = placemark.getGeometry().getLocation().getLatitude();
                        var lon = placemark.getGeometry().getLocation().getLongitude();
                        change_view(lat, lon, null, 30);
                        file_exists = true;
                        break;
                    }
                }
            }
            else{
                var view_data = ge_default_view.split(",");
                change_view(view_data[0], view_data[1], view_data[2], view_data[3], view_data[4], view_data[5]);
            }
        }
    }

    /*
     parse devices data
     */
	function displayDevConf()
	{
		var id = 0;
		var objDev = [];

		var devices1 = parent.resourceTree.getObjects({'cam_geo_calibration': 'yes'});
		var devices2 = parent.resourceTree.getObjects({'cam_geo_calibration': 'dynamic'});

		var devices = $.merge(devices1, devices2);

		for(var i = 0; i < devices.length; i++)
		{
			var objG = parent.resourceTree.getObject(devices[i]);

			var o = {
				'obj_id':  objG.obj,
                'type':    objG.type,
				'name':    objG.name,
				'ptz':     objG.attr('POSITIONCTL'),
				'lat':     parseFloat(objG.attr('CAM_GEO_LAT')),
				'lon':     parseFloat(objG.attr('CAM_GEO_LONG')),
				'alt':     parseFloat(objG.attr('CAM_GEO_ALT')),
				'altMode': objG.attr('CAM_GEO_ALT_MODE'),
				'range':   parseFloat(objG.attr('CAM_GEO_RANGE')),
				'tilt':    parseFloat(objG.attr('CAM_GEO_TILT')),
				'heading': parseFloat(objG.attr('CAM_GEO_AZIMUTH')),
                'model_id': objG.attr('CAM_GEO_MODEL'),
                'layer_id': objG.attr('CAM_GEO_LAYER'),
				'hfov':    parseFloat(objG.attr('CAM_GEO_HFOV')),
				'hfov_show': objG.attr('CAM_GEO_HFOV_SHOW'),
				'view_range': parseFloat(objG.attr('CAM_GEO_VIEW_RANGE')),
				'offset_north': parseFloat(objG.attr('CAM_GEO_NORTH_OFFSET'))
			};

			//if( IsNumeric(o.lat) && IsNumeric(o.lon) ){
			if( !IsNumeric(o.lat) ) o.lat = 0.0; 			// Default latitude [deg]
			if( !IsNumeric(o.lon) ) o.lon = 0.0; 			// Default longitude [deg]
			if( !IsNumeric(o.alt) ) o.alt = 1.0; 			// Default altitude [m]
			if( !IsNumeric(o.range) ) o.range = 100; 	// Default range [m]
			if( !IsNumeric(o.tilt) ) o.tilt = 0; 		// Default tilt [deg]
			if( !IsNumeric(o.heading) ) o.heading = 0; 	// Default heading [deg]
			if( !IsNumeric(o.hfov) ) o.hfov = 90; 	// Default hfov [deg]
			if( !IsNumeric(o.view_range) ) o.view_range = 100; 	// Default view_range [m]
			if( !IsNumeric(o.offset_north) ) o.offset_north = 0; 	// Default offset_north [deg]
			objDev[id++] = o;
			//}
		}
		setDevConf(objDev);
	}

    /*
     create placemarks for devices
     */
	function setDevConf(oDev)
	{
		if(oDev.length != 0)
		{
			for(var i=0; i<oDev.length; i++)
			{
				camIDs[i] = oDev[i].obj_id;
				if(oDev[i].ptz != "none") ptzPresence = true;

				var icon = ge.createIcon('');
				var iconURL = checkDeviceIconURL(oDev[i]);
				icon.setHref(iconURL);
				var style = ge.createStyle('');
				style.getIconStyle().setIcon(icon);
				style.getIconStyle().setScale(0.75);

				var lineStyle = style.getLineStyle();
				lineStyle.setWidth(3);
				lineStyle.getColor().set('f000ffff');

				style.getPolyStyle().getColor().set('7f00ff00');
				var point = ge.createPoint('');
				var altMode = ge.ALTITUDE_RELATIVE_TO_GROUND;
                var alt = parseFloat(oDev[i].alt, 10);

                if(oDev[i].altMode == "relativeToModel" && oDev[i].model_id && oDev[i].layer_id){
                    var layer_data = get_model_layer_data_by_id(obj_3d_models_list, oDev[i].model_id, oDev[i].layer_id);
                    var model_data = get_model_data_by_id(obj_3d_models_list, oDev[i].model_id);
                    alt+= calculate_layer_height(model_data, layer_data);
                } else if(oDev[i].altMode == "clampToGround") {
					altMode = ge.ALTITUDE_CLAMP_TO_GROUND;
                } else if(oDev[i].altMode == "absolute") {
					altMode = ge.ALTITUDE_ABSOLUTE;
				}

				point.set(parseFloat(oDev[i].lat), parseFloat(oDev[i].lon), alt, altMode, true, false);

				var lineString = ge.createLineString('');
				lineString.setAltitudeMode(altMode);
				lineString.setExtrude(true);
				lineString.setTessellate(true);
				lineString.getCoordinates().pushLatLngAlt(parseFloat(oDev[i].lat), parseFloat(oDev[i].lon), alt);

				var placemark = ge.createPlacemark('');
				placemark.setName(oDev[i].name);
				placemark.setSnippet(oDev[i].obj_id);
				placemark.setStyleSelector(style);
				placemark.setGeometry(point);

				var placemarkLine = ge.createPlacemark('');
				placemarkLine.setSnippet(oDev[i].obj_id);
				placemarkLine.setStyleSelector(style);
				placemarkLine.setGeometry(lineString);

                if(oDev[i].model_id && oDev[i].layer_id){
                    placemark.setVisibility(false);
                }

				ge.getFeatures().appendChild(placemark);
				ge.getFeatures().appendChild(placemarkLine);

				window['device_'+oDev[i].obj_id] = {
					'placemark': placemark,
					'placemarkLine': placemarkLine,
					'point': point,
					'line': lineString,
					'name': oDev[i].name,
					'range': oDev[i].range,
					'tilt': oDev[i].tilt,
					'heading': oDev[i].heading,
                    'model_id': oDev[i].model_id,
                    'layer_id': oDev[i].layer_id,
					'obj_id': oDev[i].obj_id,
                    'type':  oDev[i].type,
					'hfov': oDev[i].hfov,
					'hfov_show': oDev[i].hfov_show,
					'view_range': oDev[i].view_range,
					'offset_north': oDev[i].offset_north,
					'azimuth': (oDev[i].ptz != "none") ? oDev[i].offset_north : oDev[i].heading,
					'event_id': null,
					'ptz': oDev[i].ptz
				};

				cameraChangeFieldOfView(window['device_'+oDev[i].obj_id]);

                if(oDev[i].type == "camera"){
				    addMapListener(window['device_'+oDev[i].obj_id].placemark);
                }
			}

			if(oDev.length == 1){
				lockViewOnDevice(oDev[0].obj_id, false);
			}
			else{
				lockViewOnDevice(camIDs.join(","), true);
			}
		}
	}

	function balloonEventAknowledge(e)
	{
		var element = (e ? e.target : window.event.srcElement);
		var obj_id = element.getAttribute('name');
		acknowledgeEventSend(obj_id, window['device_'+obj_id].event_id);
	}

	function ptzLaunch(obj_id)
	{
		var o = {};
		o.ve_ptz = "yes";
		o.obj_id = obj_id;
		o.cell_id = "_ve";
		parent.mx.PTZ.load(o);
	}

	//-------------------------------->
	// Targeting Functions

	function targetingCamerasUpdate(tCS)
	{
		var tN = tCS.childNodes;
		for(var i=0; i<tN.length; i++)
		{
			if(tN.item(i).nodeName.toLowerCase() == "camera")
			{
				var cid = tN.item(i).getAttribute("id");
				if(window['device_'+cid])
				{
					var tNL = tN.item(i).childNodes;
					for(var j=0; j<tNL.length; j++)
					{
						if(tNL.item(j).nodeName == "position")
						{
							var la = tNL.item(j).getAttribute("lat");
							var lo = tNL.item(j).getAttribute("long");
							var al = tNL.item(j).getAttribute("alt");
							var al_m = tNL.item(j).getAttribute("alt_mode");
						}
						else if(tNL.item(j).nodeName == "direction")
						{
							var azim = tNL.item(j).getAttribute("azim");
							var tilt = tNL.item(j).getAttribute("tilt");
							var hfov = tNL.item(j).getAttribute("hfov");
						}
					}

					if( !IsNumeric(la) && (la != window['device_'+cid].point.getLatitude()) ) window['device_'+cid].point.setLatitude(la);
					if( !IsNumeric(lo) && (lo != window['device_'+cid].point.getLongitude()) ) window['device_'+cid].point.setLongitude(lo);
					if( !IsNumeric(al) && (al != window['device_'+cid].point.getAltitude()) ) window['device_'+cid].point.setAltitude(al);
					if( !IsNumeric(azim) && (azim != window['device_'+cid].azimuth) ) window['device_'+cid].azimuth = azim;
					if( !IsNumeric(hfov) && (hfov != window['device_'+cid].hfov) ) window['device_'+cid].hfov = hfov;

					cameraChangeFieldOfView(window['device_'+cid]);
					cameraCheckPosition(cid, al_m, la, lo, al);
				}
			}
		}
	}

	/**
	 * change camera position
	 * @param {number} objId
	 * @param {string} altMode
	 * @param {number} lat
	 * @param {number} long
	 * @param {number} alt
	 */
	function cameraCheckPosition(objId, altMode, lat, long, alt)
	{
		var obj = parent.resourceTree.getObject(objId);
		if(obj && obj.attr('CAM_GEO_CALIBRATION') != "no")
		{
			var deviceData = window['device_' + objId];
			if (!deviceData)
			{
				return;
			}

			var altM = (altMode == "absolute") ? ge.ALTITUDE_ABSOLUTE : ge.ALTITUDE_RELATIVE_TO_GROUND;

			//if object exists
			if (deviceData.placemark) {
				deviceData.point.set(lat, long, alt, altM, true, false);
				deviceData.line.getCoordinates().pushLatLngAlt(lat, long, alt);
			}

			if (parent.mx.GE.lockedDeviceId != null && parent.mx.GE.lockedDeviceId == deviceData.obj_id) {
				var lookAt = ge.createLookAt('');
				lookAt.setLatitude(lat);
				lookAt.setLongitude(long);
				lookAt.setAltitude(alt);
				lookAt.setAltitudeMode(altM);
				lookAt.setRange(deviceData.range);
				lookAt.setTilt(deviceData.tilt);
				lookAt.setHeading(deviceData.heading);
				ge.getView().setAbstractView(lookAt);
			}
		}
	}

	/**
	 * @param {number|string} objId
	 * @param {boolean} isMultiple
	 */
	function lockViewOnDevice(objId, isMultiple){
		var lookAt;
		if(isMultiple){
			var obj_ids = objId.split(",");
			var obj_ids_geocalibrated = [];

			var building_dev = 0;
			for(var i = 0; i < obj_ids.length; i++){
				//filter non-calibrated ids
				if(window['device_' + obj_ids[i]]){
					obj_ids_geocalibrated.push(obj_ids[i]);
				}
				else{
					continue;
				}

				if(window['device_' + obj_ids[i]].layer_id == null || window['device_' + obj_ids[i]].layer_id == undefined){
					continue;
				}
				building_dev++;
			}

			//if all devices in buildings
			if(building_dev == obj_ids.length){
				var view_data = ge_default_view.split(",");
                change_view(view_data[0], view_data[1], view_data[2], view_data[3], view_data[4], view_data[5]);
			} else {
				//find radius
				var radiusData = findRangeRadius(obj_ids_geocalibrated);

				if(radiusData['numOfDevices'] == 0){
					alert(__("No geo-calibrated devices present in set!"));
					return;
				}

				lookAt = ge.createLookAt('');
				lookAt.setLatitude(radiusData['x']);
				lookAt.setLongitude(radiusData['y']);
				lookAt.setAltitude(0);
				//if(oDev[0].altMode == "absolute") { var altM = ge.ALTITUDE_ABSOLUTE; } else { var altM = ge.ALTITUDE_RELATIVE_TO_GROUND; }
				lookAt.setAltitudeMode(ge.ALTITUDE_RELATIVE_TO_GROUND);
				lookAt.setRange(radiusData['radius']*3);
				lookAt.setTilt(24);
				lookAt.setHeading(0);
				ge.getView().setAbstractView(lookAt);
			}
		} else {
			var deviceData = window['device_' + objId];
			if (!deviceData)
			{
				return;
			}

            if(deviceData.model_id != null && deviceData.layer_id != null){
                var layer = get_model_layer_data_by_id(obj_3d_models_list, deviceData.model_id, deviceData.layer_id);
                if(layer){
                    if(parent.jsx3.GO("select3DModel").getValue() != 0){
                        parent.jsx3.GO("select3DModel").setValue(0);
                        parent.mx.GE.changeModel();
                    }

                    window.setTimeout(function(){
                        if(parent.jsx3.GO("select3DModel").getValue() != layer.attributes.NUMBER){
                            parent.jsx3.GO("select3DLayer").setValue(layer.attributes.NUMBER);
                            parent.mx.GE.changeLayer();
                        }
                    }, 1000);
                }
            }

			lookAt = ge.createLookAt('');
			lookAt.setLatitude(deviceData.point.getLatitude());
			lookAt.setLongitude(deviceData.point.getLongitude());
			lookAt.setAltitude(deviceData.point.getAltitude());

			//lookAt.setAltitudeMode(altM);
			lookAt.setRange(deviceData.range);
			lookAt.setTilt(deviceData.tilt);
			lookAt.setHeading(deviceData.heading);
			ge.getView().setAbstractView(lookAt);
		}
	}

	function checkDeviceIconURL(objDev, isAlert){
        var deviceIcon = "";
        if(objDev.type == 'camera'){
		    //check device type
		    deviceIcon = parent.resourceTree.getObject(objDev.obj_id).attr('CAMERAMODEL') == 'iStream'
			    ? '/m3d/iphone'
			    : '/m3d/camera';

            if(isAlert){
                deviceIcon+= '_alerted';
            }
            deviceIcon+= '.gif';
		}else if(objDev.type == 'door'){
			deviceIcon = "/resources/door.png";
		}else if(objDev.type == 'sensor'){
			deviceIcon = "/resources/sensor.png";
		}else if(objDev.type == 'relay'){
			deviceIcon = "/resources/relay.png";
		}

		//return correct icon
		return parent.mx.MATRIX2.getServerURL()+"/TibcoGI/JSXAPPS/mx/images/design1" + deviceIcon;
	}

	function minimizeBalloonContent(obj_id, initW, initH){
		var frame = document.getElementById('ge_ballon_iframe_'+obj_id);
		if(frame){
			var table = document.getElementById('b_table');
			table.style.border = '0px';
			var fixH = 35;
			var fixW = 140;

			table.style.width = initW + fixW;
			table.style.height = initH + fixH;

			frame.style.width = initW + fixW;
			frame.style.height = initH + fixH;

			var player = frame.contentWindow._mplayer_geVPlayer;
			player.setSize(initW + fixW, initH + fixH);
			document.getElementById('b_cell_name').style.display = 'none';

			for(var i = 1; i <= 5; i++){
				document.getElementById('b_cell_btn'+i).style.display = 'none';
			}

			var b_expand = document.getElementById('b_expand');
			b_expand.style.backgroundImage = 'url(\'/TibcoGI/JSXAPPS/mx/images/design1/m3d/ge_expand_baloon.png\')';
			b_expand.onclick = function(){restoreBalloonContent(obj_id, initW, initH)};
			b_expand.title = "Show additional controls"
		}
	}

	function restoreBalloonContent(obj_id, initW, initH){
		var frame = document.getElementById('ge_ballon_iframe_'+obj_id);
		if(frame){
			document.getElementById('b_table').style.border = '1px';

			frame.style.width = initW;
			frame.style.height = initH;
			var player = frame.contentWindow._mplayer_geVPlayer;
			player.setSize(initW, initH);
			document.getElementById('b_cell_name').style.display = 'block';

			for(var i = 1; i <= 5; i++){
				document.getElementById('b_cell_btn' + i).style.display = 'block';
			}

			var b_expand = document.getElementById('b_expand');
			b_expand.style.backgroundImage = 'url(\'/TibcoGI/JSXAPPS/mx/images/design1/m3d/ge_collapse_baloon.png\')';
			b_expand.onclick = function(){minimizeBalloonContent(obj_id, initW, initH)};
			b_expand.title = "Show video only"
		}
	}

	function closeBalloon(objId){
		document.getElementById("ge_ballon_iframe_" + objId).src = "";
		ge.setBalloon(null);
	}

	function addMapListener(placemark){
		google.earth.addEventListener(placemark, 'click', function(event)
		{
			gePlayerW = parseInt(parent.mx.MATRIX2.getServer().getJSXByName("ge_block").getAbsolutePosition().W/3);
			gePlayerH = parseInt(parent.mx.MATRIX2.getServer().getJSXByName("ge_block").getAbsolutePosition().H/3);

			event.preventDefault();
			var obj_id = event.getTarget().getSnippet();
			var div = document.createElement('DIV');

			var content = '';

			var close_left = gePlayerW + 125;
			var minimize_left = gePlayerW + 105;
			content += '<div id="b_expand" title="Show video only" onclick="minimizeBalloonContent('+obj_id+', '+gePlayerW+', '+gePlayerH+')" style="width:12px;height:12px;top:-25px;background-image:url(\'/TibcoGI/JSXAPPS/mx/images/design1/m3d/ge_collapse_baloon.png\');float:left;cursor:pointer;margin-left:'+minimize_left+'px">&nbsp;</div>';
			content += '<div onclick="closeBalloon('+obj_id+')" title="Close" style="width:12px;height:12px;top:-25px;background-image:url(\'/TibcoGI/JSXAPPS/mx/images/design1/m3d/ge_close_baloon.png\');cursor:pointer;margin-left:'+close_left+'px">&nbsp;</div>';

			content += '<table id="b_table" style="text-align:center;left:0;top:0" border="1">';
			content += '<tr id="b_cell_name">';

			content += '<td colspan="2" height="25px">';
			content += "<b>"+window['device_'+obj_id].name+"</b>";
			content += '</td>';

			content += '</tr>';

			content += '<tr>';

			content += '<td rowspan="5" id="frame_cell" style="overflow:expand">';
			if(gePlayerW < 110 || gePlayerH < 70){
				content += __("Cell to small for video");
			}
			else{
				content += '<iframe id="ge_ballon_iframe_'+obj_id+'" src="/TibcoGI/JSXAPPS/mx/cell_player.php?name=geVPlayer&camera='+obj_id+'&width='+gePlayerW+'&height='+gePlayerH+'" width="'+gePlayerW+'" height="'+gePlayerH+'" scrolling="no" border="0"></iframe>';
			}
			content += '</td>';

			content += '<td id="b_cell_btn1">';
			content += "<input type='button' id='id_a01' onclick='ptzLaunch("+obj_id+");' value='PTZ' ";
			if(window['device_'+obj_id].ptz != "none" && parent.resourceTree.cred(obj_id, 'p')) {
				content += ' title="'+__("Launch PTZ control")+'" />';
			} else {
				content += ' title="'+__("PTZ is not available")+'" disabled />';
			}
			content += '</td>';
			content += '</tr>';


			content += '<tr id="b_cell_btn2">';
			content += '<td width="130px">';
			content += "<input type='button' name='"+obj_id+"' id='id_a02' value='Ackn' ";
			if(window['device_'+obj_id].event_id != null)
			{
				content += " title='"+__("Acknowledge Event id")+":"+window['device_'+obj_id].event_id+"' onclick='balloonEventAknowledge()'/>";
			} else {
				content += " title="+__("No new events present")+" disabled />";
			}
			content += '</td>';
			content += '</tr>';

			content += '<tr id="b_cell_btn3">';
			content += '<td>';
			content += "<input type='button' id='id_a03' value='"+__("Pop-Up")+"' onclick='gePopUpCamera("+obj_id+");' title='"+__("Camera Pop-Up in new cell")+"' />";
			content += '</td>';
			content += '</tr>';

			content += '<tr id="b_cell_btn4">';
			content += '<td>';
			content += "<input type='button' id='id_a04' value='"+__("Pop-Up in Tab")+"' onclick='gePopUpCameraInNewTab("+obj_id+");' title='"+__("Camera Pop-Up in new Tab")+"' />";
			content += '</td>';
			content += '</tr>';

			content += '<tr id="b_cell_btn5">';
			content += '<td>';
			content += "<input type='button' id='id_a05' value='"+__("Slew to Cue")+"' onclick='geSlew2CueInit("+obj_id+");' title='"+__("Slew to Cue")+"' />";
			content += '</td>';
			content += '</tr>';

			content += '</table>';

			div.innerHTML = content;

			var balloon = ge.createHtmlDivBalloon('');
			balloon.setBackgroundColor('#E0E0E0');
			balloon.setFeature(window['device_'+obj_id].placemark);
			balloon.setContentDiv(div);
			balloon.setMinHeight(200);
			//block video in safari and firefox
			if(!parent.$.browser.safari && !parent.$.browser.mozilla){
				balloon.setCloseButtonEnabled(false);
			}
			else{
				balloon.setCloseButtonEnabled(true);
			}
			ge.setBalloon(balloon);

			if(document.getElementById("id_a02")){
				 document.getElementById("id_a02").onclick = balloonEventAknowledge;
				 document.getElementById("id_a02").style.width = "100%";
			}

			document.getElementById("id_a01").style.width = "100%";
			document.getElementById("id_a03").style.width = "100%";
			document.getElementById("id_a04").style.width = "100%";

			window['ptz_overload_var'] = window.setTimeout(function(){ overloadPTZ(obj_id); }, 500);
		});
	}

	function overloadPTZ(obj_id)
	{
		var iframe = document.getElementById("ge_ballon_iframe_"+obj_id);
		var player = null;
		if(parent.jsx3.CLASS_LOADER.IE || parent.jsx3.CLASS_LOADER.SAF) { player = iframe.contentWindow._mplayer_geVPlayer; }
		if(player){
			player._onImageClick = function (x,y) {
				parent.mx.GE.callPTZmove(player, x, y);
			};
			if(window['ptz_overload_var']){ clearTimeout(window['ptz_overload_var']); }
		}
		else{
			window['ptz_overload_var'] = window.setTimeout(function(){ overloadPTZ(obj_id); }, 500);
		}
	}

	function cameraChangeFieldOfView(cObj){
		if(cObj.hfov_show == "yes")
		{
			var placemark = cObj.polygon_fov || ge.createPlacemark('');

			if (!placemark.getStyleSelector())
			{
				placemark.setStyleSelector(ge.createStyle(''));
				var lineStyle = placemark.getStyleSelector().getLineStyle();
				lineStyle.setWidth(1);
				lineStyle.getColor().set('44ff0000');
				placemark.getStyleSelector().getPolyStyle().getColor().set('33ff0000');
			}

			var polygon = ge.createPolygon('');
			placemark.setGeometry(polygon);
			polygon.setTessellate(false);
			var outer = ge.createLinearRing('');
			polygon.setOuterBoundary(outer);
			polygon.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);

			var la = cObj.point.getLatitude();
			var lo = cObj.point.getLongitude();
			var al = cObj.point.getAltitude();
			var coords = outer.getCoordinates();

			var np = 9;
			var ll = [];
			var distance = cObj.view_range / 1852.0; // [m] to [nm]
			var d_radial = cObj.hfov / (np-1.0);

			coords.pushLatLngAlt(la, lo, al);
			for(var i=0; i<np; i++)
			{
				var radial = ((i * d_radial) - (cObj.hfov/2.0) + cObj.azimuth) * Math.PI / 180.0;
				ll = latlonByDistanceRadial(la, lo, distance, radial);
				coords.pushLatLngAlt(ll[0], ll[1], al);
			}
			coords.pushLatLngAlt(la, lo, al);

			cObj.polygon_fov = placemark;
			ge.getFeatures().appendChild(placemark);
		}
	}

	function targetingCreateBalloonBody(tid)
	{
		var div = document.createElement('DIV');

		var content = '';

		content += '<table id="tableTargeting" border="0" tid="' + tid + '">';
		content += '<tr>';
		content += '<td>';
		content += __("Target id") + ':&nbsp;';
		content += '</td>';
		content += '<td>';
		content += tid;
		content += '</td>';
		content += '</tr>';

		content += '<tr>';
		content += '<td>';
		content += __("Latitude") + ':&nbsp;';
		content += '</td>';
		content += '<td id="tblTargetingLat">';
		content += window['target_'+tid].placemark_point.getLatitude();
		content += '</td>';
		content += '</tr>';

		content += '<tr>';
		content += '<td>';
		content += __("Longitude") + ':&nbsp;';
		content += '</td>';
		content += '<td id="tblTargetingLon">';
		content += window['target_'+tid].placemark_point.getLongitude();
		content += '</td>';
		content += '</tr>';

		content += '<tr>';
		content += '<td>';
		content += __("Altitude") + ':&nbsp;';
		content += '</td>';
		content += '<td id="tblTargetingAlt">';
		content += window['target_'+tid].placemark_point.getAltitude();
		content += '</td>';
		content += '</tr>';

		if(ptzPresence)
		{
			content += '<tr>';
			content += '<td colspan="2">';
			content += '<br/>' + __("Select Camera to follow");
			content += '</td>';
			content += '</tr>';

			content += '<tr>';
			content += '<td colspan="2">';
			content += "<select id='trgSlewCameraSelect' name='"+tid+"' size='10' style='background-color:#E8E8E8;' multiple>";
			content += "<option id='null' value='0' selected>(none)";
			var ii = 0;
			for(var i=0; i<camIDs.length; i++)
			{
				if(window['device_'+camIDs[i]].ptz != "none")
				{
					ii++;
					content += "<option id='ocamid_"+camIDs[i]+"' value='"+ii+"'>"+window['device_'+camIDs[i]].name;
				}
			}
			content += "</select>";
			content += '</td>';
			content += '</tr>';

			content += '<tr>';
			content += '<td colspan="2">';
			content += '<input type="button" id="buttonCameraSlew" value="'+__("Submit Selection")+'" onclick="selectCamerasToFollow();"/>';
			content += '</td>';
			content += '</tr>';
		}

		content += '</table>';
		div.innerHTML = content;

		var balloon = ge.createHtmlDivBalloon('');
		balloon.setMaxWidth(800);
		balloon.setBackgroundColor('#E0E0E0');
		balloon.setFeature(window['target_'+tid].placemark);
		balloon.setContentDiv(div);
		ge.setBalloon(balloon);
	}

	function selectCamerasToFollow()
	{
		if(!document.getElementById('trgSlewCameraSelect'))
			return;
		var str = "";
		var oSelect = document.getElementById('trgSlewCameraSelect');
		var tid = oSelect.name;
		for (var i = 0; i<oSelect.options.length; i++)
		{
			if (oSelect.options[i].selected)
			{
				if(oSelect.options[i].value != 0)
				{
					if(str == "")
					{
						str += oSelect.options[i].id.split("_")[1];
					}
					else
					{
						str += "," + oSelect.options[i].id.split("_")[1];
					}
				}
			}
		}

		if(str != "")
		{
			window['target_'+tid].camerasToFollowList = str;
		}
		else
		{
			window['target_'+tid].camerasToFollowList = null;
		}
	}

	function camerasToFollowTarget(tid, t_la, t_lo, t_al)
	{
		if( ('target_'+tid) in window )
		{
			if(window['target_'+tid].camerasToFollowList != null)
			{
				var obj_IDs = window['target_'+tid].camerasToFollowList.split(",");
				for (var i=0; i<obj_IDs.length; i++)
				{
					if( ('device_'+obj_IDs[i]) in window )
					{
						var c_la = window['device_'+obj_IDs[i]].point.getLatitude();
						var c_lo = window['device_'+obj_IDs[i]].point.getLongitude();
						var c_al = window['device_'+obj_IDs[i]].point.getAltitude();
						var c_on = window['device_'+obj_IDs[i]].offset_north;
						var c_ptz = window['device_'+obj_IDs[i]].ptz;

						if(c_ptz != "none")
						{
							// Calculate Pan angle
							var t_angle = angleBy2Points(c_la*Math.PI/180, c_lo*Math.PI/180, t_la*Math.PI/180, t_lo*Math.PI/180) * 180/Math.PI;
							var tmpA = -t_angle;
							if(t_angle >  180) tmpA = 360 - t_angle;
							tmpA = Math.round( tmpA + c_on);
							if(Math.abs(tmpA) > 180)
							{
								if(tmpA > 0) { tmpA = -(360 - tmpA); } else { tmpA = 360 + tmpA; }
							}

							// Calculate Tilt angle
							var tmpB = null;
							var dst = distanceBetween2Points( (c_la*Math.PI/180), (c_lo*Math.PI/180), (t_la*Math.PI/180), (t_lo*Math.PI/180) ) * 180 * 60 * 1852.0 / Math.PI;
							if(c_al > t_al)
							{
								tmpB = -Math.round(Math.atan2((c_al - t_al) ,dst) * 180 / Math.PI);
							}
							else
							{
								tmpB = Math.round(Math.atan2((t_al - c_al), dst) * 180 / Math.PI);
							}

							ptzAbsoluteChange(obj_IDs[i], tmpA, tmpB);

							window['device_'+obj_IDs[i]].azimuth = -t_angle;
							//window['camera_'+cid].hfov = hf;
							cameraChangeFieldOfView(window['device_'+obj_IDs[i]]);
						}
					}
				}
			}
		}
	}
	//--------------------------------<

	//-------------------------------->
	// click-on-screen PTZ Functions
	function clickOnScreenPTZ(objId, playerW, playerH, x, y)
	{
		var Direction_C="<PTZ_Command>do.ptz?dev="+objId+"&mode=rel&size="+playerW+'x'+playerH+"&xy="+x+','+y+"</PTZ_Command>";

		$.ajax({
			url: "/ptz/cgi-bin/send_message.pl",
			data: {data: Direction_C},
			success: function() {}
		});
	}

	function ptzAbsoluteChange(objId, pan, tilt)
	{
		var pt="<PTZ_Command>do.ptz?dev="+objId+"&mode=abs&pt="+pan+','+tilt+"</PTZ_Command>";
		$.ajax({
			url: "/ptz/cgi-bin/send_message.pl",
			data: {data: pt},
			success: function() {}
		});
	}
	//--------------------------------<

	//-------------------------------->
	// Search and reposition to GE location
	function searchLocation(location)
	{
		var geocoder = new google.maps.Geocoder();

		geocoder.geocode({
			address: location.toString()
			},
			function(GeocoderResults) {
				if (GeocoderResults) {
					var lat = GeocoderResults[0].geometry.location.lat();
					var lng = GeocoderResults[0].geometry.location.lng();

                    var lookAt = ge.createLookAt('');
                    lookAt.set(lat, lng, 10, ge.ALTITUDE_RELATIVE_TO_GROUND, 0, 0, 3000);
                    ge.getView().setAbstractView(lookAt);
                }
            }
		);
	}
	//--------------------------------<

	// add cue into map for device
	function geSlew2CueInit(objId){
		var objDev = window['device_'+objId];

		var icon = ge.createIcon('');
			icon.setHref("http://maps.google.com/mapfiles/kml/paddle/red-circle.png");

		var style = ge.createStyle('');
			style.getIconStyle().setIcon(icon);
			style.getIconStyle().setScale(0.75);

		var lineStyle = style.getLineStyle();
			lineStyle.setWidth(1.5);
			lineStyle.getColor().set('f000ffff');
			style.getPolyStyle().getColor().set('7f00ff00');

		//var altMode = ge.ALTITUDE_RELATIVE_TO_GROUND;
		var altMode = ge.ALTITUDE_CLAMP_TO_GROUND;

		var placemark_point = ge.createPlacemark('');
			placemark_point.setSnippet(objDev.obj_id);
			placemark_point.setName(__("Target"));
			placemark_point.setStyleSelector(style);
		var point = ge.createPoint('');
			placemark_point.setGeometry(point);

		var placemark_line = ge.createPlacemark('');
			placemark_line.setStyleSelector(style);
		var line = ge.createLineString('');
			line.setAltitudeMode(altMode);
			line.setExtrude(false);
			line.setTessellate(true);
			placemark_line.setGeometry(line);

			var la = objDev.point.getLatitude();
			var lo = objDev.point.getLongitude();
			//var al = objDev.point.getAltitude();
			var al = 0.0;
			line.getCoordinates().pushLatLngAlt(la, lo, al);

			var np = 9;
			var ll = [];
			var distance = objDev.view_range / 1852.0; // [m] to [nm]
			var d_radial = objDev.hfov / (np-1.0);

			for(var i=0; i<np; i++){
				var radial = ((i * d_radial) - (objDev.hfov/2.0) + objDev.azimuth) * Math.PI / 180.0;
				ll = latlonByDistanceRadial(la, lo, distance, radial);

				if(i == 4){
					point.set(ll[0], ll[1], al, altMode, true, false);
					line.getCoordinates().pushLatLngAlt(ll[0], ll[1], al);
				}
			}

			if(cue_placemark_point != null){
				geSlew2CueStop();
			}

			cue_placemark_point = placemark_point;
			cue_placemark_line = placemark_line;
			ge.getFeatures().appendChild(placemark_point);
			ge.getFeatures().appendChild(placemark_line);

			//add listener to cue
			google.earth.addEventListener(cue_placemark_point, 'click', function(event) {
				event.preventDefault();

				var div = document.createElement('DIV');
				var content = '';
				content += '<table id="tableCue" border="0">';
				content += '<tr>';
				content += '<td>';
				content += '<input type="button" value="'+__("Cancel")+'" onclick="geSlew2CueStop()" />';
				content += '</td>';
				content += '</tr>';
				content += '</table>';
				div.innerHTML = content;

				var balloon = ge.createHtmlDivBalloon('');
				balloon.setMaxWidth(800);
				balloon.setBackgroundColor('#E0E0E0');
				balloon.setFeature(cue_placemark_point);
				balloon.setContentDiv(div);
				ge.setBalloon(balloon);
			});

			closeBalloon(objId);

			parent.mx.GE.callPTZmoveAbs(objId, 0 + objDev.offset_north, 0);
	}

	// rotate cue
	function geSlew2CueChange(new_lat, new_lon){
		var objId = cue_placemark_point.getSnippet();

		var point = cue_placemark_point.getGeometry();
		point.setLatitude(parseFloat(new_lat));
		point.setLongitude(parseFloat(new_lon));

		var line = cue_placemark_line.getGeometry();
		line.getCoordinates().setLatLngAlt(1, new_lat, new_lon, 0); // change 2-nd point coords

		var objDev = window['device_' + objId];
		var dev_lat = objDev.point.getLatitude();
		var dev_lon = objDev.point.getLongitude();
		var dev_alt = objDev.point.getAltitude();
		var offset = objDev.offset_north;

		devGeo2Absolute.setParams(dev_lat, dev_lon, dev_alt, new_lat, new_lon, 0, offset);
		var anglePan = Math.round(devGeo2Absolute.getPan());
		var angleTilt = Math.round(devGeo2Absolute.getTilt());

		parent.mx.GE.callPTZmoveAbs(objId, anglePan, angleTilt);

		objDev.azimuth = (-1) * devGeo2Absolute.getAn2p();
		cameraChangeFieldOfView(objDev);
	}

	//remove cue from map
	function geSlew2CueStop(){
		ge.getFeatures().removeChild(cue_placemark_point);
		ge.getFeatures().removeChild(cue_placemark_line);
		cue_placemark_point = null;
		cue_placemark_line = null;
		ge.setBalloon(null);
	}

	//-------------------------------------------------------------------------------------------------------->
	var iconAltitude = 2.0; // [m]
	var targetingsUgsTrailMaxPointsNumber = 30;

	function targetingTargetSet(prop)
	{
		try {
			var tProp = prop.target;

			var id = tProp.id;
			var lat = tProp.latitude;
			var lon = tProp.longitude;

			if (ge.getElementById(id + '_Placemark_Ic') != null)
			{
				ge.getElementById(id + '_Point').set(lat, lon, iconAltitude, ge.ALTITUDE_RELATIVE_TO_GROUND, true, false);
				var ls = ge.getElementById(id + '_LineString').getCoordinates();
				ls.pushLatLngAlt(lat, lon, iconAltitude);
				if (ls.getLength() >= targetingsUgsTrailMaxPointsNumber) ls.shift();

				var pm = ge.getElementById(id + '_Placemark_Ic');

				var descr = pm.getDescription().split("|");
				tProp.symbolId = descr[1];
				tProp.symbolDescr = descr[2];

				var balloon = ge.getBalloon();

				var pmDescr = "";
				if (balloon && balloon.getId() == (id + '_HtmlStringBalloon'))
				{
					pmDescr += tProp.id + "|";
					pmDescr += tProp.symbolId + "|";
					pmDescr += tProp.symbolDescr + "|";
					pmDescr += tProp.latitude + "|";
					pmDescr += tProp.longitude + "|";
					pmDescr += tProp.altitude + "|";
					pmDescr += tProp.distance + "|";
					pmDescr += tProp.type + "|";
					pmDescr += tProp.speed + "|";
					pmDescr += tProp.course + "|";
					pmDescr += tProp.source + "|";
					pmDescr += prop.objId;

					pm.setDescription(pmDescr);

					balloon.setContentString(targetingCreateBalloonContent(id));
				}

				// Placemark_Ls contains time to create/modify, for Target's Scene Recycling purposes
				pmDescr = "";
				pmDescr += (new Date()).getTime();
				ge.getElementById(id + '_Placemark_Ls').setDescription(pmDescr);

			} else {
				var icon = ge.createIcon(id + '_Icon');
				icon.setHref("http://" + jsServerName + ":" + jsServerPort + targetingIconsUrl + tProp.symbolId + ".png");

				var style = ge.createStyle('');
				style.getIconStyle().setIcon(icon);
				style.getIconStyle().getHotSpot().set(0.5, ge.UNITS_FRACTION, 0, ge.UNITS_FRACTION);
				style.getIconStyle().setScale(0.6);

				var lineStyle = style.getLineStyle();
				lineStyle.setWidth(1);
				lineStyle.getColor().set('ffffffff');  // aabbggrr format

				var pt = ge.createPoint(id + '_Point');
				pt.set(lat, lon, iconAltitude, ge.ALTITUDE_RELATIVE_TO_GROUND, true, false);

				var ls = ge.createLineString(id + '_LineString');
				ls.setTessellate(true);
				ls.setExtrude(true);
				ls.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
				ls.getCoordinates().pushLatLngAlt(lat, lon, iconAltitude);

				var pm = ge.createPlacemark(id + '_Placemark_Ic');
				var pmName = parent.jsTargetingShowIds ? id : " ";
				pm.setName(pmName);

				var pmDescr = "";
				pmDescr += tProp.id + "|";
				pmDescr += tProp.symbolId + "|";
				pmDescr += tProp.symbolDescr + "|";
				pmDescr += tProp.latitude + "|";
				pmDescr += tProp.longitude + "|";
				pmDescr += tProp.altitude + "|";
				pmDescr += tProp.distance + "|";
				pmDescr += tProp.type + "|";
				pmDescr += tProp.speed + "|";
				pmDescr += tProp.course + "|";
				pmDescr += tProp.source + "|";
				pmDescr += prop.objId;

				pm.setDescription(pmDescr);

				google.earth.addEventListener(pm, 'click', function (event)
				{
					var id = event.getCurrentTarget().getDescription().split("|")[0];
					event.preventDefault();

					var balloon = ge.createHtmlStringBalloon(id + '_HtmlStringBalloon');
					balloon.setFeature(event.getTarget());
					balloon.setMaxWidth(800);
					balloon.setBackgroundColor("#F5F5F5");
					//balloon.setForegroundColor();
					balloon.setContentString(targetingCreateBalloonContent(id));
					ge.setBalloon(balloon);
				});

				pm.setGeometry(pt);
				pm.setStyleSelector(style);

				ge.getFeatures().appendChild(pm);

				var styleLs = ge.createStyle('');
				var lineStyleLs = styleLs.getLineStyle();
				var lineWidth = parent.jsTargetingShowTrails ? 3 : 0;
				lineStyleLs.setWidth(lineWidth);
				lineStyleLs.getColor().set('9900ffff');  // aabbggrr format

				var polyStyle = styleLs.getPolyStyle();
				polyStyle.getColor().set('7f00aa00');

				var pmLs = ge.createPlacemark(id + '_Placemark_Ls');
				pmLs.setGeometry(ls);
				pmLs.setStyleSelector(styleLs);

				pmDescr = "";
				pmDescr += (new Date()).getTime();
				pmLs.setDescription(pmDescr);

				ge.getFeatures().appendChild(pmLs);
			}

			// Camera to Autofollow target (Autotracking)
			if (parent.jsTargetingAutoTracking && (parent.jsTargetingAutoTrackingCameraId != null))
			{
				var objDev = window['device_' + parent.jsTargetingAutoTrackingCameraId];
				var dev_lat = objDev.point.getLatitude();
				var dev_lon = objDev.point.getLongitude();
				var dev_alt = objDev.point.getAltitude();
				var offset = objDev.offset_north;

				devGeo2Absolute.setParams(dev_lat, dev_lon, dev_alt, lat, lon, 0, offset);
				var anglePan = Math.round(devGeo2Absolute.getPan());
				var angleTilt = Math.round(devGeo2Absolute.getTilt());
				parent.mx.GE.callPTZmoveAbs(parent.jsTargetingAutoTrackingCameraId, anglePan, angleTilt);

				objDev.azimuth = (-1) * devGeo2Absolute.getAn2p();
				cameraChangeFieldOfView(objDev);
			}

			// Camera View to Target
			//
			// vAnalytics WILL BE REGISTERED FROM ALL CLIENTS - MULTIPLE TIMES --- MUST be registered in eLog from OV (before posing to ActiveMQ)
			// vAnalytics targets MUST be GEO-REFERENCED on server side, and registered on GEO-database, before be send to the client!
			//
			if ((tProp.source == "vGeoRef" || tProp.source == "LRF") && parent.jsSessionId == prop.sessionId)
			{
				/* -- Change of Point of View change on new target - CANCELED.
				 var camera = ge.getView().copyAsCamera(ge.ALTITUDE_RELATIVE_TO_GROUND);
				 camera.set( prop.camera.latitude,
				 prop.camera.longitude,
				 prop.camera.height,
				 ge.ALTITUDE_RELATIVE_TO_GROUND,
				 prop.camera.azimuthAngle,
				 (prop.camera.tiltAngel+90.0),
				 0.0)
				 ge.getView().setAbstractView(camera);
				 */

				// Target of "vGeoRef" register
				// "UGS" are registered on server side
				prop.target = tProp;
				parent.Targeting.targetRegister(prop);
			}

			if (((new Date()).getTime() - parent.jsTargetingLastSceneRecycle) > parent.jsTargetingSceneRecycleRefreshTime)
			{
				targetingSceneRecycle();
			}
		}
		catch (e)
		{
			console.warn("id = " + prop.target.id);
			console.error(e);
		}
	}

	function targetingShowTargetsTrailsIds()
	{
		var pml = ge.getElementsByType("KmlPlacemark");
		for (var i = 0; i < pml.getLength(); i++)
		{
			var pm = pml.item(i);

			if (pm.getId().search(/_Placemark_Ls/g) > -1)
			{
				if (parent.jsTargetingShowTrails)
				{
					pm.getStyleSelector().getLineStyle().setWidth(3);
					if (pm.getId().search(parent.jsTargetingCurrentTargetId) > -1)
					{
						pm.getGeometry().setAltitudeMode(ge.ALTITUDE_RELATIVE_TO_GROUND);
					} else {
						pm.getGeometry().setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
					}
				} else {
					pm.getStyleSelector().getLineStyle().setWidth(0);
					pm.getGeometry().setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
				}
			}

			if (pm.getId().search(/_Placemark_Ic/g) > -1)
			{
				var pmName = parent.jsTargetingShowIds ? pm.getDescription().split("|")[0] : " ";
				pm.setName(pmName);
			}
		}
	}

	function targetingChangeTargetProp(id, obj, tType)
	{
		var icon = ge.getElementById(id+'_Icon');
		var pm = ge.getElementById(id+'_Placemark_Ic');
		var pmd = pm.getDescription().split("|");

		if(obj != null) {
			var index  = obj.selectedIndex;
			var symbol = obj.options[index].value;
			var tId_0 = symbol.substring(0,1);
			var tId_2 = symbol.substring(2);
			var currType = pmd[1].substring(1,2);

			//var descr = obj.options[index].label;
			var descr = "desc";
			var newType = tId_0 + currType + tId_2;
		} else if(tType != null) {
			var tId_0 = pmd[1].substring(0,1);
			var tId_2 = pmd[1].substring(2);

			var descr = pmd[2];
			var newType = tId_0 + tType + tId_2;
		} else {
			parent.appLogger.error("Incorrect input data in targetingChangeTargetProp() method.");
			return;
		}

		icon.setHref("http://" + jsServerName + ":" + jsServerPort + targetingIconsUrl + newType + ".png");
		var pmName = parent.jsTargetingShowIds ? id : " ";
		pm.setName(pmName);

		var newPmDescr = id + "|";
		newPmDescr += newType + "|";
		newPmDescr += descr;
		for(var i=3; i<pmd.length; i++)
		{
			newPmDescr += "|" + pmd[i];
		}
		pm.setDescription(newPmDescr);

		var balloon = ge.getBalloon();
		balloon.setContentString( targetingCreateBalloonContent(id) );
		ge.setBalloon(balloon);

		// Target Change register
		var prop = {
			propChange: true,
			userId: jsUserId,
			userName: jsUserName,
			sessionId: jsSessionId,
			objId: pmd[11],
			target: {
				id: id,
				symbolId: newType,
				symbolDescr: descr,
				latitude: pmd[3],
				longitude: pmd[4],
				altitude: pmd[5],
				distance: pmd[6],
				type: pmd[7],
				speed: pmd[8],
				course: pmd[9],
				source: pmd[10]
			}
		};
		parent.Targeting.targetRegister(prop);
	}

	function targetingChangeTargetPropDisplay(prop)
	{
		var id = prop.target.id;
		var newType = prop.target.symbolId;
		var descr = prop.target.symbolDescr;

		if(ge.getElementById(id+'_Placemark_Ic') != null)
		{
			var icon = ge.getElementById(id+'_Icon');
			var pm = ge.getElementById(id+'_Placemark_Ic');
			var pmd = pm.getDescription().split("|");

			icon.setHref("http://" + jsServerName + ":" + jsServerPort + targetingIconsUrl + newType + ".png");
			var pmName = parent.jsTargetingShowIds ? id : " ";
			pm.setName(pmName);

			var newPmDescr = id + "|";
			newPmDescr += newType + "|";
			newPmDescr += descr;
			for(var i=3; i<pmd.length; i++)
			{
				newPmDescr += "|" + pmd[i];
			}
			pm.setDescription(newPmDescr);

			var balloon = ge.getBalloon();
			if( balloon && balloon.getId() == (id+'_HtmlStringBalloon') )
			{
				balloon.setContentString( targetingCreateBalloonContent(id) );
				ge.setBalloon(balloon);
			}
		}
	}

	function targetingCreateBalloonContent(id)
	{
		var pm = ge.getElementById(id+'_Placemark_Ic');

		var descr = pm.getDescription().split("|");
		var tSymbolId = descr[1];
		var tSymbolDescr = descr[2];
		var tLat = descr[3] * 1.0;
		var tLon = descr[4] * 1.0;
		var tAlt = descr[5] * 1.0;
		var tDis = descr[6] * 1.0;
		var tType = descr[7];
		var tSpeed = descr[8] * 1.0;
		var tCourse = descr[9] * 1.0;
		var tSource = descr[10];
		var tObjId = descr[11];

		var content =
		"<table style='border:1pt solid black;'>" +
		//"<tr><td colspan='4' align='right' bgcolor='#778899'><img src='/sdi/global/img/STRATUS-logo_small-STRATUS.png'></td></tr>" +
		"<tr><td colspan='4'><b><i>"+__("Target Parameters")+":</i></b>"+"</td></tr>"+
		"<tr><td colspan='3'>Id: "+id+"</td></tr>"+

		"<tr style='background-color:lightgray;'><td>Latitude</td><td>Longitude</td><td>Altitude</td><td>Distance</td></tr>"+
		"<tr style='background-color:whitesmoke;'>"+
		"<td>" + tLat.toFixed(5) + "</td>"+
		"<td>" + tLon.toFixed(5) + "</td>"+
		"<td>" + tAlt.toFixed(5) + "</td>"+
		"<td>" + tDis.toFixed(5) + "</td></tr>"+
		"<tr><td></td><td></td><td></td><td></td></tr>"+

		"<tr style='background-color:lightgray;'><td>Type</td><td>Speed</td><td>Course</td><td>Source</td></tr>"+
		"<tr style='background-color:whitesmoke;'>"+
		"<td>" + tType + "</td>"+
		"<td>" + tSpeed.toFixed(1) + "</td>"+
		"<td>" + tCourse.toFixed(3) + "</td>"+
		"<td>" + tSource + "</td></tr>"+
		"<tr><td></td><td></td><td></td><td></td></tr>"+

		"<tr><td colspan='4'><b><i>Change Target Type:</i></b></td></tr>";

		content += "<tr><td colspan='4'><select id='tselect' onChange='javascript:targetingChangeTargetProp(\"" + id + "\", this, null);'>";
		for(var i=0; i<MIL_STD_2525C.symbol.length; i++)
		{
			content += "<option value='"+MIL_STD_2525C.symbol[i].identity[0].val+"' ";
			if(MIL_STD_2525C.symbol[i].identity[0].val.substring(2) == tSymbolId.substring(2)) content += "selected";
			content += " >"+MIL_STD_2525C.symbol[i].id+"</option>";
		}
		content += "</select></td></tr>";

		var tId_0 = tSymbolId.substring(0,1);
		var tId_1 = tSymbolId.substring(1,2);
		var tId_2 = tSymbolId.substring(2);

		content += "<tr><td></td><td></td><td></td><td></td></tr>"+

		"<tr>"+
		"<td align='center'><img src='" + targetingIconsUrl + tId_0 + "U" + tId_2 +".png' width='48px' title='UNKNOWN' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"U\" );'/><br/>"+
		"<input type='radio' name='rtarget' value='UNKNOWN' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"U\" );'";
		if(tId_1 == "U") content += "checked";
		content += "></td>"+
		"<td align='center'><img src='" + targetingIconsUrl + tId_0 + "N" + tId_2 +".png' width='48px' title='NEUTRAL' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"N\" );'/><br/>"+
		"<input type='radio' name='rtarget' value='NEUTRAL' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"N\" );'";
		if(tId_1 == "N") content += "checked";
		content += "></td>"+
		"<td align='center'><img src='" + targetingIconsUrl + tId_0 + "H" + tId_2 +".png' width='48px' title='HOSTILE' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"H\" );'/><br/>"+
		"<input type='radio' name='rtarget' value='HOSTILE' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"H\" );'";
		if(tId_1 == "H") content += "checked";
		content += "></td>"+
		"<td align='center'><img src='" + targetingIconsUrl + tId_0 + "F" + tId_2 +".png' width='48px' title='FRIEND' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"F\" );'/><br/>"+
		"<input type='radio' name='rtarget' value='FRIEND' onclick='javascript:targetingChangeTargetProp(\"" + id + "\", null, \"F\" );'";
		if(tId_1 == "F") content += "checked";
		content += "></td>"+
		"</tr>";
		content += "</table>";

		return content;
	}

	function targetingClearScene()
	{
		if(ge.getBalloon()) ge.setBalloon(null);

		var pml = ge.getElementsByType("KmlPlacemark");
		for(var i=0; i<pml.getLength(); i++)
		{
			var pm = pml.item(i);
			if(pm.getId().search(/_Placemark_/g) > -1)
			{
				ge.getFeatures().removeChild(pm);
			}
		}
	}

	function targetingClearTrails()
	{
		if(ge.getBalloon()) ge.setBalloon(null);

		var pml = ge.getElementsByType("KmlPlacemark");
		for(var i=0; i<pml.getLength(); i++)
		{
			var pm = pml.item(i);
			if(pm.getId().search(/_Placemark_Ar_Ls/g) > -1)
			{
				ge.getFeatures().removeChild(pm);
			}
		}
	}

	function targetingArchiveTargetsShow(str)
	{
//-------------------------------------------------------------------------------------------------------------------------------------
// NOT ALL OF THE TARGET ARE SHOWN - TO SEE WHY !!??
		if(str.length < 1) return;

		targetingClearScene();

		var id = null;

		var pmp = null;
		pmp = str.split("|");

		for(var i=0; i<pmp.length; i++)
		{
			var pmSpl = pmp[i].split(",");

			id = pmSpl[2];

			var icon = ge.createIcon(id+'_Icon');
			icon.setHref("http://" + jsServerName + ":" + jsServerPort + targetingIconsUrl + pmSpl[3] + ".png");

			var style = ge.createStyle('');
			style.getIconStyle().setIcon(icon);
			style.getIconStyle().getHotSpot().set(0.5, ge.UNITS_FRACTION, 0, ge.UNITS_FRACTION);
			style.getIconStyle().setScale(0.6);

			var lineStyle = style.getLineStyle();
			lineStyle.setWidth(1);
			lineStyle.getColor().set('ffffffff');  // aabbggrr format

			var pt = ge.createPoint(id+'_Point');
			pt.set(parseFloat(pmSpl[5]), parseFloat(pmSpl[6]), iconAltitude, ge.ALTITUDE_RELATIVE_TO_GROUND, true, false);

			var pm = ge.createPlacemark(id+'_Placemark_Ic');
			var pmName = pmSpl[2];
			pm.setName(pmName);

			var pmDescr = "";
			for(var j=2; j<13; j++)
			{
				pmDescr +=  pmSpl[j] + "|";
			}
			pmDescr +=  pmSpl[1];
			pm.setDescription(pmDescr);

			google.earth.addEventListener(pm, 'click', function(event)
			{
				var id = event.getCurrentTarget().getDescription().split("|")[0];
				event.preventDefault();

				var balloon = ge.createHtmlStringBalloon(id+'_HtmlStringBalloon');
				balloon.setFeature(event.getTarget());
				balloon.setMaxWidth(800);
				balloon.setBackgroundColor("#F5F5F5");
				balloon.setContentString( targetingCreateBalloonContent(id) );
				ge.setBalloon(balloon);
			});

			pm.setGeometry(pt);
			pm.setStyleSelector(style);
			ge.getFeatures().appendChild(pm);
		}
	}

	function targetingArchiveSingleTrailShow(str)
	{
		if(str.length < 1) return;

		targetingClearTrails();

		var id = "singleTrailShow";

		var pmp = null;
		pmp = str.split("|");

		var ls = ge.createLineString(id+'_LineString');
		ls.setTessellate(true);
		ls.setExtrude(true);
		ls.setAltitudeMode(ge.ALTITUDE_RELATIVE_TO_GROUND);

		// Must CREATE String KML, and parse it as kmlTour object (JS API is still under development)!

		for(var i=0; i<pmp.length; i++)
		{
			var pmSpl = pmp[i].split(",");
			var lat = parseFloat(pmSpl[0]);
			var lon = parseFloat(pmSpl[1]);
			ls.getCoordinates().pushLatLngAlt(lat, lon, iconAltitude);
			if(i == 0)
			{
				var lookAt = ge.createLookAt('');
				var pt = ge.getElementById(parent.jsTargetingCurrentTargetId+'_Point');
				lookAt.setLatitude(lat);
				lookAt.setLongitude(lon);
				lookAt.setAltitude(iconAltitude);
				lookAt.setRange(50);
				lookAt.setTilt(45);
				ge.getView().setAbstractView(lookAt);
			}
		}

		var styleLs = ge.createStyle('');
		var lineStyleLs = styleLs.getLineStyle();
		lineStyleLs.setWidth(2);
		lineStyleLs.getColor().set('9900ffff');  // aabbggrr format
		var polyStyle = styleLs.getPolyStyle();
		polyStyle.getColor().set('7f00aa00');

		var pmLs = ge.createPlacemark(id+'_Placemark_Ar_Ls');
		pmLs.setGeometry(ls);
		pmLs.setStyleSelector(styleLs);
		ge.getFeatures().appendChild(pmLs);
	}

	function targetingTargetSelected(id)
	{
		var lSt;
		if(id == null){
			return;
		}

		if(ge.getBalloon()) ge.setBalloon(null);

		var pml = ge.getElementsByType("KmlPlacemark");
		for(var i=0; i<pml.getLength(); i++)
		{
			var pm = pml.item(i);
			if(pm.getId().search(/_Placemark_Ic/g) > -1)
			{
				lSt = pm.getStyleSelector().getLineStyle();
				lSt.setWidth(1);
				lSt.getColor().set('ffffffff'); // aabbggrr format

			} else if(pm.getId().search(/_Placemark_Ls/g) > -1) {

				var lineWidth = parent.jsTargetingShowTrails ? 3 : 0;
				lSt = pm.getStyleSelector().getLineStyle();
				lSt.setWidth(lineWidth);
				pm.getGeometry().setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);
			}
		}

		if(id !== "noneSelected")
		{
			var pmic = ge.getElementById(parent.jsTargetingCurrentTargetId+'_Placemark_Ic');
			if (pmic)
			{
				lSt = pmic.getStyleSelector().getLineStyle();
				lSt.setWidth(2);
				lSt.getColor().set('ff0000ff'); // aabbggrr format
			}

			if(parent.jsTargetingShowTrails)
			{
				var pm = ge.getElementById(parent.jsTargetingCurrentTargetId+'_Placemark_Ls');
				if (pm)
				{
					pm.getStyleSelector().getLineStyle().setWidth(3);
					pm.getGeometry().setAltitudeMode(ge.ALTITUDE_RELATIVE_TO_GROUND);
				}
			}

			var objId = parent.document.getElementById("ge_designation_camera_follow_list").value;

			if(objId != "none")
			{
				var new_lat = pmic.getGeometry().getLatitude();
				var new_lon = pmic.getGeometry().getLongitude();
				var new_alt = 0.0;

				var objDev = window['device_'+objId];
				var dev_lat = objDev.point.getLatitude();
				var dev_lon = objDev.point.getLongitude();
				var dev_alt = objDev.point.getAltitude();
				var offset = objDev.offset_north;

				devGeo2Absolute.setParams(dev_lat, dev_lon, dev_alt, new_lat, new_lon, new_alt, offset);
				var anglePan = Math.round(devGeo2Absolute.getPan());
				var angleTilt = Math.round(devGeo2Absolute.getTilt());
				//var distance = devGeo2Absolute.getDist();

				parent.mx.GE.callPTZmoveAbs(objId, anglePan, angleTilt);
				//parent.Targeting.setCameraPtzPosition(objId, distance, anglePan, angleTilt);

				objDev.azimuth = (-1) * devGeo2Absolute.getAn2p();
				cameraChangeFieldOfView(objDev);
			}

			var lookAt = ge.createLookAt('');
			var pt = ge.getElementById(parent.jsTargetingCurrentTargetId+'_Point');
			if (pt)
			{
				lookAt.setLatitude(pt.getLatitude());
				lookAt.setLongitude(pt.getLongitude());
				lookAt.setAltitude(pt.getAltitude());
				lookAt.setRange(50);
				lookAt.setTilt(45);
	            ge.getView().setAbstractView(lookAt);
			}

			ptz(id);
		}
	}

	function ptz(targetId)
	{
		var api = new API();
		api.getTargetRelatedZone({
			targetId: targetId
		})
			.done(function(response){
				var list = response.cameraList.join(",");
				var position = response.position;
				var lat = position.lat;
				var lng = position.lng;
				var alt = position.alt;

				// TODO: add correct priority checking
				parent.HWJoystick.sendCommand("target=" + targetId + "&mode=abs&lat=" + lat + "&long=" + lng + "&elev=" + alt + "&slew=" + list, false, 9);
			});
	}

	function targetingRadarFovSet(message)
	{
		var json = $.parseJSON(message.getAttribute("fov"));

		var rId = message.getAttribute("objid");
		var rLa = parseFloat(json.result.geolocation.latitude);
		var rLo = parseFloat(json.result.geolocation.longitude);
		var rAl = parseFloat(json.result.geolocation.altitude);

		// Radar Icon
		var iconHref = "http://" + jsServerName + ":" + jsServerPort + targetingIconsUrl + "SFGPUUMRG-.png";

		var bContent =
			"<table style='border:1pt solid black;'>" +
			"<tr><td><b><i>Radar</i></b></td><td><img src='"+iconHref+"'/></td></tr>"+
			"<tr><td><b>Object Id:</b></td><td>"+rId+"</td></tr>"+
			"<tr><td><b>Serial:</b></td><td>"+json.serial+"</td></tr>"+
			//"<tr><td>userSession:</td><td>"+json.userSession+"</td></tr>"+
			"<tr><td><b>timestamp:</b></td><td>"+json.timestamp+"</td></tr>"+
			"<tr><td><b>Geolocation</b></td><td></td></tr>"+
			"<tr><td><i>latitude:</i></td><td>"+json.result.geolocation.latitude+"</td></tr>"+
			"<tr><td><i>longitude:</i></td><td>"+json.result.geolocation.longitude+"</td></tr>"+
			"<tr><td><i>altitude:</i></td><td>"+json.result.geolocation.altitude+"</td></tr>"+
			"<tr><td><i>bearing:</i></td><td>"+json.result.geolocation.bearing+"</td></tr>";

		var balloon = ge.getBalloon();
		if( balloon && balloon.getId() == (rId+'_HtmlStringBalloon') )
		{
			balloon.setContentString( bContent );
			ge.setBalloon(balloon);
		}

		if(ge.getElementById(rId+'_Radar_Ic_Pm') != null)
		{
			var pt = ge.getElementById(rId+'_Radar_Ic_Pt');
		} else {
			var icon = ge.createIcon('');
			icon.setHref(iconHref);

			var style = ge.createStyle('');
			style.getIconStyle().setIcon(icon);
			style.getIconStyle().getHotSpot().set(0.5, ge.UNITS_FRACTION, 0, ge.UNITS_FRACTION);
			style.getIconStyle().setScale(0.6);

			var lineStyle = style.getLineStyle();
			lineStyle.setWidth(1);
			lineStyle.getColor().set('ffffffff');  // aabbggrr format

			var pt = ge.createPoint(rId+'_Radar_Ic_Pt');

			var pmic = ge.createPlacemark(rId+'_Radar_Ic_Pm');
			var pmName = parent.jsTargetingShowIds ? ("Radar_id_" + rId) : " ";
			pmic.setName(pmName);

			google.earth.addEventListener(pmic, 'click', function(event)
			{
				event.preventDefault();

				var balloon = ge.createHtmlStringBalloon(rId+'_HtmlStringBalloon');
				balloon.setFeature(event.getTarget());
				balloon.setMaxWidth(800);
				balloon.setBackgroundColor("#F5F5F5");

				balloon.setContentString( bContent );
				ge.setBalloon(balloon);
			});

			pmic.setGeometry(pt);
			pmic.setStyleSelector(style);
			ge.getFeatures().appendChild(pmic);
		}
		pt.set(rLa, rLo, rAl, ge.ALTITUDE_ABSOLUTE, true, false);

		// Radar FOV Polygon
		if(ge.getElementById(rId+'_Radar_Py_Pm') != null)
		{
			var outer = ge.getElementById(rId+'_Radar_Py_Lr');
			outer.getCoordinates().clear();

		} else {
			var placemark = ge.createPlacemark(rId+'_Radar_Py_Pm');

			if (!placemark.getStyleSelector())
			{
				placemark.setStyleSelector(ge.createStyle(''));
				var lineStyle = placemark.getStyleSelector().getLineStyle();
				lineStyle.setWidth(1);
				lineStyle.getColor().set('aa00ff00');
				placemark.getStyleSelector().getPolyStyle().getColor().set('330000ff');
			}

			var polygon = ge.createPolygon('');
			placemark.setGeometry(polygon);
			polygon.setTessellate(false);

			var outer = ge.createLinearRing(rId+'_Radar_Py_Lr');
			polygon.setOuterBoundary(outer);
			polygon.setAltitudeMode(ge.ALTITUDE_CLAMP_TO_GROUND);

		}

		var coords = outer.getCoordinates();
		var vrt = json.result.fieldOfView;
		for(var i=0; i<vrt.length; i++)
		{
			var lat = parseFloat(vrt[i].latitude);
			var lon = parseFloat(vrt[i].longitude);
			var alt = parseFloat(vrt[i].altitude);
			coords.pushLatLngAlt(lat, lon, alt);
		}

		if(ge.getElementById(rId+'_Radar_Py_Pm') == null) ge.getFeatures().appendChild(placemark);
	}

	function targetingSceneRecycle()
	{
		var childNodes = null;

		try {
			childNodes = ge.getFeatures().hasChildNodes();
		}
		catch (e)
		{
			window.console && window.console.error(e);
			return;
		}

		var delList = [];

		if (childNodes)
		{
			var chNodes = ge.getFeatures().getChildNodes();

			var tId = "";
			var tDcsr = "";
			var currTime = (new Date()).getTime();
			var timeDiff = 0;

			var pmNumber = chNodes.getLength();

			var pmDs = [];

			var i;
			for (i = 0; i < pmNumber; i++)
			{
				tId = chNodes.item(i).getId();
				if( tId.search(/_Placemark_Ls/g) > -1)
				{
					pmDs.push(chNodes.item(i).getDescription()*1);
				}
			}

			if(pmDs.length > parent.jsTargetingSceneRecycleMaxTargets )
			{
				pmDs.sort(function(a,b){return b-a});
				var thr = pmDs[parent.jsTargetingSceneRecycleMaxTargets - 1];

				for (i = 0; i < pmNumber; i++)
				{
					tId = chNodes.item(i).getId();
					if( tId.search(/_Placemark_Ls/g) > -1)
					{
						if(chNodes.item(i).getDescription()*1 < thr)
						{
							ge.getFeatures().removeChild(chNodes.item(i));
							ge.getFeatures().removeChild(ge.getElementById(tId.replace("_Placemark_Ls", "_Placemark_Ic")));

							delList.push(tId.split("_Placemark_Ls")[0]);
						}
					}
				}
			} else {
				for (i = 0; i < pmNumber; i++)
				{
					tId = chNodes.item(i).getId();

					if( tId.search(/_Placemark_Ls/g) > -1)
					{
						timeDiff = currTime - chNodes.item(i).getDescription()*1;

						if(timeDiff >= parent.jsTargetingSceneTargetExpirationTime)
						{
							ge.getFeatures().removeChild(chNodes.item(i));
							ge.getFeatures().removeChild(ge.getElementById(tId.replace("_Placemark_Ls", "_Placemark_Ic")));
							delList.push(tId.split("_Placemark_Ls")[0]);
						}
					}
				}
			}
		}

		parent.mx.GE.designation.delTargetsFromList(delList);

		parent.jsTargetingLastSceneRecycle = (new Date()).getTime();
		window.setTimeout(targetingSceneRecycle, parent.jsTargetingSceneRecycleRefreshTime);
	}
