/**
 * User: abaev
 * Date: 13.10.2010
 * Time: 17:08:24
 */

var ge_3d_mapping_mode = window.ge_3d_mapping_mode;
var ge_3d_mapping_hosted_key = window.ge_3d_mapping_hosted_key;
var ge_3d_mapping_hosted_datasource = window.ge_3d_mapping_hosted_datasource;

if(ge_3d_mapping_mode == 'hosted') {
	if (!("google" in window)) { window.google = {}; }
	if (!("loader" in window.google)) { window.google.loader = {}; }
	if (!("earth" in window.google)) { window.google.earth = {}; }
	window.google.loader.ApiKey = ge_3d_mapping_hosted_key;
	window.google.loader.KeyVerified = true;
	window.google.earth.allowUsageLogging = false;
	window.google.earth.setErrorUrl("/sdi/ge/ge_error.php");
} else {
	google.load("earth", "1");
}

var ge = null;

var systemObject = new SystemObject();

var obj_3d_models_list = [];
var obj_3d_models_placemarks = {};

var default_layer_height = 3; //meters

/*
 google earth initialization
 */
function ge_initialize() {
	if (google && google.loader.LoadFailure) {
		alert(__("Install Google Earth plugin first!"));
	} else
	if (document.getElementById('map3d')) {
		if (ge_3d_mapping_mode == 'hosted') {
			google.earth.createInstance('map3d', on_ge_success, on_ge_failure, {database: ge_3d_mapping_hosted_datasource});
		} else {
			google.earth.createInstance("map3d", on_ge_success, on_ge_failure);
		}
	}

}

/*
 on ge initialization success callback
 */
function on_ge_success(object) {
    get_3d_models_data(obj_3d_models_list, function(data) {
        for (var i = 0; i < obj_3d_models_list.length; i++) {
            var obj = obj_3d_models_list[i];

            var option = $("<option></option>");
            option.val(obj.obj);
            option.html(obj.name);
            option.attr("latitude", obj.attributes.LATITUDE);
            option.attr("longitude", obj.attributes.LONGITUDE);
            option.attr("associate", obj.attributes.ASSOCIATE);

            $("#3d_models").append(option);
        }
    });

    ge = object;

	var geFeatures = ge.getLayerRoot().getFeatures().getChildNodes();
	for(var i=0; i<geFeatures.getLength(); i++) {
		ge.getLayerRoot().enableLayerById(geFeatures.item(i).getId(), true);
	}
	//ge.getLayerRoot().enableLayerById(ge.LAYER_BORDERS, true);
    //ge.getLayerRoot().enableLayerById(ge.LAYER_BUILDINGS, true);

    ge.getOptions().setAtmosphereVisibility(true);
    ge.getOptions().setStatusBarVisibility(true);
    ge.getWindow().setVisibility(true);
    ge.getNavigationControl().setVisibility(ge.VISIBILITY_AUTO);

    google.earth.addEventListener(ge.getWindow(), 'mouseup', function(event) {
        event.preventDefault();
        updatedViewData()
    });

    var view = GE_3D_MODEL_VIEW.split(",");
    for(var i = 0; i < view.length; i++){
        view[i] = parseFloat(view[i]);
    }

    $("#scene_lat").val(view[0]);
    $("#scene_lon").val(view[1]);
    $("#scene_alt").val(view[2]);
    $("#scene_range").val(view[3]);
    $("#scene_tilt").val(view[4]);
    $("#scene_heading").val(view[5]);

    var ge_view = ge.getView().copyAsLookAt(ge.ALTITUDE_CLAMP_TO_GROUND);
	ge_view.setLatitude(view[0]);
	ge_view.setLongitude(view[1]);
	ge_view.setAltitude(view[2]);
	ge_view.setRange(view[3]);
	ge_view.setTilt(view[4]);
	ge_view.setHeading(view[5]);
	ge.getView().setAbstractView(ge_view);

    $("#edit_scene_view").prop("disabled", false);
    $("#3d_models").prop("disabled", false);
    $("#3d_model_layers").prop("disabled", false);
    $("#new_model").prop("disabled", false);

	ge_monitor();
}

/*
 on ge initialization failure callback
 */
function on_ge_failure(object) {
    //alert("Google Earth not initialized!");
    //TODO hide all manipulation elements
}

function ge_monitor(){
	if(google.loader.LoadFailure || !google.loader.KeyVerified || google.earth.e){
		parent.alert(__("Google Earth plugin crashed. Component reloaded."));
		window.location.href = window.location.href;
	}
	else{
		window.setTimeout(function() { ge_monitor(); }, 20000);
	}
}

/*
* update view data
* */
function updatedViewData(){
    var ge_view = ge.getView().copyAsLookAt(ge.ALTITUDE_CLAMP_TO_GROUND);
    $("#scene_lat").val(ge_view.getLatitude());
    $("#scene_lon").val(ge_view.getLongitude());
    $("#scene_alt").val(ge_view.getAltitude());
    $("#scene_range").val(ge_view.getRange());
    $("#scene_tilt").val(ge_view.getTilt());
    $("#scene_heading").val(ge_view.getHeading());
}

/*
 show add new model form
 */
function new_model() {
    $("#model_name").val('');
    $("#model_layers").val(1);
    $("#model_layers").prop("disabled", false);
    $("#model_layers_height").val(default_layer_height);
    $("#model_action").val('add');
    $("#model_save").unbind('click').bind('click', save_model);
    $("#model_editor").show();

    $("#model_layer_add").hide();
    $("#model_layer_remove").hide();
    $("#3d_models_layers_block").hide();
}

/*
 save model to server
 */
function save_model() {
    var model_name = $("#model_name").val();
    var model_layers = $("#model_layers").val();
    var model_layers_height = $("#model_layers_height").val();

    var model_id = $("#3d_models").val();
    var model_action = $("#model_action").val();

    if (model_name == '') {
        alert(__("Input model name!"));
        return;
    }
    else if (model_layers == '' || parseInt(model_layers) <= 0) {
        alert(__("Input model number of layers!"));
        return;
    }
    else if (model_layers_height == '' || parseInt(model_layers_height) <= 0) {
        alert(__("Input model layer height!"));
        return;
    }

    var strLayers = '';
    var attributes = {
        "NAME": model_name,
        "DEFAULT_LAYER_HEIGHT": parseFloat(model_layers_height)
    };

    if (model_action == 'add') {
        for (var i = 1; i <= $("#model_layers").val(); i++) {
            strLayers += i;
            if (i != $("#model_layers").val()) {
                strLayers += ',';
            }
        }
        $.extend(attributes, {"ASSOCIATE":strLayers});
    }

    var data = {
        type: "model3d",
        attributes:  attributes,
        callback: function(json) {
            if (json.error != "") {
                alert(__("Add 3D object error: ") + json.error);
            } else {
                $("#model_editor").hide();
                if (model_action == 'add') {
                    var data_attr = {
                        obj: json.obj,
                        callback: function(data) {
                            if (data.error != "") {
                                alert(__("Get 3D object attributes error: ") + json.error);
                            } else {
                                get_model_layers(json.obj, obj_3d_models_list, function(data2) {
                                    add_new_model_to_list(json.obj, data.list, data2.list);
                                });
                            }
                        }
                    };

                    systemObject.getAttributes(data_attr);
                }
                else if (model_action == 'edit') {
                    get_model_layers(model_id, obj_3d_models_list, null);
                    var model = get_model_data_by_id(obj_3d_models_list, model_id);
                    if(model_name){
                        var option = $("#3d_models option[value='" + model_id + "']");
                        option.text(model_name);
                        model.attributes.NAME = model_name;
                        model.attributes.DEFAULT_LAYER_HEIGHT = model_layers_height;
                    }
                }
            }
        }
    };

    if (model_action == 'add') {
        systemObject.create(data);
    }
    else if (model_action == 'edit') {
        $.extend(data, {"obj":model_id});
        systemObject.setAttributes(data);
    }

    $("#3d_models_layers_block").show();
}

/*
 add new model data to list
 */
function add_new_model_to_list(obj_id, params, layers) {
    var new_model = {};
    new_model.obj = obj_id;
    new_model.name = params.NAME;
    new_model.layers = layers;
    new_model.attributes = {};
    new_model.attributes.NAME = params.NAME;
    new_model.attributes.ASSOCIATE = params.ASSOCIATE;
    new_model.attributes.DEFAULT_LAYER_HEIGHT = params.DEFAULT_LAYER_HEIGHT;
    obj_3d_models_list.push(new_model);

    var option = $("<option></option>");
    option.val(obj_id);
    option.html(new_model.attributes.NAME);
    option.attr("layers", new_model.layers.length);
    option.attr("associate", new_model.attributes.ASSOCIATE);
    option.attr("default_layer_height", new_model.attributes.DEFAULT_LAYER_HEIGHT);
    option.prop("selected", true);
    $("#3d_models").append(option);

    fill_model_layers(obj_id);

    enable_buttons();

    $("#layer_file_upload").hide();
    $("#3d_models_layers_block").show();
}

/*
 show edit new model form
 */
function edit_model() {
    var model_id = $("#3d_models").val();
    fill_model_data(model_id);
    $("#model_action").val('edit');
    $("#model_layers").prop("disabled", true);
    $("#model_save").unbind('click').bind('click', save_model);

    $("#3d_models_layers_block").hide();

    $("#model_layer_add").show();
    $("#model_layer_remove").show();

    $("#model_editor").show();
}

/*
 delete 3D model
 */
function delete_model() {
    var model_id = $("#3d_models").val();
    $.ajax({
        url: "/sdi/ge/api.php",
        dataType: "json",
        cache: false,
        data: {
            "obj": model_id
        },
        success: function(response) {
            if (response.error == "") {
                if(response.parent != ""){
                    alert(__("Model couldn't be deleted. This model assocciated to object(s): ") + response.parent + ".");
                    return;
                }

                if (confirm(__("Are you sure to delete current 3D model?"))) {
                    var data = {
                        'obj': model_id,
                        callback: function(json) {
                            if (json.error != "") {
                                alert(__("Delete 3D model error: ") + json.error);
                            } else {
                                $("#model_editor").hide();

                                for (var i = 0; i < obj_3d_models_list.length; i++) {
                                    if (obj_3d_models_list[i].obj == model_id) {
                                        obj_3d_models_list.splice(i, 1);
                                        break;
                                    }
                                }

                                $("#3d_models option[value='" + model_id + "']").remove();
                                $("#3d_model_layers").find("option:not(:first-child)").remove();

                                if ($("#3d_models option").size() == 1) {
                                    $("#3d_models").val(0);
                                    disable_buttons();
                                    hide_all_models_placemarks(obj_3d_models_placemarks);
                                    $("#3d_models_layers_block").hide();
                                }
                                else{
                                    var new_model_id = $("#3d_models").find("option:first-child").next().val();
                                    $("#3d_models").val(new_model_id);
                                    on_select_3d_model();
                                }

                                $("#3d_model_layers").val(0);
                                $("#layer_file_upload").hide();
                                alert(__("3D model successfully deleted!"));
                            }
                        }
                    };

                    systemObject.remove(data);
                }
            }
            else{
                alert(__("Check 3D model error: ") + response.error);
            }
        },
        failure: function() {
        }
    });
}

/*
 delete 3D model layers
 */
function delete_model_layers(model_id, layers_arr) {
    $("#model_layer_add").prop("disabled", true);
    $("#model_layer_remove").prop("disabled", true);
    $.ajax({
        url: "/sdi/ge/api.php",
        dataType: "json",
        cache: false,
        data: {
            "obj": layers_arr[0]
        },
        success: function(response) {
            if (response.error == "") {
                if (response.parent != "") {
                    alert(__("Layer couldn't be deleted. This layer assocciated to object(s): ") + response.parent + ".");
                    $("#model_layer_add").prop("disabled", false);
                    $("#model_layer_remove").prop("disabled", false);
                    return;
                }

                var data = {
                    type: "modellayer",
                    objList:  layers_arr,
                    callback: function(json) {
                        if (json.error != "") {
                            alert(__("Remove 3D model layer error: ") + json.error);
                        } else {
                            var obj = get_model_data_by_id(obj_3d_models_list, model_id);
                            var str_new_associate = parse_ids_from_associate(obj.attributes.ASSOCIATE, layers_arr);
                            var data_attr = {
                                type: "model3d",
                                obj: model_id,
                                attributes:  {"ASSOCIATE": str_new_associate},
                                callback: function(json) {
                                    if (json.error != "") {
                                        alert(__("Add 3D model layer error: ") + json.error);
                                    } else {
                                        obj.attributes.ASSOCIATE = str_new_associate;

                                        var placemark = get_layer_placemark(obj_3d_models_placemarks, layers_arr[0]);
                                        if(placemark){
                                            placemark.setVisibility(false);
                                            ge.getFeatures().removeChild(placemark);
                                        }

                                        remove_layer_placemark(obj_3d_models_placemarks, layers_arr[0]);

                                        get_model_layers(model_id, obj_3d_models_list, function(data) {
                                            fill_model_data(model_id);
                                        });
                                    }
                                    $("#model_layer_add").prop("disabled", false);
                                    $("#model_layer_remove").prop("disabled", false);
                                }
                            };

                            systemObject.setAttributes(data_attr);
                        }
                    }
                };

                systemObject.remove(data);
            }
            else {
                alert(__("Check 3D model layer error: ") + response.error);
                $("#model_layer_add").prop("disabled", false);
                $("#model_layer_remove").prop("disabled", false);
            }
        },
        failure: function() {
            $("#model_layer_add").prop("disabled", false);
            $("#model_layer_remove").prop("disabled", false);
        }
    });
}

/*
 parse object ids from associate attribute
 */
function parse_ids_from_associate(str_assoc, arr_ids) {
    var assocIds = str_assoc.split(",");
    for (var i = 0; i < arr_ids.length; i++) {
        for (var j = 0; j < assocIds.length; j++) {
            if(assocIds[j] == arr_ids[i]){
                assocIds.splice(j, 1);
            }
        }
    }
    return assocIds.join(",");
}

/*
 cancel 3D model operations, restore initial values
 */
function cancel_model_operations() {
    var action = $("#model_action").val();
    if (action == "add") {
        new_model();
    }
    else if (action == "edit") {
        edit_model();
    }
    $("#model_editor").hide();
    $("#3d_models_layers_block").show();
}

/*
 enable edit buttons
 */
function enable_buttons() {
    $("#edit_model").prop("disabled", false);
    $("#delete_model").prop("disabled", false);
}

/*
 disable edit buttons
 */
function disable_buttons() {
    $("#edit_model").prop("disabled", true);
    $("#delete_model").prop("disabled", true);
}

/*
 on 3d model selection
 */
function on_select_3d_model() {
    var model_id = $("#3d_models").val();
    var model = get_model_data_by_id(obj_3d_models_list, model_id);

    hide_all_models_placemarks(obj_3d_models_placemarks);

    fill_model_data(model_id);

    var exists_placemark_layer_id = null;
    for (var i = 0; i < model.layers.length; i++) {
        if($.isEmptyObject(model.layers[i].blocks)){
            continue;
        }
        //if placemark not exists and file not loaded - load it
        var placemark = get_layer_placemark(obj_3d_models_placemarks, model.layers[i].obj);
        if (placemark == null) {
            load_layer_file(model.layers[i], obj_3d_models_placemarks);
            if(exists_placemark_layer_id == null){
                exists_placemark_layer_id = model.layers[i].obj;
            }
        }
        else if(placemark != null){
            placemark.setVisibility(true);
            if(exists_placemark_layer_id == null){
                exists_placemark_layer_id = model.layers[i].obj;
            }
        }
    }

    if(exists_placemark_layer_id){
        center_on_model_layer(exists_placemark_layer_id);
    }
    else{
        alert(__("No layers uploaded for this model!"));
    }

    enable_buttons();
    $("#layer_file_upload").hide();
    $("#3d_models_layers_block").show();
}

/*
 center on 3d model
 */
function center_on_model_layer(layer_id){
    var placemark = get_layer_placemark(obj_3d_models_placemarks, layer_id);
    if(placemark){
        var lat = placemark.getGeometry().getLocation().getLatitude();
        var lon = placemark.getGeometry().getLocation().getLongitude();
        change_view(lat, lon, null, 30);
        updatedViewData();
    }
    else{
        window.setTimeout(function(){ center_on_model_layer(layer_id); }, 250);
    }
}

/*
 fill model data into form
 */
function fill_model_data(model_id) {
    var option = $("#3d_models option[value='" + model_id + "']");
    var obj = get_model_data_by_id(obj_3d_models_list, model_id);
    $("#model_name").val(option.text());
    $("#model_layers").val(obj.layers.length);
    $("#model_layers_height").val(obj.attributes.DEFAULT_LAYER_HEIGHT);

    fill_model_layers(model_id);
}

/*
 fill model layers
 */
function fill_model_layers(model_id) {
    $("#3d_model_layers").find("option:not(:first-child)").remove();

    var obj = get_model_data_by_id(obj_3d_models_list, model_id);
    for (var j = 1; j <= obj.layers.length; j++) {
        for (var i = 0; i < obj.layers.length; i++) {
            if (obj.layers[i].attributes.NUMBER == j) {
                var option = $("<option></option>");
                option.val(obj.layers[i].obj);

                var name = obj.layers[i].attributes.NUMBER;
                if (obj.layers[i].attributes.NAME != "") {
                    name = obj.layers[i].attributes.NAME;
                }
                option.html(obj.layers[i].attributes.NUMBER+". "+name);

                var block_id = null;
                var file_link = '';
                for (var id in obj.layers[i].blocks) {
                    block_id = id;
                    file_link = obj.layers[i].blocks[id];
                    //get only first block
                    break;
                }
                option.attr("block_id", block_id);
                option.attr("url", file_link);
                option.attr("layer", obj.layers[i].attributes.NUMBER);

                $("#3d_model_layers").append(option);
            }
        }
    }
}

/*
 on 3D model layer selection
 */
function on_select_3d_model_layer() {
    var model_id = $("#3d_models").val();
    var layer_id = $("#3d_model_layers").val();
    var obj = get_model_data_by_id(obj_3d_models_list, model_id);
    var current_layer = get_model_layer_data_by_id(obj_3d_models_list, model_id, layer_id);

    var current_layer_option = $("#3d_model_layers option[value='" + layer_id + "']");

    $("#upload_block_id").val(current_layer_option.attr("block_id"));

    set_layer_message(current_layer);

    $("#layer_file_upload").show();

    var layer_height = current_layer.attributes.LAYER_HEIGHT;
    if(layer_height == ""){
        layer_height = obj.attributes.DEFAULT_LAYER_HEIGHT;
    }
    $("#layer_height").val(layer_height);

    var layer_name = current_layer.attributes.NAME;
    if(layer_name == ""){
        layer_name = current_layer.attributes.NUMBER;
    }
    $("#layer_name").val(layer_name);

    for (var i = 0; i < obj.layers.length; i++) {
        var layer = obj.layers[i];
        var layer_placemark = get_layer_placemark(obj_3d_models_placemarks, layer.obj);

        if (layer_placemark == null) {
            continue;
        }

        if (layer.attributes.NUMBER <= current_layer.attributes.NUMBER) {
            layer_placemark.setVisibility(true);
        }
        else {
            layer_placemark.setVisibility(false);
        }
    }
}

/*
 set layer message
 */
function set_layer_message(layer) {
    var isEmpty = true;
    var block_url = null;
    var text = '';
    for (var id in layer.blocks) {
        isEmpty = false;
        block_url = layer.blocks[id];
        break;
    }

    var msg = "";
    if (!isEmpty) {
        text = __("UPLOADED FILE");
        var index = block_url.lastIndexOf("/");
        msg += '<span style="color:#007700">'+text+':</span> <a href="' + block_url + '">' + block_url.substr(index + 1) + '</a>';
        msg += '<br />';
        $("#upload_remove_block").show();
        $("#upload_file_block").hide();
    }
    else {
        text = __("NO FILE UPLOADED");
        msg += '<span style="color:#770000">'+text+'</span>';
        $("#upload_remove_block").hide();
        $("#upload_file_block").show();

    }
    $("#upload_info").html(msg);
}

/*
 add layer into model
 */
function add_layer() {
    var model_id = $("#3d_models").val();
    var obj = get_model_data_by_id(obj_3d_models_list, model_id);
    var new_layer_number = obj.layers.length + 1;

    $("#model_layer_add").prop("disabled", true);
    $("#model_layer_remove").prop("disabled", true);

    var data_l = {
        type: "modellayer",
        attributes:  { "NAME": new_layer_number, "NUMBER": new_layer_number },
        callback: function(json) {
            if (json.error != "") {
                alert(__("Add 3D object layer error: ") + json.error);
            } else {
                var new_strassociate = "";
                if (obj.attributes.ASSOCIATE) {
                    new_strassociate = obj.attributes.ASSOCIATE + "," + json.obj;
                }
                else {
                    new_strassociate = json.obj;
                }

                var data = {
                    type: "model3d",
                    obj: model_id,
                    attributes:  {"ASSOCIATE": new_strassociate},
                    callback: function(json) {
                        if (json.error != "") {
                            alert(__("Add 3D object layer error: ") + json.error);
                        } else {
                            obj.attributes.ASSOCIATE = new_strassociate;
                            get_model_layers(model_id, obj_3d_models_list, function(data){
                                fill_model_data(model_id);
                            });
                        }
                        $("#model_layer_add").prop("disabled", false);
                        $("#model_layer_remove").prop("disabled", false);
                    }
                };

                systemObject.setAttributes(data);
            }
        }
    };

    systemObject.create(data_l);
}

/*
 save layer height
 */
function save_layer_data(){
    var layer_height = $("#layer_height").val();
    var layer_name = $("#layer_name").val();
    var model_id = $("#3d_models").val();
    var layer_id = $("#3d_model_layers").val();
    var layer = get_model_layer_data_by_id(obj_3d_models_list, model_id, layer_id);

    var data = {
        type: "modellayer",
        obj: layer_id,
        attributes:  {"NAME": layer_name, "LAYER_HEIGHT": layer_height},
        callback: function(json) {
            if (json.error != "") {
                alert(__("Save layer height error: ") + json.error);
            } else {
                var option = $("#3d_model_layers option[value='" + layer_id + "']");
                option.html(layer.attributes.NUMBER+". "+layer_name);
                layer.attributes.NAME = layer_name;
                layer.attributes.LAYER_HEIGHT = layer_height;
                alert(__("Layer parameters saved!"));
            }
        }
    };

    systemObject.setAttributes(data);
}

/*
 remove model layer
 */
function remove_layer() {
    var model_id = $("#3d_models").val();
    var obj = get_model_data_by_id(obj_3d_models_list, model_id);
    var layer_data = {"id": 0, "number": 0};

    for (var i = 0; i < obj.layers.length; i++) {
        var cur_number = parseInt(obj.layers[i].attributes.NUMBER);
        if (layer_data.number < cur_number) {
            layer_data.id = obj.layers[i].obj;
            layer_data.number = cur_number;
        }
    }

    delete_model_layers(model_id, [layer_data.id]);
}

/*
 upload file
 */
function upload_file() {
    var model_id = $("#3d_models").val();
    var model = get_model_data_by_id(obj_3d_models_list, model_id, layer_id);
    var layer_id = $("#3d_model_layers").val();
    var layer = get_model_layer_data_by_id(obj_3d_models_list, model_id, layer_id);
    var block_id = null;
    var desc = $("#block").val().toString();

    if ($("#upload_block_id").val() != '') {
        block_id = $("#upload_block_id").val();
    }

    $("#upload_file_button").prop("disabled", true);
    $("#save_layer_button").prop("disabled", true);

    $.ajaxFileUpload({
        url:'/api/call.php',
        secureuri: false,
        fileElementId: 'block',
        dataType: 'json',
        data: {
            "function": "setBlock",
            "obj": layer_id,
            "blockId": block_id,
            "description": desc,
			"token": getToken()
        },
        success: function (data, status) {
            if (data.error != '') {
                alert(__("Error on file upload: ") + data.error);
            }
            else {
                var block_id = data.blockId.toString();
                var url = data.url;
                layer.blocks[block_id] = url;
                load_layer_file(layer, obj_3d_models_placemarks);
                center_on_model_layer(layer.obj);
                set_layer_message(layer);
                alert(__("File uploaded!"));
            }
            $("#upload_file_button").prop("disabled", false);
            $("#save_layer_button").prop("disabled", false);
        },
        error: function (data, status, e) {
            alert(e);
            $("#upload_file_button").prop("disabled", false);
            $("#save_layer_button").prop("disabled", false);
        }
    });
}

/*
 clear file block
 */
function remove_file() {
    var model_id = $("#3d_models").val();
    var layer_id = $("#3d_model_layers").val();
    var layer = get_model_layer_data_by_id(obj_3d_models_list, model_id, layer_id);

    var blockIdListData = [];

    for (var id in layer.blocks) {
        blockIdListData.push(id);
        //only first file
        break;
    }

    $.ajax({
        url: "/api/call.php",
        type: "POST",
        dataType: 'json',
        data: {
            'function': 'deleteBlocks',
            'obj': layer_id,
            'blockIdList': JSON.stringify(blockIdListData)
        },
        success: function(data) {
            if (data.error != '') {
                alert(__("Error on block delete: ") + data.error);
            }
            else {
                for (var id in layer.blocks) {
                    delete layer.blocks[id];
                    //only first file
                    break;
                }

                var placemark = get_layer_placemark(obj_3d_models_placemarks, layer.obj);
                if(placemark){
                    placemark.setVisibility(false);
                    ge.getFeatures().removeChild(placemark);
                }

                remove_layer_placemark(obj_3d_models_placemarks, layer.obj);

                set_layer_message(layer);
                alert(__("File removed!"));
            }
        }
    });
}

/*
 show view editor
 */
function show_view_editor(){
    $("#view_editor").show();
}

/*
 hide view editor
 */
function hide_view_editor(){
    $("#view_editor").hide();
}

/*
 save scene view
 */
function save_view(){
	var lat = $("#scene_lat").val();
	var lon = $("#scene_lon").val();
	var alt = $("#scene_alt").val();
	var range = $("#scene_range").val();
	var tilt = $("#scene_tilt").val();
	var heading = $("#scene_heading").val();

	if (lat == '' || lon == '' || alt == '' || range == '' || tilt == '' || heading == '') {
		alert(__("All view parameters should be set!"));
		return;
	}

	$("#edit_scene_save").prop("disabled", true);
	$("#edit_scene_cancel").prop("disabled", true);

	var attr = "GE_3D_MODEL_VIEW";
	var value = lat + "," + lon + "," + alt + "," + range + "," + tilt + "," + heading;
	var attribute = {};
	attribute[attr] = value;

	var api = new API();
	api.setIdentityAttributes({
		attributes: JSON.stringify(attribute)
	})
		.fail(function (code, message) {
			Log.error(__("Update Identity eror: ") + message);
		})
		.done(function (response) {
			if (attr == "GE_3D_MODEL_VIEW")
			{
				GE_3D_MODEL_VIEW = value;
				Log.info(__("View saved!"));
			}
		})
		.always(function () {
			$("#edit_scene_save").prop("disabled", false);
			$("#edit_scene_cancel").prop("disabled", false);
		});
}
