<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$ge_3d_view = Identity::getAttribute("GE_3D_MODEL_VIEW");

$ge_3d_mapping_mode = Identity::getAttribute("GE_3D_MAPPING_MODE");
$ge_3d_mapping_hosted_key = Identity::getAttribute("GE_3D_MAPPING_HOSTED_KEY");
$ge_3d_mapping_hosted_datasource = Identity::getAttribute("GE_3D_MAPPING_HOSTED_DATASOURCE");

$models_3d = API_GET::getObjectList(null, null, 'model3d', true);
for($i = 0; $i < count($models_3d["list"]); $i++){
	$model_3d_layers = API_GET::getObjectList($models_3d["list"][$i]['obj'], null, 'modellayer', true, true);
	if(count($model_3d_layers) > 0){
		$models_3d["list"][$i]['layers'] = $model_3d_layers['list'];
	}
	else{
		$models_3d["list"][$i]['layers'] = array();
	}
}
$models_data = json_encode($models_3d);
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=8"/>
	<title><?php /* i18n: .... */ echo __("Google Earth Matrix GUI Integration"); ?></title>
	<script src="/api/scripts/client.js"></script>
	<script src="/ptz/js/PTZ_tab.js"></script>
	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/log.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="/sdi/lib/js/es5-shim.js"></script>
	<script src="/sdi/lib/js/utils.js"></script>
	<script src="/sdi/lib/js/api.js"></script>
	<script src="/sdi/ge/js/geo_lib.js"></script>
	<script src="/sdi/ge/js/model_lib.js"></script>

	<script>
		var ge_3d_mapping_mode  = '<? echo $ge_3d_mapping_mode; ?>';
		var ge_3d_mapping_hosted_key  = '<? echo $ge_3d_mapping_hosted_key; ?>';
		var ge_3d_mapping_hosted_datasource  = '<? echo $ge_3d_mapping_hosted_datasource; ?>';
	</script>

	<?php if ($ge_3d_mapping_mode == "hosted"): ?>
	<script src="/sdi/ge/js/earth_plugin_loader.js"></script>
	<?php else: ?>
	<script src="http://www.google.com/jsapi"></script>
	<script src="/sdi/ge/js/api_utilities.js"></script>
	<?php endif; ?>

	<script src="/sdi/ge/js/gmap.js"></script>
	<script src="/sdi/ge/js/mil_std_2525c.js"></script>

	<script>
		var ge_default_view = '<? echo $ge_3d_view; ?>';
		var models_3d_json = $.parseJSON('<? echo str_replace( "'", "\'", $models_data); ?>');
		var obj_3d_models_list = models_3d_json.list;
		var obj_3d_models_placemarks = {};

		var jsUserId = "<?php print($_SESSION[SESSION_USERID]); ?>";
		var jsUserName = "<?php print addslashes($_SESSION[SESSION_USERNAME]); ?>";
		var jsSessionId = "<?php print(session_id()); ?>";
	</script>
	<script src="/sdi/ge/js/ge_naco_demo.js"></script>
	<script src="/sdi/ge/js/ge_view.js"></script>

	<link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body id="body">
	<div id="map3d"></div>
</body>
</html>
