<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$ge_view = Identity::getAttribute("GE_3D_MODEL_VIEW");

$ge_3d_mapping_mode = Identity::getAttribute("GE_3D_MAPPING_MODE");
$ge_3d_mapping_hosted_key = Identity::getAttribute("GE_3D_MAPPING_HOSTED_KEY");
$ge_3d_mapping_hosted_datasource = Identity::getAttribute("GE_3D_MAPPING_HOSTED_DATASOURCE");
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __("Google Earth 3D models configuration");?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=8"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
    <script src="/sdi/lib/js/jquery-ajaxfileupload.js"></script>
    <script src="/sdi/lib/js/systemobject.js"></script>
    <script src="/sdi/lib/js/log.js"></script>
    <script src="/sdi/lib/js/api.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="/api/scripts/client.js"></script>

	<script src="/ptz/js/PTZ_tab.js"></script>
	<script>
		var ge_3d_mapping_mode  = '<? echo $ge_3d_mapping_mode; ?>';
		var ge_3d_mapping_hosted_key  = '<? echo $ge_3d_mapping_hosted_key; ?>';
		var ge_3d_mapping_hosted_datasource  = '<? echo $ge_3d_mapping_hosted_datasource; ?>';
	</script>

	<?php if ($ge_3d_mapping_mode == "hosted"): ?>
	<script src="/sdi/ge/js/earth_plugin_loader.js"></script>
	<?php else: ?>
	<script src="http://www.google.com/jsapi"></script>
	<?php endif; ?>

    <script src="js/geo_lib.js"></script>
    <script src="js/model_lib.js"></script>
    <script src="js/ge_config_models.js"></script>

	<script>
        var jsServerName 	= "<? echo $_SERVER['SERVER_NAME']; ?>";
		var jsServerPort 	= "<? echo $_SERVER['SERVER_PORT']; ?>";
		var jsServerProto	= "<? echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http'; ?>";
        var GE_3D_MODEL_VIEW = '<? echo $ge_view; ?>';

        $(document).ready(function() {
            ge_initialize();

			$(".buttons button.back").click(function(){
				window.history.go(-2);
			});
        });
    </script>
</head>
<body id="body" bgcolor="#cccccc" topmargin="20" leftmargin="15" scroll="auto">
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<? echo __("3D Mapping scene and models setup"); ?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div class="buttons">
				<button class="back">Back</button>
			</div>
			<table border="0" class="border_table">
				<tr style="vertical-align:top;">
					<td class="darkgrayhead" style="height:180px; overflow:hidden; vertical-align: top;">
                        <b><?php /* i18n: ...*/ echo __("Initial scene view"); ?>:</b>
                        <input id="edit_scene_view" type="button" value="Edit" title="<?php /* i18n: ...*/ echo __("Edit scene view"); ?>" onclick="show_view_editor()" disabled="disabled"/><br />
                        <span id="view_editor" style="display:none">
                            <label><?php /* i18n: ...*/ echo __("Latitude"); ?>:<br /><input id="scene_lat" type="text" value="" style="width:100%"></label><br />
                            <label><?php /* i18n: ...*/ echo __("Longitude"); ?>:<br /><input id="scene_lon" type="text" value="" style="width:100%"></label><br />
                            <label><?php /* i18n: ...*/ echo __("Altitude"); ?>:<br /><input id="scene_alt" type="text" value="" style="width:100%"></label><br />
                            <label><?php /* i18n: ...*/ echo __("Range"); ?>:<br /><input id="scene_range" type="text" value="" style="width:100%"></label><br />
                            <label><?php /* i18n: ...*/ echo __("Tilt"); ?>:<br /><input id="scene_tilt" type="text" value="" style="width:100%"></label><br />
                            <label><?php /* i18n: ...*/ echo __("Heading"); ?>:<br /><input id="scene_heading" type="text" value="" style="width:100%"></label><br />
                            <input id="edit_scene_save" type="button" value="<?php /* i18n: ...*/ echo __("Save current view"); ?>" onclick="save_view()" style="width:100%">
                            <br />
                            <input id="edit_scene_cancel" type="button" value="<?php /* i18n: ...*/ echo __("Cancel"); ?>" onclick="hide_view_editor()" style="width:100%">
                        </span>
                        <br />
                        <hr />
                        <br />
						<b><?php /* i18n: ...*/ echo __("3D models"); ?>:</b>
                        <input id="new_model" type="button" value="<?php /* i18n: ...*/ echo __("New"); ?>" title="<?php /* i18n: ...*/ echo __("Add new 3D model"); ?>" onclick="new_model()" disabled="disabled" />
                        <input id="edit_model" type="button" value="<?php /* i18n: ...*/ echo __("Edit"); ?>" title="<?php /* i18n: ...*/ echo __("Edit 3D model"); ?>" onclick="edit_model()" disabled="disabled" />
                        <input id="delete_model" type="button" value="<?php /* i18n: ...*/ echo __("Delete"); ?>" title="<?php /* i18n: ...*/ echo __("Delete 3D model"); ?>" onclick="delete_model()" disabled="disabled" />
                        <br />
                        <select id="3d_models" style="width:100%" disabled="disabled" onchange="on_select_3d_model()">
                            <option value="0" selected="selected" disabled="disabled"><?php /* i18n: ...*/ echo __("Select model"); ?></option>
                        </select>
                        <br />
                        <span id="model_editor" style="display:none">
                            <label><?php /* i18n: ...*/ echo __("Name"); ?>:<br /><input id="model_name" type="text" value="" style="width:100%"></label><br />
                            <label><?php /* i18n: ...*/ echo __("Layers"); ?>:
                                <input id="model_layer_add" type="button" value="+" onclick="add_layer()" title="<?php /* i18n: ...*/ echo __("Add one layer"); ?>" />&nbsp;
                                <input id="model_layer_remove" type="button" value="-" onclick="remove_layer()" title="<?php /* i18n: ...*/ echo __("Remove one layer"); ?>" />
                                <br />
                                <input id="model_layers" type="text" value="" style="width:100%">
                            </label><br />
                            <label><?php /* i18n: ...*/ echo __("Layer height(m)"); ?>:<br /><input id="model_layers_height" type="text" value="" style="width:100%"></label>
                            <input id="model_action" type="hidden" value="add">
                            <br />
                            <input id="model_save" type="button" value="<?php /* i18n: ...*/ echo __("Save"); ?>" title="<?php /* i18n: ...*/ echo __("Save 3D model"); ?>" onclick=""  style="width:100%" />
                            <br />
                            <input id="model_cancel" type="button" value="<?php /* i18n: ...*/ echo __("Cancel"); ?>" title="<?php /* i18n: ...*/ echo __("Cancel"); ?>" onclick="cancel_model_operations()" style="width:100%" />
                        </span>

                        <div id="3d_models_layers_block" style="display:none">
                        <?php /* i18n: ...*/ echo __("3D model layers"); ?>:
                        <select id="3d_model_layers" style="width:100%" disabled="disabled" onchange="on_select_3d_model_layer()">
                            <option value="0" selected="selected" disabled="disabled"><?php /* i18n: ...*/ echo __("Select layer"); ?></option>
                        </select>
                        <span id="layer_file_indicator"></span>
                        <span id="layer_file_upload" style="display:none">
                            <!--
                                file element should be with name "block" due to js 'ajaxFileUpload' API restriction
                            -->
                            <div id="upload_info" style="width:100%; text-align:center"></div>
                            <span id="upload_remove_block">
                                <input type="button" value="<?php /* i18n: ...*/ echo __("Remove current file"); ?>" onclick="remove_file()" style="width:100%" />
                            </span>
                            <span id="upload_file_block">
                                <? /* i18n: ...*/ echo __("Select 3D model layer file to upload:"); ?><br />
                                <input id="block" name="block" type="file"  style="width:100%"/><br/>
                                <input id="upload_block_id" type="hidden" value="" />
                                <div style='clear:both; padding-top:10px;'></div>
                                <input id="upload_file_button" type="button" value="<?php /* i18n: ...*/ echo __("Upload file");?>" onclick="upload_file()" style="width:100%; float:right;" class="button" />
                            </span>
                            <label><?php /* i18n: ...*/ echo __("Layer name"); ?>:<input id="layer_name" type="text" value=""></label>
                            <br />
                            <label><?php /* i18n: ...*/ echo __("Layer height(m)"); ?>:<input id="layer_height" type="text" value=""></label>
                            <input id="save_layer_button" type="button" value="<?php /* i18n: ...*/ echo __("Save layer"); ?>" title="<?php /* i18n: ...*/ echo __("Save layer"); ?>" onclick="save_layer_data()" style="width:100%" />
                        </span>
                        </div>
					</td>
                    <td>
						<div id="map3d_container" style="width:600px; height:500px;">
							<div id="map3d" style="height:100%;"></div>
						</div>
					</td>
				</tr>
			</table>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
