<?
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$objId = "-1"; if (isset($_GET["objid"])) $objId = intval($_GET["objid"], 10);

$minMode = false; if (isset($_GET["minMode"])) $minMode = Template::boolVal($_GET["minMode"]);

$object = new Obj();

$ge_3d_mapping_mode = Identity::getAttribute("GE_3D_MAPPING_MODE");
$ge_3d_mapping_hosted_key = Identity::getAttribute("GE_3D_MAPPING_HOSTED_KEY");
$ge_3d_mapping_hosted_datasource = Identity::getAttribute("GE_3D_MAPPING_HOSTED_DATASOURCE");
?>
<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=8"/>
	<title><?php /* i18n: Win title */ echo __("Camera placement tool"); ?></title>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

    <script src="/sdi/lib/js/jquery.js"></script>
    <script src="/sdi/lib/js/jquery.browser.js"></script>
    <script src="/sdi/lib/js/es5-shim.js"></script>
    <script src="/sdi/lib/js/log.js"></script>
    <script src="/sdi/lib/js/api.js"></script>
	<script src="/api/scripts/client.js"></script>
    <script src="/api/scripts/Gettext.js"></script>
    <script src="/api/scripts/i18n.js"></script>
	<script src="/ptz/js/PTZ_tab.js"></script>
	<script src="/sdi/lib/js/utils.js"></script>
	<script src="/sdi/lib/js/mediaplayer.js"></script>
	<script>
		var ge_3d_mapping_mode  = '<? echo $ge_3d_mapping_mode; ?>';
		var ge_3d_mapping_hosted_key  = '<? echo $ge_3d_mapping_hosted_key; ?>';
		var ge_3d_mapping_hosted_datasource  = '<? echo $ge_3d_mapping_hosted_datasource; ?>';
	</script>

	<?php if ($ge_3d_mapping_mode == "hosted"): ?>
	<script src="/sdi/ge/js/earth_plugin_loader.js"></script>
	<?php else: ?>
	<script src="http://www.google.com/jsapi"></script>
	<?php endif; ?>

	<script>
		var minMode = <?=($minMode) ? "true" : "false";?>;
        var objId = <?=$objId;?>;
		var dev_type = "<?=$object->getType($objId);?>";
        var jsServerName 	= "<?=$_SERVER['SERVER_NAME'];?>";
		var jsServerPort 	= "<?=$_SERVER['SERVER_PORT'];?>";
		var jsServerProto	= "<? echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http'; ?>";
	</script>

	<script src="js/ge_admin_gui.js"></script>
	<script src="js/geo_lib.js"></script>
    <script src="js/model_lib.js"></script>
</head>
<body id="body">
    <div class="tabs">
        <div class="tabs_menu">
            <div class="single_tab">
                <div class="tab_text">
                    <?php print __("Camera placement tool");?>
                </div>
            </div>
        </div>
        <div class="tabs_content">
            <div class="buttons">
                <button class="back">Back</button>
                <button class="cancel">Cancel</button>
                <button class="apply">Apply</button>
            </div>
	        <div id="helpMessage"></div>
            <div id="attribute_wrapper">
				<label data-attr="CAM_GEO_LAT">Latitude [deg]</label><div class="attribute" data-attr="CAM_GEO_LAT"></div><br/>
				<label data-attr="CAM_GEO_LONG">Longitude [deg]</label><div class="attribute" data-attr="CAM_GEO_LONG"></div><br/>
				<label data-attr="CAM_GEO_ALT">Altitude [m]</label><div class="attribute" data-attr="CAM_GEO_ALT"></div><br/>
				<label data-attr="CAM_GEO_NORTH_OFFSET">North offset angle</label><div class="attribute" data-attr="CAM_GEO_NORTH_OFFSET"></div><br/>
				<label data-attr="CAM_GEO_AZIMUTH">Heding [deg]</label><div class="attribute" data-attr="CAM_GEO_AZIMUTH"></div><br/>
            </div>
	        <div id="camera"></div>
            <div id="map3d_wrapper">
                <div id="calibration_block_wrapper" align="left" style="background-color:#B0B0B0; width:100%; height:30px">
                    <table id="calibration_block" border="0" width="100%" height="30px">
                        <tr>
                            <td width="30px" height="30px">
                                <a href="#"><img id="device_icon" style="border-color: black; border-width: 0px; border-style: solid;" src="" width="24" height="24" title="<?php /* i18n: .... */ echo __("Click to activate device"); ?>"></a>
                            </td>
                            <td>
                                <?php /* i18n: .... */ echo __("Device"); ?>
                            </td>
                            <td id="calibrator1" width="30px">
                                <a href="#"><img id="target_icon" style="border-color: black; border-width: 0px; border-style: solid;" src="http://maps.google.com/mapfiles/kml/paddle/red-circle.png" width="24" height="24" title="<?php /* i18n: .... */ echo __("Click to activate target"); ?>"></a>
                            </td>
                            <td id="calibrator2"><?php /* i18n: .... */ echo __("Target");?></td>
                            <td id="calibrator3">
                                <img id="calibration_ruler" width="400" height="25" src="images/geCalibrationRuler.gif" title="<?php /* i18n: .... */ echo __("Attn: Please, place the target on the map first."); ?>"/>
                            </td>
                            <td id="calibrator4">
                                <img class="up" src="images/geCalibrationTiltUp.gif" width="11" height="10" title="<?php /* i18n: .... */ echo __("Tilt Up (+5 [deg])"); ?>"/>
                                <img class="down" src="images/geCalibrationTiltDown.gif" width="11" height="10" title="<?php /* i18n: .... */ echo __("Tilt Down (-5 [deg])"); ?>"/>
                            </td>
                        </tr>
                    </table>
                </div>
                <div id='map3d_container' style='height: 363px; width: 100%;'>
                    <div id='map3d' style='height: 100%;'></div>
                </div>
                <div id='map3d_search' style='height: 30px; width: 100%;'>
                    <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                        <tr>
                            <td style="text-align:left; background-color:#B0B0B0;">
                                <input id="map3d_search_device" type="button" value="<?php /* i18n: .... */ echo __("Show device"); ?>" disabled="disabled" />
                            </td>
                            <td style="text-align:right; background-color:#B0B0B0;">
                                <input id="map3d_search_model" type="button" value="<?php /* i18n: .... */ echo __("Show selected 3D model"); ?>" disabled="disabled" />
                            </td>
                            <td style="text-align:right; background-color:#B0B0B0;">
                                <input id="map3d_search_data" type="text" value="">
                            </td>
                            <td style="width:70px; text-align:right; background-color:#B0B0B0;">
                                <input id="map3d_search_address" type="button" value="<?php /* i18n: .... */ echo __("Find address"); ?>">
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="tabs_footer"></div>
    </div>
</body>
</html>
