/*
# $id
#------------------------------------------------------------------------------
# Video player
# manipulating functions
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

/*
* functions for manipulating Player
*/
function Player(obj, name)
{
	this.obj = obj;
	this.id = "";
	this.name = name ? "_mplayer_" + name : "_mplayer_VideoPlayer";
	this.mplayer = null;
	this.width = "";
	this.height = "";
	this.PTZ = new PTZ(this.obj);

	this.play = function()
	{
		if (this.mplayer)
		{
			this.mplayer.play();
		}
	};
	this.pause = function()
	{
		if (this.mplayer)
		{
			this.mplayer.pause();
		}
	};
	this.show = function(id, width, height)
	{
		var result = true;
		if (id && this.obj)
		{
			this.id = id;
			this.width = width;
			this.height = height;

			$(this.id).html('<iframe id="iframeLivePlayer" src="/sdi/externalplayer/player.php?name=' + this.name + '&camera=' + this.obj + '&width=' + this.width + '&height=' + this.height + '" width="' + this.width + '" height="' + this.height + '" scrolling="no" frameborder="0" border="0" style="background-color:gray;"/>');

			this.getMPlayerObject();
		} else {
			result = false;
		}
		return result;
	};
	this.getMPlayerObject = function()
	{
		var iframe = $("#iframeLivePlayer")[0];
		if(iframe.contentWindow && iframe.contentWindow["_mplayer_" + this.name])
		{
			this.mplayer = iframe.contentWindow["_mplayer_" + this.name];
			var width = this.width;
			var height = this.height;
			var player = this;
			this.mplayer._onImageClick = function(x, y)
			{
				player.PTZ.moveToXY(x, y, width, height);
			};
		} else {
			var player = this;
			setTimeout(
				function()
				{
					player.getMPlayerObject();
				},
				500
			);
		}
	}
}

/*
* functions for manipulating PTZ
*/
function PTZ(obj)
{
	this.obj = obj;
	this.mode = "";
	this.direction = "";
	this.width = "";
	this.height = "";
	this.x = "";
	this.y = "";

	this.moveLeft = function()
	{
		this.mode = "step";
		this.direction = "left";

		this.move();
	};
	this.moveRight = function()
	{
		this.mode = "step";
		this.direction = "right";

		this.move();
	};
	this.moveUp = function()
	{
		this.mode = "step";
		this.direction = "up";

		this.move();
	};
	this.moveDown = function()
	{
		this.mode = "step";
		this.direction = "down";

		this.move();
	};
	this.moveToXY = function(x, y, width, height)
	{
		this.mode = "rel";
		this.width = width;
		this.height = height;
		this.x = x;
		this.y = y;

		this.move();
	};
	this.move = function()
	{
		if (!this.obj)
		{
			return false;
		}
		var PTZ_Command = "";
		if (this.mode === "step")
		{
			PTZ_Command = "<PTZ_Command>do.ptz?dev=" + this.obj + "&mode=" + this.mode + "&move=" + this.direction + "</PTZ_Command>";
		} else
		if (this.mode === "rel")
		{
			PTZ_Command = "<PTZ_Command>do.ptz?dev=" + this.obj + "&mode=" + this.mode + "&size=" + this.width + 'x' + this.height + "&xy=" + this.x + ',' + this.y + "</PTZ_Command>";
		}
		$.ajax({
			url: window.location.protocol + "//" + window.location.hostname + "/ptz/cgi-bin/send_message.pl",
			async: true,
			data: { data : PTZ_Command },
			success: function(data)
			{
				//
			}
		});
	}
}
