<?php
/*
# $Id: index.php 33536 2016-01-26 17:34:37Z astarostin $
#------------------------------------------------------------------------------
# Video player
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

	$isLoggedIn = false;
	if (SessionManager::isUserLoggedIn())
	{
		$isLoggedIn = true;
	}

	$obj = null;
	if (isset($_GET['obj']))
		$obj = intval($_GET['obj'], 10);
	$width = 320;
	if (isset($_GET['width']))
		$width = intval($_GET['width'], 10);
	$height = 240;
	if (isset($_GET['height']))
		$height = intval($_GET['height'], 10);
	$showPTZ = false;
	if (isset($_GET['ptz']))
		$showPTZ = $_GET['ptz'] == 'true' ? true : false;
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php /* i18n: Win title */ echo __('Video player');?></title>
	<meta charset="utf-8"/>
	<link rel="stylesheet" href="style.css" type="text/css"/>
	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/cryptojs.sha512.js"></script>
	<script src="/sdi/externalplayer/js/externalplayer.js"></script>
	<script>
		var player = null;
		var isLoggedIn = <?php $isLoggedIn ? print "true" : print "false"; ?>;
		var obj = <?php isset($obj) ? print $obj : print -1; ?>;
		var playerWidth = <?php print $width; ?>;
		var playerHeight = <?php print $height; ?>;
		var showPTZ = <?php $showPTZ ? print "true" : print "false"; ?>;
		var EncryptionKey = '';
		var TTL = 0;
		var timerTTL = null;

		$(document).ready(function(){
			addEvents();

			$("#username").focus();

			if (isLoggedIn)
			{
				showPlayer();
			} else {
				getLoginData();
				$("#login").show();
			}
		});

		function showPlayer()
		{
			$("#cameraPlayer").show();
			playerHeight -= $("#playerControls").height();
			if (showPTZ)
			{
				$("#playerPTZControls").show();
				playerHeight -= $("#playerPTZControls").height();
			}

			player = new Player(obj);
			player.show("#player", playerWidth, playerHeight);
		}

		function setLoginTimeout()
		{
			if (TTL > 0)
			{
				if (timerTTL != null)
				{
					clearTimeout(timerTTL);
				}
				timerTTL = setTimeout(
					function()
					{
						if (!isLoggedIn)
						{
							getLoginData();
						}
					},
					TTL * 60 * 1000
				);
			}
		}

		function getLoginData()
		{
			$.ajax({
				url: "/api/call.php",
				data: {'function': 'getLoginInfo'},
				dataType: "json",
				async: false,
				cache: false,
				success: function(json)
				{
					if (json.error == "")
					{
						EncryptionKey = json["loginInfo"]["encryptionKey"];
						TTL = parseInt(json["loginInfo"]["loginTTL"], 10);
					}
				}
			});
		}

		function displayMessage(message)
		{
			$("#loginMessage").text(message);
		}

		function addEvents()
		{
			$("#doLogin").click(function(){
				var txt_username = $.trim($("#name").val());
				var txt_password = $.trim($("#password").val());

				if (txt_username.length == 0 || txt_password.length == 0)
				{
					if (txt_username.length == 0) {
					   displayMessage('Missing username');
					   $("#username").focus();
					} else {
					   displayMessage('Missing password');
					   $("#password").focus();
					}
				} else {
					var TmpHash = CryptoJS.SHA512(txt_password).toString(CryptoJS.enc.Hex);
					var PasswordHash = CryptoJS.SHA512(EncryptionKey + TmpHash + EncryptionKey).toString(CryptoJS.enc.Hex);

					$.ajax({
						type: "POST",
						url: "/api/call.php",
						data: {
							'function': 'login',
							name: txt_username,
							credentials: PasswordHash
						},
						dataType: "json",
						async: true,
						cache: false,
						success: function(json)
						{
							if (json.error != "")
							{
								displayMessage(__('Error') + ': ' + json.error);
								$("#password").val('');
								$("#password").focus();
							} else {
								isLoggedIn = true;
								$("#login").hide();

								showPlayer();
							}
						}
					});
				}
			});
			$("#play").click(function(){
				player.play();
			});
			$("#pause").click(function(){
				player.pause();
			});
			$("#ptz_top").click(function(){
				player.PTZ.moveUp();
			});
			$("#ptz_right").click(function(){
				player.PTZ.moveRight();
			});
			$("#ptz_bottom").click(function(){
				player.PTZ.moveDown();
			});
			$("#ptz_left").click(function(){
				player.PTZ.moveLeft();
			});
		}
	</script>
</head>
<body>
	<div id="wrapper">
		<div id="login">
			<form action="#" onSubmit="return false">
				<fieldset>
					<legend><?php /* i18n: ... */ echo __('Login');?></legend>
					<p><label for="name"><?php /* i18n: User name */ echo __('Name');?></label><input type="text" id="name"/></p>
					<p><label for="password"><?php /* i18n: ... */ echo __('Password');?></label><input type="text" id="password"/></p>
					<p class="submit"><input type="submit" value="Login" id="doLogin"/></p>
					<div id="loginMessage"></div>
				</fieldset>
			</form>
		</div>
		<div id="cameraPlayer">
			<div id="player">
			</div>
			<div id="playerControls">
				<input type="button" value="Play" id="play"/>
				<input type="button" value="Pause" id="pause"/>
			</div>
			<div id="playerPTZControls">
				<input type="button" value="&#x2190;" id="ptz_left"/>
				<input type="button" value="&#x2191;" id="ptz_top"/>
				<input type="button" value="&#x2193;" id="ptz_bottom"/>
				<input type="button" value="&#x2192;" id="ptz_right"/>
			</div>
		</div>
	</div>
</body>
</html>
