<?php
/*
# $Id: ModifyObjects.php 12661 2008-11-04 17:29:47Z starostin $
#------------------------------------------------------------------------------
# Object editor
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
# just test commint
#-----------------------------------------------------------------------------
*/


require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
require_once($_SERVER['APL'] . '/api/lib/php/db.php');
SessionManager::isUserLoggedIn() or SessionManager::redirect();

function TimeConvert($str){
	$strfrom = array('T',':','Z');
	$strto = array('_','-','');
	return str_replace($strfrom,$strto, $str);
}
function TimeConvert1($str){
	$strfrom = array('T','Z');
	$strto = array(' ','');
	return str_replace($strfrom,$strto, $str);
}

$camera_list = array();
function getCameraList($userid, $roleid){
//	echo '<br>~!~' . $userId . '~!~<br>';
	global $camera_list;
	$queryString = "select obj, otype, subtype from getObjects($userid, $roleid, null, null) where credentials like '%v%' "  ;
//	if ($isWitness)	$queryString += "AND d.otype = 'D' AND d.subtype = 'C'";
	$sql_camera_list = executeQuery($queryString);
	foreach ($sql_camera_list as $obj){
		$camera_list[] = $obj['obj'];
	}
}

function getObjInfo($objid){
	global $camera_list;
	$queryString = sprintf("SELECT
						o.obj, o.otype, o.subtype,
						o.name as objname
					FROM _objs as o
					WHERE
						o.deleted = '0'
						AND o.obj = %s",
						sanitize($objid));

	$list = executeQuery($queryString);
	$otype = $list[0]['otype'];
	$subtype = $list[0]['subtype'];
	if (in_array($list[0]['obj'], $camera_list)){
		$haspermission = true;
		if (isset($list[0]['objname'])){
			$name = $list[0]['objname'];
		}else{
			$name = $objid;
		}
	}else{
		$haspermission = false;
		if (isset($list[0]['objname'])){
			$name = '* ' . $list[0]['objname'];
		}else{
			$name = '* ' . $objid;
		}
	}
	return array( "name" => $name, "haspermission" => $haspermission, "otype" => $otype, "subtype" => $subtype);
}

function toUnixTime($date_time_string){
	$dt_elements = explode('_',$date_time_string);
	$date_elements = explode('-',$dt_elements[0]);
	$time_elements =  explode('-',$dt_elements[1]);
	return mktime($time_elements[0], $time_elements[1],$time_elements[2], $date_elements[1],$date_elements[2], $date_elements[0]);
}

function getduration($str_date_from, $str_date_to){
	$date_from = toUnixTime($str_date_from);
	$date_to = toUnixTime($str_date_to);
	if ($date_from < $date_to)
		$datediff = $date_to - $date_from;
	else
		$datediff = $date_from - $date_to;
	$hh = floor(intval($datediff) / 3600);
	$mm = floor(intval($datediff - 3600 * $hh) / 60);
	$ss = intval($datediff - 3600 * $hh - 60 * $mm);
	return 	sprintf("%02d:%02d:%02d", $hh, $mm, $ss);
}



function getevents($snapshotid, $roleid){
	$result = "";
	$client = "";
	$userId = $_SESSION[SESSION_USERID];
	try
	{
		$client = new SoapClient("http://" . $_SERVER['SERVER_ADDR'] ."/axis2/services/EventLogService?wsdl", array("trace"=>1));
		$client->__setCookie("PHPSESSID", session_id());

		$params = array(
							'FILTER' => array(
								'snapshotid' => array(
									'condition' => 'EQ',
									'value' => $snapshotid
								)
							),
							'OUTPUTOPTIONS' => array(
								'OPTION' => array('name' => 'objinfo','value' => 'true'),
								'OPTION' => array('name' => 'timeformat','value' => 'UTC'),
								'OPTION' => array('name' => 'properties','value' => 'true'),
								'OPTION' => array('name' => 'witnesses','value' => 'true'),
							),
							//'PAGEBREAK' => array('SORT' => 'eventid')
					);
		$result = $client->get_events($params);
	}
	catch (SoapFault $exception)
	{
		$result = '';
		return $result;
	}
	if (!is_array($result->EVENTS->EVENT))
		$result->EVENTS->EVENT = array($result->EVENTS->EVENT);

	$evnum = 0;
	getCameraList($userId, $roleid);
	foreach ($result->EVENTS->EVENT as $event){
		//Convert time
		if (isset($event->UTC->WHEN)) $event->UTC->VIEW = TimeConvert1($event->UTC->WHEN);
		if (isset($event->UTC->FROM)) $event->FROM = TimeConvert1($event->UTC->FROM);
		if (isset($event->UTC->TO)) $event->TO = TimeConvert1($event->UTC->TO);

		if (isset($event->UTC->WHEN)) $event->UTC->WHEN = TimeConvert($event->UTC->WHEN);
		if (isset($event->UTC->FROM)) $event->UTC->FROM = TimeConvert($event->UTC->FROM);
		if (isset($event->UTC->TO)) $event->UTC->TO = TimeConvert($event->UTC->TO);
		if (isset($event->UTC->UPDATED)) $event->UTC->UPDATED = TimeConvert($event->UTC->UPDATED);

		//WITNESSES as Array
		if (!is_array($event->WITNESSES->OBJ))
			$event->WITNESSES->OBJ = array($event->WITNESSES->OBJ);

		$objinfo = getObjInfo($event->OBJID);
		$event->NAME = $objinfo['name'];
		$event->HASPERMISSION = $objinfo['haspermission'];
		$event->OTYPE = $objinfo['otype'];
		$event->SUBTYPE = $objinfo['subtype'];

		if ($event->HASPERMISSION) {$event->VIEWSOURCE = $event->OBJID; $event->VIEWSOURCENAME = $event->NAME;}
		$event->DURATION = getduration($event->UTC->FROM, $event->UTC->TO);
		if (! isset($event->NOTE)) $event->NOTE = ' ';

		$i = 0;
		foreach ($event->WITNESSES->OBJ as $obj){
			if ($obj->OBJID == $event->OBJID){
				unset($event->WITNESSES->OBJ[$i]);
			}else{
				if ($obj->OTYPE !='D' || $obj->SUBTYPE != 'C'){
					unset($event->WITNESSES->OBJ[$i]);
				}else{
					$objinfoW = getObjInfo($obj->OBJID);
					if (!$objinfoW['haspermission']){
						unset($event->WITNESSES->OBJ[$i]);
					}else{
						$obj->CAMERANAME = $objinfoW['name'];
						$obj->HASPERMISSION = $objinfoW['haspermission'];
						$obj->VIEWSOURCE = $obj->OBJID;
						$obj->VIEWSOURCENAME = $obj->CAMERANAME;
						if ((!$event->HASPERMISSION || ($objinfo['otype'] !== 'D' && $objinfo['subtype'] !== 'C')) && $obj->HASPERMISSION) {$event->VIEWSOURCE = $obj->OBJID; $event->VIEWSOURCENAME = $obj->CAMERANAME;}
						//if ($objinfo['otype'] !== 'D' && $objinfo['subtype'] !== 'C' && $obj->HASPERMISSION) {$event->VIEWSOURCE = $obj->OBJID; $event->VIEWSOURCENAME = $obj->CAMERANAME;}
					}
				}
			}
			$i++;
		}
		if (!$event->HASPERMISSION && $event->WITNESSES->OBJ === array()){
			unset($result->EVENTS->EVENT[$evnum]);
		}
		$evnum++;
	}
	return $result;
}

?>
