/*
# $Id: eventpolicy_script.js 33561 2016-02-01 07:03:22Z sabaev $
#------------------------------------------------------------------------------
# Event policy
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

	$(document).ready(function () {
		init();
		addEvents();
	}).on("change", 'input[name="preevent"]', function(){
		if($(this).val() > max_cache_data[0]['MAX_CACHE_SIZE']){
			clearWarnings();
			showWarning();
		}
	});

	var api = new API();
	var apiSync = new API(false);
	var is_editing = false;
	var is_adding = false;

// it is need to translation
	var trtxt = __("Default policy");
	var trtxt = __("Default policy for mobile devices");
	var trtxt = __("Priority");
	var trtxt = __("Preevent (sec)");
	var trtxt = __("Postevent (sec)");

	//workflow
	var trtxt = __("ACSG + merge");
	var trtxt = __("ACSG / no merge");
	var trtxt = __("Simple Alert + merge");
	var trtxt = __("Simple Alert / no merge");
	var trtxt = __("Simple Info / no merge");

	//Priority
	var trtxt = __("Low");
	var trtxt = __("Normal");
	var trtxt = __("High");
	var trtxt = __("Critical");

	var trtxt = __("Informational");
	var trtxt = __("Alert");
// eof it is need to translation

	var max_cache_data = null;
	var warn = false;

	function init()
	{
		$.when(
				api.getSMWriterConf(),
				api.getVersionControlInformation({"section": "info"})
			)
			.fail(function(code, message){
				//Log.error("[" + code + "] " + message);
			})
			.done(function(getSMConfResponse, getVersionResponse){					
				max_cache_data = [
					getSMConfResponse[0].list,
					getVersionResponse[0].section.info					
				];

				$("#addeventpolicy").show();
				$("#editeventpolicy").hide();
				$("#deleteeventpolicy").hide();
				$("#eventpolicy_parameters").hide();
				fillEventPolicyList();
			});
	}

	function fillEventPolicyList()
	{
		api.getEventPolicyList()
			.done(function(response){
				var list = response.list;
				var options = "";
				for (var i = 0; i < list.length; i++)
				{
					options += '<option value="' + list[i]["eventpolicy"] + '">' + __(list[i]["name"]) + '</option>';
				}
				$("#eventpolicylist").empty();
				$('<select size="6" class="tablestyle" style="width:100%">' + options + '</select>').appendTo("#eventpolicylist");
				$("#eventpolicylist select").change(onEventPolicyListChange);
			});
	}

	function getEventSourceWorkflowList(eventpolicy_id, eventsource_id)
	{
		var workflow_list = "";
		var infworkflow_list = "";

		apiSync.getEventSourceWorkflowList({
			'eventpolicy_id': eventpolicy_id,
			'eventsource_id': eventsource_id
		})
			.done(function(response){
				var list = response.list;
				workflow_list = '<select class="singlelineshort" name="workflow">';
				infworkflow_list = '<select class="singlelineshort" name="infworkflow">';

				var selectedIndex = -1;
				if (list[list.length - 1] != null)
				{
					if (list[list.length - 1]["workflow"] != undefined)
						workflowSelectedIndex = list[list.length - 1]["workflow"];
					if (list[list.length - 1]["infworkflow"] != undefined)
						infworkflowSelectedIndex = list[list.length - 1]["infworkflow"];
				}

				// last element contains selected workflow
				for (var i = 0; i < list.length - 1; i++)
				{
					if (list[i]["workflow"] == workflowSelectedIndex)
						workflow_list += '<option value="' + list[i]["workflow"] + '" selected="true">' + __(list[i]["name"]) + '</option>';
					else
						workflow_list += '<option value="' + list[i]["workflow"] + '">' + __(list[i]["name"]) + '</option>';

					if (list[i]["workflow"] == infworkflowSelectedIndex)
						infworkflow_list += '<option value="' + list[i]["workflow"] + '" selected="true">' + __(list[i]["name"]) + '</option>';
					else
						infworkflow_list += '<option value="' + list[i]["workflow"] + '">' + __(list[i]["name"]) + '</option>';
				}
				workflow_list += '</select>';
			});

		return { "workflow" : workflow_list, "infworkflow" : infworkflow_list };
	}

	function fillEventPolicyParameters(eventpolicy_id)
	{
		var result = true;
		
		clearWarnings();

		$("#waitindicator")
			.show()
			.mask();

		apiSync.getEventSourceParametersList({
			id: eventpolicy_id
		})
			.fail(function(){
				result = false;
			})
			.done(function(response){
				var list = response;				
				var eventsourceparameters_list = list["eventsourceparameters_list"];
				var eventsourceparameters = list["eventsourceparameters"];
				var eventsourceparameters_table = '<table class="border_table width100">';

				// create head of table
				{
					var len = 0;
					for (var i in eventsourceparameters[0]["parameters"])
						len++;
					eventsourceparameters_table += '<tr>';
					eventsourceparameters_table += '<th class="darkgrayhead1" style="width:140px">' +  __("Event Source") + '</th>';
					eventsourceparameters_table += '<th class="darkgrayhead1">' + __("Alert Workflow") + '</th>' ;
					eventsourceparameters_table += '<th class="darkgrayhead1">' + __("Informational Workflow") + '</th>';
					$.each(	eventsourceparameters[0]["parameters"],
						function(key, value)
						{
							var header = "";
							if (key == "preevent" || key == "postevent")
								header = key + " (sec)";
							else
								header = key;
							if (header == "eventtype") header = __("Default event type");
							header = header.charAt(0).toUpperCase() + header.slice(1);
							eventsourceparameters_table += '<th class="darkgrayhead1">' + __(header) + '</th>';
						}
					);
					eventsourceparameters_table += "</tr>";
				}
				// fill table
				for (var i = 0; i < eventsourceparameters.length; i++)
				{
					eventsourceparameters_table += '<tr id="eventsource_' + eventsourceparameters[i]["eventsource"] + '">';
					eventsourceparameters_table += '<th class="firstelement">' + __(eventsourceparameters[i]["name"]) + '</th>';
					eventsourceparameters_table += '<td>' + getEventSourceWorkflowList(eventpolicy_id, eventsourceparameters[i]["eventsource"])["workflow"] + '</td>';
					eventsourceparameters_table += '<td>' + getEventSourceWorkflowList(eventpolicy_id, eventsourceparameters[i]["eventsource"])["infworkflow"] + '</td>';
					$.each(	eventsourceparameters[i]["parameters"],
						function(key, value)
						{
							var element = eventsourceparameters_list[key];
							if (typeof element != "undefined")
							{

								var isHide = '';
								if (key == 'eventtype' && eventsourceparameters[i]["name"] == 'User'){
									isHide = "display:none;";
								}

								var element_select_list = '<select class="singlelineshort" style="border:0px;'+ isHide +'" name="' + key + '">';
								for (var j = 0; j < element.length; j++)
								{
									if (key == 'lifespan' && element[j]["id"] == 0) continue;
									if (element[j]["id"] == value)
										element_select_list += '<option value="' + element[j]["id"] + '" selected="true">' + __(element[j]["name"]) + '</option>';
									else
										element_select_list += '<option value="' + element[j]["id"] + '">' + __(element[j]["name"]) + '</option>';
								}
								element_select_list += '</select>';
								eventsourceparameters_table += '<td>' + element_select_list + '</td>';
							} else {
								// show cache warning
								if(!warn && key == "preevent" && value > parseInt(max_cache_data[0]['MAX_CACHE_SIZE'])){
									showWarning();
								}
								eventsourceparameters_table += '<td><input type="text" style="width:50px;" class="editfieldshort" name="' + key + '" value="' + value + '"/></td>';
							}
						}
					);
					eventsourceparameters_table += "</tr>";
				}
				eventsourceparameters_table += "</table>";


				var eventlifespan_list = list['eventlifespan'];
				var eventlifespan_table = '<table class="border_table width100"><col width="10%">';
				for (var i = 0; i < eventlifespan_list.length; i++)
				{
					if (eventlifespan_list[i]["preserverhours"] == -1)
						preserverhours_val = __("content-dependent");
					else
					if (eventlifespan_list[i]["preserverhours"] == -2)
						preserverhours_val = __("space-limited");
					else
						preserverhours_val = eventlifespan_list[i]["preserverhours"];
					eventlifespan_table	+= '<tr><th class="darkgrayhead">' + __(eventlifespan_list[i]['name']) + '</th><td><input id="' + eventlifespan_list[i]['id'] + '" type="text" maxlength="5" value="' + preserverhours_val + '" class="editfield width100" style="border:0;"/></td></tr>'
				}
				eventlifespan_table += '</table>';
				eventlifespan_table += '<div id="howinputmapping">' + __("Enter number of hours Event will be preserved dependent on Priority. <br>Enter \"-1\" for \"content-dependent\" (Event will be recycled once media expires with Storage Policy). <br>Enter \"-2\" for \"space-limited\" (Event will be stored as long as possible until Storage Space needs to be reclaimed).") + '</div>';

				$("#eventsourceparameters").html("");
				$(eventsourceparameters_table).appendTo("#eventsourceparameters");

				$("#eventpolicy_eventlifespan").empty();
				$(eventlifespan_table).appendTo("#eventpolicy_eventlifespan");

				$("#eventpolicy_eventlifespan input").focus(function(){
					if (!$(this).prop("readOnly")){
						if ($(this).val() === __("content-dependent")) $(this).val("-1");
						else
						if ($(this).val() === __("space-limited")) $(this).val("-2");

						if (this.createTextRange){
							var r = this.createTextRange();
							r.collapse(false);
							r.select();
						}
					}
				});
				$("#eventpolicy_eventlifespan input").blur(function(){
					var regexp = new RegExp("^\\d+$");
					var lifespan_value = this.value;
					if ((!regexp.test(lifespan_value) && (parseInt(lifespan_value) != -1 && parseInt(lifespan_value) != -2)) && lifespan_value !== __("content-dependent") && lifespan_value !== __("space-limited"))
					{
						alert(__("Event lifespan must be an integer more zero, equal zero or equal -1 (content-dependent), -2 (space-limited)."));
						$(this).focus();
					}else{
						if (parseInt($(this).val()) === -1) $(this).val(__("content-dependent"));
						else
						if (parseInt($(this).val()) === -2) $(this).val(__("space-limited"));
					}
				});
			})
			.always(function(){
				$("#waitindicator")
					.hide()
					.unmask();
			});

		return result;
	}

	function onEventPolicyListChange()
	{
		is_editing = false;
		is_adding = false;

// CIRRUS_REPLACE_EVENTPOLICY_ID002_BEGIN
		$("#addeventpolicy").show();
// CIRRUS_REPLACE_EVENTPOLICY_ID002_END

		$("#editeventpolicy").hide();
		$("#deleteeventpolicy").hide();

		//$("#eventpolicy_parameters").hide("slow");

		$("#eventpolicy_name_edit").val("");
		$("#eventpolicy_description_edit").val("");


		var id = $("#eventpolicylist select").val();
		if (String(id) != 'undefined')
		{
			api.getEventPolicy({
				id: id
			})
				.done(function(response){
					var list = response.list;
					if (list[0]["protected"] == 't')
					{
						$("#editeventpolicy").hide();
						$("#deleteeventpolicy").hide();
					} else {
						$("#editeventpolicy").show();
						$("#deleteeventpolicy").show();
					}
				});
		}

		$("#eventpolicy_parameters").hide();
		fillParameters(true);
	}

	function fillParameters(readOnly)
	{
		var id = $("#eventpolicylist select").val();

		if (readOnly)
		{
			$("#waitindicator")
				.show()
				.mask();
		} else {
			$("#eventpolicy_parameters").mask();
		}

		api.getEventPolicy({
			id: id
		})
			.done(function(response) {
				var list = response.list;
				if (!list[0])
					return;

				$("#eventpolicy_name_edit").val(list[0]["name"]);
				$("#eventpolicy_description_edit").val(list[0]["description"]);

				if (fillEventPolicyParameters(id))
				{
					if (readOnly)
					{
						$("#saveeventpolicy").hide();
						$("#canceleventpolicy").hide();

						$("#eventpolicy_parameters input:text").each(
							function()
							{
								$(this).prop("readOnly", true);
							}
						);
						$("#eventpolicy_parameters select").each(
							function()
							{
								$(this).prop("disabled", true);
							}
						);
						$("#howinputmapping").hide();
					}else{
						$("#howinputmapping").show();
					}

					$("#eventpolicy_parameters").slideDown("fast");
				} else {
					init();
				}
			})
			.always(function(){
				if (readOnly)
				{
					$("#waitindicator")
						.hide()
						.unmask();
				} else {
					$("#eventpolicy_parameters").unmask();
				}
			});
	}

	function addEvents()
	{
		//starting setting some animation when the ajax starts and completes
		$("#addeventpolicy").click(
			function()
			{
				$("#addeventpolicy").hide();
				$("#editeventpolicy").hide();
				$("#deleteeventpolicy").hide();

				// activate inputs and show buttons to edit
				$("#eventpolicy_name_edit").prop("readOnly", false);
				$("#eventpolicy_description_edit").prop("readOnly", false);
				$("#eventpolicy_name_edit").prop("disabled", false);
				$("#eventpolicy_description_edit").prop("disabled", false);
				$("#saveeventpolicy").show();
				$("#canceleventpolicy").show();

				// fill parameters with default values from eventpolicy with id = 1
				if (fillEventPolicyParameters(1))
				{
					is_adding = true;
					is_editing = false;

					$("#eventpolicy_name_edit").val("");
					$("#eventpolicy_description_edit").val("");

					$("#eventpolicy_parameters").slideDown("fast");
				} else {
					init();
				}
			}
		);
		$("#deleteeventpolicy").click(
			function()
			{
				if(confirm(__("Are you shure you want to delete Event policy?")))
				{
					var id = $("#eventpolicylist select").val();
					api.deleteEventPolicy({
						id: id
					})
						.fail(function(code, message){
							alert(__("Event policy was not deleted") + " \n" + message);
						})
						.done(function(){
							init();
						});
				}
			}
		);
		$("#editeventpolicy").click(
			function()
			{
				is_adding = false;
				is_editing = true;
				$("#editeventpolicy").hide();

				// activate inputs and show buttons to edit
				$("#eventpolicy_name_edit").prop("readOnly", false);
				$("#eventpolicy_description_edit").prop("readOnly", false);
				$("#eventpolicy_name_edit").prop("disabled", false);
				$("#eventpolicy_description_edit").prop("disabled", false);
				$("#saveeventpolicy").show();
				$("#canceleventpolicy").show();

				fillParameters(false);
			}
		);
		$("#saveeventpolicy").click(
			function()
			{
				var eventsource_parameters = [];
				// getting parameters from eventpolicy_parameters
				var is_params_correct = true;
				var params_err = '';
				$("#eventpolicy_parameters tr").each(
					function()
					{
						var id = $(this).attr("id");
						if (id)
						{
							var element = {};
							var eventsource_id = id.substring(id.lastIndexOf("_") + 1);
							element["eventsource"] = eventsource_id;
							element["workflow"] = $("#" + id + " select[name='workflow']").val();
							element["infworkflow"] = $("#" + id + " select[name='infworkflow']").val();
							element["parameters"] = {};
							$("#" + id + " input[type='text'], #" + id + " select[name!='workflow'][name!='infworkflow']").each(
								function()
								{
									var name = $.trim(this.name);
									var value = $.trim(this.value);

									if (name != "" && name != "undefined" && value != "")
									{
										element["parameters"][name] = value;
									}
								}
							);

							var regexp = new RegExp("^\\d+$");
							if (typeof (element["parameters"]["preevent"]) == "undefined" || typeof (element["parameters"]["postevent"]) == "undefined"){
								is_params_correct = false;
								params_err = __("Please fill 'preevent' and 'postevent' parameters");
								return;
							}
							if (element["parameters"]["preevent"] == "0" && element["parameters"]["postevent"] == "0"){
								is_params_correct = false;
								params_err = __("Both 'preevent' and 'postevent' parameters can not be set to zero (0)");
								return;
							}
							if (!regexp.test(element["parameters"]["preevent"]) || !regexp.test(element["parameters"]["postevent"]))
							{
								is_params_correct = false;
								params_err = __("Parameters 'preevent' and 'postevent' must be an integer.");
								return;
							}
							eventsource_parameters.push(element);
						}
					}
				);

				if (! is_params_correct)
				{
					alert(params_err);
					return;
				}

				var name = $("#eventpolicy_name_edit").val();
				var description = $("#eventpolicy_description_edit").val();
				if ($.trim(name) == "")
				{
					alert(__("Please fill 'Name' field"));
					return;
				}

				// check event lifespan
				var regexp = new RegExp("^\\d+$");
				var check = true;
				var prev = 0;
				$("#eventpolicy_eventlifespan input").each(
					function()
					{
						if (!check)
							return;
						var id = $(this).attr("id");
						if (id)
						{
							var lifespan_value = this.value;
							if (lifespan_value.toLowerCase() === __("content-dependent")) lifespan_value = -1;
							else
							if (lifespan_value.toLowerCase() === __("space-limited")) lifespan_value = -2;

							if (!regexp.test(lifespan_value) && (parseInt(lifespan_value) != -1 && parseInt(lifespan_value) != -2))
							{
								alert(__("Event lifespan must be an integer more zero, equal zero or equal -1 (content-dependent), -2 (space-limited)."));
								check = false;
								return;
							} else {
								if ((parseInt(lifespan_value) < -2 || parseInt(lifespan_value) < parseInt(prev)) && parseInt(lifespan_value) !== 0  && parseInt(lifespan_value) !== -1 && parseInt(lifespan_value) !== -2)
								{
									alert(__("Next event lifespans must be greater than previous."));
									check = false;
									return;
								}
								if (parseInt(lifespan_value) !== 0 && parseInt(lifespan_value) !== -1 && parseInt(lifespan_value) !== -2)
									prev = this.value;
							}
						}
					}
				);
				if (!check)
					return;

				// create array for send
				var eventpriority = [];
				$("#eventpolicy_eventlifespan input").each(
					function()
					{
						var id = $(this).attr("id");
						if (id)
						{
							var lifespan_value = this.value;
							if (lifespan_value.toLowerCase() === __("content-dependent")) lifespan_value = -1;
							else
							if (lifespan_value.toLowerCase() === __("space-limited")) lifespan_value = -2;

							var element = {};
							element["eventpriority"] = id;
							element["preserverhours"] = lifespan_value;
							eventpriority.push(element);
						}
					}
				);

				if (is_adding)
				{
					api.addEventPolicy({
						'name': name,
						'description': description,
						'eventsource_workflow_parameters': JSON.stringify(eventsource_parameters),
						'eventpolicystorage': JSON.stringify(eventpriority)
					})
						.fail(function(code, message){
							alert(__("Event policy was not added") + "\n" + message);
						})
						.done(function(){
							init();
						});
				}
				if (is_editing)
				{
					var id = $("#eventpolicylist select").val();
					api.editEventPolicy({
						'id': id,
						'name': name,
						'description': description,
						'eventsource_workflow_parameters': JSON.stringify(eventsource_parameters),
						'eventpolicystorage': JSON.stringify(eventpriority)
					})
						.fail(function(code, message){
							alert(__("Event policy was not edited") + "\n" + message);
						})
						.done(function(){
							init();
						});
				}
			}
		);
		$("#canceleventpolicy").click(
			function()
			{
				init();
			}
		);
	}
	
	function showWarning(){
		if(max_cache_data){
			var msg = __('Having pre-event time in policy above ') + max_cache_data[0]['MAX_CACHE_SIZE'] + 
			__(' seconds and having cameras locally captured on ') + (max_cache_data[1].edition != "" ? max_cache_data[1].edition : max_cache_data[1].brand) + 
			__(' will result in pre-event time truncated to ') + max_cache_data[0]['MAX_CACHE_SIZE'] + __(' seconds');
			Log.warning(msg, 60*60*1000);
			warn = true;
		}
	}
	
	function clearWarnings(){
		warn = false;
		$("#messages").html('');
	}
