function EventExporter(params){
	// gui timezone offset
	var currentTimezoneOffset = params.currentTimezoneOffset || (new Date()).getTimezoneOffset()*60*1000;
	// timestamp to string representation format function
	var timestamp2date = params.timestamp2date || null;

	var self = this;

	/*
		init event exporter
	*/
	this.init = function(){
		// set export button event
		$("#e_export").on("click", this.export);

		this.initFields();

		$("#spinner").bind("ajaxSend", function() {
			$(this).show();
		});
	};

	/*
		init filters values
	*/
	this.initFields = function(){
		if(timestamp2date == null){
			alert(__("No datetimepicker parser function! Using default time interval."));
		}

		var options = {
			parentID: $('body'),
			left: 15,
			validateOnBlur: true,
			mask: true,
			lazyInit: false,
			allowBlank: false,
			monthChangeSpinner: false,
			onChangeDateTime: function (curtime, input) {
				if(curtime){
					input.data("time", curtime.getTime());
				}
			},
			onShow: function(current_time, input){}
		};

		if(timestamp2date != null){
			options.value = timestamp2date(e_start, "YYYY/MM/DD HH:II");
		}
		$('#e_start').datetimepicker(options);

		if(timestamp2date != null){
			options.value = timestamp2date(e_end, "YYYY/MM/DD HH:II");
		}
		$('#e_end').datetimepicker(options);

		$('#e_type').val(e_type);
		$('#e_state').val(e_state);
		$('#e_role').val(e_role);
	};

	/*
		do event export
	*/
	this.export = function(){
		var datetimepicker = $('#e_start').data('xdsoft_datetimepicker');
		datetimepicker.data('xdsoft_datetime').setCurrentTime($('#e_start').val());
		datetimepicker.trigger('changedatetime.xdsoft');

		var datetimepicker2 = $('#e_end').data('xdsoft_datetimepicker');
		datetimepicker2.data('xdsoft_datetime').setCurrentTime($('#e_end').val());
		datetimepicker2.trigger('changedatetime.xdsoft');

		var startTime = $('#e_start').data("time");
		var endTime = $('#e_end').data("time");

		var startTS = parseInt(startTime) - (new Date()).getTimezoneOffset()*60*1000 - currentTimezoneOffset;
		var endTS = parseInt(endTime) - (new Date()).getTimezoneOffset()*60*1000 - currentTimezoneOffset;

		var role = $('#e_role').val();
		var format = $('#e_format').val();

		var vars = {
			export_events: "1",
			role: role,
			format: format,
			start_time: startTS,
			end_time: endTS
		};

		var message = $('#e_message').val();
		if(message != ""){
			vars.message = message;
		}

		var type = $('#e_type').val();
		if(type != -1){
			vars.event_type = type;
		}

		var state = $('#e_state').val();
		if(state != 0){
			vars.event_state = state;
		}

		var url = '/api/download.php';
		$.get(
			url,
			vars
		).done(function(data, textStatus, jqXHR) {
			if(format == "csv"){
				$("#e_download").attr("src", url + "?" + $.param(vars));
			}
			else if(format == "html"){
				self.showHtml(data);
			}
			$("#spinner").hide();
		}).fail(function(jqXHR, textStatus, errorThrown) {
			$("#spinner").hide();
			alert("Error: " + errorThrown);
		});
	};

	/*
		show data in html
	*/
	this.showHtml = function(data){
		var htmlExportWindow = window.open("export.html", "EXPORTHTML", "width=800,height=600,toolbar=no,scrollbars=yes,location=no,status=no,resizable=no");
		var style = '';

		// i18n: %1 is a system brand name
		var caption = Gettext.strargs(__("%1 Surveillance Management EVENT LOG"), [s_Brand]);
		// i18n: %1 is a date, %2 is an user name
		var exported = Gettext.strargs(__("exported at %1 by %2"), [new Date(), u_Name]);

		if (readCookie('lang_direction') == 'rtl')
			style = 'style="direction: rtl;"';

		var strDocument =
			'<table border="0" ' + style + '>' +
				'<tr><td><h3>' + caption + '<br />' + exported + '</h3></td></tr>';

		if (s_Name != "") {
			strDocument += '<tr><td><h4>' + Gettext.strargs(__("System name: %1"), [s_Name]) + '</h4></td></tr>';
		}

		strDocument += '<tr><td>' + Gettext.strargs(__("<b>From filter</b>: %1"), [new Date(e_start)]) + '</td></tr>';
		strDocument += '<tr><td>' + Gettext.strargs(__("<b>To filter</b>: %1"), [new Date(e_end)]) + '</td></tr>';

		var typeText = $("#e_type option:selected").text();
		strDocument += '<tr><td>' + Gettext.strargs(__("<b>Type filter</b>: %1"), [typeText]) + '</td></tr>';

		var stateText = $("#e_state option:selected").text();
		strDocument += '<tr><td>' + Gettext.strargs(__("<b>State filter</b>: %1"), [stateText]) + '</td></tr>';

		var msgText = $("#e_message").val();
		if (msgText != '') {
			strDocument += '<tr><td>' + Gettext.strargs(__("<b>User filter</b>: %1"), [msgText]) + '</td></tr>';
		}

		var dataArr = data.csvToArray();

		strDocument +=
			'<tr><td>' +
				'<table cellpadding="0" cellspacing="0" class="table_general">' +
				'<tr>';
		for(var i = 0; i < dataArr[0].length; i++){
			strDocument += '<td class="table_header_cell"><b>' + dataArr[0][i] + '</b></td>';
		}
		strDocument +='</tr>';

		for (var i = 1; i < dataArr.length; i++) {
			strDocument +=
				'<tr>';
			for(var j = 0; j < dataArr[i].length; j++){
				strDocument += '<td class="table_cell">' + dataArr[i][j] + '</td>';
			}
			strDocument +='</tr>';
		}

		strDocument +=
			'</table>' +
				'</td></tr></table>';

		this.setHtmlWindowContent(htmlExportWindow, strDocument);
	};

	/*
		set html export window content
	*/
	this.setHtmlWindowContent = function(win, content){
		if (win.document && win.document.getElementById('main_body')) {
			window.setTimeout(function() {
				win.document.getElementById('main_body').innerHTML = content;
				$("#spinner").hide();
			}, 50);
		}
		else {
			window.setTimeout(function() {
				self.setHtmlWindowContent(win, content);
			}, 250);
		}
	};
}
