<?php
	require_once $_SERVER["APL"] . "/api/lib/php/bootstrap.php";

	SessionManager::isUserLoggedIn() or SessionManager::redirect();

	$nodeInfo = Node::getInfo();

	$sysName = Identity::getAttribute("NAME");
	$sysBrand = $nodeInfo["brand"];

	$user = new User();
	$userName = $user->getName($_SESSION[SESSION_USERID]);
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>
	<title><?php echo __("Event Log Export"); ?></title>
	<link rel="stylesheet" type="text/css" href="css/style.css" />

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="js/export.js"></script>

	<link rel="stylesheet" type="text/css" href="/sdi/lib/js/3rdparty/datetimepicker/jquery.datetimepicker.css" />
	<script src="/sdi/lib/js/3rdparty/datetimepicker/jquery.datetimepicker.js"></script>

	<script src="/sdi/lib/js/3rdparty/csvToArray.v2.1.js"></script>

	<script type="text/javascript">
		var u_Name = '<?php echo $userName; ?>';
		var s_Name = '<?php echo $sysName; ?>';
		var s_Brand = '<?php echo $sysBrand; ?>';

		var e_role = '<?php echo (isset($_GET['role']) ? $_GET['role'] : ''); ?>';
		var e_start = <?php echo (isset($_GET['start_time']) ? $_GET['start_time'] : 'new Date().getTime() - 12*60*60*1000'); ?>;
		var e_end = <?php echo (isset($_GET['end_time']) ? $_GET['end_time'] : 'new Date().getTime()'); ?>;
		var e_type = <?php echo (isset($_GET['event_type']) ? $_GET['event_type'] : '-1'); ?>;
		var e_state = '<?php echo (isset($_GET['event_state']) ? $_GET['event_state'] : '0'); ?>';
		var config = {};
		if(window.opener.mx){
			config = {
				timestamp2date: window.opener.mx.TIME.timestamp2date,
				currentTimezoneOffset: window.opener.mx.TIME.currentTimezoneOffset
			};
		}
		$(document).ready(function(){
			var ee = new EventExporter(config);
			ee.init();
		});
	</script>
</head>
<body>
	<div id="e_filter">
		<label><?php echo __("From"); ?>:</label><input type="text" id="e_start" value=""><br />
		<label><?php echo __("To"); ?>:</label><input type="text" id="e_end" value=""><br />
		<label><?php echo __("Search"); ?>:</label><input type="text" id="e_message" value="<?php echo (isset($_GET['msg']) ? $_GET['msg'] : ''); ?>"><br />
		<label><?php echo __("Type"); ?>:</label>
		<select id="e_type">
			<option value="-1" selected><?php echo __("All"); ?></option>
			<option value="0"><?php echo __("Informational"); ?></option>
			<option value="1"><?php echo __("Alert"); ?></option>
		</select><br />
		<label><?php echo __("State"); ?>:</label>
		<select id="e_state">
			<option value="0" selected><?php echo __("All"); ?></option>
			<option value="!8"><?php echo __("Not Cleared"); ?></option>
			<option value="!4"><?php echo __("Not Acknowledged"); ?></option>
			<option value="8"><?php echo __("Cleared"); ?></option>
		</select><br />
		<label><?php echo __("Format"); ?>:</label>
		<select id="e_format">
			<option value="csv" selected>CSV</option>
			<option value="html">HTML</option>
		</select><br />
		<input type="hidden" id="e_role" value="">
		<button id="e_export"><?php echo __("Export"); ?></button><br />
	</div>
	<div id="e_iframe">
		<iframe id="e_download" src="" width="1" height="1" align="left" frameBorder="0"></iframe>
	</div>
	<div id="spinner" class="spinner" style="display:none;">
		<img id="img-spinner" src="img/ajax-loader.gif" alt="Loading"/>
	</div>
</body>
</html>
