<?php
/**
 * @version $Id: uploadxml.php 11542 2008-07-23 15:51:18Z starostin $
 * ------------------------------------------------------------------------------
 * Backup manager
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
include('functions.php');

// Check if user is Admin (assigned to Admin Role)
$user = new User();
if (!$user->isAdmin($_SESSION[SESSION_USERID]))
{
	header('HTTP/1.0 403 Forbidden');
	echo __("Access denied\n");
	exit;
}

$error = "";
$uploadfile = "";
$fileElementName = 'backup_file';
if (!empty($_FILES[$fileElementName]['error']))
{
	switch($_FILES[$fileElementName]['error'])
	{
		case '1':
			$error = __('The uploaded file exceeds the upload_max_filesize directive in php.ini');
			break;
		case '2':
			$error = __('The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form');
			break;
		case '3':
			$error = __('The uploaded file was only partially uploaded');
			break;
		case '4':
			$error = __('No file was uploaded.');
			break;
		case '6':
			$error = __('Missing a temporary folder');
			break;
		case '7':
			$error = __('Failed to write file to disk');
			break;
		case '8':
			$error = __('File upload stopped by extension');
			break;
		case '999':
		default:
			$error = __('No error code avaiable');
	}
}elseif(empty($_FILES[$fileElementName]['tmp_name']) || $_FILES[$fileElementName]['tmp_name'] == 'none')
{
	$error = __('No file was uploaded..');
}else
{
	$uploaddir = dirname($_FILES[$fileElementName]['tmp_name']);
	$uploadfile = $uploaddir . "/" . "backup_" . basename($_FILES[$fileElementName]['tmp_name']);
	if (move_uploaded_file($_FILES[$fileElementName]['tmp_name'], $uploadfile) === FALSE)
	{
		$error = __("Cannot move uploaded file.");
	}
	//for security reason, we force to remove all uploaded file
	@unlink($_FILES[$fileElementName]);
}
$result = array();
$result["error"] = $error;
$result["filename_location"] = $uploadfile;
$result["filename"] = $_FILES[$fileElementName]["name"];

echo json_encode($result);
?>
