/**
 * @version $Id: backup_script.js 32848 2015-08-05 23:17:32Z astarostin $
 * ------------------------------------------------------------------------------
 * Backup editor
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
	var type_list = [];
	var doTabClick = true;
	var global_select_list = [];
	$(document).ready(
		function()
		{
			init();
			simple_tooltip("img","tooltip");
			addEvents();
		}
	);

	function disabledOptionsFixForIE()
	{
		// Disabled options fix for Internet Explorer
		if ($.browser.msie)
		{
			$('select').each(function(){
				this.rejectDisabled = function(){
					if (this.selectedIndex >= 0)
					{
						if (this.options[this.selectedIndex].disabled){
							if (this.lastSelectedIndex) {
								this.selectedIndex = this.lastSelectedIndex;
							} else {
								var first_enabled = $(this).children('option:not(:disabled)').get(0);
								this.selectedIndex = first_enabled ? first_enabled.index : 0;
							}
						} else {
							this.lastSelectedIndex = this.selectedIndex;
						}
					}
				};
				this.rejectDisabled();
				this.lastSelectedIndex = this.selectedIndex;
				$(this).children('option[disabled]').each(function(){
					$(this).css('color', '#CCC');
				});
				$(this).change(function() {
					this.rejectDisabled();
				});
			});
		}
	}

	function init()
	{
		$("#logout").hide();
		$("#restorebackup").hide();
		$("#deletebackup").hide();
		$("#downloadbackup").hide();

		$("#backup_file_block").hide();
		$("#backup_comment_block").hide();

		$("#backuplist_container").slideDown("fast");

		$("#backup_parameters").slideUp("fast");
		$("#backuprestore_log_container").slideUp("fast");
		$("#backupcreate_log_container").slideUp("fast");

		$("#backup_file").val("");

		$("#tabs_menu .tab_inactive, #tabs_menu .current_tab").click(function(){
			if (doTabClick){
				$("#tabs_menu .current_tab").removeAttr("id")
						.removeClass("current_tab")
						.addClass("tab_inactive");

				$(this).attr("id", "current_tab")
						.removeClass("tab_inactive")
						.addClass("current_tab");

				//create options in necessary type
				if ($("#tabs_menu .current_tab").attr("name") == "tab_user"){
					assemble_backups_list("user");
				}
				if ($("#tabs_menu .current_tab").attr("name") == "tab_auto"){
					assemble_backups_list("auto");
				}
				if ($("#tabs_menu .current_tab").attr("name") == "tab_prerestored"){
					assemble_backups_list("pre-restored");
				}
			}
		});
		fillBackupList();
	}


	function assemble_backups_list(backuptype){
		var backupselect = '<select size="10" class="tablestyle" multiple="multiple">';
		if (type_list[backuptype]){
			backupselect += type_list[backuptype];
		}
		backupselect += '<option value="" disabled="disabled" style="text-align:center"></option>';
		backupselect += '</select>';

		$("#backuplist").empty();
		$(backupselect).appendTo("#backuplist");
		$("#backuplist select").change(onBackupListChange);
		$("#backuplist select").keyup(onBackupListChange);

		$("#backuprestore_log_container").slideUp("fast");
		$("#backupcreate_log_container").slideUp("fast");
		$("#backup_file_block").slideUp("fast");
		$("#backup_comment_block").slideUp("fast");
		$("#backup_parameters").slideUp("fast");

		$("#restorebackup").hide();
		$("#deletebackup").hide();
		$("#downloadbackup").hide();

		if (backuptype != "user"){
			$("#createbackup").hide();
		}else{
			$("#createbackup").show();
		}
	}

	function initafterrestore()
	{
		//top.location.href="/usr/logout.php";
	}

	function simple_tooltip(target_items, name){
		$(target_items).each(function(i){
			$("body").append("<div class='"+name+"' id='"+name+i+"'><p>"+$(this).attr('title')+"</p></div>");
			var my_tooltip = $("#"+name+i);

			$(this).removeAttr("title").mouseover(function(){
				my_tooltip.css({display:"none"}).fadeIn(100);
			}).mousemove(function(kmouse){
				my_tooltip.css({left:kmouse.pageX+15, top:kmouse.pageY+15});
			}).mouseout(function(){
				my_tooltip.fadeOut(100);
			});
		});
	}

	function fillBackupList()
	{
		$.ajax({
			url: "call.php",
			dataType: "json",
			cache: false,
			data: {
				'function' : 'getBackupList'
			},
			success: function(list)
			{
				if (list == "" && list.length == 0)
				{
					// list is empty
				} else {
					// sort list of elements by type
					type_list = [];
					for (var i = 0; i < list.length; i++)
					{
						if (!(type_list[list[i]["backup_type"]] instanceof Array))
						{
							type_list[list[i]["backup_type"]] = [];
						}
						var element = type_list[list[i]["backup_type"]];
						var selectoption = '<option value="' + list[i]["backup"] + '" data-backuptype="' + list[i]["backup_type"] + '">' + list[i]["name"] + '&nbsp;&nbsp;&nbsp;' + list[i]["comment"] + '</option>';
						element.push(selectoption);
					}

					// create list of elements and out to the screen
					var curr_tab = $("#tabs_menu .current_tab").attr("name");
					if (curr_tab == "tab_user") assemble_backups_list("user");
					if (curr_tab == "tab_auto") assemble_backups_list("auto");
					if (curr_tab == "tab_prerestored") assemble_backups_list("pre-restored");
					disabledOptionsFixForIE();
				}
			}
		});
	}

	function onBackupListChange()
	{
		is_editing = false;
		is_adding = false;

		$("#backuprestore_log_container").slideUp("fast");
		$("#backupcreate_log_container").slideUp("fast");
		$("#backup_file_block").slideUp("fast");
		$("#backup_comment_block").slideUp("fast");

		var arr_id = $("#backuplist select").val();
		if (global_select_list.join() == arr_id.join()) return;
		global_select_list = arr_id;

		var count_id = arr_id ? arr_id.length : 0;
		if (count_id == 1)
		{
			var id = arr_id[0];
			$("#backup_parameters").slideUp("fast");
			var backup_info = getBackupInfo(id);
			var url = backup_info["url"];
			var log = backup_info["log"];
			var version = backup_info["ver"];
			var revision = backup_info["rev"];
			var status = backup_info["status"];
			var alien = backup_info["alien"];
			var migratory = backup_info["migratory"];
			var comment = backup_info["comment"];
			var origin = backup_info["origin"];
			var protected = backup_info["protected"];
			var transdb = backup_info["transdb"];

			var backup_nodes = "";
			for (var key in backup_info["nodes"])
			{
				backup_nodes += "name : " + key + ",  status : " + backup_info["nodes"][key] + "\n";
			}

			$("#downloadbackup").attr("href", url);
			$("#restorebackup").attr("alien", alien);
			$("#restorebackup").attr("migratory", migratory);

			$("#backup_version").text(version);
			$("#backup_revision").text(revision);
			$("#backup_status").text(status);
			$("#backup_origin").text(origin);
			$("#backup_protected").text(protected);
			$("#backup_comment").text(comment);
			$("#backup_transdb").text(transdb);
			$("#backup_nodes").empty();
			$("<pre>" + backup_nodes + "</pre>").appendTo("#backup_nodes");
			$("#backup_log").empty();
			$("<pre>" + log + "</pre>").appendTo("#backup_log");

			if (origin == 'native') {
				$("#row_backup_protected").hide();
			} else {
				$("#row_backup_protected").show();
			}

			if (transdb === 'yes') {
				$("#row_backup_transdb").show();
			} else {
				$("#row_backup_transdb").hide();
			}


			$("#backup_parameters").slideDown("fast");
			$("#restorebackup").show();
			$("#deletebackup").show();
			$("#downloadbackup").show();
		}
		else if (count_id == 0){
			$("#backup_parameters").slideUp("fast");
			$("#restorebackup").hide();
			$("#deletebackup").hide();
			$("#downloadbackup").hide();

		}
		else if (count_id > 1){
			$("#backup_parameters").slideUp("fast");
			$("#restorebackup").hide();
			$("#deletebackup").show();
			$("#downloadbackup").hide();

		}
	}

	function getBackupInfo(id)
	{
		var backup_info = "";
		$.ajax({
			url: "call.php",
			dataType: "json",
			async: false,
			cache: false,
			data: {
				'function' : 'getBackupInfo',
				'backup' : id
			},
			success: function(json)
			{
				backup_info = json[0];
			}
		});
		return backup_info;
	}

	function saveBackup(filename, filename_location)
	{
		$.ajax({
			url: "call.php",
			dataType: "json",
			cache: false,
			data: {
				'function' : 'saveBackup',
				'filename' : filename,
				'filename_location' : filename_location
			},
			success: function(list)
			{
				if (list[0]["error"] != "")
				{
					alert(__('Error: Backup not uploaded.') + list[0]["error"]);
				} else {
					top.setTimeout(init,2000);
				}
			}
		});
	}

	function backupFileUpload()
	{
		$.ajaxFileUpload(
			{
				url : 'uploadbackup.php',
				secureuri : false,
				fileElementId : 'backup_file',
				dataType : 'json',
				success :	function(data, status)
							{
								if(typeof(data.error) != 'undefined')
								{
									if(data.error !== '')
									{
										alert(data.error);
									} else
									{
										var filename = data.filename;
										var filename_location = data.filename_location;
										saveBackup(filename, filename_location);
									}
								}
							},
				error :		function(data, status, e)
							{
								alert(e);
							}
			}
		);
		return false;
	}

	var restoring = false;
	var lastGetLogTime = 0;
	function loadRestoreProcessLog(backup_id, div_log_id)
	{
		if (restoring)
		{
			lastGetLogTime = (new Date()).getTime();
			$.ajax({
				url: "call.php",
				dataType: "json",
				cache: false,
				data: {
					'function': 'getRestoreProcessLog',
					'backup': backup_id
				},
				success: function(list)
				{
					var log = "";
					if (list[0]["error"] != "")
					{
						//
						log = list[0]["log"];
						if ($.trim(log) == "")
							log = __("Create backup before restoring.");
					} else {
						log = list[0]["log"];
					}
					$("#" + div_log_id).empty();
					$("<pre>" + log + "</pre>").appendTo("#" + div_log_id);

					var now = (new Date()).getTime();
					if (now - lastGetLogTime >= 1000)
					{
						loadRestoreProcessLog(backup_id, div_log_id);
					} else {
						setTimeout(
							function(){
								loadRestoreProcessLog(backup_id, div_log_id);
							},
							1000 - (now - lastGetLogTime)
						);
					}
				}
			});
		}
	}

	function addEvents()
	{
		$("#createbackup").click(
			function()
			{

				$("#backup_parameters").slideUp("fast");
				$("#backup_comment_block").show();
				$("#backup_file_block").slideUp("fast");
			}
		);
		$("#btnCreateCancel").click(
			function()
			{
				$("#backup_parameters").slideUp("fast");
				$("#backup_comment_block").slideUp("fast");
			}
		);
		$("#btnCreate").click(
			function()
			{
				$("#backup_parameters").slideUp("fast");
				$("#backupcreate_log_container").slideDown("fast");
				var comment = $("#comment").val();
				var transdb = $("#include_transdb").prop("checked") ? "1" : "0";

				$.ajax( {
					url: "call.php",
					dataType: "json",
					data: {
						'function': 'createBackup',
						'comment': comment,
						'transdb': transdb
					},
					beforeSend: function()
					{
						$("#backup_comment_block").mask();
					},
					complete: function()
					{
						$("#backup_comment_block").slideUp("fast");
						$("#backup_comment_block").unmask();
					},
					success: function(list)
					{
						$("#backup_comment_block").slideUp("fast");
						if (list[0]["error"] != "")
						{
							alert(__("The backup was not created") + "\n" + list[0]["error"]);
						} else {
							alert(__("The backup has been created successfully"));
							init();
						}
					}
				});
			}
		);

		$("#logout").click(
			function()
			{
				top.location.href = '/sdi/login/logout.php?token=' + getToken();
			}
		);
		$("#restorebackup").click(
			function()
			{
				var alien = $(this).attr("alien");
				var migratory = $(this).attr("migratory");
				var margin = "50px";
				var msg = __("Are you sure you want to restore backup?");
				if(migratory == "1") {
					margin = "35px";
					msg = __("Warning! This backup seems to be created for other version of software. Restoring it will launch migration procedure. Do you want to proceed?");
				}
				else if(alien == "1") {
					margin = "35px";
					msg = __("Warning! This backup seems to be created for other master. Do you want to proceed?");
				}

				var buttons = {};
				buttons[__("Cancel")] = function() {
					$(this).dialog("close");
				};

				buttons[__("OK")] = function()
				{
					$("#backuprestore_log_container").slideDown("fast");
					var arr_id = $("#backuplist select").val();
					var restore_lic = $("#restore_license").prop("checked") ? "1" : "0";
					var id = arr_id[0];

					$(this).dialog("close");

					$.ajax( {
						url: "call.php",
						cache: false,
						data: { 'function' : 'restoreBackup', 'backup' : id,
							'license' : restore_lic
						      },
						beforeSend: function()
						{
							$("#backup_parameters").mask();
						},
						complete: function()
						{
							$("#backup_parameters").unmask();
						},
						success: function(data)
						{
							restoring = false;
							var list = eval(data);
							if (list[0]["error"] != "")
							{
								$("#backuprestore_log_container").slideUp("fast");
								$("#backup_parameters").slideDown("fast");
								alert(__("Backup was not restored") + "\n" + list[0]["error"]);
							} else {
								doTabClick = false;
								$("#logout").show();
								$("#backuplist select").prop("disabled", true);
								$("#createbackup").hide();
								$("#restorebackup").hide();
								$("#deletebackup").hide();
								$("#downloadbackup").hide();
								$("#uploadbackup").hide();
								alert(__("You backup recovery finished successfully.\nPlease make sure software users re-login in their User Interface, so that changes are propagated."));
								initafterrestore();
							}
						}
					});
					restoring = true;
					loadRestoreProcessLog(id, "backuprestore_log");
				};

				var replace_text = __("Replace existing license");
				$("#dialog-confirm").html(
					msg + "<div style='margin-top:"+margin+"'>"+
					"<input id='restore_license' type='checkbox'>"+
					"&nbsp;&nbsp;" + replace_text + "</input></div>"
				);
				$("#dialog-confirm" ).dialog({
					    resizable: false,
					    height: 200,
					    width: 400,
					    modal: true,
					    buttons: buttons
				});
			}
		);

		$("#deletebackup").click(
			function()
			{
				var arr_id = $("#backuplist select").val();
				var count_id = arr_id.length;
				var confirm_str = '';
				if (count_id == 1) confirm_str = __("Configuration backup will be deleted. Do you want to proceed?");
				if (count_id > 1) confirm_str = __("Do you realy want to delete " + count_id + " backups?");

				var buttons = {};
				buttons[__("OK")] = function() {
					var wasError = false;
					var viewAlert = '';

					$.ajax({
						url: "call.php",
						dataType: "json",
						cache: false,
						data: {
							'function': 'deleteBackup',
							'backuplist': JSON.stringify(arr_id)
						},
						success: function(list)
						{
							if (list[0]["error"] != "")
							{
								viewAlert = __("Some backups were not deleted:") +"\n" + list[0]["error"];
								wasError = true;
							}
							if (wasError) alert (viewAlert);
							init();
						}
					});

				    $( this ).dialog( "close" );
				};
				buttons[__("Cancel")] = function() {
					$( this ).dialog( "close" );
				};
				$("#dialog-confirm").html(confirm_str);
				$("#dialog-confirm" ).dialog({
					    resizable: false,
					    height: 200,
					    width: 400,
					    modal: true,
					    buttons: buttons
				});

			}
		);

		$("#uploadbackup").click(
			function()
			{
				$("#backup_comment_block").slideUp("fast");
				$("#backup_file_block").show();
			}
		);
		$("#btnUploadCancel").click(
			function()
			{
				$("#backup_file_block").hide();
			}
		);
		$("#backup_file_upload").click(
			function()
			{
				if ($.trim($("#backup_file").val()) == "")
					$("#backup_file_block").hide();
				else {
					backupFileUpload();
				}
			}
		);
		$("#downloadbackup").click(
			function()
			{
				window.location = $("#downloadbackup").attr("href");
			}
		);
	}
