<?php
/**
 * @version $Id: index.php 33536 2016-01-26 17:34:37Z astarostin $
 * ------------------------------------------------------------------------------
 * Backup manager GUI
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Win title */ __('Configuration backups');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="/sdi/global/editor.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/lib/css/smoothness/jquery-ui-1.10.4.css" type="text/css" />

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery-ui.min.js"></script>
	<script src="/sdi/lib/js/jquery-ajaxfileupload.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="/sdi/lib/js/jquery.mask.js"></script>
	<script src="js/backup_script.js"></script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu_header"><?php echo /* i18n: title */ __('Configuration backups');?></div>
		<div id="tabs_menu" class="tabs_menu">
			<div name="tab_user" class="current_tab" style="width: 33%;">
				<div class="tab_text"><?=__('User Created');?></div>
			</div>
			<div name="tab_auto" class="tab_inactive" style="width: 33%;">
				<div class="tab_text"><?=__('Automaticaly Created');?></div>
			</div>
			<div name="tab_prerestored" class="tab_inactive" style="width: 34%;">
				<div class="tab_text"><?=__('Pre-restored');?></div>
			</div>
		</div>
		<div class="tabs_content">
			<div id="main_block">
				<span id="loading"><img src="img/ajax-loader.gif" alt="Loading"/></span>
				<div id="backuplist_container" style="margin-bottom:10px">
					<div class="darkgrayhead">
						<span style="float: left;"><?php echo /* i18n: ... */ __('Backup list');?></span>
					</div>
					<div id="backuplist" class="tablestyle"></div>
					<div id="backup_file_block" style="float:left; margin-bottom:10px">
						<input id="backup_file" name="backup_file" type="file"/><input class="" type="button" value="<?php echo __('Upload');?>" id="backup_file_upload"/>
						<input class="" type="button" value="<?php echo __('Cancel');?>" id="btnUploadCancel"style="margin-left:30px;"/>
					</div>
					<div id="backup_comment_block" style="float:left; width:100%; margin-bottom:10px">
						<div style="float:left; margin-top:5px;"><?php echo /* i18n: ... */ __('Please, input comments for new backup');?></div>
						<input id="comment" name="comment" type="text" style="float:left; width:100%; margin-top:5px;"/>
						<div style="float:left; margin-top:5px; width:100%">
						    <input id="include_transdb" name="include_transdb" type="checkbox"/>
						    <?php echo /* i18n: ... */ __('Include transactional database');?>
						</div>
						<input class="" type="button" value="<?php echo __('Create');?>" id="btnCreate"style="float:left; margin-top:10px;"/>
						<input class="" type="button" value="<?php echo __('Cancel');?>" id="btnCreateCancel"style="float:left; margin-top:10px;  margin-left:30px;"/>
					</div>
				</div>
			</div>

			<div class="tabs_manage_buttons_wrapper">
				<div class="tabs_manage_buttons">
					<div><input type="button" id="createbackup" value="<?php echo __('New');?>"/></div>
					<div><input type="button" id="uploadbackup" value="<?php echo __('Upload');?>"/></div>
					<div><input type="button" id="restorebackup" value="<?php echo __('Restore');?>"/></div>
					<div><input type="button" id="deletebackup" value="<?php echo __('Delete');?>"/></div>
					<div><input type="button" id="downloadbackup" value="<?php echo __('Download');?>"/></div>
					<div><input type="button" id="logout" value="<?php echo __('Logout');?>"/></div>
				</div>
			</div>
			<div id="dialog-confirm"></div>

			<div id="log_block" style="margin-left:10px; margin-right:10px;">
				<div id="backuprestore_log_container">
					<div id="backuprestore_log"></div>
				</div>
				<div id="backupcreate_log_container">
					<div id="backupcreate_log"><?php echo /* i18n: ... */ __('Please wait while creating backup.');?></div>
				</div>
				<!--div style="clear: both; padding-top:10px"></div-->
				<div id="backup_parameters">
						<span><?php echo __("Information for Backup");?></span>
					<table class="border_table width100">
						<col width="10%">
						<tr>
							<th class="darkgrayhead"><label for="backup_version"><?php echo /* i18n: ... */ __('Version');?></label></th>
							<td class="tablestyle"><div id="backup_version" class="editfield"></div></td>
						</tr>
						<tr>
							<th class="darkgrayhead"><label for="backup_revision"><?php echo /* i18n: ... */ __('Revision');?></label></th>
							<td class="tablestyle"><div id="backup_revision" class="editfield"></div></td>
						</tr>
						<tr>
							<th class="darkgrayhead"><label for="backup_status"><?php echo /* i18n: ... */ __('Status');?></label></th>
							<td class="tablestyle"><div id="backup_status" class="editfield"></div></td>
						</tr>
						<tr>
							<th class="darkgrayhead"><label for="backup_origin"><?php echo /* i18n: ... */ __('Origin');?></label></th>
							<td class="tablestyle"><div id="backup_origin" class="editfield"></div></td>
						</tr>
						<tr id="row_backup_protected">
							<th class="darkgrayhead"><label for="backup_protected"><?php echo /* i18n: ... */ __('Protected');?></label></th>
							<td class="tablestyle"><div id="backup_protected" class="editfield"></div></td>
						</tr>
						<tr>
							<th class="darkgrayhead"><label for="backup_comment"><?php echo /* i18n: ... */ __('Comment');?></label></th>
							<td class="tablestyle"><div id="backup_comment" class="editfield"></div></td>
						</tr>
						<tr id="row_backup_transdb">
							<th class="darkgrayhead"><label for="backup_transdb"><?php echo /* i18n: ... */ __('Transactional DB');?></label></th>
							<td class="tablestyle"><div id="backup_transdb" class="editfield"></div></td>
						</tr>

						<tr>
							<th class="darkgrayhead"><label for="backup_nodes"><?php echo /* i18n: ... */ __('Nodes');?></label></th>
							<td class="tablestyle"><div id="backup_nodes" class="editfield"></div></td>
						</tr>
						<tr>
							<th class="darkgrayhead" style="vertical-align:top;"><label for="backup_log"><?php echo /* i18n: ... */ __('Log');?></label></th>
							<td class="tablestyle"><div id="backup_log" class="editfield"></div></td>
						</tr>
					</table>
				</div>
			</div>
		</div>
		<div id="param_block">
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
