<?php
/**
 * @version $Id: functions.php 11677 2008-08-05 15:27:55Z starostin $
 * ------------------------------------------------------------------------------
 * Backup manager functions
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

//if the user leaves the page or closes the browser prematurely, this will help prevent half completed statements
ignore_user_abort();

$master_backup_dir = $_SERVER['APL_VAR'] ."/backup/master";
$backup_dir = $_SERVER['APL_VAR'] ."/backup";
$temp_dir = $_SERVER['APL_VAR'] ."/tmp/backup";
$master_uni = Node::getUNI();

function getBackupList()
{
	$dateformat = getIdettityDateFormat();
	$list = array();

	global $master_backup_dir;
	$dir = $master_backup_dir;
	if (is_dir($dir))
	{
		$files = scandir($dir);
		if (is_array($files))
		{
//			sort($files);
			rsort($files);
			foreach($files as $file)
			{
				if (preg_match('/^([0-9]{6}_[0-9]{6})$/', $file, $regs) && is_dir("$dir/$regs[1]"))
				{
					$backup = $regs[1];
					$backup_stat_xml = "$master_backup_dir/$backup/stat.xml";

					if (!is_file("$backup_stat_xml") && is_dir("$master_backup_dir/$backup"))
					{
						system(escapeshellcmd("rm -rf $master_backup_dir/$backup"));
						continue;
					}
					$backup_comment = "$master_backup_dir/$backup/comment";


					$element = array();
					$element["backup"] = $backup;
					$element["name"] = $backup;
					$element["comment"] = '';
					if (is_file("$backup_comment") && is_dir("$master_backup_dir/$backup"))
					{
						$fh = fopen("$backup_comment", "r");
						$line = fgets($fh, 4096);
						$element["comment"] = $line;
						fclose($fh);
					}

					$type = "";
					$dom = new DOMDocument;
					if ($dom->load($backup_stat_xml))
					{
						$info = $dom->getElementsByTagName("BACKUP");
						if($info != NULL)
						{
							$type = $info->item(0)->getAttribute("TYPE");
							$time = $info->item(0)->getAttribute("TIME");
							$element["time"] = $time;
							date_default_timezone_set(Identity::getAttribute("TIME_ZONE"));
							$time = date($dateformat,$time);
							$element["name"] = $time;
						}
					}
					$element["backup_type"] = $type;
					array_push($list, $element);
				}
			}
		}
	}
	return $list;
}

function createBackup($comment = NULL, $transdb = NULL)
{
	$list = array();

	global $backup_dir;
	$error = "";
	$master_backup_pid = "$backup_dir/master_backup.pid";

	clearstatcache();
	if ($handle = @fopen($master_backup_pid, "r"))
	{
		$pid = fgets($handle);
		fclose($handle);
		$pid = trim($pid);
		$comm = shell_exec(escapeshellcmd("ps -p $pid -o comm="));
		if(strstr($comm, 'master_backup')) {
		    $error = __("Create backup process already running. Please try again later.");
		}
	}
	if($error == "") {
		if ($comment){
			$comment = str_replace("'", "'\"'\"'",$comment);
			$comment = "-c '" . $comment . "'";
		}
		$transdb = $transdb ? " -t" : "";
		$command = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] .
		" VERSIONER_PERL_VERSION=" . $_SERVER["VERSIONER_PERL_VERSION"] .
		" sudo -u " . "apl" . " " . $_SERVER['APL'] . "/conf/bin/master_backup " . $comment . $transdb;
		$result = system(escapeshellcmd($command). " >/dev/null 2>&1", $return_var);
		if ($return_var != 0)
		{
			$error = sprintf(__("Return value: %s"), $return_var);
		}
	}

	$element = array();
	$element["error"] = $error;


	$element["return_var"] = $return_var;
	$element["command"] = $command;

	array_push($list, $element);

	return $list;
}

function checkBackupUNI($backup_stat_xml)
{
	$node_conf = $_SERVER['APL'] . "/var/conf/node/conf";
	$uni_node = "";
	$uni_backup = "";

	if ($f = fopen($node_conf,"r"))
	{
		while (!feof($f)) {

			$line = stream_get_line($f, 65535, "\n");

			if(preg_match('/^UNI=(.+)$/', $line, $regs))
			{
				$uni_node = $regs[1];

				$dom = new DOMDocument;
				if ($dom->load($backup_stat_xml))
				{
					$info = $dom->getElementsByTagName("BACKUP");
					if($info != NULL)
					{
						$uni_backup = $info->item(0)->getAttribute("UNI");
					}
				}
				break;
			}
		}
	}

	$command = $_SERVER['APL'] . "/vpatch/bin/vctl maturity";
	$maturity = trim(shell_exec(escapeshellcmd($command)));

	$result = false;
	if ($uni_node == $uni_backup && $uni_node != "" && $uni_backup != ""
		|| $maturity == 'VIRGIN')
		$result = true;

	return $result;
}

function checkBackupVersion($backup_dir)
{
	$result = false;
	$dbs = array('confdb', 'transdb');
	$dbver_bck = array();

	foreach ($dbs as $db) {
		if ($f = fopen(escapeshellcmd("$backup_dir/db/version_$db"),"r"))
		{
		while (!feof($f)) {

			$line = stream_get_line($f, 65535, "\n");

			if(preg_match('/^(\w+)=(.+)$/', $line, $regs))
			{
			    $dbver_bck[$db][$regs[1]] = $regs[2];
			}
		}
		fclose($f);
	    }
	}

	if ( !$dbver_bck["confdb"]["VERSION"] || !$dbver_bck["confdb"]["ITERATION"] ||
	    !$dbver_bck["transdb"]["VERSION"] || !$dbver_bck["transdb"]["ITERATION"] )
	{
		return false;
	}

	$res = DB::select("SELECT version||'-'||iteration as ver from version_confdb");
	$vc_cur = $res[0]["ver"];
	$res = DB::select("SELECT version||'-'||iteration as ver from version_transdb");
	$vt_cur = $res[0]["ver"];
	$vc_bck = $dbver_bck["confdb"]["VERSION"]."-".$dbver_bck["confdb"]["ITERATION"];
	$vt_bck = $dbver_bck["transdb"]["VERSION"]."-".$dbver_bck["transdb"]["ITERATION"];

	if ( strcmp($vc_cur, $vc_bck) >= 0 && strcmp($vt_cur, $vt_bck) >= 0 )
	{
		$result = true;
	}

	return $result;
}

function getBackupDirName($backup_stat_xml)
{
	$dirname = "";
	$dom = new DOMDocument;
	if ($dom->load($backup_stat_xml))
	{
		$info = $dom->getElementsByTagName("BACKUP");
		if($info != NULL)
		{
			$TIME = $info->item(0)->getAttribute("TIME");
			$dirname = gmdate("ymd_His", $TIME);
		}
	}
	return $dirname;
}

function restoreBackup($backup, $license = false)
{
	$list = array();

	global $master_backup_dir, $backup_dir, $temp_dir;
	$error = "";
	$master_restore_pid = "$backup_dir/master_restore.pid";
	$restore_log = escapeshellcmd("$temp_dir/master_restore-$backup.log");
	$backup_stat_xml = "$master_backup_dir/$backup/stat.xml";

	// remove restore process log
	@unlink($restore_log);

	if (checkBackupUNI($backup_stat_xml))
	{
		if (checkBackupVersion("$master_backup_dir/$backup"))
		{
			if (is_dir("$master_backup_dir/$backup"))
			{
				clearstatcache();
				if ($handle = @fopen($master_restore_pid, "r"))
				{
					fclose($handle);
					$error = __("Restore backup process already running. Please try again later.");
				} else {

					// create backup before restore backup
					$command = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] .
					    " VERSIONER_PERL_VERSION=" . $_SERVER["VERSIONER_PERL_VERSION"] .
					    " sudo -u " . "apl" . " " . $_SERVER['APL'] .
					    "/conf/bin/master_backup -m pre-restored ";
					$result = system(escapeshellcmd($command) . ">/dev/null 2>&1", $return_var);


					//delete old pre-restored backups
					$bk_list = scandir("$master_backup_dir",1);
					$j = 0;
					for($i = 0; $i < count($bk_list); $i++){
						if(isset($bk_list[$i]) && $bk_list[$i]!=='.' && $bk_list[$i]!=='..'){
							$backup_dir = "$master_backup_dir/$bk_list[$i]";
							if (is_dir($backup_dir)){
								$backupInfo = getBackupInfo($bk_list[$i]);
								if ($backupInfo[0]['backup_type'] == 'pre-restored' && ($j++ > 4)){
									system(escapeshellcmd("rm -rf $backup_dir"), $return_var);
								}
							}
						}
					}
					$restore_lic = $license ? "-l" : "";
					$command = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] .
					    " VERSIONER_PERL_VERSION=" . $_SERVER["VERSIONER_PERL_VERSION"] .
					    " sudo -u " . "apl" . " " . $_SERVER['APL'] .
					    "/conf/bin/master_restore $restore_lic $backup ";
					$result = system(escapeshellcmd($command).">/dev/null 2>&1", $return_var);

					if ($return_var != 0)
					{
						$error = sprintf(__("Return value: %s"), $return_var);
					}
				}
			} else {
				$error = __("Backup does not exists. Please refresh the page.");
			}
		} else {
			$error = __("This backup from other version");
		}
	} else {
		$error = __("This backup from other server.");
	}

	$element = array();
	$element["error"] = $error;
	array_push($list, $element);

	return $list;
}

function getRestoreProcessLog($backup)
{
	global $temp_dir;
	$list = array();
	$element = array();
	$log = "";
	$error = "";
	$restore_log = escapeshellcmd("$temp_dir/master_restore-$backup.log");

	if (is_file($restore_log))
	{
		$log = file_get_contents($restore_log);
	} else {
		$error = __("Log file does not exists");
	}

	$element["log"] = $log;
	$element["error"] = $error;

	array_push($list, $element);
	return $list;
}

function deleteBackup($backuplist=array())
{
	$list = array();

	//$error = "";
	$error = array();
	foreach ($backuplist as $backup){
		if ($backup != "")
		{
			global $master_backup_dir;
			$backup_dir = "$master_backup_dir/$backup";
			if (is_dir($backup_dir))
			{
				$command = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] .
				" VERSIONER_PERL_VERSION=" . $_SERVER["VERSIONER_PERL_VERSION"] .
				" sudo -u " . "apl" . " " . $_SERVER['APL'] . "/conf/bin/master_backup -r " . $backup ;
				system(escapeshellcmd($command), $return_var);
				if ($return_var != 0)
				{
					$error[] =$backup . " - " . sprintf(__("Return value: %s"), $return_var);
				}
			}else {
				$error[] = $backup . " - " . __("Backup does not exists");
			}
		}
	}

	$element = array();
	$element["error"] = implode(", ",$error);
	array_push($list, $element);

	return $list;
}

function getBackupLink($backup)
{
	$url = "";

	$url = "http://" . $_SERVER['SERVER_NAME'] . "/sdi/backupmanager/downloadbackup.php?backup=$backup";

	return $url;
}

function getBackupInfo($backup)
{
	$list = array();
	$element = array();

	global $master_backup_dir, $master_uni;
	$backup_dir = "$master_backup_dir/$backup";

	if (is_dir($backup_dir))
	{
		$backup_verinfo = "$master_backup_dir/$backup/verinfo";
		$backup_stat_xml = "$master_backup_dir/$backup/stat.xml";
		$backup_log = escapeshellcmd("$master_backup_dir/$backup/backup.log");
		$comment = escapeshellcmd("$master_backup_dir/$backup/comment");
		$origin = escapeshellcmd("$master_backup_dir/$backup/origin");
		$transdb = escapeshellcmd("$master_backup_dir/$backup/db/transdb.db");

		$element["url"] = getBackupLink($backup);

		if (is_file($backup_log))
		{
			$element["log"] = file_get_contents($backup_log);
		}
		if (is_file($comment))
		{
			$element["comment"] = file_get_contents($comment);
		}else{
			$element["comment"] = '';
		}
		if (is_file($transdb))
		{
			$element["transdb"] = "yes";
		}else {
			$element["transdb"] = "no";
		}
		if (is_file($origin))
		{
			$data = file_get_contents($origin);
			$lines = preg_split("/\n/", $data);
			foreach ($lines as $line) {
			    list($attr, $val) = explode("=", $line);
			    if ($attr === "origin") {
				    $element["origin"] = $val;
				    $element["protected"] = "yes";
			    }
			    else if ($attr === "protected") {
				    $element["protected"] = $val === "1" ? "yes" : "no";
			    }
			}

		} else {
			$element["origin"] = "unknown";
			$element["protected"] = "unknown";
		}

		$vinfo_str = file_get_contents($backup_verinfo);
		if($vinfo_str !== FALSE) {
			$lines = preg_split("/\n/", $vinfo_str);
			foreach ($lines as $line) {
			    list($attr, $val) = explode("=", $line);
			    if ($attr === "ver") {
				    $element["ver"] = $val;
			    }
			    else if ($attr === "rev") {
				    $element["rev"] = $val;
			    }
			}
		}

		$dom = new DOMDocument;
		if ($dom->load($backup_stat_xml))
		{
			$info = $dom->getElementsByTagName("BACKUP");
			if($info != NULL)
			{
				$element["backup_type"] = $info->item(0)->getAttribute("TYPE");
				$element["status"] = $info->item(0)->getAttribute("STATUS");
				// Check for alien backup
				$backup_uni = $info->item(0)->getAttribute("UNI");
				$element["alien"] = $master_uni == $backup_uni ? "0" : "1";

			}
			$targets = $dom->getElementsByTagName("TARGET");
			foreach($targets as $target)
			{
				if ($target->getAttribute("NAME") == "Domain")
				{
					$nodes = array();
					$child_nodes = $target->getElementsByTagName("NODE");
					foreach($child_nodes as $child_node)
					{
						$nodes[$child_node->getAttribute("NAME")] = $child_node->getAttribute("STATUS");
					}
					$element["nodes"] = $nodes;
					break;
				}
			}
		}
	} else {
		$element["error"] = __("Backup does not exists. Please refresh the page.");
	}

	array_push($list, $element);

	return $list;
}

function saveBackup($filename, $filename_location)
{
	$list = array();

	$error = "";
	$warnings = array();
	$p = 'X3ins1de';
	$protected = 1;
	global $master_backup_dir, $temp_dir;

	if (is_file($filename_location))
	{
		$dir = dirname($filename_location);
		$stat_xml = "$dir/stat.xml";
		@unlink($stat_xml);

		$result = system(
			"cd ".escapeshellcmd($dir)." && unzip -Z1 ".escapeshellcmd($filename_location).
			" | grep stat.xml | xargs unzip -qq -j -P $p ".escapeshellcmd($filename_location));

		if (is_file($stat_xml)) {

			// Check if backup is password-protected
			$result = exec("cd ".escapeshellcmd($dir)." && unzip -Z ".escapeshellcmd($filename_location).
			     " | grep stat.xml | perl -p -e '\$_=substr((split /\s+/)[4],0,1)'");

			if ($result === 'T' || $result === 'B') {
				$result = system("cd ".escapeshellcmd($dir)." && unzip -qq -P $p ".escapeshellcmd($filename_location));

				$bckdir = getBackupDirName($stat_xml);
				$bckpath = $dir . "/" . $bckdir;

				if (checkBackupUNI($stat_xml))
				{
					if (checkBackupVersion($bckpath))
					{
						// Write 'origin' file
						@unlink("$temp_dir/{$filename}.origin");
						if ($fh = fopen("$temp_dir/{$filename}.origin", "w")) {
							fwrite($fh, "backup=$filename\n");
							fwrite($fh, "origin=foreign\n");
							fwrite($fh, "protected=".$protected."\n");
							fwrite($fh, "uploaded_at=".time()."\n");
							fwrite($fh, "uploader_id=".$_SESSION[SESSION_USERID]."\n");
							if (fclose($fh)) {
							    @unlink("$temp_dir/$filename");
							    if(rename($filename_location, "$temp_dir/$filename") !== true) {
								$error = __("Error moving uploaded backup");
							    }

							} else {
							    $error = __("Error writing origin file");
							}
						} else {
						    $error = __("Error writing origin file");
						}


					} else {
						$error = __("This backup from other version");
					}
				} else {
					$error = __("This backup from other server");
				}
			}
			else { // Backup is not encrypted
				$error = __("Inconsistent backup file. Upload forbidden");
				$protected = 0;
			}

			@unlink($stat_xml);
			if (is_dir($bckpath)) {
				system(escapeshellcmd("rm -rf $bckpath"));
			}

		} else {
			$error = __("Invalid backup format");
		}

	} else {
		$error = __("Cannot find uploaded backup");
	}

	// remote temporary backup file if still exists
	if (is_file($filename_location))
	{
		@unlink(escapeshellcmd($filename_location));
	}

	$element = array();
	$element["error"] = $error;
	$element["warnings"] = $warnings;
	array_push($list, $element);

	return $list;
}

function getIdettityDateFormat()
{
	//get short data format
	$sysDateFormat = Identity::getAttribute("NLS_LONG_DATE_FORMAT");
	$dateformat = "m/d/y H:i:s";
	$delimer = "/";
	$pos = strpos($sysDateFormat, "/");
	if ($pos !== false) $delimer = "/";
	$pos = strpos($sysDateFormat, "-");
	if ($pos !== false) $delimer = "-";
	$pos = strpos($sysDateFormat, ".");
	if ($pos !== false) $delimer = ".";
	$sysDFParts = explode($delimer, $sysDateFormat);
	$phpDFParts = array();
	for ($i=0; $i<count($sysDFParts); $i++){
		switch ($sysDFParts[$i]){
			case "D": $phpDFParts[] = "j";	break;
			case "DD": $phpDFParts[] = "d";	break;
			case "M": $phpDFParts[] = "n";	break;
			case "MM": $phpDFParts[] = "m";	break;
			case "YY": $phpDFParts[] = "y";	break;
			case "YYYY": $phpDFParts[] = "y";	break;
		}
	}
	if (count($phpDFParts) > 0)
		$dateformat = implode($delimer, $phpDFParts) .  " H:i:s";
	return $dateformat;
}

?>
