<?php
/**
 * @version $Id: downloadbackup.php 28462 2013-04-24 12:54:56Z astarostin $
 * ------------------------------------------------------------------------------
 * Return file to user
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

include("functions.php");

// Check if user is Admin (assigned to Admin Role)
$user = new User();
if (!$user->isAdmin($_SESSION[SESSION_USERID]))
{
	header('HTTP/1.0 403 Forbidden');
	echo __("Access denied\n");
	exit;
}

if (isset($_GET['backup']))
{
	global $master_backup_dir, $temp_dir;
	$backup = $_GET['backup'];

	if (preg_match('/^([0-9]{6})_([0-9]{6})$/', $backup, $regs))
	{
		$backup = sprintf("%06d", intval($regs[1], 10)) . "_" . sprintf("%06d", intval($regs[2], 10));
	} else {
		header('HTTP/1.0 404 Not Found');
		echo __("Backup not found\n");
		exit;
	}

	$backup_file_name = "$backup.mbck";
	$backup_file = "$temp_dir/$backup_file_name";

	if (!is_dir($temp_dir))
	{
		mkdir($temp_dir);
	}

	# delete all backup archives older then 30 minutes
	$result = system(escapeshellcmd("find $temp_dir -type f -mmin +30 -name '*.mbck' -delete"), $return_var);

	if (!is_dir("$master_backup_dir/$backup"))
	{
		header('HTTP/1.0 404 Not Found');
		echo __("Backup not found\n");
		exit;
	}

	if (!is_file($backup_file))
	{
		$result = system("cd $master_backup_dir && zip -qry -P X3ins1de ".escapeshellcmd("$backup_file $backup"), $return_var);
	}
	if ($return_var != 0)
	{
		$error = sprintf(__("Return value: %s"), $return_var);
	}

	if (!file_exists($file = $backup_file))
	{
		header('HTTP/1.0 404 Not Found');
		echo __("Some errors while creating backup\n");
		exit;
	}

	////////////////////////////////////////////////////////////////////////////////

	set_time_limit(0);
	header('Cache-Control: private');
	header('Content-Type: application/x-force-download; name="'.$backup_file_name.'"');
	header('Content-Disposition: attachment; filename="'.$backup_file_name.'"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');

	////////////////////////////////////////////////////////////////////////////////
	$range = 0;
	if (isset($_SERVER['HTTP_RANGE']) && ($range = $_SERVER['HTTP_RANGE']))
	{
		$range = str_replace('bytes=', '', $range);
		$range = intval(str_replace('-', '', $range), 10);
		$size  = filesize($file);

		header('HTTP/1.0 206 Partial Content');
		header('Content-Length: '.$size - $range);
		header('Content-Range: bytes '.$range.'-'.($size - 1).'/'.$size);
	} else {
		header('HTTP/1.0 200 OK');
		header('Content-Length: '.filesize($file));
	}

	////////////////////////////////////////////////////////////////////////////////

	$file = fopen(escapeshellcmd($file), 'rb');
	fseek($file, (int)$range);

	while (!feof($file) and !connection_status()){
		echo fread($file, (1024 * 8));
		flush();
		ob_flush();
	}
}
?>
