<?php
/**
 * @version $Id: call.php 11677 2008-08-05 15:27:55Z starostin $
 * ------------------------------------------------------------------------------
 * Backup manager API interface
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

include('functions.php');

if (Identity::getAttribute("CHECK_CSRFTOKEN") == "yes"
	&&
	isset($_SERVER["HTTP_X_TOKEN"]) && !SessionManager::checkCSRFToken($_SERVER["HTTP_X_TOKEN"])
)
{
	$response = array();
	$response["error"] = "Forbidden";
	$response["code"] = 403;
	echo json_encode($response);

	exit;
}

// Check if user is Admin (assigned to Admin Role)
$user = new User();
if (!$user->isAdmin($_SESSION[SESSION_USERID]))
{
	$response = array();
	$response["code"] = 403;
	$response["error"] = "Access denied";
	echo json_encode($response);

	exit;
}

if (isset($_POST['function']))
{
	switch ($_POST['function'])
	{
	}
}
if (isset($_GET['function']))
{
	switch ($_GET['function'])
	{
		case 'getBackupList':
				echo json_encode(getBackupList());
			exit;
			break;
		case 'createBackup':
				echo json_encode(createBackup($_GET['comment'], $_GET['transdb']));
			exit;
			break;
		case 'restoreBackup':
			if (isset($_GET['backup']))
				echo json_encode(restoreBackup($_GET['backup'], $_GET['license']));
			exit;
			break;
		case 'getRestoreProcessLog':
			if (isset($_GET['backup']))
				echo json_encode(getRestoreProcessLog($_GET['backup']));
			exit;
			break;
		case 'deleteBackup':
			if (isset($_GET['backuplist']))
				echo json_encode(deleteBackup(json_decode($_GET['backuplist'])));
			exit;
			break;
		case 'getBackupInfo':
			if (isset($_GET['backup']))
				echo json_encode(getBackupInfo($_GET['backup']));
			exit;
			break;
		case 'saveBackup':
			if (isset($_GET['filename']) && isset($_GET['filename_location']))
				echo json_encode(saveBackup($_GET['filename'], $_GET['filename_location']));
			exit;
			break;
	}
}
?>
