<?php
/**
 * @version $Id: panel.php 25452 2012-03-22 16:00:20Z astarostin $
 * ------------------------------------------------------------------------------
 * Control panel for avatar
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
	require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
	SessionManager::isUserLoggedIn() or SessionManager::redirect();

	$avatarObj = 0;
	if (!isset($_GET["obj"]))
	{
		die("avatar obj not defined");
	}
	$avatarObj = intval($_GET["obj"], 10);
	
	$avatar = new Avatar();
	$avatarAttrs = $avatar->getAttributes($avatarObj);
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Avatar status panel');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link rel="stylesheet" type="text/css" href="/sdi/lib/css/smoothness/jquery-ui-1.10.4.css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script>
		var require = {
			config: {
				panel_2: {
					obj: <?=$avatarObj;?>,
					userId: <?=$_SESSION[SESSION_USERID];?>
				}
			},
			paths: {
				panel_2: "js/panel_2"
			}
		};
	</script>
	<script src="/sdi/lib/js/require.js" data-main="panel_2"></script>
	<script src="/sdi/lib/js/jquery.js"></script>
</head>
<body>
	<div class="tabs">
	<?php 
		if(!isset($_GET['noheader'])){ ?>
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php 
						print $avatarAttrs['NAME'] . " " . __("panel");
					?>
				</div>
			</div>
		</div>
		<?php } ?>
		<div class="tabs_content border_table">
			<table id="av_table">
				<tr>
					<th><?php echo __("Status"); ?></th>
					<th><?php echo __("Value"); ?></th>
					<th><?php echo __("Controls"); ?></th>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Connection Status"); ?> :&nbsp;</td>
					<td><div id="av_status"></div></td>
					<td></td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Last status update"); ?> :&nbsp;</td>
					<td>
						<span id="av_statusLastUpdate"></span>&nbsp;
					</td>
					<td class="align_center">
						<button id="but_reqStatusUpdate" title="<?php echo __("Update Avatar status"); ?>"><?php echo __("Request update"); ?></button>
						<button id="but_reopenChannel" title="<?php echo __("Reopen Avatar channel"); ?>"><?php echo __("Reopen channel"); ?></button>
					</td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Status propagation interval"); ?> :&nbsp;</td>
					<td><div id="av_statusPropInterval"></div></td>
					<td></td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Devices"); ?> :&nbsp;</td>
					<td><div id="av_devices"></div></td>
					<td></td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Pending auto content delivery requests"); ?> :&nbsp;</td>
					<td>
						<span id="av_pendingAutoRequests"></span>
					</td>
					<td class="align_center">
						<button id="but_reqAutoPurge" title="<?php echo __("Purge auto requests"); ?>"><?php echo __("Purge"); ?></button>
					</td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Pending explicit content delivery requests"); ?> :&nbsp;</td>
					<td>
						<span id="av_pendingExplicitRequests"></span>
					</td>
					<td class="align_center">
						<button id="but_reqExplicitPurge" title="<?php echo __("Purge explicit requests"); ?>"><?php echo __("Purge"); ?></button>
					</td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Queued for Delivery"); ?> :&nbsp;</td>
					<td><span id="av_queued"></span>&nbsp;<?php echo __("Mbytes"); ?></td>
					<td class="align_center">
						<button id="av_queued_link" title="<?php echo __("Show queued details"); ?>"><?php echo __("Show details"); ?></button>
					</td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Recent Deliveries"); ?> :&nbsp;</td>
					<td><span id="av_recent"></span>&nbsp;<?php echo __("Mbytes/s"); ?></td>
					<td class="align_center">
						<button id="av_recent_link" title="<?php echo __("Show recent details"); ?>"><?php echo __("Show details"); ?></button>
					</td>
				</tr>
				<tr>
					<td class="align_right"><?php echo __("Turnaround Time"); ?> :&nbsp;</td>
					<td><div id="av_turnaround"></div></td>
					<td></td>
				</tr>
				<!--
				<tr>
					<td class="align_right"><?php echo __("Retransmits"); ?> :&nbsp;</td>
					<td><div id="av_retransmits"></div></td>
					<td></td>
				</tr>
				-->
			</table>
			<div id="dialog" title="<?php echo __("Content delivery details"); ?>">
				<p>
					<span id="dialog_control"></span>
					<span id="dialog_content"></span>
				</p>
			</div>
		</div>
		<div class="tabs_footer2"></div>
	</div>
</body>
</html>
