<?php
/**
 * @version $Id: panel.php 33536 2016-01-26 17:34:37Z astarostin $
 * ------------------------------------------------------------------------------
 * Control panel for avatar
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
	require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
	SessionManager::isUserLoggedIn() or SessionManager::redirect();

	$avatarObj = 0;
	if (!isset($_GET["obj"]))
	{
		die("avatar obj not defined");
	}
	$avatarObj = intval($_GET["obj"], 10);
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Avatar control panel');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/global/editor.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery.mask.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="/sdi/lib/js/log.js"></script>
	<script src="/sdi/lib/js/es5-shim.js"></script>
	<script src="/sdi/lib/js/api.js"></script>
	<script>
		var avatarObj = <?=$avatarObj;?>;
	</script>
	<script src="js/panel.js"></script>
</head>
<body>
	<div class="tabs_content">
		<div class="tabs_form">
			<!--
			<div>
				<div class="caption">Avatars</div>
				<select id="avatar_list"></select>
			</div>
			-->
			<fieldset>
				<table>
					<tr>
						<td>Avatar</td>
						<td><input type="button" value="ON" data-attr="POWER" data-value="on"><input type="button" value="OFF" data-attr="POWER" data-value="off"></td>
					</tr>
					<tr>
						<td>Radio</td>
						<td><input type="button" value="ON" data-attr="CHANNEL" data-value="on"><input type="button" value="OFF" data-attr="CHANNEL" data-value="off"></td>
					</tr>
					<tr>
						<td>Engine</td>
						<td><input type="button" value="Start/Stop" data-attr="ENGINE" data-value="on"><input type="button" value="Cut-OFF" data-attr="ENGINE" data-value="off"></td>
					</tr>
				</table>
			</fieldset>

			<fieldset>
				<table>
					<tr><td>Status</td><td><input id="STATUS" type="text" data-type="stat" data-attr="STATUS" readonly="true" value=""></td></tr>
					<tr><td>Data</td><td><input id="DATA" type="text" data-type="stat" readonly="true" data-attr="DATA" value=""></td></tr>
					<tr><td>Power</td><td><input id="POWER" type="text" data-type="stat" readonly="true" data-attr="POWER" value=""></td></tr>
				</table>
			</fieldset>
		</div>
	</div>
</body>
</html>
