/**
 * @version $Id: panel_2.js 33957 2016-03-21 13:30:18Z sabaev $
 * ------------------------------------------------------------------------------
 * caontrol panel for avatar
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

define("panel_2", ["module", "jquery", "jquery-ui", "i18n", "log", "api"], function(module){
	"use strict";

	window.avatarPanel = new AvatarPanel_2(module.config());

	$(document).ready(function(){
		avatarPanel.init();
	});

	/**
	 * create object for controling avatar panel
	 *
	 * @param {Number} obj
	 * @constructor
	 */
	function AvatarPanel_2(cfg)
	{
		var _self = this;

		/**
		 * @type {Number}
		 * @private
		 */
		var _avatarObj = cfg.obj;

		var _userObjId = cfg.userId;

		/**
		 * @type {Number}
		 * @private
		 */
		var _statusUpdateInterval = 30000;
		var _statusUpdateIntervalObj;

		/**
		 * @type {API}
		 * @private
		 */
		var _api = new API();

		var _data = {
			identity: [],
			status: "",
			attrs: [],
			requests: [],
			devices: [],
			delivery: []
		};

		this.init = function()
		{
			$("#dialog_control").text(__("Scope") + ": ");
			var sel = $('<select>').appendTo('#dialog_control');

			var options = [
				{val : 1, text: '1 ' + __("minute")},
				{val : 5, text: '5 ' + __("minutes")},
				{val : 15, text: '15 ' + __("minutes")},
				{val : 30, text: '30 ' + __("minutes")},
				{val : 60, text: '60 ' + __("minutes")}
			];

			$(options).each(function() {
				sel.append($("<option>").attr('value', this.val).text(this.text));
			});
			sel.attr("id", "interval").find("option:last").prop("selected", true);

			$("#dialog").dialog({
				modal: true,
				autoOpen: false,
				width: 500
			});

			$.when(
				_api.getObjectList({parentObj: _avatarObj, type: "camera", withAttributes: true})
			)
				.fail(function(code, message){
					//Log.error("[" + code + "] " + message);
				})
				.done(function(getDevicesResponse){
					// set avatar devices data
					if(getDevicesResponse && getDevicesResponse.error == ""){
					_data.devices = getDevicesResponse.list;
					}

					_self.updateAvatarDetails();
					_self.addEvents();
					_self.runUpdates();
				});
		};

		/**
		 * add events
		 */
		this.addEvents = function()
		{
			$("#but_reqStatusUpdate").on("click", function(){
				_self.updateAvatarDetails();
			});

			$("#but_reopenChannel").on("click", function(){
				_self.reopenChannel();
			});

			$("#but_reqAutoPurge").on("click", function(){
				_self.purgeDownloadRequests(true);
			});

			$("#but_reqExplicitPurge").on("click", function(){
				_self.purgeDownloadRequests(false);
			});

			$("#av_queued_link").on("click", function(){
				_self.showDetailsDialog("t");
			});

			$("#av_recent_link").on("click", function(){
				_self.showDetailsDialog("f");
			});

			$("#interval").on("change", function(){
				_self.showDetailsDialog("f");
			});
		};

		/**
		 * update stats on page
		 */
		this.runUpdates = function()
		{
			_statusUpdateIntervalObj = setInterval(function(){
				_self.updateAvatarDetails();
			}, _statusUpdateInterval);
		};

		/**
		 * stop updating stats
		 */
		this.stopUpdate = function()
		{
			clearInterval(_statusUpdateIntervalObj);
		};

		this.updateAvatarDetails = function()
		{
			var btn = $("#but_reqStatusUpdate");
			btn.prop("disabled", true);

			var devIds = [];
			for(var i = 0; i < _data.devices.length; i++){
				devIds.push(_data.devices[i].obj);
			}

			$.when(
				_api.getIdentityAttributes(),
				_api.getAttributes({obj: _avatarObj}),
				_api.getAvatarStatus({obj: _avatarObj}),
				_api.getContentDeliveryDetails({objs: JSON.stringify(devIds)}),
				_api.getObjectList({parentObj: _avatarObj, type: "camera", withAttributes: true}),
				_self.getDownloadRequests()
			)
				.fail(function(code, message){
					btn.prop("disabled", false);
					//Log.error("[" + code + "] " + message);
				})
				.done(function(getIdentityResponse, getAttributesResponse, getStatusResponse, getCDDetailsResponse, getDevicesResponse, getDownloadRequestsResponse){
					// set system identity data
					if(getIdentityResponse && getIdentityResponse[0].error == ""){
						_data.identity = getIdentityResponse[0].list;
					}

					// set avatar attrs data
					if(getAttributesResponse && getAttributesResponse[0].error == ""){
						_data.attrs = getAttributesResponse[0].list;
					}

					// set avatar status data
					if(getStatusResponse && getStatusResponse[0].error == ""){
						_data.status = getStatusResponse[0].status;
					}

					// set content download details data
					if(getCDDetailsResponse && getCDDetailsResponse[0].error == ""){
						_data.delivery = getCDDetailsResponse[0].details;
					}

					// set avatar devices data
					if(getDevicesResponse && getDevicesResponse[0].error == ""){
						_data.devices = getDevicesResponse[0].list;
					}

					_self.repaintData();
					btn.prop("disabled", false);
				});
		};

		/**
		*  get all requests
		*/
		this.getDownloadRequests = function() {
			$.ajax('/cxf/services/aod/get', {
				context: this,
				data: {
					userid: _userObjId
				},
				success: function(data) {
					_data.requests = (data.requests ? data.requests : []);
				}
			});
		};

		/**
		*  purge requests
		*/
		this.purgeDownloadRequests = function(isPrivate) {
			$("#but_reqAutoPurge").prop("disabled", true);
			$("#but_reqExplicitPurge").prop("disabled", true);

			for(var i = 0; i < _data.requests.length; i++){
				if(_data.requests[i].private == isPrivate && $.inArray(_data.requests[i].status, ['COMPLETED', 'CANCELED', 'FAILED']) == -1){
					$.ajax('/cxf/services/aod/cancel', {
						cache: false,
						data: {requestid: _data.requests[i].requestid},
						success: function(data) {}
					});
				}
			}

			$("#but_reqAutoPurge").prop("disabled", false);
			$("#but_reqExplicitPurge").prop("disabled", false);
		};

		/**
		*  reopen channel
		*/
		this.reopenChannel = function() {
			var btn = $("#but_reopenChannel");
			btn.prop("disabled", true);
			$.when(
				_api.execAvatarExternalCommand({obj: _avatarObj, commandName: _data.attrs['REOPEN_CHANNEL_CMD']})
			)
				.fail(function(code, message){
					btn.prop("disabled", false);
					//Log.error("[" + code + "] " + message);
				})
				.done(function(getCommandResponse){
					if(getCommandResponse.error != ""){
						alert(__("Error") + " : " + getCommandResponse.error);
					}
					else if(getCommandResponse.exit_status != 0){
						alert(__("Error") + " : " + getCommandResponse.message);
					}
					else{
						alert(__("Channel reopened!"));
					}
					btn.prop("disabled", false);
				});
		};

		/**
		*  repaint data
		*/
		this.repaintData = function() {
			if(_data.status == "ONLINE"){
				$("#av_status").addClass("av_status_online");
			}
			else{
				$("#av_status").removeClass("av_status_online");
			}
			$("#av_status").text(_data.status);
			
			var lastUpdateText = _self.tsToDate(_data.attrs['STAT_TIME']*1000);
			lastUpdateText = lastUpdateText.split(".");
			$("#av_statusLastUpdate").text(lastUpdateText[0]);

			if(_data.attrs['REOPEN_CHANNEL_CMD'] == ''){
				$("#but_reopenChannel").prop("disabled", true);
			}
			else{
				$("#but_reopenChannel").prop("disabled", false);
			}

			var statusPropagationIntervaltext = "";
			var spiMinutes = Math.floor(_data.attrs['STATUS_PROPOGATION_INTERVAL']/60);
			var spiSeconds = _data.attrs['STATUS_PROPOGATION_INTERVAL'] - spiMinutes*60;
			
			if(spiMinutes > 0){
				statusPropagationIntervaltext+= spiMinutes + " " + __("min") + " ";
			}
			if(spiSeconds > 0){
				statusPropagationIntervaltext+= spiSeconds + " " + __("sec");
			}
			$("#av_statusPropInterval").text(statusPropagationIntervaltext);

			var devOnline = 0;
			var devOffline = 0;
			var devOnDemand = 0;
			var onDemandValues = [
				"ARCHIVE_EVENTS_LR|METADATA_EVENTS",
				"ARCHIVE_EVENTS_NR|ARCHIVE_EVENTS_LR|METADATA_EVENTS",
				"METADATA_EVENTS"
			];
			for(var i = 0; i < _data.devices.length; i++){
				if(_data.devices[i].attributes['STATUS'] == "ON"){
					devOnline++;
				}
				else if(_data.devices[i].attributes['STATUS'] == "OFF"){
					devOffline++;
				}
				
				if($.inArray(_data.devices[i].attributes['AV_DELIVERY_HR'], onDemandValues) != -1){
					devOnDemand++;
				}
			}
			$("#av_devices").text(devOnline + " " + __("online") + ", " + devOnDemand + " " + __("on-demand") + ", " + devOffline + " " + __("offline"));

			var reqAuto = 0;
			var reqExplicit = 0;

			for(var i = 0; i < _data.requests.length; i++){
				// count by type
				if(_data.requests[i].private && $.inArray(_data.requests[i].status, ['NOT CONFIRMED', 'COMPLETED', 'CANCELED', 'FAILED']) == -1){
					reqAuto++;
				}
				else if(!_data.requests[i].private && $.inArray(_data.requests[i].status, ['NOT CONFIRMED', 'COMPLETED', 'CANCELED', 'FAILED']) == -1){
					reqExplicit++;
				}
			}

			if(reqAuto == 0){
				$("#but_reqAutoPurge").prop("disabled", true);
			}
			else{
				$("#but_reqAutoPurge").prop("disabled", false);
			}

			if(reqExplicit == 0){
				$("#but_reqExplicitPurge").prop("disabled", true);
			}
			else{
				$("#but_reqExplicitPurge").prop("disabled", false);
			}

			$("#av_pendingAutoRequests").text(reqAuto);
			$("#av_pendingExplicitRequests").text(reqExplicit);

			var reqQueuedSize = 0;
			var reqSpeed = 0;
			for(var i = 0; i < _data.delivery.length; i++){
				if(_data.delivery[i].isqueued == "t"){
					reqQueuedSize+= parseFloat(_data.delivery[i].megabytes);
				}
				else{
					reqSpeed+= parseFloat(_data.delivery[i].megabytes)/parseInt(_data.delivery[i].seconds, 10);
				}
			}
			reqQueuedSize = Math.round(reqQueuedSize * 1000) / 1000;
			reqSpeed = Math.round(reqSpeed * 1000) / 1000;
			$("#av_queued").text(reqQueuedSize);
			$("#av_recent").text(reqSpeed);

			var avg = parseInt(_data.attrs['STAT_RTT_AVG']*1000, 10);
			var min = parseInt(_data.attrs['STAT_RTT_MIN']*1000, 10);
			var max = parseInt(_data.attrs['STAT_RTT_MAX']*1000, 10);
			if(max > 999999){
				max = "?";
			}
			$("#av_turnaround").text(avg + " mS " + __("average") + ", " + min  + " mS " + __("minimum") + ", " + max  + " mS " + __("maximum"));

			//$("#av_retransmits").text("0.000 %");

			$("#av_table").css("visibility", "visible");
		};

		this.showDetailsDialog = function(type) {
			if(type == "f"){
				$("#interval").css("display", "block");
			}
			else{
				$("#interval").css("display", "none");
			}

			$.when(
				_api.getServerTime()
			)
				.fail(function(code, message){
					//Log.error("[" + code + "] " + message);
				})
				.done(function(getTimeResponse){
					if(getTimeResponse.error != ""){
						alert(__("Error") + " : " + getTimeResponse.error);
					}
					else{
						var inteval = $("#interval").val();
						var time_limit = getTimeResponse["servertime"] - inteval*60;
						var devs = [];

						var dLiveTotal = 0;
						var dArchiveTotal = 0;
						var dAutoPushTotal = 0;
						var dOnDemandTotal = 0;

						for(var i = 0; i < _data.devices.length; i++){
							if(_data.devices[i].subtype != "C"){
								continue;
							}

							var dLive = 0;
							var dArchive = 0;
							var dAutoPush = 0;
							var dOnDemand = 0;
							for(var j = 0; j < _data.delivery.length; j++){
								if(_data.devices[i].obj == _data.delivery[j].objid && (type == "t" || _data.delivery[j].timestamp >= time_limit)){
									if(_data.delivery[j].deliverytypeid == 1){
										dLive+= parseFloat(_data.delivery[j].megabytes);
										dLiveTotal+= parseFloat(_data.delivery[j].megabytes);
									}
									else if(_data.delivery[j].deliverytypeid == 3){
										dArchive+= parseFloat(_data.delivery[j].megabytes);
										dArchiveTotal+= parseFloat(_data.delivery[j].megabytes);
									}
									
									if(_data.delivery[j].isqueued == 't'){
										dOnDemand+= parseFloat(_data.delivery[j].megabytes);
										dOnDemandTotal+= parseFloat(_data.delivery[j].megabytes);
									}
									else if(_data.delivery[j].isqueued == 'f'){
										dAutoPush+= parseFloat(_data.delivery[j].megabytes);
										dAutoPushTotal+= parseFloat(_data.delivery[j].megabytes);
									}
								}
							}

							devs[_data.devices[i].obj] = [_data.devices[i].name, dLive, dArchive, dAutoPush, dOnDemand];
						}

						var html = '<div class="border_table"><table class="av_border">';
						html+= "<tr>";
						html+= "<th class='align_center av_border'>" + __("Device") + "</th>";
						html+= "<th class='align_center av_border'>" + __("Live view") + "</th>";
						html+= "<th class='align_center av_border'>" + __("Streamed archive") + "</th>";
						html+= "<th class='align_center av_border'>" + __("Auto-push") + "</th>";
						html+= "<th class='align_center av_border'>" + __("On-demand") + "</th>";
						html+= "</tr>";

						devs.forEach(function(dev, i, arr) {
							html+= "<tr>";
							html+= "<td class='align_center av_border'>" + dev[0] + "</td>";
							html+= "<td class='align_center av_border'>" + (Math.round(dev[1] * 1000) / 1000) + "</td>";
							html+= "<td class='align_center av_border'>" + (Math.round(dev[2] * 1000) / 1000) + "</td>";
							html+= "<td class='align_center av_border'>" + (Math.round(dev[3] * 1000) / 1000) + "</td>";
							html+= "<td class='align_center av_border'>" + (Math.round(dev[4] * 1000) / 1000) + "</td>";
							html+= "</tr>"
						});

						html+= "<tr>";
						html+= "<td class='align_center av_border'>" + __("Total") + ":</td>";
						html+= "<td class='align_center av_border'>" + (Math.round(dLiveTotal * 1000) / 1000) + "</td>";
						html+= "<td class='align_center av_border'>" + (Math.round(dArchiveTotal * 1000) / 1000) + "</td>";
						html+= "<td class='align_center av_border'>" + (Math.round(dAutoPushTotal * 1000) / 1000) + "</td>";
						html+= "<td class='align_center av_border'>" + (Math.round(dOnDemandTotal * 1000) / 1000) + "</td>";
						html+= "</tr>";

						html+= "</table>";
						html+= "</div>";
						$("#dialog_content").html(html);
						$("#dialog").dialog("open");
					}
				});
		};

		/**
		*  transform timestamp to viewable date in system format
		*/
		this.tsToDate = function(timestamp) {
			var format = _data.identity['NLS_LONG_DATE_FORMAT'] + " " + _data.identity['NLS_TIME_FORMAT'];
			var date = new Date(timestamp);

			format = format.replace('YYYY', date.getFullYear());
			format = format.replace('YY',   String(date.getFullYear()).substr(2));
			format = format.replace('MM',  (date.getMonth()+1<10) ?  "0"+(date.getMonth()+1)  : date.getMonth()+1);
			format = format.replace('DD',  (date.getDate()<10)    ?  "0"+date.getDate()       : date.getDate());

			format = format.replace('hh',  (date.getHours()<10)   ?  "0"+date.getHours()      : date.getHours());
			format = format.replace('mm',  (date.getMinutes()<10) ?  "0"+date.getMinutes()    : date.getMinutes());
			format = format.replace('SS',  (date.getSeconds()<10) ?  "0"+date.getSeconds()    : date.getSeconds());
			format = format.replace('ss',  (date.getMilliseconds()<10) ?  "0"+date.getMilliseconds()    : date.getMilliseconds());

			return format;
		};
	}
});
