/**
 * @version $Id: panel.js 28421 2013-04-22 11:48:00Z astarostin $
 * ------------------------------------------------------------------------------
 * caontrol panel for avatar
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

(function(window, undefined){
	"use strict";

	var avatarObj = window.avatarObj;

	$(document).ready(function(){
		addEvents();

		updateStat(avatarObj);

		// update stats on page
		runStatUpdates(60000);

		/*
		fillAvatarList(function(){
		});
		*/
	});

	/**
	 * fill avatar list
	 *
	 * @param callback
	 */
	function fillAvatarList(callback)
	{
		var id = "avatar_list";

		var api = new API();
		$("#" + id).mask();
		api.getObjectList({
			type: "avatar",
			withAttributes: true
		})
		.fail(function(code, message){
			Log.error(message);
		})
		.done(function(response){
			response.list = response.list || [];

			var html = ['<select id="' + id + '">'];
			for (var i = 0; i < response.list.length; i++)
			{
				html.push('<option value="' + response.list[i].obj + '">' + response.list[i].attributes["NAME"] + '</option>');
			}
			html.push('</select>');

			$("#" + id).replaceWith(html.join(''));

			callback();
		})
		.always(function(){
			$("#" + id).unmask();
		});
	}

	/**
	 * add events
	 */
	function addEvents()
	{
		/*
		$("#avatar_list").change(function(){
			updateStat($(this).val());
		});
		*/

		$(".tabs_form").on("click", "input[type='button']", function(){
			var attr = $(this).data("attr");
			var val = $(this).data("value");
			var api = new API();

			var attributes = {};
			attributes[attr] = val;

			var elementToMask = this;

			$(elementToMask).mask();
			api.setAttributes({
				obj: avatarObj,
				attributes: attributes
			})
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				Log.info(__("Command sent"));
			})
			.always(function(){
				$(elementToMask).unmask();
			});
		});
	}

	/**
	 * update stat on page
	 *
	 * @param obj
	 */
	function updateStat(obj)
	{
		var api = new API();

		$("#recording").mask();
		api.getAttributes({
			obj: obj
		})
		.fail(function(code, message){
			Log.error(message);
		})
		.done(function(response){
			var date = new Date();
			var calculatedAttributes = {};

			// Status
			date.setTime(parseInt(response.list["STAT_REASON_TIME"], 10) * 1000);
			var statReasonTime = response.list["STAT_REASON_TIME"] == "" ? "" : date.getHours() + ":" + (date.getMinutes() + 1) + " " + (date.getMonth() + 1) + "/" + date.getDate() + "/" + date.getFullYear();
			calculatedAttributes["STATUS"] = response.list["STAT_STATUS"] + (response.list["STAT_STATUS"] == "ONLINE" ? "" : " (" + response.list["STAT_REASON"] + " " + __("at") + " " + statReasonTime + ")");

			// Data
			var speed = Math.ceil(parseInt(response.list["STAT_SENT_LAST"], 10) / 60) + "/" + Math.ceil(parseInt(response.list["STAT_GENERATED"], 10) / 60) + " " + __("KB/sec");
			calculatedAttributes["DATA"] = response.list["STAT_CHANNEL_STATUS"] + " " + __("at speed") + " " + speed;

			// Power
			var statPowerLowSeconds = response.list["STAT_POWER_LOW_SECONDS"];
			if (response.list["STAT_POWER"] == "LOW" && statPowerLowSeconds != "")
			{
				var STAT_POWER_LOW_SECONDS = parseInt(response.list["STAT_POWER_LOW_SECONDS"], 10);
				if (!isNaN(STAT_POWER_LOW_SECONDS))
				{
					var minute = Math.floor(STAT_POWER_LOW_SECONDS / 60);
					var seconds = STAT_POWER_LOW_SECONDS % 60;
					statPowerLowSeconds = minute + __("min") + (seconds == 0 ? "" : " " + seconds +__("sec"));
				}
			}
			calculatedAttributes["POWER"] = response.list["STAT_POWER"] + (response.list["STAT_POWER"] == "LOW" ? " (" + __("for") + " " + statPowerLowSeconds + ")" : "");

			/*
			Status STAT_STATUS (STAT_REASON from STAT_REASON_TIME)
			Data STAT_CHANNEL_STATUS at speed SPEED
			Power STAT_POWER (from STAT_POWER_LOW_SECONDS)
			*/

			$(".tabs_form input[data-type='stat']").each(function(){
				var attr = $(this).data("attr");
				var val = "";

				if (calculatedAttributes[attr])
				{
					val = calculatedAttributes[attr];
				} else {
					val = response.list[attr];
				}

				$(this).val(val);
			});
		})
		.always(function(){
			$("#recording").unmask();
		});
	}

	/**
	 * update stats on page every interval ms
	 *
	 * @param interval ms, update interval
	 */
	function runStatUpdates(interval)
	{
		setTimeout(function(){
			updateStat(avatarObj);
			runStatUpdates(interval);
		}, interval);
	}
})(window);
