var auditObj = {
    api: new API(),
    pagesize: 25,
    pagenum: 0,
    total: 0,
    countRows: true,

    from: ((new Date()).getTime()) - 24 * 60 * 60 * 1000,
    to: ((new Date()).getTime()),
    categories: null,
    msgFilter: null,
    userid: null,
    objid: null,
    dateFormat: null,
    allCategories: [],
    allRecords: [],
    filterCallTimer: null,
	filterHidden: false,

    /**
     * Create audit GUI
     */
    create: function(jqContainer, dateFormat, pagesize, hideFilters) {
        var deferred = $.Deferred();

        var filtersCSS = "block";
        if(hideFilters){
			this.filterHidden = true;
            filtersCSS = "none";
        }
        var gui = '<div id="main_block" style="padding: 10px;">' +
                '<div style="clear: both; display:' + filtersCSS + '">' +
				'   <div id="audit_categories_set" title="'+__("Set audit categories")+'" style="display:none"><p id="audit_categories_content"></p></div>' +
                '	<table id="audit_filters">' +
                '		<tr>' +
                '			<td>' + __("Start of interval") + ':</td>' +
                '			<td>' +
                '               <input type="text" name="audit_startTS_picker" id="audit_startTS_picker" value="" size="17"/>' +
                '           </td>' +
                '			<td><span id="audit_category_start">&nbsp;</span>' + __("Category") + ':</td>' +
                '			<td>' +
                '				<input type="text" id="audit_category" value="' + __("All") + '" disabled="disabled" style="width:150px"/>' +
                '               <input type="button" id="audit_category_change_set"  value="[...]" onclick="auditObj.showCategoriesSet()">' +
                '			</td>' +
                '		</tr>' +
                '		<tr>' +
                '			<td>' + __("End of interval") + ':</td>' +
                '			<td>' +
                '               <input type="text" name="audit_endTS_picker" id="audit_endTS_picker" value="" size="17" />' +
                '           </td>' +
                '			<td>&nbsp;' + __("User") + ':</td>' +
                '			<td>' +
                '				<select class="dropmenu" size="1" name="user" id="audit_user" onclick="auditObj.initiateFilter()" style="width:150px">' +
                '					<option value="All" selected>' + __("All") + '</option>' +
                '				</select>' +
                '			</td>' +
                '		</tr>' +
                '		<tr>' +
                '			<td><!--' + __("Action filter") + ':--></td>' +
                '			<td>' +
                '               <input class="textfield" type="text" name="audit_filter" id="audit_filter" size="17" value="" onkeyup="auditObj.pagenum=0;auditObj.initiateFilter()" style="display:none"/>' +
                '           </td>' +
                '			<td>&nbsp;' + __("Device") + ':</td>' +
                '			<td>' +
                '				<select class="dropmenu" size="1" name="device" id="audit_device" onclick="auditObj.initiateFilter()" style="width:150px">' +
                '					<option value="All" selected>' + __("All") + '</option>' +
                '				</select>' +
				'               <input type="button" value="' + __("Refresh audit") + '" onclick="auditObj.refresh()" style="float:both">' +
                '               <img id="audit_loading" src="/sdi/audit/img/ajax-loader.gif" style="display:none;float:right" />' +
                '			</td>' +
                '		</tr>' +
                '	</table>' +
                '</div>' +

				'<div id="audit_categories_content" style="display:none"><input id="show_user_activity" type="checkbox" checked onclick="auditObj.applyFilter()"/>&nbsp;'+__("Show user activity")+'</div>' +

                '<div id="audit_content" style="clear: both; display:block; padding:2px">' +
                '</div>' +
                '<div id="audit_pages" style="clear: both"></div>' +
                '</div>';

        jqContainer.html(jqContainer.html() + gui);

        this.dateFormat = dateFormat;

        if(pagesize){
            this.pagesize = pagesize;
        }
        else{
            var h_diff = 170;
            if(hideFilters){
                h_diff = 50;
            }
            this.pagesize = parseInt((document.documentElement.clientHeight - h_diff) / 20);
        }

        if (!hideFilters) {
            var pickerDateFormat = this.dateFormat.toLowerCase();
            //'yy-mm-dd'
            if (pickerDateFormat.search("yyyy") != -1) {
                pickerDateFormat = pickerDateFormat.replace(/yyyy/g, "yy")
            }
            else if (pickerDateFormat.search("yy") != -1) {
                pickerDateFormat = pickerDateFormat.replace(/yy/g, "y")
            }

            $("#audit_startTS_picker").datetimepicker({
                dateFormat: pickerDateFormat,
                onSelect: function(dateText, inst) {
                    auditObj.from = $.datepicker.formatDate('@', $(this).datepicker('getDate'));
                    auditObj.initiateFilter()
                }
            }).datetimepicker("setDate", (new Date(auditObj.from)));
            $("#audit_endTS_picker").datetimepicker({
                dateFormat: pickerDateFormat ,
                onSelect: function(dateText, inst) {
                    auditObj.to = $.datepicker.formatDate('@', $(this).datepicker('getDate'));
                    auditObj.initiateFilter()
                }
            }).datetimepicker("setDate", (new Date(auditObj.to)));
        }

        $.when(
            this.fillUsers(),
            this.fillCategories(),
            this.fillDevices()
        )
            .fail(function(){
                deferred.reject();
            })
            .done(function(){
                deferred.resolve();
            });

        return deferred.promise();
    },

	refresh: function(){
		if(!this.filterHidden){
			$("#audit_endTS_picker").datetimepicker("setDate", (new Date((new Date()).getTime())));
			auditObj.to = $.datepicker.formatDate('@', $("#audit_endTS_picker").datepicker('getDate'));
		}

		this.pagenum = 0;

		var currentDevice = $("#audit_device").val();
		var currentUser = $("#audit_user").val();

        var self = this;

        $.when(
            this.fillDevices(),
            this.fillUsers()
        )
            .done(function(){
                $("#audit_device").val(currentDevice);
             	$("#audit_user").val(currentUser);

                self.applyFilter();
            });
	},

    showCategoriesSet: function() {
		$("#audit_categories_set").dialog({
			height: 350,
			width: 'auto',
			resizable: false,
			draggable: false,
			buttons: {
				"Select all": function() { auditObj.selectAllCategories(true); },
				"Deselect all": function() { auditObj.selectAllCategories(false); },
				"OK": function() { $(this).dialog("close"); }
			}
		});
    },

    onCategoriesSetChange: function(categoryId, checked) {
        var selCategoryName = "";
        var checkedCounter = 0;
        for (var i = 0; i < this.allCategories.length; i++) {
            // select/deselect all child categories
            if (this.allCategories[i].category == categoryId && this.allCategories[i].parent == null) {
                for (var j = 0; j < this.allCategories.length; j++) {
                    if (this.allCategories[j].parent == categoryId) {
                        if (checked) {
                            $("#audit_category_" + j).prop("checked", true);
                        }
                        else {
                            $("#audit_category_" + j).prop("checked", false);
                        }
                    }
                }
            }

            // select/deselect parent category
            if (this.allCategories[i].category == categoryId && this.allCategories[i].parent != null) {
                for (var j = 0; j < this.allCategories.length; j++) {
                    if (this.allCategories[j].category == this.allCategories[i].parent) {
                        $("#audit_category_" + j).prop("checked", false);
                    }
                }
            }

            if ($("#audit_category_" + i).prop("checked")) {
                checkedCounter++;
                selCategoryName = this.allCategories[i].name;
            }
        }

        if (checkedCounter == this.allCategories.length) {
            selCategoryName = __("All")
        }
        else if (checkedCounter != 1) {
            selCategoryName = __("Several items")
        }

        $("#audit_category").val(selCategoryName);

        this.initiateFilter();
    },

    selectAllCategories: function(bSelect) {
        for (var i = 0; i < this.allCategories.length; i++) {
    	    if (bSelect) {
        	    $("#audit_category_" + i).prop("checked", true);
            }
            else {
        	    $("#audit_category_" + i).prop("checked", false);
            }
        }
        $("#audit_category").val(bSelect ? __("All") : __("None"));
        this.initiateFilter();
    },

	showUserActivity: function(show, enable){
		if(enable){
			$("#show_user_activity").prop("checked", true);
		}
		else{
			$("#show_user_activity").prop("checked", false);
		}

		if(show){
			$("#audit_categories_content").show();
		}
		else{
			$("#audit_categories_content").hide();
		}
	},

    /**
     * Get audit records
     */
    callGetAuditRecords: function() {
        $("#audit_loading").css("display", "block");

        var req_data = {};
        if (this.from != null) {
            req_data['from'] = Math.floor(this.from / 1000);
        }
        if (this.to != null) {
            req_data['to'] = Math.floor(this.to / 1000);
        }
        if (this.categories != null) {
            req_data['categories'] = JSON.stringify(this.categories);
        }
        if (this.msgFilter != null) {
            req_data['msgFilter'] = this.msgFilter;
        }
        if (this.userid != null) {
            req_data['userid'] = this.userid;
        }
        if (this.objid != null) {
            req_data['objid'] = this.objid;
        }
        if (this.pagesize != null) {
            req_data['pagesize'] = this.pagesize;
        }
        if (this.pagenum != null) {
            req_data['pagenum'] = this.pagenum;
        }
        if (this.countRows != null) {
            req_data['countRows'] = this.countRows;
        }

        req_data['includeDigest'] = true;

        this.api.getAuditRecords(req_data)
            .fail(function(code, message){
                alert(__("Audit error: ") + message);
            })
            .done(function(data){
                auditObj.total = data.list.total;
                if (data.list.data != undefined) {
                    auditObj.allRecords = data.list.data;
                }
                else {
                    auditObj.allRecords = [];
                }
                auditObj.setPages();
                auditObj.fillAuditRecords();
            })
            .always(function(){
                $("#audit_loading").css("display", "none");
            });
    },

    /**
     set audit records in container
     */
    fillAuditRecords: function() {
        var data = auditObj.allRecords;
        var parent = $("#audit_content");

        parent.empty().hide();

        if (data.length > 0) {
            var table = '<table id="audit_table" class="tablesorter"><thead>' +
                    '<tr>' +
                    '<th style="width:10px">&nbsp;</th>' +
                    '<th style="width:145px">' + __("Date Time") + '</th>' +
                    '<th style="width:50px">' + __("User") + '</th>' +
                    '<th style="width:auto">' + __("Action") + '</th>' +
                    '</tr>' +
                    '</thead>' +
                    '<tbody>';

            for (var rowId = 0; rowId < data.length; rowId++) {
                var record = data[rowId];
                var logDateFormat = this.ts2date(record['date'] * 1000);
				var categoryArrNum = 0;
                for (var i = 0; i < this.allCategories.length; i++) {
                    if (this.allCategories[i].category == record['category']) {
                        var logAction = this.allCategories[i].digest;
						categoryArrNum = i;
                        if(logAction == null){
                            logAction = __("No digest for category ")  + this.allCategories[i].category;
                        }
                    }
                }

                if (!$.isEmptyObject(record['parameters'][0])) {
                    for (var i = 0; i < record['parameters'][0].length; i++) {
                        logAction = logAction.replace("%" + (i + 1), record['parameters'][0][i])
                    }
                }

                if(record['otype'] == "D" || record['otype'] == "X" || record['otype'] == "T"){
					if (record['udid'] == ''){
						logAction = '#'+record['objid']+' ' + record['objname'] + ': ' + __(logAction)
					}else{
						logAction = '['+record['udid']+'] ' + record['objname'] + ': ' + __(logAction)
					}
                }
				else if(this.allCategories[categoryArrNum].parent == 16){
					logAction = '[Event #'+record['objid']+']: ' + __(logAction)
				}

                var evenOdd = "odd";
                if (evenOdd == "even")
                    evenOdd = "odd";
                else
                    evenOdd = "even";

                var icon = "/TibcoGI/JSXAPPS/mx/assets/eventlog/plus.gif";
                if(this.allRecords[rowId]['parameters'][1] === undefined)
                    icon = "/sdi/audit/img/empty.png";

                table += '<tr class="' + evenOdd + '" onclick="auditObj.showRowInfo(this, ' + rowId + ')">' +

                        '<td><img id="audit_open_' + rowId + '" style="width:9px;height:9px;border:0;" src="' + icon + '" /></td>' +
                        '<td>' + logDateFormat + '</td>' +
                        '<td>' + (record['uname']!=null?record['uname']:__("System")) + '</td>' +
                        '<td>' + logAction + '</td>' +
                        '</tr>';
            }

            table += '</tbody></table>';

            parent.html(table);

            $("#audit_table").tablesorter({headers:{0:{ sorter: false}, 1:{ sorter: false}, 2:{ sorter: false}, 3:{ sorter: false}}});

            parent.show();
        }
        else {
            parent.html('<br /><div>' + __("No records found") + '</div>').show();
        }
    },

	ts2date: function(ts){
		var date = new Date(ts);
        var logDateFormat = this.dateFormat + " " + "HH:II:SS";

        logDateFormat = logDateFormat.replace('YYYY', date.getFullYear());
        logDateFormat = logDateFormat.replace('YY', String(date.getFullYear()).substr(2));
        logDateFormat = logDateFormat.replace('MM', (date.getMonth() + 1 < 10) ? "0" + (date.getMonth() + 1) : date.getMonth() + 1);
        logDateFormat = logDateFormat.replace('DD', (date.getDate() < 10) ? "0" + date.getDate() : date.getDate());
        logDateFormat = logDateFormat.replace('HH', (date.getHours() < 10) ? "0" + date.getHours() : date.getHours());
        logDateFormat = logDateFormat.replace('II', (date.getMinutes() < 10) ? "0" + date.getMinutes() : date.getMinutes());
        logDateFormat = logDateFormat.replace('SS', (date.getSeconds() < 10) ? "0" + date.getSeconds() : date.getSeconds());
		return logDateFormat;
	},

    showRowInfo: function(element, rowId) {
		// close if clicked opened row
        if ((element.nextSibling && element.nextSibling.id == "detailed_row") || element.id == "detailed_row") {
            $("#detailed_row").detach();
            $("#audit_open_" + rowId).attr("src", "/TibcoGI/JSXAPPS/mx/assets/eventlog/plus.gif");
            return;
        }

        if(this.allRecords[rowId]['parameters'][1] === undefined || this.allRecords[rowId]['parameters'][1].length == 0){
            return;
        }

        var detailsText = __("No additional information provided.");
        var defaultTemplateAC = __("Attribute %1 changed from %2 to %3");
            detailsText = "";
            for (var i = 0; i < this.allRecords[rowId]['parameters'][1].length; i++) {
                if (this.allRecords[rowId]['parameters'][1][i][0] == "@AV") { // attribute value
					var value = this.allRecords[rowId]['parameters'][1][i][2];
					if(this.allRecords[rowId]['parameters'][1][i][1].toUpperCase() == "FROM" || this.allRecords[rowId]['parameters'][1][i][1].toUpperCase() == "TO"){
						value = this.ts2date(this.allRecords[rowId]['parameters'][1][i][2]*1000);
					}
                    detailsText += this.allRecords[rowId]['parameters'][1][i][1] + " = " + value + "<br />";
                }
                else if (this.allRecords[rowId]['parameters'][1][i][0] == "@AC") { // attribute change
                    var templateAC = defaultTemplateAC;
                    templateAC = templateAC.replace("%1", this.allRecords[rowId]['parameters'][1][i][1]);
                    templateAC = templateAC.replace("%2", '<span class="attr-old-value">' + this.allRecords[rowId]['parameters'][1][i][2] + '</span>');
                    templateAC = templateAC.replace("%3", '<span class="attr-new-value">' + this.allRecords[rowId]['parameters'][1][i][3] + '</span>');
                    detailsText += templateAC + "<br />"
                }
                else if (this.allRecords[rowId]['parameters'][1][i][0] == "@T") { // text only
                    detailsText += this.allRecords[rowId]['parameters'][1][i][1] + "<br />"
                }
            }

		// close details if exists
		if($("#detailed_row")){
			$("#audit_open_" + $("#detailed_row").attr("rowid")).attr("src", "/TibcoGI/JSXAPPS/mx/assets/eventlog/plus.gif");
			$("#detailed_row").detach();
		}

        var details = '<tr id="detailed_row" rowid="' + rowId + '" class="' + element.className + '" onclick="auditObj.showRowInfo(this, ' + rowId + ')">' +
                '<td colspan="4" style="padding-left:230px">' + detailsText + '</td>' +
                '</tr>';
        $("#audit_open_" + rowId).attr("src", "/TibcoGI/JSXAPPS/mx/assets/eventlog/minus.gif");
        $(element).after(details);
    },

    callAddAuditRecord: function(category, objid, params) {
        var req_data = {};
        if (category != null) {
            req_data['category'] = category;
        }
        if (objid != null) {
            req_data['objid'] = objid;
        }
        if (params != null) {
            req_data['paramsJSON'] = JSON.stringify(params);
        }

        this.api.addAuditRecord(req_data)
            .fail(function(code, message){
                alert(__("Audit error: ") + message);
            })
            .done(function(data){
            });
    },

    /**
     set categories
     */
    fillCategories: function() {
        var deferred = $.Deferred();

        this.api.getAuditCategories()
            .fail(function(code, message){
                alert(__("Error on user get: ") + message);

                deferred.reject();
            })
            .done(function(json){
                auditObj.allCategories = json.list.categories;
                var parentCategories = [];
                var categories = '<br />';
                for (var i = 0; i < json.list.categories.length; i++) {
                    if (json.list.categories[i].parent == null) {
                        parentCategories.push(i);
                    }
                }

                for (var j = 0; j < parentCategories.length; j++) {
                    var parentCategoriesHTML = '<input id="audit_category_' + parentCategories[j] + '" type="checkbox" checked value="' + json.list.categories[parentCategories[j]].category + '" onclick="auditObj.onCategoriesSetChange(' + json.list.categories[parentCategories[j]].category + ', this.checked)" />&nbsp;' + __(json.list.categories[parentCategories[j]].name) + '<br />';
                    for (var i = 0; i < json.list.categories.length; i++) {
                        if(json.list.categories[parentCategories[j]].category == json.list.categories[i].parent){
                            parentCategoriesHTML+= '&nbsp;&nbsp;&nbsp;<input id="audit_category_' + i + '" type="checkbox" checked value="' + json.list.categories[i].category + '" onclick="auditObj.pagenum=0;auditObj.onCategoriesSetChange(' + json.list.categories[i].category + ', this.checked)" />&nbsp;' + __(json.list.categories[i].name) + '<br />';
                        }
                    }
                    categories += parentCategoriesHTML;
                }

                $("#audit_categories_content").html(categories);

                deferred.resolve();
            });

        return deferred.promise();
    },

    /**
     set users
     */
    fillUsers: function() {
        var deferred = $.Deferred();

        var self = this;

        this.api.getObjectList({'type': 'user', 'isAll': true, 'withAttributes': true})
            .fail(function(code, message){
                alert(__("Error on user get: ") + message);

                deferred.reject();
            })
            .done(function(json){
                var users = '<option value="All" selected>' + __("All") + '</option>';
                for (var i = 0; i < json.list.length; i++) {
                    users += '<option value="' + json.list[i].obj + '" title="' + json.list[i].description + '">' + json.list[i].name + '</option>';
                }

                self.api.getDeletedObjectList({'otype': 'U'})
                    .fail(function(code, message){
						deferred.resolve();
                    })
                    .done(function(json2){
                        for (var i = 0; i < json2.list.length; i++) {
                            users += '<option value="' + json2.list[i].obj + '" title="' + json2.list[i].description + '" style="color:gray;">' + json2.list[i].name + '</option>';
                        }

                        $("#audit_user").html(users);

                        deferred.resolve();
                    });
            });

        return deferred.promise();
    },

    /**
     set devices
     */
    fillDevices: function() {
        var deferred = $.Deferred();

        var self = this;

        this.api.getObjectList({'type': 'camera', 'isAll': true, 'withAttributes': true})
            .fail(function(code, message){
                alert(__("Error on devices get: ") + message);

                deferred.reject();
            })
            .done(function(json){
                var devs = '<option value="All" selected>' + __("All") + '</option>';
                for (var i = 0; i < json.list.length; i++) {
                    devs += '<option value="' + json.list[i].obj + '">' + json.list[i].name + '</option>';
                }

                self.api.getDeletedObjectList({'otype': 'D', 'subtype': 'C'})
                    .fail(function(code, message){
                        deferred.resolve();
                    })
                    .done(function(json2){
                        for (var i = 0; i < json2.list.length; i++) {
                            devs += '<option value="' + json2.list[i].obj + '" style="color:gray;">' + json2.list[i].name + '</option>';
                        }

                        $("#audit_device").html(devs);

                        deferred.resolve();
                    });
            });

        return deferred.promise();
    },

    /**
     initiate filter
     */
    initiateFilter: function() {
        clearTimeout(this.filterCallTimer);
        this.filterCallTimer = window.setTimeout(function() {
            auditObj.applyFilter();
        }, 1500)
    },

    /**
     apply filter
     */
    applyFilter: function() {
        if ($("#audit_prev")) {
            $("#audit_prev").prop("disabled", true);
            $("#audit_next").prop("disabled", true);
        }

		var showTheUserActivity = $("#show_user_activity").prop("checked");
		if ($("#audit_category").val() != "All" || !showTheUserActivity) {
			var categories = [];
			for (var i = 0; i < this.allCategories.length; i++) {
				if ($("#audit_category_" + i).prop("checked")) {
					if(showTheUserActivity || this.allCategories[i].parent == 28){
						categories.push(this.allCategories[i].category);
					}
				}
			}
			if(categories.length == 0){
				$("#audit_content").html('<br /><div>' + __("No records found") + '</div>').show();
				return;
			}
			this.categories = categories;
		}
		else {
			this.categories = null;
		}

		if(!this.filterHidden){
			if ($("#audit_action").val() != "") {
				this.msgFilter = $("#audit_filter").val();
			}
			else {
				this.msgFilter = null;
			}

			if ($("#audit_user").val() != "All") {
				this.userid = $("#audit_user").val();
			}
			else {
				this.userid = null;
			}

			if ($("#audit_device").val() != "All") {
				this.objid = $("#audit_device").val();
			}
			else {
				this.objid = null;
			}
		}

        this.callGetAuditRecords();
    },

    /**
     set pages with current filter
     */
    setPages: function() {
        if (this.allRecords.length > 0) {
            var pagesAmount = Math.ceil(this.total / this.pagesize);
            var pageNumber = this.pagenum + 1;

            var prev_disabled = "";
            var next_disabled = "";

            if (pagesAmount == 1) {
                prev_disabled = 'disabled="disabled"';
                next_disabled = 'disabled="disabled"';
            }
            else if (pageNumber == 1) {
                prev_disabled = 'disabled="disabled"';
            }
            else if (pageNumber == pagesAmount) {
                next_disabled = 'disabled="disabled"';
            }

            var pages = '<div style="width:100%;position:relative">' +
                    __("Page: ") +
                    '<input type="text" id="audit_current" size="3" value="' + pageNumber + '" onkeyup="auditObj.onManualPageChange(this.value)" />' +
                    __(" from ") + pagesAmount + '&nbsp;&nbsp;&nbsp;' +
                    '<input type="button" id="audit_prev" value="' + __("Prev") + '" onclick="auditObj.prevPage()" title="' + __("Previous page") + '" ' + prev_disabled + '/>' +
                    '<input type="button" id="audit_next" value="' + __("Next") + '" onclick="auditObj.nextPage()" title="' + __("Next page") + '" ' + next_disabled + '/>' +
                    '</div>';
            $("#audit_pages").html(pages);
        }
    },

    onManualPageChange: function(newValue) {
        var pagesAmount = Math.ceil(this.total / this.pagesize);
        if (newValue != parseInt(newValue, 10) || newValue <= 0) {
            $("#audit_current").val(1);
            this.pagenum = 0;
        }
        else if (newValue > pagesAmount) {
            $("#audit_current").val(pagesAmount);
            this.pagenum = pagesAmount - 1;
        }
        else {
            this.pagenum = newValue - 1;
        }

        this.initiateFilter();
    },

    /**
     goto next page
     */
    nextPage: function() {
        if (this.pagenum + 1 <= parseInt(this.total / this.pagesize)) {
            this.pagenum += 1;
            this.applyFilter();
        }
        else {
            alert("No more pages");
        }
    },

    /**
     goto prev page
     */
    prevPage: function() {
        if (this.pagenum - 1 >= 0) {
            this.pagenum -= 1;
            this.applyFilter();
        }
        else {
            alert("No prev pages");
        }
    }
};
