<?php
/**
 * @version $Id: audit_general.php 22553 2011-04-28 14:11:34Z sabaev $
 * ------------------------------------------------------------------------------
 * General audit interface
 * ------------------------------------------------------------------------------
 * @author Sergey Abaev
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$identity = Identity::getAttributes();

?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Audit log');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link rel="stylesheet" type="text/css" href="/sdi/calendar/jCal.css"/>
	<link rel="stylesheet" type="text/css" href="/sdi/lib/css/smoothness/jquery-ui-1.10.4.css"/>
	<link rel="stylesheet" type="text/css" href="/sdi/lib/css/tablesorter/style.css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery-ui.min.js"></script>

	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>

	<script src="/sdi/lib/js/jquery-ui-timepicker-addon.js"></script>
	<script src="/sdi/lib/js/jquery.tablesorter.min.js"></script>

    <script src="/sdi/lib/js/api.js"></script>

	<script src="js/audit_lib.js"></script>
    <script>
        $(document).ready(function() {
            auditObj.create($("div .tabs_content"), '<? echo $identity['NLS_LONG_DATE_FORMAT']; ?>')
                .done(function(){
                    auditObj.initiateFilter();
                });
        });
    </script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("Audit log"); ?>
				</div>
			</div>
		</div>
		<div class="tabs_content"></div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
