(function(){
	"use strict";

	var analytics = window.analytics;

	/**
	 * Implements scheduler for analytics zones
	 */
	analytics.scheduler = {
		data: {},
		postures: [],
		postures1: [],
		posturesSelector: null,
		vae_module: '',
		UI_inited:false,

		init: function(configurator, camAttributes, vae_module) {

			// maybe use general storage for camera attributes

			this.updateCamAttributes(camAttributes);
			this.configurator = configurator;
			this.vae_module = vae_module;

			// Get postures for camera
			var self = this;
			$.when(
				this.getPostures()
			).done(function() {
				//self.initUI();
				$.when(self.getPostures1()).done(function() {self.initUI();	});
			});
		},

		updateCamAttributes: function(camAttributes) {
			this.camAttributes = camAttributes;
			this.camId = camAttributes.OBJID;
		},

		initUI: function() {
			var select = $('#zone_editor select[name="postures"]');
			var html = '', posture;

			for (var i in this.postures) {
				posture = this.postures[i];
				if(posture.DEFAULTFOR == ''){
					var timecards = '';
					for (var j in posture.timecards) {
						timecards += '~~ ' + posture.timecards[j].SUMMARY;
					}
					html += '<option value="' + i + '">' + posture.NAME + timecards + '</option>';
				}
			}
			extendJaoselect();
			select.html(html).jaoselect({placeholder: 'Please select Scheduled States'});
			this.posturesSelector = select.next('.jao_select');

			var self = this;
			$('#zone_editor select[name="state"]').change(function() {
				if (this.value === 'when') {
					self.posturesSelector.show();
					$('#schedule_preview').show();
				} else {
					self.posturesSelector.hide();
					$('#schedule_preview').hide();
				}
			});
			$('#schedule_preview').click(function() {
				// get schedule info
				var html = "";
				for (var i in self.postures) {
					posture = self.postures[i];
					var timecards = '';
					for (var j in posture.timecards) {
						timecards += '<li>' + posture.timecards[j].SUMMARY + "</li>";
					}

					var properties = "";
					for (var k in posture.properties) {
						properties += '<li><b>'+ k +': </b>'+ posture.properties[k] + "</li>";
					}

					html += "<div class='postureinfo'>" + "<div class='posturename'>Scheduled State: <b>" + posture.NAME + "</b></div>";
					if (properties != '') html += "<div class='category'>"+'Properties'+"</div><ul>"+properties+ "</ul>";
					if (timecards != '') html += "<div class='category'>"+'Timecards'+"</div><ul>"+timecards+ "</ul>";
					html += '</div>';
				}
				$('#schedule_info').html(html);
				analytics.scheduler.openModal("#schedule_preview_box", 690, 30);
			});
			$("#schedule_info_close").click(function(){
				$('#schedule_preview_box').hide();
				$('#mask').hide();
			});
			this.UI_inited = true;
		},

		save: function() {
			var attributes = {};
			var key = 'VAE_' + this.vae_module.toUpperCase() + '_SCHEDULER';
			attributes[key] = this.serialize();
			return $.post('/api/call.php', {
				'function': 'setAttributes',
				'obj': this.camId,
				'attributes': JSON.stringify(attributes)
			});
		},

		serialize: function() {
			var result = [], i, objects = this.configurator.objects;

			for (i = 0; i < objects.length; i++) {

				var data = {
					active: objects[i].active,
					state: objects[i].state,
					name: objects[i].name,
					postures: objects[i].postures || []
				};

				if (objects[i].state == 'active') {
					data.active = true;
				}
				if (objects[i].state == 'nonactive') {
					data.active = false;
				}

				result.push(data);
			}
			return result;
		},

		unserialize: function() {
			var schedule = $.parseJSON(this.camAttributes['VAE_' + this.vae_module.toUpperCase() + '_SCHEDULER']) || [],
				objects = this.configurator.objects,
				key, i;

			for (i=0; i<schedule.length; i++) {
				for (key in schedule[i]) {
					objects[i][key] = schedule[i][key];
				}
			}
		},

		openModal: function(id, x, y)
		{
			var maskHeight = $(document).height();
			var maskWidth = $(window).width();

			$('#mask').css({'width':maskWidth,'height':maskHeight});

			$('#mask').fadeTo("fast",0.4);

			var winH = $(window).height();
			var winW = $(window).width();

			$(id).css('top',  y);
			$(id).css('left', x);

			$(id).fadeIn(100);
		},

		getPostures: function() {
			var self = this;

		return this.camAttributes.SCHEDULEID ?
			$.ajax({
				url: "/api/call.php",
				dataType: "json",
				async: true,
				cache: false,
				data: {'function': 'getPosturesInfo', scheduleid: this.camAttributes.SCHEDULEID, useDefault: true, allPostures: true, actualOnly: true},
				success: function(res_data)
				{
					self.postures = res_data.list;
				}
			}):
			[];
	},
	
		getPostures1: function() {
			var self = this;
			var posturearr = [];
			for (var i in self.postures){
				posturearr.push(i);

			}
			return this.camAttributes.SCHEDULEID ?
				$.ajax({
					url: "/api/call.php",
					dataType: "json",
					async: true,
					cache: false,
					data: {'function': 'getTemplates', objList: JSON.stringify(posturearr)},
					success: function(res_data)
					{
						if (typeof(res_data.template)!='undefined'){
							analytics.scheduler.postures1 = res_data.template;
							for (var i in res_data.template){
								if (typeof(analytics.scheduler.postures[i])!='undefined'){
									analytics.scheduler.postures[i].properties = [];
									if (typeof(res_data.template[i].attributes)!='undefined'){
										for (var j in res_data.template[i].attributes){
											var regexp = /^PROPERTY_.+$/i;
											if (res_data.template[i].attributes[j].VALUE != '' && regexp.test(j)){
												var label = res_data.template[i].attributes[j].LABEL
												var val = '';
												if (res_data.template[i].attributes[j].TYPE == "dropmenu" && typeof(res_data.template[i].attributes[j].LIST) != 'undefined'){
													for(var k in res_data.template[i].attributes[j].LIST){
														if (res_data.template[i].attributes[j].LIST[k].value ==  res_data.template[i].attributes[j].VALUE){
															val = res_data.template[i].attributes[j].LIST[k].label;
														}
													}
												}
												analytics.scheduler.postures[i].properties[label] = val;
											}
										}
									}
								}
							}
						}
					}
				}):
				[];
		}
	};

	function extendJaoselect(){
		$.extend(true, $.fn.jaoselect, {htmlBuilder:{
			renderOption: function(option){
				var rows = option.text().split('~~');
				var title = rows[0];
				var divs = '';
				for (var i=1; i<rows.length; i++){
					divs += "<li>"+rows[i]+"</li>";
				}
				if (divs !== ''){
					divs = "<ul>" + divs + "</ul>";
				}

				var attr = {
						type: this.settings.multiple? 'checkbox' : 'radio',
						value: option.val(),
						name: 'jaoselect_' + this.settings.name,
						disabled: option.prop('disabled') ? 'disabled' : '',
						'class': 'jao_option'
					},
					labelAttr = $.extend({
						'data-title': title + divs, //option.text(),
						'data-cls': option.attr('class') || '',
						'data-value': option.val(),
						'class': option.prop('disabled') ? 'disabled' : ''
					}, this.dataToAttributes(option));

				return '<label ' + this.renderAttributes(labelAttr) + '>' +
							'<input ' + this.renderAttributes(attr) + ' />' + this.renderLabel(option) +
						'</label>';
			},
			renderLabel: function(option) {
				var className = option.attr('class') ? 'class="' + option.attr('class') + '"' : '',
					image = option.data('image') ? '<img src="' + option.data('image') + '" /> ' : '';

				var rows = option.text().split('~~');
				var divs = '';
				for (var i=1; i<rows.length; i++){
					divs += "<li>"+rows[i]+"</li>";
				}
				if (divs !== ''){
					divs = "<ul>" + divs + "</ul>";
				}
				return image + '<span ' + className + '>' + rows[0] + '</span>' + divs;
			}
		}});
	}

})();
