(function(window){
	"use strict";

	/**
	 * @type {string}
	 */
	var dateFormat = window.dateFormat;
	/**
	 * @type {number}
	 */
	var obj = window.obj;

	$(document).ready(function(){
		getLogList(obj);
	});

	function getLogList(obj)
	{
		var req_data = {};
		req_data['function'] = 'getCameraLog';
		req_data['obj'] = obj;

		$.ajax({
			url:      "/api/call.php",
			async:    true,
			cache:    false,
			dataType: 'json',
			data:     req_data,
			success:  function (data)
			{
				if (data.error != '') {
					alert(__("Get log error: ") + data.error);
				}
				else {
					fillList(data.list);
				}
			}
		});
	}

	function fillList(list)
	{
		var data = list;
		var parent = $("#main_log_wrapper");
		parent.empty();

		if (data.length > 0) {
			var table = '<table class="border_table" border="1"  width="100%" cellspacing="0" cellpadding="4" >' +
					'<tr bgcolor="#999999" style="background:#999999;">' +
					'	<th width=150>' + __("Date Time") + '</th>' +
					'	<th>' + __("Err Type") + '</th>' +
					'	<th>' + __("Note") + '</th>' +
					'</tr>' +
					'<tbody>';

			for (var rowId = 0; rowId < data.length; rowId++) {
				var record = data[rowId];
				var logDateFormat = ts2date(record['TS'] * 1000);
				var tr = '<tr>';
				switch (record['ERRTYPE']) {
					case 'INFO':
						tr = '<tr style="background:#EEEEEE;">';
						break;
					case 'DEBUG':
						tr = '<tr style="background:#EEEEEE;">';
						break;
					case 'ERROR':
						tr = '<tr style="background:#FFAAAA;">';
						break;
					case 'FATAL':
						tr = '<tr style="background:#FFCC88;">';
						break;
					case 'WARN':
						tr = '<tr style="background:#AAAAFF;">';
						break;
					default:
						tr = '<tr style="background:#AAAAff;">';
				}
				table += tr +
						'	<td>' + logDateFormat + '</td>' +
						'	<td>' + record['ERRTYPE'] + '</td>' +
						'	<td>' + record['NOTE'] + '</td>' +
						'</tr>';
			}

			table += '</tbody></table>';

			parent.html(table);
		}
		else {
			parent.html('<br /><div>' + __("No records found") + '</div>');
		}
	}

	function ts2date(ts)
	{
		var date = new Date(ts);
		var logDateFormat = dateFormat + " " + "HH:II:SS";

		logDateFormat = logDateFormat.replace('YYYY', date.getFullYear());
		logDateFormat = logDateFormat.replace('YY', String(date.getFullYear()).substr(2));
		logDateFormat = logDateFormat.replace('MM', (date.getMonth() + 1 < 10) ? "0" + (date.getMonth() + 1) : date.getMonth() + 1);
		logDateFormat = logDateFormat.replace('DD', (date.getDate() < 10) ? "0" + date.getDate() : date.getDate());
		logDateFormat = logDateFormat.replace('HH', (date.getHours() < 10) ? "0" + date.getHours() : date.getHours());
		logDateFormat = logDateFormat.replace('II', (date.getMinutes() < 10) ? "0" + date.getMinutes() : date.getMinutes());
		logDateFormat = logDateFormat.replace('SS', (date.getSeconds() < 10) ? "0" + date.getSeconds() : date.getSeconds());
		return logDateFormat;
	}

})(window);
