/*
# $Id: admincirrus_script.js 33772 2016-02-28 22:32:57Z astarostin $
#------------------------------------------------------------------------------
# Admin Cirrus
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by: Abaev Sergey
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
/*
	<script src="/sdi/lib/js/sha1.js"></script>
	<script src="/ptz/js/hwj.js"></script>
	<script src="/sdi/lib/js/api.js"></script>
* */

require(["jquery", "jquery.mask", "jquery-ajaxfileupload", "jquery-ui", "log", "i18n", "api"], function(){
	"use strict";

	var API = require("api");

	var current_mode = "cameras";
	var textfield_and_regexp_list_for_check = {};
	var textfield_for_camera_exists_check = {};
	// attributes list of all cameras present on the screen
	var objectAttributes = {};
	var deletedCameras = {};
	var selectedCameras = {};

	//is user informed about license replacement
	var isUserLicenseInformed = false;

	//is user skiped portal registration
	var isUserLicenseSkip = false;
	var xhr = null;
	var isRunFileUpload = false;
	var noCamSelected = false;

	window.SKM_BRAND = window.SKM_BRAND || 'STRATUS';
	window.isMassObjectEditor = window.isMassObjectEditor || false;
	window.setid = window.setid || null;
	var stop_exists = {stop:false};
	var templateattributes = {};
	var CRM_REGISTRATION_URL = "";

	var syncAPI = new API(false);
	var api = new API();

	//////////
	$(document).ready(
		function()
		{
			api.getIdentityAttributes()
				.done(function(response){
					var attributes = response['list'];

					if (attributes.CRM_REGISTRATION_URL)
					{
						CRM_REGISTRATION_URL = attributes.CRM_REGISTRATION_URL;
					}

					init();
					addEvents();

					$(".editor_container").addClass("editor_container_" + readCookie("language"));

					if (window.mode == "addObject")
					{
						onAddCameraClick();
					} else
					if (window.mode == "licensing")
					{
						$("#systemsettingslist div[data-setting='licensing']").trigger("click");
					}
				});
		}
	);

	function goToMatrix(obj)
	{
		obj = obj || null;
		var backhrefout = window.backhref || "";
		var hash = "";
		if (backhrefout != '') hash = backhrefout;
		if (obj)
		{	if (hash != '')
				hash += "/camera_" + obj;
			else
				hash = "camera_" + obj;
		}
		top.location.hash = hash;
	}

	function showVCAdetails()
	{
		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: false,
			data: { 'function' : 'getVCADetails' },
			cache: false,
			beforeSend: function()
			{
				$("#wizard").mask();
			},
			complete: function()
			{
				$("#wizard").unmask();
			},
			success: function(data)
			{
				if (checkSessionExpired(data)) return false;
				if (data == ""){
					// list is empty
				}
				else {
					if (data["error"] == ""){
						var list = data["list"];
						if (list.length > 0){
							var nodeList_html = '<div id="VCA_details">';
							for (var i = 0; i < list.length; i++){

								if(list[i]["vca_version"] == undefined){
									list[i]["vca_version"] = "N/A";
								}
								nodeList_html += '<br />Version: ' + list[i]["vca_version"] + '<br />';

								var node_id = list[i]["location"];
								var channels = "N/A";
								if(list[i]["vca_channels"]){
									channels = __("active") + " " + list[i]["vca_active"] + __(" from ") + list[i]["vca_channels"] + " " + __("channels");
								}

								nodeList_html += __("Node") + " " + node_id + ": " + channels + "<br>";
							}

							$("#VCA_details").remove();
							$("#VCA_details_cell").append(nodeList_html + "</div>");
						}
					}
				}
			}
		});
	}

	function showOV6details()
	{
		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			data: { 'function' : 'getOV6Details' },
			cache: false,
			beforeSend: function()
			{
				$("#wizard").mask();
			},
			complete: function()
			{
				$("#wizard").unmask();
			},
			success: function(data)
			{
				if (checkSessionExpired(data)) return false;
				if (data == ""){
					// list is empty
				}
				else {
					if (data["error"] == ""){
						var nodeCamerasData = data["list"];
						var LICENSE_OV6_KEYPACK = data["LICENSE_OV6_KEYPACK"];

						/*
							show cameras table
						*/
						var ov6_html = '<div id="OV6_details">';
						for(var node in LICENSE_OV6_KEYPACK) {
							var curNode = LICENSE_OV6_KEYPACK[node];

							var curNodeName = curNode.node;
							var curNodeCameras = [];
							for (var i = 0; i < nodeCamerasData.length; i++){
								var curNodeCamerasData = nodeCamerasData[i]
								if(curNode.node == curNodeCamerasData.uni){
									curNodeName = curNodeCamerasData.location;
									curNodeCameras =  curNodeCamerasData.cameras;
								}
							}

							var ov6_node_html = "";
							ov6_node_html+= '<br/>' + __ ('Node')+ ' "' + curNodeName + '"<br/>';
							ov6_node_html+= '<table>';

							ov6_node_html+= '<tr>';
							ov6_node_html+= '<td>' + __ ('Cameras')+ '\\' + __ ('Features')+ '</td>';
							for(var t = 0; t < curNode.features.length; t++){
								var color = "";
								var used = 0;
								if (curNode.features[t].hasOwnProperty("busy")) {
									used = curNode.features[t].busy;
								}
								if(used > curNode.features[t].max){
									color = "#FF0000";
								}
								ov6_node_html+= '<td style="text-align:center" nowrap>' + curNode.features[t].name.replace("vnlib_onboard", "") +
									'<br/>(<font color="' + color + '">' + used + ' of ' + curNode.features[t].max + '</font>)</td>';
							}
							ov6_node_html+= '</tr>';

							var ov6_cameras_html = "";
							for (var j = 0; j < curNodeCameras.length; j++){
								var camera = curNodeCameras[j];
								var camera_link = '/sdi/admin/#set_14/camera_' + camera.obj;
								ov6_cameras_html+= '<tr>';
								ov6_cameras_html+= '<td><a href="'+camera_link+'" target="_parent">'+camera.name+'</a></td>';

								for(var n = 0; n < curNode.features.length; n++){
									var featureState = "";
									if(curNode.features[n].hasOwnProperty("ch_ids") && $.inArray(parseInt(camera.obj), curNode.features[n].ch_ids) != -1){
										featureState = '<img style="width:10px;height:10px" src="/TibcoGI/JSXAPPS/mx/images/design1/resources/yes.png">';
									}

									ov6_cameras_html+= '<td style="text-align:center">'+featureState+'</td>';
								}

								ov6_cameras_html+= '</tr>';
							}

							if(curNodeCameras.length == 0){
								ov6_cameras_html+= '<tr><td colspan="20">'+__('No active features')+'</td></tr>';
							}

							ov6_node_html+= ov6_cameras_html;
							ov6_node_html+= '</table>';
							ov6_html+= ov6_node_html;
						}
						ov6_html+= '</div>';
						$("#OV6_details").remove();
						$("#OV6_details_cell").append(ov6_html);
					}
					else{
						alert("OV6 details get error. " + data["error"]);
					}
				}
			}
		});
	}

	function init()
	{
		$("#wizard").slideUp();
		$("#licensing").slideUp();

		fillNodeList();
	}

	function showWizard()
	{
		$("#wizard_step_1").show();
		$("#wizard_step_2").hide();
		$("#wizard input[name='DEVIP']").val('0.0.0.0');
		$("#wizard input[name='DEVICEIP']").val('');
		$("#wizard input[name='USRNAME']").val('');
		$("#wizard input[name='PASSWD']").val('');
		$("#wizard input[name='CAMERAMODEL']").val('');
		$("#wizard input[name='CAMERAFIRMWARE']").val('');
		$("#wizard input[name='NAME']").val('');
		$("#wizard input[name='LOCATION']").val('');

		$("#next_step").data("value", 1);
		$("#next_step").show();

		$("#wizard").show();
	}

	function returnWithAlert(alertString){
		alert(alertString);
		$("#next").prop("disabled", false);
		$("#next_cancel").prop("disabled", false);
		$("#wizard_step_1").show();
	}

	function wizardNextStep()
	{
		$("#next").prop("disabled", true);
		if (xhr) xhr.abort();
		var step = parseInt($("#next_step").data("value"), 10);
		$("#wizard_step_" + step).hide();
		switch (step)
		{
			case 1:
				if ($("#actionType").val() === "import")
				{
					importCameraList();
					return;
				}
				$("#urlrtp").hide();
				if ($("#cameraTypeList").val() === "network")
				{

					if ($("#cameraTypeList").val() === "network")
					{
						var ip = $("#wizard input[name='DEVIP']").val();
						if (ip === "")
						{
							alert( __("Please enter camera IP"));
							$("#next").prop("disabled", false);
							$("#next_cancel").prop("disabled", false);
							$("#wizard_step_" + step).show();
							return;
						}
						var port = "80";
						var found;
						if ((found = /^([^/?#]+):(\d+)$/i.exec(ip)) != null)
						{
							ip = found[1];
							port = found[2];
						}
						else if (/^[^/?#]+$/i.exec(ip) == null)
						{
							alert( __("Camera IP is invalid"));
							$("#next").prop("disabled", false);
							$("#next_cancel").prop("disabled", false);
							$("#wizard_step_" + step).show();
							return;
						}
						var user = $("#wizard input[name='USRNAME']").val();
						var passw = $("#wizard input[name='PASSWD']").val();
						var fastProbeModel = $("#cameraModelList").val();
					}

					// show loading indicator
					$("#wizard_content .columns:first").prepend('<div class="loading_light">' + /* i18n: Loading progress. */ __("Loading") + '</div>');

					var nodeid = $("#cameraNodeList").val();
					if (!nodeid)
					{
						Log.error(__("There is no node with camera add support"));
						$("#next_cancel").trigger("click");
						return;
					}

					templateattributes = {};
					stop_exists.stop = false;
					Validate.getCameraModel({
						attributes: {
							DEVIP: ip,
							HTTP_PORT: port,
							USRNAME: user,
							PASSWD: passw,
							CAMERAMODEL: fastProbeModel
						},
						"nodeid": nodeid,
						"stop_exists": stop_exists,
						"callback": function(model)
						{
							//if (stop_exists) return;
							if (model){
								if (model["error"] === "")
								{
									if (!model["attributes"] || !model["attributes"]["CAMERAMODEL"] || model["attributes"]["CAMERAMODEL"] === "")
									{
										alert(__("The camera is not recognized."));
										$("#next").prop("disabled", false);
										$("#next_cancel").prop("disabled", false);
										$("#wizard_step_" + step).show();
										return;
									} else {
										// hide loading indicator
										$("#wizard_content .columns:first .loading_light").remove();

										var exists_msg = model["exists"];

										var CAMERAMODEL = model["attributes"]["CAMERAMODEL"];
										var MODELID = model["attributes"]["MODELID"];
										var MEDIA_FORMAT_LIST = model["attributes"]["MEDIA_FORMAT_LIST"];
										var IMAGESIZE_LIST = model["attributes"]["IMAGESIZE_LIST"];
										var AUDIO_UNIQUE_ID_LIST = model["attributes"]["AUDIO_UNIQUE_ID"];
										templateattributes = model["attributes"];

										$("#wizard input[name='CAMERAMODEL']").val(CAMERAMODEL);
										$("#wizard input[name='MODELID']").val(MODELID);
										$("#wizard input[name='CAMERAFIRMWARE']").val(model["attributes"]["FIRMWARE"]);
										$("#wizard").data("IMAGESIZE_LIST", model["attributes"]["IMAGESIZE_LIST"]);
										$("#wizard").data("AUDIO_UNIQUE_ID_LIST", AUDIO_UNIQUE_ID_LIST);
										$("#wizard").data("MEDIA_FORMAT_LIST", MEDIA_FORMAT_LIST);

										var htmlList = [];
										htmlList.push('<form>');
										var cameraList = model["parameters"]["CAMERA_LIST"];
										var snapshotList = model["parameters"]["SNAPSHOT_LIST"];
										var length = 0;
										if(typeof(cameraList) !== 'undefined'){
											$.each(cameraList, function(index){
												var camera = cameraList[index];
												var checked = '';
												if (length == 0) checked = ' checked ';
												length++;
												htmlList.push('<div class="item">');
													htmlList.push('<div class="image"><img width="165" src="/sdi/admincirrus/downloadimage.php?picture=' + snapshotList[index] + '"/></div>');
													htmlList.push('<div class="label"><input type="radio" name="CAMERA" ' + checked + ' value="' + index + '"">' + camera + '</div>');
												htmlList.push('</div>');
											});
										}
										htmlList.push('</form>');

										// create list and add events for image list
										$("#camera_picture")
											.html(htmlList.join(''))
											.on("click", ".item", function(){
												// check radio button in image list item
												$(this).find("input[name='CAMERA']").prop("checked", true);
												var CAMERA = $("#camera_picture input[name='CAMERA']:checked").val();

												if(typeof(model.existList) !== "undefined") {
                                                    $.each(model.existList, function(obj,val)
                                                    {
                                                        if (CAMERA == model.existList[obj].attributes.CAMERA)
                                                        {
                                                            Log.warning("The camera you are selecting is already registered in the system. Adding multiple registrations for the same camera will open multiple video streams from the camera and may lead to video performance degradation.");
                                                        }
                                                    });
                                                }
											});

										// check first element in list
										if (length < 2)
										{
											$("#camera_picture input[name='CAMERA']:first").prop("checked", true);
											if (exists_msg !== "")
												Log.warning(exists_msg);
										}

										fillMediaFormat(templateattributes);
										//Solution for Bosch cameras
										//Begin solution
										/*if (CAMERAMODEL == 'Bosch'){
											$("#wizard select[name='MEDIA_FORMAT']").hide();
											$("#wizard select[name='IMAGESIZE']").hide();
										}*/
										//End solution
									}
								} else {
									// hide loading indicator
									$("#wizard_content .columns:first .loading_light").remove();

									alert(model["error"]);
									$("#next").prop("disabled", false);
									$("#next_cancel").prop("disabled", false);
									$("#wizard_step_" + step).show();
									if ($("#cameraTypeList").val() == "network"){
										if (!$("#cameraTypeAxisList").html()){
											$("#cameraTypeList").trigger("change");
										}
									}
									return;
								}
							}

							$("#wizard input[name='NAME']").val($("#wizard input[name='CAMERAMODEL']").val() + " " + $("#wizard input[name='MODELID']").val());

							step++;
							if (step <= 2)
							{
								$("#next_step").data("value", step);
								$("#next").prop("disabled", false);
								$("#next_cancel").prop("disabled", false);
								$("#wizard_step_" + step).show();
							}
						}
					});
					return;
				} else
				if ($("#cameraTypeList").val() === "url")
				{
					$("#wizard input[name='CAMERAMODEL']").val('URL');
					$("#wizard input[name='MODELID']").val("");
					$("#wizard input[name='NAME']").val($("#wizard input[name='CAMERAMODEL']").val() + " camera");

					$("#wizard select[name='MEDIA_FORMAT']").hide();
					$("#wizard select[name='IMAGESIZE']").hide();

					var devurl = $("#cameraTypeUnicast input[name='DEVURL']").val();
					if (!/^rtp:\/\/.*/.test(devurl) )
					{
						$("#urlrtp").show();
						$("#wizard select[name='RTP_OVER_TCP']").show();
						$("#wizard select[name='RTP_FORCE_MULTICAST']").show();
					}

					var devurl = $("#cameraTypeUrl input[name='DEVURL']").val();
					if (/^rtsp:\/\//.test(devurl) )
					{
						$("#urlrtp").show();
						$("#wizard select[name='RTP_OVER_TCP']").show();
						$("#wizard select[name='RTP_FORCE_MULTICAST']").show();
					}


					$("#camera_picture").html('');

					fillMediaFormat({CAMERAMODEL: "URL", MODELID: ""});
				} else

				// unicast camera
				if ($("#cameraTypeList").val() === "unicast")
				{
					var port = $("#cameraTypeUnicast input[name='RTP_UNICAST_PORT']").val();
					// Port number field in camera wizard should allow to enter only 1024-65535
					var metadataport = $("#cameraTypeUnicast input[name='METADATA_PORT']").val();

					var cameramodel = $("#unicastCameraModelList").val();
					var modelid = "Unicast";
					if (port === "")
					{
						returnWithAlert( __("Please enter Port for listening"));
						return;
					}else
					if (!/^\d{1,5}$/.test(port) || parseInt(port) > 65535 )
					{
						returnWithAlert( __("Port must be integer and less then 65535"));
						return;
					}
					if ($.trim(metadataport) != '' && (!/^\d{1,5}$/.test(metadataport) || parseInt(metadataport) > 65535 || parseInt(metadataport) < 1024) )
					{
						returnWithAlert( __("Metadata port must be integer and between 1024 and 65535"));
						return;
					}
					//check if port not used
					$("#wizard input[name='CAMERAMODEL']").val(cameramodel);
					$("#wizard input[name='MODELID']").val(modelid);
					$("#wizard input[name='NAME']").val($("#wizard input[name='CAMERAMODEL']").val() + " " + $("#wizard input[name='MODELID']").val());

					var fastProbeModel = cameramodel;

					$("#wizard select[name='MEDIA_FORMAT']").hide();
					$("#wizard select[name='IMAGESIZE']").hide();
					$("#camera_picture").html('');

					fillMediaFormat({CAMERAMODEL: cameramodel, MODELID: modelid, RTP_UNICAST_PORT: port, DEVIP: '', METADATA_PORT: metadataport});
					$("#wizard_content .columns:first .loading_light").remove();

					// call php get function to search unicast camera with same port
					$("#cameraNodeList").trigger("change");
				} else

				// Multicast camera
				if ($("#cameraTypeList").val() === "multicast")
				{
					var port = $("#cameraTypeMulticast input[name='RTP_MULTICAST_PORT']").val();
					var ip = $("#cameraTypeMulticast input[name='MULTICAST_IP']").val();
					// Port number field in camera wizard should allow to enter only 1-65535

					var cameramodel = $("#multicastCameraModelList").val();
					var modelid = "Multicast";
					if (port === "")
					{
						returnWithAlert( __("Please enter Port for listening"));
						return;
					}else
					if (!/^\d{1,5}$/.test(port) || parseInt(port) > 65535 )
					{
						returnWithAlert( __("Port must be integer and less then 65535"));
						return;
					}
					if (ip === "")
					{
						returnWithAlert( __("Please enter IP for listening"));
						return;
					}else
					if (!/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/.test(ip))
					{
						returnWithAlert( __("IP must be ip-adress"));
						return;
					}

					//check if port and ip used
					var portused = false;

					$("#wizard input[name='CAMERAMODEL']").val(cameramodel);
					$("#wizard input[name='MODELID']").val(modelid);
					$("#wizard input[name='NAME']").val($("#wizard input[name='CAMERAMODEL']").val() + " " + $("#wizard input[name='MODELID']").val());

					var fastProbeModel = cameramodel;

					$("#wizard select[name='MEDIA_FORMAT']").hide();
					$("#wizard select[name='IMAGESIZE']").hide();
					$("#camera_picture").html('');

					fillMediaFormat({CAMERAMODEL: cameramodel, MODELID: modelid, RTP_MULTICAST_PORT: port, MULTICAST_IP: ip, DEVIP: ''});
					$("#wizard_content .columns:first .loading_light").remove();
					// call php get function to search unicast camera with same port
					$("#cameraNodeList").trigger("change");

					//return;
				} else
				if ($("#cameraTypeList").val() === "local")
				{
					var id = $("#cameraTypeLocalList option:selected").val();
					var modelid = $("#cameraTypeLocalList option:selected").text();

					$("#wizard input[name='CAMERAMODEL']").val('qtCam');
					$("#wizard input[name='MODELID']").val(modelid);
					$("#wizard input[name='NAME']").val(modelid);
					$("#camera_picture").html('');

					fillMediaFormat({CAMERAMODEL: "qtCam", MODELID: modelid});

					var qtCamCameraPicture = getqtCamCameraPicture(id);
					var img = '<img src="/sdi/admincirrus/downloadimage.php?picture=' + qtCamCameraPicture + '"/>';
					$("#camera_picture")
						.empty()
						.append(img);
				} else {
					alert("Please choose camera type");
					$("#next").prop("disabled", false);
					$("#next_cancel").prop("disabled", false);
					$("#wizard_step_" + step).show();
					return;
				}
			break;
			case 2:
			break;
		}
		step++;
		if (step <= 2)
		{
			$("#next_step").data("value", step);
			$("#next_cancel").prop("disabled", false);
			$("#wizard_step_" + step).show();
		}
		else
		{
			var name = $.trim($("#wizard input[name='NAME']").val());
			var location = $.trim($("#wizard input[name='LOCATION']").val());

			if (!/^.+$/.test(name))
			{
				step--;
				$("#next").prop("disabled", false);
				$("#next_cancel").prop("disabled", false);
				$("#wizard_step_" + step).show();
				alert(__("Camera name is a mandatory field."));
				return;
			}

/*			if (!/^[^']*$/.test(location))
			{
				step--;
				$("#next").prop("disabled", false);
				$("#next_cancel").prop("disabled", false);
				$("#wizard_step_" + step).show();
				alert(__("Location should begin with a character and not contain quotes."));
				return;
			}*/

			if ((found = /^([^/?#]+):(\d+)$/i.exec($("#wizard input[name='DEVIP']").val())) != null)
			{
				$("#wizard input[name='DEVIP']").val(found[1]);
				$("#wizard input[name='HTTP_PORT']").val(found[2]);
			}

			//var attributes = {};
			var attributes = templateattributes;
			// select input form elements
			$("#wizard input[type='text']").each(
				function()
				{
					if (String(this.name) !== "")
					{
						attributes[this.name] = $.trim(this.value);
					}
				}
			);

			if ($("#cameraTypeList").val() === "url")
			{
				var devurl = $("#cameraTypeUrl input[name='DEVURL']").val();
				if (/^rtsp:\/\//.test(devurl) ){
					attributes["RTP_OVER_TCP"] = $("#wizard select[name='RTP_OVER_TCP']").val();;
					attributes["RTP_FORCE_MULTICAST"] = $("#wizard select[name='RTP_FORCE_MULTICAST']").val();
				}
			}
			if ($("#cameraTypeList").val() === "unicast" || $("#cameraTypeList").val() === "multicast")
			{
				attributes["DEVIP"] = "";
			}
			if ($("#cameraTypeList").val() === "local")
			{
				attributes["QTCAM_UNIQUE_ID"] = $("#cameraTypeLocalList").val();
				attributes["DEVIP"] = "127.0.0.1";
				attributes["AUDIO_UNIQUE_ID"] = $("#wizard select[name='AUDIO_UNIQUE_ID']").val();
				if (attributes["AUDIO_UNIQUE_ID"] !== "")
				{
					attributes["AUDIO"] = "on";
				}
			}

			attributes["IMAGESIZE_LIST"] = $("#wizard").data("IMAGESIZE_LIST");
			attributes["IMAGESIZE"] = $("#wizard select[name='IMAGESIZE']").val();
			attributes["MEDIA_FORMAT_LIST"] = $("#wizard").data("MEDIA_FORMAT_LIST");
			attributes["MEDIA_FORMAT"] = $("#wizard select[name='MEDIA_FORMAT']").val();
			attributes["ENCODER_SETTING_OVERRIDE"] = $("#wizard select[name='ENCODER_SETTING_OVERRIDE']").val();
			attributes["PROTO"] = $("#wizard input[name='PROTO']").val();

			var CAMERA = $("#camera_picture input[name='CAMERA']:checked").val();
			if (CAMERA) attributes["CAMERA"] = CAMERA;

			if (attributes["CAMERAMODEL"] == "ONVIF")
			{
				var ONVIF_PROFILES_value = attributes["ONVIF_PROFILES"];
				var ONVIF_PROFILES = JSON.parse(ONVIF_PROFILES_value);

				var ONVIF_PROFILE = Object.keys(ONVIF_PROFILES[CAMERA])[0];

				var IMAGESIZE = ONVIF_PROFILES[CAMERA][ONVIF_PROFILE].IMAGESIZE;
				var MEDIA_FORMAT = ONVIF_PROFILES[CAMERA][ONVIF_PROFILE].MEDIA_FORMAT;

				attributes["ONVIF_PROFILE"] = ONVIF_PROFILE;
				attributes["IMAGESIZE"] = IMAGESIZE;
				attributes["MEDIA_FORMAT"] = MEDIA_FORMAT;
			}

			// add camera
			var nodeid = $("#cameraNodeList").val();
			var parameters = {
				nodeid: nodeid,
				type: "camera",
				attributes: JSON.stringify(attributes)
			};
			if (setid) parameters.setid = setid;

			api.addObject(parameters)
				.fail(function(code, message){
					alert(__("Camera was not added") + "\n" + message);
				})
				.done(function(response){
					$("#wizard").hide();

					var obj = response.obj;

					goToMatrix(obj);
				});
		}
	}

	function fillMediaFormat(templateAttr){
		var listToHTML = function(list)
		{
			var options = [];
			for (var i = 0; i < list.length; i++)
			{
				if (typeof list[i] == "object")
					options.push('<option value="' + list[i].value + '">' + list[i].label + '</option>');
				else
					options.push('<option value="' + list[i] + '">' + list[i] + '</option>');
			}
			return options.join('');
		};
		var MEDIA_FORMAT_js = '';
		var IMAGESIZE_js = '';
		var ENCODER_SETTING_OVERRIDE_js = '';
		var CAMERAMODEL =  templateAttr["CAMERAMODEL"];
		$("#wizard select[name='MEDIA_FORMAT']").show();
		$("#wizard select[name='IMAGESIZE']").show();
		if ($("#cameraTypeList").val() === "local")
		{
			$("#audiouniqueid").show();
			$("#wizard select[name='AUDIO_UNIQUE_ID']").show();
		}
		$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").show();
		$("#wizard select[name='MEDIA_FORMAT']").mask();
		$("#wizard select[name='IMAGESIZE']").mask();
		$("#wizard select[name='AUDIO_UNIQUE_ID']").mask();
		$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").mask();
		$("#next").prop("disabled", true);

		api.getTemplates({
			type: "camera",
			attributes: JSON.stringify(templateAttr)
		})
			.done(function(response){
                Validate.template_attr=response.template[""].attributes;
				var PROTO = response.template[""].attributes.PROTO;
				if (response.template[""].attributes.MEDIA_FORMAT.JS)
					MEDIA_FORMAT_js = response.template[""].attributes.MEDIA_FORMAT.JS;
				if (response.template[""].attributes.IMAGESIZE.JS)
					IMAGESIZE_js = response.template[""].attributes.IMAGESIZE.JS;
				if (response.template[""].attributes.ENCODER_SETTING_OVERRIDE && response.template[""].attributes.ENCODER_SETTING_OVERRIDE.JS)
					ENCODER_SETTING_OVERRIDE_js = response.template[""].attributes.ENCODER_SETTING_OVERRIDE.JS;
				$("#wizard input[name='PROTO']").val(PROTO.VALUE);

				//MEDIA_FORMAT
				var list = [];
				var MEDIA_FORMAT = response.template[""].attributes.MEDIA_FORMAT;
				if (MEDIA_FORMAT.TYPE !== "dropmenu")
				{
					list.push({value: MEDIA_FORMAT.VALUE, label: MEDIA_FORMAT.VALUE});
				} else {
					list = MEDIA_FORMAT.LIST;
				}
				$("#wizard select[name='MEDIA_FORMAT']").html(listToHTML(list));

				//IMAGESIZE
				var list = [];
				var IMAGESIZE = response.template[""].attributes.IMAGESIZE;
				if (IMAGESIZE.TYPE !== "dropmenu")
				{
					list.push({value: IMAGESIZE.VALUE, label: IMAGESIZE.VALUE});
				} else {
				//Solution for Bosch cameras
				//Begin solution
					if(CAMERAMODEL == "Bosch"){
						list.push({value: IMAGESIZE.VALUE, label: IMAGESIZE.VALUE});
					}else{
				//End solution
						list = IMAGESIZE.LIST;
					}
				}
				$("#wizard select[name='IMAGESIZE']").html(listToHTML(list));
				if (IMAGESIZE.TYPE == "hidden") $("#wizard select[name='IMAGESIZE']").hide();

				//AUDIO_UNIQUE_ID
				if ($("#cameraTypeList").val() === "local")
				{
					var list = [];
					var AUDIO_UNIQUE_ID = response.template[""].attributes.AUDIO_UNIQUE_ID;
					if (AUDIO_UNIQUE_ID.TYPE !== "dropmenu")
					{
						list.push({value: AUDIO_UNIQUE_ID.VALUE, label: AUDIO_UNIQUE_ID.VALUE});
					} else {
						list = AUDIO_UNIQUE_ID.LIST;
					}
					$("#wizard select[name='AUDIO_UNIQUE_ID']").html(listToHTML(list));
					if (AUDIO_UNIQUE_ID.TYPE == "hidden") $("#wizard select[name='AUDIO_UNIQUE_ID']").hide();
				}

				//ENCODER_SETTING_OVERRIDE
				var list = [];
				if (response.template[""].attributes.ENCODER_SETTING_OVERRIDE){
					var ENCODER_SETTING_OVERRIDE = response.template[""].attributes.ENCODER_SETTING_OVERRIDE;
					if (ENCODER_SETTING_OVERRIDE.TYPE !== "dropmenu")
					{
						list.push({value: ENCODER_SETTING_OVERRIDE.VALUE, label: ENCODER_SETTING_OVERRIDE.VALUE});
					} else {
						list = ENCODER_SETTING_OVERRIDE.LIST;
					}
					$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").html(listToHTML(list));
					if (ENCODER_SETTING_OVERRIDE.TYPE == "hidden") $("#wizard select[name='ENCODER_SETTING_OVERRIDE']").hide();
				}else{
					$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").hide();
				}

				require_js(
					"/sdi/admin/js/camera/" + CAMERAMODEL + "/validate.js",
					function ()
					{
						if (MEDIA_FORMAT_js){
							$("#wizard select[name='MEDIA_FORMAT']").change(eval(MEDIA_FORMAT_js));
							$("#wizard select[name='MEDIA_FORMAT']").trigger("change");
						}
						if (IMAGESIZE_js){
							$("#wizard select[name='IMAGESIZE']").change(eval(IMAGESIZE_js));
							$("#wizard select[name='IMAGESIZE']").trigger("change");
						}
						if (ENCODER_SETTING_OVERRIDE_js){
							$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").change(eval(ENCODER_SETTING_OVERRIDE_js));
							$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").trigger("change");
						}


						$("#next").prop("disabled", false);
						$("#next_cancel").prop("disabled", false);
						$("#wizard select[name='MEDIA_FORMAT']").unmask();
						$("#wizard select[name='IMAGESIZE']").unmask();
						$("#wizard select[name='AUDIO_UNIQUE_ID']").unmask();
						$("#wizard select[name='ENCODER_SETTING_OVERRIDE']").unmask();
					}
				);
			});
	}

	// load JS script to head section
	function require_js(url, callback)
	{
		if (!url)
			return;

		if ($("head script[src$='" + url + "']").length > 0)
		{
			callback();
		} else {
			var script = document.createElement("script");

			if (script.readyState) // IE
			{
				script.onreadystatechange = function()
				{
					if (script.readyState == "loaded"
						|| script.readyState == "complete")
					{
						script.onreadystatechange = null;
						callback();
					}
				};
			} else { // Others
				script.onload = function()
				{
					callback();
				};
			}

			script.setAttribute("src", url);
			document.getElementsByTagName("head")[0].appendChild(script);
		}
	}

	function onAddCameraClick()
	{
		current_mode = "addcamera";

		$("#div_ok").hide();
		$("#hint_block").slideUp();
		$("#manage_users").slideUp();
		$("#identity").slideUp();
		$("#licensing").slideUp();
		$("#tabs").slideUp();

		showWizard();

		$("#actionType").val("single");
		if ($("#actionType").val())
			$("#actionType").trigger("click");

		$("#cameraTypeList").val("network");
		if ($("#cameraTypeList").val()){
			$("#cameraTypeList").trigger("change");
		}
	}

	function fillNodeList()
	{
		$("#wizard").mask();
		$.when(
			api.getObjectList({type: "node", withAttributes: true}),
			api.getObjectList({type: "avatar", withAttributes: true})
		)
			.done(function(responseNodeList, responseAvatarList){
				var list = responseNodeList[0]["list"];
				var avatarList = responseAvatarList[0]["list"];
				if (list.length > 0)
				{
					var nodeList_select = "";
					var i, obj;
					for (i = 0; i < list.length; i++)
					{
						obj = list[i]["obj"];
						var CAMERA_REGISTRATION = list[i]["attributes"]["CAMERA_REGISTRATION"] == "yes";
						var number_of_cameras = list[i]["number_of_cameras"];
						var location = list[i]["attributes"]["IP"];
						if (CAMERA_REGISTRATION)
						{
							nodeList_select += '<option value="' + obj + '">' + __("Node") + ': ' + location + ' (' + number_of_cameras + ' cameras)</option>';
						}
					}

					for (i = 0; i < avatarList.length; i++)
					{
						obj = avatarList[i]["obj"];
						var name = avatarList[i]["attributes"]["NAME"];
						nodeList_select += '<option value="' + obj + '">Avatar: ' + name + '</option>';
					}

					$("#cameraNodeList")
						.empty()
						.append(nodeList_select)
						.val(window.nodeid);
				}
			})
			.always(function(){
				$("#wizard").unmask();
			});
	}

	function fillCameraModelList(callback)
	{
		api.getCameraModelList()
			.fail(function (code, message){})
			.done(function (response){
				var list = response.list;
				if (list.length > 0)
				{
					var cameraModelList_select = "";

					cameraModelList_select += '<option value="auto" selected="true">auto</option>';
					for (var i = 0; i < list.length; i++)
					{
						var name = list[i]["name"];
						cameraModelList_select += '<option value="' + name.replace(/"/g, '&quot;') + '">' + name + '</option>';
					}

					$("#cameraModelList")
						.empty()
						.append(cameraModelList_select);

					if ($.isFunction(callback))
					{
						callback();
					}
				}
			});
	}

	function fillqtCamCameraList()
	{
		// fill qtCamCameraList
		$("#cameraTypeLocal").mask();
		getqtCamCameraList(function(list){
			if (list["list"].length > 0)
			{
				var cameraTypeLocalList = "";
				for (var i = 0; i < list["list"].length; i++)
				{
					var id = list["list"][i]["UNIQUEID"];
					var name = list["list"][i]["MODELID"];
					cameraTypeLocalList += '<option value="' + id + '">' + name + '</option>';
				}

				$("#cameraTypeLocalList")
					.empty()
					.append(cameraTypeLocalList);
				$("#cameraTypeLocal").unmask();
			}else{
				$("#cameraTypeLocal").unmask();
			}
		});
	}

	// getqtCamCameraList({async: true, callback: function(list){}});
	// call callback(list) after getting list of qtCam
	function getqtCamCameraList(callback)
	{
		api.getqtCamParametersList({
			type: "camera"
		})
			.fail(function (code, message){
				var list = {list: []};
				callback(list);
			})
			.done(function (response){
				var list = response;
				callback(list);
			});
	}

	function getqtCamCameraPicture(id)
	{
		var qtCamCameraPicture = "";

		$("#cameraTypeLocalList").mask();
		syncAPI.getqtCamCameraPicture({
			id: id
		})
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				qtCamCameraPicture = response.SNAPSHOT;
			})
			.always(function(){
				$("#cameraTypeLocalList").unmask();
			});

		return qtCamCameraPicture;
	}

	function fillAxisCameraList()
	{
		$("#cameraTypeAxisSelect").mask();
		api.getAxisCameraList()
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				var cameraTypeAxisList = "";

				var list = response.CAMERAS;
				if (list.length > 0)
				{
					for (var i = 0; i < list.length; i++)
					{
						var ip = list[i]["ip"];
						var name = list[i]["name"];
						var port = list[i]["port"];
						if (port !== "80")
							ip += ":" + port;
						cameraTypeAxisList += '<option value="' + ip + '">' + name + ' (' + ip + ')</option>';
					}

					$("#cameraTypeAxisList")
						.empty()
						.append(cameraTypeAxisList);
				}
			})
			.always(function(){
				$("#cameraTypeAxisSelect").unmask();
			});
	}

	function onCameraTypeAxisListClick()
	{
		var ip = $("#cameraTypeAxisList").val();
		if (ip)
			$("#wizard input[name='DEVIP']").val(ip);
	}

	function checkSessionExpired(data)
	{
		if (/^(<script.*>)/.test(data)){
			top.location.href = '/sdi/login/logout.php?token=' + getToken();
			return true;
		}
		return false;
	}

	function onCameraTypeUrlChange(){
		if ($("#cameraTypeUrl input").val() !== '') $("#next").prop("disabled", false);
		else $("#next").prop("disabled", true);
	}

	function onCameraTypeLocalListChange(){
		if ($("#cameraTypeLocalList").val() !== '' && $("#cameraTypeLocalList").val() !== null)
			$("#next").prop("disabled", false);
		else
			$("#next").prop("disabled", true);
	}

	function doEnabledRegButtons(){
		var serialNumber = $("#licensing input[name='SERIAL']").val();
		if (serialNumber !== ''){
			$("#licensing input[name='PORTAL_SHOW_REGISTRATION']").prop("disabled", false);
			$("#licensing input[name='SHOW_MANUAL_REGISTRATION']").prop("disabled", false);
		}else{
			$("#licensing input[name='PORTAL_SHOW_REGISTRATION']").prop("disabled", true);
			$("#licensing input[name='SHOW_MANUAL_REGISTRATION']").prop("disabled", true);
		}
	}

	function showManualRegistration(){
		var serialNumber = $("#licensing input[name='SERIAL']").val();
		api.createPCID({"serialNumber": serialNumber})
			.fail(function(code, message){
				Log.error(__("Error during pcid.bin creation") + "\n" + message);
			})
			.done(function(){
				window.location.href = '/sdi/about/manual_license.php';
			});
	}

	function importCameraList() {
		var nodeid = $("#camimportNodeList").val();
		isRunFileUpload = true;
		$("#wizard_content .columns:first").prepend('<div class="loading_light">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
		xhr = $.ajaxFileUpload({
			url : 'import_camlist.php?nodeid=' + nodeid + "&setid=" + window.setid,
			async: false,
			secureuri : false,
			fileElementId : 'file_upload',
			dataType : 'json',
			complete: function()
			{
				$("#wizard_content .columns:first .loading_light").remove();
			},
			success : function(data, status)
			{
				if (isRunFileUpload){
					$("#wizard_import").show();
					$("#div_ok").show();
					$("#div_next").hide();

					$("#wizard_content .columns:first .loading_light").remove();
					if (typeof(data.error) !== 'undefined')
					{
						if(data.error !== '')
						{
							$("#import_result").text(__("Import error: ") + data.error);
							alert(data.error);
						} else
						{
							var msg = __("Entries PASSED:") + " " + data.passed + "<br>" +
								__("Entries REJECTED:") + " " + data.rejected.length;
							if (data.rejected.length > 0)
							{
								msg += "<br>----------------------------<br>" +
									__("Rejected entries at lines:") + " ";
									for (var i = 0; i < data.rejected.length; i++)
									{
										msg += data.rejected[i] + (i == data.rejected.length - 1 ? "" : ", ");
									}
							}

							$("#import_result").html(msg);
							if (data.rejected.length == 0) {
								$("#next_cancel").prop("disabled", true);
								Log.info(msg);
							} else if(data.passed > 0) {
								Log.warning(msg);
							} else {
								Log.error(msg);
							}
						}
					}
				}
			},
			error : function(data, status, e)
			{
				if (isRunFileUpload){
					$("#wizard_content .columns:first .loading_light").remove();
					$("#import_result").text(__("Import error: ") + e);
					$("#wizard_import").show();
					$("#div_ok").show();
					$("#div_next").hide();
					alert(e);
				}
			}
		});
	}

	function addEvents()
	{
		$(window).resize(function(){
			var window_height = $(window).height();

			var right_cell_height = $("#tabs").height() + 45;
			var camera_list_height = $("#cameralist").height();
			if (right_cell_height < window_height - 100)
			{
				$("#cameralist").css("height", window_height - 100);
			} else {
				$("#cameralist").css("height", right_cell_height);
			}
		});

		$(document).keydown(function(event){
			if (event.keyCode == 13
				&& $("#wizard:visible").length)
			{
				if ($(event.target).attr("id") !== "next")
					$("#next").trigger("click");
			}
		});

		$("#tabs_content").keydown(function(event){
			if (event.keyCode == 13)
			{
				if (!window.isMassObjectEditor &&
					!$("#saveObject").prop("disabled"))
				{
					$("#saveObject").trigger("click");
				}
			}
		});

		$("#addcamera").click(onAddCameraClick);

		$("#next").click(
			function()
			{
				wizardNextStep();
			}
		);

		$("#ok_button").click(
			function()
			{
				goToMatrix();
			}
		);

		$("#next_cancel").click(
			function()
			{
				$("#div_ok").hide();
				$("#import_result").html("");
				$("#wizard_import").hide();
				$("#div_next").show();
				isRunFileUpload = false;
				if ($("#addcamera").length)
				{
					$("#addcamera").trigger("click");
				} else {
					if (xhr) xhr.abort();
					//checkAgain = checkAgain && false;
					stop_exists.stop = true;
					$("#wizard_content .columns:first .loading_light").remove();
					var step = parseInt($("#next_step").data("value"), 10);
					if ( $("#wizard_step_1").is(":hidden") ) {
						$("#wizard_step_" + step).hide();
						$("#next_step").data("value", "1");
						$("#next").prop("disabled", false);
						$("#wizard_step_1").show();
						if ($("#cameraTypeList").val() == "network"){
							if (!$("#cameraTypeAxisList").html()){
								$("#cameraTypeList").trigger("change");
							}
						}
					}else{
						goToMatrix();
					}
				}
			}
		);

		$("#systemsettingslist div[data-setting='licensing']").click(
			function()
			{
				current_mode = "licensing";

				$("#hint_block").slideUp();
				$("#manage_users").slideUp();
				$("#identity").slideUp();
				$("#wizard").slideUp();
				$("#tabs").slideUp();
				$("#manage_price_block").slideUp();
				$("#current_report_block").slideUp();
				$("#history_report_block").slideUp();

				api.getLicenseAttributesList()
					.fail(function(code, message){
						Log.error("[" + code + "] " + message);
					})
					.done(function(data){
						var list = data;
						var content = "<table class='border_table'>";
						content += "<tr><th>" + __("Licensed Option") + "</th><th>" + __("Currently Used") + "</th><th>" + __("Licensed Limit") + "</th></tr>";

						var label = '';
						var serial = '';

						if (typeof(list.attributes["ser"]) != "undefined")
						{
							label = list.attributes["ser"]["label"];
							serial = list.attributes["ser"]["value"];
						}

						if (serial !== "")
						{
							content += "<tr><td>" + label + "</td><td>" + serial + '</td><td><input type="button" value="' + __("Change") + '" size="20" name="LICENSE_CHANGE"/></td></tr>';
						} else {
							$("#need_activate").show();
						}

						var attributes = list.attributes;
						for (var parameter in attributes)
						{
							var label = attributes[parameter]["label"];
							var limit = attributes[parameter]["limit"];
							var value = attributes[parameter]["value"];
							var overflow = attributes[parameter]["overflow"];
							var additionalInfo = "";

							if (limit == "1NaN") limit = 'N/A';
							if (value == "1NaN") value = 'N/A';

							if (parameter !== "ser" && parameter !== "vca" && parameter !== "geo" && parameter !== "ov6" && parameter !== "cls")
							{
								if (overflow)
								{
									content += "<tr><td>" + label + "</td><td style='color:red'>" + value + "</td><td>" + limit + "</td></tr>";
								} else
								{
									content += "<tr><td>" + label + "</td><td>" + value + "</td><td>" + limit + "</td></tr>";
								}
							}
							if (parameter == "ver" && overflow)
							{
								Log.warning(__('License version is not compatible with your STRATUS version. Please update your license.'));
							}

							if (parameter == "vca")
							{
								if (value == 0)
								{
									value = "off";
								} else
								if (value == 1)
								{
									value = "on";
								}
								content += '<tr><td>' + label + '</td><td colspan="2" id="VCA_details_cell">' + value + '&nbsp;<input type="button" value="' + __("Details") + '"/></td></tr>';
							}

							if (parameter == "ov6")
							{
								if (value == 0)
								{
									value = "off";
								}
								else{
									value = "on";
								}
								content += '<tr><td>' + label + '</td><td colspan="2" id="OV6_details_cell" ov6="' + value + '">' + value + '&nbsp;<input type="button" value="' + __("Details") + '"/></td></tr>';
							}

							if (parameter == "geo")
							{
								content += '<tr><td>' + label + '</td><td colspan="2">' + value + '</td></tr>';
							}

							if (parameter == "cls")
							{
								if (value == 0) {
									value = "DISABLED";
								}
								content += '<tr><td>' + label + '</td><td colspan="2">' + value + '</td></tr>';
							}
						}
						content += "</table>";
						if (serial == "") {content = ''; $("#nolicense").show();}
						$("#license_attributes")
							.empty()
							.append(content)
							.on("click", "#VCA_details_cell", showVCAdetails)
							.on("click", "#OV6_details_cell", showOV6details);
						$("#license_attributes input[name='LICENSE_CHANGE']").click(function(){
							$("#need_activate").show();
							$("#license_attributes input[name='LICENSE_CHANGE']").hide();
						});
						$("#licensing").slideDown();
					});
			}
		);

		$("#cameraTypeUrl input").keyup(onCameraTypeUrlChange);
		$("#cameraTypeUrl input").change(onCameraTypeUrlChange);
		$("#cameraTypeLocalList").change(onCameraTypeLocalListChange);

		$("#wizard select[name='RTP_OVER_TCP']").change(function()
			{
				var value = $("#wizard select[name='RTP_OVER_TCP']").val();
				if (value === 'on'){
					$("#wizard select[name='RTP_FORCE_MULTICAST']").val('off');
				}
			}
		);
		$("#wizard select[name='RTP_FORCE_MULTICAST']").change(function()
			{
				var value = $("#wizard select[name='RTP_FORCE_MULTICAST']").val();
				if (value === 'on'){
					$("#wizard select[name='RTP_OVER_TCP']").val('off');
				}
			}
		);

		$("#cameraTypeList").change(
			function()
			{
				$("#next").prop("disabled", false);
				if ($("#cameraTypeList").val() === "network")
				{
					fillCameraModelList();
					$("#cameraTypeAxisList").empty();
					$("#cameraTypeLocal").slideUp();
					$("#cameraTypeUrl").slideUp();
					$("#cameraTypeUnicast").slideUp();
					$("#cameraTypeMulticast").slideUp();
					$("#cameraTypeNetwork").slideDown();
					$("#cameraTypeAxis").show();
				} else
				if ($("#cameraTypeList").val() === "url")
				{
					$("#cameraTypeNetwork").slideUp();
					$("#cameraTypeAxis").slideUp();
					$("#cameraTypeLocal").slideUp();
					$("#cameraTypeUnicast").slideUp();
					$("#cameraTypeMulticast").slideUp();
					$("#cameraTypeUrl").slideDown();
					if ($("#cameraTypeUrl input").val() !== '') $("#next").prop("disabled", false);
					else $("#next").prop("disabled", true);
				} else
				if ($("#cameraTypeList").val() === "unicast")
				{
					$("#cameraTypeUnicast").slideDown();
					$("#cameraTypeMulticast").slideUp();
					$("#cameraTypeNetwork").slideUp();
					$("#cameraTypeAxis").slideUp();
					$("#cameraTypeLocal").slideUp();
					$("#cameraTypeUrl").slideUp();

					if ($("#cameraTypeUnicast input[name='DEVIP']").val() !== '' || $("#cameraTypeUnicast input[name='HTTP_PORT']").val() !== '')  $("#next").prop("disabled", false);
					else $("#next").prop("disabled", true);
				} else
				if ($("#cameraTypeList").val() === "multicast")
				{
					$("#cameraTypeMulticast").slideDown();
					$("#cameraTypeUnicast").slideUp();
					$("#cameraTypeNetwork").slideUp();
					$("#cameraTypeAxis").slideUp();
					$("#cameraTypeLocal").slideUp();
					$("#cameraTypeUrl").slideUp();

					if ($("#cameraTypeMulticast input[name='DEVIP']").val() !== '' || $("#cameraTypeMulticast input[name='HTTP_PORT']").val() !== '')  $("#next").prop("disabled", false);
					else $("#next").prop("disabled", true);
				} else

				if ($("#cameraTypeList").val() === "local")
				{
					$("#cameraTypeNetwork").slideUp(0);
					$("#cameraTypeAxis").slideUp(0);
					$("#cameraTypeUrl").slideUp(0);
					$("#cameraTypeUnicast").slideUp(0);
					$("#cameraTypeMulticast").slideUp(0);
					$("#cameraTypeLocal").slideDown(0);
					if ($("#cameraTypeLocalList").val() != '' && $("#cameraTypeLocalList").val() !== null) $("#next").prop("disabled", false);
					else $("#next").prop("disabled", true);
					fillqtCamCameraList();
				}
			}
		);

		$("#fillCameraTypeAxisList").click(function(){
			fillAxisCameraList();
		});

		$("#cameraTypeAxisList").click(onCameraTypeAxisListClick);

		$("#need_activate input[name='SERIAL']").keyup(function(){
			doEnabledRegButtons();
		});

		$("#need_activate input[name='SHOW_MANUAL_REGISTRATION']").click(function(){
			showManualRegistration();
		});

		$("#licensing input[name='SERIAL_ACTIVATE']").click(function(){
			$("#portal_registration").hide();
			$("#serial_conirmation").hide();
			$("#portal_skip_registration").hide();
			$("#license_ageement").show();
		});

		$("#licensing input[name='DO_NOT_AGREE_ACTIVATE']").click(function(){
			alert("You do not agree with the license conditions.");
			$("#license_ageement").hide();
			$("#license_attributes").show();
			$("#nolicense").hide();
			$("#licensing_header").text("Product Licensing");
			$("#systemsettingslist div[data-setting='licensing']").trigger("click");
		});

		$("#licensing input[name='AGREE_ACTIVATE']").click(function(){
			var serialNumber = $("#licensing input[name='SERIAL']").val();

			$("#need_activate").hide();
			$("#licensing").mask();

			api.activateSerialNumber({"serialNumber": serialNumber})
				.fail(function(code, message){
					var my_err_msg = __("Serial already activated from another hardware!");
					alert(__("Issues reported during license activation:") +"\n" + __(message));

					$("#license_ageement").hide();
					$("#license_attributes").show();
					$("#nolicense").hide();
					$("#licensing_header").text("Product Licensing");

					if (!$("#license_attributes input[name='LICENSE_CHANGE']").length)
					{
						$("#need_activate").show();
						$("#licensing_header").text("Product Licensing");
					}

					$("#systemsettingslist div[data-setting='licensing']").trigger("click");
				})
				.done(function(){
					Log.info(__("The licence is successfully changed."));

					if (isUserLicenseSkip || CRM_REGISTRATION_URL == "" || CRM_REGISTRATION_URL == "none")
					{
						$("#license_ageement").hide();
						$("#license_attributes").show();
						$("#nolicense").hide();
						$("#licensing_header").text("Product Licensing");
						fade();
						top.setTimeout(doReload, 2500);
					} else {
						$("#licensing input[name='PORTAL_REGISTER']").trigger('click');
					}
				})
				.always(function(){
					$("#licensing").unmask();
				});
		});

		function fade()
		{
			var maskHeight = $(top.document).height();
			var maskWidth = $(top.window).width();

			$(top.document.getElementById("maskdiv")).css({'width':maskWidth,'height':maskHeight});
			$(top.document.getElementById("maskdiv")).fadeTo("fast",0.1);
		}

		function doReload(){
			$(top.document.getElementById("maskdiv")).hide();
			top.location.reload();
		}

		//show portal registration form
		$("#licensing input[name='PORTAL_SHOW_REGISTRATION']").click(function(){
			if(CRM_REGISTRATION_URL == "" || CRM_REGISTRATION_URL == "none"){
				$("#license_attributes").hide();
				$("#need_activate").hide();
				$("#licensing input[name='SERIAL_ACTIVATE']").trigger("click");
				return;
			}

			var serialNumber = $("#licensing input[name='SERIAL']").val();
			if(serialNumber == ''){
				alert("Incorrect serial number!");
				return;
			}

			if(!isUserLicenseInformed){
				if(confirm("Your current license will be replaced if you proceed")){
					isUserLicenseInformed = true;
				}
			}

			var serialNumber = $("#licensing input[name='SERIAL']").val();
			syncAPI.hasConnectToLicenseServer()
				.fail(function(code, message){
					window.location.href = '/sdi/about/manual_license.php';
				})
				.done(function(response){});

			if (isUserLicenseInformed){
				$("#need_activate").hide();
				$("#license_attributes").hide();
				$("#nolicense").hide();
				$("#portal_skip_registration").hide();
				$("#serial_conirmation").hide();
				$("#portal_registration").show();

				$("#licensing_header").text("Product Registration");
			}
		});

		//register user in customer portal
		$("#licensing input[name='PORTAL_REGISTER']").click(function(){
			var serialNumber = $("#licensing input[name='SERIAL']").val();
			var date = new Date();
			var year = date.getFullYear();
			var month = date.getMonth(); month++; if(month<10){ month="0"+month; }
			var day = date.getDate();  if(day<10){ day="0"+day; }
			var portalFirstName = $("#licensing input[name='PORTAL_FIRST_NAME']").val();
			var portalLastName = $("#licensing input[name='PORTAL_LAST_NAME']").val();
			var portalMail = $("#licensing input[name='PORTAL_EMAIL']").val();
			var portalPhone = $("#licensing input[name='PORTAL_PHONE']").val();
			var portalAddress = $("#licensing input[name='PORTAL_ADDRESS']").val();
			var portalDescrition = "STRATUS user. Serial number:"+serialNumber+". Activation date:"+year+"-"+month+"-"+day;

				$.post(
					CRM_REGISTRATION_URL,
					"contact_lastname="+portalLastName+"&contact_firstname="+portalFirstName+"&contact_email="+portalMail+"&contact_phone="+portalPhone+"&contact_description="+portalDescrition,
					function(data, textStatus){
						if(textStatus.toString() == "success"/* && data.toString().search(/successfully added/)!=-1*/){
							//portal user successfully registered
							Log.info(__("Portal user successfully registred."));
						}
						else{
							alert(__("Couldn't connect to customer portal. Skiping portal registration."));
						}
//						$("#serial_conirmation").hide();
						$("#license_ageement").hide();
						$("#license_attributes").show();
						$("#nolicense").hide();
						$("#licensing_header").text("Product Licensing");
						//$("#systemsettingslist div[data-setting='licensing']").trigger("click");

						fade();
						top.setTimeout(doReload,2500);

					}
				);
		});

		//show serial confirmation screen
		$("#licensing input[name='SERIAL_CONFIRM']").click(function(){
			$("#portal_registration").hide();

			var serialNumber = $("#licensing input[name='SERIAL']").val();
			var portalFirstName = $("#licensing input[name='PORTAL_FIRST_NAME']").val();
			var portalLastName = $("#licensing input[name='PORTAL_LAST_NAME']").val();
			var portalMail = $("#licensing input[name='PORTAL_EMAIL']").val();
			var portalPhone = $("#licensing input[name='PORTAL_PHONE']").val();
			var portalAddress = $("#licensing input[name='PORTAL_ADDRESS']").val();

			if(portalFirstName!='' && portalLastName!='' && portalMail!=''){
				var html_message = "Please confirm license activation for serial number:  "+serialNumber+" for user "+portalFirstName+" "+portalLastName+" (email:"+portalMail;
				if(portalPhone!=''){
					html_message+=", phone:"+portalPhone;
				}
				if(portalAddress!=''){
					html_message+=", address:"+portalAddress;
				}
				html_message+=").";
				$("#comfirm_information").html(html_message);

				$("#serial_conirmation").show();
				isUserLicenseSkip = false;
			}
			else{
				isUserLicenseSkip = true;
				$("#portal_registration").hide();
				$("#portal_skip_registration").show();
			}
		});

		$("#actionType").click(
			function() {
				var actionType = $("#actionType").val();
				if(actionType == "single") {
					$("#next").attr("value", __("Next"));
					$("#camimportNodeList").html($("#cameraNodeList").html());
					$("#camimportNodeList").prepend("<option value='auto' selected='true'>auto</option>");
					$("#camimportNodeList").val(window.nodeid);
					$("#singleCamSection").show();
					$("#importCamListSection").hide();
				} else if(actionType == "import") {
					$("#next").attr("value",__("Import"));
					$("#singleCamSection").hide();
					$("#importCamListSection").show();
				}
			}
		);

		$("#cameraNodeList").change(
			function() {
				var nodeip = $("#cameraNodeList").val();
				var nodeid = 0;
				var cameraType = $("#cameraTypeList").val();
				if (cameraType === "unicast" || cameraType === "multicast")
				{
					$("#next").prop("disabled", true);
					var filterMask = '';
					if (cameraType === "unicast") filterMask = 'Unicast';
					if (cameraType === "multicast") filterMask = 'Multicast';

					$("#wizard_step_2").mask();

					api.getObjectList({
						type: "node",
						withAttributes : true
					})
						.fail(function (code, message){
							$("#wizard_step_2").unmask();
							returnWithAlert(message);
						})
						.done(function (response){
							var nodelist = response.list;
							for (var i = 0; i < nodelist.length; i++){
								if (nodelist[i]['attributes']['UNI'] == nodeip) nodeid = nodelist[i]['obj']
							}
							var portused = false;

							api.getObjectList({
								withAttributes: true,
								nodeid: nodeid,
								filterAttribute: 'MODELID',
								filterMask: filterMask
							})
								.always(function(){
									$("#wizard_step_2").unmask();
								})
								.fail(function (code, message){
									returnWithAlert(message);
								})
								.done(function (response){
									if (response.list){
										var list = response.list;
										if (cameraType === "multicast"){
											var port = $("#cameraTypeMulticast input[name='RTP_MULTICAST_PORT']").val();
											var ip = $("#cameraTypeMulticast input[name='MULTICAST_IP']").val();
											for (var i = 0; i < list.length; i++){
												if (list[i]['attributes']['RTP_MULTICAST_PORT'] && list[i]['attributes']['RTP_MULTICAST_PORT'] == port &&
													list[i]['attributes']['MULTICAST_IP'] && list[i]['attributes']['MULTICAST_IP'] == ip){
													portused = true;
												}
											}
										}else if (cameraType === "unicast"){
											var port = $("#cameraTypeUnicast input[name='RTP_UNICAST_PORT']").val();
											for (var i = 0; i < list.length; i++){
												if (list[i]['attributes']['RTP_UNICAST_PORT'] && list[i]['attributes']['RTP_UNICAST_PORT'] == port){
													portused = true;
												}
											}
										}
										if (portused)
										{
											if (cameraType === "unicast"){
												alert( __("Port was used by another unicast camera. Two unicast cameras can not operate simultaneously with one port on same node."));
											}
											if (cameraType === "multicast"){
												alert( __("Port and IP was used by another multicast camera. Two multicast cameras can not operate simultaneously with one port and IP on same node."));
											}
											$("#next").prop("disabled", true);
										}else{
											$("#next").prop("disabled", false);
										}
									}
								});
						});
				}
			}
		);
	}

});
