<?php
/**
 * @version $Id: index.php 34755 2016-05-19 18:40:21Z astarostin $
 * ------------------------------------------------------------------------------
 * Add camera wizard and lciense page
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2012
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$mode = "full";
if (isset($_GET["mode"]))
{
	$mode = $_GET["mode"];
}

$obj = -1;
if (isset($_GET["obj"]))
{
	$obj = intval($_GET["obj"], 10);
}

$setid = -1;
if (isset($_GET["setid"]))
{
	$setid = intval($_GET["setid"], 10);
}

$backhref = "";
if (isset($_GET["backhref"]))
{
	$backhref = htmlentities($_GET["backhref"], ENT_QUOTES, 'UTF-8');
}

$object = new Obj();
if (isset($_GET["objectType"]))
{
	$objectType = htmlentities($_GET["objectType"], ENT_QUOTES, 'UTF-8');
} else {
	$objectType = $object->getType($obj);
	if (!isset($objectType))
		$objectType = "camera";
}

$model = $object->getAttribute($obj, "CAMERAMODEL");

$nodeid = null;
if (isset($_GET["nodeid"]))
{
	$nodeid = $_GET["nodeid"];
} else {
	$nodeid = Node::getMasterNodeId();
}

$brand = Node::getBrand();
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('AdminLight');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>
	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css"/>

	<!--load validation functions-->
	<script src="/sdi/admin/js/<?=Purifier::clean($objectType)?>/<?=Purifier::clean($model)?>/validate.js"></script>

	<script>
		var SKM_BRAND = '<?=Purifier::clean($brand)?>';
		var isMassObjectEditor = false;
		var nodeid = '<?=Purifier::clean($nodeid)?>';
		var setid = <?php if ($setid > -1) echo $setid; else echo "null"?>;
		var backhref = '<?=Purifier::clean($backhref)?>';
		var mode = '<?=Purifier::clean($mode)?>';
	</script>

	<script data-main="js/admincirrus_script.js" src="/sdi/lib/js/require.js"></script>
</head>
<body>
	<div class="editor_container">
	<?php
	if ($mode === "addObject")
	{
?>
				<div id="wizard" class="tabs">
					<div class="tabs_menu">
						<div class="single_tab">
							<div class="tab_text"><?php print __("Camera Add Wizard");?></div>
						</div>
					</div>
					<div id="wizard_content" class="tabs_content">
						<div class="columns">
							<div class="wizard_section" id="wizard_step_1">
								<?
									$SIMPLIFIED_ADD_CAMERA_WIZARD = Template::boolVal(Identity::getAttribute("SIMPLIFIED_ADD_CAMERA_WIZARD"));
									$extendedStyle = $SIMPLIFIED_ADD_CAMERA_WIZARD ? 'class="hidden"' : "";
								?>
								<div <?=$extendedStyle;?>>
									<div class="help"><?php echo __('Choose action type');?></div>
									<select id="actionType" size="2">
										<option value="single" selected="true"><?php echo __('Add single camera');?></option>
										<option <?php if ($brand === 'CIRRUS') print 'disabled="true"';?> value="import"><?php echo __('Import camera list from CSV file');?></option>
									</select>
								</div>
								<div id="singleCamSection">
									<div <?=$extendedStyle;?>>
										<div class="help"><?php echo __('Choose camera type');?></div>
										<select id="cameraTypeList" size="6">
											<option value="network" selected="true"><?php echo __('Network');?></option>
											<option value="url"><?php echo __('URL');?></option>
											<!--option value="local"><?php echo __('Local');?></option-->
<!-- CLARE_REPLACE_ADMINCIRRUS_INDEX_PHP_ID001_BEGIN -->
											<option value="unicast"><?php echo __('Unicast');?></option>
											<option value="multicast"><?php echo __('Multicast');?></option>
<!-- CLARE_REPLACE_ADMINCIRRUS_INDEX_PHP_ID001_END -->
										</select>
										<div>
											<div class="description"><?php echo __('Node');?></div>
											<select id="cameraNodeList"></select>
										</div>
									</div>
									<div id="cameraTypeNetwork">
										<div class="help"><?php echo __('Enter camera IP or Domain Name');?></div>
										<div class="description"><?php echo __('Domain Name');?></div>
										<input type="text" value="0.0.0.0" size="20" name="DEVIP"/>
										<input type="text" value="80" size="20" name="HTTP_PORT" style="display: none;"/>
										<div class="description"><?php echo __('Camera model name (fast probing)');?></div>
										<select id="cameraModelList">
											<option value="auto"><?php echo __('auto');?></option>
										</select>
										<div id="cameraTypeAxis">
											<div class="help"><?php echo __('or choose camera from the list');?></div>
											<div id="cameraTypeAxisSelect">
												<button id="fillCameraTypeAxisList"><?=__("Search cameras");?></button>
												<select id="cameraTypeAxisList" size="6"></select>
											</div>
										</div>
										<div class="help"><?php echo __('Enter camera Username, Password');?> </div>
										<div class="description"><?php echo __('Username');?></div>
										<input type="text" value="user" size="20" name="USRNAME"/>
										<div class="description"><?php echo __('Password');?></div>
										<input type="password" value="pass" size="20" name="PASSWD"/>
									</div>
									<div id="cameraTypeUrl">
										<div class="description"><?php echo __('Enter camera URL');?></div>
										<input type="text" value="" size="20" name="DEVURL"/>
									</div>
									<div id="cameraTypeUnicast">
										<div class="description"><?php echo __('Model');?></div>
										<select id="unicastCameraModelList" size="1">
											<option value="ListenerMPEG2-TS" selected="true">ListenerMPEG2-TS</option>
										</select>
										<div class="description"><?php echo __('Port');?></div>
										<input type="text" value="" size="20" name="RTP_UNICAST_PORT"/>
										<div class="description"><?php echo __('Metadata port');?></div>
										<input type="text" value="" size="20" name="METADATA_PORT"/>
									</div>
									<div id="cameraTypeMulticast">
										<div class="description"><?php echo __('Model');?></div>
										<select id="multicastCameraModelList" size="1">
											<option value="ListenerMPEG2-TS" selected="true">ListenerMPEG2-TS</option>
										</select>
										<div class="description"><?php echo __('Port');?></div>
										<input type="text" value="" size="20" name="RTP_MULTICAST_PORT"/>
										<div class="description"><?php echo __('IP');?></div>
										<input type="text" value="" size="20" name="MULTICAST_IP"/>
									</div>

									<div id="cameraTypeLocal">
										<div class="help"><?php echo __('Choose camera from list');?></div>
										<select id="cameraTypeLocalList" size="6"></select>
									</div>
								</div>

								<div id="importCamListSection" style="width: 80%">
								<?php if ($brand !== 'CIRRUS'){ ?>
									<div class="help"><?php echo __('Choose file to upload');?></div>
									<div style="float: left;  width : 100%">
										<input id="file_upload" name="file_upload" type="file" style="width:100%;"/>
									</div>
									<div class="help"><?php echo __('Choose destination node');?></div>
									<div style="float : left; width : 100%;">
									    <select id="camimportNodeList"  style="width:56%;">
										<option selected value="auto">auto</option>
									    </select>
									</div>
									<div id="block_help_import">
										<p><?php echo __('CSV File Format');?><br/><hr/></p><p>
										<?php echo __('The file containing the camera information should be in plain text format.  There should be only one camera entry per line. Empty lines and lines beginning with "#" will be ignored.  Each camera entry should consist or 4 or 5 comma - separated values: ');?><br>
										<?php echo __('Camera Manufacturer, Model ID, Network Address, Input Number, Camera name, Location (optional), Name (optional), Password (optional), HTTP port (optional)');?>
										</p>
									</div>
								<?php } ?>
								</div>
							</div>
							<div class="wizard_section" id="wizard_step_2">
								<div class="help"><?php echo __('Enter camera Name and Location');?></div>
								<div class="description"><?php echo __('Camera Name');?></div>
								<input type="text" value="Axis camera" size="20" name="NAME"/>
								<div class="description"><?php echo __('Location');?></div>
								<input type="text" value="Room" size="20" name="LOCATION"/>
								<div class="description"><?php echo __('Media Format');?></div>
								<div class="mdformat" id="mdformat">
									<select name="MEDIA_FORMAT" id="MEDIA_FORMAT_undefined"></select>
								</div>
								<div class="description"><?php echo __('Image size');?></div>
								<div class="mdformat" id="imagesize">
									<select name="IMAGESIZE" id="IMAGESIZE_undefined"></select>
								</div>

								<div id="urlrtp">
									<div class="description"><?php echo __('RTP over TCP');?></div>
									<div class="mdformat" id="rtp_over_tcp">
										<select name="RTP_OVER_TCP" id="RTP_OVER_TCP_undefined">
											<option value="off" selected="true"><?php echo __('OFF');?></option>
											<option value="on"><?php echo __('ON');?></option>
										</select>
									</div>
									<div class="description"><?php echo __('RTP force Multicast');?></div>
									<div class="mdformat" id="rtp_force_multicast">
										<select name="RTP_FORCE_MULTICAST" id="RTP_FORCE_MULTICAST_undefined">
											<option value="off" selected="true"><?php echo __('OFF');?></option>
											<option value="on"><?php echo __('ON');?></option>
										</select>
									</div>
								</div>


								<div id="audiouniqueid">
								<div class="description"><?php echo __('Audio source');?></div>
								<div class="mdformat">
									<select name="AUDIO_UNIQUE_ID" id="AUDIO_UNIQUE_ID_undefined"></select>
								</div>
								</div>
								<div class="description"><?php echo __('Encoder Setting Override');?></div>
								<div class="mdformat" id="encoder_settings_override">
									<select name="ENCODER_SETTING_OVERRIDE" id="ENCODER_SETTING_OVERRIDE_undefined"></select>
								</div>

								<input type="text" name="PROTO" id="PROTO_undefined" style="display:none">
								<div class="help"><?php echo __('You entered data for camera:');?></div>
								<div class="description"><?php echo __('Camera model');?></div>
								<input type="text" value="axis" size="20" name="CAMERAMODEL" readOnly="true"/>
								<div class="description"><?php echo __('Model number');?></div>
								<input type="text" value="axis" size="20" name="MODELID" readOnly="true"/>
								<div class="description"><?php echo __('Model firmware');?></div>
								<input type="text" value="207" size="20" name="CAMERAFIRMWARE" readOnly="true"/>
								<div class="help"><?php echo __('Camera image:');?></div>
								<div id="camera_picture"></div>
							</div>
							<div class="wizard_section" id="wizard_import">
								<div class="help"><?php echo __('Camera import result');?></div>
								<div id="import_result">
								</div>
							</div>

							<div class="wizard_section tabs_manage_buttons_wrapper" id="next_step">
								<div id="div_cancel" style="width: 45%; float: left; text-align: right; padding: 5px;"><input type="button" id="next_cancel" value="<?php echo __('Cancel');?>"/></div>
								<div id="div_next" style="width: 45%; float: left; padding: 5px;"><input type="button" value="<?php echo __('Next');?>" id="next"/></div>
								<div id="div_ok" style="width: 45%; float: left; padding: 5px;"><input type="button" id="ok_button" value="<?php echo __('Ok');?>" /></div>
							</div>
						</div>
					</div>
					<div class="tabs_footer"></div>
				</div>
<?php
	}
?>
<?php
    if ($mode === "licensing")
    {
		?>
		<div id="systemsettingslist" style='display: none;'>
			<div class="item" data-setting="licensing" style='display: none;'>
				<!-- div class="name">Licensing</div -->
				<p>&nbsp;</p>
			</div>
		</div>
		<div id="licensing" class="block">
			<div class="tabs_menu">
				<div id="licensing_header" class="single_tab">
					<div class="tab_text"><?php print __("Product Licensing");?></div>
				</div>
			</div>
			<div id="licensing_content" class="tabs_content">
				<div id="need_activate" class="columns">
					<div class="help"><?php echo __('Serial Number');?></div>
					<input type="text" value="" size="20" name="SERIAL"/>
					<input type="button" value="<?php echo __('Online Registration');?>" size="10" name="PORTAL_SHOW_REGISTRATION" style="width:20%"/>
					<input type="button" value="<?php echo __('Manual Registration');?>" size="10" name="SHOW_MANUAL_REGISTRATION" style="width:20%"/>
				</div>
				<div id="portal_registration" style='display: none;'>
					<div class="help"><p><?php echo __('Thank you for purchasing videoNEXT product.');?></p>
						<p><?php echo __('videoNEXT product registration is quick, easy and secure.');?></p>
						<p><?php echo __('Your warranty is not affected by your decision to register or not, but your registration will allow us to serve your better over lifetime of your product.');?></p>
						<p><?php echo __('Registration will allow you to access our Customer Portal and get latest updates and documentation for your product.');?></p>
						<b><?php echo __('Please provide your:');?></b>
						<br />&nbsp;&nbsp;<?php echo __('Contact first name:');?>
						<br />&nbsp;&nbsp;<input type="text" value="" size="40" name="PORTAL_FIRST_NAME"/>
						<br />&nbsp;&nbsp;<?php echo __('Contact last name:');?>
						<br />&nbsp;&nbsp;<input type="text" value="" size="40" name="PORTAL_LAST_NAME"/>
						<br />&nbsp;&nbsp;<?php echo __('Email address:');?>
						<br />&nbsp;&nbsp;<input type="text" value="" size="40" name="PORTAL_EMAIL"/>
						<br />&nbsp;&nbsp;<?php echo __('Phone number (optional):');?>
						<br />&nbsp;&nbsp;<input type="text" value="" size="40" name="PORTAL_PHONE"/>
						<br />&nbsp;&nbsp;<?php echo __('Street address (optional):');?>
						<br />&nbsp;&nbsp;<input type="text" value="" size="40" name="PORTAL_ADDRESS"/>
						<br />
						<p>&nbsp;&nbsp;<input type="button" value="<?php echo __('Next');?>" size="20" name="SERIAL_CONFIRM"/></p>
					</div>
				</div>
				<div id="portal_skip_registration" style='display: none;'>
					<div class="help"><p><?php echo __('Are you sure you want to skip registration?');?></p>
						<p><?php echo __('Registration will provide you with added benefit of accessing our Customer Portal and getting latest updates and documentation for your product.');?></p>
						<p style="text-align:center">
							<input type="button" value="<?php echo __('Register');?>" size="20" name="PORTAL_SHOW_REGISTRATION"/>
							<input type="button" value="<?php echo __('Skip');?>" size="20" name="SERIAL_ACTIVATE"/>
						</p>
					</div>
				</div>
				<div id="license_ageement" style='display: none;'>
					<div id="license_frame" style="text-align:center; height: 470px; width:690px;">
						<!--iframe src="/common/sla.htm" frameborder="1" marginheight="0" marginwidth="0" align="left" height="450" width="690" scrolling="auto"></iframe-->
						<iframe src="/common/sla.htm" style=" border: 2px groove #aaa;" align="left" height="450" width="690" scrolling="auto"></iframe>
					</div>
					<p style="text-align:center">
						<input type="button" value="<?php echo __('I do NOT Agree ');?>" size="20" name="DO_NOT_AGREE_ACTIVATE"/>
						<input type="button" value="<?php echo __('I Agree');?>" size="20" name="AGREE_ACTIVATE"/>
					</p>
				</div>

				<div id="serial_conirmation" style='display: none;'>
					<div id="comfirm_information" class="help">
					</div>
					<p style="text-align:center">
						<input type="button" value="<?php echo __('Ok');?>" size="20" name="SERIAL_ACTIVATE"/>
						<input type="button" value="<?php echo __('Cancel');?>" size="20" name="PORTAL_SHOW_REGISTRATION"/>
						<input type="hidden" name="PORTAL_REGISTER"/>
					</p>
				</div>
				<div id="nolicense" style="display:none;"><?php echo __('License is not present');?></div>
				<div id="license_attributes">
				</div>
			</div>
			<div class="tabs_footer"></div>
		</div>
	</div>
</div>
<?php
	}
?>
</div>
</body>
</html>
