<?php
/*
# $id:$
#------------------------------------------------------------------------------
# creating cameras by import list of cameras from text file
# Sample SQL for getting list of cameras for importing
SELECT
	v1.val as CAMERAMODEL, v2.val as MODELID, v3.val AS DEVIP, v4.val as CAMERA, v5.val as NAME
FROM
	_objs, _obj_attr as v1, _obj_attr as v2, _obj_attr as v3, _obj_attr as v4, _obj_attr as v5
WHERE
	_objs.obj = v1.obj AND _objs.obj = v2.obj AND _objs.obj = v3.obj AND _objs.obj = v4.obj AND _objs.obj = v5.obj
	AND v1.attr = 'CAMERAMODEL' AND v2.attr = 'MODELID' AND v3.attr = 'DEVIP' AND v4.attr = 'CAMERA' AND v5.attr = 'NAME' AND deleted = 0;
#------------------------------------------------------------------------------
# Author: Alexey Tsibulnik
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
include('functions.php');

// Input data -------------------------------------
$error = $_FILES['file_upload']['error'];
$tmp_name = $_FILES['file_upload']['tmp_name'];
//-------------------------------------------------
$errorMsg = "";
$uploadfile = "";
$entriesPassed = 0;
$entriesRejected = array();
$nodeid = isset($_GET["nodeid"]) ? $_GET["nodeid"] : "auto";
$setid = intval($_GET["setid"]);
$set = new Set();
$add_to_set = false;
if (!isset($setid) || !$set->isExists($setid)) {
	$add_to_set = false;
}
else if (!$set->isProtected($setid)) {
	$add_to_set = true;
}
$uni = $nodeid == "auto" ? "" : Node::getUNI($nodeid);

if (!empty($error))
{
	switch($error)
	{
		case '1':
			$errorMsg = __('The uploaded file exceeds the upload_max_filesize directive in php.ini');
			break;
		case '2':
			$errorMsg = __('The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form');
			break;
		case '3':
			$errorMsg = __('The uploaded file was only partially uploaded');
			break;
		case '4':
			$errorMsg = __('No file was uploaded.');
			break;
		case '6':
			$errorMsg = __('Missing a temporary folder');
			break;
		case '7':
			$errorMsg = __('Failed to write file to disk');
			break;
		case '8':
			$errorMsg = __('File upload stopped by extension');
			break;
		case '999':
		default:
			$errorMsg = __('No error code avaiable');
	}
}
elseif(empty($tmp_name) || $tmp_name == __('none'))
{
	$errorMsg = __('No file was uploaded..');
}
else
{
	$uploadfile = dirname($tmp_name) . "/" . "camlist_" . basename($tmp_name);
	if (move_uploaded_file($tmp_name, $uploadfile) === FALSE)
	{
		$errorMsg = __("Cannot move uploaded file.");
	}
	else
	{
		/**
		 *
		 * Special logic: auto assign cameras to nodes
		 * We should choose node for every camera imported
		 * according to number of cameras on that node
		 *
		 **/
		function ncmp($a, $b) {
		    if ($a == $b) { return 0; }
		    return $a["count"] < $b["count"] ? -1 : 1;
		}

		if ($nodeid == "auto") {
			$node = new Node();
			$nlist = $node->getListWithNumberOfCameras();
			$masterUNI = Node::getUNI();
		}
		// Parse CSV file, extract camera entries
		$contents = file_get_contents($uploadfile);
		$arrEntries = preg_split("/\n/", $contents);
		$arrCams = array(); // Array of camera attributes
		// Get camera model list for validating entries
		$modelList = Camera::getModelList();
		foreach ($arrEntries as $num => $entry) {
			$entry = trim($entry);
			if($entry == '') continue;
			if($entry[0] == '#') continue;
			$elements_number = substr_count($entry, ",");
			if($elements_number < 4) {
				$entriesRejected[] = $num + 1;
				continue;
			}
			$requestAttr = array();
			$request = array();
			list (
				$requestAttr["CAMERAMODEL"],
				$requestAttr["MODELID"],
				$requestAttr["DEVIP"],
				$requestAttr["CAMERA"],
				$requestAttr["NAME"],
				$requestAttr["LOCATION"],
				$requestAttr["USRNAME"],
				$requestAttr["PASSWD"],
				$requestAttr["HTTP_PORT"]
			) = preg_split("/,/", $entry);
			foreach ($requestAttr as $key => $val) {
				$requestAttr[$key] = trim($val);
			}
			if(empty($requestAttr["CAMERAMODEL"]) || empty($requestAttr["NAME"])) {
				$entriesRejected[] = $num + 1;
				continue;
			}
			// Validate camera model
			if(!$modelList["error"]) {
				$ok = false;
				foreach($modelList as $model) {
					if(strtoupper($model["name"]) == strtoupper($requestAttr["CAMERAMODEL"])) {
						$requestAttr["CAMERAMODEL"] = $model["name"];
						$ok = true;
						break;
					}
				}
				if($ok == false) {
					$entriesRejected[] = $num + 1;
					continue;
				}
			}
			$requestAttr["ARCHSTATE"] = "off";
			if (! $requestAttr["HTTP_PORT"]) $requestAttr["HTTP_PORT"] = 80;
			// Push resulting camera attrs to $arrCams
			$request["attr"] = $requestAttr;
			$request["line"] = $num + 1;
			$request["obj"] = new Camera();
			$arrCams[] = $request;
		}

		// launch camera probing
		foreach ($arrCams as &$cam) {
			// add additional parameters for probe script
			$probeAttr = array();
			$probeAttr["CAMERAMODEL"] = $cam["attr"]["CAMERAMODEL"];
			$probeAttr["DEVIP"] = $cam["attr"]["DEVIP"];
			$probeAttr["HTTP_PORT"] = $cam["attr"]["HTTP_PORT"];
			$probeAttr["USRNAME"] = $cam["attr"]["USRNAME"];
			$probeAttr["PASSWD"] = $cam["attr"]["PASSWD"];
			$probeAttr["CAMERA"] = $cam["attr"]["CAMERA"];
			$probeAttr["probe_single_brand"] = "1";
			$probeAttr["force_probing"] = "1";
			$ticket = $cam["obj"]->getTicketForModel($probeAttr);
			$cam["ticket"] = $ticket;
		}
		//Wait for probing to complete
		$probeCompl = false;
		$maxWait = 15; // Wait for probing to complete
		$tStart = time();
		while (! $probeCompl && (time()-$tStart < $maxWait)) {
			sleep(1);
			$probeCompl = true;
			foreach ($arrCams as &$cam) {
				$response = $cam["obj"]->getModelByTicket($cam["ticket"]);
				if ( !isset($response["parameters"]) ||
				    ($response["parameters"]["state"] !== "OK" &&
				    $response["parameters"]["state"] !== "ERROR") )
				{
					$probeCompl = false;
					break;
				}
				else
				{
					$cam["probe"] = $response;
				}
			}
		}
		// Probing complete: process result
		foreach ($arrCams as &$cam) {
			if  ($cam["probe"]["parameters"]["state"] !== "OK") { // Probe failed
				//$entriesRejected[] = $cam["line"];
				//continue;
				error_log("Warning! Probing failed for entry at line ".$cam["line"]);
			} else {
				$cam["attr"]["CAMERAMODEL"] = $cam["probe"]["attributes"]["CAMERAMODEL"];
				$cam["attr"]["MODELID"] = $cam["probe"]["attributes"]["MODELID"];
				$cam["attr"]["CAMERAFIRMWARE"] = $cam["probe"]["attributes"]["FIRMWARE"];
				if (isset($cam["probe"]["attributes"]["MEDIA_FORMAT_LIST"]) && $cam["probe"]["attributes"]["IMAGESIZE_LIST"]) {
					$cam["attr"]["MEDIA_FORMAT_LIST"] = $cam["probe"]["attributes"]["MEDIA_FORMAT_LIST"];
					$cam["attr"]["IMAGESIZE_LIST"] = $cam["probe"]["attributes"]["IMAGESIZE_LIST"];
				}
			}

			// Find appropriate node for camera if $nodeid == "auto"
			if ($nodeid == "auto") {
				usort($nlist, "ncmp");
				$ind = 0;
				if (count($nlist) > 1 && $nlist[0]["uni"] == $masterUNI) {
					$ind = 1;
				}
				$uni = $nlist[$ind]["uni"];
			}

			// Create camera object for this entry
			DB::query("BEGIN;");
			$resp = $cam["obj"]->create($cam["attr"], $uni);
			if(is_array($resp) && $resp["error"]) {
				$entriesRejected[] = $cam["line"];
				continue;
			} else {
				$entriesPassed++;
				if ($nodeid == "auto") { $nlist[$ind]["number_of_cameras"]++; }
				if ($add_to_set) { $set->add($setid, $resp); }
			}
			DB::query("COMMIT;");
		}

		//Finally, remove CSV file
		@unlink($uploadfile);
	}
	//for security reason, we force to remove all uploaded file
	@unlink($_FILES[$fileElementName]);
}
sort($entriesRejected);
$result = array();
$result["error"] = $errorMsg;
$result["passed"] = $entriesPassed;
$result["rejected"] = $entriesRejected;

echo json_encode($result);
?>
