<?php
/*
# $Id: downloadimage.php 29902 2013-11-29 12:16:08Z teetov $
#------------------------------------------------------------------------------
# Return file to user
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

// Per-status camera snapshots: STATUS => URL
$CamStatus = array();
$CamStatus["OFF"] = "/TibcoGI/JSXAPPS/mx/images/design1/eLog2/camera_off.png";
$CamStatus["BROKEN"] = "/TibcoGI/JSXAPPS/mx/images/design1/eLog2/no_video_found.png";
$CamStatus["DOWN"] = "/TibcoGI/JSXAPPS/mx/images/design1/eLog2/no_video_found.png";
$CamStatus["STARTING"] = "/sdi/admin/img/noimage/noimage.165x165.jpg";
$CamStatus["starting"] = "/sdi/admin/img/noimage/noimage.165x165.jpg";
$CamStatus["stopping"] = "/sdi/admin/img/noimage/noimage.165x165.jpg";

if (isset($_GET['objid'])) {
	$objid = intval($_GET['objid'], 10);
	$uni = Obj::getUNI($objid);

	if (isset($_GET['width']) && isset($_GET['height'])) {
		$size = $_GET['width'].'x'.$_GET['height'].'.';
	} else {
		// If no width and height provided, get max size
		$size = '';
	}

	$DEADAFTER = 60; // Node is considered to be dead if UNI file isn't updated for a long time
	$stat = stat($_SERVER['APL']."/var/conf/master/nodes/$uni");
	$mtime = $stat[9];
	if (time() - $mtime > $DEADAFTER) {
	    header("location: /TibcoGI/JSXAPPS/mx/images/design1/eLog2/no_video_found.png");
	}
	else {
	    $cam = new Obj();
	    $url = "";
	    $status = $cam->getAttribute($objid, "STATUS");

	    if (!$status) {
		$url = $CamStatus["STARTING"]; // Perhaps, 'STATUS' attr wasn't set yet
	    }
	    else if (array_key_exists($status, $CamStatus)) {
		$url = $CamStatus[$status];
	    }
	    else if ($status == "ON") {
		$url = "/storage/snapshot?objid=$objid";
	    }
	    else {
		$url = $CamStatus["BROKEN"]; // Unknown status
	    }

	    header("location: $url");
	}
}


if (isset($_GET['picture']))
{
	$picture = $_GET['picture'];

	$picture_file_name = "";
	if (preg_match("/^\d+-.+-\d+\.(jpg|png|jpeg)$/i", $picture, $matches))
	{
		$picture_file_name = $matches[0];
	}

	$picture_file = $_SERVER['APL'] . "/var/probe/image/" . $picture_file_name;
	if ($picture_file_name != "" && !is_file($picture_file))
	{
		header('HTTP/1.0 404 Not Found');
		echo __("picture not found") . "\n";
		exit;
	}

	////////////////////////////////////////////////////////////////////////////////

	set_time_limit(0);
	header("Cache-Control: no-cache, must-revalidate");
	header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
	header('Content-type: image/jpg; name="' . $picture_file_name . '"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');

	////////////////////////////////////////////////////////////////////////////////
	$range = 0;
	if (isset($_SERVER['HTTP_RANGE']) && ($range = $_SERVER['HTTP_RANGE'])) {
		$range = str_replace('bytes=', '', $range);
		$range = intval(str_replace('-', '', $range), 10);
		$size = filesize($picture_file);

		header('HTTP/1.0 206 Partial Content');
		header('Content-Length: ' . ($size - $range));
		header('Content-Range: bytes ' . $range . '-' . ($size - 1) . '/' . $size);
	} else {
		header('HTTP/1.0 200 OK');
		header('Content-Length: ' . filesize($picture_file));
	}

	////////////////////////////////////////////////////////////////////////////////

	$file = fopen(escapeshellcmd($picture_file), 'rb');
	fseek($file, (int) $range);

	while (!feof($file) and !connection_status()) {
		echo fread($file, (1024 * 8));
		flush();
		ob_flush();
	}
}
?>
