<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

function http_fetch ($url, $timeout) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    $respond = curl_exec ($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close ($ch);

    return array (
	"respond" => $respond,
	"code"    => $httpCode
    );
}

// Fetch data from request
$userId = $_SESSION[SESSION_USERID];
$bCanView = false;
$bCanSetup = false;
$host=$_SERVER['SERVER_ADDR'];
$port=$_SERVER['SERVER_PORT'];
$uni = '';
$nodeid = 0;

$node = new Node();
if (!empty($_GET['obj']))
{
	$nodeid = intval($_GET['obj']);
	$uni = $node->getUNI($nodeid);
	if (!isset($uni))
	{
		exit("incorrect 'obj'");
	}
} else {
	exit("'obj' is empty");
}

// Have to find out whether user has Administrator privileges

$user = new User();
// Check for 'V' and 's' credential
// User should have right for 'View'
$bCanView = $user->checkObjectCredentials($userId, Obj::CONTROL_PANEL, "V") !== false;
if(!$bCanView) {
// i18n: ...
    exit(__("You aren't permitted to view this page"));
}

$nodeConf = $node->getAttributes($nodeid);

$conf_path = '/opt/sarch/var/conf/master/nodes';
$fStat = stat("$conf_path/$uni");
$mtime = gmstrftime("%Y-%m-%d %H:%M:%S", $fStat['mtime']);

// Now check SKM version via HTTP API
$api_call_str = "http://" . $nodeConf['IP'] . "/api/cgi-bin/vctl.pl?return=info";
$result = http_fetch($api_call_str, 2);
$configXML = $result["respond"];
$parser = xml_parser_create();
xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
xml_parse_into_struct($parser, $configXML, $values, $tags);
xml_parser_free($parser);
unset($tags);
unset($configXML);

foreach($values as $el) {
    if( ($el['tag'] == 'INFO') && ($el['type'] == 'open') ) {
		$nodeConf['VERID'] = $el['attributes']['VERID'];
		break;
    }
}

// Get SKM History via HTTP API
$nodeHistory = $nodeConf["HISTORY"];
if (isset($nodeHistory)) {
    $nodeHistory = json_decode($nodeHistory);
}

// Get total number of configured cameras,relas and sensors
$arrObjids = array();
$arrCams = array();
$cams_total = $sensors_total = $relays_total = "unknown";
$res = DB::select("select obj from _objs where otype='D' and subtype='C' and deleted=0 and node_ip='".$uni."'");
$cams_total = count($res);
foreach ($res as $row)	{
    array_push($arrObjids, array("objid"=>$row["obj"]));
    $arrCams[$row["obj"]] = array("health" => "unknown");
}
// ??? may be best use STATUS ???
$queryString =
	"SELECT _objs.obj
		FROM
			_objs, _obj_attr as attr
		WHERE
			_objs.deleted = 0
			AND _objs.subtype = 'C'
			AND _objs.otype = 'D'
			AND _objs.obj = attr.obj
			AND attr.attr = 'ARCHSTATE'
			and node_ip='".$uni."'
			AND attr.val = 'off';";
$list = DB::select($queryString, array());
$cams_offline = array();
foreach($list as $cam) {
	$cams_offline[$cam["obj"]] = $cam["obj"];
}

$count_cams_offline = count($list);

$res = DB::select("select obj from _objs where otype='D' and subtype='S' and deleted=0 and node_id='".$nodeid."'");
$sensors_total = count($res);
$res = DB::select("select obj from _objs where otype='D' and subtype='R' and deleted=0 and node_id='".$nodeid."'");
$relays_total = count($res);

// Get cameras health status via web service call
try
{
    $client = new SoapClient("http://s_master/axis2/services/ObjectManagementService?wsdl", array('trace' => 1));
	$client->__setCookie("PHPSESSID", session_id());
    $result = "";
    $result = $client->getObjects(
				    array("Filter" => array("ObjectListFilter" => $arrObjids))
				);
	// Ensure an array for singular results
	if (is_object($result->Object)) $arrResult[0] = $result->Object;
	else $arrResult = $result->Object;

    foreach($arrResult as $objref) {
		$objid  = $objref->objid;
	    $health = '';
	    foreach($objref->Properties->Property as $prop) {
			if($prop->name == 'health') { $health = $prop->value; }
	    }
	    $arrCams[$objid]["health"] = $health;
    }
}
catch (SoapFault $exception)
{
    if(isset($client->__last_response)) {
	$dom = new DOMDocument;
	if ($dom->loadXML($client->__last_response))
	{
		$nodeList = $dom->getElementsByTagName("Object");
		foreach ($nodeList as $node)
		{
		    $propList = $node->getElementsByTagName("Property");
		    foreach($propList as $prop) {
			if($prop->getAttribute("name") == "health") {
			    $arrCams[$node->getAttribute("objid")]["health"] = $prop->getAttribute("value");
			 }
		    }
		}
	}
    }
}
catch (Exception $ex) {}

// Now count healthy and sick cameras
$cams_healthy = 0;
$cams_broken = 0;
foreach($arrCams as $obj => $cam) {
    if(isset($cam["health"]) && $cam["health"] == 2 && !isset($cams_offline[$obj])) $cams_healthy++;
}

// Retrieve brief hardware statistics from node
$nodeStats = Node::getStatistics($uni);

if ( $nodeStats && count( $nodeStats ) > 0 ) {
    $loadavg = $nodeStats["STAT_LOAD_AVERAGE"]["val"];
    $root_usage = $nodeStats["STAT_ROOT_USAGE"]["val"];
    $cache_usage = $nodeStats["STAT_CACHE_USAGE"]["val"];
    $var_usage = $nodeStats["STAT_VAR_USAGE"]["val"];
    $aplvar_usage = $nodeStats["STAT_APLVAR_USAGE"]["val"];

    // Convert uptime in human readable form
	$uptime = $nodeStats["STAT_UPTIME"]["val"];
    if ($uptime)
    {
		$d = floor($uptime/86400);
		$h = floor( ($uptime - $d * 86400) / 3600);
		$m = floor( ($uptime - $d * 86400 - $h * 3600) / 60);
		$uptime = ($d ? "$d days, " : "") . ($h ? "$h hours, " : "") . "$m min";
    }
}

// Find out node status
$isDead = $node->isDead($uni);
$isMaster = $node->getUNI() == $uni;

$statusHtml = $isDead ? "<font color='red'>OFFLINE</font>" : "<font color='green'>ONLINE</font>";

// check special credentials
$scFullDevice = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "F");
$scDeviceSettings = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "f");
$scDevicePolicy = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "R");
$scDeviceAnalytics = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "E");

?>
<!DOCTYPE html>
<html>
<head>
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID001_BEGIN -->
	<title><?php echo /* i18n: Page tittle */ __('Node Statistics');?></title>
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID001_END -->
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/global/editor.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/require.js"></script>
	<script>
		var scFullDevice = <?=$scFullDevice ? "true" : "false";?>;
		var scDeviceSettings = <?=$scDeviceSettings ? "true" : "false";?>;
		var scDevicePolicy = <?=$scDevicePolicy ? "true" : "false";?>;
		var scDeviceAnalytics = <?=$scDeviceAnalytics ? "true" : "false";?>;

		require(["nodeinfo"], function(nodeinfo){
			"use strict";
			nodeinfo.createNodeEditor(<?=$nodeid;?>);
		});
	</script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID002_BEGIN -->
					<?php print __("Node Information");?>
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID002_END -->
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div id="editor"></div>
            <div id="main">
				<div id="nodestatus" style="padding-top: 10px; padding-left: 15px">
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID003_BEGIN -->
					<h2 style="text-align: left; padding-left: 20px"><?php echo /* i18n: Table name */ __('Node Status');?></h2>
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID003_END -->
					<table cellspacing="2" cellpadding="4" width="500" class="border_table">
						<thead style="gray">
							<tr class="configitems"><th><?php echo /* i18n: Fields names */ __('Attribute');?></th><th><?php echo /* i18n: ... */ __('Current Value');?></th></tr>
						</thead>
					<tbody>
					<tr class="tablestyle">
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID004_BEGIN -->
						<td><?php echo /* i18n: ... */ __('Node Status'); ?></td>
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID004_END -->
				<?php
					if ($isDead && !$isMaster) { // Node offline (slave node - can remove)
				?>
						<td><b><font color="red"><?php echo  __('OFFLINE'); ?></font></b></td>
				<?php
					}	else if (!$isDead || $isMaster){ // Node online
				?>
						<td><b><?php echo $statusHtml ?></b></td>
				<?php
				}
				?>
					</tr>
					</tbody>
					</table>
				</div>
                <div id="nodeinfo" style="padding-top: 10px; padding-left: 15px">

<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID005_BEGIN -->
					<h2 style="text-align: left; padding-left: 20px"><?php echo /* i18n: Table name */ __('Node Summary');?></h2>
<!-- CLARE_REPLACE_ADMIN_NODEINFO_PHP_ID005_END -->
                    <table cols="2" width="500" cellspacing="2" cellpadding="4" class="border_table">
						<thead style="gray">
							<tr class="configitems"><th><?php echo /* i18n: Fields names */ __('Attribute');?></th><th><?php echo /* i18n: ... */ __('Current Value');?></th></tr>
						</thead>
						<tbody>
						<tr class="tablestyle"><td><?php echo /* i18n: Rowss names */ __('ID');?></td><td><? echo $uni ?></td></tr>
						<tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Name');?></td><td><? echo $nodeConf['FQDN'] ?></td></tr>
						<tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Network ID');?></td><td><? echo $nodeConf['FQDN'] ?></td></tr>
						<tr class="tablestyle"><td><?php echo /* i18n: ... */ __('IP');?></td><td><? echo $nodeConf['IP'] ?></td></tr>
						<tr class="tablestyle"><td><?php echo /* i18n: ... */ __('RTSP Port');?></td><td><? echo $nodeConf['RTSP_PORT'] ?></td></tr>
						<tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Version');?></td><td><? echo $nodeConf['VERID'] ?></td></tr>
						<tr class="tablestyle"><td><?php echo /* i18n: ... */ __('RTSP URI');?></td><td><? echo htmlspecialchars($nodeConf['URI']); ?></td></tr>
						</tbody>
                    </table>
                </div>
				<div id="caminfo" style="padding-top: 10px; padding-left: 15px">
					<h2 style="text-align: left; padding-left: 20px"><?php echo /* i18n: Table name  */ __('Device Statistics:');?></h2>
					<table cols="4"  width="500" cellspacing="2" cellpadding="4" class="border_table">
					<tbody>
					<tr class="configitems" align="center"><th>&nbsp;</th><th><?php echo /* i18n: Fields names */ __('Configured');?></th><th><?php echo /* i18n: ... */ __('Operational');?></th><th><?php echo /* i18n: ... */ __('Broken');?></th><th><?=__('Offline');?></th></tr>
					<tr class="tablestyle" align="center"><td align="left"><?php echo /* i18n: Rowss names */ __('Cameras');?></td><td><?echo $cams_total?></td><td><?echo $cams_healthy?></td><td><?echo $cams_total-$cams_healthy-$count_cams_offline?></td><td><?=$count_cams_offline?></td></tr>
					<tr class="tablestyle" align="center"><td align="left"><?php echo /* i18n: ... */ __('Relays');?></td><td><?echo $relays_total?></td><td>-</td><td>-</td><td>-</td></tr>
					<tr class="tablestyle" align="center"><td align="left"><?php echo /* i18n: ... */ __('Sensors');?></td><td><?echo $sensors_total?></td><td>-</td><td>-</td><td>-</td></tr>
					</tbody>
					</table>
				</div>

				<div id="hwhistory" style="padding-top: 10px; padding-left: 15px">
					<h2 style="text-align: left; padding-left: 20px"><?php echo __('History');?></h2>
					<table cols="2" border="0" width="500" cellspacing="2" cellpadding="4" class="border_table">
						<thead style="gray">
							<tr class="configitems"><th><?php echo /* i18n: Fields names */ __('Attribute');?></th><th><?php echo /* i18n: ... */ __('Current Value');?></th></tr>
						</thead>
						<tbody>
						<?php
						for ($i = 0; $i < count($nodeHistory); $i++)
						{
						?>
							<tr class="tablestyle"><td><?php echo $nodeHistory[$i]->ACTION;?></td><td><? echo $nodeHistory[$i]->DATE; ?></td></tr>
						<?php } ?>
						</tbody>
					</table>
				</div>

				<?php
					if (!$isDead) { // Node offline
				?>
                <div id="hwinfo" style="padding-top: 10px; padding-left: 15px">
            	    <h2 style="text-align: left; padding-left: 20px"><?php echo /* i18n: Table name  */ __('Hardware Statistics');?></h2>
            	    <table cols="2" cellspacing="2" cellpadding="4" width="500" class="border_table">
            	    <tbody>
		    		<tr class="configitems" align="center"><th><?php echo /* i18n: Fields names */ __('Attribute');?></th><th><?php echo /* i18n: ... */ __('Current Value');?></th></tr>
            	    <tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Uptime');?></td><td><?echo $uptime?></td></tr>
            	    <tr class="tablestyle"><td><?php echo /* i18n: Rows names */ __('Load Average');?></td><td><?echo $loadavg?></td></tr>
            	    <tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Disk Usage (/)');?></td><td><?echo $root_usage?>%</td></tr>
            	    <tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Disk Usage (/var)');?></td><td><?echo $var_usage?>%</td></tr>
            	    <tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Disk Usage (/var/sarch)');?></td><td><?echo $aplvar_usage?>%</td></tr>
            	    <tr class="tablestyle"><td><?php echo /* i18n: ... */ __('Cache Usage');?></td><td><?echo $cache_usage?>%</td></tr>
            	    </tbody>
            	    </table>
                </div>
				<?php } ?>
			</div>
			<br>

		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
