<?php
/**
 * @version $Id: validate.php 33167 2015-10-14 22:47:31Z astarostin $
 * ------------------------------------------------------------------------------
 * Merge several js files into one with validate functions
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$type = $_GET["type"];
$model = $_GET["model"];

$pathList = array();
array_push($pathList, $_SERVER["APL"] . "/conf/etc/device/default/js/validate.js");

if (isset($type))
{
	if ($type == 'camera' || $type == 'relay' || $type == 'door' || $type == 'sensor_skm' || $type == 'sensor_acsg' || $type == 'gateway')
	{
		// path to default camera
		array_push($pathList, APL_PATH . "/conf/etc/device/$type/default/js/validate.js");
		if (isset($model))
		{
			// path to camera
			array_push($pathList, APL_PATH . "/conf/etc/device/$type/$model/js/validate.js");
		}

		$VAEList = Node::getVAEList();
		foreach($VAEList as $vae => $vaePath)
		{
			// path to default camera
			array_push($pathList, "$vaePath/etc/$type/default/js/validate.js");
			if (isset($model))
			{
				// path to camera
				array_push($pathList, "$vaePath/etc/$type/$model/js/validate.js");
			}
		}
	} else
	if ($type == 'schedule' || $type == 'posture' || $type == 'timecard')
	{
		array_push($pathList, APL_PATH . "/conf/etc/schedule/js/validate.js");
		array_push($pathList, APL_PATH . "/conf/etc/schedule/$type/default/js/validate.js");
		if (isset($model))
		{
			array_push($pathList, APL_PATH . "/conf/etc/schedule/$type/$model/js/validate.js");
		}
	} else
	if ($type == 'monitor' || $type == 'wall' || $type == 'vmxlayout')
	{
		array_push($pathList, APL_PATH . "/conf/etc/vmx/js/validate.js");
		array_push($pathList, APL_PATH . "/conf/etc/vmx/$type/default/js/validate.js");
		if (isset($model))
		{
			array_push($pathList, APL_PATH . "/conf/etc/vmx/$type/$model/js/validate.js");
		}
	} else
	if ($type == 'user')
	{
		array_push($pathList, APL_PATH . "/conf/etc/user/js/validate.js");
	} else
	if ($type == 'gui')
	{
		array_push($pathList, APL_PATH . "/conf/etc/identity/js/validate.js");
	}
}

header("Content-Type: application/x-javascript");

foreach ($pathList as $path)
{
	if (is_file($path))
		readfile($path);
}
