(function(){
	"use strict";

	$(document).ready(function(){

		AMQ
			.subscribe("topic://uploadProgress_" + readCookie("PHPSESSID"), function(messageList){
				messageList.forEach(function(message){
					var response = JSON.parse(message);
					$(".progress").html("Parsing " + response.progress);
				});
			});

		var time;
		var prevBytesComplete;
		var speed = 0;

		var swfu = new SWFUpload({
			upload_url: "/sdi/admin/upload_video_file.php",
			post_params: {"PHPSESSID": readCookie("PHPSESSID")},
			flash_url: "/sdi/admin/js/swfupload.swf",
			file_post_name: "upload_video",
			button_placeholder_id: "upload_button",
			button_image_url: "img/add_obj.png",
	        button_width: "27",
	        button_height: "15",
	        button_cursor: SWFUpload.CURSOR.HAND,
			button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
	        //button_text: "Upload",
			upload_start_handler: function(file)
			{
				return true;
			},
			upload_success_handler: function(file, server_data, receivedResponse)
			{
				var data = JSON.parse(server_data);
				uploadComplete(data);
			},
			swfupload_loaded_handler: function()
			{
				console.log("swfupload_loaded_handler");
			},
			file_dialog_start_handler: function ()
			{
				console.log("file_dialog_start_handler");
			},
			file_queued_handler: function ()
			{
				console.log("file_queued_handler");
			},
			file_queue_error_handler: function ()
			{
				console.log("file_queue_error_handler");
			},
			file_dialog_complete_handler: function(numFilesSelected, numFilesQueued)
			{
				if (numFilesQueued > 0) {
					$(".progress").html("");
					$(".result").html("");
					$(".log").html("");
					time = Date.now();
					prevBytesComplete = 0;
					$(".select_wrapper").mask({text: __("Uploading files, please wait")});
					this.startUpload();
				}
			},
			upload_progress_handler: function(file, bytesComplete, totalBytes)
			{
				var percentage =  (bytesComplete / totalBytes) * 100;
				percentage = (percentage | 0) + ((percentage % 1) * 100 | 0) / 100;

				var text = percentage + "%";

				if (Date.now() - time > 1000)
				{
					time = Date.now();
					speed = (bytesComplete - prevBytesComplete) / 1000000;
					speed = (speed | 0) + ((speed % 1) * 100 | 0) / 100;
					prevBytesComplete = bytesComplete;
				}

				text += "<br/>" + speed + " Mb/s"

				$(".progress").html(text);
			},
			upload_error_handler: function (file, size, code)
			{
				console.log("upload_error_handler");
			},
			upload_complete_handler: function (file)
			{
				console.log("upload_complete_handler");
				$(".select_wrapper").unmask();
			},
			debug_handler: function(message)
			{
				console.log(message);
			}
		});

		$(".tabs_content button").click(function(){
			$(".tabs_content").mask({text: __("Uploading files, please wait")});

			$.ajaxFileUpload({
				url: '/sdi/admin/upload_video_file.php',
				secureuri: false,
				fileElementId: 'upload_video',
				dataType: 'json',
				success: function(data, status){
					$(".tabs_content").unmask();

					if(typeof(data.error) != 'undefined')
					{
						uploadComplete(data);
					}
				},
				error: function(data, status, e){
					Log.error(e);
				}
			});
		});
	});

	function uploadComplete(data)
	{
		$(".progress").html("");

		if(data.error != '')
		{
			Log.error(data.error);
		} else {
			var htmlLog = "<strong>Log:</strong><br/>";
			for (var i= 0; i < data.result.log.length; i++)
			{
				var row = data.result.log[i];
				htmlLog += row[0] + ": " + row[1] + "<br/>";
			}
			$(".log").html(htmlLog);

			var htmlResult = "<strong>Created cameras:</strong><br/>";
			for (var cameraId in data.result.timestamp)
			{
				var camera = data.result.timestamp[cameraId];
				var timestamp = parseInt(camera.timestamp) * 1000;
				var date = new Date();
				date.setTime(timestamp);
				var month = date.getMonth() + 1;
				var dateString = date.getFullYear() + "/" + month + "/" + date.getDate() + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();

				var name = camera.name;
				htmlResult += dateString + ' <a href="/sdi/admin/#set_14/camera_' + cameraId + '" target="blank">[' + cameraId + "] " + name + '</a><br/>';
			}
			$(".result").html(htmlResult);
		}
	}
})();
