/**
 * @version $Id: cred.js 22542 2011-04-26 15:55:58Z stsibulskiy $
 * ------------------------------------------------------------------------------
 * Logic for credentiall manegment
 * Initialising
 * iCredentialsEditor.init(type, selector)
 * type = (user|role|user)
 * dynamicaly load cred.php and atach it to selector
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

define("scheduler", ["jquery", "log", "fullcalendar", "api", "editor", "jquery.timePicker"], function(){
"use strict";

var Editor = require("editor");

Date.prototype.copy = function () {
  return new Date(this.getTime());
};

Date.prototype.lastday = function() {
  var d = new Date(this.getFullYear(), this.getMonth() + 1, 0);
  return d.getDate();
};

Date.prototype.getDaysBetween = function(d) {
  d = d.copy();
  d.setHours(this.getHours(), this.getMinutes(), this.getSeconds(), this.getMilliseconds());
  var diff = d.getTime() - this.getTime();
  return (diff)/this.msPERDAY;
};

Date.prototype.addDaysRet = function(d) {
	var dd = this.copy();
	dd.setDate( this.getDate() + d );
	return dd;
};

Date.prototype.addDays = function(d) {
  this.setDate( this.getDate() + d );
};

Date.prototype.addWeeksRet = function(w) {
	var dd = this.copy();
	dd.addDays(w * 7);
	return dd;
};

Date.prototype.addWeeks = function(w) {
  this.addDays(w * 7);
};

Date.prototype.addMonths= function(m) {
  var d = this.getDate();
  this.setMonth(this.getMonth() + m);

  if (this.getDate() < d)
    this.setDate(0);
};

Date.prototype.addMonthsRet = function(m) {
	var dd = this.copy();
	dd.addMonths(m);
	return dd;
};

Date.prototype.addYears = function(y) {
  var m = this.getMonth();
  this.setFullYear(this.getFullYear() + y);

  if (m < this.getMonth()) {
    this.setDate(0);
  }
};

Date.prototype.addYearsRet = function(y) {
	var dd = this.copy();
	dd.addYears(y);
	return dd;
};

Date.prototype.getMonthsBetween = function(d) {
  var sDate, eDate;
  var d1 = this.getFullYear() * 12 + this.getMonth();
  var d2 = d.getFullYear() * 12 + d.getMonth();
  var sign;
  var months = 0;

  if (this == d) {
    months = 0;
  } else if (d1 == d2) { //тот же год и месяц
    months = (d.getDate() - this.getDate()) / this.lastday();
  } else {
    if (d1 <  d2) {
      sDate = this;
      eDate = d;
      sign = 1;
    } else {
      sDate = d;
      eDate = this;
      sign = -1;
    }

    var sAdj = sDate.lastday() - sDate.getDate();
    var eAdj = eDate.getDate();
    var adj = (sAdj + eAdj) / sDate.lastday() - 1;
    months = Math.abs(d2 - d1) + adj;
    months = (months * sign)
  }
  return months;
};

Date.prototype.getEarly = function(d) {
	var d1 = this.copy();
	var d2 = d.copy();
	var d1TS = d1.valueOf();
	var d2TS = d2.valueOf();
	this.setTime(Math.min(d1TS, d2TS));
};

Date.prototype.getEarlyRet = function(d) {
	var d1 = this.copy();
	var d2 = d.copy();
	var d1TS = d1.valueOf();
	var d2TS = d2.valueOf();
	return d1.setTime(Math.min(d1TS, d2TS));
};
Date.prototype.isEarly = function(d) {
	var d1TS = this.valueOf();
	var d2TS = d.valueOf();
	return d1TS <= d2TS;
};


function clone(obj){
    if(obj == null || typeof(obj) != 'object')
        return obj;
    var temp = new obj.constructor();
    for(var key in obj)
        temp[key] = clone(obj[key]);
    return temp;
}

function cloneown(obj){
    if(obj == null || typeof(obj) != 'object')
        return obj;
    var temp = new obj.constructor();
    for(var key in obj) if (obj.hasOwnProperty(key)) {
        temp[key] = cloneown(obj[key]);
	}
    return temp;
}

var iSchedulerEditor = {
	isDebug: false,
	list: {
		was: {
			posture: {},
			schedule: {},
			device: {},
			device2schedule: {}
		},
		now: {
			posture: null,
			schedule: null,
			device: null,
			device2schedule: null
		}
	},
	selected: {
		posture: null,
		schedule: null,
		device: null
	},

	currentType: null,
	attrList: [],

	isDevice2scheduleListChanged: false,
	oldDevice2ScheduleList: [],

	editor: null,
	isEvents: false,
	id: null,
	systemObject: null,
	currschedule: null,
	timecardArray: null,
	newTimeCardID: 0,
	datefrom: 0,
	dateto: 0,
	scheduleInfo: {},
	eventSource:[],
	editWindowInfo:{},
	isNeedToSaveScheduleInfo: false,
	scheduleNameList: [],
	tmpevent: {},
	hashArr: [],
	lasthash: '',
	doChangeHash: true,


	init: function(type, id)
	{
		iSchedulerEditor.attrList = [];
		if (!id)
			return;

		iSchedulerEditor.id = "#schedulerManager";

		iSchedulerEditor.currentType = (type == "posture" || type == "schedule" ) ? type : null;
		if (!iSchedulerEditor.currentType)
		{
			Log.error(__("Incorrect mode"));
			return;
		}

		iSchedulerEditor.isDebug && Log.info(__("Loading..."));

		var initEditor = function()
		{
			var caption = iSchedulerEditor.currentType.charAt(0).toUpperCase() + iSchedulerEditor.currentType.substring(1, iSchedulerEditor.currentType.length) + " Manager";
			$(iSchedulerEditor.id + " .single_tab:first .tab_text").html(caption);

			var row;
			// init variables
			for (row in iSchedulerEditor.list.was)
			{
				iSchedulerEditor.list.was[row] = {};
			}
			for (row in iSchedulerEditor.list.now)
			{
				iSchedulerEditor.list.now[row] = null;
			}
			for (row in iSchedulerEditor.selected)
			{
				iSchedulerEditor.selected[row] = null;
			}

			iSchedulerEditor.addEvents();


			if (window.location.hash == ""){
				$("#schedule select[class=objectList]").trigger("change");
			}else
				iSchedulerEditor.onChangeHash();
		};


		// check_event if editor already on screen
		if ($(iSchedulerEditor.id).length == 0)
		{
			$(id).load("scheduler.php", function(){
				initEditor();
			});

		} else {
			if (iSchedulerEditor.doChangeHash){
				initEditor();
			}
		}

		$( "#t_date_from" ).datepicker(
			{ dateFormat: 'yy-mm-dd' }
		);
		$( "#t_date_to" ).datepicker({
			dateFormat: 'yy-mm-dd'
		});

	},

	onChangeHash: function()
	{
		if (iSchedulerEditor.doChangeHash !== false){
			var hash = window.location.hash;

			if (hash != "")
			{
				// delete # from hash
				var tmphash = hash.substring(1, hash.length);
				// get array of of objects (actions) from path
				iSchedulerEditor.hashArr = tmphash.split('/');
				iSchedulerEditor.lasthash = tmphash;
				if (iSchedulerEditor.hashArr.length > 0)
					iSchedulerEditor.lasthash = iSchedulerEditor.hashArr[iSchedulerEditor.hashArr.length-1];
			}

			var match, type;
			if (iSchedulerEditor.lasthash == 'schedule_manager')
			{
				iSchedulerEditor.initScheduleManagement(null);
			} else
			if (match = iSchedulerEditor.lasthash.match(/^schedule_manager_(\d+)/i))
			{
				var obj = match[1];
				type = match[0];
				iSchedulerEditor.initScheduleManagement(obj);
			}
		}else{
			iSchedulerEditor.doChangeHash = true;
		}

		function getObjectNameList (params, callback)
		{
			var id = params.id || null;
			var objList = params.objList || null;
			var type = params.type || null;
			var data = {'function': 'getObjectList'};
			if (type){
				data.type = type;
				if (type == 'node') data.withAttributes = true;
			}
			if (objList){
				data.objList = JSON.stringify(objList);
			}
			if (!id)
				return;

			$.ajax({
				url: "/api/call.php",
				data: data,
				dataType: "json",
				cache: false,
				async: false,
				beforeSend: function(XMLHttpRequest)
				{
					//$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown)
				{
					//$(id).html('');
				},
				complete: function()
				{
				},
				success: function(json)
				{
					if (json.error !== "")
					{
						Log.error(json.error);
					} else {
						var objectList = json.list;
						var objParamList = [];
						// get children
						if (objectList)
						{
							for (var num in objectList)
							{
								var obj = objectList[num]["obj"];
								objParamList[obj] = [];
								objParamList[obj]['name'] = objectList[num]["name"];
								if (objectList[num]["udid"])
									objParamList[obj]['udid'] = objectList[num]["udid"];
								else objParamList[obj]['udid'] = '';
								if (type) {
									objParamList[obj]['type'] = type;
									objParamList[obj]['template'] = type;
									objParamList[obj]['fullname'] = objParamList[obj]['type'] + " [" + objParamList[obj]["udid"] + "]: "  + objParamList[obj]["name"];
									if (type == 'set'){
										if (obj < 99)
											objParamList[obj]['fullname'] = __("System Sets") + ": " + objParamList[obj]['name'];
										else
											objParamList[obj]['fullname'] = __("User Sets") + ": " + objParamList[obj]['name'];
									}
									if (type == 'node'){
										objParamList[obj]['fullname'] = __("Node") + ": " + objectList[num]['attributes']['HOST'];
									}
								}
								else{
									var otype = objectList[num]["otype"];
									var subtype = objectList[num]["subtype"];
									var iAdmin = require("iadmin");
									objParamList[obj]['type'] = iAdmin.objectTypes[otype][subtype]["name"];
									objParamList[obj]['template'] = iAdmin.objectTypes[otype][subtype]["template"];
									objParamList[obj]['location'] = objectList[num]["location"];
									objParamList[obj]['fullname'] = objParamList[obj]['type'] + " [" + objParamList[obj]["udid"] + "]: "  + objParamList[obj]["name"];
								}
							}
						}
						if (!type){
							getObjectNameList({id: "#list .tabs_content", type: 'set'},
								function(objParamListSet){
									for (var objid in objParamListSet)
									{
										objParamList[objid] = objParamListSet[objid];
									}
								}
							);
							getObjectNameList({id: "#list .tabs_content", type: 'node'},
								function(objParamListSet){
									for (var objid in objParamListSet)
									{
										objParamList[objid] = objParamListSet[objid];
									}
								}
							);
						}
						callback(objParamList);
					}
				}
			});
		}

		var backnameHtml = '';
		if (iSchedulerEditor.hashArr.length>1 && iSchedulerEditor.lasthash.match(/^schedule_manager_(\d+)/i)){
			var objList = [];
			var backpath = iSchedulerEditor.hashArr;
			for (var i=0; i<backpath.length-1; i++){
				var objStruct = backpath[i].split('_');
				objList[i] = objStruct[1];
			}
			getObjectNameList({id: "#lbreadcumbs", objList: objList},
				function(objParamList){
					var backpathdevice = '';

					var backpath = iSchedulerEditor.hashArr;
					for (var i=0; i<backpath.length-1; i++){
						if (backpathdevice == '')
							backpathdevice += '#' + backpath[i];
						else backpathdevice += '/' + backpath[i];
						var objStruct = backpath[i].split('_');
						var objID = objStruct[1];
						var fullname = backpath[i];
						if (objParamList[objID])
							fullname = objParamList[objID]['fullname'];
						// get obj info from obj= ID from backpath[i]
						backnameHtml +=
							'<a href=' + backpathdevice + ' style="text-decoration:underline">' + fullname + '</a> > ';
					}
					if(backnameHtml !== ''){
						$("#breadcumbs").html(backnameHtml + __("Schedule Manager"));
						$("#breadcumbs").show();
					}else{
						$("#breadcumbs").html("");
						$("#breadcumbs").hide();
					}
				}
			);
		}else{
			$("#breadcumbs").html("");
			$("#breadcumbs").hide();
		}


	},

	addEvents: function()
	{
		if (iSchedulerEditor.isEvents)
			return;

		iSchedulerEditor.isEvents = true;
		$("#editor_sch .editor_close").click(function(){
			iSchedulerEditor.destroyEditor();
		});

	// Modal window
    $('a[name=modal]').click(function(e) {
		e.preventDefault();
		var id = $(this).attr('href');
		iSchedulerEditor.openModal(id);
	});

	$("#editdevices").click(function(){
		// open device editor
		iSchedulerEditor.fillDevice2ScheduleList({
			scheduleid: iSchedulerEditor.currschedule,
			filter: $("#device2schedule .objectFilter").val(),
			callback: function()
			{
				iSchedulerEditor.fillDeviceList({ except: iSchedulerEditor.list.was.device2schedule, filter: $("#devices .objectFilter").val()});
				iSchedulerEditor.oldDevice2ScheduleList = iSchedulerEditor.getDevice2ScheduleList();
			}
		});

		iSchedulerEditor.openModal("#dialog-devices", 100, 100);
	});

	$("#editpostures").click(function(){
		// open device editor
		iSchedulerEditor.openModal("#dialog-postures", 100, 100);
	});

	$("#b_craate_tc").click(function(){
		// get datefro, dateto
		// add event to calendar
		var datefrom = iSchedulerEditor.datefrom;
		var dateto = iSchedulerEditor.dateto;
		var name = $("#addposturelist").val();

		// retrieve the dropped element's stored Event Object
		var originalEventObject = {'postureid': 100};
		var copiedEventObject = $.extend({}, originalEventObject);

		// assign it the date that was reported
		copiedEventObject.title = 'Title ' + name;
		copiedEventObject.start = datefrom;
		copiedEventObject.end = dateto;
		copiedEventObject.allDay = false;
		copiedEventObject.id = ++iSchedulerEditor.newTimeCardID;
		$('#calendar').fullCalendar('renderEvent', copiedEventObject, true);
		$('#mask, .window').hide();
	});

	$("#b_save_tc").click(function(){
		// datefrom = iSchedulerEditor.datefrom;
		// dateto = iSchedulerEditor.dateto;
		var name = $("#addposturelist").val();

		//распарсить дату и время
		var arr_date_f = $("#t_date_from").val().split('-');
		var arr_date_t = $("#t_date_to").val().split('-');
		var arr_time_f = $("#t_time_from").val().split(':');
		var arr_time_t = $("#t_time_to").val().split(':');

		// получить дату из пикеров
		var datefromDP = $( "#t_date_from" ).datepicker( "getDate" );
		var datetoDP = $( "#t_date_to" ).datepicker( "getDate" );

		// получить время из пикеров
		var timefromDP = $.timePicker("#t_time_from").getTime();
		var timetoDP = $.timePicker("#t_time_to").getTime();

		var d = datefromDP.getDate();
		var m = datefromDP.getMonth();
		var y = datefromDP.getFullYear();
		var hh = timefromDP.getHours();
		var mm = timefromDP.getMinutes();
		datefromDP.setHours(hh);
		datefromDP.setMinutes(mm);
		var hh = timetoDP.getHours();
		var mm = timetoDP.getMinutes();
		datetoDP.setHours(hh);
		datetoDP.setMinutes(mm);
		var datefrom = new Date(datefromDP.getTime());
		var dateto = new Date(datetoDP.getTime());
		var currdate = new Date();
		if(datefrom.valueOf()>dateto.valueOf()){
			alert(__("Start time of event should be early of End time"));
			return false;
		}
		if(currdate.valueOf()>datefrom.valueOf()){
			alert(__("Could not move star time to past."));
			// TODO: rem only for developing
			//return false;
		}

		var datefromTS = datefrom.valueOf()/1000 - datefrom.getTimezoneOffset()*60;
		var datetoTS = dateto.valueOf()/1000 - dateto.getTimezoneOffset()*60;

		// retrieve the dropped element's stored Event Object
		var originalEventObject = {};
		var copiedEventObject = $.extend({}, originalEventObject);

		// assign it the date that was reported
		//copiedEventObject.title = $("#t_posturename").val();
		copiedEventObject.title = $("#t_posturename").text();
		copiedEventObject.start = datefrom;
		copiedEventObject.end = dateto;
		copiedEventObject.allDay = false;
		copiedEventObject.id = $("#h_tcid").val()*1;

		var timecardid = $("#h_tcid").val()*1;
		var postureid = iSchedulerEditor.editWindowInfo["postureid"]*1;
		var timecardinfo = {};
		var tc_start = datefrom;
		var tc_end = dateto;
		var tc_allDay = false;
		var tc_rrule = {};
			var tc_frequency = '';
			var tc_interval = '';
			var tc_interval_arr = [];
			var tc_interval = '';
			var tc_count = '';
			var tc_until = '';
		if($("#cb_repeat").prop("checked")){

			var tc_frequency_val = $("#s-frequency").val();
			switch (tc_frequency_val)
			{
				case "0":
					tc_frequency = "DAILY";
				break;
				case "1":
					tc_frequency = "WEEKLY";
				break;
				case "2":
					tc_frequency = "WEEKLY";
				break;
				case "3":
					tc_frequency = "WEEKLY";
				break;
				case "4":
					tc_frequency = "WEEKLY";
				break;
				case "5":
					tc_frequency = "MONTHLY";
				break;
				case "6":
					tc_frequency = "YEARLY";
				break;
				default:
					tc_frequency = "";
				break;
			}
			if (tc_frequency !== '') tc_rrule['frequency'] = tc_frequency;
			if($("#rep-interval").is(":visible")){
				tc_interval = $("#s-interval").val();
				tc_rrule['interval'] = tc_interval;
			}
			if($("#rep-repeaton").is(":visible")){
				//repeaton
				if($("#repeaton_MO").is(':checked')) tc_interval_arr.push("MO");
				if($("#repeaton_TU").is(':checked')) tc_interval_arr.push("TU");
				if($("#repeaton_WE").is(':checked')) tc_interval_arr.push("WE");
				if($("#repeaton_TH").is(':checked')) tc_interval_arr.push("TH");
				if($("#repeaton_FR").is(':checked')) tc_interval_arr.push("FR");
				if($("#repeaton_SA").is(':checked')) tc_interval_arr.push("SA");
				if($("#repeaton_SU").is(':checked')) tc_interval_arr.push("SU");
				tc_rrule['byday'] = tc_interval_arr;
			}

			//ends
			var s_endson_val = $(":radio[name=endson]").filter(":checked").val();
			switch (s_endson_val)
			{
				case "1":
				break;
				case "2":
					tc_count = $("#endson_count_input").val();

					var digit = new RegExp(/^[0-9]+$/);
					if (!digit.test(tc_count) || parseInt(tc_count)<1){
						alert(__("Incorrect value of 'After XXX occurrences' field. Must be integer and more tnen 0."));
						return false;
					}
					tc_rrule['count'] = tc_count;
				break;
				case "3":
					var dateuntil = $( "#endson_until_input" ).datepicker( "getDate" );
					if(dateuntil === null || dateuntil.valueOf()<dateto.valueOf()){
						alert(__("'End: At' of repeat event should be later than End time"));
						return false;
					}

					tc_until = $("#endson_until_input").val();
					tc_rrule['until'] = tc_until;
					tc_rrule['untilTS'] = Math.round(dateuntil.getTime() / 1000);
				break;
			}
		}
		$("#endson_until_input").val("");
		var tc_summary = $("#rep-summary").val();
		var tcattr = {"NAME":$("#t_NAME").val(), "DESCRIPTION":$("#t_DESCRIPTION").val()};
		// var tcattr = {"UDID":$("#t_UDID").val(), "NAME":$("#t_NAME").val(), "DESCRIPTION":$("#t_DESCRIPTION").val()}
		var timecardinfo = {'startTS':datefromTS, 'endTS':datetoTS, 'start':tc_start, 'end':tc_end, 'allday':tc_allDay, 'rrule':tc_rrule, 'summary': tc_summary, 'attr': tcattr};

		//compare timecardinfo and iSchedulerEditor.tmpevent
		iSchedulerEditor.updateTimecard1(iSchedulerEditor.currschedule, postureid, timecardid, timecardinfo);
	});


	$("#b_delete_tc").click(function(){
		var timecardid = $("#h_tcid").val()*1;
		var postureid = iSchedulerEditor.editWindowInfo["postureid"]*1;
		iSchedulerEditor.deleteTimecard(iSchedulerEditor.currschedule, postureid, timecardid);
	});

	$("#s-frequency").change(function(){
		var selectval = $(this).val();
		switch (selectval)
		{
			case "0":
				$("#rep-interval").show();
				$("#rep-interval-dwmy").text(__("days"));
				$("#rep-repeaton").hide();
			break;
			case "1":
				$("#rep-interval").hide();
				$("#rep-repeaton").hide();
			break;
			case "2":
				$("#rep-interval").hide();
				$("#rep-repeaton").hide();
			break;
			case "3":
				$("#rep-interval").hide();
				$("#rep-repeaton").hide();
			break;
			case "4":
				$("#rep-interval").show();
				$("#rep-interval-dwmy").text(__("weeks"));
				$("#rep-repeaton").show();
			break;
			case "5":
				$("#rep-interval").show();
				$("#rep-interval-dwmy").text(__("months"));
				$("#rep-repeaton").hide();
			break;
			case "6":
				$("#rep-interval").show();
				$("#rep-interval-dwmy").text(__("years"));
				$("#rep-repeaton").hide();
			break;
			default:
				$("#rep-interval").show();
				$("#rep-interval-dwmy").text = __("days");
				$("#rep-repeaton").hide();
			break;
		}

	});
	$(":radio[name=endson]").change(function(){
		var selectval = $(":radio[name=endson]").filter(":checked").val();
		switch (selectval)
		{
			case "1":
				//count
				$(".s_endson_count span").hide();
				$("#endson_count_input").hide();
				$("#endson_count_input").prop("disabled", true);
				//until
				$("#endson_until_input").hide();
				$("#endson_until_input").prop("disabled", true);
			break;
			case "2":
				//count
				$(".s_endson_count span").show();
				$("#endson_count_input").show();
				$("#endson_count_input").prop("disabled", false);
				//until
				$("#endson_until_input").hide();
				$("#endson_until_input").prop("disabled", true);
			break;
			case "3":
				$(".s_endson_count span").hide();
				$("#endson_count_input").hide();
				$("#endson_count_input").prop("disabled", true);

				$("#endson_until_input").show();
				$("#endson_until_input").prop("disabled", false);
			break;
			default:
				$("#endson_count_input").prop("disabled", true);
				$("#endson_until_input").prop("disabled", true);
				$("#endson_until_input").hide();
				$("#endson_count_input").hide();
				$(".s_endson_count span").hide();
			break;
		}
	});

    $('.window .close').click(function (e) {
		e.preventDefault();
		$('#mask, .window').hide();
    });

    $('#mask').click(function () {
		$(this).hide();
		$('.window').hide();
    });

    $('#cb_repeat').change(function () {
		if($("#cb_repeat").prop("checked")){
			$("#repeat-dialog").show();
		}else{
			$("#repeat-dialog").hide();
		}
    });

	$("#addposture").click(function(){
		iSchedulerEditor.createEditor({
			id: "#editor_sch",
			type: "posture",
			attributes: {'SCHEDULE':iSchedulerEditor.currschedule},
			buttons: {
				remove: {
					show: false
				},
				back: {
					show: false
				}
			}
		});
		iSchedulerEditor.editor.onSave = function(obj, success)
		{
			if (obj && success)
			{
				iSchedulerEditor.destroyEditor();
				iSchedulerEditor.fillPostureList1({"scheduleid":iSchedulerEditor.currschedule});
				iSchedulerEditor.updatePosturesDivs();
			}
		};

	});

	$("#editposture").click(function(){
			var type = "posture";
			var obj = null;
			obj = iSchedulerEditor.selected[type][0];

			if (type && obj)
			{
				iSchedulerEditor.createEditor({
					obj: obj,
					id: "#editor_sch .content",
					type: type,
					buttons: {
						back: {
							show: false
						}
					}
				});
				var func = function(obj, success)
				{
					if (success)
					{
						iSchedulerEditor.destroyEditor();
						iSchedulerEditor.fillPostureList1({"scheduleid":iSchedulerEditor.currschedule});
						iSchedulerEditor.updatePosturesDivs();
					}
				};
				iSchedulerEditor.editor.onSave = func;
				iSchedulerEditor.editor.onDelete = func;
			}
	});


		$("#deleteposture").click(function(){
			iSchedulerEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var type = "posture";
			var objList = null;

			if (iSchedulerEditor.selected[type])
			{
				objList = iSchedulerEditor.selected[type];
			}

			if (type && objList)
			{
				// delete only not protected objects
				var objListForDelete = [];
				for (var i = 0; i < objList.length; i++)
				{
					var element = iSchedulerEditor.list.was[type][objList[i]];
					if (element)
					{
						if (element.protected == "0")
						{
							objListForDelete.push(objList[i]);
						} else {
							// i18n: example: Role Admin is protected
							Log.warning(Gettext.strargs(__("%1 '%2' is protected"), [type, element.name]));
						}
					}
				}

				var stringList = "";
				for (var i = 0; i < objListForDelete.length; i++)
				{
					if (iSchedulerEditor.list.was[type][objListForDelete[i]])
					{
						stringList += iSchedulerEditor.list.was[type][objListForDelete[i]].name;
						if (i < objListForDelete.length - 1)
							stringList += ", ";
					}
				}

				if (objListForDelete.length > 0 && confirm(Gettext.strargs(__("Are you sure you want to delete %1 (%2)?"), [type, stringList])))
				{
					var api = new API();
					api.deleteObject({
						objList: JSON.stringify(objListForDelete)
					})
						.fail(function (code, message){
							Log.error(message);
						})
						.always(function (){
							iSchedulerEditor.fillPostureList1({"scheduleid":iSchedulerEditor.currschedule});
							iSchedulerEditor.updatePosturesDivs();

							//Delete calendar from iSchedulerEditor
							var calendar_id = "#calendar";
							iSchedulerEditor.getScheduleInfo({
								scheduleid: iSchedulerEditor.currschedule,//schedule[0],
								beforeSend: function()
								{
									$(calendar_id).mask();
								},
								error: function()
								{
									$(calendar_id).html('');
								},
								success: function(list)
								{
									iSchedulerEditor.scheduleInfo = list;
									iSchedulerEditor.fillCalendar(list);
									iSchedulerEditor.enabledApplyCancel(false);
								}

							});
						});
				}
			}
		});

		$("#postures").delegate(".objectList", "change keyup", function(){
			var val = $(this).val();
			if (val){
				iSchedulerEditor.selected["posture"] = val;
			}
		});


		$("#dialog-devices").delegate(".move", "click", function(){
			iSchedulerEditor.isDebug && Log.warning($(this).data("typeList") + " " + $(this).val());

			var type = $(this).data("type");
			var val = iSchedulerEditor.selected[type];
			iSchedulerEditor.isDebug && Log.info(val);
			var i = 0;

			switch ($(this).data("typeList"))
			{
				case "device":
					if (val)
					{
						iSchedulerEditor.list.now.device2schedule = iSchedulerEditor.list.now.device2schedule || $.extend({}, iSchedulerEditor.list.was.device2schedule);
						iSchedulerEditor.list.now.device = iSchedulerEditor.list.now.device || iSchedulerEditor.removeFromArray(iSchedulerEditor.list.was.device, iSchedulerEditor.list.was.device2schedule);
						for (i = 0; i < val.length; i++)
						{
							iSchedulerEditor.list.now.device2schedule[val[i]] = iSchedulerEditor.list.now.device[val[i]];
							delete iSchedulerEditor.list.now.device[val[i]];
						}

						iSchedulerEditor.fillDevice2ScheduleList({ list: iSchedulerEditor.list.now.device2schedule,filter: $("#device2schedule .objectFilter").val()});
						iSchedulerEditor.fillDeviceList({ list: iSchedulerEditor.list.now.device, filter: $("#devices .objectFilter").val() });
					}
				break;
				case "device2schedule":
					if (val)
					{
						iSchedulerEditor.list.now.device2schedule = iSchedulerEditor.list.now.device2schedule || $.extend({}, iSchedulerEditor.list.was.device2schedule);
						iSchedulerEditor.list.now[type] = iSchedulerEditor.list.now[type] || iSchedulerEditor.removeFromArray(iSchedulerEditor.list.was[type], iSchedulerEditor.list.was.device2schedule);
						for (i = 0; i < val.length; i++)
						{
							iSchedulerEditor.list.now[type][val[i]] = iSchedulerEditor.list.now.device2schedule[val[i]];
							delete iSchedulerEditor.list.now.device2schedule[val[i]];
						}

						iSchedulerEditor.fillDevice2ScheduleList({ list: iSchedulerEditor.list.now.device2schedule,filter: $("#device2schedule .objectFilter").val() });
						iSchedulerEditor.fillDeviceList({ list: iSchedulerEditor.list.now[type], filter: $("#devices .objectFilter").val() });
					}
				break;
			}
		});


	$("#devicessave").click(function(){
			iSchedulerEditor.saveObjectsOnSchedule();
			$("input.move").prop("disabled", true);
	});

	$("#devicescansel").click(function(){
		iSchedulerEditor.fillDevice2ScheduleList({
			scheduleid: iSchedulerEditor.currschedule,
			filter: $("#device2schedule .objectFilter").val(),
			callback: function()
			{
				$("input.move").prop("disabled", true);
				iSchedulerEditor.fillDeviceList({ except: iSchedulerEditor.list.was.device2schedule, filter: $("#devices .objectFilter").val()});
				//iSchedulerEditor.list.now.device2schedule = null;
				iSchedulerEditor.list.now.device2schedule = iSchedulerEditor.list.was.device2schedule;
				iSchedulerEditor.list.now.device = null;
				iSchedulerEditor.oldDevice2ScheduleList = iSchedulerEditor.getDevice2ScheduleList();
			}
		});
		//redraw old divice and device2schedule lists
	});
	// eof Modal window


	/*confirm for moving TC items*/
	$("#edit_tc_do_one_item").click(function(){
		iSchedulerEditor.editTC_one_item();
	});

	$("#edit_tc_do_range").click(function(){
		iSchedulerEditor.editTC_from_datepoint();
	});

	$("#edit_tc_close").click(function(){
	// iSchedulerEditor.saveObjectsOnSchedule();
	});
	/*EOF confirm for moving TC items*/

	/*confirm for delete TC items*/
	$("#delete_tc_do_one_item").click(function(){
		var doDelete = true;
		iSchedulerEditor.editTC_one_item(doDelete);
	});

	$("#delete_tc_do_range").click(function(){
		var doDelete = true;
		iSchedulerEditor.editTC_from_datepoint(doDelete);
	});

	$("#delete_tc_close").click(function(){
		$('#confirm_delete_tc').hide();
	});


	$("#edit_tc_all_range").click(function(){
		iSchedulerEditor.editTC_full();
	});
	$("#delete_tc_all_range").click(function(){
		var doDelete = true;
		iSchedulerEditor.editTC_full(doDelete);
	});

	/*EOF confirm for delete TC items*/

		$("#calendarsave").click(function(){
			iSchedulerEditor.setScheduleInfo();
			iSchedulerEditor.enabledApplyCancel(false);
		});
		$("#calendarcansel").click(function(){
		//////////////////////////////////
		//TODO need to set by one function
							iSchedulerEditor.list.now = {};
							iSchedulerEditor.fillDevice2ScheduleList({
								scheduleid: iSchedulerEditor.currschedule,
								filter: $("#device2schedule .objectFilter").val(),
								callback: function()
								{
									iSchedulerEditor.fillDeviceList({ except: iSchedulerEditor.list.was.device2schedule, filter: $("#devices .objectFilter").val()});
								}
							});

							var calendar_id = "#calendar";
							iSchedulerEditor.getScheduleInfo({
								scheduleid: iSchedulerEditor.currschedule,//schedule[0]
								beforeSend: function()
								{
									$(calendar_id).mask();
								},
								error: function()
								{
									$(calendar_id).html('');
								},
								success: function(list)
								{
									iSchedulerEditor.scheduleInfo = list;
									iSchedulerEditor.fillCalendar(list);
									iSchedulerEditor.enabledApplyCancel(false);
								}
							});
		});

		// add events for links for reload lists
		$(iSchedulerEditor.id + " .tabs_content").delegate("a", "click", function(){
			switch ($(this).attr("href"))
			{
				case "#posture":
					iSchedulerEditor.init("posture", iSchedulerEditor.id);
				break;
				case "#schedule":
					iSchedulerEditor.init("schedule", iSchedulerEditor.id);
				break;
				case "#devices":
					//iSchedulerEditor.fillDeviceList();
				break;
			}
		});

		// add events for buttons for relocating items in lists
		$(iSchedulerEditor.id + " .tabs_content").delegate(".move", "click", function(){
			iSchedulerEditor.isDebug && Log.warning($(this).data("typeList") + " " + $(this).val());

			var type = $(this).data("type");
			var val = iSchedulerEditor.selected[type];
			iSchedulerEditor.isDebug && Log.info(val);
			var i = 0;

			switch ($(this).data("typeList"))
			{
				case "device":
					if (val)
					{
						iSchedulerEditor.list.now.device2schedule = iSchedulerEditor.list.now.device2schedule || $.extend({}, iSchedulerEditor.list.was.device2schedule);
						iSchedulerEditor.list.now.device = iSchedulerEditor.list.now.device || iSchedulerEditor.removeFromArray(iSchedulerEditor.list.was.device, iSchedulerEditor.list.was.device2schedule);
						for (i = 0; i < val.length; i++)
						{
							iSchedulerEditor.list.now.device2schedule[val[i]] = iSchedulerEditor.list.now.device[val[i]];
							delete iSchedulerEditor.list.now.device[val[i]];
						}

						iSchedulerEditor.fillDevice2ScheduleList({ list: iSchedulerEditor.list.now.device2schedule,filter: $("#device2schedule .objectFilter").val() });
						iSchedulerEditor.fillDeviceList({ list: iSchedulerEditor.list.now.device, filter: $("#devices .objectFilter").val() });
					}
				break;
				case "device2schedule":
					if (val)
					{
						iSchedulerEditor.list.now.device2schedule = iSchedulerEditor.list.now.device2schedule || $.extend({}, iSchedulerEditor.list.was.device2schedule);
						iSchedulerEditor.list.now[type] = iSchedulerEditor.list.now[type] || iSchedulerEditor.removeFromArray(iSchedulerEditor.list.was[type], iSchedulerEditor.list.was.device2schedule);
						for (i = 0; i < val.length; i++)
						{
							iSchedulerEditor.list.now[type][val[i]] = iSchedulerEditor.list.now.device2schedule[val[i]];
							delete iSchedulerEditor.list.now.device2schedule[val[i]];
						}

						iSchedulerEditor.fillDevice2ScheduleList({ list: iSchedulerEditor.list.now.device2schedule });
						iSchedulerEditor.fillDeviceList({ list: iSchedulerEditor.list.now[type], filter: $("#devices .objectFilter").val() });
					}
				break;
			}
		});

		// add events for buttons for adding objects
		$(iSchedulerEditor.id + " .tabs_content").delegate(".add", "click", function(){
			iSchedulerEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var type = $(this).data("type");
			var typeList = $(this).data("typeList");

			switch (typeList)
			{
				case "posture":
				case "schedule":
					iSchedulerEditor.createEditor({
						id: "#editor_sch",
						type: type,
						buttons: {
							remove: {
								show: false
							},
							back: {
								show: false
							}
						}
					});
					iSchedulerEditor.editor.onSave = function(obj, success)
					{
						if (obj && success)
						{
							iSchedulerEditor.destroyEditor();
							iSchedulerEditor.initScheduleManagement(obj);
						}
					};
				break;
				case "device2schedule":
				break;
			}
		});

		// add events for buttons for editing objects
		$(iSchedulerEditor.id + " .tabs_content").delegate(".edit", "click", function(){
			iSchedulerEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var type = $(this).data("type");
			var obj = null;

			if (iSchedulerEditor.selected[type])
			{
				if (type == 'schedule'){
					obj = iSchedulerEditor.selected[type];
				}else{
					obj = iSchedulerEditor.selected[type][0];
				}
			}

			if (type && obj)
			{
				iSchedulerEditor.createEditor({
					obj: obj,
					id: "#editor_sch .content",
					type: type,
					buttons: {
						back: {
							show: false
						}
					}
				});
				var func = function(obj, success)
				{
					if (success)
					{
						iSchedulerEditor.destroyEditor();
						iSchedulerEditor.initScheduleManagement(obj);
					}
				};
				iSchedulerEditor.editor.onSave = func;
				iSchedulerEditor.editor.onDelete = func;
			}
		});

		$("#deleteschedule").click(function(){
			var scheduleid = iSchedulerEditor.currschedule;
			var type = 'schedule';
			var scheduleName = iSchedulerEditor.scheduleInfo[scheduleid].name;
			var objListForDelete = [];
			objListForDelete.push(scheduleid);

//			confirm(Gettext.strargs(__("Are you sure you want to delete 1 (2)?"),[]));
			if ((scheduleid>0) && confirm(Gettext.strargs(__("Are you sure you want to delete %1 (%2) with all attached Postures and Timecards.?"), [type, scheduleName])))
			{
				var api = new API();
				api.deleteObject({
					objList: JSON.stringify(objListForDelete)
				})
					.fail(function (code, message){
						Log.error(message);
					})
					.done(function (){
						//delete from scheduleinfo
						delete iSchedulerEditor.scheduleInfo[scheduleid];

						Log.info(Gettext.strargs(__("Schedule (%1) was deleted successfully with all attached Postures and Timecards."), [scheduleName]));
						iSchedulerEditor.initScheduleManagement();
						iSchedulerEditor.updatePosturesDivs();
					});
			}
		});

		// add events for lists for selecting items
		$(iSchedulerEditor.id + " .tabs_content, #dialog-devices" ).delegate(".objectList", "change keyup", function(){
			iSchedulerEditor.isDebug && Log.warning($(this).data("typeList") + " " + $(this).val());

			var val = $(this).val();
			if (val)
			{
				iSchedulerEditor.selected[$(this).data("type")] = val;
				switch ($(this).data("typeList"))
				{
					case "posture":
					break;
					case "schedule":

						if (iSchedulerEditor.currentType == "schedule")
						{
							// check if enabled SaveButton
							if (iSchedulerEditor.isNeedToSaveScheduleInfo){
								// if enabled - set dialog "Do you wont to save?"

//								if (iSchedulerEditor.confirmDialog()) {
								if (confirm(__("Last changes on schedule was not saved. Do you want to save it?"))) {
									// if yes - save schedule info
									//iSchedulerEditor.setScheduleInfo();

									//TODO need to rewrite this function
									var currschedule = iSchedulerEditor.currschedule;
									var scheduleInfo = iSchedulerEditor.scheduleInfo;
									var data = {
										"function": 'setScheduleInfo'
									};
									data.scheduleid = currschedule;
									data.scheduleInfo = JSON.stringify(scheduleInfo);
									var calendar_id = "#calendar";
									$.ajax({
										type: "POST",
										url: "/api/call.php",
										data: data,
										dataType: "json",
										cache: false,
										beforeSend: function(XMLHttpRequest)
										{
											$(calendar_id).mask();
										},
										error: function(XMLHttpRequest, textStatus, errorThrown)
										{
											$(calendar_id).html('');
											return false;
										},
										complete: function(json)
										{
											$(calendar_id).unmask();
										},
										success: function(json)
										{
											if (json.error !== ""){
												Log.error(json.error);
												return false;
											}
										}
									});
								}
							}
							iSchedulerEditor.currschedule = iSchedulerEditor.selected.schedule;

							// clear changes for previous selected schedule
							iSchedulerEditor.list.now = {};
							iSchedulerEditor.fillDevice2ScheduleList({
								scheduleid: iSchedulerEditor.currschedule,
								filter: $("#device2schedule .objectFilter").val(),
								callback: function()
								{
									iSchedulerEditor.fillDeviceList({ except: iSchedulerEditor.list.was.device2schedule, filter: $("#devices .objectFilter").val()});
									iSchedulerEditor.oldDevice2ScheduleList = iSchedulerEditor.getDevice2ScheduleList();
								}
							});

							var unused_posture_id = "#unused_posture_list";
							iSchedulerEditor.getUnusedPosturesList({
								beforeSend: function()
								{
									$(unused_posture_id).mask();
								},
								error: function()
								{
									$(unused_posture_id).html('');
								},
								success: function(list)
								{
									iSchedulerEditor.fillUnusedPostures(list);
								}
							});

							var calendar_id = "#calendar";
							iSchedulerEditor.getScheduleInfo({
								scheduleid: iSchedulerEditor.currschedule,//schedule[0],
								beforeSend: function()
								{
									$(calendar_id).mask();
								},
								error: function()
								{
									$(calendar_id).html('');
								},
								success: function(list)
								{
									iSchedulerEditor.scheduleInfo = list;
									iSchedulerEditor.fillCalendar(list);
									iSchedulerEditor.enabledApplyCancel(false);
								}

							});
							iSchedulerEditor.doChangeHash = false;
							var hashArrLength = iSchedulerEditor.hashArr.length;
							if(hashArrLength>0) iSchedulerEditor.hashArr.length = hashArrLength -1;
							var strHash = iSchedulerEditor.hashArr.join('/');
							if (strHash != ''){
								strHash = strHash + '/';
							}
							var hash = strHash + 'schedule_manager_' + iSchedulerEditor.currschedule;

							if (hash != "")
							{
								var tmphash = hash;//.substring(0, hash.length);
								iSchedulerEditor.hashArr = tmphash.split('/');
								iSchedulerEditor.lasthash = tmphash;
								if (iSchedulerEditor.hashArr.length > 0)
									iSchedulerEditor.lasthash = iSchedulerEditor.hashArr[iSchedulerEditor.hashArr.length-1];
							}
							window.location.hash = hash;


						}
					break;
					case "device":
					break;
				}

				if (iSchedulerEditor.currentType == $(this).data("typeList"))
				{
					iSchedulerEditor.showHideButtons({
						type: $(this).data("typeList"),
						show: ["add", "delete", "edit"]
					});
				} else {
					iSchedulerEditor.showHideButtons({
						type: $(this).data("typeList"),
						show: ["move"]
					});
				}

			}else{
				iSchedulerEditor.showHideButtons({
					type: $(this).data("typeList"),
					hide: ["move"]
				});
			}
		});

		$("#device2schedule").delegate(".objectFilter", "keyup", function(){//change keyup
			var filter = $(this).val();
			if (iSchedulerEditor.list.now.device2schedule){
				var list = iSchedulerEditor.list.now.device2schedule;
				var scheduleid = null;
			}else{
				var list = null;
				var scheduleid = iSchedulerEditor.selected.schedule;
			}
			iSchedulerEditor.fillDevice2ScheduleList({ list: list, scheduleid: scheduleid, filter:filter });
		});

		$("#devices").delegate(".objectFilter", "keyup", function(){//change keyup
			var filter = $(this).val();

			iSchedulerEditor.fillDeviceList({ list: iSchedulerEditor.list.now.device||iSchedulerEditor.list.was.device, except: iSchedulerEditor.list.now.device2schedule||iSchedulerEditor.list.was.device2schedule, filter:filter });

		});


	},

	confirmDialog: function(){
		$("#confirm").dialog({
			title: "",
			width: 250,
			height: 150,
			resizable: false,
			draggable: false,
			position: "center",
			buttons: {
			  "Yes": function() {
				$(this).dialog("close");
				return true;
			  },
			  "No": function() {
				$(this).dialog("close");
				return false;
			  }
			}
		});
	},
	showHideButtons: function(params)
	{
		params.type = params.type || null;
		params.show = params.show || [];

		// list of types and their list ids
		var types = {
			device: "#devices",
			device2schedule: "#device2schedule"
		};

		var actions = [
			{
				action: "add",
				selector: ".add"
			},
			{
				action: "delete",
				selector: ".delete"
			},
			{
				action: "edit",
				selector: ".edit"
			},
			{
				action: "move",
				selector: ".move"
			}
		];

		var i;
		// hide all action buttons
		for (var type in types)
		{
			for (i = 0; i < actions.length; i++)
				$(types[type] + " " + actions[i].selector).prop("disabled", true);

			// remove border around list
			$(types[type] + " .objectList")
				.removeClass("highlightBorder");
		}

		if (params.type)
		{
			// show action buttons
			for (i = 0; i < actions.length; i++)
			{
				for (var j = 0; j < params.show.length; j++)
				{
					if (actions[i].action == params.show[j])
						$(types[params.type] + " " + actions[i].selector).prop("disabled", false);
				}
			}

			// add border around list
			$(types[params.type] + " .objectList")
				.addClass("highlightBorder");
		}
	},

	initScheduleManagement: function(obj)
	{
		obj = obj || null;
		$("#postures").show();
		$("#postureattrs").hide();

		$("#schedule .objectList").empty();
		$("#schedule")
			.show();
		$("#schedule .controls input").show();
		$("#schedule .controls2 input").hide();
		$("#devices .objectList").empty();
		$("#devices")
			.show();
		$("#device2schedule .objectList").empty();
		$("#device2schedule")
			.show();

		var blockHeight = $("#set2role").outerHeight() + $("#device2schedule").outerHeight() + $("#timecards").outerHeight();
		var scheduleHeight = $("#schedule").outerHeight();
		$("#device2set1").hide();
		$("#scheduleattrs").show();
		$("#posture_editor").html("");
		$("#posture_editor").hide();
		$("#timecards").show();

		// insert full calendar
		$('#timecards').show();
		$('#unused_posture_list div.unused_posture').each(function() {

			// create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
			// it doesn't need to have a start or end
			var eventObject = {
				title: $.trim($(this).text()) // use the element's text as the event title
			};

			// store the Event Object in the DOM element so we can get to it later
			$(this).data('eventObject', eventObject);

			// make the event draggable using jQuery UI
			$(this).draggable({
				zIndex: 999,
				revert: true,      // will cause the event to go back to its
				revertDuration: 0  //  original position after the drag
			});

		});



			var date = new Date();
			var d = date.getDate();
			var m = date.getMonth();
			var y = date.getFullYear();
			$('#calendar').fullCalendar( 'destroy' );
			var fullCalendar = $('#calendar').fullCalendar({
				// put your options and callbacks here
				weekends: true, // will hide Saturdays and Sundays
				ignoreTimezone: true,
				weekMode: 'liquid',
				header: {
					left: 'prev,next today',
					center: 'title',
					right: 'month,agendaWeek,agendaDay'
				},
				allDaySlot: false,
				timeFormat:
					{
						// for agendaWeek and agendaDay
						agenda: 'HH:mm{-HH:mm}', // 5:00 - 6:30

						// for all other views
						'': 'HH:mm{-HH:mm}'            // 7p
					},
				axisFormat:'HH:mm',
				// 'HH:mm{-HH:mm}',
				defaultView: 'agendaWeek',
				editable: true,
				//aspectRatio: 2,
				height: 780,
				contentHeight: 560,
				//timeFormat: 'H(:mm)',
				agenda: 'HH:mm',
				columnFormat:{
					month: 'ddd',    // Mon
					week: 'ddd MM/dd', // Mon 9/7
					day: 'dddd MM/dd'  // Monday 9/7
				},
				dayNames:[__('Sunday'), __('Monday'), __('Tuesday'), __('Wednesday'), __('Thursday'), __('Friday'), __('Saturday')],
				dayNamesShort:[__('Su'), __('Mo'), __('Tu'), __('We'), __('Th'), __('Fr'), __('Sa')],
				monthNames:[__('January'), __('February'), __('March'), __('April'), __('May'), __('June'), __('July'), __('August'), __('September'), __('October'), __('November'), __('December')],
				monthNamesShort:[__('Jan'), __('Feb'), __('Mar'), __('Apr'), __('May'), __('Jun'), __('Jul'), __('Aug'), __('Sep'), __('Oct'), __('Nov'), __('Dec')],
				buttonText:{
					today:    __('today'),
					month:    __('month'),
					week:     __('week'),
					day:      __('day'),
					prev: '&lt;',
					next: '&gt;'
				},
				events: [],
				eventClick: function(calEvent, jsEvent, view) {
					var datefrom = calEvent.start;
					var currdate = new Date();
					var currDS = currdate.valueOf();
					var eventStartDS = datefrom.valueOf();
					if(currDS > eventStartDS){
						alert("Updating or deleting timecards from the past!");
						iSchedulerEditor.enableTCTimeData();
					}else{
						iSchedulerEditor.enableTCTimeData();
					}

					var dateto = calEvent.end;
					iSchedulerEditor.datefrom = datefrom;
					iSchedulerEditor.dateto = dateto;

					$("#eventdatefrom").text(datefrom.toLocaleString());
					$("#eventdateto").text(dateto.toLocaleString());
					$("#h_tcid").val(calEvent.id);

					// Add new
					iSchedulerEditor.fillTMPevent(calEvent);
					var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
					var i=0;
					for (i=0; i < arrLength; i++){
						if(typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]) != 'undefined'){
							if (iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'] == calEvent.id){
								iSchedulerEditor.tmpevent.i = i;
								iSchedulerEditor.tmpevent.ICAL_DATA = clone(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']);
								iSchedulerEditor.tmpevent.NAME = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['NAME'];
								iSchedulerEditor.tmpevent.UDID = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['UDID'];
								iSchedulerEditor.tmpevent.DESCRIPTION = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['DESCRIPTION'];
								break;
							}
						}
					}
					iSchedulerEditor.tmpevent.oldStartDS = eventStartDS;
					// EOF  Add new

					iSchedulerEditor.fillEditWindow("#dialog2", calEvent);

					$('#cb_repeat').trigger("change");
					iSchedulerEditor.openModal("#dialog2", 300, 300);
				},

				droppable: true, // this allows things to be dropped onto the calendar !!!
				drop: function(date, allDay) { // this function is called when something is dropped
					var currdate = new Date();
					var currDS = currdate.valueOf();
					var eventStartDS = date.valueOf();
					if(currDS > eventStartDS){
						alert("Inserting timecard to the past!");
					}

					// retrieve the dropped element's stored Event Object
					var originalEventObject = $(this).data('eventObject');

					// we need to copy it, so that multiple events don't have a reference to the same object
					var copiedEventObject = $.extend({}, originalEventObject);

					// assign it the date that was reported
					copiedEventObject.start = date;
					var dd = date.getDate();
					var mm = date.getMonth();
					var yy = date.getFullYear();
					var hh = date.getHours();
					var min = date.getMinutes();
					copiedEventObject.end = new Date(yy, mm, dd, hh+3, min);
					copiedEventObject.allDay = false;
					copiedEventObject.id = ++iSchedulerEditor.newTimeCardID;

					$('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

					//add copiedEventObject to calendar[j];
					var newCalStruct = {};
					newCalStruct['id'] = copiedEventObject.id;
					newCalStruct['name'] = copiedEventObject.title;
					newCalStruct['title'] = copiedEventObject.title;
					newCalStruct['timecardid'] = copiedEventObject.id;
					newCalStruct['postureid'] = originalEventObject.postureid;
					newCalStruct['timecard'] = {};
					newCalStruct['timecard']['attributes'] = {};
					newCalStruct['timecard']['attributes']['NAME'] = 'Timecard';
					newCalStruct['timecard']['attributes']['ICAL_DATA'] = {};
					newCalStruct['timecard']['attributes']['ICAL_DATA']['startTS'] = copiedEventObject.start.valueOf()/1000 - copiedEventObject.start.getTimezoneOffset()*60;
					newCalStruct['timecard']['attributes']['ICAL_DATA']['endTS'] = copiedEventObject.end.valueOf()/1000 - copiedEventObject.end.getTimezoneOffset()*60;

					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].push(newCalStruct);
					iSchedulerEditor.enabledApplyCancel(true);

					var blockHeight = $("#calendar").outerHeight()+10;
					$("#schedulerManager .schedulerManager_content").height(blockHeight);

				},


				eventDrop: function(event,dayDelta,minuteDelta,allDay,revertFunc) {
					var deltasec = dayDelta*60*60*24 + minuteDelta*60;
					var currdate = new Date();
					var currDS = currdate.valueOf();
					var eventStartDS = event.start.valueOf();
					var eventOldStartDS = event.start.valueOf()-deltasec*1000;
					$('#edit_tc_all_range').hide();
					if(currDS > eventOldStartDS){
						alert("Moving timecard from the past!");
					}
					if(currDS > eventStartDS){
						alert("Moving timecard to the past!");
					}

					var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
					var i=0;
					for (i=0; i < arrLength; i++){
						if (typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]) != 'undefined'
							&& iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'] == event.id){
						//Узнать, рекурентная ли ТК
						// если нет = просто меняем как раньше
						// если да
						// проверить, тянем ли главный (стартовый, родительский) Итем
						//	если да, то меняем как раньше
						//	если нет
								// Задать вопрос Изменять всю последовательность или только
								//					один итем
								// Если один итем
								//	Добавляем исключение в текущий ТК: исключение на тот временной промежуток, где раньше был Итем
								//	Создаем новую ТК не повторяющуюся на тот же Постур с параметрами event.start, event.end
								// Если вся последовательность
								// 	Заканчиваем текущий ТК на старте бывшего итема.
								//	Создаем новую рекурентную ТК на тот же Постур с параметрами как у старого ТС но стартующего в event.start.


							if(typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']) != "undefined" &&
									iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule'].length != 0
							){
								// проверить, тянем ли главный (стартовый, родительский) Итем
								if(typeof(event.first) != "undefined" && event.first){
									iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['startTS'] = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['startTS']*1+deltasec*1;
									iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS']*1+deltasec*1;
									iSchedulerEditor.enabledApplyCancel(true);
								}else{
									iSchedulerEditor.fillTMPevent(event);
									iSchedulerEditor.tmpevent.i = i;
									iSchedulerEditor.tmpevent.oldStartDS = eventOldStartDS;
									$('#edit_tc_do_one_item').show();
									iSchedulerEditor.openModal("#confirm_edit_tc", 100, 100);
									revertFunc();

							}
							}else{
								iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['startTS'] = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['startTS']*1+deltasec*1;
								iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS']*1+deltasec*1;
								iSchedulerEditor.enabledApplyCancel(true);
							}
							break;
						}
					}
				},
				eventResize: function(event,dayDelta,minuteDelta,revertFunc) {
					var deltasec = dayDelta*60*60*24 + minuteDelta*60;

					var currdate = new Date();
					var currDS = currdate.valueOf();
					var eventEndDS = event.start.valueOf();
					var eventOldEndDS = event.end.valueOf()-deltasec*1000;
					var eventStartDS = event.start.valueOf();
					var eventOldStartDS = event.start.valueOf();
					if(currDS > eventOldEndDS){
						alert("Changing timecards from the past!");
					}



					var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
					var i=0;
					for (i=0; i < arrLength; i++){
						if (typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]) != 'undefined'
							&& iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'] == event.id){
							if(typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']) != "undefined" &&
									iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule'].length != 0
							){
								if(typeof(event.first) != "undefined" && event.first){
									iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS']*1+deltasec*1;
									iSchedulerEditor.enabledApplyCancel(true);
								}else{
									iSchedulerEditor.fillTMPevent(event);
									iSchedulerEditor.tmpevent.i = i;
									iSchedulerEditor.tmpevent.oldStartDS = eventOldStartDS;
									$('#edit_tc_do_one_item').show();
									iSchedulerEditor.openModal("#confirm_edit_tc", 100, 100);
									revertFunc();
							}
							}else{
								iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS']*1+deltasec*1;
								iSchedulerEditor.enabledApplyCancel(true);
							}
							break;
						}
					}
				},
				viewDisplay: function(view) {
					iSchedulerEditor.convertScheduleInfoToEventSource(true);
				}

			});

		var blockHeight = $("#timecards").outerHeight();

		var contentheight = $("#content").height();
		var contentheight = blockHeight+170;
		contentheight = Math.max(contentheight, blockHeight+170);
		$("#content").height(contentheight);

		$("#schedule").css({
			top: ($(".schedulerManagerBlock").position().top + blockHeight / 2 - scheduleHeight / 2) + "px",
			left: ""
		});
		$("#device2schedule")
			.css({
				left: ($("#schedule").position().left + $("#schedule").outerWidth()) + "px",
				top: ($("#schedule").position().top + scheduleHeight / 2) + "px"
			});
		$("#devices").css({
			display: "block",
			left: ($("#device2schedule").position().left + $("#device2schedule").width() + $("#device2schedule .controls2").width()) + "px",
			top: ($("#device2schedule").position().top) + "px"
		});

		var withProtected = $("#schedule .showSystemSets input[type=checkbox]").prop("checked");

		iSchedulerEditor.fillUnusedPosturesList();
		iSchedulerEditor.fillScheduleList({
			withProtected: withProtected,
			callback: function()
			{
				obj = obj || $("#schedule .objectList option:first").val();
				iSchedulerEditor.selected["schedule"] = obj;
				if (obj)
				{
					var element = $("#schedule .objectList option[value=" + obj + "]");
					if (!(element.length > 0))
					{
						element = $("#schedule .objectList option[value=" + iSchedulerEditor.selected.schedule + "]");
					}
					element.prop("selected", true).change();
					iSchedulerEditor.currschedule = iSchedulerEditor.selected.schedule;
				}else{
					iSchedulerEditor.eventSource = [];
					iSchedulerEditor.fillCalendarEventSource();
				}
			}
		});

	},

	openModal: function(id, x, y)
	{
		var maskHeight = $(document).height();
		var maskWidth = $(window).width();

		$('#mask').css({'width':maskWidth,'height':maskHeight});

		$('#mask').fadeTo("fast",0.4);

		var winH = $(window).height();
		var winW = $(window).width();

		$(id).css('top',  y-100);
		$(id).css('left', winW/2-$(id).width()/2);

		$(id).fadeIn(100);
	},

	fillEditWindow: function(id, calEvent)
	{
		var datefrom = calEvent.start.copy();
		var dateto = calEvent.end.copy();

		var timefrom = calEvent.start.copy();
		var timeto = calEvent.end.copy();

		$("#eventdatefrom").text(datefrom.toLocaleString());
		$("#eventdateto").text(dateto.toLocaleString());

		/*if (typeof(calEvent.UDID) !== 'undefined'){
			$("#t_UDID").val(calEvent.UDID);
		}else{
			$("#t_UDID").val('');
		}*/
		if (typeof(calEvent.NAME) !== 'undefined'){
			$("#t_NAME").val(calEvent.NAME);
		}else{
			$("#t_NAME").val('');
		}
		if (typeof(calEvent.SUMMARY) !== 'undefined'){
			$("#t_SUMMARY").text(calEvent.SUMMARY);
		}else{
			$("#t_SUMMARY").text('');
		}
		if (typeof(calEvent.DESCRIPTION) !== 'undefined'){
			$("#t_DESCRIPTION").val(calEvent.DESCRIPTION);
		}else{
			$("#t_DESCRIPTION").val('');
		}
		$("#t_posturename").text(calEvent.title);
		$("#t_time_to, #t_time_from").timePicker({
		  show24Hours: true,
		  separator: ':',
		  step: 15});

		$.timePicker("#t_time_from").setTime(timefrom);
		$.timePicker("#t_time_to").setTime(timeto);


		$( "#t_date_from" ).datepicker(
			{ dateFormat: 'yy-mm-dd' }
		);
		$( "#t_date_to" ).datepicker({
			dateFormat: 'yy-mm-dd'
		});
		$("#t_date_from").datepicker( "setDate" , datefrom);
		$("#t_date_to").datepicker( "setDate" , dateto);

		$( "#endson_until_input" ).datepicker({
			dateFormat: 'yy-mm-dd'
		});

		var timecardid = calEvent.id;
		iSchedulerEditor.fillEditWindowInfo(timecardid);

/*		function isEmptyObject(obj) {
			if (Array.isArray(obj)){
				if (obj.length > 0) return false;
				else return true;
			}else if (Object.keys(obj).length > 0){
				return false;
			} else return true;
		}*/

		$("#repeaton_MO, #repeaton_TU, #repeaton_WE, #repeaton_TH, #repeaton_FR, #repeaton_SA, #repeaton_SU").prop("checked", false);
		if (!$.isEmptyObject(iSchedulerEditor.editWindowInfo["rrule"])){
			$("#cb_repeat").prop("checked", true);
			if(typeof(iSchedulerEditor.editWindowInfo["rrule"]["interval"]) !== "undefined"){
				$("#s-interval").val(iSchedulerEditor.editWindowInfo["rrule"]["interval"]);
			}
			if(typeof(iSchedulerEditor.editWindowInfo["rrule"]["frequency"]) !== "undefined"){
				if(iSchedulerEditor.editWindowInfo["rrule"]["frequency"] == "DAILY") $("#s-frequency").val(0);
				if(iSchedulerEditor.editWindowInfo["rrule"]["frequency"] == "WEEKLY") $("#s-frequency").val(4);
				if(iSchedulerEditor.editWindowInfo["rrule"]["frequency"] == "MONTHLY") $("#s-frequency").val(5);
				if(iSchedulerEditor.editWindowInfo["rrule"]["frequency"] == "YEARLY") $("#s-frequency").val(6);
			}


			if(typeof(iSchedulerEditor.editWindowInfo["rrule"]["byday"]) !== "undefined" && iSchedulerEditor.editWindowInfo["rrule"]["byday"].length>0){
				for (var i in iSchedulerEditor.editWindowInfo["rrule"]["byday"]){
					$("#repeaton_"+iSchedulerEditor.editWindowInfo["rrule"]["byday"][i]).prop("checked", true);
				}
			}

			if(typeof(iSchedulerEditor.editWindowInfo["rrule"]["count"]) !== "undefined" || typeof(iSchedulerEditor.editWindowInfo["rrule"]["until"]) !== "undefined" ){
				if(typeof(iSchedulerEditor.editWindowInfo["rrule"]["count"]) !== "undefined"){
					$("#endson_count").prop("checked", true);
					$("#endson_count_input").val(iSchedulerEditor.editWindowInfo["rrule"]["count"]);
				}else
				if(typeof(iSchedulerEditor.editWindowInfo["rrule"]["until"]) !== "undefined"){
					$("#endson_until").prop("checked", true);
					var untilDate = new Date(iSchedulerEditor.editWindowInfo["rrule"]["untilTS"]*1000);
					$("#endson_until_input").datepicker( "setDate" , untilDate);
				}else{
					$("#endson_until_input").val('');
				}
			}else{
				$("#endson_never").prop("checked", true);
				$("#endson_until_input").val('');
				$("#endson_count_input").val('');
			}

		}else{
			$("#cb_repeat").prop("checked", false);
			$("#endson_never").prop("checked", true);
			$("#endson_until_input").val('');
			$("#endson_count_input").val('');
			$("#s-frequency").val(0);
			$("#endson_count_input").val('1');
			$("#s-interval").val('1');
		}
		$(":radio[name=endson]").trigger("change");
		$("#s-frequency").trigger("change");
	},

	fillEditWindowInfo: function(timecardid)
	{
		var timecardInfo = iSchedulerEditor.getTimecardInfo(timecardid);
		iSchedulerEditor.editWindowInfo = {};
		if (timecardInfo){
			iSchedulerEditor.editWindowInfo["postureid"] = timecardInfo['postureid'];
			iSchedulerEditor.editWindowInfo["timecardid"] = timecardid;
			iSchedulerEditor.editWindowInfo["rrule"] = Array.isArray(timecardInfo['timecard']['attributes']['ICAL_DATA']['rrule'])? {} : timecardInfo['timecard']['attributes']['ICAL_DATA']['rrule'];
			iSchedulerEditor.editWindowInfo["start"] = timecardInfo['timecard']['attributes']['ICAL_DATA']['startTS'];
			iSchedulerEditor.editWindowInfo["end"] = timecardInfo['timecard']['attributes']['ICAL_DATA']['endTS'];
		}
	},

	getTimecardInfo: function(timecardid)
	{
		var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
		var i=0;
		for (i=0; i < arrLength; i++){
			if(typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]) != 'undefined'){
				if (iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'] == timecardid){
					return iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i];
				}
			}
		}
		return false;
	},

	fillAddWindow: function(id, calEvent)
	{
		var datefrom = calEvent.start;
		var dateto = calEvent.end;

		var ddf = datefrom.getDate();
		var mmf = datefrom.getMonth();
		var yyf = datefrom.getFullYear();
		var hhf = datefrom.getHours();
		var minf = datefrom.getMinutes();

		var ddt = dateto.getDate();
		var mmt = dateto.getMonth();
		var yyt = dateto.getFullYear();
		var hht = dateto.getHours();
		var mint = dateto.getMinutes();

		$("#eventdatefrom").text(datefrom.toLocaleString());
		$("#eventdateto").text(dateto.toLocaleString());

		$("#t_posturename").text(calEvent.title);

		$("#t_time_from").timePicker();
		$("#t_time_to").timePicker();
		var date_from_val = yyf + "-" + mmf +"-" + ddf;  // YYYY-MM-DD
		var time_from_val = hhf + ":" + minf+ ":00";  // hh:mm:ss
		var date_to_val = yyt + "-" + mmt +"-" + ddf;  // YYYY-MM-DD
		var time_to_val = hht + ":" + mint+ ":00";  // hh:mm:ss
		$("#t_date_from").val(date_from_val);
		$("#t_time_from").val(time_from_val);

		$("#t_date_to").val(date_to_val);
		$("#t_time_to").val(time_to_val);
	},

	getDeviceList: function(params)
	{
		if (!params)
		{
			return;
		}

		params.type = params.type || null;
		params.postureid = params.postureid || null;
		params.scheduleid = params.scheduleid || null;
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		var data = {
			"function": 'getObjectList'
		};

		var isAll = ((params.postureid || params.scheduleid) === null) && params.type !== null;
		if (isAll && isAll != false) data.isAll = isAll;
		if (params.type) data.type = params.type;
		if (params.postureid) data.postureid = params.postureid;
		if (params.scheduleid) data.scheduleid = params.scheduleid;

		$.ajax({
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				if ($.isFunction(params.beforeSend))
				{
					params.beforeSend();
				}
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				if ($.isFunction(params.error))
				{
					params.error();
				}
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					json.list = json.list || [];
					if ($.isFunction(params.success))
					{
						params.success(iSchedulerEditor.changeListFormat(json.list));
					}
				}
			}
		});
	},

	getList: function(params)
	{
		if (!params)
		{
			return;
		}

		params.type = params.type || null;
		params.postureid = params.postureid || null;
		params.scheduleid = params.scheduleid || null;
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;
		params.notinschedule = params.notinschedule || null;
		params.parentObj = params.parentObj || null;


		var data = {
			"function": 'getObjectList'
		};
		if (params.scheduleid) data = {"function": 'getObjectOnScheduleList'};
		if (params.notinschedule) {
			data = {"function": 'getObjectOnScheduleList'};
			params.scheduleid = null;
		}

		var isAll = ((params.postureid || params.scheduleid) === null) && params.type !== null;
		if (isAll && isAll != false) data.isAll = isAll;
		if (params.type) data.type = params.type;
		if (params.postureid) data.postureid = params.postureid;
		if (params.scheduleid) data.scheduleid = params.scheduleid;
		if (params.parentObj) data.parentObj = params.parentObj;

		$.ajax({
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				if ($.isFunction(params.beforeSend))
				{
					params.beforeSend();
					if (params.type == 'schedule'){
						iSchedulerEditor.currschedule = null;
						iSchedulerEditor.scheduleInfo = [];
						iSchedulerEditor.enabledApplyCancel();
					}
				}
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				if ($.isFunction(params.error))
				{
					params.error();
				}
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
					if (params.type == 'schedule'){
						iSchedulerEditor.currschedule = null;
						iSchedulerEditor.scheduleInfo = [];
						iSchedulerEditor.enabledApplyCancel();
					}
				} else {
					json.list = json.list || [];
					if (params.type == 'schedule' && json.list === []){
						iSchedulerEditor.currschedule = null;
						iSchedulerEditor.scheduleInfo = [];
						iSchedulerEditor.enabledApplyCancel();
					}
					if ($.isFunction(params.success))
					{
						params.success(iSchedulerEditor.changeListFormat(json.list));
					}
				}
			}
		});
	},

	convertScheduleListToHTML: function(params)
	{
		params.list = params.list || {};
		params.withUDID = true; //!!params.withUDID;
		params.withProtected = params.withProtected == null ? params.withProtected = true : params.withProtected = !!params.withProtected;
		var list_html = ['<select class="objectList" size="1" style="height:25px;">'];
		if (!$.isEmptyObject(params.list))
		{
			for (var i in params.list)
			{
				var row = params.list[i];
				//if (!row) continue;
				var obj = row.obj;
				var name = row.name;
				var udidlabel = '';
				var label = udidlabel + ' ' + __(name);

				var isProtected = row["protected"] == "1";
				if (!params.withProtected && isProtected)
					continue;

				var item = '<option value="' + obj + '"> ' + label + '</option>';

				list_html.push(item);
			}
		}
		list_html.push('</select>');
		return list_html.join('');
	},

	convertListToHTML: function(params)
	{
		params.list = params.list || {};
		params.withUDID = !!params.withUDID;
		params.withScheduleid = !!params.withScheduleid;
		params.withProtected = params.withProtected == null ? params.withProtected = true : params.withProtected = !!params.withProtected;

		var list_html = ['<select class="objectList" multiple="true">'];
		if (!$.isEmptyObject(params.list))
		{
			for (var i in params.list)
			{
				var row = params.list[i];
				var obj = row.obj;
				var name = row.name;
				var udidlabel = '';
				if (params.withUDID && row.udid && row.udid!=''){
					udidlabel = '[' + row.udid + ']';
				}else{
					udidlabel = '#' + row.obj;
				}
				var label = udidlabel + ' ' + __(name);

				if (params.withScheduleid){
					if (row.scheduleid !==''){
						var strSchedule = '';
						if (typeof(iSchedulerEditor.scheduleNameList[row.scheduleid]) !== 'undefined'){
							strSchedule = " (" + iSchedulerEditor.scheduleNameList[row.scheduleid] + ")";
						}
						label = label + strSchedule;
					}
				}

				var isProtected = row["protected"] == "1";
				if (!params.withProtected && isProtected)
					continue;

				var item = '<option value="' + obj + '"> ' + label + '</option>';

				list_html.push(item);
			}
		}
		list_html.push('</select>');
		return list_html.join('');
	},
	changeListFormat: function(list)
	{
		// TODO: slow code, need optimizing
		var changedList = {};
		for (var i = 0; i < list.length; i++)
		{
			changedList[list[i].obj] = list[i];
		}
		return changedList;
	},

	/**
	 * remove from source array elements with 'obj' that contains in except array
	 * @param source
	 * @param except
	 * @return array
	 */
	removeFromArray: function(source, except)
	{
		var result = {};
		if (!$.isEmptyObject(except))
		{
			// TODO: slow code, need optimizing
			for (var i in source)
			{
				var sourceRow = source[i];
				var add = true;
				for (var j in except)
				{
					var exceptRow = except[j];
					if (sourceRow.obj == exceptRow.obj)
					{
						add = false;
						break;
					}
				}
				if (add)
				{
					result[sourceRow.obj] = sourceRow;
				}
			}
		} else
			result = $.extend({}, source);
		return result;
	},

	/**
	 * remove from source array elements havn't got simbols in filter
	 * @param source
	 * @param filter
	 * @return array
	 */
	removeByFilter: function(source, filter)
	{
		var result = source;
		var maskVal = filter || null;
		if (maskVal) {
			maskVal = maskVal.toLowerCase();
			var a = '\\';
			maskVal = maskVal.replace('(', a+'(');
			maskVal = maskVal.replace(')', a+')');
			maskVal = maskVal.replace('[', a+'[');
			maskVal = maskVal.replace(']', a+']');
			maskVal = maskVal.replace('*', a+'*');
			maskVal = maskVal.replace('+', a+'+');
			maskVal = maskVal.replace('?', a+'?');
		}
		if (maskVal)
		{
			result = {};
			for (var i in source)
			{
				var sourceRow = source[i];
				if (sourceRow["udid"] && sourceRow["udid"]!=''){
					var fullname = sourceRow["udid"].toLowerCase() + sourceRow["name"].toLowerCase();
					var fullname1 = '[' + sourceRow["udid"].toLowerCase()+ '] ' + sourceRow["name"].toLowerCase();
				}else{
					var fullname = sourceRow["obj"].toLowerCase() + sourceRow["name"].toLowerCase();
					var fullname1 = '#' + sourceRow["obj"].toLowerCase()+ ' ' + sourceRow["name"].toLowerCase();
				}

				if (fullname && !(fullname.match(maskVal) || fullname1.match(maskVal)))
				{
					continue;
				}
				result[i] = source[i];
			}
		}
		return result;
	},

	/**
	 * add to source array elements with 'obj' that contains in addition array and not contains in source array
	 * @param source
	 * @param addition
	 * @return array
	 */
	object_merge: function(source, addition)
	{
		var result = $.extend({}, source);
		if (!$.isEmptyObject(addition))
		{
			// TODO: slow code, need optimizing
			for (var i in addition)
			{
				var additionRow = addition[i];
				var add = true;
				for (var j in source)
				{
					var sourceRow = source[j];
					if (sourceRow.obj == additionRow.obj)
					{
						add = false;
						break;
					}
				}
				if (add)
				{
					result[additionRow.obj] = additionRow;
				}
			}
		}
		return result;
	},

	fillPostureList1: function(params)
	{
		if (!params)
			return;

		params.except = params.except || [];
		params.list = params.list || null;
		params.callback = params.callback || null;
		params.scheduleid = params.scheduleid || null;

		if (params.scheduleid === null)
			return;

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iSchedulerEditor.convertListToHTML({
				list: iSchedulerEditor.removeFromArray(list, params.except)
			}));

			var data = {
				"typeList": "posture",
				"type": "posture"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#postures";
		if (params.list)
		{
			fillList(id, params.list);
		} else {
			iSchedulerEditor.getList(
			{
				type: "posture",
				parentObj: params.scheduleid,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iSchedulerEditor.list.was.posture = list;
					fillList(id, iSchedulerEditor.list.was.posture);
					iSchedulerEditor.addEvents();
				}
			});
		}
	},



	fillScheduleList: function(params)
	{
		if (!params)
			return;

		params.withProtected = params.withProtected == null ? params.withProtected = true : params.withProtected = !!params.withProtected;
		params.except = params.except || [];
		params.list = params.list || null;
		params.addition = params.addition || [];
		params.callback = params.callback || null;

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iSchedulerEditor.convertScheduleListToHTML({
				list: iSchedulerEditor.removeFromArray(list, params.except),
				withProtected: params.withProtected
			}));

			var data = {
				"typeList": "schedule",
				"type": "schedule"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#schedule";

		if (params.list)
		{
			 fillList(id, params.list);
		} else {
			iSchedulerEditor.getList(
			{
				type: "schedule",
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iSchedulerEditor.list.was.schedule = list;
					iSchedulerEditor.scheduleNameList = [];
					for (var i in list){
						iSchedulerEditor.scheduleNameList[list[i]['obj']] = list[i]['name'];
					}
					fillList(id, iSchedulerEditor.list.was.schedule);
				}
			});
		}
	},


	fillUnusedPosturesList: function(params)
	{
		if (!params)
			return;

		params.list = params.list || null;
		var id = "#devices";
		if (params.list)
		{
			 fillList(id, params.list);
		} else {
			iSchedulerEditor.getList(
			{
				notinschedule: true,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iSchedulerEditor.list.was.device = list;
					fillList(id, iSchedulerEditor.unusedpostures); // add param
				}
			});
		}

	},

	fillDeviceList: function(params)
	{
		if (!params)
			return;

		params.except = params.except || [];
		params.filter = params.filter || null;
		params.list = params.list || null;
		params.addition = params.addition || [];
		params.callback = params.callback || null;

		var fillList = function(id, list)
		{
			// show only objects with otype = 'D' or 'X'
			var filteredList = {};
			for (var obj in list)
			{
				if (list[obj].otype == "D" || list[obj].otype == "X")
				{
					filteredList[obj] = list[obj];
				}
			}
			$(id + " .objectList").replaceWith(iSchedulerEditor.convertListToHTML({
				list: iSchedulerEditor.removeFromArray(iSchedulerEditor.removeByFilter(filteredList, params.filter), params.except),
				withUDID: true,
				withScheduleid: true
			}));

			var data = {
				"typeList": "device",
				"type": "device"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#devices";

		if (params.list)
		{
			 fillList(id, params.list);
		} else {
			iSchedulerEditor.getList(
			{
				notinschedule: true,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iSchedulerEditor.list.was.device = list;
					fillList(id, iSchedulerEditor.list.was.device); // add param
				}
			});
		}
	},

	getDevice2ScheduleList: function()
	{
		var deviceList = [];
		var pushed = 0;
		for (var i in iSchedulerEditor.list.now.device2schedule){
			if (typeof (iSchedulerEditor.list.now.device2schedule[i]) != 'undefined'){
				pushed = deviceList.push(i);
			}
		}
		return deviceList;
	},


	updatePosturesDivs: function()
	{
		var unused_posture_id = "#unused_posture_list";
		iSchedulerEditor.getUnusedPosturesList({
			beforeSend: function()
			{
				$(unused_posture_id).mask();
			},
			error: function()
			{
				$(unused_posture_id).html('');
			},
			success: function(list)
			{
				iSchedulerEditor.fillUnusedPostures(list);
				$(unused_posture_id).unmask();
			}
		});
	},

	getUnusedPosturesList: function(params)
	{
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		var data = {
			"function": 'getUnusedPosturesList',
			"scheduleid": iSchedulerEditor.currschedule
		};
		var id = "#unused_posture_list";

		$.ajax({
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				if ($.isFunction(params.beforeSend))
				{
					params.beforeSend();
				}
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				if ($.isFunction(params.error))
				{
					params.error();
				}
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					json.list = json.list || [];
					if ($.isFunction(params.success))
					{
						iSchedulerEditor.unusedPostures = json.list;
						var list = {};
						for (var i in json.list){
							list[json.list[i]['obj']] = json.list[i]['name'];
						}
						params.success(json.list);
					}
				}
			}
		});
	},

	fillSelect: function(list, id, selectedval)
	{
		selectedval = selectedval || false;
		$(id).empty();
		for (var i in list){
			if (selectedval && selectedval==i){
				$(id).append( $('<option value="'+i+'" selected="selected">'+list[i]+'</option>'));
			}else{
				$(id).append( $('<option value="'+i+'">'+list[i]+'</option>'));
			}
		}
	},

	getScheduleInfo: function(params)
	{
		params.scheduleid = params.scheduleid || null;
		params.callback = params.callback || null;

		var data = {
			"function": 'getScheduleInfo'
		};
		if (params.scheduleid) data.scheduleid = params.scheduleid;
		var id = "#calendar";

		$.ajax({
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				if ($.isFunction(params.beforeSend))
				{
					params.beforeSend();
				}
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				if ($.isFunction(params.error))
				{
					params.error();
				}
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					json.list = json.list || [];
					if ($.isFunction(params.success))
					{
						params.success(json.list);
					}
				}
			}
		});
	},



	fillUnusedPostures: function(postures_list)
	{
		if (!postures_list)
			return;
		var id = "#unused_posture_list";
		var list_html = '';
		var def_id = "#def_posture_list";
		var def_list_html = '';
		for (var i = 0; i < postures_list.length; i++)
		{
			if (typeof(postures_list[i]['DEFAULT']) !== "undefined" && postures_list[i]['DEFAULT'] == "true"){
				def_list_html += "<div class='postureinfo def_posture' id='posture_"+postures_list[i]['obj']+"' data-postureid="+postures_list[i]['obj']+" style='height:20px; margin:10px; cursor:	pointer; background:#8B8B8B;'>\n";
				def_list_html += "&nbsp;<div style='margin:0; float:right; width:75%;' class='default_posture' data-postureid="+postures_list[i]['obj']+">"+postures_list[i]['name']+"</div>\n";
				def_list_html += "</div>\n";
			}else{
				var post_div = '';
				post_div += "<div class='postureinfo' id='posture_"+postures_list[i]['obj']+"' data-postureid="+postures_list[i]['obj']+" style='height:20px; margin:10px; cursor:n-resize; background:#8B8B8B url(img/sort.png) no-repeat 2px 2px;'>\n";
				post_div += "&nbsp;<div style='margin:0; float:right; width:75%' class='unused_posture' data-postureid="+postures_list[i]['obj']+">"+postures_list[i]['name']+"</div>\n";
				post_div += "</div>\n";
				list_html = post_div + list_html;
			}
		}
		$(id).html(list_html);
		$(def_id).html(def_list_html);

		$('#unused_posture_list, #def_posture_list').undelegate(".unused_posture", "dblclick click");
		$('#unused_posture_list, #def_posture_list').delegate(".unused_posture", "dblclick click",function(){
			var type = "posture";
			var obj = $(this).data("postureid");

			var buttons = {back: {show: false}};
			if ($(this).hasClass('def_posture')){
				buttons = {back: {show: false}, remove: {show: false}};
			}

			if (type && obj)
			{
				iSchedulerEditor.createEditor({
					obj: obj,
					id: "#editor_sch .content",
					type: type,
					buttons:buttons
				});
				var func = function(obj, success)
				{
					if (success)
					{
						iSchedulerEditor.destroyEditor();
						iSchedulerEditor.fillPostureList1({"scheduleid":iSchedulerEditor.currschedule});
						iSchedulerEditor.updatePosturesDivs();
					}
				};

				var delfunc = function(obj, success)
				{
					if (success)
					{
						iSchedulerEditor.destroyEditor();
						iSchedulerEditor.fillPostureList1({"scheduleid":iSchedulerEditor.currschedule});
						iSchedulerEditor.updatePosturesDivs();

						//Delete calendar from iSchedulerEditor
						var calendar_id = "#calendar";
						iSchedulerEditor.getScheduleInfo({
							scheduleid: iSchedulerEditor.currschedule,//schedule[0],
							beforeSend: function()
							{
								$(calendar_id).mask();
							},
							error: function()
							{
								$(calendar_id).html('');
							},
							success: function(list)
							{
								iSchedulerEditor.scheduleInfo = list;
								iSchedulerEditor.fillCalendar(list);
								iSchedulerEditor.enabledApplyCancel(false);
							}

						});
					}
				};
				iSchedulerEditor.editor.onSave = func;
				iSchedulerEditor.editor.onDelete = delfunc;
			}
		});

		$('#unused_posture_list div.unused_posture').each(function() {
			var eventObject = {
				title: $.trim($(this).text()), // use the element's text as the event title
				postureid: $(this).data("postureid")
			};
			$(this).data('eventObject', eventObject);
			$(this).draggable({
				appendTo: 'body',
				helper: 'clone',
				zIndex: 999,
				revert: true,      // will cause the event to go back to its
				revertDuration: 0  //  original position after the drag
			});
		});
		$("#unused_posture_list").sortable({ opacity: 0.8, cursor: 'move',
			axis: 'y',
			distance: '5',
			delay: '100',
			containment: 'parent',
			update: function() {
				var order = $(this).sortable("toArray");
				var len = order.length-1;
				var postures = [];
				for (i in order){
					postures[len - i] = order[i].replace('posture_','')*1;
				}
				iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['postures'] = postures;
				iSchedulerEditor.enabledApplyCancel(true);
			}
		});

	},

	setScheduleInfo: function()
	{
		var currschedule = iSchedulerEditor.currschedule;
		var scheduleInfo = iSchedulerEditor.scheduleInfo;

		var data = {
			"function": 'setScheduleInfo'
		};
		data.scheduleid = currschedule;
		data.scheduleInfo = JSON.stringify(scheduleInfo);

		var calendar_id = "#calendar";

		$.ajax({
			type: "POST",
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				$(calendar_id).mask();
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				$(calendar_id).html('');
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					var list = json.list || [];
					iSchedulerEditor.scheduleInfo = list;
					iSchedulerEditor.fillCalendar(list);
					$(calendar_id).unmask();
				}
			}
		});


	},


	saveObjectsOnSchedule: function()
	{
		var deviceList = iSchedulerEditor.getDevice2ScheduleList();
		var olddeviceList = iSchedulerEditor.oldDevice2ScheduleList; //!

		var odl = [];
		var isrepeat = false;
		for (var i = 0; i < olddeviceList.length; i++) {
			isrepeat = false;
			var repeat_j = -1;
			for (var j = 0; j < deviceList.length; j++) {
				if (deviceList[j] == olddeviceList[i]){
					isrepeat = true;
					repeat_j = j;
				}
			}
			if (!isrepeat){
				odl.push(olddeviceList[i]);
			}else{
				deviceList.splice(repeat_j,1);
			}
		}
		olddeviceList = odl;
		if (olddeviceList.length == 0 && deviceList.length == 0){
			return false;
		}

		var data = {
			"function": 'saveObjectsOnSchedule'
		};
		data.scheduleid = iSchedulerEditor.currschedule;
		data.oldobjlist = JSON.stringify(olddeviceList);
		data.objlist = JSON.stringify(deviceList);

		var calendar_id = "#calendar";

		$.ajax({
			type: "POST",
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				$(calendar_id).mask();
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				$(calendar_id).html('');
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					json.list = json.list || [];
					var device2schedule = [];
					for (var i in json.list){
						device2schedule[json.list[i].obj] = json.list[i];
					}
					iSchedulerEditor.list.was.device2schedule = device2schedule;
					iSchedulerEditor.list.now.device2schedule = device2schedule;
					iSchedulerEditor.list.now.device = null;
					iSchedulerEditor.oldDevice2ScheduleList = iSchedulerEditor.getDevice2ScheduleList();
					$(calendar_id).unmask();
				}
			}
		});

	},

	/**
	*
	* difficult function for convert calendar[j] structure to fullCalendar structure (event)
	*
	**/
	scheduleInfoToFCal: function()
	{
		var params = iSchedulerEditor.scheduleInfo;
		if (!params)
			return;

		iSchedulerEditor.newTimeCardID = 0;
		var date = new Date();
		var d = date.getDate();
		var m = date.getMonth();
		var y = date.getFullYear();

		var id = "#calendar";
		//delete all events in fCal
		//get startview (visStart) and endview (visEnd)
		var view = $('#calendar').fullCalendar('getView');
		var visStart = view.visStart; //Date object
		var visEnd = view.visEnd;	//Date object
		$('#calendar').fullCalendar('removeEvents');
		var eventSource = [];

		for (var i in params)
		{
			var schedule = params[i];
			if (schedule['calendar'].length>0){
				for (var j in schedule['calendar']){
					var cal_info = schedule['calendar'][j];
					if (cal_info['postureid']>0 && cal_info['timecardid']>0){

			// view posture-timecard
						var originalEventObject = 1;
						var oneEvent = $.extend({}, originalEventObject);
						oneEvent.id = cal_info['timecardid'];
						///////////////////////////////
						//TODO: need to get posturename
						//cal_info['posture']['name'] or
						//cal_info['posture']['attributes']['NAME']
						////////////////////////////////
						oneEvent.title = cal_info['postureid'];
						oneEvent.timecardname = cal_info['timecardid']; /*???????????*/
						///////////////////////////////
						//EOF need to get posturename
						////////////////////////////////
						oneEvent.postureid = cal_info['postureid'];
						oneEvent.timecardid = cal_info['timecardid'];

						var ruleattrs = cal_info['timecard']['attributes']['ICAL_DATA'];
						// may be need to convert to datetime class
						oneEvent.start = new Date();
						oneEvent.end = new Date();
						oneEvent.start.setTime(ruleattrs['startTS']*1000);
						oneEvent.end.setTime(ruleattrs['endTS']*1000);
						oneEvent.allDay = false;
						var oneEvent1 = clone(oneEvent);
						eventSource.push(oneEvent1);
						/////////////////////////////////////////
						///parse rrule
						/////////////////////////////////////////
						if (ruleattrs['rrule']['frequency'] !== undefined){
							var er_frequency = ruleattrs['rrule']['frequency'];
							var er_interval = 0;
							var er_byday = [];
							var er_count = 0;
							var er_until = 0;
							var er_period = 1;

							if (ruleattrs['rrule']['interval'] !== undefined && ruleattrs['rrule']['interval']>0){
								er_interval = ruleattrs['rrule']['interval']
							}
							if (ruleattrs['rrule']['count'] !== undefined && ruleattrs['rrule']['count']>0){
								er_count = ruleattrs['rrule']['count']
							}
							if (ruleattrs['rrule']['until'] !== undefined){
								er_until = ruleattrs['rrule']['until']
							}
							if (ruleattrs['rrule']['byday'] !== undefined){
								er_byday = ruleattrs['rrule']['byday']
							}
							if (ruleattrs['rrule']['period'] !== undefined){
								er_period = ruleattrs['rrule']['period']
							}
							if (er_interval>=0 && oneEvent.start.isEarly(visEnd)){
								var lastdate;
								if (er_interval == 0) er_interval=1;
								var i=0;
								var doExit = false;
								var startdate = oneEvent.start.copy();
								var enddate = oneEvent.end.copy();
								if (er_count>0){
									if (er_frequency == 'DAILY') lastdate = startdate.addDaysRet(er_count*er_period);
									if (er_frequency == 'WEEKLY') lastdate = startdate.addWeeksRet(er_count*er_period);
									if (er_frequency == 'MONTHLY') lastdate = startdate.addMonthsRet(er_count*er_period);
								}
								if (er_until!=0){
									lastdate = er_until; //date
								}
								if (er_count==0 && er_until==0) lastdate = visEnd.copy();
								lastdate.getEarly(visEnd);

								var i=0;
								while (!doExit){
									var result_start = oneEvent.start.copy();
									var result_end = oneEvent.end.copy();
									i++;
									// result = start + i*uFreq*period days, if result>visStart => add to oneEvent
									if (er_frequency == 'DAILY') {
										result_start = startdate.addDaysRet(i*er_period);
										result_end = enddate.addDaysRet(i*er_period);
									}
									if (er_frequency == 'WEEKLY') {
										result_start = startdate.addWeeksRet(i*er_period);
										result_end = enddate.addWeeksRet(i*er_period);
									}
									if (er_frequency == 'MONTHLY') {
										result_start = startdate.addMonthsRet(i*er_period);
										result_end = enddate.addMonthsRet(i*er_period);
									}

									////////////////////////////////////////////////////////////
									///result = start + i*uFreq*period days, if result>visStart => add to oneEvent
									/////////////////////////////////////////////////////////////
									//if result>visStart => add to oneEvent
									if (!result_start.isEarly(visStart) && result_start.isEarly(lastdate)
										|| !result_end.isEarly(visStart) && result_end.isEarly(visEnd)) {
										oneEvent.start = result_start.copy();
										oneEvent.end = result_end.copy();
										var oneEvent1 = clone(oneEvent);
										eventSource.push(oneEvent1);
										//$('#calendar').fullCalendar('renderEvent', oneEvent, true);
									}//add to oneEvent


									// if freq=weekly and er_byday.count >0
									if (er_frequency == 'WEEKLY' && er_byday.count >0) {

										// result = start + i*uFreq*period days, if result>visStart => add to oneEvent
										// get date of start week  -- startWeekDate
										var dCS = result_start.getDay();
										var result1_start = result_start.copy();
										var result1_end = result_end.copy();
										for (j=0; j++; j<=6){
											var result1_start = result_start.copy();
											var result1_end = result_end.copy();
											if (er_byday[j]='MO'){result1_start.addDays(-dCS + 0); result1_end.addDays(-dCS + 0);}
											if (er_byday[j]='TU'){result1_start.addDays(-dCS + 1); result1_end.addDays(-dCS + 1);}
											if (er_byday[j]='WE'){result1_start.addDays(-dCS + 2); result1_end.addDays(-dCS + 2);}
											if (er_byday[j]='TH'){result1_start.addDays(-dCS + 3); result1_end.addDays(-dCS + 3);}
											if (er_byday[j]='FR'){result1_start.addDays(-dCS + 4); result1_end.addDays(-dCS + 4);}
											if (er_byday[j]='SA'){result1_start.addDays(-dCS + 5); result1_end.addDays(-dCS + 5);}
											if (er_byday[j]='SU'){result1_start.addDays(-dCS + 6); result1_end.addDays(-dCS + 6);}

											//if result1<visEnd add result1 to oneEvent
											if (!result1_start.isEarly(visStart) && result1_start.isEarly(lastdate)
												|| !result1_end.isEarly(visStart) && result1_end.isEarly(visEnd)) {
												oneEvent.start = result1_start.copy();
												oneEvent.end = result1_end.copy();
												var oneEvent1 = clone(oneEvent);
												eventSource.push(oneEvent1);
												//$('#calendar').fullCalendar('renderEvent', oneEvent, true);
											}//add to oneEvent

										}
									}
									if (!result_start.isEarly(lastdate)) break;
								}
							}
						}
						/////////////////////////////////////////
						///eof parse rrule
						/////////////////////////////////////////
			// eof view posture-timecard
					}

				}
			}
		}
		$('#calendar').fullCalendar( 'addEventSource', eventSource );
	},

	getEventSource: function(doFill)
	{
		doFill = doFill || false;
		var calendar_id = '#calendar';
		var data = {
			"function": 'getEventSource'
		};
		data.scheduleid = iSchedulerEditor.currschedule;
		var view = $('#calendar').fullCalendar('getView');
		if (typeof(view) !== "undefined"){
			var visStart = view.visStart; //Date object
			var visEnd = view.visEnd;	//Date object
			// convert visStart, visEnd to TimeStamp
			visStart = visStart.valueOf()/1000 - visStart.getTimezoneOffset()*60;
			visEnd = visEnd.valueOf()/1000 - visEnd.getTimezoneOffset()*60;
			data.datefrom = visStart;
			data.dateto = visEnd;
		}

		$.ajax({
			type: "GET",
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				$(calendar_id).mask();
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				//$(calendar_id).html('');
				$(calendar_id).unmask();
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					var list = json.list;
					for (var i in list){
						if(typeof(list[i]['startArr']) != 'undefined' && typeof(list[i]['endArr']) != 'undefined' &&
							typeof(list[i]['id']) != 'undefined' ){
							var startDateArr = list[i]['startArr'].split(',');
							var endDateArr = list[i]['endArr'].split(',');
							var tstart = new Date(startDateArr[0], startDateArr[1]-1, startDateArr[2], startDateArr[3], startDateArr[4], startDateArr[5]);
							var tend = new Date(endDateArr[0], endDateArr[1]-1, endDateArr[2], endDateArr[3], endDateArr[4], endDateArr[5]);
	/*
							var tstart = new Date();
							var tend = new Date();
							tstart.setTime(list[i]['startTS']*1000);//+ tstart.getTimezoneOffset()*60*1000);
							tstart.setTime(tstart.getTime() + tstart.getTimezoneOffset()*60*1000);
							tend.setTime(list[i]['endTS']*1000);// + tend.getTimezoneOffset()*60*1000);
							tend.setTime(tend.getTime() + tend.getTimezoneOffset()*60*1000);
	*/

							list[i]['start'] = tstart;
							list[i]['end'] = tend;
							list[i]['id'] = list[i]['id']*1;
							list[i]['allDay'] = false;
						}

					}
					iSchedulerEditor.eventSource = list;
					if (doFill){
						iSchedulerEditor.fillCalendarEventSource();
					}
					$(calendar_id).unmask();
				}
			}
		});

	},

	convertScheduleInfoToEventSource: function(doFill)
	{
		doFill = doFill || false;
		var calendar_id = '#calendar';
		var data = {
			"function": 'convertScheduleInfoToEventSource'
		};
		// if not currschedule - return
		if (iSchedulerEditor.currschedule === null) return false;
		data.scheduleid = iSchedulerEditor.currschedule;
		data.scheduleInfo = JSON.stringify(iSchedulerEditor.scheduleInfo);
		var view = $('#calendar').fullCalendar('getView');
		if (typeof(view) !== "undefined" ){
			var visStart = view.visStart.valueOf()/1000 - view.visStart.getTimezoneOffset()*60; //Date object
			var visEnd = view.visEnd.valueOf()/1000 - view.visEnd.getTimezoneOffset()*60;	//Date object
			data.datefrom = visStart;
			data.dateto = visEnd;
		}

		$.ajax({
			type: "POST",
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			beforeSend: function(XMLHttpRequest)
			{
				$(calendar_id).mask();
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				//$(calendar_id).html('');
			},
			success: function(json)
			{
				if (json.error !== "")
				{
					Log.error(json.error);
				} else {
					var list = json.list;
					for (var i in list){
						//new Date(1,2,3,4,5,6)
						//Sun Mar 03 1901 04:05:06 GMT+0300 (Russian Standard Time)
						// get date Array
						// parse dates
						if(typeof(list[i]['startArr']) != 'undefined' && typeof(list[i]['endArr']) != 'undefined' &&
							typeof(list[i]['id']) != 'undefined' ){


							var startDateArr = list[i]['startArr'].split(',');
							var endDateArr = list[i]['endArr'].split(',');
							var tstart = new Date(startDateArr[0], startDateArr[1]-1, startDateArr[2], startDateArr[3], startDateArr[4], startDateArr[5]);
							var tend = new Date(endDateArr[0], endDateArr[1]-1, endDateArr[2], endDateArr[3], endDateArr[4], endDateArr[5]);

							/*var tstart = new Date();
							var tend = new Date();
							tstart.setTime(list[i]['startTS']*1000);//+ tstart.getTimezoneOffset()*60*1000);
							tstart.setTime(tstart.getTime() + tstart.getTimezoneOffset()*60*1000);
							tend.setTime(list[i]['endTS']*1000);// + tend.getTimezoneOffset()*60*1000);
							tend.setTime(tend.getTime() + tend.getTimezoneOffset()*60*1000);*/
							list[i]['start'] = tstart;
							list[i]['end'] = tend;
							list[i]['id'] = list[i]['id']*1;
							list[i]['allDay'] = false;
						}
					}
					iSchedulerEditor.eventSource = list;
					if (doFill){
						iSchedulerEditor.fillCalendarEventSource();
					}
					$(calendar_id).unmask();
				}
			}
		});
	},

	fillCalendarEventSource: function()
	{
		$('#calendar').fullCalendar('removeEvents');
		$('#calendar').fullCalendar( 'addEventSource', iSchedulerEditor.eventSource );

		var blockHeight = $("#calendar").outerHeight()+10;
		$("#schedulerManager .schedulerManager_content").height(blockHeight);
	},

	fillCalendar: function(params)
	{

		iSchedulerEditor.getEventSource(true);
		//iSchedulerEditor.scheduleInfoToFCal();
		$('#calendar').fullCalendar('refetchEvents');
		var blockHeight = $("#calendar").outerHeight()+10;
		$("#schedulerManager .schedulerManager_content").height(blockHeight);
	},

	deleteTimecard: function(scheduleid, postureid, timecardid)
	{
		if (!scheduleid || !postureid || !timecardid)
			return;
		//delete from scheduleinfo.calendar
		//add to scheduleinfo.deleted
		var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
		var i=0;
		for (i=0; i < arrLength; i++){
			if (typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]) != 'undefined' &&
				iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'] == timecardid && iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['postureid'] == postureid){

		// if TC was without RRULE  - delete it.
		// if had RRULE and first item - delete all !!!
		// if had RRULE and NOT first item
		// open dialog for deletion of 	Timecard
		//	if delete one item
		//	if delete rang from item

		//get date
		var startDate = Math.floor(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['startTS']/(60*60*24))*(60*60*24);


				if(
					// if TC was without RRULE  - delete it.
					typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']) == 'undefined'
					|| typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']['frequency']) == 'undefined'

					|| (
					// if had RRULE and start == until - delete all !!!
						typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']['untilTS']) == 'undefined'
						&& startDate <= Math.floor(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']['untilTS']/(60*60*24))*(60*60*24)
					)
					/*|| (
						typeof(iSchedulerEditor.tmpevent.first) != "undefined" && iSchedulerEditor.tmpevent.first
					)*/
					// if had RRULE and first item - delete all !!!

					){
					if (typeof iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['deleted'] == "undefined"){
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['deleted'] = [];
					}
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['deleted'].push({"timecardid":timecardid, "postureid":postureid});
					delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i];

					$('#calendar').fullCalendar( 'removeEvents' , timecardid);
					iSchedulerEditor.editWindowInfo = {};
					iSchedulerEditor.enabledApplyCancel(true);
					$('#mask, .window').hide();
				}else{
					// iSchedulerEditor.tmpevent.oldStartDS = eventOldStartDS;
					// prepare form
					if (typeof(iSchedulerEditor.tmpevent.first) != "undefined" && iSchedulerEditor.tmpevent.first){
						$('#delete_tc_all_range').show();
						$('#delete_tc_do_one_item').hide();
						$('#delete_tc_do_range').hide();
					}else{
						$('#delete_tc_all_range').hide();
						$('#delete_tc_do_one_item').show();
						$('#delete_tc_do_range').show();
					}
					iSchedulerEditor.openModal("#confirm_delete_tc", 100, 100);
					// open dialog for deletion of 	Timecard
				}

				break;
			}
		}
	},

	updateTimecard1: function(scheduleid, postureid, timecardid, timecardinfo)
	{
		if (!scheduleid || !postureid || !timecardid)
			return;
		//update from scheduleinfo.calendar
		var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
		var i=0;
		function isObject(obj){
			return typeof(obj) == "object";
		}
		/*function isEmptyObject(obj){
			if ( typeof(obj) == "object" ){
				var key;
				for ( key in obj ) {
					return false;
				}
				return true;
			}else{
				return true;
			}
		}*/
		iSchedulerEditor.tmpevent.NAME = timecardinfo['attr']['NAME'];
		iSchedulerEditor.tmpevent.UDID = timecardinfo['attr']['UDID'];
		iSchedulerEditor.tmpevent.DESCRIPTION = timecardinfo['attr']['DESCRIPTION'];

		for (i=0; i < arrLength; i++){
			if (typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]) != "undefined"
				&& iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'] == timecardid
				&& iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['postureid'] == postureid){
		// if TC was without RRULE  - update it.
		// if had RRULE and first item - update all
		// if had RRULE and NOT first item
		// open dialog for update of 	Timecard
				if (!isObject(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule'])
					|| $.isEmptyObject(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule'])
				){
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['NAME'] = timecardinfo['attr']['NAME'];
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['UDID'] = timecardinfo['attr']['UDID'];
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['DESCRIPTION'] = timecardinfo['attr']['DESCRIPTION'];

					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['NAME'] = timecardinfo['attr']['NAME'];
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['UDID'] = timecardinfo['attr']['UDID'];
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['DESCRIPTION'] = timecardinfo['attr']['DESCRIPTION'];
					iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA'] = timecardinfo;

					iSchedulerEditor.editWindowInfo = {};
					iSchedulerEditor.enabledApplyCancel(true);
					$('#mask, .window').hide();
					iSchedulerEditor.convertScheduleInfoToEventSource(true);

				}else{
					var openModalFlag = 0;

					if (typeof(timecardinfo.rrule) == 'undefined' || $.isEmptyObject(timecardinfo.rrule)
					){
						//если изменилось RRULE, то будет запрос менять все с этого или нет
						//iSchedulerEditor.tmpevent.rrule = {};
						iSchedulerEditor.tmpevent.ICAL_DATA.rrule = {};
						openModalFlag = 2;
					}else
					if (typeof(iSchedulerEditor.tmpevent.ICAL_DATA.rrule) != 'undefined'
							&& typeof(timecardinfo.rrule) != 'undefined'
							&& !$.isEmptyObject(timecardinfo.rrule)
							&& iSchedulerEditor.tmpevent.ICAL_DATA.rrule != timecardinfo.rrule
					){
						//если изменилось RRULE, то будет запрос менять все с этого или нет
						iSchedulerEditor.tmpevent.ICAL_DATA.rrule = timecardinfo.rrule;
						openModalFlag = 2;
					}

					if (timecardinfo.start.valueOf() != iSchedulerEditor.tmpevent.start.valueOf() || timecardinfo.end.valueOf() != iSchedulerEditor.tmpevent.end.valueOf()){
						//если изменилось начало или конец итема, то будет запрос один итем или все с этого
						// изменить в iSchedulerEditor.tmpevent
						iSchedulerEditor.tmpevent.end = timecardinfo.end;
						iSchedulerEditor.tmpevent.endTS = timecardinfo.endTS;
						iSchedulerEditor.tmpevent.start = timecardinfo.start;
						iSchedulerEditor.tmpevent.startTS = timecardinfo.startTS;
						iSchedulerEditor.tmpevent.eventstartTS = parseInt(iSchedulerEditor.tmpevent.start.valueOf()/ 1000) - iSchedulerEditor.tmpevent.start.getTimezoneOffset()*60;
						iSchedulerEditor.tmpevent.eventendTS = parseInt(iSchedulerEditor.tmpevent.end.valueOf()/ 1000) - iSchedulerEditor.tmpevent.start.getTimezoneOffset()*60;
						openModalFlag = 1;
					}
					if (timecardinfo.tcattr != iSchedulerEditor.tmpevent.tcattr){
						//если изменились только атрибуты, изменить без запроса
						iSchedulerEditor.tmpevent.tcattr = timecardinfo.tcattr;
						if (openModalFlag == 0){
						//openModalFlag = 0;
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['NAME'] = timecardinfo['attr']['NAME'];
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['UDID'] = timecardinfo['attr']['UDID'];
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['DESCRIPTION'] = timecardinfo['attr']['DESCRIPTION'];

						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['NAME'] = timecardinfo['attr']['NAME'];
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['UDID'] = timecardinfo['attr']['UDID'];
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['DESCRIPTION'] = timecardinfo['attr']['DESCRIPTION'];
						iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA'] = timecardinfo;

						iSchedulerEditor.editWindowInfo = {};
						iSchedulerEditor.enabledApplyCancel(true);
						$('#mask, .window').hide();
						iSchedulerEditor.convertScheduleInfoToEventSource(true);
						return;
						}

					}

					if (typeof(iSchedulerEditor.tmpevent.first) != "undefined" && iSchedulerEditor.tmpevent.first){
						$('#edit_tc_all_range').show();
						$('#edit_tc_do_one_item').hide();
						$('#edit_tc_do_range').hide();
					}else{
						$('#edit_tc_all_range').hide();
						$('#edit_tc_do_range').show();
						if (openModalFlag == 1){
							$('#edit_tc_do_one_item').show();
						}else if (openModalFlag == 2){
							$('#edit_tc_do_one_item').hide();
						}
					}
					iSchedulerEditor.openModal("#confirm_edit_tc", 100, 100, openModalFlag);
				}

				break;
			}
		}
	},

	fillDevice2ScheduleList: function(params)
	{
		if (!params)
			return;

		params.setid = params.setid || null;
		params.scheduleid = params.scheduleid || null;
		params.list = params.list || null;
		params.filter = params.filter || null;
		params.callback = params.callback || null;

		if (iSchedulerEditor.isDevice2scheduleListChanged)
		{
			Log.warning(__("device2schedule was changed, you can lost your changes"));
		}

		var fillList = function(id, list)
		{
			// show only objects with otype = 'D' or 'X'
			var filteredList = {};
			for (var obj in list)
			{
				if (list[obj].otype == "D" || list[obj].otype == "X")
				{
					filteredList[obj] = list[obj];
				}
			}
			$(id + " .objectList").replaceWith(iSchedulerEditor.convertListToHTML({
				list: iSchedulerEditor.removeFromArray(iSchedulerEditor.removeByFilter(filteredList, params.filter), params.except),
				withUDID: true
			}));

			var data = {
				"typeList": "device2schedule",
				"type": "device"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#device2schedule";

		if (params.list)
		{
			fillList(id, params.list);
		} else {
			if (!params.scheduleid)
			{
				Log.error(__("Please specify scheduleid"));
				return;
			}
			iSchedulerEditor.getList(
			{
				scheduleid:params.scheduleid,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iSchedulerEditor.list.was.device2schedule = list;
					fillList(id, iSchedulerEditor.list.was.device2schedule);
					iSchedulerEditor.list.now.device2schedule = iSchedulerEditor.list.was.device2schedule;
					iSchedulerEditor.oldDevice2ScheduleList = iSchedulerEditor.getDevice2ScheduleList();
				}
			});
		}
	},
	createEditor: function(params)
	{
		params.obj = params.obj || null;
		params.id = params.id || null;
		params.type = params.type || null;
		params.buttons = params.buttons || null;
		params.attributes = params.attributes || {};

		if (params.id && params.type)
		{
			$("#editor_sch").show();
			iSchedulerEditor.editor = new Editor({
				obj: params.obj,
				id: params.id,
				type: params.type,
				notReload: true,
				attributes: params.attributes
			});

			if (params.buttons)
				iSchedulerEditor.editor.setButtons(params.buttons);

			iSchedulerEditor.editor.init();
		}
	},
	fillObjectAttributes: function(object_id, callback)
	{
		$("#postureattrs").mask();
		var type = "posture";
		var aditionalAttributes = {};
		var api = new API();
		api.getTemplates({
			obj: object_id,
			type: type,
			attributes: JSON.stringify(aditionalAttributes)
		})
			.fail(function (code, message){
				Log.error(message);
			})
			.done(function (response){
				if (response.template)
				{
					// load validate functions
					var objectTemplate = json.template;
					var isMassObjectEditor = true;
					iSchedulerEditor.attrList = objectTemplate;
					iSchedulerEditor.createObjectAttributes(object_id, objectTemplate, "postureattrs", isMassObjectEditor);
					$("#postureattrs").unmask();
				}
				$("#postureattrs").unmask();
			});
	},

	enabledApplyCancel: function(isEnabled)
	{
		if (typeof(iSchedulerEditor.currschedule) == 'undefined' || iSchedulerEditor.currschedule === null	|| iSchedulerEditor.currschedule<100){
			$("#deleteschedule").prop("disabled", true);
			$("#editschedule").prop("disabled", true);
			$("#editdevices").prop("disabled", true);
			$("#addposture").prop("disabled", true);
			$("#calendarsave").prop("disabled", true);
			$("#calendarcansel").prop("disabled", true);
			iSchedulerEditor.isNeedToSaveScheduleInfo = false;
		} else {
			$("#deleteschedule").prop("disabled", false);
			$("#editschedule").prop("disabled", false);
			$("#editdevices").prop("disabled", false);
			$("#addposture").prop("disabled", false);
		}
		if (isEnabled){
			$("#calendarsave").prop("disabled", false);
			$("#calendarcansel").prop("disabled", false);
			iSchedulerEditor.isNeedToSaveScheduleInfo = true;
			$("#warning_msg").show();
			$("#warning_fake").hide();
		} else {
			$("#calendarsave").prop("disabled", true);
			$("#calendarcansel").prop("disabled", true);
			iSchedulerEditor.isNeedToSaveScheduleInfo = false;
			$("#warning_msg").hide();
			$("#warning_fake").show();
		}
	},

	fillTMPevent: function(event)
	{
		iSchedulerEditor.tmpevent = {};
		iSchedulerEditor.tmpevent.allDay = event.allDay;
		iSchedulerEditor.tmpevent.end = event.end;
		iSchedulerEditor.tmpevent.endTS = event.endTS;
		iSchedulerEditor.tmpevent.eventstartTS = parseInt(event.start.valueOf()/ 1000) - event.start.getTimezoneOffset()*60;
		iSchedulerEditor.tmpevent.eventendTS = parseInt(event.end.valueOf()/ 1000) - event.start.getTimezoneOffset()*60;
		iSchedulerEditor.tmpevent.id = event.id;
		iSchedulerEditor.tmpevent.postureid = event.postureid;
		iSchedulerEditor.tmpevent.start = event.start;
		iSchedulerEditor.tmpevent.startTS = event.startTS;
		iSchedulerEditor.tmpevent.timecardid = event.timecardid;
		iSchedulerEditor.tmpevent.title = event.title;
		if(typeof(event.first) != "undefined" && event.first){
			iSchedulerEditor.tmpevent.first = event.first;
		}
	},


	editTC_one_item: function(doDelete)
	{
		doDelete = doDelete || false;
		var event = iSchedulerEditor.tmpevent;
		var currdate = new Date();
		var currDS = currdate.valueOf();
		var eventStartDS = iSchedulerEditor.tmpevent.eventstartTS;
		var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
		var i = event.i;
		var eventOldStartDS = iSchedulerEditor.tmpevent.oldStartDS;

		//create exrule element
		var exdate = eventOldStartDS;
		var exdateTS = parseInt(exdate/ 1000);

		if(typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['exdate']) != "undefined"){
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['exdate'].push(exdateTS);
		}else{
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['exdate'] = [];
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['exdate'][0] = exdateTS;
		}
		if (!doDelete){
			//create TC
			var newCalendar = clone(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]);
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].push(newCalendar);
			var j = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length-1;

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['id'] = ++iSchedulerEditor.newTimeCardID;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecardid'] = iSchedulerEditor.newTimeCardID;

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['startTS'] = iSchedulerEditor.tmpevent.eventstartTS;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.tmpevent.eventendTS;

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['NAME'] = iSchedulerEditor.tmpevent.NAME;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['UDID'] = iSchedulerEditor.tmpevent.UDID;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['DESCRIPTION'] = iSchedulerEditor.tmpevent.DESCRIPTION;

			delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['UDID'];
			delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['rrule'];
			delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['exdate'];
			//EOF create TC
		}

		iSchedulerEditor.convertScheduleInfoToEventSource(true);
		iSchedulerEditor.enabledApplyCancel(true);
		$('#mask, .window').hide();
	},

	editTC_from_datepoint: function(doDelete)
	{
		doDelete = doDelete || false;
		// Добавить окончание в выбранную дату
		// создать новый ТС с выбранной даты
		var event = iSchedulerEditor.tmpevent;
		var currdate = new Date();
		var currDS = currdate.valueOf();
		var eventStartDS = iSchedulerEditor.tmpevent.eventstartTS;
		var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
		var i = event.i;
		var eventOldStartDS = iSchedulerEditor.tmpevent.oldStartDS;

		//create exrule element
		var untilDate = eventOldStartDS;
		var untilDateTS = parseInt(untilDate/ 1000);
		var untilDT = new Date(untilDate);
		var untilArr = {
			"year": untilDT.getFullYear(),
			"month": untilDT.getMonth()*1 + 1,
			"day": untilDT.getDate()
		};
		if(!doDelete){
			//create new TC
			var newCalendar = clone(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]);
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].push(newCalendar);
			var j = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length-1;

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['id'] = ++iSchedulerEditor.newTimeCardID;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecardid'] = iSchedulerEditor.newTimeCardID;

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['startTS'] = iSchedulerEditor.tmpevent.eventstartTS;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.tmpevent.eventendTS;
			if (typeof(iSchedulerEditor.tmpevent.ICAL_DATA) != "undefined" && typeof(iSchedulerEditor.tmpevent.ICAL_DATA.rrule) != "undefined"){
				iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['ICAL_DATA']['rrule']	= iSchedulerEditor.tmpevent.ICAL_DATA.rrule;
			}

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['NAME'] = iSchedulerEditor.tmpevent.NAME;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['UDID'] = iSchedulerEditor.tmpevent.UDID;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['DESCRIPTION'] = iSchedulerEditor.tmpevent.DESCRIPTION;

			delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][j]['timecard']['attributes']['UDID'];
			//EOF create new TC
		}

		// close old TC
		if(typeof(iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']) != "undefined"){
			delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']['count'];
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']['until'] = untilArr;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']['untilTS'] = untilDateTS;
		}
		// EOF close old TC


		iSchedulerEditor.convertScheduleInfoToEventSource(true);
		iSchedulerEditor.enabledApplyCancel(true);
		$('#mask, .window').hide();

	},

	editTC_full: function(doDelete)
	{
		doDelete = doDelete || false;
		var event = iSchedulerEditor.tmpevent;
		var eventStartDS = iSchedulerEditor.tmpevent.eventstartTS;
		var arrLength = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'].length;
		var i = event.i;



		if(doDelete){
			if (typeof iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['deleted'] == "undefined"){
				iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['deleted'] = [];
			}
			var postureid = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['postureid'];
			var timecardid = iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecardid'];

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['deleted'].push({"timecardid":timecardid, "postureid":postureid});
			delete iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i];

			$('#calendar').fullCalendar( 'removeEvents' , timecardid);
			iSchedulerEditor.editWindowInfo = {};
			iSchedulerEditor.enabledApplyCancel(true);
			$('#mask, .window').hide();
		}else{
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['startTS'] = iSchedulerEditor.tmpevent.eventstartTS;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['endTS'] = iSchedulerEditor.tmpevent.eventendTS;
			if (typeof(iSchedulerEditor.tmpevent.ICAL_DATA) != "undefined" && typeof(iSchedulerEditor.tmpevent.ICAL_DATA.rrule) != "undefined"){
				iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['ICAL_DATA']['rrule']	= iSchedulerEditor.tmpevent.ICAL_DATA.rrule;
			}

			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['NAME'] = iSchedulerEditor.tmpevent.NAME;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['UDID'] = iSchedulerEditor.tmpevent.UDID;
			iSchedulerEditor.scheduleInfo[iSchedulerEditor.currschedule]['calendar'][i]['timecard']['attributes']['DESCRIPTION'] = iSchedulerEditor.tmpevent.DESCRIPTION;

			iSchedulerEditor.convertScheduleInfoToEventSource(true);
			iSchedulerEditor.enabledApplyCancel(true);
			$('#mask, .window').hide();
		}
	},

	createObjectAttributes: function(obj_id, objects, elementIdForAtach, isMassObjectEditor)
	{
		isMassObjectEditor = true;
		var tab_content = [];
		var objectNames = [];
		if (!($("#" + elementIdForAtach).length > 0))
			return;

		var headerForTable = [];
		headerForTable.push('<table id="selectButtons"><tr><td><input type="button" id="canselChanges" value="' + __("Cansel") +'"/><input type="button" id="saveAllChanges" value="' + __("Save") +'"/></td><td>&nbsp;</td>');
		for (var object in objects)
		{
			var name = objects[object].attributes["NAME"]["VALUE"];
			headerForTable.push('<td>&nbsp;</td>');
			objectNames.push('<div><label><input type="checkbox" data-obj="' + object + '" data-event="checkCamera" value="' + __("Check") +'"/>' + name + '</label></div>');
		}
		headerForTable.push('<td>&nbsp;</td></tr></table>');
		tab_content.push(headerForTable.join(''));

		// clear check list if reload attributes
		var textfield_and_regexp_list_for_check = {};
		var textfield_and_js_list_for_check = {};

		// find last object, and nu,ber of objects in objects
		var firstObject = null;
		var lastObject = null;
		var numberOfObjects = 0;
		for (var object in objects)
		{
			if (!firstObject) firstObject = object;
			lastObject = object;
			numberOfObjects++;
		}

		// create tabs
		function convertObjectsFormat(objects)
		{
			var result = {
				category: {},
				object: {}
			};

			for (var object in objects)
			{
				var tabs = objects[object].categories;

				result.object[object] = {};

				for (var tab in tabs)
				{
					var tabName = tabs[tab].category;
					var tabAttributes = tabs[tab].attributes;

					if (!result.category[tabName]) result.category[tabName] = [];
					if (!result.object[object][tabName]) result.object[object][tabName] = {};

					for (var attr in tabAttributes)
					{
						var attrName = tabAttributes[attr];
						if (!result.category[tabName][attrName]) result.category[tabName][attrName] = [];
						result.category[tabName][attrName][object] = object;

						result.object[object][tabName][attrName] = true;
					}
				}
			}
			return result;
		}

		var convertedObjects = convertObjectsFormat(objects);
		var tabs = convertedObjects.category;
		var tabsObjects = convertedObjects.object;

		for (var tab in tabs)
		{
			var tab_content_visible_attributes = [];

			tab_content_visible_attributes.push('<div class="tab_caption"><div>' + __(tab, 'template') + '</div>' + '</div>');
			// create content for tab
			tab_content_visible_attributes.push('<table style="width:100%;">');
			var tab_content_hidden_attributes = [];

			for (var attr in tabs[tab])
			{
				// find attr with label
				var first_label = "";
				var has_visible_attr = false;
				for (var object in objects)
				{
					if (!tabsObjects[object][tab] || !tabsObjects[object][tab][attr])
						continue;

					var tab_objects_attr = objects[object].attributes[attr];
					if (!tab_objects_attr)
						continue;

					var type = tab_objects_attr["TYPE"];
					var label = tab_objects_attr["LABEL"];

					has_visible_attr = true;
					if (label !== "")
					{
						first_label = label;
						break;
					}
				}

				for (var object in objects)
				{
					var attr_id = attr + "_" + object;
					var tab_objects_attr = objects[object].attributes[attr];

					if (has_visible_attr && object == firstObject)
					{
						tab_content_visible_attributes.push('<tr id="' + attr + '_row"><td class="tdcaption" style="width:200px;" align="right">' + __(first_label, 'template') + '</td>');
					}

					if (tabsObjects[object][tab] && tabsObjects[object][tab][attr] && tab_objects_attr)
					{
						var type = tab_objects_attr["TYPE"];
						var value = tab_objects_attr["VALUE"];
						var label = tab_objects_attr["LABEL"];
						var list = tab_objects_attr["LIST"];
						var url = tab_objects_attr["URL"];
						var validate = tab_objects_attr["VALIDATE"];
						var error = tab_objects_attr["ERROR"];
						var js = tab_objects_attr["JS"];

						if (type === "")
							continue;


						tab_content_visible_attributes.push('<td align="left" id="' + attr_id + '_cell">');

						var found = null;
						var maxlength = "";

						// create controls
						if (type === "dropmenu")
						{
							tab_content_visible_attributes.push('<select style="width:200px;" id="' + attr_id + '" data-type="' + type + '" data-obj="' + object + '" data-attr="' + attr + '">');
							var options = list;
							var isSelected = false;
							tab_content_visible_attributes.push('<option value=""></option>');
							for (var j = 0; j < options.length; j++)
							{
								optionValue = options[j]['value'] || '';
								var optionValue = optionValue.replace(/"/g, '&quot;');
								var selectedAttribute = "";
								if (options[j]['value'] == value)
								{
									isSelected = true;
									selectedAttribute = 'selected="true"';
								}

								tab_content_visible_attributes.push('<option value="' + optionValue + '" ' + selectedAttribute + '>' + __(options[j]['label'], 'template') + '</option>');
							}

							// if list not contain necessary value, then create empty option
							if (!isSelected)
							{
								tab_content_visible_attributes.push('<option value="' + value.replace(/"/g, '&quot;') + '" selected="true"></option>');
							}
							tab_content_visible_attributes.push('</select>');
						}

					} else
					if (has_visible_attr)
					{
						tab_content_visible_attributes.push('<td>&nbsp;</td>');
					}

					if (has_visible_attr && object == lastObject)
					{
						tab_content_visible_attributes.push("</tr>");
					}
				}
			}
			tab_content_visible_attributes.push("</table>");
			tab_content.push('<div class="tab_content" id="tab_content_' + tab + '" style="display:block;">' + tab_content_hidden_attributes.join('') + tab_content_visible_attributes.join('') + '</div>');
		}

		// append new tabs to DOM
		if (isMassObjectEditor)
		{
			var elementIdForAtach_width = numberOfObjects * (104 + 2) + 156 * 2 + 104 + 4;
			$(".editor_container").width(elementIdForAtach_width + "px");
		}
		$("#" + elementIdForAtach).html(tab_content.join(''));
		$("#" + elementIdForAtach).data("obj", obj_id);
	},

	disableTCTimeData: function()
	{
		$("#t_date_from").prop("disabled", true);
		$("#t_time_from").prop("disabled", true);
		$("#t_date_to").prop("disabled", true);
		$("#t_time_to").prop("disabled", true);

		$("#cb_repeat").prop("disabled", true);
		$("#s-frequency").prop("disabled", true);
		$("#s-interval").prop("disabled", true);
		$("#repeaton_MO").prop("disabled", true);
		$("#repeaton_TU").prop("disabled", true);
		$("#repeaton_WE").prop("disabled", true);
		$("#repeaton_TH").prop("disabled", true);
		$("#repeaton_FR").prop("disabled", true);
		$("#repeaton_SA").prop("disabled", true);
		$("#repeaton_SU").prop("disabled", true);

		$("#endson_never").prop("disabled", true);
		$("#endson_count").prop("disabled", true);
		$("#endson_count_input").prop("disabled", true);

		$("#endson_until").prop("disabled", true);
		$("#endson_until_input").prop("disabled", true);

		$("#b_delete_tc").prop("disabled", true);
	},

	enableTCTimeData: function()
	{
		$("#t_date_from").prop("disabled", false);
		$("#t_time_from").prop("disabled", false);
		$("#t_date_to").prop("disabled", false);
		$("#t_time_to").prop("disabled", false);

		$("#cb_repeat").prop("disabled", false);

		$("#s-frequency").prop("disabled", false);
		$("#s-interval").prop("disabled", false);
		$("#repeaton_MO").prop("disabled", false);
		$("#repeaton_TU").prop("disabled", false);
		$("#repeaton_WE").prop("disabled", false);
		$("#repeaton_TH").prop("disabled", false);
		$("#repeaton_FR").prop("disabled", false);
		$("#repeaton_SA").prop("disabled", false);
		$("#repeaton_SU").prop("disabled", false);

		$("#endson_never").prop("disabled", false);
		$("#endson_count").prop("disabled", false);
		$("#endson_count_input").prop("disabled", false);

		$("#endson_until").prop("disabled", false);
		$("#endson_until_input").prop("disabled", false);

		$("#b_delete_tc").prop("disabled", false);
	},

	destroyEditor: function()
	{
		if (iSchedulerEditor.editor)
		{
			iSchedulerEditor.editor.destroy();
			iSchedulerEditor.editor = null;
			$("#editor_sch").hide();
		}
	}
};

// for translate
var a = __("Admin Role");
var a = __("Manager Role");
var a = __("Operator Role");
var a = __("Viewer Role");

return iSchedulerEditor;
});
