define("nodeinfo", ["jquery", "editor", "log", "i18n"], function(){
	"use strict";

	/**
	 * @type {Editor}
	 */
	var Editor = require("editor");

	return {
		createNodeEditor: function (obj)
		{
			$(document).ready(function ()
			{
				var params = {
					obj: obj,
					isMassObjectEditor: false,
					id: "#editor",
					type: "node"
				};

				var editor = new Editor(params);

				editor.onLoad = function ()
				{
				};
				editor.onSave = function (obj)
				{
				};
				editor.onDelete = function ()
				{
					Log.warning(__("Warning! After node is removed, you can attach it back by restoring recent configuration backup."));
				};
				editor.onCancel = function ()
				{
				};

				editor.init();
			});
		}
	}
});
