/**
 * @version $Id: admin_script.js 30204 2014-02-18 13:12:51Z atsybulnik $
 * ------------------------------------------------------------------------------
 * Admin GUI
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @author Sergey Tsybulsky
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

define("iadmin", ["cred", "scheduler", "api", "session_manager", "i18n", "amq.api", "editor", "jquery", "jquery.treeview", "jquery.ba-hashchange"], function(){
	"use strict";

	var Editor = require("editor");
	var iCredentialsEditor = require("cred");
	var iSchedulerEditor = require("scheduler");

	var iAdmin = {
		objectList: {},
		objectNameList: {},
		objectTypes: {},
		currentSetid: 0,
		currentNodeid: null,
		currentListView: "tile", //type of viewing objects  "tile" or "list"
		doFillList: true,
		editor: null,
		backhref: "",
		hashArr: [],
		lasthash: "",

		licenseKeys: {},

		/**
		 * interface initialization
		 */
		init: function()
		{
			AMQ
				// check for session close
				.fail(function(status){
					if (status == 401)
					{
						window.location.href = '/sdi/login/logout.php?token=' + getToken();
					}
				})
				// subscribe for session close
				.subscribe("topic://sessionClose_" + readCookie("PHPSESSID"), function(messageList){
					messageList.forEach(function(message){
						var response = JSON.parse(message);
						window.location.href = '/sdi/login/logout.php?reason=' + response.reason + '&token=' + getToken();
					});
				});

			// if nothing is select from navigation then try to select camera list from node
			// create tree
			$("#navigation").treeview({
				animated: "fast",
				collapsed: true,
				unique: true,
				persist: "location",
				//cookieId: "treeview-black",
				toggle: function() {
					//window.console && console.log("%o was toggled", this);
				}
			});

			iAdmin.addEvents(function(){
				if (window.location.hash == "")
				{
					$("#navigation a[class=folder]:first").parent().children("div.hitarea").trigger("click");
					window.location.href = $("#navigation a[class=file2]:first").attr("href");
				} else {
					iAdmin.onChangeHash();
				}
			});

			if (window.SYSTEM_CLASSIFICATION == "CLASSIFIED" || window.SYSTEM_CLASSIFICATION == "SENSITIVE")
			{
				$(".system_classification").show();
				$("#footer").css("margin-top", "-61px;");
			} else{
				$("#footer").css("margin-top", "-41px;");
				$(".system_classification").hide();
			}

			// remove loading indicator
			$(".loader").remove();
		},

		/**
		 * event handler for hash change event
		 *
		 * @param isMenuClick
		 */
		onChangeHash: function(isMenuClick)
		{
			isMenuClick = isMenuClick || false;

			// check for session
			var SESSION_ID = readCookie("PHPSESSID") || false;
			if (!SESSION_ID)
			{
				// remove
				window.console.log("remove");
				window.location.href = '/sdi/login/logout.php?token=' + getToken();
			}

			var hash = window.location.hash;
			// can be:
			// #set_99/camera_105/relay_120
			// #set_99/camera_105
			// #set_99
			// #set_99/add_camera
			// #add_camera
			// #fignya_kakayato
			// or empty

			if (hash == "#logout")
			{
				return;
			}

			if (hash != "")
			{
				// delete # from hash
				var tmphash = hash.substring(1, hash.length);
				// get array of of objects (actions) from path
				iAdmin.hashArr = tmphash.split('/');
				iAdmin.lasthash = tmphash;
				if (iAdmin.hashArr.length > 0)
					iAdmin.lasthash = iAdmin.hashArr[iAdmin.hashArr.length-1];
			}

			var match = null;
			var type = null;
			if (hash == "")
			{
				window.location.href = $("#navigation a[class=file2]:first").attr("href");
			} else
			if (match = iAdmin.lasthash.match(/^(camera|external|relay|sensor_skm|monitor|wall|gateway|sensor_acsg|door|perimeter|area|audio|posture|avatar)_(\d+)/i))
			{
				$("#scheduler").hide();
				$("#credentials").hide();
				$("#session_manager").hide();

				var obj = match[2];
				type = match[1];
				var showdelete = {};
				if (match = iAdmin.lasthash.match(/^(sensor_acsg|door|perimeter|area|audio)_(\d+)/i))
				{
					showdelete = {
						remove: {
							show: false
						}
					};
				}

				var objname = iAdmin.objectNameList[obj] || '';
				if (!objname){
					objname = iAdmin.getObjFullName(obj, type);
				}

				var params = {
					obj: obj,
					setid: null,
					nodeid: null,
					type: type,
					id: "#content",
					buttons: showdelete,
					name: objname,
					backname: $('#setName').text(),
					backpath: iAdmin.hashArr
				};

				if (iAdmin.currentNodeid)
				{
					params.nodeid = iAdmin.currentNodeid;
				} else {
					params.setid = iAdmin.currentSetid;
				}

				iAdmin.createEditor(params);
			} else
			if (match = iAdmin.lasthash.match(/^add_(camera|relay|sensor_skm)/i))
			{
				$("#scheduler").hide();
				$("#credentials").hide();
				$("#session_manager").hide();

				var templateName = match[1]; //"camera"; //$(this).attr("template");
				var prelasthash = iAdmin.hashArr[iAdmin.hashArr.length - 2] || '';
				var backhref = '';
				var setid_html = '';
				var nodeid_html = '';
				if (prelasthash != '' && (match = prelasthash.match(/^set_(\d+)/i)))
				{
					var setid = match[1];
					iAdmin.currentSetid = setid;
					iAdmin.currentNodeid = null;
				}

				if (iAdmin.currentSetid && iAdmin.currentSetid > 0)
				{
					setid_html = "&setid=" + iAdmin.currentSetid;
					backhref = "&backhref=set_" + iAdmin.currentSetid;
				}

				if (iAdmin.currentNodeid)
				{
					nodeid_html = "&nodeid=" + iAdmin.currentNodeid;
				}

				// open addcamera editor
				var dataurl_html = '/sdi/admincirrus/index.php?mode=addObject' + nodeid_html + setid_html + '&template=' + templateName + backhref;

				if (templateName == "relay" || templateName == "sensor_skm" || templateName == "external")
				{
					dataurl_html = '/sdi/sensoreditor/index.php?template=' + templateName + backhref + nodeid_html + setid_html;
				}

				if (
					dataurl_html != ""
					&&
					(
						templateName == "camera"
						|| templateName == "relay"
						|| templateName == "sensor_skm"
						|| templateName == "external"
					)
				)
				{
					iAdmin.setFrameContent(dataurl_html);
				}

				iAdmin.setContentHeight();
			} else
			if (match = iAdmin.lasthash.match(/^add_(monitor|wall|gateway)/i))
			{
				$("#scheduler").hide();
				$("#credentials").hide();
				$("#session_manager").hide();

				type = match[1]; // "camera";
				var prelasthash = iAdmin.hashArr[iAdmin.hashArr.length-2] || '';
				if (prelasthash != '' && (match = prelasthash.match(/^set_(\d+)/i))){
					var setid = match[1];
					iAdmin.currentSetid = setid;
					iAdmin.currentNodeid = null;
				}
				var attributes = {};
				iAdmin.createEditor({
					buttons: {
						remove: {
							show: false
						}
					},
					setid: iAdmin.currentSetid,
					type: type,
					id: "#content",
					isGoBack: true,
					attributes: attributes,
					name: __("Add new") + " " + __(type),
					backname: $('#setName').text()
				});
			} else
			if (hash.match(/^#identity/i))
			{
				$("#scheduler").hide();
				$("#credentials").hide();
				$("#session_manager").hide();

				iAdmin.createEditor({
					buttons: {
						remove: {
							show: false
						},
						back: {
							show: false
						}
					},
					obj: 53,
					setid: iAdmin.currentSetid,
					type: "gui",
					id: "#content",
					name: "Identity"
				});
			} else
			if (match = iAdmin.lasthash.match(/^set_(\d+)/i))
			{
				$("#list").css({
					"max-width": "",
					"min-width": "",
					"width": ""
				});

				iAdmin.destroyEditor();
				var setid = match[1];
				iAdmin.currentSetid = setid;
				iAdmin.currentNodeid = null;

				$("#scheduler").hide();
				$("#credentials").hide();
				iAdmin.destroyEditor();
				$("#iframe")
					.hide()
					.attr("src", "");
				$("#list").show();
				$("#session_manager").hide();

				iAdmin.getObjectList({id: "#list .tabs_content", setid: setid}, function(params){
					iAdmin.fillObjectList(params);

					// show quick start if no devices in set
					if(iAdmin.objectList.length == 0){
						$("#list .tabs_content").append(
								'<div style="text-align: center" id="qs_frame">' +
									'<iframe width="99%" scrolling="no" height="100%" align="left" src="/sdi/admin/quickstart.php"></iframe>' +
								'</div>');
					}

					$("#filterByMask").trigger("keyup");
				});
			} else
			if (match = hash.match(/^#(user|role|set)_manager/i))
			{
				iAdmin.destroyEditor();
				$("#list").hide();
				$("#scheduler").hide();
				$("#iframe")
					.hide()
					.attr("src", "");
				$("#credentials").show();
				$("#session_manager").hide();

				var mode = match[1];
				iCredentialsEditor.init(mode, "#credentials");
			} else
			if (match = iAdmin.lasthash.match(/^schedule_manager_(\d+)/i))
			{
				if (typeof(iSchedulerEditor.editor) !== "undefined")
				{
					iSchedulerEditor.destroyEditor();
				}
				iAdmin.destroyEditor();
				$("#list").hide();
				$("#credentials").hide();
				$("#iframe")
						.hide()
						.attr("src", "");
				$("#scheduler").show();
				$("#session_manager").hide();

				var mode = "schedule";
				iSchedulerEditor.init(mode, "#scheduler");
			} else
			if (match = hash.match(/^#(posture|timecard|schedule)_manager/i))
			{
				if (typeof(iSchedulerEditor.editor) !== "undefined"){
					iSchedulerEditor.destroyEditor();
				}
				iAdmin.destroyEditor();
				$("#list").hide();
				$("#credentials").hide();
				$("#iframe")
					.hide()
					.attr("src", "");
				$("#scheduler").show();
				$("#session_manager").hide();

				var mode = match[1];
				iSchedulerEditor.init(mode, "#scheduler");
			} else
			if (match = hash.match(/^#session_manager/i))
			{
				iAdmin.destroyEditor();
				$("#list").hide();
				$("#credentials").hide();
				$("#iframe")
						.hide()
						.attr("src", "");
				$("#scheduler").hide();
				$("#session_manager").show();

				var sessionManager = new SessionManager(true);
				sessionManager.init("#session_manager .tabs_content");
				sessionManager.fillSessionList(function ()
				{
					$("#session_manager .tabs_content .object_list").treeview({
						animated:"fast",
						collapsed:true,
						unique:true
					});
					$("#session_manager .tabs_content .object_list").delegate(".clickable_area", "click", function (e){
						$(this).parent().children("div.hitarea").trigger("click");
					});
				});
			} else
			if (match = hash.match(/^#node_content_(\d+)/i))
			{
				$("#list").css({
					"max-width": "",
					"min-width": "",
					"width": ""
				});

				iAdmin.destroyEditor();
				var nodeid = match[1];
				iAdmin.currentNodeid = nodeid;

				$("#scheduler").hide();
				$("#credentials").hide();
				iAdmin.destroyEditor();
				$("#iframe")
					.hide()
					.attr("src", "");
				$("#list").show();
				$("#session_manager").hide();

				iAdmin.getObjectList({id: "#list .tabs_content", nodeid: nodeid}, function(params){iAdmin.fillObjectList(params);$("#filterByMask").trigger("keyup");});
			} else
			if (match = hash.match(/^#avatar_content_(\d+)/i))
			{
				$("#list").css({
					"max-width": "",
					"min-width": "",
					"width": ""
				});

				iAdmin.destroyEditor();
				var avatarid = match[1];
				iAdmin.currentNodeid = avatarid;

				$("#credentials").hide();
				iAdmin.destroyEditor();
				$("#iframe")
					.hide()
					.attr("src", "");
				$("#list").show();

				iAdmin.getObjectList({id: "#list .tabs_content", parentObj: avatarid}, function(params){iAdmin.fillObjectList(params);$("#filterByMask").trigger("keyup");});
			} else
			if (match = iAdmin.lasthash.match(/^(ptzCalibrator)_(\d+)/i))
			{
				iAdmin.destroyEditor();
				iAdmin.setFrameContent('/ptz/ptzCalibrator.php?obj=' + match[2]);
				iAdmin.setContentHeight();
			} else {
				var selobjs = $("#navigation a").filter(function() { return (this.href.toLowerCase() == window.location.href.toLowerCase()) && (!$(this).hasClass('folder')); });
				if (selobjs.length > 0 && !isMenuClick)
				{
					selobjs.trigger("click");
				}
			}

			iAdmin.setContentHeight();
		},
		/**
		 * add events to interface controls
		 */
		addEvents: function(callback)
		{
			iAdmin.currentSetid = 0;

			$(document).ajaxSuccess(function(evt, request, settings){
				try{
					// logout if user not logged in
					if (request.status == 401)
					{
						window.location.href = '/sdi/login/logout.php?token=' + getToken();
					}
				}
				catch(e) {}
			});

			iAdmin.getObjectTypes(function(){
				$(window).hashchange( function(){
					iAdmin.onChangeHash();
				});

				// create event handler for tree items
				$("#navigation").delegate("a", "click", function(){
					$("#filterByMask").val("");
					$(this).parent().children("div.hitarea").trigger("click");

					var url = $(this).data("url") || "";
					var hash = $(this).attr("href") || "";

					if (url !== "")
					{
						iAdmin.destroyEditor();
						var isFullScreen = false;
						if (hash == '#matrix'
							|| hash == '#logout'
							|| hash == '#map3d')
						{
							isFullScreen = true;
						}
						iAdmin.setFrameContent(url, false, isFullScreen);
					} else
					if (hash !== "")
					{
						var oldhash = window.location.hash;
						window.location.hash = hash;
						if (oldhash == hash)
						{
							iAdmin.onChangeHash(true);
						}
					}

					iAdmin.setContentHeight();
				});

				$("#list .tabs_content").delegate(".item, .item item_off", "click", function(){
					iAdmin.backhref = window.location.hash;
					window.location.hash = $(this).attr("next-url");

					iAdmin.setContentHeight();
				});

				$("#list .tabs_content").delegate(".list_element_small", "click", function(){
					iAdmin.backhref = window.location.hash;
					window.location.hash = $(this).attr("next-url");

					iAdmin.setContentHeight();
				});

				$("#filterByType").change(function(){
					var filterTypeVal = $("#filterByType").val();
					var maskVal = $("#filterByMask").val();

					iAdmin.doFillList = false;

					iAdmin.refillObjectList({id: "#list .tabs_content", setid: iAdmin.currentSetid, filtertype: filterTypeVal, filtermask: maskVal});
				});

				$("#filterByMask").keyup(function(){
					var filterTypeVal = $("#filterByType").val();
					var maskVal = $("#filterByMask").val();

					iAdmin.doFillList = false;

					iAdmin.refillObjectList({id: "#list .tabs_content", setid: iAdmin.currentSetid, filtertype: filterTypeVal, filtermask: maskVal});
				});

				// set content to screen height
				$(window).resize(function(){
					iAdmin.setContentHeight();
				});

				// show objects like tiles
				$("#viewAsTiles").click(function(){
					iAdmin.currentListView = "tile";
					$(".viewAsTilesEditorClose").hide();
					$(".viewAsListEditorClose").hide();

					$("#list").css({
						"max-width": "",
						"min-width": "",
						"width": ""
					});

					var filterTypeVal = $("#filterByType").val();
					var maskVal = $("#filterByMask").val();

					var params = {
						id: "#list .tabs_content",
						setid: iAdmin.currentSetid,
						filtertype: filterTypeVal,
						filtermask: maskVal
					};

					if (maskVal == "")
						iAdmin.fillObjectList(params);
					else
						iAdmin.refillObjectList(params);
				});

				// show objects as list
				$("#viewAsList").click(function(){
					iAdmin.currentListView = "list";
					$(".viewAsTilesEditorClose").hide();
					$(".viewAsListEditorClose").hide();

					$("#list").css({
						"max-width": "",
						"min-width": "",
						"width": ""
					});

					var filterTypeVal = $("#filterByType").val();
					var maskVal = $("#filterByMask").val();

					var params = {
						id: "#list .tabs_content",
						setid: iAdmin.currentSetid,
						filtertype: filterTypeVal,
						filtermask: maskVal
					};

					if (maskVal == "")
						iAdmin.fillObjectList(params);
					else
						iAdmin.refillObjectList(params);
				});

				// show objects in editor, create Spreadsheet editor
				$("#list").delegate(".viewAsEditor", "click", function(){
					// i18n: Loading progress.
					var warningMessage = __("Depending on the number of devices present, this view may take some time to load. Please be patient.") + "\n" + __("Are you sure you want to continue?");
					if (confirm(warningMessage))
					{
						if (!$(this).parent().parent().hasClass("collapsable"))
						{
							$(this).parent().parent().children("div.hitarea").trigger("click");
						}

						$(".viewAsEditor").show();
						$(this).hide();
						if (iAdmin.currentListView == "tile")
						{
							$(".viewAsTilesEditorClose").hide();
							$(this).parent().children(".viewAsTilesEditorClose").show();
						} else {
							$(".viewAsListEditorClose").hide();
							$(this).parent().children(".viewAsListEditorClose").show();
						}

						var tmpcurrentListView = iAdmin.currentListView;
						iAdmin.currentListView = "editor";

						// prepare place for spreadsheet editor
						$("#spreadSheetEditor").remove();
						var element = $(this).parent().parent();
						element.find("ul").hide();
						element.append('<div id="spreadSheetEditor"></div>');

						// get node

						var type = element.data("type");

						var params = {
							isMassObjectEditor: true,
							id: "#spreadSheetEditor",
							type: type
						};

						if (iAdmin.currentNodeid)
						{
							params.nodeid = iAdmin.currentNodeid;
						} else {
							params.setid = iAdmin.currentSetid;
						}

						var editor = new Editor(params);

						editor.onLoad = function()
						{
							var mainContainerWidth = $(".editor_container:first").width() + 2;
							if (mainContainerWidth<650) mainContainerWidth = 650;
							$("#list").css({
								"max-width": mainContainerWidth + "px",
								"min-width": mainContainerWidth + "px"
							});
						};
						editor.onSave = function(obj)
						{
						};
						editor.onDelete = function()
						{
						};
						editor.onCancel = function()
						{
						};

						editor.init();
						iAdmin.currentListView = tmpcurrentListView;
					} else {
						/*$("#spreadSheetEditor").remove();*/
					}
				});
				$("#list").delegate(".viewAsTilesEditorClose, .viewAsListEditorClose", "click", function(){
					$("#spreadSheetEditor").remove();
					$("#list").css({
						"max-width": "",
						"min-width": ""
					});
					$(".viewAsEditor").show();
					$(".viewAsTilesEditorClose").hide();
					$(".viewAsListEditorClose").hide();
				});

				// create new object
				$("#list").delegate(".addObject", "click", function(){
					var hash = window.location.hash;
					var setid = iAdmin.currentSetid || null;

					var href = $(this).data("href");
					if (href)
					{
						iAdmin.backhref = hash;

						window.location.hash = href;
						if ($(this).data("url") !== '')
						{
							iAdmin.setFrameContent($(this).data("url"));
						}

						iAdmin.setContentHeight();
					} else {
						var match = null;
						if (match = hash.match(/^#set_(\d+)/i))
						{
							setid = match[1];
							iAdmin.currentSetid = setid;
							iAdmin.currentNodeid = null;
						}

						$("#scheduler").hide();
						$("#credentials").hide();
						$("#iframe")
							.hide()
							.attr("src", "");
						$("#list").show();

						iAdmin.fillAddObjectTypeList({id: "#list .tabs_content", setid: setid});
					}
				});

				callback();
			});
		},

		/**
		* set height of the content with frame
		*/
		setContentHeight: function()
		{
			if ($("#list:visible").length > 0 || $("#tabs:visible").length > 0 || $('#scheduler').is(":visible"))
			{
				$("#content").height("");
				return;
			}

			var height = $(window).height() - $("#header").outerHeight() - $("#footer").outerHeight() - $("#classified_header").outerHeight();
			var sidebarHeight = $("#sideLeft").outerHeight(true);
			if (sidebarHeight > height)
			{
				height = sidebarHeight;
			}
			$("#content").height(height);
		},

		/**
		 * set url for the frame
		 * @param {String} url
		 * @param {Boolean} [isHideMenu]
		 * @param {Boolean} [isFullScreen]
		 */
		setFrameContent: function(url, isHideMenu, isFullScreen)
		{
			url = url || "";
			isHideMenu = isHideMenu || false;
			isFullScreen = isFullScreen || false;

			// only urls related to current site are possible
			if (url[0] != '/')
			{
				return;
			}

			$("#session_manager").hide();
			$("#scheduler").hide();
			$("#credentials").hide();
			$("#list").hide();

			if (isFullScreen)
			{
				window.location.assign(url);
			} else {
				if (isHideMenu)
				{
					iAdmin.hideMenu();
				}

				$("#iframe")
					.show()
					.attr("src", url);
			}
		},

		hideMenu: function()
		{
			$("#content").css("padding", "0 0 0 0px");
			$("#sideLeft").hide();
		},

		showMenu: function()
		{
			$("#content").css("padding", "0 0 0 270px");
			$("#sideLeft").show();
		},

		/**
		 * get list of object types and store it in iAdmin.objectTypes
		 *
		 * @param {Function} [callback]
		 */
		getObjectTypes: function(callback)
		{
			var api = new API();
			api.getTypes()
				.done(function(response){
					iAdmin.objectTypes = response["types"];

					if ($.isFunction(callback))
					{
						callback();
					}
				});
		},

		getObjFullName: function(obj, type, setid)
		{
			type = type || null;
			setid = setid || null;

			var data = {};
			if (type)
			{
				data.type = type;
			}
			if (setid)
			{
				data.setid = setid;
			}

			var result = '';

			var api = new API(false);
			api.getObjectList(data)
				.fail(function(code, message){
					Log.error(message);
				})
				.done(function(response){
					var objectList = response.list;
					if (objectList.length > 0)
					{
						for (var i = 0; i < objectList.length; i++)
						{
							if (objectList[i]["obj"] == obj){
								var otype = objectList[i]["otype"];
								var subtype = objectList[i]["subtype"];
								var objectType = iAdmin.objectTypes[otype][subtype]["name"];
								var location = objectList[i]["location"] || "";

								var udid='';
								if (typeof(objectList[i]["udid"]) != 'undefined' && objectList[i]["udid"]!=''){
									udid = '['+objectList[i]["udid"]+']';
								}else{
									udid = '#'+objectList[i]["obj"]
								}
								result = objectType + " " + udid + ": "  + objectList[i]["name"];
								if (location) result += " / " + location;

								break;
							}
						}
					}
				});

			return result;
		},

		getAttribute:function (obj, attribute)
		{
			var data = {'function':'getAttribute'};
			obj = obj || null;
			attribute = attribute || null;
			if (obj && attribute)
			{
				data.obj = obj;
				data.attribute = attribute;
			} else
			{
				return '';
			}

			var result = '';

			$.ajax({
				url:"/api/call.php",
				data:data,
				dataType:"json",
				cache:false,
				async:false,
				success:function (json)
				{
					if (json.error !== "")
					{
						Log.error(json.error);
					} else {
						result = json.value;
					}
				}
			});

			return result;
		},

		getObjectList: function(params, callback)
		{
			var id = params.id || null;
			var setid = params.setid || null;
			var nodeid = params.nodeid || null;
			var parentObj = params.parentObj || null;
			var data = {};

			if (setid)
			{
				data.setid = setid;
			}
			if (nodeid)
			{
				data.nodeid = nodeid;
			}
			if (parentObj)
			{
				data.parentObj = parentObj;
			}
			if (!id)
				return;

			var api = new API();
			$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
			api.getObjectList(data)
				.fail(function(code, message){
					$(id).html('');
					Log.error(message);
				})
				.done(function(response){
					iAdmin.objectList = response.list;
					// get children
					if (iAdmin.objectList.length > 0)
					{
						iAdmin.objectNameList = [];
						for (var i = 0; i < iAdmin.objectList.length; i++)
						{
							var obj = iAdmin.objectList[i]["obj"];
							var otype = iAdmin.objectList[i]["otype"];
							var subtype = iAdmin.objectList[i]["subtype"];
							var objectType = iAdmin.objectTypes[otype][subtype]["name"];

							var udid='';
							if (typeof(iAdmin.objectList[i]["udid"]) != 'undefined' && iAdmin.objectList[i]["udid"]!=''){
								udid = '['+iAdmin.objectList[i]["udid"]+']';
							}else{
								udid = '#'+iAdmin.objectList[i]["obj"]
							}
							iAdmin.objectNameList[obj] = objectType + " " + udid + " "  + iAdmin.objectList[i]["name"];

							var location = iAdmin.objectList[i]["location"] || "";
							if (location) iAdmin.objectNameList[obj] += " / " + location;

							iAdmin.objectList[i]["children"] = [];

							if ((otype = 'D' && subtype == 'E') || (otype = 'X' && subtype == 'G')){
								iAdmin.objectList[i]["children"] = iAdmin.getSubObjectList({id: "#list .tabs_content", parentObj: obj});
							}
						}
					}

					callback(params);
				});
		},

		getSubObjectList: function(params)
		{
			var id = params.id || null;
			var setid = params.setid || null;
			var parentObj = params.parentObj || null;
			var data = {'function': 'getObjectList'};

			if (setid){
				data.setid = setid;
			}
			if (parentObj){
				data.parentObj = parentObj;
			}else{
				return;
			}
			if (!id)
				return;

			var result = {};

			$.ajax({
				url: "/api/call.php",
				data: data,
				dataType: "json",
				cache: false,
				async: false,
				beforeSend: function(XMLHttpRequest)
				{
					$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown)
				{
					$(id).html('');
				},
				success: function(json)
				{
					if (json.error !== "")
					{
						Log.error(json.error);
					} else {
						result = json.list;
					}
				}
			});
			return result;
		},

		fillHtmlObjArr: function(params)
		{
			var id = params.id || null;
			var listType = iAdmin.currentListView || "list";
			var setid = params.setid || null;
			var maskVal = params.filtermask || null;

			if (maskVal) {
				maskVal = maskVal.toLowerCase();
				var a = '\\';
				maskVal = maskVal.replace('(', a+'(');
				maskVal = maskVal.replace(')', a+')');
				maskVal = maskVal.replace('[', a+'[');
				maskVal = maskVal.replace(']', a+']');
				maskVal = maskVal.replace('*', a+'*');
				maskVal = maskVal.replace('+', a+'+');
				maskVal = maskVal.replace('?', a+'?');
			}

			var filterTypeVal = params.filtertype || null;
			var parentObj = params.parentObj || null;
			var children = params.children || null;
			var parentnexturl = params.parentnexturl || null;

			var list = [];
			if (parentObj && children)
			{
				list = children || [];
			} else {
				list = iAdmin.objectList;
			}

			var list_html = {};
			list_html['camera'] = [];
			list_html['camera']['name'] = 'Camera';
			list_html['camera']['html'] = '';

			if (list.length > 0)
			{
				for (var i = 0; i < list.length; i++)
				{
					var obj = list[i]["obj"];
					var udid=list[i]["udid"];
					var udid1='';
					if (udid == ''){
						udid1 = obj;
						udid = '#'+obj;
					}else{
						udid1=udid;
						udid = '['+udid+']';
					}

					var name = list[i]["name"];
					var description = list[i]["description"] || '';

					if (maskVal)
					{
						var lname = udid1.toLowerCase() + name.toLowerCase();
						var lname1 = udid.toLowerCase()+ ' ' + name.toLowerCase();
						if (lname && !(lname.match(maskVal) || lname1.match(maskVal)))
						{
							continue;
						}
					}

					var state = "on";
					var otype = list[i]["otype"];
					var subtype = list[i]["subtype"];
					var objectType = iAdmin.objectTypes[otype][subtype]["name"];
					var objectTypeTemplate = iAdmin.objectTypes[otype][subtype]["template"];

					switch (objectTypeTemplate)
					{
						case 'gui':
						case 'node':
						case 'configuration':
						case 'set':
						case 'role':
						case 'user':
							continue;
					}

					var setid_html = iAdmin.currentSetid ? "&setid=" + setid : "";
					var backhref = '&backhref=set_' + iAdmin.currentSetid;

					var sublist = null;

					var item = [];
					var label = udid + ' ' + name;

					var nexturl = iAdmin.hashArr.join('/') + '/' + objectTypeTemplate + '_' +obj;
					if (parentnexturl) nexturl = parentnexturl + '/' + objectTypeTemplate + '_' +obj;
					if (listType === "tile")
					{
						var classStyle = (state == 'on') ? '' : ' item_off';
						var templateImagePath = {
							'default': '/storage/snapshot?objid=' + obj + '&downscale&status&_=' + (Date.now() / 10000 | 0),
							camera: '/storage/snapshot?objid=' + obj + '&downscale&status&_=' + (Date.now() / 10000 | 0),
							area: '/sdi/admin/img/area.png',
							audio: '/sdi/admin/img/audio.png',
							door: '/sdi/admin/img/door.png',
							external: '/sdi/admin/img/device.png',
							gateway: '/sdi/admin/img/device.png',
							monitor: '/sdi/admin/img/monitor.png',
							perimeter: '/sdi/admin/img/perimeter.png',
							relay: '/sdi/admin/img/relay.png',
							sensor_skm: '/sdi/admin/img/sensor.png',
							sensor_acsg: '/sdi/admin/img/sensor.png',
							wall: '/sdi/admin/img/wall.png',
							avatar: '/sdi/admin/img/avatar.png'
						};

						var imagePath = templateImagePath[objectTypeTemplate] ? templateImagePath[objectTypeTemplate] : "";

						item = [
							'<div class="item' + classStyle + '" template="' + objectTypeTemplate +'" obj="' + obj + '" next-url="' + nexturl + '">',
								'<div class="image"><img width="165" src="' + imagePath + '"/></div>',
								'<div class="label">' + label + '</div>',
								'<div class="description">' + description + '</div>',
							'</div>'
						];
					} else {
						var sublisthtml = '';
						children = list[i]["children"] || [];

						if (children.length > 0){
							sublist = iAdmin.fillHtmlObjArr({id: "#list .tabs_content", setid: iAdmin.currentSetid, filtertype: filterTypeVal, filtermask: maskVal, parentObj: obj, children: children, parentnexturl: nexturl});

							if (sublist){
								sublisthtml = iAdmin.createFullList(sublist, setid_html, backhref, listType, iAdmin.currentSetid?iAdmin.currentSetid:"");
							}
						}

						item = [
							'<li>',
								'<div class="folder list_element_small" template="' + objectTypeTemplate +'" obj="' + obj + '" next-url="' + nexturl + '">',
									'<div class="content">',
										'<div class="text">',
											'<div class="label">' + label + '</div>',
											'<div class="description">' + description + '</div>',
										'</div>',
									'</div>',
								'</div>',
								sublisthtml,
							'</li>'
						];
					}

					if (!list_html[objectTypeTemplate]){
						list_html[objectTypeTemplate] = [];
						list_html[objectTypeTemplate]['name'] = objectType;
						list_html[objectTypeTemplate]['html'] = '';
					}

					list_html[objectTypeTemplate]['html'] = list_html[objectTypeTemplate]['html'] + item.join('');

					if (!iAdmin.doFillList){
						return [];
					}
				}
			}
			if (list_html['camera']['html'] == ''){delete list_html['camera'];}

			if (listType === "tile"){
				for (var name in list_html){
					list_html[name]['html'] = '<li>' + list_html[name]['html'] + '</li>';
				}
			}
			return list_html;
		},

		createFullList: function(list_html, setid_html, backhref, listType, setid)
		{
			var setid_html = setid_html || '';
			var backhref = backhref || '';
			var fullList_html = '';
			var setid = setid || '';
			var hashsetid = '';
			if (setid != '') hashsetid = "set_" + setid + "/";

			var nodeid_html = '';
			if (iAdmin.currentNodeid)
			{
				nodeid_html = "&nodeid=" + iAdmin.currentNodeid;
			}

			for (var templateName in list_html)
			{
				var dataurl = '/sdi/admincirrus/index.php?mode=addObject' + nodeid_html;

				if (templateName == "relay" || templateName == "sensor_skm" || templateName == "external")
				{
					dataurl = '/sdi/sensoreditor/index.php' + nodeid_html;
				} else
				if (templateName == "wall" || templateName == "monitor" || templateName == "gateway")
				{
					dataurl = '';
				}

				var buttonAdd_html = '';
				switch (templateName){
					case 'camera':
					case 'relay':
					case 'sensor_skm':
					case 'monitor':
					case 'wall':
					// 2.7.1 Hide MODBUS functionality
					//case 'external':
					case 'gateway':
						if (
							typeof(iAdmin.licenseKeys[templateName]) == 'undefined'
							||
							typeof(iAdmin.licenseKeys[templateName]) !== 'undefined' && !iAdmin.licenseKeys[templateName]
						)
						{
							buttonAdd_html = '<div class="addObject" title="Add" data-url="' + dataurl + setid_html + '&template=' + templateName + backhref + '" data-href="#' + hashsetid + 'add_'+ templateName +'"></div>';
						}
				}

				var class_html = "";
				if (listType === "tile")
				{
					class_html = 'class="tile_ul"';
				}
				var buttonCloseEdit_html = '';
				if (iAdmin.currentListView == "tile"){
					buttonCloseEdit_html = '<div title="Tile" class="viewAsTilesEditorClose" style="display:none;"></div>'
				}else{
					buttonCloseEdit_html = '<div title="Tile" class="viewAsListEditorClose" style="display:none;"></div>'
				}

				fullList_html +=
					'<li data-type="' + templateName + '" data-caption-name="' + list_html[templateName]["name"] + '">' +
						'<div class="clickable_area">' +
							(window.scFullDevice == true ? buttonAdd_html : '') +
							'<div class="viewAsEditor" title="' + __("Configuration Editor") + '"></div>' + buttonCloseEdit_html +
							'<div class="caption_list_element_small">' + __(list_html[templateName]["name"]) + '</div>' +
						'</div>'+
						'<ul ' + class_html + '>' +
						list_html[templateName]['html'] +
						'</ul>' +
					'</li>';

			}
			fullList_html = '<ul id="list_objects" class="object_list treeview-famfamfam treeview">' + fullList_html + '</ul>';
			return fullList_html;
		},

		fillObjectList: function(params)
		{
			var id = params.id || null;
			var listType = iAdmin.currentListView || "list";
			var setid = params.setid || null;
			var maskVal = params.filtermask || null;
			var filterTypeVal = params.filtertype || null;

			var list = iAdmin.objectList;
			var list_html = [];

			iAdmin.doFillList = true;
			$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');

			var countList = list.length;
			list_html = iAdmin.fillHtmlObjArr(params);
			var cameraList = list_html["camera"] || false;
			if (listType === "tile" && countList > 100 && cameraList && cameraList["html"].length > 0)
				$("#loading_progress").show("fast");

			var setid_html = setid ? "&setid=" + setid : "";
			var backhref = '&backhref=set_' + iAdmin.currentSetid;

			if (!iAdmin.doFillList){
				$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
				return false;
			}

			// create full html list from objects
			var fullList_html = iAdmin.createFullList(list_html, setid_html, backhref, listType, setid ? setid : "");
			if (!iAdmin.doFillList){
				$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
				return false;
			}
			$(id).html(fullList_html);

			var setNameText = "";
			if (iAdmin.currentNodeid)
			{
				setNameText = "Node: " + $("a[href=#node_content_" + iAdmin.currentNodeid + "]").parent().parent().parent().find("a[class=folder]:first").text();
			} else {
				setNameText = $("a[href=#set_" + setid + "]").parent().parent().parent().find("a[class=folder]:first").text() + ': '+ $("a[href=#set_" + setid + "]").text();
			}
			$('#setName').text(setNameText);

			$("#list_objects").treeview({
				animated: "fast",
				collapsed: true,
				unique: true
			});

			$("#list_objects").delegate(".clickable_area", "click", function(e){
				if (iAdmin.currentListView == "list" || iAdmin.currentListView == "tile")
				{
					if (!$(e.target).hasClass("viewAsEditor"))
					{
						$(this).parent().children("div.hitarea").trigger("click");
					}
				}
			});
			$("#list_objects div[class=clickable_area]:first").click();

			$("#loading_progress").hide("fast");
		},

		refillObjectList: function(params)
		{
			var id = params.id || null; //#list .tabs_content
			var listType = iAdmin.currentListView || "list";
			var setid = params.setid || null;
			var maskVal = params.filtermask || null;
			var filterTypeVal = params.filtertype || null;

			var list = iAdmin.objectList;
			var list_html = [];
			iAdmin.doFillList = true;

			var countList = list.length;
			list_html = iAdmin.fillHtmlObjArr(params);
			list_html["camera"] = list_html["camera"] || false;
			if (listType === "tile" && countList > 100 && list_html["camera"] && list_html["camera"]["html"].length>0)
				$("#loading_progress").show("fast");

			if (!iAdmin.doFillList){
				$(id).html('<div class="loading_dark">' + /* i18n: Loading progress. */ __("Loading") + '</div>');
				return false;
			}

			// redraw list from objects
			$("#list_objects ul").html("");
			$("#list_objects li").hide();
			if (listType === "tile"){
				$("#list_objects ul").addClass('tile_ul');
			}else{
				$("#list_objects ul").removeClass('tile_ul');
			}

			for (var name in list_html){
				$("#list_objects [data-caption-name='" + list_html[name]['name'] + "'] ul").html(list_html[name]['html']);
				$("#list_objects [data-caption-name='" + list_html[name]['name'] + "']").show();
			}

			$("#list_objects .expandable ul").hide();
			$("#list_objects .collapsable  ul").show();

			$("#loading_progress").hide("fast");
		},

		fillAddObjectTypeList: function(params)
		{
			var id = params.id || null;
			var setid_html = iAdmin.currentSetid ? "&setid=" + iAdmin.currentSetid : "";
			var hashsetid = iAdmin.currentSetid ? "set_" + iAdmin.currentSetid + "/" : "";

			var fullList_html = '';
			for (var otype in iAdmin.objectTypes){
				for (var subtype in iAdmin.objectTypes[otype]){
					var objectType = iAdmin.objectTypes[otype][subtype]["name"];
					var objectTypeTemplate = iAdmin.objectTypes[otype][subtype]["template"];
					var backhref = window.location.hash;
					if (backhref !== ''){
						backhref = '&backhref=' + backhref.substring(1, backhref.length);
					}

					var href = '#' + hashsetid + 'add_'+ objectTypeTemplate;

					var nodeid_html = '';
					if (iAdmin.currentNodeid)
					{
						nodeid_html = "&nodeid=" + iAdmin.currentNodeid;
					}

					var dataurl_html = '/sdi/admincirrus/index.php?mode=addObject' + nodeid_html + setid_html + '&template=' + objectTypeTemplate + backhref;

					if (objectTypeTemplate == "relay" || objectTypeTemplate == "sensor_skm" || objectTypeTemplate == "external")
					{
						dataurl_html = '/sdi/sensoreditor/index.php?template=' + objectTypeTemplate + backhref + nodeid_html + setid_html;
					} else
					if (objectTypeTemplate == "model3d" || objectTypeTemplate == "modellayer")
					{
						href = dataurl_html = '/sdi/admin/#map3d';
					} else
					if (
						objectTypeTemplate == "monitor" || objectTypeTemplate == "wall" || objectTypeTemplate == "gateway"
						||
						objectTypeTemplate == "sensor_acsg" || objectTypeTemplate == "door" || objectTypeTemplate == "perimeter" || objectTypeTemplate == "area"
					)
					{
						dataurl_html = '';
					}

					switch (objectTypeTemplate){
						// 2.7.1 Hide MODBUS functionality
						//case 'external':
						case 'camera':
						// turn off model3d and modellayer before adding this objects to credentials manager
						// case 'model3d':
						// case 'modellayer':
						case 'relay':
						case 'sensor_skm':
						case 'wall':
						case 'monitor':
						case 'gateway':
							if (
								typeof(iAdmin.licenseKeys[objectTypeTemplate]) == 'undefined'
								||
								typeof(iAdmin.licenseKeys[objectTypeTemplate]) !== 'undefined' && !iAdmin.licenseKeys[objectTypeTemplate]
							)
							{
								fullList_html +=
									'<li data-caption-name="' + objectTypeTemplate + '" data-url="' + dataurl_html + '" href="#' + hashsetid + 'add_'+ objectTypeTemplate +'">'+
										'<div class="clickable_area">' +
											(window.scFullDevice == true ? '<div class="addObject" title="Add" data-url="' + dataurl_html + '" data-href="' + href + '"></div>' : '') +
											'<div class="caption_list_element_small">' + __(objectType) + '</div>'+
										'</div>' +
									'</li>';
							}
					}
				}
			}

			fullList_html = '<ul id="list_objectsAdd" class="object_list treeview-famfamfam treeview">' + fullList_html + '</ul>';
			$(id).html(fullList_html);
		},

		createEditor: function(params)
		{
			params.obj = params.obj || null;
			params.setid = params.setid || null;
			params.nodeid = params.nodeid || null;
			params.id = params.id || null;
			params.type = params.type || null;
			params.attributes = params.attributes || null;
			params.buttons = params.buttons || null;
			var isGoBack = params.isGoBack || false;
			params.name = params.name || null;
			params.backname = params.backname || null;
			params.backhref = iAdmin.backhref || null;
			// backpath mast by array
			params.backpath = params.backpath || null;

			/**
			 * view/edit params
			 */
			if (params.obj && params.id && params.type)
			{
				iAdmin.editor = new Editor({
					obj: params.obj,
					id: params.id,
					type: params.type,
					name: params.name,
					backname: params.backname,
					backhref: params.backhref,
					backpath: params.backpath
				});
				iAdmin.editor.setButtons(params.buttons);
				iAdmin.editor.onLoad = function()
				{
					iAdmin.setContentHeight();
				};
				iAdmin.editor.onSave = function(obj)
				{
					obj = obj || null;
					if (obj && obj > 0 && isGoBack){
						window.location.hash = iAdmin.backhref;
						window.location.reload();
					}
					if (obj && obj == 53)
					{
						var SYSTEM_CLASSIFICATION = iAdmin.getAttribute(53, "SYSTEM_CLASSIFICATION").toUpperCase();
						if (SYSTEM_CLASSIFICATION == "CLASSIFIED" || SYSTEM_CLASSIFICATION == "SENSITIVE")
						{
							$(".system_classification").html("- " + SYSTEM_CLASSIFICATION + " -");
							$("#footer").css("margin-top", "-61px;");
							$(".system_classification").show();
						} else {
							$(".system_classification").hide();
							$("#footer").css("margin-top", "-41px;");
						}
					}
				};
				iAdmin.editor.onBack = function(obj)
				{
					window.location.hash = params.backhref;
				};
				iAdmin.editor.onDelete = function()
				{
					window.location.hash = params.backhref;
					window.location.reload();
				};
				iAdmin.editor.onCancel = function()
				{
				};

				$("#scheduler").hide();
				$("#credentials").hide();
				$("#list").hide();
				$("#iframe")
					.hide()
					.attr("src", "");
				iAdmin.editor.init();
			}else
			/**
			 * create new
			 */
			if (!params.obj && params.setid && params.id && params.type)
			{
				iAdmin.editor = new Editor({
					id: params.id,
					setid: params.setid,
					type: params.type,
					attributes: params.attributes,
					name: params.name,
					backname: params.backname,
					backhref: params.backhref
				});
				iAdmin.editor.setButtons(params.buttons);
				iAdmin.editor.onLoad = function()
				{
					iAdmin.setContentHeight();
				};
				iAdmin.editor.onSave = function(obj){
					obj = obj || null;
					if (obj && obj > 0 && isGoBack){
						window.location.hash = iAdmin.backhref;
						window.location.reload();
					}else{
						alert(params.type + " can not be created");
					}
				};
				iAdmin.editor.onDelete = function(){
					window.location.hash = iAdmin.backhref;
					window.location.reload();
				};
				iAdmin.editor.onBack = function(obj)
				{
					window.location.hash = iAdmin.backhref;
				};
				iAdmin.editor.onCancel = function(){

				};

				$("#scheduler").hide();
				$("#credentials").hide();
				$("#list").hide();
				$("#iframe")
					.hide()
					.attr("src", "");
				iAdmin.editor.init();
			}
		},

		destroyEditor: function()
		{
			if (iAdmin.editor)
			{
				iAdmin.editor.destroy();
				iAdmin.editor = null;
			}
		},

		setLicenseKeys: function(keys)
		{
			iAdmin.licenseKeys = keys;
		}
	};

	$(document).ready(iAdmin.init);

	return iAdmin;
});
