/**
 * @version $Id: cred.js 33151 2015-10-09 22:22:34Z sabaev $
 * ------------------------------------------------------------------------------
 * Logic for credentiall manegment
 * Initialising
 * iCredentialsEditor.init(type, selector)
 * type = (user|role|user)
 * dynamicaly load cred.php and atach it to selector
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
define("cred", ["jquery", "log", "api", "i18n", "editor", "password_editor"], function(){
	"use strict";

	var Editor = require("editor");
	var PasswordEditor = require("password_editor");

var iCredentialsEditor = {
	isDebug: false,
	list: {
		was: {
			user: {},
			role: {},
			set: {},
			device: {},
			user2role: {},
			set2role: {},
			device2set: {}
		},
		now: {
			user: null,
			role: null,
			set: null,
			device: null,
			user2role: null,
			set2role: null,
			device2set: null
		}
	},
	selected: {
		user: null,
		role: null,
		set: null,
		device: null
	},

	currentType: null,

	isUser2RoleListChanged: false,
	isSet2RoleListChanged: false,
	isDevice2SetListChanged: false,

	editor: null,
	isEvents: false,
	id: null,

	init: function(type, id)
	{
		if (!id)
			return;

		iCredentialsEditor.id = "#credentialManager";

		iCredentialsEditor.currentType = (type == "role" || type == "set" || type == "user") ? type : null;
		if (!iCredentialsEditor.currentType)
		{
			Log.error(__("Incorrect mode"));
			return;
		}

		iCredentialsEditor.isDebug && Log.info(__("Loading..."));

		var initEditor = function()
		{
			var caption = iCredentialsEditor.currentType.charAt(0).toUpperCase() + iCredentialsEditor.currentType.substring(1, iCredentialsEditor.currentType.length) + " Manager";
			$(iCredentialsEditor.id + " .single_tab:first .tab_text").html(caption);

			// load permission typeof list
			iCredentialsEditor.fillPermissionTypeList({
				id: "#set2role .permission",
				callback: function(){
					$("#set2role .permission").prepend(__("Permissions") + ":");
				}
			});

			var row;
			// init variables
			for (row in iCredentialsEditor.list.was)
			{
				iCredentialsEditor.list.was[row] = {};
			}
			for (row in iCredentialsEditor.list.now)
			{
				iCredentialsEditor.list.now[row] = null;
			}
			for (row in iCredentialsEditor.selected)
			{
				iCredentialsEditor.selected[row] = null;
			}

			iCredentialsEditor.addEvents();
			iCredentialsEditor.initType(iCredentialsEditor.currentType, null);
		};

		// check_event if editor already on screen
		if ($(iCredentialsEditor.id).length == 0)
		{
			$(id).load("cred.php", function(){
				initEditor();
			});
		} else {
			initEditor();
		}

		iCredentialsEditor.checkCredentials();
	},
	addEvents: function()
	{
		if (iCredentialsEditor.isEvents)
			return;

		iCredentialsEditor.isEvents = true;
		$("#editor .editor_close").click(function(){
			iCredentialsEditor.destroyEditor();
		});

		$("#sets .showSystemSets input[type=checkbox]").click(function(){
			var currentType = iCredentialsEditor.currentType;
			switch (currentType)
			{
				case "role":
					$("#roles .objectList option:selected").click();
				break;
				case "set":
					var obj = $("#sets .objectList").val();
					iCredentialsEditor.initSetManagement(obj);
				break;
			}
		});

		// add events for links for reload lists
		$(iCredentialsEditor.id + " .tabs_content").on("click", "a", function(){
			switch ($(this).attr("href"))
			{
				case "#users":
					iCredentialsEditor.init("user", iCredentialsEditor.id);
				break;
				case "#roles":
					iCredentialsEditor.init("role", iCredentialsEditor.id);
				break;
				case "#sets":
					iCredentialsEditor.init("set", iCredentialsEditor.id);
				break;
				case "#devices":
					//iCredentialsEditor.fillDeviceList();
				break;
			}
		});

		// add events for buttons for editing permissions
		/*$(iCredentialsEditor.id + " .tabs_content").on("click", ".permission", function(){
			Log.warning($(this).data("typeList") + " " + $(this).val());

			var type = $(this).data("type");
			var val = iCredentialsEditor.selected[type];
			Log.message(val);

			switch ($(this).data("typeList"))
			{
				case "set2role":
					// show permission editor
				break;
			}
		});*/

		// add events for buttons for relocating items in lists
		$(iCredentialsEditor.id + " .tabs_content").on("click", ".move", function(){
			iCredentialsEditor.isDebug && Log.warning($(this).data("typeList") + " " + $(this).val());

			var type = $(this).data("type");
			var val = iCredentialsEditor.selected[type];
			iCredentialsEditor.isDebug && Log.info(val);
			var i = 0;

			switch ($(this).data("typeList"))
			{
				case "user":
					if (val)
					{
						iCredentialsEditor.list.now.user2role = iCredentialsEditor.list.now.user2role || $.extend({}, iCredentialsEditor.list.was.user2role);
						iCredentialsEditor.list.now.user = iCredentialsEditor.list.now.user || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.user, iCredentialsEditor.list.was.user2role);
						for (i = 0; i < val.length; i++)
						{
							iCredentialsEditor.list.now.user2role[val[i]] = iCredentialsEditor.list.now.user[val[i]];
							delete iCredentialsEditor.list.now.user[val[i]];
						}

						iCredentialsEditor.fillUser2RoleList({ list: iCredentialsEditor.list.now.user2role});
						iCredentialsEditor.fillUserList({ list: iCredentialsEditor.list.now.user });
					}
				break;
				case "role":
					if (val)
					{
						if (iCredentialsEditor.currentType == "set")
						{
							iCredentialsEditor.list.now.set2role = iCredentialsEditor.list.now.set2role || $.extend({}, iCredentialsEditor.list.was.set2role);
							iCredentialsEditor.list.now.role = iCredentialsEditor.list.now.role || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.role, iCredentialsEditor.list.was.set2role);

							for (i = 0; i < val.length; i++)
							{
								iCredentialsEditor.list.now.set2role[val[i]] = iCredentialsEditor.list.now.role[val[i]];
								delete iCredentialsEditor.list.now.role[val[i]];
							}

							iCredentialsEditor.fillSet2RoleList({ list: iCredentialsEditor.list.now.set2role});
						} else {
							iCredentialsEditor.list.now.user2role = iCredentialsEditor.list.now.user2role || $.extend({}, iCredentialsEditor.list.was.user2role);
							iCredentialsEditor.list.now.role = iCredentialsEditor.list.now.role || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.role, iCredentialsEditor.list.was.user2role);

							for (i = 0; i < val.length; i++)
							{
								iCredentialsEditor.list.now.user2role[val[i]] = iCredentialsEditor.list.now.role[val[i]];
								delete iCredentialsEditor.list.now.role[val[i]];
							}

							iCredentialsEditor.fillUser2RoleList({ list: iCredentialsEditor.list.now.user2role});
						}

						iCredentialsEditor.fillRoleList({ list: iCredentialsEditor.list.now.role });
					}
				break;
				case "set":
					if (val)
					{
						iCredentialsEditor.list.now.set2role = iCredentialsEditor.list.now.set2role || $.extend({}, iCredentialsEditor.list.was.set2role);
						iCredentialsEditor.list.now.set = iCredentialsEditor.list.now.set || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.set, iCredentialsEditor.list.was.set2role);
						for (i = 0; i < val.length; i++)
						{
							iCredentialsEditor.list.now.set2role[val[i]] = iCredentialsEditor.list.now.set[val[i]];
							delete iCredentialsEditor.list.now.set[val[i]];
						}

						iCredentialsEditor.fillSet2RoleList({ list: iCredentialsEditor.list.now.set2role });
						iCredentialsEditor.fillSetList({ list: iCredentialsEditor.list.now.set });
					}
				break;
				case "device":
					if (val)
					{
						iCredentialsEditor.list.now.device2set = iCredentialsEditor.list.now.device2set || $.extend({}, iCredentialsEditor.list.was.device2set);
						iCredentialsEditor.list.now.device = iCredentialsEditor.list.now.device || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.device, iCredentialsEditor.list.was.device2set);
						for (i = 0; i < val.length; i++)
						{
							iCredentialsEditor.list.now.device2set[val[i]] = iCredentialsEditor.list.now.device[val[i]];
							delete iCredentialsEditor.list.now.device[val[i]];
						}

						iCredentialsEditor.fillDevice2SetList({ list: iCredentialsEditor.list.now.device2set });
						iCredentialsEditor.fillDeviceList({ list: iCredentialsEditor.list.now.device });
					}
				break;
				case "user2role":
					if (val)
					{
						iCredentialsEditor.list.now.user2role = iCredentialsEditor.list.now.user2role || $.extend({}, iCredentialsEditor.list.was.user2role);
						iCredentialsEditor.list.now[type] = iCredentialsEditor.list.now[type] || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was[type], iCredentialsEditor.list.was.user2role);
						for (i = 0; i < val.length; i++)
						{
							iCredentialsEditor.list.now[type][val[i]] = iCredentialsEditor.list.now.user2role[val[i]];
							delete iCredentialsEditor.list.now.user2role[val[i]];
						}

						iCredentialsEditor.fillUser2RoleList({ list: iCredentialsEditor.list.now.user2role});
						if (type == "user")
							iCredentialsEditor.fillUserList({ list: iCredentialsEditor.list.now[type] });
						else
							iCredentialsEditor.fillRoleList({ list: iCredentialsEditor.list.now[type] });
					}
				break;
				case "set2role":
					if (val)
					{
						iCredentialsEditor.list.now.set2role = iCredentialsEditor.list.now.set2role || $.extend({}, iCredentialsEditor.list.was.set2role);
						iCredentialsEditor.list.now[type] = iCredentialsEditor.list.now[type] || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was[type], iCredentialsEditor.list.was.set2role);
						for (i = 0; i < val.length; i++)
						{
							iCredentialsEditor.list.now[type][val[i]] = iCredentialsEditor.list.now.set2role[val[i]];
							delete iCredentialsEditor.list.now.set2role[val[i]];
						}

						iCredentialsEditor.fillSet2RoleList({ list: iCredentialsEditor.list.now.set2role });
						if (type == "set")
							iCredentialsEditor.fillSetList({ list: iCredentialsEditor.list.now[type] });
						else
							iCredentialsEditor.fillRoleList({ list: iCredentialsEditor.list.now[type] });
					}
				break;
				case "device2set":
					if (val)
					{
						iCredentialsEditor.list.now.device2set = iCredentialsEditor.list.now.device2set || $.extend({}, iCredentialsEditor.list.was.device2set);
						iCredentialsEditor.list.now[type] = iCredentialsEditor.list.now[type] || iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was[type], iCredentialsEditor.list.was.device2set);
						for (i = 0; i < val.length; i++)
						{
							iCredentialsEditor.list.now[type][val[i]] = iCredentialsEditor.list.now.device2set[val[i]];
							delete iCredentialsEditor.list.now.device2set[val[i]];
						}

						iCredentialsEditor.fillDevice2SetList({ list: iCredentialsEditor.list.now.device2set });
						iCredentialsEditor.fillDeviceList({ list: iCredentialsEditor.list.now[type] });
					}
				break;
			}

			iCredentialsEditor.save();

			iCredentialsEditor.showHideButtons({
				show: ["move", "edit", "delete"]
			});
		});

		// add events for buttons for adding objects
		$(iCredentialsEditor.id + " .tabs_content").on("click", ".add", function(){
			iCredentialsEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var type = $(this).data("type");
			var typeList = $(this).data("typeList");

			switch (typeList)
			{
				case "user":
				case "role":
				case "set":
					iCredentialsEditor.createEditor({
						id: "#editor",
						type: type,
						buttons: {
							remove: {
								show: false
							},
							back: {
								show: false
							}
						}
					});
					iCredentialsEditor.editor.onSave = function(obj, success)
					{
						if (obj && success)
						{
							iCredentialsEditor.destroyEditor();
							iCredentialsEditor.initType(iCredentialsEditor.currentType, obj);
						}
					};
				break;
				case "user2role":
				break;
				case "set2role":
				break;
				case "device2set":
				break;
			}
		});

		// add events for buttons for editing objects
		$(iCredentialsEditor.id + " .tabs_content").on("click", ".edit", function(){
			iCredentialsEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var type = $(this).data("type");
			var obj = null;

			if (iCredentialsEditor.selected[type])
			{
				obj = iCredentialsEditor.selected[type][0];
			}

			if (type && obj)
			{
				iCredentialsEditor.createEditor({
					obj: obj,
					id: "#editor .content",
					type: type,
					buttons: {
						back: {
							show: false
						}
					}
				});
				var func = function(obj, success)
				{
					if (success)
					{
						iCredentialsEditor.destroyEditor();
						iCredentialsEditor.initType(iCredentialsEditor.currentType, obj);
					}
				};
				iCredentialsEditor.editor.onSave = func;
				iCredentialsEditor.editor.onDelete = func;
			}
		});

		// add events for buttons for editing user password
		$(iCredentialsEditor.id + " .tabs_content").on("click", ".edit_password", function(){
			iCredentialsEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var obj = null;
			var type = $(this).data("type");
			if (iCredentialsEditor.selected[type])
			{
				obj = iCredentialsEditor.selected[type][0];
			}

			var passwordEditor = new PasswordEditor();
			passwordEditor.init({
				selector: "#password_editor .tabs_content",
				obj: obj,
				onlyChange: false,
				success: function()
				{
					$("#password_editor .password_editor_close").click();
				}
			});

			$("#password_editor .password_editor_close").click(function(){
				$("#password_editor").hide();
			});

			$("#password_editor").show();
		});

		// add events for buttons for deleting objects
		$(iCredentialsEditor.id + " .tabs_content").on("click", ".delete", function(){
			iCredentialsEditor.isDebug && Log.warning($(this).data("type") + " " + $(this).val());

			var type = $(this).data("type");
			var objList = null;

			if (iCredentialsEditor.selected[type])
			{
				objList = iCredentialsEditor.selected[type];
			}

			if (type && objList)
			{
				// delete only not protected objects
				var objListForDelete = [];
				var i;
				for (i = 0; i < objList.length; i++)
				{
					var element = iCredentialsEditor.list.was[type][objList[i]];
					if (element)
					{
						if (element.protected == "0")
						{
							objListForDelete.push(objList[i]);
						} else {
							// i18n: example: Role Admin is protected
							Log.warning(Gettext.strargs(__("%1 '%2' is protected"), [type, element.name]));
						}
					}
				}

				var stringList = "";
				for (i = 0; i < objListForDelete.length; i++)
				{
					if (iCredentialsEditor.list.was[type][objListForDelete[i]])
					{
						stringList += iCredentialsEditor.list.was[type][objListForDelete[i]].name;
						if (i < objListForDelete.length - 1)
							stringList += ", ";
					}
				}

				if (objListForDelete.length > 0 && confirm(Gettext.strargs(__("Are you sure you want to delete %1 (%2)?"), [type, stringList])))
				{
					var api = new API();
					api.deleteObject({objList: JSON.stringify(objListForDelete)})
						.fail(function(code, message){
							Log.error(message);
						})
						.always(function(){
							iCredentialsEditor.initType(iCredentialsEditor.currentType, objList);
						});
				}
			}
			iCredentialsEditor.initType(iCredentialsEditor.currentType, null);
		});

		// add events for dropdown list for changing object permissions
		$(iCredentialsEditor.id + " .tabs_content #set2role").on("change", ".permission select", function(){
			if (iCredentialsEditor.currentType == "role")
			{
				if (iCredentialsEditor.selected.set == null || iCredentialsEditor.selected.role == null)
				{
					Log.error(__("Please select role and set!"));
					return;
				}

				Log.info(__("Saving permission"));
				var setid = iCredentialsEditor.selected.set[0];
				var roleid = iCredentialsEditor.selected.role[0];
				var permission = $("#set2role .permission select").val();
				iCredentialsEditor.savePermission({
					setid: setid,
					roleid: roleid,
					permission: permission,
					success: function()
					{
						$(iCredentialsEditor.id + " .tabs_content").unmask();
						$("#roles .objectList option:selected").click();
						//iCredentialsEditor.initType(iCredentialsEditor.currentType, iCredentialsEditor.selected[iCredentialsEditor.currentType]);
					}
				});
				//iCredentialsEditor.save();
			}
		});

		// add events for checkbox list list for changing object special credentials
		$(iCredentialsEditor.id + " .tabs_content #set2role").on("change", ".special_credentials input[type=checkbox]", function(){
			if (iCredentialsEditor.currentType == "role")
			{
				if (iCredentialsEditor.selected.set == null || iCredentialsEditor.selected.role == null)
				{
					$(this).prop("checked", false);
					Log.error(__("Please select role and set!"));
					return;
				}

				Log.info(__("Saving credentials"));
				var setid = iCredentialsEditor.selected.set[0];
				var roleid = iCredentialsEditor.selected.role[0];

				var credentials = "";
				var scInputs = $("#set2role .special_credentials input[type=checkbox]");
				$.each(scInputs, function(){
					var element = $(this);
					if (element.prop("checked"))
					{
						credentials += element.data("credential");
					}
				});

				iCredentialsEditor.saveSpecialCredentials({
					setid: setid,
					roleid: roleid,
					credentials: credentials,
					success: function()
					{
						$(iCredentialsEditor.id + " .tabs_content").unmask();
						$("#roles .objectList option:selected").click();
						//iCredentialsEditor.initType(iCredentialsEditor.currentType, iCredentialsEditor.selected[iCredentialsEditor.currentType]);
					}
				});
				//iCredentialsEditor.save();
			}
		});

		// add events for lists for selecting items
		$(iCredentialsEditor.id + " .tabs_content").on("click keyup", ".objectList", function(){
			iCredentialsEditor.isDebug && Log.warning($(this).data("typeList") + " " + $(this).val());

			// hide special credentials by default
			$("#set2role .special_credentials input[type=checkbox]:not([id=scEmailOnEvent])")
				.prop("checked", false)
				.parent().hide();

			var val = $(this).val();
			if (val)
			{
				iCredentialsEditor.selected[$(this).data("type")] = val;
				switch ($(this).data("typeList"))
				{
					case "user2role":
					break;
					case "user":
						if (iCredentialsEditor.currentType == "user")
						{
							// clear changes for previous selected user
							iCredentialsEditor.list.now = {};

							iCredentialsEditor.fillUser2RoleList({
								userid: iCredentialsEditor.selected.user[0],
								callback: function()
								{
									iCredentialsEditor.fillRoleList({ except: iCredentialsEditor.list.was.user2role });
								}
							});
						}
					break;
					case "role":
						if (iCredentialsEditor.currentType == "role")
						{
							// clear changes for previous selected role
							iCredentialsEditor.list.now = {};

							iCredentialsEditor.fillUser2RoleList({
								roleid: iCredentialsEditor.selected.role[0],
								callback: function()
								{
									iCredentialsEditor.fillUserList({ except: iCredentialsEditor.list.was.user2role });
								}
							});

							var withProtected = $("#sets .showSystemSets input[type=checkbox]").prop("checked");

							iCredentialsEditor.fillSet2RoleList({
								roleid: iCredentialsEditor.selected.role[0],
								callback: function()
								{
									iCredentialsEditor.fillSetList({
										except: iCredentialsEditor.list.was.set2role,
										withProtected: withProtected
									});
								}
							});
						}
					break;
					case "set2role":
						if (iCredentialsEditor.currentType == "role")
						{
							var set2role = iCredentialsEditor.list.was.set2role[iCredentialsEditor.selected.set[0]];
							var permission = set2role.permission;
							$("#set2role .permission select").val(permission);

							// insert readonly if set2role protected
							var isProtected = set2role.protected;
							$("#set2role .permission select").prop("disabled", isProtected == '1');

							var credentials = set2role.credentials;
							var selectorCredentialList = {
								"#set2role .special_credentials input[id=scEmailOnEvent]": "I",
								"#scUserRoleSet": "U",
								"#scUsers": "u",
								"#scFullDevice": "F",
								"#scDeviceSettings": "f",
								"#scDevicePolicy": "R",
								"#scDeviceAnalytics": "E"
							};

							// set special credential values
							for (var selector in selectorCredentialList)
							{
								var credential = selectorCredentialList[selector];
								var isChecked = !!credentials.match(credential);
								$(selector).prop("checked", isChecked);
							}

							// show special admin credentials for set 'All GUIs'
							var obj = set2role.obj;
							if (obj == 12)
							{
								// do not allow remove default Admin Role special credentials
								var isDisabled = iCredentialsEditor.selected.role[0] == 31;
								$("#set2role .special_credentials input[type=checkbox]:not([id=scEmailOnEvent])")
									.prop("disabled", isDisabled)
									.parent().show();
							}
						}
					break;
					case "set":
						if (iCredentialsEditor.currentType == "set")
						{
							// clear changes for previous selected set
							iCredentialsEditor.list.now = {};

							iCredentialsEditor.fillSet2RoleList({
								setid: iCredentialsEditor.selected.set[0],
								callback: function()
								{
									iCredentialsEditor.fillRoleList({ except: iCredentialsEditor.list.was.set2role });
								}
							});
							iCredentialsEditor.fillDevice2SetList({
								setid: iCredentialsEditor.selected.set[0],
								filter: $("#device2set .objectFilter").val(),
								callback: function()
								{
									iCredentialsEditor.fillDeviceList({ except: iCredentialsEditor.list.was.device2set, filter: $("#devices .objectFilter").val()});
								}
							});
						}
					break;
					case "device":
					break;
				}

				if (iCredentialsEditor.currentType == $(this).data("typeList"))
				{
					iCredentialsEditor.showHideButtons({
						type: $(this).data("typeList"),
						show: ["add", "delete", "edit", "edit_password"]
					});
				} else {
					if (iCredentialsEditor.currentType == "role")
					{
						iCredentialsEditor.showHideButtons({
							type: $(this).data("typeList"),
							show: ["move", "permission", "special_credentials"]
						});
					} else {
						iCredentialsEditor.showHideButtons({
							type: $(this).data("typeList"),
							show: ["move"]
						});
					}
				}

				if (iCredentialsEditor.currentType !== "role")
				{
					$("#set2role .permission").hide();
				} else {
					$("#set2role .permission").show();

					$("#set2role .permission select").prop("disabled", false);
					$("#scEmailOnEvent").prop("disabled", false);

					if (iCredentialsEditor.selected.set !== null
						&& iCredentialsEditor.selected.set.length > 0
						&& typeof(iCredentialsEditor.list.was.set2role[iCredentialsEditor.selected.set[0]]) !== 'undefined')
					{
						var isProtected = iCredentialsEditor.list.was.set2role[iCredentialsEditor.selected.set[0]].protected;
						if (isProtected == '1')
						{
							$("#set2role .permission select").prop("disabled", true);
							$("#set2role .special_credentials input[id=scEmailOnEvent]").prop("disabled", true);
						}
					}
				}
			}
		});

		$("#device2set").on("keyup", ".objectFilter", function(){//change keyup
			var filter = $(this).val();
			var list = null;
			var setid = iCredentialsEditor.selected.set[0];
			if (iCredentialsEditor.list.was.device2set)
			{
				list = iCredentialsEditor.list.was.device2set;
				setid = null;
			}
			iCredentialsEditor.fillDevice2SetList({
				list: list,
				setid: setid,
				filter: filter
			});
		});

		$("#devices").on("keyup", ".objectFilter", function(){//change keyup
			var filter = $(this).val();
			iCredentialsEditor.fillDeviceList({
				list: iCredentialsEditor.list.was.device,
				except: iCredentialsEditor.list.was.device2set,
				filter: filter
			});
		});

	},
	showHideButtons: function(params)
	{
		params.type = params.type || null;
		params.show = params.show || [];

		// list of types and their list ids
		var types = {
			set: "#sets",
			role: "#roles",
			user: "#users",
			device: "#devices",
			user2role: "#user2role",
			set2role: "#set2role",
			device2set: "#device2set"
		};

		var actions = [
			{
				action: "add",
				selector: ".add"
			},
			{
				action: "delete",
				selector: ".delete"
			},
			{
				action: "edit",
				selector: ".edit"
			},
			{
				action: "edit_password",
				selector: ".edit_password"
			},
			{
				action: "move",
				selector: ".move"
			},
			{
				action: "permission",
				selector: ".permission select"
			},
			{
				action: "special_credentials",
				selector: ".special_credentials input[id=scEmailOnEvent]"
			}
		];

		var i;
		// hide all action buttons
		for (var type in types)
		{
			for (i = 0; i < actions.length; i++)
				$(types[type] + " " + actions[i].selector).prop("disabled", "true");

			// remove border around list
			$(types[type] + " .objectList")
				.removeClass("highlightBorder");
				//.addClass("normalBorder");
		}

		if (params.type)
		{
			// show action buttons
			for (i = 0; i < actions.length; i++)
			{
				for (var j = 0; j < params.show.length; j++)
				{
					if (actions[i].action == params.show[j])
						$(types[params.type] + " " + actions[i].selector).prop("disabled", false);
				}
			}

			// add border around list
			$(types[params.type] + " .objectList")
				//.removeClass("normalBorder")
				.addClass("highlightBorder");
		}
	},
	initType: function(type, obj)
	{
		switch (type)
		{
			case "user":
				iCredentialsEditor.initUserManagement(obj);
			break;
			case "role":
				iCredentialsEditor.initRoleManagement(obj);
			break;
			case "set":
				iCredentialsEditor.initSetManagement(obj);
			break;
		}
	},
	initUserManagement: function(obj)
	{
		obj = obj || null;

		$("#users .objectList").empty();
		$("#users")
			.addClass("free")
			.css({
				display: "block",
				left: ""
			});
		$("#users .controls input").show();
		$("#users .controls2 input").hide();

		$("#roles .objectList").empty();
		$("#roles")
			.addClass("free")
			.hide();
		$("#roles .controls input").hide();
		$("#roles .controls2 input").show();
		$("#sets .objectList").empty();
		$("#sets").hide();
		$("#devices .objectList").empty();
		$("#devices").hide();

		$("#user2role .objectList").empty();
		$("#user2role .caption").html(__("Roles to User"));
		$("#user2role")
			.addClass("free")
			.css({
				display: "block",
				left: ($("#users").position().left + $("#users").outerWidth()) + "px",
				top: ($("#users").position().top) + "px"
			});

		$("#set2role .objectList").empty();
		$("#set2role").hide();
		$("#device2set .objectList").empty();
		$("#device2set").hide();

		var blockHeight = $("#users").outerHeight();
		$(".credentialManagerBlock").height(blockHeight);

		$("#roles").css({
			display: "block",
			left: ($("#user2role").position().left + $("#user2role").width() + $("#user2role .controls2").width()) + "px",
			top: ($("#user2role").position().top) + "px"
		});

		iCredentialsEditor.fillUserList({
			callback: function()
			{
				obj = obj || $("#users .objectList option:first").val();
				if (obj)
				{
					var element = $("#users .objectList option[value=" + obj + "]");
					if (!(element.length > 0))
					{
						element = $("#users .objectList option[value=" + iCredentialsEditor.selected.user[0] + "]");
					}
					element.prop("selected", true).click();
				}
			}
		});
	},
	initRoleManagement: function(obj)
	{
		obj = obj || null;

		$("#users .objectList").empty();
		$("#users")
			.addClass("free")
			.hide(); // should be show
		$("#users .controls input").hide();
		$("#users .controls2 input").show();
		$("#roles .objectList").empty();
		$("#roles")
			.addClass("free")
			.show();
		$("#roles .controls input").show();
		$("#roles .controls2 input").hide();
		$("#sets .objectList").empty();
		$("#sets")
			.addClass("free")
			.hide(); // should be show
		$("#sets .controls input[type=button]").hide();
		$("#sets .controls2 input").show();
		$("#devices .objectList").empty();
		$("#devices").hide();

		$("#user2role .objectList").empty();
		$("#user2role .caption").html(__("Users in Role"));
		$("#user2role")
			.addClass("free")
			.show();
		$("#set2role .objectList").empty();
		$("#set2role .caption").html(__("Sets in Role"));
		$("#set2role")
			.addClass("free")
			.show();
		$("#device2set .objectList").empty();
		$("#device2set").hide();

		var blockHeight = $("#user2role").outerHeight(true) + $("#set2role").outerHeight(true) + 10;
		var rolesHeight = $("#roles").outerHeight();

		$(".credentialManagerBlock").height(blockHeight);
		$("#roles").css({
			top: ($(".credentialManagerBlock").position().top + blockHeight / 2 - rolesHeight / 2) + "px",
			left: ""
		});
		$("#user2role")
			.css({
				left: ($("#roles").position().left + $("#roles").outerWidth()) + "px",
				top: ($("#roles").position().top - rolesHeight / 2) + "px"
			});
		$("#set2role")
			.css({
				left: ($("#roles").position().left + $("#roles").outerWidth()) + "px",
				top: ($("#roles").position().top + rolesHeight / 2) + "px"
			});
		$("#users").css({
			display: "block",
			left: ($("#user2role").position().left + $("#user2role").width() + $("#user2role .controls2").width()) + "px",
			top: ($("#user2role").position().top) + "px"
		});
		$("#sets").css({
			display: "block",
			left: ($("#set2role").position().left + $("#set2role").width() + $("#set2role .controls2").width()) + "px",
			top: ($("#set2role").position().top) + "px"
		});

		$("#set2role .special_credentials input[type=checkbox]:not([id=scEmailOnEvent])").parent().hide();

		iCredentialsEditor.fillRoleList({
			callback: function()
			{
				obj = obj || $("#roles .objectList option:first").val();
				if (obj)
				{
					var element = $("#roles .objectList option[value=" + obj + "]");
					if (!(element.length > 0))
					{
						element = $("#roles .objectList option[value=" + iCredentialsEditor.selected.role[0] + "]");
					}
					element.prop("selected", true).click();
				}
			}
		});
	},
	initSetManagement: function(obj)
	{
		obj = obj || null;

		$("#users .objectList").empty();
		$("#users").hide();
		$("#roles .objectList").empty();
		$("#roles")
			.addClass("free")
			.hide(); // should be show
		$("#roles .controls input").hide();
		$("#roles .controls2 input").show();
		$("#sets .objectList").empty();
		$("#sets")
			.addClass("free")
			.show();
		$("#sets .controls input").show();
		$("#sets .controls2 input").hide();
		$("#devices .objectList").empty();
		$("#devices")
			.addClass("free")
			.hide(); // should be show
		$("#users .controls input").hide();
		$("#users .controls2 input").show();

		$("#user2role .objectList").empty();
		$("#user2role").hide();
		$("#set2role .objectList").empty();
		$("#set2role .caption").html(__("Roles to Set"));
		$("#set2role")
			.addClass("free")
			.show();
		$("#device2set .objectList").empty();
		$("#device2set")
			.addClass("free")
			.show();

		var blockHeight = $("#set2role").outerHeight() + $("#device2set").outerHeight();
		var setsHeight = $("#sets").outerHeight();

		$(".credentialManagerBlock").height(blockHeight+20);
		$("#sets").css({
			top: ($(".credentialManagerBlock").position().top + blockHeight / 2 - setsHeight / 2) + "px",
			left: ""
		});
		$("#set2role")
			.css({
				left: ($("#sets").position().left + $("#sets").outerWidth()) + "px",
				top: ($("#sets").position().top - 10 - setsHeight / 2) + "px"
			});
		$("#device2set")
			.css({
				left: ($("#sets").position().left + $("#sets").outerWidth()) + "px",
				top: ($("#sets").position().top + setsHeight / 2) + "px"
			});
		$("#roles").css({
			display: "block",
			left: ($("#set2role").position().left + $("#set2role").width() + $("#set2role .controls2").width()) + "px",
			top: ($("#set2role").position().top) + "px"
		});
		$("#devices").css({
			display: "block",
			left: ($("#device2set").position().left + $("#device2set").width() + $("#device2set .controls2").width()) + "px",
			top: ($("#device2set").position().top) + "px"
		});

		var withProtected = $("#sets .showSystemSets input[type=checkbox]").prop("checked");

		iCredentialsEditor.fillSetList({
			withProtected: withProtected,
			callback: function()
			{
				obj = obj || $("#sets .objectList option:first").val();
				if (obj)
				{
					var element = $("#sets .objectList option[value=" + obj + "]");
					if (!(element.length > 0))
					{
						element = $("#sets .objectList option[value=" + iCredentialsEditor.selected.set[0] + "]");
					}
					element.prop("selected", true).click();
				}
			}
		});
	},
	getList: function(params)
	{
		if (!params)
		{
			return;
		}

		params.type = params.type || null;
		params.userid = params.userid || null;
		params.roleid = params.roleid || null;
		params.setid = params.setid || null;
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		var data = {};

		var isAll = ((params.userid || params.roleid || params.setid) === null) && params.type !== null;
		if (isAll && isAll != false) data.isAll = isAll;
		if (params.type) data.type = params.type;
		if (params.userid) data.userid = params.userid;
		if (params.roleid) data.roleid = params.roleid;
		if (params.setid) data.setid = params.setid;

		if ($.isFunction(params.beforeSend))
		{
			params.beforeSend();
		}
		var api = new API();
		api.getObjectList(data)
			.fail(function(code, message){
				Log.error(message);
				if ($.isFunction(params.error))
				{
					params.error();
				}
			})
			.done(function(response){
				response.list = response.list || [];
				if ($.isFunction(params.success))
				{
					params.success(iCredentialsEditor.changeListFormat(response.list));
				}
			});
	},
	convertListToHTML: function(params)
	{
		params.list = params.list || {};
		params.withUDID = !!params.withUDID;
		params.withProtected = params.withProtected == null ? params.withProtected = true : params.withProtected = !!params.withProtected;

		var list_html = ['<select class="objectList" multiple="true">'];
		if (!$.isEmptyObject(params.list))
		{
			for (var i in params.list)
			{
				var row = params.list[i];
				//if (!row) continue;
				var obj = row.obj;
				var name = row.name;
				var udidlabel = '';
				if (params.withUDID){
					if (row.udid && row.udid!=''){
						udidlabel = '[' + row.udid + ']';
					}else{
						udidlabel = '#' + row.obj;
					}
				}
				var label = udidlabel + ' ' + __(name);

				var isProtected = row["protected"] == "1";
				if (!params.withProtected && isProtected)
					continue;

				var item = '<option value="' + obj + '"> ' + label + '</option>';

				list_html.push(item);
			}
		}
		list_html.push('</select>');
		return list_html.join('');
	},
	changeListFormat: function(list)
	{
		// TODO: slow code, need optimizing
		var changedList = {};
		for (var i = 0; i < list.length; i++)
		{
			changedList[list[i].obj] = list[i];
		}
		return changedList;
	},
	/**
	 * remove from source array elements with 'obj' that contains in except array
	 * @param source
	 * @param except
	 * @return array
	 */
	removeFromArray: function(source, except)
	{
		var result = {};
		if (!$.isEmptyObject(except))
		{
			// TODO: slow code, need optimizing
			for (var i in source)
			{
				var sourceRow = source[i];
				var add = true;
				for (var j in except)
				{
					var exceptRow = except[j];
					if (sourceRow.obj == exceptRow.obj)
					{
						add = false;
						break;
					}
				}
				if (add)
				{
					result[sourceRow.obj] = sourceRow;
				}
			}
		} else
			result = $.extend({}, source);
		return result;
	},
	/**
	 * remove from source array elements havn't got simbols in filter
	 * @param source
	 * @param filter
	 * @return array
	 */
	removeByFilter: function(source, filter)
	{
		var result = source;
		var maskVal = filter || null;
		if (maskVal) {
			maskVal = maskVal.toLowerCase();
			var a = '\\';
			maskVal = maskVal.replace('(', a+'(');
			maskVal = maskVal.replace(')', a+')');
			maskVal = maskVal.replace('[', a+'[');
			maskVal = maskVal.replace(']', a+']');
			maskVal = maskVal.replace('*', a+'*');
			maskVal = maskVal.replace('+', a+'+');
			maskVal = maskVal.replace('?', a+'?');
		}
		if (maskVal)
		{
			result = {};
			for (var i in source)
			{
				var sourceRow = source[i];
				if (sourceRow["udid"] && sourceRow["udid"]!=''){
					var fullname = sourceRow["udid"].toLowerCase() + sourceRow["name"].toLowerCase();
					var fullname1 = '[' + sourceRow["udid"].toLowerCase()+ '] ' + sourceRow["name"].toLowerCase();
				}else{
					var fullname = sourceRow["obj"].toLowerCase() + sourceRow["name"].toLowerCase();
					var fullname1 = '#' + sourceRow["obj"].toLowerCase()+ ' ' + sourceRow["name"].toLowerCase();
				}

				if (fullname && !(fullname.match(maskVal) || fullname1.match(maskVal)))
				{
					continue;
				}
				result[i] = source[i];
			}
		}
		return result;
	},
	/**
	 * add to source array elements with 'obj' that contains in addition array and not contains in source array
	 * @param source
	 * @param addition
	 * @return array
	 */
	object_merge: function(source, addition)
	{
		var result = $.extend({}, source);
		if (!$.isEmptyObject(addition))
		{
			// TODO: slow code, need optimizing
			for (var i in addition)
			{
				var additionRow = addition[i];
				var add = true;
				for (var j in source)
				{
					var sourceRow = source[j];
					if (sourceRow.obj == additionRow.obj)
					{
						add = false;
						break;
					}
				}
				if (add)
				{
					result[additionRow.obj] = additionRow;
				}
			}
		}
		return result;
	},
	fillUserList: function(params)
	{
		if (!params)
			return;

		params.except = params.except || [];
		params.list = params.list || null;
		params.addition = params.addition || [];
		params.callback = params.callback || null;

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
				list: iCredentialsEditor.removeFromArray(list, params.except)
			}));

			var data = {
				"typeList": "user",
				"type": "user"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#users";
		if (params.list)
		{
			fillList(id, params.list);
		} else {
			iCredentialsEditor.getList(
			{
				type: "user",
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iCredentialsEditor.list.was.user = list;
					fillList(id, iCredentialsEditor.list.was.user);
				}
			});
		}
	},
	fillRoleList: function(params)
	{
		if (!params)
			return;

		params.except = params.except || [];
		params.list = params.list || null;
		params.addition = params.addition || [];
		params.callback = params.callback || null;

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
				list: iCredentialsEditor.removeFromArray(list, params.except)
			}));
			var data = {
				"typeList": "role",
				"type": "role"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#roles";
		if (params.list)
		{
			fillList(id, params.list);
		} else {
			iCredentialsEditor.getList(
			{
				type: "role",
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iCredentialsEditor.list.was.role = list;
					fillList(id, iCredentialsEditor.list.was.role);
				}
			});
		}
	},
	fillSetList: function(params)
	{
		if (!params)
			return;

		params.withProtected = params.withProtected == null ? params.withProtected = false : params.withProtected = !!params.withProtected;
		params.except = params.except || [];
		params.list = params.list || null;
		params.addition = params.addition || [];
		params.callback = params.callback || null;

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
				list: iCredentialsEditor.removeFromArray(list, params.except),
				withProtected: params.withProtected
			}));

			var data = {
				"typeList": "set",
				"type": "set"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#sets";

		if (params.list)
		{
			 fillList(id, params.list);
		} else {
			iCredentialsEditor.getList(
			{
				type: "set",
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					// do not show 'Matrix' set
					delete list[13];

					iCredentialsEditor.list.was.set = list;
					fillList(id, iCredentialsEditor.list.was.set);
				}
			});
		}
	},
	fillDeviceList: function(params)
	{
		if (!params)
			return;

		params.except = params.except || [];
		params.filter = params.filter || null;
		params.list = params.list || null;
		params.addition = params.addition || [];
		params.callback = params.callback || null;

		var fillList = function(id, list)
		{
			// show only objects with otype = 'D', 'V' or 'X'
			var filteredList = {};
			for (var obj in list)
			{
				if ((list[obj].otype == "D" && list[obj].subtype != "V") || list[obj].otype == "X" || list[obj].otype == "V")
				{
					filteredList[obj] = list[obj];
				}
			}
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
//				list: iCredentialsEditor.removeFromArray(filteredList, params.except),
				list: iCredentialsEditor.removeFromArray(iCredentialsEditor.removeByFilter(filteredList, params.filter), params.except),
				withUDID: true
			}));

			var data = {
				"typeList": "device",
				"type": "device"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#devices";

		if (params.list)
		{
			 fillList(id, params.list);
		} else {
			iCredentialsEditor.getList(
			{
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iCredentialsEditor.list.was.device = list;
					fillList(id, iCredentialsEditor.list.was.device); // add param
				}
			});
		}
	},
	fillUser2RoleList: function(params)
	{
		if (!params)
			return;

		params.roleid = params.roleid || null;
		params.userid = params.userid || null;
		params.list = params.list || null;
		params.callback = params.callback || null;

		if (iCredentialsEditor.isUser2RoleListChanged)
		{
			Log.warning(__("user2Role was changed, you can lost your changes"));
		}

		// in user2role list can be roles or users
		var type = "";
		if (iCredentialsEditor.currentType == "role")
			type = "user";
		else
		if (iCredentialsEditor.currentType == "user")
			type = "role";

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
				list: iCredentialsEditor.removeFromArray(list, params.except)
			}));

			var data = {
				typeList: "user2role",
				type: type
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#user2role";

		if (params.list)
		{
			fillList(id, params.list)
		} else {
			if (!params.roleid && !params.userid)
			{
				Log.error(__("Please specify roleid or userid"));
				return;
			}
			var data = {
				type: type,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iCredentialsEditor.list.was.user2role = list;
					fillList(id, iCredentialsEditor.list.was.user2role);
				}
			};

			if (params.roleid) data.roleid = params.roleid;
			if (params.userid) data.userid = params.userid;

			iCredentialsEditor.getList(data);
		}
	},
	fillSet2RoleList: function(params)
	{
		if (!params)
			return;

		params.withProtected = params.withProtected == null ? params.withProtected = true : params.withProtected = !!params.withProtected;
		params.roleid = params.roleid || null;
		params.setid = params.setid || null;
		params.list = params.list || null;
		params.callback = params.callback || null;

		if (iCredentialsEditor.isSet2RoleListChanged)
		{
			Log.warning(__("set2Role was changed, you can lost your changes"));
		}

		// in set2role list can be roles or sets
		var type = "";
		if (iCredentialsEditor.currentType == "role")
			type = "set";
		else
		if (iCredentialsEditor.currentType == "set")
			type = "role";

		var fillList = function(id, list)
		{
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
				list: iCredentialsEditor.removeFromArray(list, params.except),
				withProtected: params.withProtected
			}));

			var data = {
				"typeList": "set2role",
				"type": type
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#set2role";

		if (params.list)
		{
			fillList(id, params.list);
		} else {
			if (!params.roleid && !params.setid)
			{
				Log.error(__("Please specify roleid or setid"));
				return;
			}
			var data = {
				type: type,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					// do not show 'Matrix' set
					delete list[13];

					iCredentialsEditor.list.was.set2role = list;
					fillList(id, iCredentialsEditor.list.was.set2role);
				}
			};

			if (params.roleid) data.roleid = params.roleid;
			if (params.setid) data.setid = params.setid;

			iCredentialsEditor.getList(data);
		}
	},
	fillDevice2SetList: function(params)
	{
		if (!params)
			return;

		params.setid = params.setid || null;
		params.list = params.list || null;
		params.filter = params.filter || null;
		params.callback = params.callback || null;

		if (iCredentialsEditor.isDevice2SetListChanged)
		{
			Log.warning(__("device2set was changed, you can lost your changes"));
		}

		var fillList = function(id, list)
		{
			// show only objects with otype = 'D', 'V' or 'X'
			var filteredList = {};
			for (var obj in list)
			{
				if ((list[obj].otype == "D" && list[obj].subtype != "V") || list[obj].otype == "X" || list[obj].otype == "V")
				{
					filteredList[obj] = list[obj];
				}
			}
			$(id + " .objectList").replaceWith(iCredentialsEditor.convertListToHTML({
				list: iCredentialsEditor.removeFromArray(iCredentialsEditor.removeByFilter(filteredList, params.filter), params.except),
				withUDID: true
			}));

			var data = {
				"typeList": "device2set",
				"type": "device"
			};
			$(id + " input").data(data);
			$(id + " .objectList").data(data);
			$(id).unmask();

			if ($.isFunction(params.callback))
			{
				params.callback();
			}
		};

		var id = "#device2set";

		if (params.list)
		{
			fillList(id, params.list);
		} else {
			if (!params.setid)
			{
				Log.error(__("Please specify setid"));
				return;
			}
			iCredentialsEditor.getList(
			{
				// type: "device", // we need all of types in set
				setid: params.setid,
				beforeSend: function()
				{
					$(id).mask();
				},
				error: function()
				{
					$(id).html('');
				},
				success: function(list)
				{
					iCredentialsEditor.list.was.device2set = list;
					fillList(id, iCredentialsEditor.list.was.device2set);
				}
			});
		}
	},
	save: function()
	{
		var addRoleList = [];
		var removeRoleList = [];
		var addSetList = [];
		var removeSetList = [];

		// add
		var user2roleList = iCredentialsEditor.removeFromArray(iCredentialsEditor.list.now.user2role || {}, iCredentialsEditor.list.was.user2role);
		var set2roleList = iCredentialsEditor.removeFromArray(iCredentialsEditor.list.now.set2role || {}, iCredentialsEditor.list.was.set2role);
		var list = iCredentialsEditor.object_merge(user2roleList, set2roleList);
		var device2setList = iCredentialsEditor.removeFromArray(iCredentialsEditor.list.now.device2set || {}, iCredentialsEditor.list.was.device2set);

		var obj;
		for (obj in list)
		{
			addRoleList.push(obj);
		}
		for (obj in device2setList)
		{
			addSetList.push(obj);
		}

		// remove
		user2roleList = iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.user2role, iCredentialsEditor.list.now.user2role || iCredentialsEditor.list.was.user2role);
		set2roleList = iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.set2role, iCredentialsEditor.list.now.set2role || iCredentialsEditor.list.was.set2role);
		list = iCredentialsEditor.object_merge(user2roleList, set2roleList);
		device2setList = iCredentialsEditor.removeFromArray(iCredentialsEditor.list.was.device2set, iCredentialsEditor.list.now.device2set || iCredentialsEditor.list.was.device2set);

		for (obj in list)
		{
			removeRoleList.push(obj);
		}
		for (obj in device2setList)
		{
			removeSetList.push(obj);
		}

		var data = {
			beforeSend: function()
			{
				$(iCredentialsEditor.id + " .tabs_content").mask();
			}
		};

		switch (iCredentialsEditor.currentType)
		{
			case "user":
				// add (remove) user to (from) every role in addRoleList (removeRoleList)
				var userid = iCredentialsEditor.selected.user[0];
				var changeUser = function(i, j)
				{
					if (addRoleList.length > 0 && i < addRoleList.length)
					{
						data.roleid = addRoleList[i];
						data.addList = [];
						data.removeList = null;
						data.addList.push(userid);
						i++;
					} else
					if (removeRoleList.length > 0 && j < removeRoleList.length)
					{
						data.roleid = removeRoleList[j];
						data.addList = null;
						data.removeList = [];
						data.removeList.push(userid);
						j++;
					}
					data.success = data.error = function()
					{
						if ((i > addRoleList.length - 1) && (j > removeRoleList.length - 1))
						{
							$(iCredentialsEditor.id + " .tabs_content").unmask();
							$("#users .objectList option:selected").click();
							//iCredentialsEditor.initType(iCredentialsEditor.currentType, iCredentialsEditor.selected[iCredentialsEditor.currentType]);
						}
						else
							changeUser(i, j);
					};
					iCredentialsEditor.changeSetRole(data);
				};
				changeUser(0, 0);
			break;
			case "role":
				// add (remove) sets, users to (from) role
				var roleid = iCredentialsEditor.selected.role[0];
				data.roleid = roleid;
				data.addList = addRoleList;
				data.removeList = removeRoleList;
				data.success = data.error = function()
				{
					$(iCredentialsEditor.id + " .tabs_content").unmask();
					$("#roles .objectList option:selected").click();
					//iCredentialsEditor.initType(iCredentialsEditor.currentType, iCredentialsEditor.selected[iCredentialsEditor.currentType]);
				};
				iCredentialsEditor.changeSetRole(data);
			break;
			case "set":
				var setid = iCredentialsEditor.selected.set[0];

				// add (remove) devices to (from) set
				if (addSetList.length > 0 || removeSetList.length > 0)
				{
					var dataSet = $.extend({}, data);
					dataSet.setid = setid;
					dataSet.addList = addSetList;
					dataSet.removeList = removeSetList;
					dataSet.success = dataSet.error = function()
					{
						$(iCredentialsEditor.id + " .tabs_content").unmask();
						$("#sets .objectList option:selected").click();
						//iCredentialsEditor.initType(iCredentialsEditor.currentType, iCredentialsEditor.selected[iCredentialsEditor.currentType]);
					};
					iCredentialsEditor.changeSetRole(dataSet);
				}

				// add (remove) set to every role in addRoleList (removeRoleList)
				var changeSet = function(i, j)
				{
					if (addRoleList.length > 0 && i < addRoleList.length)
					{
						data.roleid = addRoleList[i];
						data.addList = [];
						data.removeList = null;
						data.addList.push(setid);
						i++;
					} else
					if (removeRoleList.length > 0 && j < removeRoleList.length)
					{
						data.roleid = removeRoleList[j];
						data.addList = null;
						data.removeList = [];
						data.removeList.push(setid);
						j++;
					}
					data.success = data.error = function()
					{
						if ((i > addRoleList.length - 1) && (j > removeRoleList.length - 1))
						{
							$(iCredentialsEditor.id + " .tabs_content").unmask();
							$("#sets .objectList option:selected").click();
							//iCredentialsEditor.initType(iCredentialsEditor.currentType, iCredentialsEditor.selected[iCredentialsEditor.currentType]);
						}
						else
							changeSet(i, j);
					};
					iCredentialsEditor.changeSetRole(data);
				};
				changeSet(0, 0);
			break;
		}
	},
	changeSetRole: function(params)
	{
		if (!params)
		{
			return;
		}

		params.roleid = params.roleid || null;
		params.setid = params.setid || null;
		params.addList = params.addList || null;
		params.removeList = params.removeList || null;
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		if ((!params.roleid && !params.setid) || (!params.addList && !params.removeList))
		{
			return;
		}

		var data = {
			parentobj: (params.roleid || params.setid)
		};

		if (params.addList) data.addList = JSON.stringify(params.addList);
		if (params.removeList) data.removeList = JSON.stringify(params.removeList);

		if ($.isFunction(params.beforeSend))
		{
			params.beforeSend();
		}
		var api = new API();
		api.changeObjectList(data)
			.fail(function(code, message){
				Log.error(message);
				if ($.isFunction(params.error))
				{
					params.error();
				}
			})
			.done(function(response){
				response.list = response.list || [];

				if ($.isFunction(params.success))
				{
					params.success();
				}
			});
	},
	saveSpecialCredentials: function(params)
	{
		params.credentials = params.credentials || "";
		params.roleid = params.roleid || null;
		params.setid = params.setid || null;
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		// save set2role credentials
		if (!params.setid || !params.roleid)
		{
			if ($.isFunction(params.success))
			{
				params.success();
			}
			return;
		}

		if ($.isFunction(params.beforeSend))
		{
			params.beforeSend();
		}
		var api = new API();
		api.setSpecialCredentials({
			setid: params.setid,
			roleid: params.roleid,
			credentials: params.credentials
		})
			.fail(function(code, message){
				Log.error(message);
				if ($.isFunction(params.error))
				{
					params.error();
				}
			})
			.done(function(response){
				if ($.isFunction(params.success))
				{
					params.success();
				}
			});
	},
	savePermission: function(params)
	{
		params.permission = params.permission || null;
		params.roleid = params.roleid || null;
		params.setid = params.setid || null;
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		// save set2role permission
		if (!params.setid || !params.roleid || !params.permission || (iCredentialsEditor.list.was.set2role[params.setid] && (params.permission == iCredentialsEditor.list.was.set2role[params.setid].permission)))
		{
			if ($.isFunction(params.success))
			{
				params.success();
			}
			return;
		}

		if ($.isFunction(params.beforeSend))
		{
			params.beforeSend();
		}
		var api = new API();
		api.setPermission({
			setid: params.setid,
			roleid: params.roleid,
			permission: params.permission
		})
			.fail(function(code, message){
				Log.error(message);
				if ($.isFunction(params.error))
				{
					params.error();
				}
			})
			.done(function(response){
				if ($.isFunction(params.success))
				{
					params.success();
				}
			});
	},
	getPermissionTypeList: function(params)
	{
		params.beforeSend = params.beforeSend || null;
		params.error = params.error || null;
		params.success = params.success || null;

		if ($.isFunction(params.beforeSend))
		{
			params.beforeSend();
		}
		var api = new API();
		api.getPermissionTypeList()
			.fail(function(code, error){
				Log.error(error);
				if ($.isFunction(params.error))
				{
					params.error();
				}
			})
			.done(function(response){
				response.type = response.type || {};
				if ($.isFunction(params.success))
				{
					params.success(response.type);
				}
			});
	},
	fillPermissionTypeList: function(params)
	{
		params.id = params.id || null;
		params.callback = params.callback || null;

		if (!params.id || !($(params.id).length > 0))
			return;

		iCredentialsEditor.getPermissionTypeList({
			success: function(json)
			{
				var htmlList = [];
				htmlList.push('<select>');
				for (var type in json)
				{
					htmlList.push('<option value="' + type + '">' + json[type].description + '</option>');
				}
				htmlList.push('</select>');

				$(params.id).html(htmlList.join(''));

				if ($.isFunction(params.callback))
				{
					params.callback();
				}
			}
		});
	},
	createEditor: function(params)
	{
		params.obj = params.obj || null;
		params.id = params.id || null;
		params.type = params.type || null;
		params.buttons = params.buttons || null;

		if (params.id && params.type)
		{
			$("#editor").show();
			iCredentialsEditor.editor = new Editor({
				obj: params.obj,
				id: params.id,
				type: params.type,
				notReload: true
			});

			if (params.buttons)
				iCredentialsEditor.editor.setButtons(params.buttons);

			iCredentialsEditor.editor.init();
		}
	},
	destroyEditor: function()
	{
		if (iCredentialsEditor.editor)
		{
			iCredentialsEditor.editor.destroy();
			iCredentialsEditor.editor = null;
			$("#editor").hide();
		}
	},
	/**
	 * disable elements if no credentials
	 */
	checkCredentials: function()
	{
		var checkList = {
			"user": !window.scUsers && !window.scAccess,
			"role": !window.scAccess,
			"set": !window.scAccess
		};
		var isDisabled = typeof checkList[iCredentialsEditor.currentType] != "undefined" ? checkList[iCredentialsEditor.currentType] : false;

		if (isDisabled
		    && $("#credentialManager").find("input:enabled, button:enabled, textarea:enabled, select:enabled").length > 0)
		{
			$("#credentialManager")
				.find("input, button, textarea, select")
				.prop("disabled", true);
		}

		// TODO: WTF IS THIS? REMOVE THIS!
		setTimeout(function(){
			iCredentialsEditor.checkCredentials();
		}, 333);
	}
};

// for translate
var a = __("Admin Role");
var a = __("Manager Role");
var a = __("Operator Role");
var a = __("Viewer Role");

return iCredentialsEditor;
});
