/*
# $Id: object_script.js 18912 2010-07-02 16:25:18Z tsibulskiy $
#------------------------------------------------------------------------------
# Object editor
#------------------------------------------------------------------------------
# Author: Serge Tsybulsky
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

	$(document).ready(
		function()
		{
			init();
			addEvents();
		}
	);

	function init()
	{

		var data = {'function': 'getCertificateFullInfo'};

		$.ajax({
			type: "GET",
			url: "/api/call.php",
			data: data,
			dataType: "json",
			cache: false,
			async: false,
			beforeSend: function(XMLHttpRequest)
			{
				$("#certificate_content").mask();
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				$("#certificate_content").unmask();
			},
			success: function(json)
			{
				$("#certificate_content").unmask();
				if (json.error == "")
				{
					if (json.requestexists) {
						$("#SHOW_REQUEST").show();

						$("#certificate_request_field").val('');
						//requestinfo fill json.requestinfo
					}
					else {
						$("#SHOW_REQUEST").hide();
						//requestinfo clear
						$("#certificate_request_field").val('');
					}

					if (json.certificatevalid) {
						$("#nocertificate").hide();
						$("#iscertificate").show();
						//certificate_info_field fill json.certificateinfo
						$("#certificate_info_field").val('');
						if (json.certificateinfo != "")
						{
							var str = '';
							for(var i=0; i<json.certificateinfo.length; i++)
								str += json.certificateinfo[i] + '<br>';
							$("#certificate_info_field").html(str);
						}
					}else{
						$("#iscertificate").hide();
						//certificate_info_field clear
						$("#certificate_info_field").val('');
						$("#nocertificate").show();
					}
					$("#certificatemanage").show();
					$("#registration").hide();
					$("#certificate_install").hide();
					$("#request_info").hide();
				}else{
					alert (json.error);
				}
			}
		});



	}

	function addEvents()
	{
		$("#SHOW_REGISTRATION").click(
			function()
			{
				$("#registration").show();
				$("#certificatemanage").hide();
				$("#certificate_install").hide();
				$("#request_info").hide();
			}
		);
		$("#SHOW_CERTIFICATE_INPUT").click(
			function()
			{
				$("#certificate_install").show();
				$("#registration").hide();
				$("#certificatemanage").hide();
				$("#request_info").hide();
			}
		);

		$("#REQUEST_CONFIRM").click(
			function()
			{
				if ($("#user_domain_field").val() == '' ||
						$("#user_state_or_province_field").val() == '' ||
						$("#user_country_field").val() == '' ||
						$("#user_email_field").val() == '' ||
						$("#user_organization_field").val() == '' ||
						$("#user_localityName_field").val() == ''
					){
					alert(__("All fields are mandatory!"));
					return;
				}
				var email_val = $("#user_email_field").val();
				reg = /[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
				if (!email_val.match(reg)){
					alert(__("Incorrect e-mail address!"));
					return;
				}

				var user_domain_field = $("#user_domain_field").val();
				var user_state_or_province_field = $("#user_state_or_province_field").val();
				var user_country_field = $("#user_country_field").val();
				var user_email_field = $("#user_email_field").val();
				var user_organization_field = $("#user_organization_field").val();
				var user_localityName_field = $("#user_localityName_field").val();
				var user_organizationalUnitName_field = $("#user_organizationalUnitName_field").val();
				var requestParameters = {};
				requestParameters['domain'] = user_domain_field;
				requestParameters['state_or_province'] = user_state_or_province_field;
				requestParameters['country'] = user_country_field;
				requestParameters['email'] = user_email_field;
				requestParameters['organization'] = user_organization_field;
				requestParameters['localityName'] = user_localityName_field;
				requestParameters['organizationalUnitName'] = user_organizationalUnitName_field;

				var data = {'function': 'createCertificateRequest', 'requestParameters': JSON.stringify(requestParameters)};

				$.ajax({
					type: "POST",
					url: "/api/call.php",
					data: data,
					dataType: "json",
					cache: false,
					async: false,
					beforeSend: function(XMLHttpRequest)
					{
						$("#certificate_content").mask();
					},
					error: function(XMLHttpRequest, textStatus, errorThrown)
					{
						$("#certificate_content").unmask();
					},
					success: function(json)
					{
						$("#certificate_content").unmask();
						if (json.error == "")
						{
							if (json.request.request != "")
							{
								$("#certificate_request_field").val('');
								var request_str = '';
								for(var i=0; i<json.request.length; i++)
									request_str += json.request[i];
								$("#certificate_request_field").val(request_str);

								$("#request_info").show();
									$("#certificate_request").show();
								$("#certificate_install").hide();
								$("#registration").hide();
								$("#certificatemanage").hide();
								$("#OK_BUTTON").show();
								$("input[name='BACK_BUTTON']").hide();
							}else{
								alert (__("Request is empty."));
							}
						}else{
							alert (json.error);
						}
					}
				});
			}
		);

		$("#INSTALL_CERTIFICATE").click(
			function()
			{
				var certificate_txt = $("#certificate_field").val();
				var data = {'function': 'installCertificate', 'certificate': certificate_txt};

				$.ajax({
					type: "POST",
					url: "/api/call.php",
					data: data,
					dataType: "json",
					cache: false,
					async: false,
					beforeSend: function(XMLHttpRequest)
					{
						$("#certificate_install").mask();
					},
					error: function(XMLHttpRequest, textStatus, errorThrown)
					{
						$("#certificate_install").unmask();
					},
					success: function(json)
					{
						$("#certificate_install").unmask();
						if (json.error == "")
						{
							if (json.result)
							{
								Log.info(__("Certificate successfuly installed."));
								init();
							}else{
								alert (__("Error in installing certificate."));
								init();
							}
						}else{
							alert (json.error);
						}
					}
				});
			}
		);

		$("#SHOW_REQUEST").click(
			function()
			{
				var data = {'function': 'getCertificateRequestInfo'};

				$.ajax({
					type: "GET",
					url: "/api/call.php",
					data: data,
					dataType: "json",
					cache: false,
					async: false,
					beforeSend: function(XMLHttpRequest)
					{
						$("#certificate_content").mask();
					},
					error: function(XMLHttpRequest, textStatus, errorThrown)
					{
						$("#certificate_content").unmask();
					},
					success: function(json)
					{
						$("#certificate_content").unmask();
						if (json.error == "")
						{
							if (json.exists && json.info != "")
							{
								$("#certificate_request_field").val('');
								var request_str = '';
								for(var i=0; i<json.info.length; i++)
									request_str += json.info[i];
								$("#certificate_request_field").val(request_str);

								$("#request_info").show();
									$("#certificate_request").show();
								$("#certificate_install").hide();
								$("#registration").hide();
								$("#certificatemanage").hide();
							}else{
								alert (__("Request is empty."));
							}
						}else{
							alert (json.error);
						}
					}
				});
			}
		);

		$("#OK_BUTTON").click(
			function()
			{
				$("#OK_BUTTON").hide();
				$("input[name='BACK_BUTTON']").show();
				init();
			}
		);

		$("input[name='BACK_BUTTON']").click(
			function()
			{
				$("#certificatemanage").show();
				$("#registration").hide();
				$("#certificate_install").hide();
				$("#request_info").hide();
			}
		);


	}
