<?php
/**
 * @version $Id: index.php 33528 2016-01-23 15:26:46Z sabaev $
 * ------------------------------------------------------------------------------
 * Admin GUI
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$user = new User();
if (!$user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "V")){
	FileLog::info(__("Tried to use Admin Panel, but did not have credentials"));
	header($_SERVER["SERVER_PROTOCOL"] . " 403 Forbidden", false, 403);
	print '<link rel="stylesheet" href="/common/css/style.css">';
	print '<body>';
	print '<h2>Error has occurred</h2>';
	print '<pre>Error code 403: Forbidden</pre>';
	print '</body>';
	exit;
}

$master = new Node();
$masterUNI = $master->getUNI();
$nodeList = $master->getList(true);

foreach ($nodeList as $key => $node){
	$nodeid = $node["attributes"]["UNI"];
	$DEADAFTER = 60; // Node is considered to be dead if UNI file isn't updated for a long time
	clearstatcache();
	$stat = stat($_SERVER['APL']."/var/conf/master/nodes/$nodeid");
	$mtime = $stat[9];
	$isDead = time() - $mtime > $DEADAFTER ? true : false;
	$nodeList[$key]["attributes"]["isDead"] = $isDead;
}

// get list of avatar in the system
$avatarList = $master->getObjects(null, "V", "*", true);

$userid = $_SESSION[SESSION_USERID];
$setList = $user->getSets($userid, null, null, false, true);
$title = Identity::getAttribute("NAME");
$SYSTEM_CLASSIFICATION = strtoupper (Identity::getAttribute("SYSTEM_CLASSIFICATION"));
in_array($SYSTEM_CLASSIFICATION, array("CLASSIFIED", "SENSITIVE")) ? $isClassified = true : $isClassified = false;

// Gather "edition" for logo branding
$nodeInfo = Node::getInfo();
$brandName = "STRATUS";
$edition = $nodeInfo['edition'] != "" ? $nodeInfo['edition'] : $brandName;
if($edition == ""){
	$edition = $nodeInfo['brand'];
}
$edition_file = str_replace(' ', '_', $edition);

// load AdminUI configuration
$UICfg = Node::getAdminUIConfig();

// tabs for Identity
$identityGeneral = true;
if(isset($UICfg['Settings.Identity.General.show']) && $UICfg['Settings.Identity.General.show'] == "no"){
	$identityGeneral = false;	 
}
$identityEvents = true;
if(isset($UICfg['Settings.Identity.Events.show']) && $UICfg['Settings.Identity.Events.show'] == "no"){
	$identityEvents = false;	 
}
$identityMapping = true;
if(isset($UICfg['Settings.Identity.Mapping.show']) && $UICfg['Settings.Identity.Mapping.show'] == "no"){
	$identityMapping = false;	 
}
$identityvMX = true;
if(isset($UICfg['Settings.Identity.vMX.show']) && $UICfg['Settings.Identity.vMX.show'] == "no"){
	$identityvMX = false;	 
}
$identityMiscellaneous = true;
if(isset($UICfg['Settings.Identity.Miscellaneous.show']) && $UICfg['Settings.Identity.Miscellaneous.show'] == "no"){
	$identityMiscellaneous = false;	 
}
$identitySession = true;
if(isset($UICfg['Settings.Identity.Session.show']) && $UICfg['Settings.Identity.Session.show'] == "no"){
	$identitySession = false;	 
}
$identityCloud = true;
if(isset($UICfg['Settings.Identity.Cloud.show']) && $UICfg['Settings.Identity.Cloud.show'] == "no"){
	$identityCloud = false;	 
}
$identityLDAP = true;
if(isset($UICfg['Settings.Identity.LDAP.show']) && $UICfg['Settings.Identity.LDAP.show'] == "no"){
	$identityLDAP = false;	 
}

// check special credentials
$scFullDevice = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "F");
$scDeviceSettings = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "f");
$scDevicePolicy = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "R");
$scDeviceAnalytics = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "E");

//add audit record
Audit::addRecordVArg(7, Obj::CONTROL_PANEL, null, 'Control panel');
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ $title . " " . __("Control panel");?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>

	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/global/editor.css" type="text/css"/>
	<link rel="stylesheet" href="/sdi/lib/css/jquery.treeview/jquery.treeview.css" type="text/css" />
	<link rel="stylesheet" href="cred.css" type="text/css" />
	<link rel="stylesheet" href="scheduler.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/lib/css/uidatepicker/jquery.ui.all.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/lib/css/tablesorter/style.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/lib/css/fullcalendar/fullcalendar.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/lib/css/timePicker/timePicker.css" type="text/css" />
	<link rel="stylesheet" href="/sdi/lib/css/jaoselect/style.css" type="text/css"/>
	<link rel="stylesheet" href="/sdi/lib/css/password_editor.css" type="text/css"/>

	<script src="/sdi/lib/js/require.js"></script>
	<script>
		var SYSTEM_CLASSIFICATION = "<?=$SYSTEM_CLASSIFICATION;?>";

		var scFullDevice = <?=$scFullDevice ? "true" : "false";?>;
		var scDeviceSettings = <?=$scDeviceSettings ? "true" : "false";?>;
		var scDevicePolicy = <?=$scDevicePolicy ? "true" : "false";?>;
		var scDeviceAnalytics = <?=$scDeviceAnalytics ? "true" : "false";?>;

		var identityGeneral = <?=$identityGeneral ? "true" : "false";?>;
		var identityEvents = <?=$identityEvents ? "true" : "false";?>;
		var identityMapping = <?=$identityMapping ? "true" : "false";?>;
		var identityvMX = <?=$identityvMX ? "true" : "false";?>;
		var identityMiscellaneous = <?=$identityMiscellaneous ? "true" : "false";?>;
		var identitySession = <?=$identitySession ? "true" : "false";?>;
		var identityCloud = <?=$identityCloud ? "true" : "false";?>;
		var identityLDAP = <?=$identityLDAP ? "true" : "false";?>;

		require(["iadmin"], function(iAdmin){
			"use strict";

			iAdmin.setLicenseKeys(<?=json_encode(Node::getLicenseKeys());?>);
		});
	</script>
</head>
<body>
	<div class="loader"></div>
	<div id="wrapper">
		<?php if ($isClassified): ?>
			<div id="classified_header" class="system_classification"> - <?=__($SYSTEM_CLASSIFICATION);?> - </div>
		<?php endif;?>
		<div id="wrapper_content" <?php if ($isClassified) echo 'class="classified"';?>>
			<div id="header">
			</div><!-- #header-->
			<div id="middle">
				<div id="container">
					<div id="content">
						<div id="list" class="tabs">
							<div class="tabs_menu">
								<div class="single_tab">
									<div class="tab_text">
										<div style='float:left;'>
											<?php if($scFullDevice){ ?>
												<div class="addObject" title="<?=__('Add');?>"></div>
											<?php } ?>
											<div id="viewAsTiles" title="<?=__('Tile');?>"></div>
											<div id="viewAsList" title="<?=__('List');?>"></div>
											<!--Sort by <select id="filterByType">
												<option>Name</option>
												<option>Location</option>
											</select-->
											<div id="setName"></div>
										</div>
										<div style='float:right; margin-right:7px; font-size: 0.8em; font-weight:normal;'><?=__('Filter');?> <input id="filterByMask" type="text" value=""/></div>
									</div>
								</div>
							</div>
							<div class="tabs_content">
								<!--div class="item">
									<div class="image"><img src=""/></div>
									<div class="label">ddd</div>
								</div-->
							</div>
							<div class="tabs_footer"></div>
						</div>
						<div id="credentials">&nbsp;</div>
						<div id="scheduler">&nbsp;</div>
						<div id="session_manager" class="tabs">
							<div class="tabs_menu">
								<div class="single_tab">
									<div class="tab_text">
										<?php print __("Session manager");?>
									</div>
								</div>
							</div>
							<div class="tabs_content">
							</div>
							<div class="tabs_footer"></div>
						</div>
						<iframe id="iframe" src="" frameborder="0" border="0"  width="100%" height="100%"></iframe>
					</div><!-- #content-->
				</div><!-- #container-->

				<div id="sideLeft" class="sidebar">
					<div class="tabs">
						<div class="tabs_menu">
							<div class="single_tab">
								<div class="tab_text"></div>
							</div>
						</div>
						<div class="tabs_content">
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID001_BEGIN -->
							<div class='logo_menu' align='center'><img style="width:auto;height:60px;margin-top:-13px;padding-bottom:5px;" border="0" src="/sdi/global/img/logo_small_cp-<?php print $edition_file ?>.png" title="<?php print $edition ?>"></div>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID001_END -->
							<ul id="navigation" class="filetree treeview-famfamfam treeview">
								<? if(isset($UICfg['User_Sets.show']) && $UICfg['User_Sets.show'] == "yes"){ ?>
								<li><a class="folder"><?=__('User Sets');?></a>
									<ul>
										<?php foreach ($setList as $set): ?>
											<?php /* not show ALL GUI set, and protected sets*/ if ($set["obj"] != 12 && $set["obj"] != 13 && $set["protected"] == 0): ?>
												<li><a class="file2" href="#set_<?=$set["obj"];?>" protected="<?=$set["protected"];?>"><?=$set["name"];?></a></li>
											<?php endif; ?>
										<?php endforeach; ?>
									</ul>
								</li> <? } ?>
								<? if(isset($UICfg['System_Sets.show']) && $UICfg['System_Sets.show'] == "yes"){ ?>
								<li><a class="folder"><?=__('System Sets');?></a>
									<ul>
										<?php foreach ($setList as $set): ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID005_BEGIN -->
											<?php /* not show ALL GUI set, and not protected sets */ /* + 2.7.1 Hide MODBUS functionality*/if ($set["obj"] != 6 && $set["obj"] != 12 && $set["obj"] != 13 && $set["obj"] != 15 && $set["obj"] != 16 && $set["protected"] == 1 && $set["number"] > 0): ?>
												<li><a class="file2" href="#set_<?=$set["obj"];?>" protected="<?=$set["protected"];?>"><?=__($set["name"]);?></a></li>
											<?php endif; ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID005_END -->
										<?php endforeach; ?>
									</ul>
								</li> <? } ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID002_BEGIN -->
								<? if(isset($UICfg['Nodes.show']) && $UICfg['Nodes.show'] == "yes"){ ?>
								<li><a class="folder"><?=__('Nodes');?></a>
									<ul>
									<?php foreach ($nodeList as $node): ?>
										<?php if(isset($node["attributes"]["isDead"]) && ($node["attributes"]["isDead"])): ?>
											<li><a class="redfolder"><?=$node["attributes"]["NODENAME"];?></a>
										<?php else: ?>
											<li><a class="folder"><?=$node["attributes"]["NODENAME"];?></a>
										<?php endif; ?>
											<ul>
												<li><a class="file2" href="#node_content_<?=$node["obj"];?>"><?=__('Node Content');?></a></li>
												<li><a class="file2" href="#nodeinfo_<?=$node["obj"];?>" data-url="/sdi/admin/nodeinfo.php?obj=<?=$node["obj"];?>"><?=__('Node Information');?></a></li>
											</ul>
										</li>
									<?php endforeach; ?>
									</ul>
								</li> <? } ?>
								<?php if (isset($avatarList) && count($avatarList)>0 && isset($UICfg['Avatars.show']) && $UICfg['Avatars.show'] == "yes"): ?>
								<li><a class="folder"><?php echo __('Avatars');?></a>
									<ul>
									<?php foreach ($avatarList as $avatar): ?>
										<li><a class="folder" href="#"><?php echo $avatar["attributes"]["NAME"];?></a>
											<ul>
												<li><a class="file2" href="#avatar_content_<?php echo $avatar["obj"];?>"><?php echo __("Devices");?></a></li>
												<li><a class="file2" href="#avatar_status_<?php echo $avatar["obj"];?>" data-url="/sdi/avatar/panel_2.php?obj=<?php echo $avatar["obj"];?>"><?php echo __("Status panel");?></a></li>
											</ul>
										</li>
									<?php endforeach; ?>
									</ul>
								</li>
								<?php endif; ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID002_END -->
								<? if(isset($UICfg['Settings.show']) && $UICfg['Settings.show'] == "yes"){ ?>
								<li><a class="folder"><?php echo __('Settings');?></a>
									<ul>
										<? if(isset($UICfg['Settings.Identity.show']) && $UICfg['Settings.Identity.show'] == "yes"){ ?>
											<li><a class="file" href="#identity"><?=__('Identity');?></a></li> <? } ?>
										<? if(isset($UICfg['Settings.Session_Manager.show']) && $UICfg['Settings.Session_Manager.show'] == "yes"){ ?>
											<li><a class="file" href="#session_manager"><?=__('Session Manager');?></a></li> <? } ?>
										<? if(isset($UICfg['Settings.Storage_Manager.show']) && $UICfg['Settings.Storage_Manager.show'] == "yes"){ ?>
											<li><a class="file" href="#storage_manager" data-url="/sdi/sm/sm.php"><?=__('Storage Manager');?></a></li> <? } ?>
										<? if(isset($UICfg['Settings.Schedule_Manager.show']) && $UICfg['Settings.Schedule_Manager.show'] == "yes"){ ?>
											<li><a class="file" href="#schedule_manager"><?=__('Schedule Manager');?></a></li> <? } ?>
										<? if(isset($UICfg['Settings.Policies.show']) && $UICfg['Settings.Policies.show'] == "yes"){ ?>
											<li><a class="folder"><?=__('Policies');?></a>
												<ul>
													<? if(isset($UICfg['Settings.Policies.Storage_Policy.show']) && $UICfg['Settings.Policies.Storage_Policy.show'] == "yes"){ ?>
														<li><a class="file" href="#storagepolicy" data-url="/sdi/storagepolicy/"><?=__('Storage Policy');?></a></li> <? } ?>
													<? if(isset($UICfg['Settings.Policies.Event_Policy.show']) && $UICfg['Settings.Policies.Event_Policy.show'] == "yes"){ ?>
														<li><a class="file" href="#eventpolicy" data-url="/sdi/eventpolicy/"><?=__('Event Policy');?></a></li> <? } ?>
												</ul>
											</li> <? } ?>
										<? if(isset($UICfg['Settings.Credentials.show']) && $UICfg['Settings.Credentials.show'] == "yes"){ ?>
											<li><a class="folder"><?=__('Credentials');?></a>
												<ul>
													<? if(isset($UICfg['Settings.Credentials.User_Manager.show']) && $UICfg['Settings.Credentials.User_Manager.show'] == "yes"){ ?>
														<li><a class="file" href="#user_manager"><?=__('User Manager');?></a></li> <? } ?>
													<? if(isset($UICfg['Settings.Credentials.Role_Manager.show']) && $UICfg['Settings.Credentials.Role_Manager.show'] == "yes"){ ?>
														<li><a class="file" href="#role_manager"><?=__('Role Manager');?></a></li> <? } ?>
													<? if(isset($UICfg['Settings.Credentials.Set_Manager.show']) && $UICfg['Settings.Credentials.Set_Manager.show'] == "yes"){ ?>
														<li><a class="file" href="#set_manager"><?=__('Set Manager');?></a></li> <? } ?>
												</ul>
											</li> <? } ?>
										<? if(isset($UICfg['Settings.CustomizeSystem.show']) && $UICfg['Settings.CustomizeSystem.show'] == "yes"){ ?>
											<li><a class="folder"><?=__('Customize System');?></a>
												<ul>
													<? if(isset($UICfg['Settings.CustomizeSystem.Workflow.show']) && $UICfg['Settings.CustomizeSystem.Workflow.show'] == "yes"){ ?>
													<li><a class="file" href="#workflow" data-url="/sdi/workflow/"><?=__('Workflow');?></a></li> <? } ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID004_BEGIN -->
												<? if(isset($UICfg['Settings.CustomizeSystem.Maps.show']) && $UICfg['Settings.CustomizeSystem.Maps.show'] == "yes"){ ?>
													<!--<li><a class="file" href="#map3d" data-url="/sdi/ge/ge_config_models.php"><?=__('Maps');?></a></li>-->
												<? } ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID004_END -->
												<? if(isset($UICfg['Settings.CustomizeSystem.Joystick.show']) && $UICfg['Settings.CustomizeSystem.Joystick.show'] == "yes"){ ?>
													<li><a class="file" href="#joystick" data-url="/ptz/hwjCalibrator.php"><?=__('Joystick');?></a></li> <? } ?>
												<? if(isset($UICfg['Settings.CustomizeSystem.Emailer.show']) && $UICfg['Settings.CustomizeSystem.Emailer.show'] == "yes"){ ?>
													<li><a class="file" href="#e_mail" data-url="/sdi/admin/emailer_cfg.php"><?=__('Email Configuration');?></a></li> <? } ?>
												<? if(isset($UICfg['Settings.CustomizeSystem.Digital_Signature.show']) && $UICfg['Settings.CustomizeSystem.Digital_Signature.show'] == "yes"){ ?>
													<li><a class="file" href="#certificate" data-url="/sdi/admin/certificate.php"><?=__('Digital Signature');?></a></li> <? } ?>
											</ul>
										</li> <? } ?>
									</ul>
								</li> <? } ?>
								<? if(isset($UICfg['Maintenance.show']) && $UICfg['Maintenance.show'] == "yes"){ ?>
								<li><a class="folder"><?=__('Maintenance');?></a>
									<ul>
										<? if(isset($UICfg['Maintenance.Backups.show']) && $UICfg['Maintenance.Backups.show'] == "yes"){ ?>
											<li><a class="file" href="#backupmanager" data-url="/sdi/backupmanager/index.php"><?=__('Configuration Backups');?></a></li> <? } ?>
										<? if(isset($UICfg['Maintenance.Support.show']) && $UICfg['Maintenance.Support.show'] == "yes"){ ?>
											<li><a class="file" href="#support" data-url="/sdi/support/index.php"><?=__('Support Files');?></a></li> <? } ?>
										<? if(isset($UICfg['Maintenance.Audit.show']) && $UICfg['Maintenance.Audit.show'] == "yes"){ ?>
											<li><a class="file" href="#audit_log" data-url="/sdi/audit/audit_general.php"><?=__('Audit Log');?></a></li> <? } ?>
										<? if(isset($UICfg['Maintenance.Upload_Video.show']) && $UICfg['Maintenance.Upload_Video.show'] == "yes"){ ?>
											<li><a class="file" href="#upload_video" data-url="/sdi/admin/upload_video.php"><?=__('Upload video');?></a></li> <? } ?>
									</ul>
								</li> <? } ?>
								<? if(isset($UICfg['General.show']) && $UICfg['General.show'] == "yes"){ ?>
								<li><a class="folder"><?=__('General');?></a>
									<ul>
										<? if(isset($UICfg['General.Quick_Start.show']) && $UICfg['General.Quick_Start.show'] == "yes"){ ?>
											<li><a class="file" href="#quickstart" data-url="/sdi/admin/quickstart.php"><?=__('Quick Start');?></a></li> <? } ?>
										<? if(isset($UICfg['General.About.show']) && $UICfg['General.About.show'] == "yes"){ ?>
											<li><a class="file" href="#about" data-url="/sdi/about/aboutmaster.php"><?=__('About');?></a></li> <? } ?>
										<? if(isset($UICfg['General.Licensing.show']) && $UICfg['General.Licensing.show'] == "yes"){ ?>
											<li><a class="file" href="#licensing" data-url="/sdi/admincirrus/index.php?mode=licensing"><?=__('Licensing');?></a></li> <? } ?>
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID003_BEGIN -->
<!-- CLARE_REPLACE_ADMIN_INDEX_PHP_ID003_END -->
									</ul>
								</li> <? } ?>
								<? if(isset($UICfg['MatrixGUI.show']) && $UICfg['MatrixGUI.show'] == "yes"){ ?>
									<li><a class="file" href="#matrix" data-url="/TibcoGI/JSXAPPS/mx/mx.php"><?=__('Matrix');?></a></li> <? } ?>
								<li><a class="file" href="#logout" data-url="/sdi/login/logout.php?token=<?=SessionManager::getCSRFToken();?>"><?=__('Logout');?></a></li>
							</ul>
						</div>
						<div class="tabs_footer"></div>
					</div>
				</div><!-- .sidebar.sl -->
			</div><!-- #middle-->
		</div><!-- #wrapper_content -->
	</div><!-- #wrapper -->
	<div id="footer" <?php if ($isClassified) echo 'class="classified"';?>>
		<div class="copyright">
			<?php include $_SERVER['APL'] . '/sdi/html/global/copyright.php';?>
		</div>
		<?php if ($isClassified): ?>
			<div id="classified_footer" class="system_classification"> - <?=__($SYSTEM_CLASSIFICATION);?> - </div>
		<?php endif;?>
	</div><!-- #footer -->
	<div id='loading_progress' class="loading_dark" style="display:none; height:40px; position: absolute; visibility: visible; top: 63px; left: 275px;"></div>
	<div id="maskdiv"></div>
</body>
</html>

<?php
/* It is need to tranlate system sets*/
$a = __("ACSG Sensors");
$a = __("All Areas");
$a = __("All Audio");
$a = __("All Cameras");
$a = __("All Doors");
$a = __("All External devices");
$a = __("All Gateways");
$a = __("All Monitors");
$a = __("All Perimeters");
$a = __("All Relays");
$a = __("All Walls");
$a = __("Sensors");
$a = __("All 3D models");
$a = __("All layer models");
$a = __("Access Control Sensors");
 /* EOF for translate */
?>
