<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

error_reporting(0);
$action = (isset($_POST['action'])) ? __("Apply") : __("Cancel");

$EMAIL_POLICY = array();
$EMAIL_POLICY['code'] = array("Label" => __("Log level"), "Width" => 60);
$EMAIL_POLICY['time'] = array("Label" => __("Period "), "Width" => 120);
$EMAIL_POLICY['emails'] = array("Label" => __("E-mail addresses"), "Width" => 350);

$result = Array();
$config = Array();
if ($action === __("Apply"))
{
	$isDataSaved = SaveData();
	$tab_policy_cur = "current_tab";
	$tab_config_cur = "tab_inactive";
	if (isset($_POST['CURRENT_TAB']) && $_POST['CURRENT_TAB'] == "tab_config"){
		$tab_policy_cur = "tab_inactive";
		$tab_config_cur = "current_tab";
	}
}

$syst = GetData();

function GetData($type = '')
{
	$configXML = file_get_contents("http://s_master/api/cgi-bin/dynadata.cgi?return=datablock&typeid=Emailer");
	//XML_Data_Spamer.xml");
	$parser = xml_parser_create();
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	xml_parse_into_struct($parser, $configXML, $values, $tags);
	xml_parser_free($parser);
	unset($tags);
	unset($configXML);

	global $result, $config;
	$id = 0;
	foreach ($values as $el)
	{
		if ($el['tag'] == 'POLICY' && $el['type'] == 'open' && $el['level'] == 5)
		{
			$id = $el['attributes']['LEVEL'];
			$result[$id]['CODE'] = $el['attributes']['CODE'];
		}
		elseif ($el['tag'] == 'POLICY' && $el['type'] == 'close' && $el['level'] == 5)
		{
			$id = 0;
		}
		elseif ($el['level'] == 6 && isset($el['attributes']))
		{
			$result[$id][$el['tag']] = urldecode($el['attributes']['VALUE']);
		}
		elseif ($el['tag'] == 'CONFIG' && $el['type'] == 'complete' && $el['level'] == 5)
		{
			$config['SERVER'] = urldecode($el['attributes']['SERVER']);
			$config['EMAIL'] = urldecode($el['attributes']['EMAIL']);
			$config['USER'] = urldecode($el['attributes']['USER']);
			$config['PASSWORD'] = urldecode($el['attributes']['PASSWORD']);
			$config['STATUS'] = urldecode($el['attributes']['STATUS']);
			$config['EVENTS_DETAILS_ENABLE'] = urldecode($el['attributes']['EVENTS_DETAILS_ENABLE']);
			$config['EVENTS_DETAILS_AMOUNT'] = urldecode($el['attributes']['EVENTS_DETAILS_AMOUNT']);

			if (isset($el['attributes']['PORT'])) {$config['PORT'] = urldecode($el['attributes']['PORT']);}
			else $config['PORT'] = 25;
			if (isset($el['attributes']['SECURE'])) {$config['SECURE'] = urldecode($el['attributes']['SECURE']);}
		}
	}
	
	return $result;
}

function SaveData()
{
	$xmlData = '<RESULT>';
	$xmlData .= '<POLICY LEVEL="INFO" CODE="2">';
	$xmlData .= (isset($_POST['INFO'])) ? convertTime($_POST['INFO'], $_POST['TIME_INFO']) : "<TIME VALUE=\"NONE\"/>";
	$xmlData .= "<EMAILS VALUE=\"" . urlencode(trim($_POST['EMAILS_INFO'])) . "\"/></POLICY>\n";
	$xmlData .= '<POLICY LEVEL="WARN" CODE="3">';
	$xmlData .= (isset($_POST['WARN'])) ? convertTime($_POST['WARN'], $_POST['TIME_WARN']) : "<TIME VALUE=\"NONE\"/>";
	$xmlData .= "<EMAILS VALUE=\"" . urlencode(trim($_POST['EMAILS_WARN'])) . "\"/></POLICY>\n";
	$xmlData .= '<POLICY LEVEL="ERROR" CODE="4">';
	$xmlData .= (isset($_POST['ERROR'])) ? convertTime($_POST['ERROR'], $_POST['TIME_ERROR']) : "<TIME VALUE=\"NONE\"/>";
	$xmlData .= "<EMAILS VALUE=\"" . urlencode(trim($_POST['EMAILS_ERROR'])) . "\"/></POLICY>\n";
	$xmlData .= '<POLICY LEVEL="FATAL" CODE="5">';
	$xmlData .= (isset($_POST['FATAL'])) ? convertTime($_POST['FATAL'], $_POST['TIME_FATAL']) : "<TIME VALUE=\"NONE\"/>";
	$xmlData .= "<EMAILS VALUE=\"" . urlencode(trim($_POST['EMAILS_FATAL'])) . "\"/></POLICY>\n";
	$xmlData .= "<CONFIG SERVER=\"" . urlencode(trim($_POST['CONF_SERVER'])) . "\" EMAIL=\"" . urlencode(trim($_POST['CONF_EMAIL'])) .
			"\" SECURE=\"" . urlencode(trim($_POST['SECURE'])) . "\" PORT=\"" . urlencode(trim($_POST['PORT'])) .
			"\" USER=\"" . urlencode(trim($_POST['CONF_USER'])) . "\" PASSWORD=\"" . urlencode($_POST['CONF_PASSWORD']) .
			"\" EVENTS_DETAILS_ENABLE=\"" . $_POST['EVENTS_DETAILS_ENABLE'] .
			"\" EVENTS_DETAILS_AMOUNT=\"" . $_POST['EVENTS_DETAILS_AMOUNT'] .
			"\" STATUS=\"" . $_POST['CONF_STATUS'] . "\"/>";
	$xmlData .= '</RESULT>';
	$xmlData = urlencode($xmlData);
	//looking for blockid to save config
	$configXML = file_get_contents("http://s_master/api/cgi-bin/dynadata.cgi?return=blockids&TYPEID=Emailer");
	$parser = xml_parser_create();
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	xml_parse_into_struct($parser, $configXML, $values, $tags);
	xml_parser_free($parser);
	unset($tags);
	unset($configXML);
	$id = 0;
	foreach ($values as $el)
	{
		if ($el['tag'] == 'DATABLOCK' && $el['type'] == 'complete' && $el['level'] == 2)
		{
			$id = $el['attributes']['BLOCKID'];
		}
	}

	if ($id > 0)
	{
		$configXML = file_get_contents("http://s_master/api/cgi-bin/dynadata.cgi?modify=datablock&TYPEID=Emailer&data=$xmlData&blockid=" . $id);
	}
	else
	{
		$configXML = file_get_contents("http://s_master/api/cgi-bin/dynadata.cgi?modify=datablock&TYPEID=Emailer&data=$xmlData&blockid=new");
	}
	
	if($configXML === FALSE){
		return false;
	}
	else {
		return true;
	}
}

function convertTime($data, $time)
{
	switch ($time)
	{
		case 'min':
			$data = $data * 60;
			break;
		case 'hour':
			$data = $data * 3600;
			break;
		case 'day':
			$data = $data * 86400;
			break;
		default:
			$data = 'NONE';
			break;
	}
	$xml = "<TIME VALUE=\"$data\"/>";
	return $xml;
}

function timeEdit($td, $level)
{
	global $action;
	switch ($td)
	{
		case ($td < 60):
			$td = 0;
			$tperiod = 'min';
			break;
		case ($td < 3600 and $td >= 60):
			$td = $td / 60;
			$tperiod = 'min';
			break;
		case ($td < 86400 and $td >= 3600):
			$td = $td / 3600;
			$tperiod = 'hour';
			break;
		case ($td >= 86400):
			$td = $td / 86400;
			$tperiod = 'day';
			break;
		default:
			$td = 0;
			$tperiod = 'min';
			break;
	}
	$html_out = $td;
	$html_out = "<input class=\"textfield\" size=\"3\" name=\"" . $level . "\" type=text value=\"" . $td . "\">\n";
	$html_out .= "</td><td align=\"left\" style=\"width:60px\"><select name=\"TIME_" . $level . "\" class=\"textfield\">\n"; //dropmenu
	$html_out .= ($tperiod == 'min') ? "\t<option value=\"min\" selected>" . __("min") ."</option>\n" : "\t<option value=\"min\" >" . __("min") ."</option>\n";
	$html_out .= ($tperiod == 'hour') ? "\t<option value=\"hour\" selected>" . __("hour") ."</option>\n" : "\t<option value=\"hour\" >" . __("hour") ."</option>\n";
	$html_out .= ($tperiod == 'day') ? "\t<option value=\"day\" selected>" . __("day") ."</option>\n" : "\t<option value=\"day\" >" . __("day") ."</option>\n";
	$html_out .= "</select>\n";
	return $html_out;
}

?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Email Configuration');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/global/editor.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="/sdi/lib/js/log.js"></script>
	
    <script>
		$(document).ready(function(){
			init();
		});
		
		function Passw()
		{
			var firstPwd = document.getElementById("CONF_PASSWORD").value;
			var secondPwd = prompt(__("Enter password again"), "");
			if (firstPwd == secondPwd)
			{
				document.getElementById("MY_FORM").submit();
			} else
			{
				alert(__("PASSWORD DOESN'T MATCH!"));
			}
		}

		function init()
		{
			$("#cancelObject").prop("disabled", true);
			$("#saveObject").prop("disabled", true);

			$("#tabs_menu .tab_inactive, #tabs_menu .current_tab").click(function(){
				$("#tabs_menu .current_tab").removeAttr("id")
						.removeClass("current_tab")
						.addClass("tab_inactive");

				$(this).attr("id", "current_tab")
						.removeClass("tab_inactive")
						.addClass("current_tab");

				if ($("#tabs_menu .current_tab").attr("name") == "tab_policy")
				{
					$("#tab_content_Policy").show();
					$("#tab_content_Config").hide();
					//$("#CURRENT_TAB_VAL").val("tab_policy");
				}
				else
				{
					$("#tab_content_Policy").hide();
					$("#tab_content_Config").show();
					//$("#CURRENT_TAB_VAL").val("tab_config");
				}
			});

			$("#tabs_content").delegate("input, select", "change keyup", function(){
				$("#cancelObject").prop("disabled", false);
				$("#saveObject").prop("disabled", false);
			});


			if ($("#tabs_menu .current_tab").attr("name") == "tab_policy")
			{
				$("#tab_content_Policy").show();
				$("#tab_content_Config").hide();
				//$("#CURRENT_TAB_VAL").val("tab_policy");
			}
			else
			{
				$("#tab_content_Policy").hide();
				$("#tab_content_Config").show();
				//$("#CURRENT_TAB_VAL").val("tab_config");
			}

			<?php
				// show save result message
				if(isset($isDataSaved)){
					if($isDataSaved){
						?>
						Log.info(__("Configuration successfully saved."));
						<?php
					}
					else{
						?>
						Log.error(__("Configuration save error."));
						<?php
					}
				}
			?>
		}
    </script>
</head>

<body>
	<form id="MY_FORM" method="POST" action="emailer_cfg.php">

		<div class="main_container" style="width:750px;">
			<div class="tabs">

				<div class="tabs_menu_header"><?=__('Email Configuration');?></div>

				<div id="tabs_menu" class="tabs_menu">
					<!--div name="tab_policy" class="<?=isset($tab_policy_cur)?$tab_policy_cur:"current_tab"?>" style="width: 50%;">
						<div class="tab_text"><?php echo __('Policy');?>
						</div>
					</div-->
					<div name="tab_config" class="<?=isset($tab_config_cur)?$tab_config_cur:"current_tab"?>" style="width: 100%;">
						<div class="tab_text"><?php echo __('Config');?>
						</div>
					</div>
				</div>

				<div class="tabs_content">
					<div class="tabs_form" id="tabs_content" style="width: 100%;">
						<!-- TEMPORARY DELETED only for 3.3.2, must be revert on 3.5 -->
						<!--div id="tab_content_Policy" class="tab_content">
							<table>
								<tr>
									<td align="center" style="width:80px"><?=__($EMAIL_POLICY['code']['Label'])?></td>
									<td style="width:60px"><?//=__($EMAIL_POLICY['time']['Label'])?></td>
									<td style="width:60px"><?php echo __('Granularity');?></td>
									<td align="left"><?//=__($EMAIL_POLICY['emails']['Label'])?></td>
								</tr>
								<tr>
									<td align="center" style="width:80px"><?php echo __('INFO');?></td>
									<td style="width:60px"><?//=timeEdit($result['INFO']['TIME'], 'INFO')?></td>
									<td align="left">
										<input class="textfield" style="width:350px" name="EMAILS_INFO" size="<?=$EMAIL_POLICY['emails']['Width'] / 7?>" type=text value="<?=$result['INFO']['EMAILS']?>">
									</td>
								</tr>
								<tr>
									<td align="center" style="width:80px"><?php echo __('WARN');?></td>
									<td style="width:60px"><?//=timeEdit($result['WARN']['TIME'], 'WARN')?></td>
									<td align="left">
										<input class="textfield" style="width:350px" name="EMAILS_WARN" size="<?=$EMAIL_POLICY['emails']['Width'] / 7?>" type=text value="<?=$result['WARN']['EMAILS']?>">
									</td>
								</tr>
								<tr>
									<td align="center" style="width:80px"><?php echo __('ERROR');?></td>
									<td style="width:60px"><?//=timeEdit($result['ERROR']['TIME'], 'ERROR')?></td>
									<td align="left">
										<input class="textfield" style="width:350px" name="EMAILS_ERROR" size="<?=$EMAIL_POLICY['emails']['Width'] / 7?>" type=text value="<?=$result['ERROR']['EMAILS']?>">
									</td>
								</tr>
								<tr>
									<td align="center" style="width:80px"><?php echo __('FATAL');?></td>
									<td style="width:60px"><?//=timeEdit($result['FATAL']['TIME'], 'FATAL')?></td>
									<td align="left">
										<input class="textfield" style="width:350px" name="EMAILS_FATAL" size="<?=$EMAIL_POLICY['emails']['Width'] / 7?>" type=text value="<?=$result['FATAL']['EMAILS']?>">
									</td>
								</tr>
							</table>
						</div-->
						<!-- EOF TEMPORARY DELETE -->

						<div id="tab_content_Config" class="tab_content" >
							<table>
								<tr>
									<td align="right"><?php echo __('Send from Email');?></td>
									<td align="left">
									<?
									$inpSize = $ColumnNames[$fieldname]["Width"] / 7;
									echo "<input class=\"textfield\" style=\"width:350px\" name= \"CONF_EMAIL\" size=\"50\" type=text value=\"" . $config['EMAIL'] . "\">";
									?>
									</td>
								</tr>
								<tr>
									<td align="right"><?php echo __('SMTP Server');?></td>
									<td align="left">
									<?
									$inpSize = $ColumnNames[$fieldname]["Width"] / 7;
									echo "<input class=\"textfield\" style=\"width:350px\" name= \"CONF_SERVER\" size=\"50\" type=text value=\"" . $config['SERVER'] . "\">";
									?>
									</td>

								</tr>


								<tr>
									<td align="right"><?php echo __('Security');?></td>
									<td align="left">
									<select name="SECURE" class="dropmenu" style="width:350px">
									<?
										if (!isset($config['SECURE']) || isset($config['SECURE']) && ($config['SECURE'] == 'none' || $config['SECURE'] == ''))
										{
											echo "\t<option value=\"\" selected>" . __('None') . "</option>\n";
										}
										else
										{
											echo "\t<option value=\"\" >" . __('None') . "</option>\n";
										}
										if ($config['SECURE'] == 'ssl')
										{
											echo "\t<option value=\"ssl\" selected>" . __('SSL') . "</option>\n";
										}
										else
										{
											echo "\t<option value=\"ssl\" >" . __('SSL') . "</option>\n";
										}
										if ($config['SECURE'] == 'tls')
										{
											echo "\t<option value=\"tls\" selected>" . __('TLS') . "</option>\n";
										}
										else
										{
											echo "\t<option value=\"tls\" >" . __('TLS') . "</option>\n";
									}
									?>
									</select>
									</td>

								</tr>
								<tr>
									<td align="right"><?php echo __('Port');?></td>
									<td align="left">
									<?
									$inpSize = $ColumnNames[$fieldname]["Width"] / 7;
									echo "<input class=\"textfield\" style=\"width:350px\" name= \"PORT\" size=\"50\" type=text value=\"" . $config['PORT'] . "\">";
									?>
									</td>

								</tr>

								<tr>
									<td align="right"><?php echo __('SMTP Server User');?></td>
									<td align="left">
									<?
									$inpSize = $ColumnNames[$fieldname]["Width"] / 7;
									echo "<input class=\"textfield\" style=\"width:350px\" name= \"CONF_USER\" size=\"50\" type=text value=\"" . $config['USER'] . "\">";
									?>
									</td>
								</tr>
								<tr>
									<td align="right"><?php echo __('SMTP Server Password');?></td>
									<td align="left">
									<?
									$inpSize = $ColumnNames[$fieldname]["Width"] / 7;
									echo "<input class=\"password\" style=\"width:350px\" id = \"CONF_PASSWORD\" name= \"CONF_PASSWORD\" size=\"50\" type=password autocomplete=\"off\" value=\"" . (isset($config['PASSWORD']) ? $config['PASSWORD'] : '') . "\">";
									?>
									</td>
								</tr>
								<!-- TEMPORARY INSERTED only for 3.3.2, must be revert on 3.5 -->
								<tr>
									<td align="right" ><?php echo __('Send to email');?></td>
									<td align="left">
										<input class="textfield" style="width:350px" name="EMAILS_INFO" size="<?=$EMAIL_POLICY['emails']['Width'] / 7?>" type=text value="<?=$result['INFO']['EMAILS']?>">
									</td>
								</tr>

								<tr>
									<td align="right" ><?php echo __('Send to period');?></td>
									<td style="width:60px">
										<table><tr><td>
											<?=timeEdit($result['INFO']['TIME'], 'INFO')?>
										</td></tr></table>
									</td>
								</tr>
								<!-- EOF TEMPORARY INSERT -->





								<tr>
									<td align="right"><?php echo __('Run status');?></td>
									<td align="left">

										<select name="CONF_STATUS" class="dropmenu" style="width:350px">
										<?
										if ($config['STATUS'] == 'YES')
										{
											echo "\t<option value=\"YES\" selected>" . __('YES') . "</option>\n";
										}
										else
										{
											echo "\t<option value=\"YES\" >" . __('YES') . "</option>\n";
										}
										if ($config['STATUS'] == 'NO')
										{
											echo "\t<option value=\"NO\" selected>" . __('NO') . "</option>\n";
										}
										else
										{
											echo "\t<option value=\"NO\" >" . __('NO') . "</option>\n";
										}
										?>
										</select>
									</td>
								</tr>
								<tr>
									<td align="right"><?php echo __('Enable event details');?></td>
									<td align="left">
										<select name="EVENTS_DETAILS_ENABLE" class="dropmenu" style="width:350px">
										<?
											$selectedYes = "";
											$selectedNo = "";
											if ($config['EVENTS_DETAILS_ENABLE'] == 'YES'){
												$selectedYes = " selected";
											}
											else{
												$selectedNo = " selected";
											}

											echo "\t<option value=\"YES\"".$selectedYes.">" . __('YES') . "</option>\n\t<option value=\"NO\"".$selectedNo.">" . __('NO') . "</option>\n";
										?>
										</select>
									</td>
								</tr>
								<tr>
									<td align="right"><?php echo __('Detailed events amount');?></td>
									<td align="left">
										<select name="EVENTS_DETAILS_AMOUNT" class="dropmenu" style="width:350px">
										<?
											$detailsAmountValuesHTML = "";
											$detailsAmountValues = array(5, 10, 20);
											for($i = 0; $i < count($detailsAmountValues); $i++){
												if($config['EVENTS_DETAILS_AMOUNT'] == $detailsAmountValues[$i]){
													$setailsAmountSelected = " selected";
												}
												else{
													$setailsAmountSelected = "";
												}
												$detailsAmountValuesHTML.= "\t<option value=\"".$detailsAmountValues[$i]."\"".$setailsAmountSelected.">".$detailsAmountValues[$i]."</option>\n";
											}

											echo $detailsAmountValuesHTML;
										?>
										</select>
									</td>
								</tr>
							</table>
							<!--input class="textfield" name="CURRENT_TAB" id="CURRENT_TAB_VAL" type="hidden" value=""-->
						</div>

					</div>

					<div class="tabs_manage_buttons_wrapper">
						<div class="tabs_manage_buttons">
							<div style="width: 20%; float: left; text-align: right;">
								<input type="submit" value="<?php echo __('Cancel');?>" name="cancel" id="cancelObject">
							</div>
							<div style="width: 20%; float: left;">
								<input type="submit" value="<?php echo __('Apply');?>" name="action" id="saveObject">
							</div>
						</div>
					</div>
				</div>

				<div class="tabs_footer"></div>

			</div>
		</div>

		<input type='hidden' name='tab' id='tab' value=''>
	</form>

</body>
</html>
